/* Reader.c generated by valac 0.56.17, the Vala compiler
 * generated from Reader.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2015 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>

#define PC_CONSTANTS_PAM_CONF_START "## PANTHEON_PARENTAL_CONTROLS_START"
#define PC_CONSTANTS_PAM_CONF_END "## PANTHEON_PARENTAL_CONTROLS_END"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_PAM_TYPE_READER (pc_pam_reader_get_type ())
#define PC_PAM_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_PAM_TYPE_READER, PCPAMReader))
#define PC_PAM_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_PAM_TYPE_READER, PCPAMReaderClass))
#define PC_PAM_IS_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_PAM_TYPE_READER))
#define PC_PAM_IS_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_PAM_TYPE_READER))
#define PC_PAM_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_PAM_TYPE_READER, PCPAMReaderClass))

typedef struct _PCPAMReader PCPAMReader;
typedef struct _PCPAMReaderClass PCPAMReaderClass;
typedef struct _PCPAMReaderPrivate PCPAMReaderPrivate;
enum  {
	PC_PAM_READER_0_PROPERTY,
	PC_PAM_READER_NUM_PROPERTIES
};
static GParamSpec* pc_pam_reader_properties[PC_PAM_READER_NUM_PROPERTIES];

#define PC_PAM_TYPE_TOKEN (pc_pam_token_get_type ())
#define PC_PAM_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_PAM_TYPE_TOKEN, PCPAMToken))
#define PC_PAM_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_PAM_TYPE_TOKEN, PCPAMTokenClass))
#define PC_PAM_IS_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_PAM_TYPE_TOKEN))
#define PC_PAM_IS_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_PAM_TYPE_TOKEN))
#define PC_PAM_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_PAM_TYPE_TOKEN, PCPAMTokenClass))

typedef struct _PCPAMToken PCPAMToken;
typedef struct _PCPAMTokenClass PCPAMTokenClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PCPAMReader {
	GObject parent_instance;
	PCPAMReaderPrivate * priv;
};

struct _PCPAMReaderClass {
	GObjectClass parent_class;
};

static gpointer pc_pam_reader_parent_class = NULL;

VALA_EXTERN GType pc_pam_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCPAMReader, g_object_unref)
VALA_EXTERN gchar* pc_pam_reader_get_config (const gchar* contents,
                                 gint* start_idx,
                                 gint* end_idx);
VALA_EXTERN GType pc_pam_token_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCPAMToken, g_object_unref)
VALA_EXTERN GList* pc_pam_reader_get_tokens (const gchar* filename);
VALA_EXTERN GList* pc_pam_token_parse (const gchar* str);
VALA_EXTERN PCPAMToken* pc_pam_reader_get_token_for_user (const gchar* filename,
                                              const gchar* username);
VALA_EXTERN gchar* pc_pam_token_get_user_arg0 (PCPAMToken* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN PCPAMReader* pc_pam_reader_new (void);
VALA_EXTERN PCPAMReader* pc_pam_reader_construct (GType object_type);
static GType pc_pam_reader_get_type_once (void);

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
pc_pam_reader_get_config (const gchar* contents,
                          gint* start_idx,
                          gint* end_idx)
{
	gint _vala_start_idx = 0;
	gint _vala_end_idx = 0;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (contents != NULL, NULL);
	_vala_start_idx = string_index_of (contents, PC_CONSTANTS_PAM_CONF_START, 0);
	_vala_end_idx = string_index_of (contents, PC_CONSTANTS_PAM_CONF_END, 0) + g_utf8_strlen (PC_CONSTANTS_PAM_CONF_END, (gssize) -1);
	if (_vala_start_idx == -1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_end_idx == -1;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		if (start_idx) {
			*start_idx = _vala_start_idx;
		}
		if (end_idx) {
			*end_idx = _vala_end_idx;
		}
		return result;
	}
	_tmp2_ = string_slice (contents, (glong) _vala_start_idx, (glong) _vala_end_idx);
	result = _tmp2_;
	if (start_idx) {
		*start_idx = _vala_start_idx;
	}
	if (end_idx) {
		*end_idx = _vala_end_idx;
	}
	return result;
}

GList*
pc_pam_reader_get_tokens (const gchar* filename)
{
	gchar* contents = NULL;
	gchar* config = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GList* _tmp6_;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (filename != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		g_file_get_contents (filename, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("Reader.vala:41: %s", _tmp2_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (contents);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp3_ = contents;
	_tmp4_ = pc_pam_reader_get_config (_tmp3_, NULL, NULL);
	config = _tmp4_;
	_tmp5_ = config;
	_tmp6_ = pc_pam_token_parse (_tmp5_);
	result = _tmp6_;
	_g_free0 (config);
	_g_free0 (contents);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

PCPAMToken*
pc_pam_reader_get_token_for_user (const gchar* filename,
                                  const gchar* username)
{
	GList* _tmp0_;
	PCPAMToken* result;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = pc_pam_reader_get_tokens (filename);
	{
		GList* token_collection = NULL;
		GList* token_it = NULL;
		token_collection = _tmp0_;
		for (token_it = token_collection; token_it != NULL; token_it = token_it->next) {
			PCPAMToken* _tmp1_;
			PCPAMToken* token = NULL;
			_tmp1_ = _g_object_ref0 ((PCPAMToken*) token_it->data);
			token = _tmp1_;
			{
				PCPAMToken* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gboolean _tmp5_;
				_tmp2_ = token;
				_tmp3_ = pc_pam_token_get_user_arg0 (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strcmp0 (_tmp4_, username) == 0;
				_g_free0 (_tmp4_);
				if (_tmp5_) {
					result = token;
					(token_collection == NULL) ? NULL : (token_collection = (_g_list_free__g_object_unref0_ (token_collection), NULL));
					return result;
				}
				_g_object_unref0 (token);
			}
		}
		(token_collection == NULL) ? NULL : (token_collection = (_g_list_free__g_object_unref0_ (token_collection), NULL));
	}
	result = NULL;
	return result;
}

PCPAMReader*
pc_pam_reader_construct (GType object_type)
{
	PCPAMReader * self = NULL;
	self = (PCPAMReader*) g_object_new (object_type, NULL);
	return self;
}

PCPAMReader*
pc_pam_reader_new (void)
{
	return pc_pam_reader_construct (PC_PAM_TYPE_READER);
}

static void
pc_pam_reader_class_init (PCPAMReaderClass * klass,
                          gpointer klass_data)
{
	pc_pam_reader_parent_class = g_type_class_peek_parent (klass);
}

static void
pc_pam_reader_instance_init (PCPAMReader * self,
                             gpointer klass)
{
}

static GType
pc_pam_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCPAMReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_pam_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCPAMReader), 0, (GInstanceInitFunc) pc_pam_reader_instance_init, NULL };
	GType pc_pam_reader_type_id;
	pc_pam_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "PCPAMReader", &g_define_type_info, 0);
	return pc_pam_reader_type_id;
}

GType
pc_pam_reader_get_type (void)
{
	static volatile gsize pc_pam_reader_type_id__once = 0;
	if (g_once_init_enter (&pc_pam_reader_type_id__once)) {
		GType pc_pam_reader_type_id;
		pc_pam_reader_type_id = pc_pam_reader_get_type_once ();
		g_once_init_leave (&pc_pam_reader_type_id__once, pc_pam_reader_type_id);
	}
	return pc_pam_reader_type_id__once;
}

