/*
 * sst-basic-blocks - an open source library of core audio utilities
 * built by Surge Synth Team.
 *
 * Provides a collection of tools useful on the audio thread for blocks,
 * modulation, etc... or useful for adapting code to multiple environments.
 *
 * Copyright 2023, various authors, as described in the GitHub
 * transaction log. Parts of this code are derived from similar
 * functions original in Surge or ShortCircuit.
 *
 * sst-basic-blocks is released under the GNU General Public Licence v3
 * or later (GPL-3.0-or-later). The license is found in the "LICENSE"
 * file in the root of this repository, or at
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * A very small number of explicitly chosen header files can also be
 * used in an MIT/BSD context. Please see the README.md file in this
 * repo or the comments in the individual files. Only headers with an
 * explicit mention that they are dual licensed may be copied and reused
 * outside the GPL3 terms.
 *
 * All source in sst-basic-blocks available at
 * https://github.com/surge-synthesizer/sst-basic-blocks
 */

#ifndef INCLUDE_SST_BASIC_BLOCKS_DSP_MIDSIDE_H
#define INCLUDE_SST_BASIC_BLOCKS_DSP_MIDSIDE_H

namespace sst::basic_blocks::dsp
{
template <size_t blocksize>
void encodeMS(float *__restrict L, float *__restrict R, float *__restrict M, float *__restrict S)
{
    for (auto i = 0U; i < blocksize; ++i)
    {
        M[i] = 0.5f * (L[i] + R[i]);
        S[i] = 0.5f * (L[i] - R[i]);
    }
}

template <size_t blocksize>
void decodeMS(float *__restrict M, float *__restrict S, float *__restrict L, float *__restrict R)
{
    for (auto i = 0U; i < blocksize; ++i)
    {
        L[i] = M[i] + S[i];
        R[i] = M[i] - S[i];
    }
}
} // namespace sst::basic_blocks::dsp
#endif // SURGE_MIDSIDE_H
