/* Window.c generated by valac 0.56.18, the Vala compiler
 * generated from Window.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <granite.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <cairo-gobject.h>
#include <glib/gi18n-lib.h>

#define SPICE_WINDOW_ACTION_PREFIX "win."
#define SPICE_WINDOW_ACTION_UNDO "action_undo"
#define SPICE_WINDOW_ACTION_REDO "action_redo"
#define SPICE_WINDOW_ACTION_CLONE "action_clone"
#define SPICE_WINDOW_ACTION_PRESENT_START "action_present_start"
#define SPICE_WINDOW_ACTION_PRESENT_STOP "action_present_stop"
#define SPICE_WINDOW_ACTION_SHOW_WELCOME "show_welcome"
#define SPICE_WINDOW_ACTION_NOTES "toggle_notes"
#define SPICE_WINDOW_ACTION_EXPORT "action_export"
#define SPICE_WINDOW_ACTION_NEW_SLIDE "action_new_slide"
#define SPICE_WINDOW_ACTION_INSERT_TEXT "action_insert_txt"
#define SPICE_WINDOW_ACTION_INSERT_IMG "action_insert_img"
#define SPICE_WINDOW_ACTION_INSERT_SHAPE "action_insert_shape"
#define SPICE_WINDOW_ACTION_BRING_FWD "action_bring_fwd"
#define SPICE_WINDOW_ACTION_BRING_BWD "action_send_bwd"
#define SPICE_WINDOW_ACTION_COPY "action_copy"
#define SPICE_WINDOW_ACTION_CUT "action_cut"
#define SPICE_WINDOW_ACTION_PASTE "action_paste"
#define SPICE_WINDOW_ACTION_DELETE "action_delete"
#define SPICE_WINDOW_ACTION_NEXT "action_next"
#define SPICE_WINDOW_ACTION_PREVIOUS "action_previous"
#define SPICE_WINDOW_ACTION_NEXT_EDIT "action_next_editing"
#define SPICE_WINDOW_ACTION_PREVIOUS_EDIT "action_previous_editing"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;
typedef struct _SpiceWindowPrivate SpiceWindowPrivate;

#define SPICE_TYPE_HEADERBAR (spice_headerbar_get_type ())
#define SPICE_HEADERBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_HEADERBAR, SpiceHeaderbar))
#define SPICE_HEADERBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_HEADERBAR, SpiceHeaderbarClass))
#define SPICE_IS_HEADERBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_HEADERBAR))
#define SPICE_IS_HEADERBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_HEADERBAR))
#define SPICE_HEADERBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_HEADERBAR, SpiceHeaderbarClass))

typedef struct _SpiceHeaderbar SpiceHeaderbar;
typedef struct _SpiceHeaderbarClass SpiceHeaderbarClass;

#define SPICE_TYPE_SLIDE_MANAGER (spice_slide_manager_get_type ())
#define SPICE_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager))
#define SPICE_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))
#define SPICE_IS_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_IS_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_SLIDE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))

typedef struct _SpiceSlideManager SpiceSlideManager;
typedef struct _SpiceSlideManagerClass SpiceSlideManagerClass;

#define SPICE_TYPE_SLIDE_LIST (spice_slide_list_get_type ())
#define SPICE_SLIDE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_LIST, SpiceSlideList))
#define SPICE_SLIDE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_LIST, SpiceSlideListClass))
#define SPICE_IS_SLIDE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_LIST))
#define SPICE_IS_SLIDE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_LIST))
#define SPICE_SLIDE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_LIST, SpiceSlideListClass))

typedef struct _SpiceSlideList SpiceSlideList;
typedef struct _SpiceSlideListClass SpiceSlideListClass;

#define SPICE_TYPE_DYNAMIC_TOOLBAR (spice_dynamic_toolbar_get_type ())
#define SPICE_DYNAMIC_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_DYNAMIC_TOOLBAR, SpiceDynamicToolbar))
#define SPICE_DYNAMIC_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_DYNAMIC_TOOLBAR, SpiceDynamicToolbarClass))
#define SPICE_IS_DYNAMIC_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_DYNAMIC_TOOLBAR))
#define SPICE_IS_DYNAMIC_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_DYNAMIC_TOOLBAR))
#define SPICE_DYNAMIC_TOOLBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_DYNAMIC_TOOLBAR, SpiceDynamicToolbarClass))

typedef struct _SpiceDynamicToolbar SpiceDynamicToolbar;
typedef struct _SpiceDynamicToolbarClass SpiceDynamicToolbarClass;

#define SPICE_TYPE_PRESENTER_NOTES (spice_presenter_notes_get_type ())
#define SPICE_PRESENTER_NOTES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_PRESENTER_NOTES, SpicePresenterNotes))
#define SPICE_PRESENTER_NOTES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_PRESENTER_NOTES, SpicePresenterNotesClass))
#define SPICE_IS_PRESENTER_NOTES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_PRESENTER_NOTES))
#define SPICE_IS_PRESENTER_NOTES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_PRESENTER_NOTES))
#define SPICE_PRESENTER_NOTES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_PRESENTER_NOTES, SpicePresenterNotesClass))

typedef struct _SpicePresenterNotes SpicePresenterNotes;
typedef struct _SpicePresenterNotesClass SpicePresenterNotesClass;

#define SPICE_TYPE_WELCOME (spice_welcome_get_type ())
#define SPICE_WELCOME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WELCOME, SpiceWelcome))
#define SPICE_WELCOME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WELCOME, SpiceWelcomeClass))
#define SPICE_IS_WELCOME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WELCOME))
#define SPICE_IS_WELCOME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WELCOME))
#define SPICE_WELCOME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WELCOME, SpiceWelcomeClass))

typedef struct _SpiceWelcome SpiceWelcome;
typedef struct _SpiceWelcomeClass SpiceWelcomeClass;

#define SPICE_TYPE_PRESENTER_WINDOW (spice_presenter_window_get_type ())
#define SPICE_PRESENTER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindow))
#define SPICE_PRESENTER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindowClass))
#define SPICE_IS_PRESENTER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_PRESENTER_WINDOW))
#define SPICE_IS_PRESENTER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_PRESENTER_WINDOW))
#define SPICE_PRESENTER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindowClass))

typedef struct _SpicePresenterWindow SpicePresenterWindow;
typedef struct _SpicePresenterWindowClass SpicePresenterWindowClass;

#define SPICE_SERVICES_TYPE_HISTORY_MANAGER (spice_services_history_manager_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManager))
#define SPICE_SERVICES_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))
#define SPICE_SERVICES_IS_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_IS_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_HISTORY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))

typedef struct _SpiceServicesHistoryManager SpiceServicesHistoryManager;
typedef struct _SpiceServicesHistoryManagerClass SpiceServicesHistoryManagerClass;
enum  {
	SPICE_WINDOW_0_PROPERTY,
	SPICE_WINDOW_IS_PRESENTING_PROPERTY,
	SPICE_WINDOW_HISTORY_MANAGER_PROPERTY,
	SPICE_WINDOW_CURRENT_FILE_PROPERTY,
	SPICE_WINDOW_ACTIONS_PROPERTY,
	SPICE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* spice_window_properties[SPICE_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define SPICE_SERVICES_TYPE_SETTINGS (spice_services_settings_get_type ())
#define SPICE_SERVICES_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettings))
#define SPICE_SERVICES_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))
#define SPICE_SERVICES_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))

typedef struct _SpiceServicesSettings SpiceServicesSettings;
typedef struct _SpiceServicesSettingsClass SpiceServicesSettingsClass;

#define SPICE_TYPE_APPLICATION (spice_application_get_type ())
#define SPICE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_APPLICATION, SpiceApplication))
#define SPICE_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_APPLICATION, SpiceApplicationClass))
#define SPICE_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_APPLICATION))
#define SPICE_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_APPLICATION))
#define SPICE_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_APPLICATION, SpiceApplicationClass))

typedef struct _SpiceApplication SpiceApplication;
typedef struct _SpiceApplicationClass SpiceApplicationClass;

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;
typedef enum  {
	SPICE_ASPECT_RATIO_ASPECT_4_3 = 1,
	SPICE_ASPECT_RATIO_ASPECT_16_9 = 2,
	SPICE_ASPECT_RATIO_ASPECT_16_10 = 3,
	SPICE_ASPECT_RATIO_ASPECT_3_2 = 4,
	SPICE_ASPECT_RATIO_ASPECT_5_4 = 5
} SpiceAspectRatio;

#define SPICE_TYPE_ASPECT_RATIO (spice_aspect_ratio_get_type ())

#define SPICE_TYPE_SLIDE (spice_slide_get_type ())
#define SPICE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE, SpiceSlide))
#define SPICE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE, SpiceSlideClass))
#define SPICE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE))
#define SPICE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE))
#define SPICE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE, SpiceSlideClass))

typedef struct _SpiceSlide SpiceSlide;
typedef struct _SpiceSlideClass SpiceSlideClass;

#define SPICE_TYPE_IMAGE_ITEM (spice_image_item_get_type ())
#define SPICE_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItem))
#define SPICE_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))
#define SPICE_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))

typedef struct _SpiceImageItem SpiceImageItem;
typedef struct _SpiceImageItemClass SpiceImageItemClass;
typedef struct _SpiceSlidePrivate SpiceSlidePrivate;

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;

#define SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION (spice_services_history_manager_history_action_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))

typedef struct _SpiceServicesHistoryManagerHistoryAction SpiceServicesHistoryManagerHistoryAction;
typedef struct _SpiceServicesHistoryManagerHistoryActionClass SpiceServicesHistoryManagerHistoryActionClass;
typedef enum  {
	SPICE_CANVAS_ITEM_TYPE_TEXT,
	SPICE_CANVAS_ITEM_TYPE_IMAGE,
	SPICE_CANVAS_ITEM_TYPE_SHAPE
} SpiceCanvasItemType;

#define SPICE_TYPE_CANVAS_ITEM_TYPE (spice_canvas_item_type_get_type ())
typedef struct _SpiceSlideManagerPrivate SpiceSlideManagerPrivate;

struct _SpiceWindow {
	GtkApplicationWindow parent_instance;
	SpiceWindowPrivate * priv;
};

struct _SpiceWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _SpiceWindowPrivate {
	guint inhibit_token;
	gint old_x;
	gint old_y;
	gboolean notification_shown;
	gboolean is_full_;
	SpiceHeaderbar* headerbar;
	SpiceSlideManager* slide_manager;
	SpiceSlideList* slide_list;
	SpiceDynamicToolbar* toolbar;
	GraniteWidgetsToast* toast;
	GtkRevealer* sidebar_revealer;
	GtkRevealer* toolbar_revealer;
	GtkAspectFrame* aspect_frame;
	GtkOverlay* app_overlay;
	SpicePresenterNotes* presenter_notes;
	GtkStack* app_stack;
	SpiceWelcome* welcome;
	SpicePresenterWindow* presenter_window;
	SpiceServicesHistoryManager* _history_manager;
	GFile* _current_file;
	GSimpleActionGroup* _actions;
	guint* hide_id;
	gboolean cursor_hidden;
};

struct _SpiceSlide {
	GObject parent_instance;
	SpiceSlidePrivate * priv;
	JsonObject* save_data;
	SpiceCanvas* canvas;
	GtkImage* preview;
};

struct _SpiceSlideClass {
	GObjectClass parent_class;
};

struct _SpiceSlideManager {
	GObject parent_instance;
	SpiceSlideManagerPrivate * priv;
	gboolean making_new_slide;
	SpiceSlide* end_presentation_slide;
	SpiceSlide* preview_slide_;
	SpiceSlide* checkpoint;
};

struct _SpiceSlideManagerClass {
	GObjectClass parent_class;
};

static gint SpiceWindow_private_offset;
static gpointer spice_window_parent_class = NULL;
VALA_EXTERN GeeMultiMap* spice_window_action_accelerators;
GeeMultiMap* spice_window_action_accelerators = NULL;
VALA_EXTERN SpiceServicesSettings* spice_settings;
VALA_EXTERN gint spice_slide_list_WIDTH;
VALA_EXTERN gboolean DEBUG;

VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN GType spice_headerbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceHeaderbar, g_object_unref)
VALA_EXTERN GType spice_slide_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideManager, g_object_unref)
VALA_EXTERN GType spice_slide_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideList, g_object_unref)
VALA_EXTERN GType spice_dynamic_toolbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceDynamicToolbar, g_object_unref)
VALA_EXTERN GType spice_presenter_notes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpicePresenterNotes, g_object_unref)
VALA_EXTERN GType spice_welcome_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWelcome, g_object_unref)
VALA_EXTERN GType spice_presenter_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpicePresenterWindow, g_object_unref)
VALA_EXTERN GType spice_services_history_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManager, g_object_unref)
VALA_EXTERN void spice_window_action_undo (SpiceWindow* self);
static void _spice_window_action_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
VALA_EXTERN void spice_window_action_redo (SpiceWindow* self);
static void _spice_window_action_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
VALA_EXTERN void spice_window_action_clone (SpiceWindow* self);
static void _spice_window_action_clone_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
VALA_EXTERN void spice_window_action_present_toggle (SpiceWindow* self);
static void _spice_window_action_present_toggle_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
VALA_EXTERN void spice_window_show_welcome (SpiceWindow* self);
static void _spice_window_show_welcome_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
VALA_EXTERN void spice_window_action_toggle_notes (SpiceWindow* self);
static void _spice_window_action_toggle_notes_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
VALA_EXTERN void spice_window_action_export (SpiceWindow* self);
static void _spice_window_action_export_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
VALA_EXTERN void spice_window_action_new_slide (SpiceWindow* self);
static void _spice_window_action_new_slide_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
VALA_EXTERN void spice_window_action_insert_txt (SpiceWindow* self);
static void _spice_window_action_insert_txt_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void spice_window_action_insert_img (SpiceWindow* self);
static void _spice_window_action_insert_img_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void spice_window_action_insert_shape (SpiceWindow* self);
static void _spice_window_action_insert_shape_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
VALA_EXTERN void spice_window_action_bring_fwd (SpiceWindow* self);
static void _spice_window_action_bring_fwd_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
VALA_EXTERN void spice_window_action_send_bwd (SpiceWindow* self);
static void _spice_window_action_send_bwd_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void spice_window_copy (SpiceWindow* self);
static void _spice_window_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void spice_window_cut (SpiceWindow* self);
static void _spice_window_cut_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void spice_window_paste (SpiceWindow* self);
static void _spice_window_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN void spice_window_delete_object (SpiceWindow* self);
static void _spice_window_delete_object_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void spice_window_next_slide (SpiceWindow* self);
static void _spice_window_next_slide_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void spice_window_previous_slide (SpiceWindow* self);
static void _spice_window_previous_slide_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
VALA_EXTERN SpiceWindow* spice_window_new (GtkApplication* app);
VALA_EXTERN SpiceWindow* spice_window_construct (GType object_type,
                                     GtkApplication* app);
VALA_EXTERN GType spice_services_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesSettings, g_object_unref)
VALA_EXTERN gint spice_services_settings_get_pos_x (SpiceServicesSettings* self);
VALA_EXTERN gint spice_services_settings_get_pos_y (SpiceServicesSettings* self);
VALA_EXTERN gint spice_services_settings_get_window_width (SpiceServicesSettings* self);
VALA_EXTERN gint spice_services_settings_get_window_height (SpiceServicesSettings* self);
VALA_EXTERN void spice_window_show_app (SpiceWindow* self);
static void spice_window_set_actions (SpiceWindow* self,
                               GSimpleActionGroup* value);
VALA_EXTERN GSimpleActionGroup* spice_window_get_actions (SpiceWindow* self);
static void spice_window_show_editor (SpiceWindow* self);
VALA_EXTERN SpiceHeaderbar* spice_headerbar_new (SpiceSlideManager* slide_manager);
VALA_EXTERN SpiceHeaderbar* spice_headerbar_construct (GType object_type,
                                           SpiceSlideManager* slide_manager);
VALA_EXTERN SpiceDynamicToolbar* spice_dynamic_toolbar_new (SpiceSlideManager* slide_manager);
VALA_EXTERN SpiceDynamicToolbar* spice_dynamic_toolbar_construct (GType object_type,
                                                      SpiceSlideManager* slide_manager);
VALA_EXTERN SpiceSlideList* spice_slide_list_new (SpiceSlideManager* manager);
VALA_EXTERN SpiceSlideList* spice_slide_list_construct (GType object_type,
                                            SpiceSlideManager* manager);
VALA_EXTERN SpicePresenterNotes* spice_presenter_notes_new (void);
VALA_EXTERN SpicePresenterNotes* spice_presenter_notes_construct (GType object_type);
VALA_EXTERN GtkStack* spice_slide_manager_get_slideshow (SpiceSlideManager* self);
static void spice_window_connect_signals (SpiceWindow* self,
                                   GtkApplication* app);
VALA_EXTERN void spice_window_enable_action_group (SpiceWindow* self,
                                       gchar** action_group,
                                       gint action_group_length1,
                                       gboolean enabled);
VALA_EXTERN void spice_window_save_current_file (SpiceWindow* self);
VALA_EXTERN void spice_headerbar_set_sensitive (SpiceHeaderbar* self,
                                    gboolean value);
VALA_EXTERN void spice_welcome_reload (SpiceWelcome* self);
VALA_EXTERN GFile* spice_window_get_current_file (SpiceWindow* self);
VALA_EXTERN GType spice_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceApplication, g_object_unref)
VALA_EXTERN SpiceApplication* spice_application_get_instance (void);
VALA_EXTERN void spice_application_unregister_file_from_window (SpiceApplication* self,
                                                    GFile* file);
static void spice_window_set_current_file (SpiceWindow* self,
                                    GFile* value);
VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
static void __lambda130_ (SpiceWindow* self,
                   SpiceCanvasItem* item);
VALA_EXTERN void spice_dynamic_toolbar_item_selected (SpiceDynamicToolbar* self,
                                          SpiceCanvasItem* item,
                                          gboolean new_item);
static void ___lambda130__spice_slide_manager_item_clicked (SpiceSlideManager* _sender,
                                                     SpiceCanvasItem* item,
                                                     gpointer self);
VALA_EXTERN GType spice_aspect_ratio_get_type (void) G_GNUC_CONST ;
static void __lambda131_ (SpiceWindow* self,
                   SpiceAspectRatio new_ratio);
VALA_EXTERN gint spice_aspect_ratio_get_width_value (SpiceAspectRatio value);
VALA_EXTERN gfloat spice_aspect_ratio_get_ratio_value (SpiceAspectRatio value);
static void ___lambda131__spice_slide_manager_aspect_ratio_changed (SpiceSlideManager* _sender,
                                                             SpiceAspectRatio ratio,
                                                             gpointer self);
VALA_EXTERN GType spice_slide_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlide, g_object_unref)
static void __lambda132_ (SpiceWindow* self,
                   SpiceSlide* current_slide);
VALA_EXTERN void spice_presenter_notes_set_text (SpicePresenterNotes* self,
                                     const gchar* text);
VALA_EXTERN const gchar* spice_slide_get_notes (SpiceSlide* self);
static void ___lambda132__spice_slide_manager_current_slide_changed (SpiceSlideManager* _sender,
                                                              SpiceSlide* slide,
                                                              gpointer self);
static void __lambda133_ (SpiceWindow* self,
                   const gchar* text);
VALA_EXTERN SpiceSlide* spice_slide_manager_get_current_slide (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_set_notes (SpiceSlide* self,
                            const gchar* value);
static void ___lambda133__spice_presenter_notes_text_changed (SpicePresenterNotes* _sender,
                                                       const gchar* text,
                                                       gpointer self);
static void spice_window_on_drag_data_received (SpiceWindow* self,
                                         GdkDragContext* drag_context,
                                         gint x,
                                         gint y,
                                         GtkSelectionData* data,
                                         guint info,
                                         guint time);
static void _spice_window_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                        GdkDragContext* context,
                                                                        gint x,
                                                                        gint y,
                                                                        GtkSelectionData* selection_data,
                                                                        guint info,
                                                                        guint time_,
                                                                        gpointer self);
VALA_EXTERN gboolean spice_utils_is_valid_image (GFile* file);
VALA_EXTERN GType spice_image_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceImageItem, g_object_unref)
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN SpiceImageItem* spice_image_item_new_from_file (SpiceCanvas* _canvas,
                                                GFile* file);
VALA_EXTERN SpiceImageItem* spice_image_item_construct_from_file (GType object_type,
                                                      SpiceCanvas* _canvas,
                                                      GFile* file);
VALA_EXTERN SpiceCanvasItem* spice_canvas_add_item (SpiceCanvas* self,
                                        SpiceCanvasItem* item,
                                        gboolean undoable_action);
VALA_EXTERN SpiceCanvasItem* spice_slide_manager_get_current_item (SpiceSlideManager* self);
VALA_EXTERN void spice_clipboard_cut (SpiceSlideManager* manager,
                          GObject* object);
VALA_EXTERN void spice_clipboard_copy (SpiceSlideManager* manager,
                           GObject* object);
VALA_EXTERN void spice_clipboard_paste (SpiceSlideManager* manager);
VALA_EXTERN void spice_clipboard_delete (GObject* object);
VALA_EXTERN void spice_canvas_unselect_all (SpiceCanvas* self,
                                gboolean reset_item);
VALA_EXTERN void spice_slide_manager_next_slide (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_manager_previous_slide (SpiceSlideManager* self);
VALA_EXTERN void spice_window_add_toast_notification (SpiceWindow* self,
                                          GraniteWidgetsToast* toast);
static void ___lambda75_ (SpiceWindow* self);
static void ____lambda75__granite_widgets_toast_closed (GraniteWidgetsToast* _sender,
                                                 gpointer self);
static void ___lambda76_ (SpiceWindow* self);
static void ____lambda76__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                         gpointer self);
VALA_EXTERN void spice_window_open_file (SpiceWindow* self,
                             GFile* file);
VALA_EXTERN gboolean spice_application_is_file_opened (SpiceApplication* self,
                                           GFile* file);
VALA_EXTERN SpiceWindow* spice_application_get_window_from_file (SpiceApplication* self,
                                                     GFile* file);
VALA_EXTERN void spice_slide_manager_reset (SpiceSlideManager* self);
VALA_EXTERN SpiceServicesHistoryManager* spice_window_get_history_manager (SpiceWindow* self);
VALA_EXTERN void spice_services_history_manager_clear_history (SpiceServicesHistoryManager* self);
VALA_EXTERN gchar* spice_services_file_manager_open_file (GFile* file);
VALA_EXTERN void spice_slide_manager_load_data (SpiceSlideManager* self,
                                    const gchar* data);
VALA_EXTERN void spice_application_register_file_to_window (SpiceApplication* self,
                                                GFile* file,
                                                SpiceWindow* window);
VALA_EXTERN guint spice_slide_manager_slide_count (SpiceSlideManager* self);
VALA_EXTERN void spice_services_file_manager_delete_file (GFile* file);
VALA_EXTERN void spice_services_file_manager_write_file (GFile* file,
                                             const gchar* contents);
VALA_EXTERN gchar* spice_slide_manager_serialise (SpiceSlideManager* self);
static gboolean spice_window_real_delete_event (GtkWidget* base,
                                         GdkEventAny* event);
VALA_EXTERN void spice_services_settings_set_pos_x (SpiceServicesSettings* self,
                                        gint value);
VALA_EXTERN void spice_services_settings_set_pos_y (SpiceServicesSettings* self,
                                        gint value);
VALA_EXTERN void spice_services_settings_set_window_width (SpiceServicesSettings* self,
                                               gint value);
VALA_EXTERN void spice_services_settings_set_window_height (SpiceServicesSettings* self,
                                                gint value);
VALA_EXTERN void spice_utils_set_action_enabled (const gchar* action_name,
                                     GSimpleActionGroup* action_group,
                                     gboolean enabled);
VALA_EXTERN GType spice_services_history_manager_history_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManagerHistoryAction, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_undo (SpiceServicesHistoryManager* self);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_redo (SpiceServicesHistoryManager* self);
VALA_EXTERN void spice_clipboard_duplicate (SpiceSlideManager* manager,
                                GObject* object);
VALA_EXTERN gboolean spice_window_get_is_presenting (SpiceWindow* self);
VALA_EXTERN void spice_window_set_is_presenting (SpiceWindow* self,
                                     gboolean value);
VALA_EXTERN void spice_presenter_notes_focus_notes (SpicePresenterNotes* self);
VALA_EXTERN void spice_headerbar_set_notes_shown (SpiceHeaderbar* self,
                                      gboolean value);
VALA_EXTERN void spice_services_file_manager_export_to_pdf (SpiceSlideManager* manager);
VALA_EXTERN void spice_utils_new_slide (SpiceSlideManager* manager);
VALA_EXTERN GType spice_canvas_item_type_get_type (void) G_GNUC_CONST ;
static void spice_window_insert_item_action (SpiceWindow* self,
                                      SpiceCanvasItemType type);
VALA_EXTERN SpiceCanvasItem* spice_slide_manager_request_new_item (SpiceSlideManager* self,
                                                       SpiceCanvasItemType type);
VALA_EXTERN void spice_slide_manager_move_up_request (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_manager_move_down_request (SpiceSlideManager* self);
static gboolean spice_window_request_to_hide_mouse (SpiceWindow* self,
                                             GdkEvent* event);
static gboolean spice_window_hide_cursor (SpiceWindow* self,
                                   gboolean hide);
static gboolean __lambda94_ (SpiceWindow* self);
static gboolean ___lambda94__gsource_func (gpointer self);
static guint* _uint_dup (guint* self);
VALA_EXTERN SpicePresenterWindow* spice_presenter_window_new (SpiceSlideManager* slide_manager,
                                                  SpiceWindow* window);
VALA_EXTERN SpicePresenterWindow* spice_presenter_window_construct (GType object_type,
                                                        SpiceSlideManager* slide_manager,
                                                        SpiceWindow* window);
static gboolean _spice_window_request_to_hide_mouse_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                             GdkEventMotion* event,
                                                                             gpointer self);
VALA_EXTERN void spice_headerbar_set_is_presenting (SpiceHeaderbar* self,
                                        gboolean value);
VALA_EXTERN void spice_slide_manager_end_presentation (SpiceSlideManager* self);
static void spice_window_set_history_manager (SpiceWindow* self,
                                       SpiceServicesHistoryManager* value);
static GObject * spice_window_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
VALA_EXTERN SpiceServicesHistoryManager* spice_services_history_manager_new (void);
VALA_EXTERN SpiceServicesHistoryManager* spice_services_history_manager_construct (GType object_type);
VALA_EXTERN SpiceSlideManager* spice_slide_manager_new (SpiceWindow* window);
VALA_EXTERN SpiceSlideManager* spice_slide_manager_construct (GType object_type,
                                                  SpiceWindow* window);
VALA_EXTERN void spice_gamepad_slide_controller_startup (SpiceSlideManager* _slide_manager,
                                             SpiceWindow* window);
VALA_EXTERN SpiceWelcome* spice_welcome_new (void);
VALA_EXTERN SpiceWelcome* spice_welcome_construct (GType object_type);
static void _spice_window___lambda143_ (SpiceWindow* self,
                                 GFile* file);
static void __spice_window___lambda143__spice_welcome_open_file (SpiceWelcome* _sender,
                                                          GFile* file,
                                                          gpointer self);
static void spice_window_finalize (GObject * obj);
static GType spice_window_get_type_once (void);
static void _vala_spice_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_spice_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GtkTargetEntry SPICE_WINDOW_DRAG_TARGETS[1] = {{"text/uri-list", (guint) 0, (guint) 0}};
static const GActionEntry SPICE_WINDOW_action_entries[22] = {{SPICE_WINDOW_ACTION_UNDO, _spice_window_action_undo_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_REDO, _spice_window_action_redo_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_CLONE, _spice_window_action_clone_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_PRESENT_START, _spice_window_action_present_toggle_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_PRESENT_STOP, _spice_window_action_present_toggle_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_SHOW_WELCOME, _spice_window_show_welcome_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_NOTES, _spice_window_action_toggle_notes_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_EXPORT, _spice_window_action_export_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_NEW_SLIDE, _spice_window_action_new_slide_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_INSERT_TEXT, _spice_window_action_insert_txt_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_INSERT_IMG, _spice_window_action_insert_img_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_INSERT_SHAPE, _spice_window_action_insert_shape_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_BRING_FWD, _spice_window_action_bring_fwd_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_BRING_BWD, _spice_window_action_send_bwd_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_COPY, _spice_window_copy_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_CUT, _spice_window_cut_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_PASTE, _spice_window_paste_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_DELETE, _spice_window_delete_object_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_NEXT, _spice_window_next_slide_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_PREVIOUS, _spice_window_previous_slide_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_NEXT_EDIT, _spice_window_next_slide_gsimple_action_activate_callback}, {SPICE_WINDOW_ACTION_PREVIOUS_EDIT, _spice_window_previous_slide_gsimple_action_activate_callback}};
static const gchar* SPICE_WINDOW_editing_actions[19] = {SPICE_WINDOW_ACTION_UNDO, SPICE_WINDOW_ACTION_REDO, SPICE_WINDOW_ACTION_CLONE, SPICE_WINDOW_ACTION_PRESENT_START, SPICE_WINDOW_ACTION_SHOW_WELCOME, SPICE_WINDOW_ACTION_NOTES, SPICE_WINDOW_ACTION_EXPORT, SPICE_WINDOW_ACTION_NEW_SLIDE, SPICE_WINDOW_ACTION_INSERT_TEXT, SPICE_WINDOW_ACTION_INSERT_IMG, SPICE_WINDOW_ACTION_INSERT_SHAPE, SPICE_WINDOW_ACTION_BRING_FWD, SPICE_WINDOW_ACTION_BRING_BWD, SPICE_WINDOW_ACTION_COPY, SPICE_WINDOW_ACTION_CUT, SPICE_WINDOW_ACTION_PASTE, SPICE_WINDOW_ACTION_DELETE, SPICE_WINDOW_ACTION_NEXT_EDIT, SPICE_WINDOW_ACTION_PREVIOUS_EDIT};
static const gchar* SPICE_WINDOW_presenting_actions[3] = {SPICE_WINDOW_ACTION_PRESENT_STOP, SPICE_WINDOW_ACTION_NEXT, SPICE_WINDOW_ACTION_PREVIOUS};

static inline gpointer
spice_window_get_instance_private (SpiceWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceWindow_private_offset);
}

static void
_spice_window_action_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_undo ((SpiceWindow*) self);
#line 689 "Window.c"
}

static void
_spice_window_action_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_redo ((SpiceWindow*) self);
#line 699 "Window.c"
}

static void
_spice_window_action_clone_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_clone ((SpiceWindow*) self);
#line 709 "Window.c"
}

static void
_spice_window_action_present_toggle_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_present_toggle ((SpiceWindow*) self);
#line 719 "Window.c"
}

static void
_spice_window_show_welcome_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_show_welcome ((SpiceWindow*) self);
#line 729 "Window.c"
}

static void
_spice_window_action_toggle_notes_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_toggle_notes ((SpiceWindow*) self);
#line 739 "Window.c"
}

static void
_spice_window_action_export_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_export ((SpiceWindow*) self);
#line 749 "Window.c"
}

static void
_spice_window_action_new_slide_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_new_slide ((SpiceWindow*) self);
#line 759 "Window.c"
}

static void
_spice_window_action_insert_txt_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_insert_txt ((SpiceWindow*) self);
#line 769 "Window.c"
}

static void
_spice_window_action_insert_img_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_insert_img ((SpiceWindow*) self);
#line 779 "Window.c"
}

static void
_spice_window_action_insert_shape_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_insert_shape ((SpiceWindow*) self);
#line 789 "Window.c"
}

static void
_spice_window_action_bring_fwd_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_bring_fwd ((SpiceWindow*) self);
#line 799 "Window.c"
}

static void
_spice_window_action_send_bwd_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_send_bwd ((SpiceWindow*) self);
#line 809 "Window.c"
}

static void
_spice_window_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_copy ((SpiceWindow*) self);
#line 819 "Window.c"
}

static void
_spice_window_cut_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_cut ((SpiceWindow*) self);
#line 829 "Window.c"
}

static void
_spice_window_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_paste ((SpiceWindow*) self);
#line 839 "Window.c"
}

static void
_spice_window_delete_object_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_delete_object ((SpiceWindow*) self);
#line 849 "Window.c"
}

static void
_spice_window_next_slide_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_next_slide ((SpiceWindow*) self);
#line 859 "Window.c"
}

static void
_spice_window_previous_slide_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
#line 168 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_previous_slide ((SpiceWindow*) self);
#line 869 "Window.c"
}

SpiceWindow*
spice_window_construct (GType object_type,
                        GtkApplication* app)
{
	SpiceWindow * self = NULL;
	SpiceServicesSettings* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	SpiceServicesSettings* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	SpiceServicesSettings* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	SpiceServicesSettings* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GSimpleActionGroup* _tmp12_;
	GSimpleActionGroup* _tmp13_;
	GSimpleActionGroup* _tmp14_;
	GSimpleActionGroup* _tmp15_;
#line 254 "../Spice-up-1.9.1/src/Window.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 255 "../Spice-up-1.9.1/src/Window.vala"
	self = (SpiceWindow*) g_object_new (object_type, "application", app, NULL);
#line 257 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = spice_settings;
#line 257 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_services_settings_get_pos_x (_tmp0_);
#line 257 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = _tmp1_;
#line 257 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = spice_settings;
#line 257 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = spice_services_settings_get_pos_y (_tmp3_);
#line 257 "../Spice-up-1.9.1/src/Window.vala"
	_tmp5_ = _tmp4_;
#line 257 "../Spice-up-1.9.1/src/Window.vala"
	gtk_window_move ((GtkWindow*) self, _tmp2_, _tmp5_);
#line 258 "../Spice-up-1.9.1/src/Window.vala"
	_tmp6_ = spice_settings;
#line 258 "../Spice-up-1.9.1/src/Window.vala"
	_tmp7_ = spice_services_settings_get_window_width (_tmp6_);
#line 258 "../Spice-up-1.9.1/src/Window.vala"
	_tmp8_ = _tmp7_;
#line 258 "../Spice-up-1.9.1/src/Window.vala"
	_tmp9_ = spice_settings;
#line 258 "../Spice-up-1.9.1/src/Window.vala"
	_tmp10_ = spice_services_settings_get_window_height (_tmp9_);
#line 258 "../Spice-up-1.9.1/src/Window.vala"
	_tmp11_ = _tmp10_;
#line 258 "../Spice-up-1.9.1/src/Window.vala"
	gtk_window_resize ((GtkWindow*) self, _tmp8_, _tmp11_);
#line 259 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_show_app (self);
#line 261 "../Spice-up-1.9.1/src/Window.vala"
	_tmp12_ = g_simple_action_group_new ();
#line 261 "../Spice-up-1.9.1/src/Window.vala"
	_tmp13_ = _tmp12_;
#line 261 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_set_actions (self, _tmp13_);
#line 261 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (_tmp13_);
#line 262 "../Spice-up-1.9.1/src/Window.vala"
	_tmp14_ = self->priv->_actions;
#line 262 "../Spice-up-1.9.1/src/Window.vala"
	g_action_map_add_action_entries ((GActionMap*) _tmp14_, SPICE_WINDOW_action_entries, (gint) G_N_ELEMENTS (SPICE_WINDOW_action_entries), self);
#line 263 "../Spice-up-1.9.1/src/Window.vala"
	_tmp15_ = self->priv->_actions;
#line 263 "../Spice-up-1.9.1/src/Window.vala"
	gtk_widget_insert_action_group ((GtkWidget*) self, "win", (GActionGroup*) _tmp15_);
#line 943 "Window.c"
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp16_;
		GeeSet* _tmp17_;
		GeeSet* _tmp18_;
		GeeIterator* _tmp19_;
		GeeIterator* _tmp20_;
#line 265 "../Spice-up-1.9.1/src/Window.vala"
		_tmp16_ = spice_window_action_accelerators;
#line 265 "../Spice-up-1.9.1/src/Window.vala"
		_tmp17_ = gee_multi_map_get_keys (_tmp16_);
#line 265 "../Spice-up-1.9.1/src/Window.vala"
		_tmp18_ = _tmp17_;
#line 265 "../Spice-up-1.9.1/src/Window.vala"
		_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
#line 265 "../Spice-up-1.9.1/src/Window.vala"
		_tmp20_ = _tmp19_;
#line 265 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (_tmp18_);
#line 265 "../Spice-up-1.9.1/src/Window.vala"
		_action_it = _tmp20_;
#line 265 "../Spice-up-1.9.1/src/Window.vala"
		while (TRUE) {
#line 967 "Window.c"
			GeeIterator* _tmp21_;
			gchar* action = NULL;
			GeeIterator* _tmp22_;
			gpointer _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			GeeMultiMap* _tmp27_;
			const gchar* _tmp28_;
			GeeCollection* _tmp29_;
			GeeCollection* _tmp30_;
			gint _tmp31_ = 0;
			gpointer* _tmp32_;
			gchar** _tmp33_;
			gint _tmp33__length1;
#line 265 "../Spice-up-1.9.1/src/Window.vala"
			_tmp21_ = _action_it;
#line 265 "../Spice-up-1.9.1/src/Window.vala"
			if (!gee_iterator_next (_tmp21_)) {
#line 265 "../Spice-up-1.9.1/src/Window.vala"
				break;
#line 989 "Window.c"
			}
#line 265 "../Spice-up-1.9.1/src/Window.vala"
			_tmp22_ = _action_it;
#line 265 "../Spice-up-1.9.1/src/Window.vala"
			_tmp23_ = gee_iterator_get (_tmp22_);
#line 265 "../Spice-up-1.9.1/src/Window.vala"
			action = (gchar*) _tmp23_;
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp24_ = action;
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp25_ = g_strconcat (SPICE_WINDOW_ACTION_PREFIX, _tmp24_, NULL);
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp26_ = _tmp25_;
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp27_ = spice_window_action_accelerators;
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp28_ = action;
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp29_ = gee_multi_map_get (_tmp27_, _tmp28_);
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp30_ = _tmp29_;
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp32_ = gee_collection_to_array (_tmp30_, &_tmp31_);
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp33_ = _tmp32_;
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp33__length1 = _tmp31_;
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			gtk_application_set_accels_for_action (app, _tmp26_, _tmp33_);
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_g_object_unref0 (_tmp30_);
#line 266 "../Spice-up-1.9.1/src/Window.vala"
			_g_free0 (_tmp26_);
#line 265 "../Spice-up-1.9.1/src/Window.vala"
			_g_free0 (action);
#line 1027 "Window.c"
		}
#line 265 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (_action_it);
#line 1031 "Window.c"
	}
#line 254 "../Spice-up-1.9.1/src/Window.vala"
	return self;
#line 1035 "Window.c"
}

SpiceWindow*
spice_window_new (GtkApplication* app)
{
#line 254 "../Spice-up-1.9.1/src/Window.vala"
	return spice_window_construct (SPICE_TYPE_WINDOW, app);
#line 1043 "Window.c"
}

static void
spice_window_show_editor (SpiceWindow* self)
{
	GtkAspectFrame* _tmp0_;
	GtkStack* _tmp41_;
#line 297 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 298 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->aspect_frame;
#line 298 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp0_ == NULL) {
#line 1057 "Window.c"
		SpiceSlideManager* _tmp1_;
		SpiceHeaderbar* _tmp2_;
		SpiceHeaderbar* _tmp3_;
		SpiceSlideManager* _tmp4_;
		SpiceDynamicToolbar* _tmp5_;
		SpiceSlideManager* _tmp6_;
		SpiceSlideList* _tmp7_;
		GtkRevealer* _tmp8_;
		GtkRevealer* _tmp9_;
		SpicePresenterNotes* _tmp10_;
		GtkRevealer* _tmp11_;
		SpiceSlideList* _tmp12_;
		GtkRevealer* _tmp13_;
		GtkRevealer* _tmp14_;
		SpiceDynamicToolbar* _tmp15_;
		GtkRevealer* _tmp16_;
		GtkRevealer* _tmp17_;
		GtkAspectFrame* _tmp18_;
		GtkAspectFrame* _tmp19_;
		GtkStyleContext* _tmp20_;
		GtkAspectFrame* _tmp21_;
		SpiceSlideManager* _tmp22_;
		GtkStack* _tmp23_;
		GtkStack* _tmp24_;
		GtkAspectFrame* _tmp25_;
		GtkGrid* grid = NULL;
		GtkGrid* _tmp26_;
		GtkGrid* _tmp27_;
		GtkStyleContext* _tmp28_;
		GtkGrid* _tmp29_;
		GtkRevealer* _tmp30_;
		GtkGrid* _tmp31_;
		GtkRevealer* _tmp32_;
		GtkGrid* _tmp33_;
		GtkAspectFrame* _tmp34_;
		GtkGrid* _tmp35_;
		SpicePresenterNotes* _tmp36_;
		GtkStack* _tmp37_;
		GtkGrid* _tmp38_;
		GtkApplication* _tmp39_;
		GtkApplication* _tmp40_;
#line 299 "../Spice-up-1.9.1/src/Window.vala"
		_tmp1_ = self->priv->slide_manager;
#line 299 "../Spice-up-1.9.1/src/Window.vala"
		_tmp2_ = spice_headerbar_new (_tmp1_);
#line 299 "../Spice-up-1.9.1/src/Window.vala"
		g_object_ref_sink (_tmp2_);
#line 299 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->headerbar);
#line 299 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->headerbar = _tmp2_;
#line 300 "../Spice-up-1.9.1/src/Window.vala"
		_tmp3_ = self->priv->headerbar;
#line 300 "../Spice-up-1.9.1/src/Window.vala"
		gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp3_);
#line 302 "../Spice-up-1.9.1/src/Window.vala"
		_tmp4_ = self->priv->slide_manager;
#line 302 "../Spice-up-1.9.1/src/Window.vala"
		_tmp5_ = spice_dynamic_toolbar_new (_tmp4_);
#line 302 "../Spice-up-1.9.1/src/Window.vala"
		g_object_ref_sink (_tmp5_);
#line 302 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->toolbar);
#line 302 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->toolbar = _tmp5_;
#line 304 "../Spice-up-1.9.1/src/Window.vala"
		_tmp6_ = self->priv->slide_manager;
#line 304 "../Spice-up-1.9.1/src/Window.vala"
		_tmp7_ = spice_slide_list_new (_tmp6_);
#line 304 "../Spice-up-1.9.1/src/Window.vala"
		g_object_ref_sink (_tmp7_);
#line 304 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->slide_list);
#line 304 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->slide_list = _tmp7_;
#line 306 "../Spice-up-1.9.1/src/Window.vala"
		_tmp8_ = (GtkRevealer*) gtk_revealer_new ();
#line 306 "../Spice-up-1.9.1/src/Window.vala"
		g_object_ref_sink (_tmp8_);
#line 306 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->sidebar_revealer);
#line 306 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->sidebar_revealer = _tmp8_;
#line 307 "../Spice-up-1.9.1/src/Window.vala"
		_tmp9_ = (GtkRevealer*) gtk_revealer_new ();
#line 307 "../Spice-up-1.9.1/src/Window.vala"
		g_object_ref_sink (_tmp9_);
#line 307 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->toolbar_revealer);
#line 307 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->toolbar_revealer = _tmp9_;
#line 309 "../Spice-up-1.9.1/src/Window.vala"
		_tmp10_ = spice_presenter_notes_new ();
#line 309 "../Spice-up-1.9.1/src/Window.vala"
		g_object_ref_sink (_tmp10_);
#line 309 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->presenter_notes);
#line 309 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->presenter_notes = _tmp10_;
#line 311 "../Spice-up-1.9.1/src/Window.vala"
		_tmp11_ = self->priv->sidebar_revealer;
#line 311 "../Spice-up-1.9.1/src/Window.vala"
		_tmp12_ = self->priv->slide_list;
#line 311 "../Spice-up-1.9.1/src/Window.vala"
		gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
#line 312 "../Spice-up-1.9.1/src/Window.vala"
		_tmp13_ = self->priv->sidebar_revealer;
#line 312 "../Spice-up-1.9.1/src/Window.vala"
		gtk_revealer_set_reveal_child (_tmp13_, TRUE);
#line 314 "../Spice-up-1.9.1/src/Window.vala"
		_tmp14_ = self->priv->toolbar_revealer;
#line 314 "../Spice-up-1.9.1/src/Window.vala"
		_tmp15_ = self->priv->toolbar;
#line 314 "../Spice-up-1.9.1/src/Window.vala"
		gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
#line 315 "../Spice-up-1.9.1/src/Window.vala"
		_tmp16_ = self->priv->toolbar_revealer;
#line 315 "../Spice-up-1.9.1/src/Window.vala"
		gtk_revealer_set_reveal_child (_tmp16_, TRUE);
#line 316 "../Spice-up-1.9.1/src/Window.vala"
		_tmp17_ = self->priv->toolbar_revealer;
#line 316 "../Spice-up-1.9.1/src/Window.vala"
		gtk_revealer_set_transition_duration (_tmp17_, (guint) 0);
#line 318 "../Spice-up-1.9.1/src/Window.vala"
		_tmp18_ = (GtkAspectFrame*) gtk_aspect_frame_new (NULL, (gfloat) 0.5, (gfloat) 0.5, (gfloat) 1.7777, FALSE);
#line 318 "../Spice-up-1.9.1/src/Window.vala"
		g_object_ref_sink (_tmp18_);
#line 318 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->aspect_frame);
#line 318 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->aspect_frame = _tmp18_;
#line 319 "../Spice-up-1.9.1/src/Window.vala"
		_tmp19_ = self->priv->aspect_frame;
#line 319 "../Spice-up-1.9.1/src/Window.vala"
		_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
#line 319 "../Spice-up-1.9.1/src/Window.vala"
		gtk_style_context_add_class (_tmp20_, "flat");
#line 320 "../Spice-up-1.9.1/src/Window.vala"
		_tmp21_ = self->priv->aspect_frame;
#line 320 "../Spice-up-1.9.1/src/Window.vala"
		_tmp22_ = self->priv->slide_manager;
#line 320 "../Spice-up-1.9.1/src/Window.vala"
		_tmp23_ = spice_slide_manager_get_slideshow (_tmp22_);
#line 320 "../Spice-up-1.9.1/src/Window.vala"
		_tmp24_ = _tmp23_;
#line 320 "../Spice-up-1.9.1/src/Window.vala"
		gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp24_);
#line 321 "../Spice-up-1.9.1/src/Window.vala"
		_tmp25_ = self->priv->aspect_frame;
#line 321 "../Spice-up-1.9.1/src/Window.vala"
		g_object_set ((GtkWidget*) _tmp25_, "margin", 24, NULL);
#line 323 "../Spice-up-1.9.1/src/Window.vala"
		_tmp26_ = (GtkGrid*) gtk_grid_new ();
#line 323 "../Spice-up-1.9.1/src/Window.vala"
		g_object_ref_sink (_tmp26_);
#line 323 "../Spice-up-1.9.1/src/Window.vala"
		grid = _tmp26_;
#line 324 "../Spice-up-1.9.1/src/Window.vala"
		_tmp27_ = grid;
#line 324 "../Spice-up-1.9.1/src/Window.vala"
		_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
#line 324 "../Spice-up-1.9.1/src/Window.vala"
		gtk_style_context_add_class (_tmp28_, "app-back");
#line 325 "../Spice-up-1.9.1/src/Window.vala"
		_tmp29_ = grid;
#line 325 "../Spice-up-1.9.1/src/Window.vala"
		_tmp30_ = self->priv->toolbar_revealer;
#line 325 "../Spice-up-1.9.1/src/Window.vala"
		gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp30_, 1, 0, 1, 1);
#line 326 "../Spice-up-1.9.1/src/Window.vala"
		_tmp31_ = grid;
#line 326 "../Spice-up-1.9.1/src/Window.vala"
		_tmp32_ = self->priv->sidebar_revealer;
#line 326 "../Spice-up-1.9.1/src/Window.vala"
		gtk_grid_attach (_tmp31_, (GtkWidget*) _tmp32_, 0, 0, 1, 3);
#line 327 "../Spice-up-1.9.1/src/Window.vala"
		_tmp33_ = grid;
#line 327 "../Spice-up-1.9.1/src/Window.vala"
		_tmp34_ = self->priv->aspect_frame;
#line 327 "../Spice-up-1.9.1/src/Window.vala"
		gtk_grid_attach (_tmp33_, (GtkWidget*) _tmp34_, 1, 1, 1, 1);
#line 328 "../Spice-up-1.9.1/src/Window.vala"
		_tmp35_ = grid;
#line 328 "../Spice-up-1.9.1/src/Window.vala"
		_tmp36_ = self->priv->presenter_notes;
#line 328 "../Spice-up-1.9.1/src/Window.vala"
		gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, 1, 2, 1, 1);
#line 330 "../Spice-up-1.9.1/src/Window.vala"
		_tmp37_ = self->priv->app_stack;
#line 330 "../Spice-up-1.9.1/src/Window.vala"
		_tmp38_ = grid;
#line 330 "../Spice-up-1.9.1/src/Window.vala"
		gtk_stack_add_named (_tmp37_, (GtkWidget*) _tmp38_, "application");
#line 332 "../Spice-up-1.9.1/src/Window.vala"
		gtk_widget_show_all ((GtkWidget*) self);
#line 334 "../Spice-up-1.9.1/src/Window.vala"
		_tmp39_ = gtk_window_get_application ((GtkWindow*) self);
#line 334 "../Spice-up-1.9.1/src/Window.vala"
		_tmp40_ = _tmp39_;
#line 334 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_connect_signals (self, _tmp40_);
#line 298 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (grid);
#line 1261 "Window.c"
	}
#line 337 "../Spice-up-1.9.1/src/Window.vala"
	_tmp41_ = self->priv->app_stack;
#line 337 "../Spice-up-1.9.1/src/Window.vala"
	gtk_stack_set_visible_child_name (_tmp41_, "application");
#line 339 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_enable_action_group (self, SPICE_WINDOW_editing_actions, (gint) G_N_ELEMENTS (SPICE_WINDOW_editing_actions), TRUE);
#line 340 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_enable_action_group (self, SPICE_WINDOW_presenting_actions, (gint) G_N_ELEMENTS (SPICE_WINDOW_presenting_actions), FALSE);
#line 1271 "Window.c"
}

void
spice_window_show_welcome (SpiceWindow* self)
{
	SpiceHeaderbar* _tmp0_;
	SpiceWelcome* _tmp2_;
	GtkStack* _tmp3_;
	GtkStack* _tmp4_;
	GFile* _tmp5_;
#line 343 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 344 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_save_current_file (self);
#line 346 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->headerbar;
#line 346 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp0_ != NULL) {
#line 1290 "Window.c"
		SpiceHeaderbar* _tmp1_;
#line 347 "../Spice-up-1.9.1/src/Window.vala"
		_tmp1_ = self->priv->headerbar;
#line 347 "../Spice-up-1.9.1/src/Window.vala"
		spice_headerbar_set_sensitive (_tmp1_, FALSE);
#line 1296 "Window.c"
	}
#line 350 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = self->priv->welcome;
#line 350 "../Spice-up-1.9.1/src/Window.vala"
	spice_welcome_reload (_tmp2_);
#line 351 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = self->priv->app_stack;
#line 351 "../Spice-up-1.9.1/src/Window.vala"
	gtk_stack_set_transition_type (_tmp3_, GTK_STACK_TRANSITION_TYPE_OVER_LEFT_RIGHT);
#line 352 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = self->priv->app_stack;
#line 352 "../Spice-up-1.9.1/src/Window.vala"
	gtk_stack_set_visible_child_name (_tmp4_, "welcome");
#line 354 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_enable_action_group (self, SPICE_WINDOW_editing_actions, (gint) G_N_ELEMENTS (SPICE_WINDOW_editing_actions), FALSE);
#line 355 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_enable_action_group (self, SPICE_WINDOW_presenting_actions, (gint) G_N_ELEMENTS (SPICE_WINDOW_presenting_actions), FALSE);
#line 357 "../Spice-up-1.9.1/src/Window.vala"
	_tmp5_ = self->priv->_current_file;
#line 357 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp5_ != NULL) {
#line 1318 "Window.c"
		SpiceApplication* _tmp6_;
		SpiceApplication* _tmp7_;
		GFile* _tmp8_;
#line 358 "../Spice-up-1.9.1/src/Window.vala"
		_tmp6_ = spice_application_get_instance ();
#line 358 "../Spice-up-1.9.1/src/Window.vala"
		_tmp7_ = _tmp6_;
#line 358 "../Spice-up-1.9.1/src/Window.vala"
		_tmp8_ = self->priv->_current_file;
#line 358 "../Spice-up-1.9.1/src/Window.vala"
		spice_application_unregister_file_from_window (_tmp7_, _tmp8_);
#line 359 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_set_current_file (self, NULL);
#line 1332 "Window.c"
	}
}

static void
__lambda130_ (SpiceWindow* self,
              SpiceCanvasItem* item)
{
	SpiceDynamicToolbar* _tmp0_;
#line 365 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->toolbar;
#line 365 "../Spice-up-1.9.1/src/Window.vala"
	spice_dynamic_toolbar_item_selected (_tmp0_, item, FALSE);
#line 1345 "Window.c"
}

static void
___lambda130__spice_slide_manager_item_clicked (SpiceSlideManager* _sender,
                                                SpiceCanvasItem* item,
                                                gpointer self)
{
#line 364 "../Spice-up-1.9.1/src/Window.vala"
	__lambda130_ ((SpiceWindow*) self, item);
#line 1355 "Window.c"
}

static void
__lambda131_ (SpiceWindow* self,
              SpiceAspectRatio new_ratio)
{
	GtkAspectFrame* _tmp0_;
#line 369 "../Spice-up-1.9.1/src/Window.vala"
	spice_slide_list_WIDTH = spice_aspect_ratio_get_width_value (new_ratio);
#line 370 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->aspect_frame;
#line 370 "../Spice-up-1.9.1/src/Window.vala"
	g_object_set (_tmp0_, "ratio", spice_aspect_ratio_get_ratio_value (new_ratio), NULL);
#line 1369 "Window.c"
}

static void
___lambda131__spice_slide_manager_aspect_ratio_changed (SpiceSlideManager* _sender,
                                                        SpiceAspectRatio ratio,
                                                        gpointer self)
{
#line 368 "../Spice-up-1.9.1/src/Window.vala"
	__lambda131_ ((SpiceWindow*) self, ratio);
#line 1379 "Window.c"
}

static void
__lambda132_ (SpiceWindow* self,
              SpiceSlide* current_slide)
{
	SpicePresenterNotes* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 373 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (current_slide != NULL);
#line 374 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->presenter_notes;
#line 374 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_slide_get_notes (current_slide);
#line 374 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = _tmp1_;
#line 374 "../Spice-up-1.9.1/src/Window.vala"
	spice_presenter_notes_set_text (_tmp0_, _tmp2_);
#line 1399 "Window.c"
}

static void
___lambda132__spice_slide_manager_current_slide_changed (SpiceSlideManager* _sender,
                                                         SpiceSlide* slide,
                                                         gpointer self)
{
#line 373 "../Spice-up-1.9.1/src/Window.vala"
	__lambda132_ ((SpiceWindow*) self, slide);
#line 1409 "Window.c"
}

static void
__lambda133_ (SpiceWindow* self,
              const gchar* text)
{
	SpiceSlideManager* _tmp0_;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
#line 377 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (text != NULL);
#line 378 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 378 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_slide_manager_get_current_slide (_tmp0_);
#line 378 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = _tmp1_;
#line 378 "../Spice-up-1.9.1/src/Window.vala"
	spice_slide_set_notes (_tmp2_, text);
#line 1429 "Window.c"
}

static void
___lambda133__spice_presenter_notes_text_changed (SpicePresenterNotes* _sender,
                                                  const gchar* text,
                                                  gpointer self)
{
#line 377 "../Spice-up-1.9.1/src/Window.vala"
	__lambda133_ ((SpiceWindow*) self, text);
#line 1439 "Window.c"
}

static void
_spice_window_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                   GdkDragContext* context,
                                                                   gint x,
                                                                   gint y,
                                                                   GtkSelectionData* selection_data,
                                                                   guint info,
                                                                   guint time_,
                                                                   gpointer self)
{
#line 382 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_on_drag_data_received ((SpiceWindow*) self, context, x, y, selection_data, info, time_);
#line 1454 "Window.c"
}

static void
spice_window_connect_signals (SpiceWindow* self,
                              GtkApplication* app)
{
	SpiceSlideManager* _tmp0_;
	SpiceSlideManager* _tmp1_;
	SpiceSlideManager* _tmp2_;
	SpicePresenterNotes* _tmp3_;
	GtkAspectFrame* _tmp4_;
	GtkAspectFrame* _tmp5_;
#line 363 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 363 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (app != NULL);
#line 364 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 364 "../Spice-up-1.9.1/src/Window.vala"
	g_signal_connect_object (_tmp0_, "item-clicked", (GCallback) ___lambda130__spice_slide_manager_item_clicked, self, 0);
#line 368 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = self->priv->slide_manager;
#line 368 "../Spice-up-1.9.1/src/Window.vala"
	g_signal_connect_object (_tmp1_, "aspect-ratio-changed", (GCallback) ___lambda131__spice_slide_manager_aspect_ratio_changed, self, 0);
#line 373 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = self->priv->slide_manager;
#line 373 "../Spice-up-1.9.1/src/Window.vala"
	g_signal_connect_object (_tmp2_, "current-slide-changed", (GCallback) ___lambda132__spice_slide_manager_current_slide_changed, self, 0);
#line 377 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = self->priv->presenter_notes;
#line 377 "../Spice-up-1.9.1/src/Window.vala"
	g_signal_connect_object (_tmp3_, "text-changed", (GCallback) ___lambda133__spice_presenter_notes_text_changed, self, 0);
#line 381 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = self->priv->aspect_frame;
#line 381 "../Spice-up-1.9.1/src/Window.vala"
	gtk_drag_dest_set ((GtkWidget*) _tmp4_, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP, SPICE_WINDOW_DRAG_TARGETS, (gint) G_N_ELEMENTS (SPICE_WINDOW_DRAG_TARGETS), GDK_ACTION_COPY);
#line 382 "../Spice-up-1.9.1/src/Window.vala"
	_tmp5_ = self->priv->aspect_frame;
#line 382 "../Spice-up-1.9.1/src/Window.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "drag-data-received", (GCallback) _spice_window_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
#line 1495 "Window.c"
}

static void
spice_window_on_drag_data_received (SpiceWindow* self,
                                    GdkDragContext* drag_context,
                                    gint x,
                                    gint y,
                                    GtkSelectionData* data,
                                    guint info,
                                    guint time)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
#line 385 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 385 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (drag_context != NULL);
#line 385 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (data != NULL);
#line 386 "../Spice-up-1.9.1/src/Window.vala"
	gtk_drag_finish (drag_context, TRUE, FALSE, (guint32) time);
#line 388 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = _tmp0_ = gtk_selection_data_get_uris (data);
#line 1519 "Window.c"
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
#line 388 "../Spice-up-1.9.1/src/Window.vala"
		uri_collection = _tmp1_;
#line 388 "../Spice-up-1.9.1/src/Window.vala"
		uri_collection_length1 = _vala_array_length (_tmp0_);
#line 388 "../Spice-up-1.9.1/src/Window.vala"
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
#line 1531 "Window.c"
			gchar* _tmp2_;
			gchar* uri = NULL;
#line 388 "../Spice-up-1.9.1/src/Window.vala"
			_tmp2_ = g_strdup (uri_collection[uri_it]);
#line 388 "../Spice-up-1.9.1/src/Window.vala"
			uri = _tmp2_;
#line 1538 "Window.c"
			{
				GFile* file = NULL;
				const gchar* _tmp3_;
				GFile* _tmp4_;
				gboolean _tmp5_ = FALSE;
				GFile* _tmp6_;
#line 389 "../Spice-up-1.9.1/src/Window.vala"
				_tmp3_ = uri;
#line 389 "../Spice-up-1.9.1/src/Window.vala"
				_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 389 "../Spice-up-1.9.1/src/Window.vala"
				file = _tmp4_;
#line 391 "../Spice-up-1.9.1/src/Window.vala"
				_tmp6_ = file;
#line 391 "../Spice-up-1.9.1/src/Window.vala"
				if (spice_utils_is_valid_image (_tmp6_)) {
#line 1555 "Window.c"
					SpiceSlideManager* _tmp7_;
					SpiceSlide* _tmp8_;
					SpiceSlide* _tmp9_;
#line 391 "../Spice-up-1.9.1/src/Window.vala"
					_tmp7_ = self->priv->slide_manager;
#line 391 "../Spice-up-1.9.1/src/Window.vala"
					_tmp8_ = spice_slide_manager_get_current_slide (_tmp7_);
#line 391 "../Spice-up-1.9.1/src/Window.vala"
					_tmp9_ = _tmp8_;
#line 391 "../Spice-up-1.9.1/src/Window.vala"
					_tmp5_ = _tmp9_ != NULL;
#line 1567 "Window.c"
				} else {
#line 391 "../Spice-up-1.9.1/src/Window.vala"
					_tmp5_ = FALSE;
#line 1571 "Window.c"
				}
#line 391 "../Spice-up-1.9.1/src/Window.vala"
				if (_tmp5_) {
#line 1575 "Window.c"
					SpiceImageItem* item = NULL;
					SpiceSlideManager* _tmp10_;
					SpiceSlide* _tmp11_;
					SpiceSlide* _tmp12_;
					SpiceCanvas* _tmp13_;
					GFile* _tmp14_;
					SpiceImageItem* _tmp15_;
					SpiceSlideManager* _tmp16_;
					SpiceSlide* _tmp17_;
					SpiceSlide* _tmp18_;
					SpiceCanvas* _tmp19_;
					SpiceImageItem* _tmp20_;
					SpiceCanvasItem* _tmp21_;
					SpiceCanvasItem* _tmp22_;
#line 392 "../Spice-up-1.9.1/src/Window.vala"
					_tmp10_ = self->priv->slide_manager;
#line 392 "../Spice-up-1.9.1/src/Window.vala"
					_tmp11_ = spice_slide_manager_get_current_slide (_tmp10_);
#line 392 "../Spice-up-1.9.1/src/Window.vala"
					_tmp12_ = _tmp11_;
#line 392 "../Spice-up-1.9.1/src/Window.vala"
					_tmp13_ = _tmp12_->canvas;
#line 392 "../Spice-up-1.9.1/src/Window.vala"
					_tmp14_ = file;
#line 392 "../Spice-up-1.9.1/src/Window.vala"
					_tmp15_ = spice_image_item_new_from_file (_tmp13_, _tmp14_);
#line 392 "../Spice-up-1.9.1/src/Window.vala"
					g_object_ref_sink (_tmp15_);
#line 392 "../Spice-up-1.9.1/src/Window.vala"
					item = _tmp15_;
#line 393 "../Spice-up-1.9.1/src/Window.vala"
					_tmp16_ = self->priv->slide_manager;
#line 393 "../Spice-up-1.9.1/src/Window.vala"
					_tmp17_ = spice_slide_manager_get_current_slide (_tmp16_);
#line 393 "../Spice-up-1.9.1/src/Window.vala"
					_tmp18_ = _tmp17_;
#line 393 "../Spice-up-1.9.1/src/Window.vala"
					_tmp19_ = _tmp18_->canvas;
#line 393 "../Spice-up-1.9.1/src/Window.vala"
					_tmp20_ = item;
#line 393 "../Spice-up-1.9.1/src/Window.vala"
					_tmp21_ = spice_canvas_add_item (_tmp19_, (SpiceCanvasItem*) _tmp20_, TRUE);
#line 393 "../Spice-up-1.9.1/src/Window.vala"
					_tmp22_ = _tmp21_;
#line 393 "../Spice-up-1.9.1/src/Window.vala"
					_g_object_unref0 (_tmp22_);
#line 391 "../Spice-up-1.9.1/src/Window.vala"
					_g_object_unref0 (item);
#line 1624 "Window.c"
				}
#line 388 "../Spice-up-1.9.1/src/Window.vala"
				_g_object_unref0 (file);
#line 388 "../Spice-up-1.9.1/src/Window.vala"
				_g_free0 (uri);
#line 1630 "Window.c"
			}
		}
#line 388 "../Spice-up-1.9.1/src/Window.vala"
		uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1635 "Window.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 399 "../Spice-up-1.9.1/src/Window.vala"
	return self ? g_object_ref (self) : NULL;
#line 1644 "Window.c"
}

static void
spice_window_cut (SpiceWindow* self)
{
	SpiceCanvasItem* current_item = NULL;
	SpiceSlideManager* _tmp0_;
	SpiceCanvasItem* _tmp1_;
	SpiceCanvasItem* _tmp2_;
	SpiceCanvasItem* _tmp3_;
	SpiceCanvasItem* _tmp4_;
#line 398 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 399 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 399 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_slide_manager_get_current_item (_tmp0_);
#line 399 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = _tmp1_;
#line 399 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 399 "../Spice-up-1.9.1/src/Window.vala"
	current_item = _tmp3_;
#line 401 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = current_item;
#line 401 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp4_ != NULL) {
#line 1672 "Window.c"
		SpiceSlideManager* _tmp5_;
		SpiceCanvasItem* _tmp6_;
#line 402 "../Spice-up-1.9.1/src/Window.vala"
		_tmp5_ = self->priv->slide_manager;
#line 402 "../Spice-up-1.9.1/src/Window.vala"
		_tmp6_ = current_item;
#line 402 "../Spice-up-1.9.1/src/Window.vala"
		spice_clipboard_cut (_tmp5_, (GObject*) _tmp6_);
#line 1681 "Window.c"
	} else {
		SpiceSlideManager* _tmp7_;
		SpiceSlideManager* _tmp8_;
		SpiceSlide* _tmp9_;
		SpiceSlide* _tmp10_;
#line 404 "../Spice-up-1.9.1/src/Window.vala"
		_tmp7_ = self->priv->slide_manager;
#line 404 "../Spice-up-1.9.1/src/Window.vala"
		_tmp8_ = self->priv->slide_manager;
#line 404 "../Spice-up-1.9.1/src/Window.vala"
		_tmp9_ = spice_slide_manager_get_current_slide (_tmp8_);
#line 404 "../Spice-up-1.9.1/src/Window.vala"
		_tmp10_ = _tmp9_;
#line 404 "../Spice-up-1.9.1/src/Window.vala"
		spice_clipboard_cut (_tmp7_, (GObject*) _tmp10_);
#line 1697 "Window.c"
	}
#line 398 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (current_item);
#line 1701 "Window.c"
}

static void
spice_window_copy (SpiceWindow* self)
{
	SpiceCanvasItem* current_item = NULL;
	SpiceSlideManager* _tmp0_;
	SpiceCanvasItem* _tmp1_;
	SpiceCanvasItem* _tmp2_;
	SpiceCanvasItem* _tmp3_;
	SpiceCanvasItem* _tmp4_;
#line 409 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 410 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 410 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_slide_manager_get_current_item (_tmp0_);
#line 410 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = _tmp1_;
#line 410 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 410 "../Spice-up-1.9.1/src/Window.vala"
	current_item = _tmp3_;
#line 412 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = current_item;
#line 412 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp4_ != NULL) {
#line 1729 "Window.c"
		SpiceSlideManager* _tmp5_;
		SpiceCanvasItem* _tmp6_;
#line 413 "../Spice-up-1.9.1/src/Window.vala"
		_tmp5_ = self->priv->slide_manager;
#line 413 "../Spice-up-1.9.1/src/Window.vala"
		_tmp6_ = current_item;
#line 413 "../Spice-up-1.9.1/src/Window.vala"
		spice_clipboard_copy (_tmp5_, (GObject*) _tmp6_);
#line 1738 "Window.c"
	} else {
		SpiceSlideManager* _tmp7_;
		SpiceSlideManager* _tmp8_;
		SpiceSlide* _tmp9_;
		SpiceSlide* _tmp10_;
#line 415 "../Spice-up-1.9.1/src/Window.vala"
		_tmp7_ = self->priv->slide_manager;
#line 415 "../Spice-up-1.9.1/src/Window.vala"
		_tmp8_ = self->priv->slide_manager;
#line 415 "../Spice-up-1.9.1/src/Window.vala"
		_tmp9_ = spice_slide_manager_get_current_slide (_tmp8_);
#line 415 "../Spice-up-1.9.1/src/Window.vala"
		_tmp10_ = _tmp9_;
#line 415 "../Spice-up-1.9.1/src/Window.vala"
		spice_clipboard_copy (_tmp7_, (GObject*) _tmp10_);
#line 1754 "Window.c"
	}
#line 409 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (current_item);
#line 1758 "Window.c"
}

static void
spice_window_paste (SpiceWindow* self)
{
	SpiceSlideManager* _tmp0_;
#line 419 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 420 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 420 "../Spice-up-1.9.1/src/Window.vala"
	spice_clipboard_paste (_tmp0_);
#line 1771 "Window.c"
}

void
spice_window_delete_object (SpiceWindow* self)
{
	SpiceCanvasItem* current_item = NULL;
	SpiceSlideManager* _tmp0_;
	SpiceCanvasItem* _tmp1_;
	SpiceCanvasItem* _tmp2_;
	SpiceCanvasItem* _tmp3_;
	SpiceCanvasItem* _tmp4_;
#line 423 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 424 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 424 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_slide_manager_get_current_item (_tmp0_);
#line 424 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = _tmp1_;
#line 424 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 424 "../Spice-up-1.9.1/src/Window.vala"
	current_item = _tmp3_;
#line 426 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = current_item;
#line 426 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp4_ != NULL) {
#line 1799 "Window.c"
		SpiceCanvasItem* _tmp5_;
		SpiceSlideManager* _tmp6_;
		SpiceSlide* _tmp7_;
		SpiceSlide* _tmp8_;
		SpiceCanvas* _tmp9_;
#line 427 "../Spice-up-1.9.1/src/Window.vala"
		_tmp5_ = current_item;
#line 427 "../Spice-up-1.9.1/src/Window.vala"
		spice_clipboard_delete ((GObject*) _tmp5_);
#line 428 "../Spice-up-1.9.1/src/Window.vala"
		_tmp6_ = self->priv->slide_manager;
#line 428 "../Spice-up-1.9.1/src/Window.vala"
		_tmp7_ = spice_slide_manager_get_current_slide (_tmp6_);
#line 428 "../Spice-up-1.9.1/src/Window.vala"
		_tmp8_ = _tmp7_;
#line 428 "../Spice-up-1.9.1/src/Window.vala"
		_tmp9_ = _tmp8_->canvas;
#line 428 "../Spice-up-1.9.1/src/Window.vala"
		spice_canvas_unselect_all (_tmp9_, TRUE);
#line 1819 "Window.c"
	} else {
		SpiceSlideManager* _tmp10_;
		SpiceSlide* _tmp11_;
		SpiceSlide* _tmp12_;
#line 429 "../Spice-up-1.9.1/src/Window.vala"
		_tmp10_ = self->priv->slide_manager;
#line 429 "../Spice-up-1.9.1/src/Window.vala"
		_tmp11_ = spice_slide_manager_get_current_slide (_tmp10_);
#line 429 "../Spice-up-1.9.1/src/Window.vala"
		_tmp12_ = _tmp11_;
#line 429 "../Spice-up-1.9.1/src/Window.vala"
		if (_tmp12_ != NULL) {
#line 1832 "Window.c"
			SpiceSlideManager* _tmp13_;
			SpiceSlide* _tmp14_;
			SpiceSlide* _tmp15_;
#line 430 "../Spice-up-1.9.1/src/Window.vala"
			_tmp13_ = self->priv->slide_manager;
#line 430 "../Spice-up-1.9.1/src/Window.vala"
			_tmp14_ = spice_slide_manager_get_current_slide (_tmp13_);
#line 430 "../Spice-up-1.9.1/src/Window.vala"
			_tmp15_ = _tmp14_;
#line 430 "../Spice-up-1.9.1/src/Window.vala"
			spice_clipboard_delete ((GObject*) _tmp15_);
#line 1844 "Window.c"
		}
	}
#line 423 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (current_item);
#line 1849 "Window.c"
}

static void
spice_window_next_slide (SpiceWindow* self)
{
	SpiceSlideManager* _tmp0_;
#line 434 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 435 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 435 "../Spice-up-1.9.1/src/Window.vala"
	spice_slide_manager_next_slide (_tmp0_);
#line 1862 "Window.c"
}

static void
spice_window_previous_slide (SpiceWindow* self)
{
	SpiceSlideManager* _tmp0_;
#line 438 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 439 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 439 "../Spice-up-1.9.1/src/Window.vala"
	spice_slide_manager_previous_slide (_tmp0_);
#line 1875 "Window.c"
}

static void
___lambda75_ (SpiceWindow* self)
{
#line 446 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->notification_shown = FALSE;
#line 1883 "Window.c"
}

static void
____lambda75__granite_widgets_toast_closed (GraniteWidgetsToast* _sender,
                                            gpointer self)
{
#line 445 "../Spice-up-1.9.1/src/Window.vala"
	___lambda75_ ((SpiceWindow*) self);
#line 1892 "Window.c"
}

static void
___lambda76_ (SpiceWindow* self)
{
#line 450 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->notification_shown = FALSE;
#line 1900 "Window.c"
}

static void
____lambda76__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                    gpointer self)
{
#line 449 "../Spice-up-1.9.1/src/Window.vala"
	___lambda76_ ((SpiceWindow*) self);
#line 1909 "Window.c"
}

void
spice_window_add_toast_notification (SpiceWindow* self,
                                     GraniteWidgetsToast* toast)
{
	GraniteWidgetsToast* _tmp0_;
#line 442 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 442 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (toast != NULL);
#line 443 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->toast;
#line 443 "../Spice-up-1.9.1/src/Window.vala"
	if (toast != _tmp0_) {
#line 1925 "Window.c"
		GtkOverlay* _tmp1_;
		GtkOverlay* _tmp2_;
#line 444 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->toast = toast;
#line 445 "../Spice-up-1.9.1/src/Window.vala"
		g_signal_connect_object (toast, "closed", (GCallback) ____lambda75__granite_widgets_toast_closed, self, 0);
#line 449 "../Spice-up-1.9.1/src/Window.vala"
		g_signal_connect_object (toast, "default-action", (GCallback) ____lambda76__granite_widgets_toast_default_action, self, 0);
#line 453 "../Spice-up-1.9.1/src/Window.vala"
		_tmp1_ = self->priv->app_overlay;
#line 453 "../Spice-up-1.9.1/src/Window.vala"
		gtk_overlay_add_overlay (_tmp1_, (GtkWidget*) toast);
#line 454 "../Spice-up-1.9.1/src/Window.vala"
		_tmp2_ = self->priv->app_overlay;
#line 454 "../Spice-up-1.9.1/src/Window.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp2_);
#line 1942 "Window.c"
	}
#line 457 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->notification_shown = TRUE;
#line 458 "../Spice-up-1.9.1/src/Window.vala"
	granite_widgets_toast_send_notification (toast);
#line 1948 "Window.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1972 "Window.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 1980 "Window.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 1986 "Window.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 2014 "Window.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 2020 "Window.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 2026 "Window.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 2030 "Window.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 2038 "Window.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 2042 "Window.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 2054 "Window.c"
}

void
spice_window_open_file (SpiceWindow* self,
                        GFile* file)
{
	SpiceApplication* _tmp0_;
	SpiceApplication* _tmp1_;
	SpiceSlideManager* _tmp6_;
	SpiceServicesHistoryManager* _tmp7_;
	gchar* content = NULL;
	GFile* _tmp8_;
	gchar* _tmp9_;
	SpiceSlideManager* _tmp10_;
	const gchar* _tmp11_;
	SpiceHeaderbar* _tmp12_;
	GtkStack* _tmp13_;
	gchar* basename = NULL;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gint index_of_last_dot = 0;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* launcher_base = NULL;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	SpiceApplication* _tmp24_;
	SpiceApplication* _tmp25_;
	GFile* _tmp26_;
#line 461 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 461 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (file != NULL);
#line 462 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_save_current_file (self);
#line 464 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = spice_application_get_instance ();
#line 464 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = _tmp0_;
#line 464 "../Spice-up-1.9.1/src/Window.vala"
	if (spice_application_is_file_opened (_tmp1_, file)) {
#line 2096 "Window.c"
		SpiceApplication* _tmp2_;
		SpiceApplication* _tmp3_;
		SpiceWindow* _tmp4_;
		SpiceWindow* _tmp5_;
#line 465 "../Spice-up-1.9.1/src/Window.vala"
		_tmp2_ = spice_application_get_instance ();
#line 465 "../Spice-up-1.9.1/src/Window.vala"
		_tmp3_ = _tmp2_;
#line 465 "../Spice-up-1.9.1/src/Window.vala"
		_tmp4_ = spice_application_get_window_from_file (_tmp3_, file);
#line 465 "../Spice-up-1.9.1/src/Window.vala"
		_tmp5_ = _tmp4_;
#line 465 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_show_app (_tmp5_);
#line 465 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (_tmp5_);
#line 466 "../Spice-up-1.9.1/src/Window.vala"
		gtk_widget_destroy ((GtkWidget*) self);
#line 467 "../Spice-up-1.9.1/src/Window.vala"
		return;
#line 2117 "Window.c"
	}
#line 470 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_show_editor (self);
#line 472 "../Spice-up-1.9.1/src/Window.vala"
	_tmp6_ = self->priv->slide_manager;
#line 472 "../Spice-up-1.9.1/src/Window.vala"
	spice_slide_manager_reset (_tmp6_);
#line 473 "../Spice-up-1.9.1/src/Window.vala"
	_tmp7_ = self->priv->_history_manager;
#line 473 "../Spice-up-1.9.1/src/Window.vala"
	spice_services_history_manager_clear_history (_tmp7_);
#line 475 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_set_current_file (self, file);
#line 477 "../Spice-up-1.9.1/src/Window.vala"
	_tmp8_ = self->priv->_current_file;
#line 477 "../Spice-up-1.9.1/src/Window.vala"
	_tmp9_ = spice_services_file_manager_open_file (_tmp8_);
#line 477 "../Spice-up-1.9.1/src/Window.vala"
	content = _tmp9_;
#line 479 "../Spice-up-1.9.1/src/Window.vala"
	_tmp10_ = self->priv->slide_manager;
#line 479 "../Spice-up-1.9.1/src/Window.vala"
	_tmp11_ = content;
#line 479 "../Spice-up-1.9.1/src/Window.vala"
	spice_slide_manager_load_data (_tmp10_, _tmp11_);
#line 480 "../Spice-up-1.9.1/src/Window.vala"
	_tmp12_ = self->priv->headerbar;
#line 480 "../Spice-up-1.9.1/src/Window.vala"
	spice_headerbar_set_sensitive (_tmp12_, TRUE);
#line 481 "../Spice-up-1.9.1/src/Window.vala"
	_tmp13_ = self->priv->app_stack;
#line 481 "../Spice-up-1.9.1/src/Window.vala"
	gtk_stack_set_visible_child_name (_tmp13_, "application");
#line 483 "../Spice-up-1.9.1/src/Window.vala"
	_tmp14_ = self->priv->_current_file;
#line 483 "../Spice-up-1.9.1/src/Window.vala"
	_tmp15_ = g_file_get_basename (_tmp14_);
#line 483 "../Spice-up-1.9.1/src/Window.vala"
	basename = _tmp15_;
#line 485 "../Spice-up-1.9.1/src/Window.vala"
	_tmp16_ = basename;
#line 485 "../Spice-up-1.9.1/src/Window.vala"
	index_of_last_dot = string_last_index_of (_tmp16_, ".", 0);
#line 486 "../Spice-up-1.9.1/src/Window.vala"
	if (index_of_last_dot >= 0) {
#line 2163 "Window.c"
		const gchar* _tmp18_;
		gchar* _tmp19_;
#line 486 "../Spice-up-1.9.1/src/Window.vala"
		_tmp18_ = basename;
#line 486 "../Spice-up-1.9.1/src/Window.vala"
		_tmp19_ = string_slice (_tmp18_, (glong) 0, (glong) index_of_last_dot);
#line 486 "../Spice-up-1.9.1/src/Window.vala"
		_g_free0 (_tmp17_);
#line 486 "../Spice-up-1.9.1/src/Window.vala"
		_tmp17_ = _tmp19_;
#line 2174 "Window.c"
	} else {
		const gchar* _tmp20_;
		gchar* _tmp21_;
#line 486 "../Spice-up-1.9.1/src/Window.vala"
		_tmp20_ = basename;
#line 486 "../Spice-up-1.9.1/src/Window.vala"
		_tmp21_ = g_strdup (_tmp20_);
#line 486 "../Spice-up-1.9.1/src/Window.vala"
		_g_free0 (_tmp17_);
#line 486 "../Spice-up-1.9.1/src/Window.vala"
		_tmp17_ = _tmp21_;
#line 2186 "Window.c"
	}
#line 486 "../Spice-up-1.9.1/src/Window.vala"
	_tmp22_ = g_strdup (_tmp17_);
#line 486 "../Spice-up-1.9.1/src/Window.vala"
	launcher_base = _tmp22_;
#line 488 "../Spice-up-1.9.1/src/Window.vala"
	_tmp23_ = launcher_base;
#line 488 "../Spice-up-1.9.1/src/Window.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp23_);
#line 489 "../Spice-up-1.9.1/src/Window.vala"
	_tmp24_ = spice_application_get_instance ();
#line 489 "../Spice-up-1.9.1/src/Window.vala"
	_tmp25_ = _tmp24_;
#line 489 "../Spice-up-1.9.1/src/Window.vala"
	_tmp26_ = self->priv->_current_file;
#line 489 "../Spice-up-1.9.1/src/Window.vala"
	spice_application_register_file_to_window (_tmp25_, _tmp26_, self);
#line 461 "../Spice-up-1.9.1/src/Window.vala"
	_g_free0 (launcher_base);
#line 461 "../Spice-up-1.9.1/src/Window.vala"
	_g_free0 (_tmp17_);
#line 461 "../Spice-up-1.9.1/src/Window.vala"
	_g_free0 (basename);
#line 461 "../Spice-up-1.9.1/src/Window.vala"
	_g_free0 (content);
#line 2212 "Window.c"
}

void
spice_window_save_current_file (SpiceWindow* self)
{
	GFile* _tmp0_;
#line 492 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 493 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->_current_file;
#line 493 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp0_ != NULL) {
#line 2225 "Window.c"
		SpiceSlideManager* _tmp1_;
#line 494 "../Spice-up-1.9.1/src/Window.vala"
		_tmp1_ = self->priv->slide_manager;
#line 494 "../Spice-up-1.9.1/src/Window.vala"
		if (spice_slide_manager_slide_count (_tmp1_) == ((guint) 0)) {
#line 2231 "Window.c"
			GFile* _tmp2_;
#line 495 "../Spice-up-1.9.1/src/Window.vala"
			_tmp2_ = self->priv->_current_file;
#line 495 "../Spice-up-1.9.1/src/Window.vala"
			spice_services_file_manager_delete_file (_tmp2_);
#line 2237 "Window.c"
		} else {
			GFile* _tmp3_;
			SpiceSlideManager* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
#line 497 "../Spice-up-1.9.1/src/Window.vala"
			_tmp3_ = self->priv->_current_file;
#line 497 "../Spice-up-1.9.1/src/Window.vala"
			_tmp4_ = self->priv->slide_manager;
#line 497 "../Spice-up-1.9.1/src/Window.vala"
			_tmp5_ = spice_slide_manager_serialise (_tmp4_);
#line 497 "../Spice-up-1.9.1/src/Window.vala"
			_tmp6_ = _tmp5_;
#line 497 "../Spice-up-1.9.1/src/Window.vala"
			spice_services_file_manager_write_file (_tmp3_, _tmp6_);
#line 497 "../Spice-up-1.9.1/src/Window.vala"
			_g_free0 (_tmp6_);
#line 2255 "Window.c"
		}
	}
}

static gboolean
spice_window_real_delete_event (GtkWidget* base,
                                GdkEventAny* event)
{
	SpiceWindow * self;
	GFile* _tmp0_;
	gint width = 0;
	gint height = 0;
	gint x = 0;
	gint y = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	SpiceServicesSettings* _tmp8_;
	SpiceServicesSettings* _tmp9_;
	SpiceServicesSettings* _tmp10_;
	SpiceServicesSettings* _tmp11_;
	gboolean result;
#line 502 "../Spice-up-1.9.1/src/Window.vala"
	self = (SpiceWindow*) base;
#line 502 "../Spice-up-1.9.1/src/Window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 503 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->_current_file;
#line 503 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp0_ != NULL) {
#line 2287 "Window.c"
		SpiceApplication* _tmp1_;
		SpiceApplication* _tmp2_;
		GFile* _tmp3_;
#line 504 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_save_current_file (self);
#line 505 "../Spice-up-1.9.1/src/Window.vala"
		_tmp1_ = spice_application_get_instance ();
#line 505 "../Spice-up-1.9.1/src/Window.vala"
		_tmp2_ = _tmp1_;
#line 505 "../Spice-up-1.9.1/src/Window.vala"
		_tmp3_ = self->priv->_current_file;
#line 505 "../Spice-up-1.9.1/src/Window.vala"
		spice_application_unregister_file_from_window (_tmp2_, _tmp3_);
#line 2301 "Window.c"
	}
#line 510 "../Spice-up-1.9.1/src/Window.vala"
	gtk_window_get_size ((GtkWindow*) self, &_tmp4_, &_tmp5_);
#line 510 "../Spice-up-1.9.1/src/Window.vala"
	width = _tmp4_;
#line 510 "../Spice-up-1.9.1/src/Window.vala"
	height = _tmp5_;
#line 511 "../Spice-up-1.9.1/src/Window.vala"
	gtk_window_get_position ((GtkWindow*) self, &_tmp6_, &_tmp7_);
#line 511 "../Spice-up-1.9.1/src/Window.vala"
	x = _tmp6_;
#line 511 "../Spice-up-1.9.1/src/Window.vala"
	y = _tmp7_;
#line 513 "../Spice-up-1.9.1/src/Window.vala"
	_tmp8_ = spice_settings;
#line 513 "../Spice-up-1.9.1/src/Window.vala"
	spice_services_settings_set_pos_x (_tmp8_, x);
#line 514 "../Spice-up-1.9.1/src/Window.vala"
	_tmp9_ = spice_settings;
#line 514 "../Spice-up-1.9.1/src/Window.vala"
	spice_services_settings_set_pos_y (_tmp9_, y);
#line 515 "../Spice-up-1.9.1/src/Window.vala"
	_tmp10_ = spice_settings;
#line 515 "../Spice-up-1.9.1/src/Window.vala"
	spice_services_settings_set_window_width (_tmp10_, width);
#line 516 "../Spice-up-1.9.1/src/Window.vala"
	_tmp11_ = spice_settings;
#line 516 "../Spice-up-1.9.1/src/Window.vala"
	spice_services_settings_set_window_height (_tmp11_, height);
#line 518 "../Spice-up-1.9.1/src/Window.vala"
	result = FALSE;
#line 518 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 2335 "Window.c"
}

void
spice_window_show_app (SpiceWindow* self)
{
#line 521 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 522 "../Spice-up-1.9.1/src/Window.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 523 "../Spice-up-1.9.1/src/Window.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 524 "../Spice-up-1.9.1/src/Window.vala"
	gtk_window_present ((GtkWindow*) self);
#line 2349 "Window.c"
}

void
spice_window_enable_action_group (SpiceWindow* self,
                                  gchar** action_group,
                                  gint action_group_length1,
                                  gboolean enabled)
{
#line 527 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 2360 "Window.c"
	{
		gchar** action_collection = NULL;
		gint action_collection_length1 = 0;
		gint _action_collection_size_ = 0;
		gint action_it = 0;
#line 528 "../Spice-up-1.9.1/src/Window.vala"
		action_collection = action_group;
#line 528 "../Spice-up-1.9.1/src/Window.vala"
		action_collection_length1 = action_group_length1;
#line 528 "../Spice-up-1.9.1/src/Window.vala"
		for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
#line 2372 "Window.c"
			gchar* _tmp0_;
			gchar* action = NULL;
#line 528 "../Spice-up-1.9.1/src/Window.vala"
			_tmp0_ = g_strdup (action_collection[action_it]);
#line 528 "../Spice-up-1.9.1/src/Window.vala"
			action = _tmp0_;
#line 2379 "Window.c"
			{
				const gchar* _tmp1_;
				GSimpleActionGroup* _tmp2_;
#line 529 "../Spice-up-1.9.1/src/Window.vala"
				_tmp1_ = action;
#line 529 "../Spice-up-1.9.1/src/Window.vala"
				_tmp2_ = self->priv->_actions;
#line 529 "../Spice-up-1.9.1/src/Window.vala"
				spice_utils_set_action_enabled (_tmp1_, _tmp2_, enabled);
#line 528 "../Spice-up-1.9.1/src/Window.vala"
				_g_free0 (action);
#line 2391 "Window.c"
			}
		}
	}
}

void
spice_window_action_undo (SpiceWindow* self)
{
	SpiceServicesHistoryManager* _tmp0_;
	SpiceServicesHistoryManagerHistoryAction* _tmp1_;
	SpiceServicesHistoryManagerHistoryAction* _tmp2_;
#line 534 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 535 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->_history_manager;
#line 535 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_services_history_manager_undo (_tmp0_);
#line 535 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = _tmp1_;
#line 535 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (_tmp2_);
#line 2413 "Window.c"
}

void
spice_window_action_redo (SpiceWindow* self)
{
	SpiceServicesHistoryManager* _tmp0_;
	SpiceServicesHistoryManagerHistoryAction* _tmp1_;
	SpiceServicesHistoryManagerHistoryAction* _tmp2_;
#line 538 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 539 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->_history_manager;
#line 539 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_services_history_manager_redo (_tmp0_);
#line 539 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = _tmp1_;
#line 539 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (_tmp2_);
#line 2432 "Window.c"
}

void
spice_window_action_clone (SpiceWindow* self)
{
	SpiceCanvasItem* current_item = NULL;
	SpiceSlideManager* _tmp0_;
	SpiceCanvasItem* _tmp1_;
	SpiceCanvasItem* _tmp2_;
	SpiceCanvasItem* _tmp3_;
	SpiceCanvasItem* _tmp4_;
#line 542 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 543 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 543 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_slide_manager_get_current_item (_tmp0_);
#line 543 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = _tmp1_;
#line 543 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 543 "../Spice-up-1.9.1/src/Window.vala"
	current_item = _tmp3_;
#line 544 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = current_item;
#line 544 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp4_ != NULL) {
#line 2460 "Window.c"
		SpiceSlideManager* _tmp5_;
		SpiceCanvasItem* _tmp6_;
#line 545 "../Spice-up-1.9.1/src/Window.vala"
		_tmp5_ = self->priv->slide_manager;
#line 545 "../Spice-up-1.9.1/src/Window.vala"
		_tmp6_ = current_item;
#line 545 "../Spice-up-1.9.1/src/Window.vala"
		spice_clipboard_duplicate (_tmp5_, (GObject*) _tmp6_);
#line 2469 "Window.c"
	} else {
		SpiceSlideManager* _tmp7_;
		SpiceSlideManager* _tmp8_;
		SpiceSlide* _tmp9_;
		SpiceSlide* _tmp10_;
#line 547 "../Spice-up-1.9.1/src/Window.vala"
		_tmp7_ = self->priv->slide_manager;
#line 547 "../Spice-up-1.9.1/src/Window.vala"
		_tmp8_ = self->priv->slide_manager;
#line 547 "../Spice-up-1.9.1/src/Window.vala"
		_tmp9_ = spice_slide_manager_get_current_slide (_tmp8_);
#line 547 "../Spice-up-1.9.1/src/Window.vala"
		_tmp10_ = _tmp9_;
#line 547 "../Spice-up-1.9.1/src/Window.vala"
		spice_clipboard_duplicate (_tmp7_, (GObject*) _tmp10_);
#line 2485 "Window.c"
	}
#line 542 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (current_item);
#line 2489 "Window.c"
}

void
spice_window_action_present_toggle (SpiceWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 551 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 552 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = spice_window_get_is_presenting (self);
#line 552 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = _tmp0_;
#line 552 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_set_is_presenting (self, !_tmp1_);
#line 2505 "Window.c"
}

void
spice_window_action_toggle_notes (SpiceWindow* self)
{
	SpicePresenterNotes* _tmp0_;
	SpicePresenterNotes* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SpicePresenterNotes* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	SpiceHeaderbar* _tmp8_;
	SpicePresenterNotes* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
#line 555 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 556 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->presenter_notes;
#line 556 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = self->priv->presenter_notes;
#line 556 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = gtk_revealer_get_reveal_child ((GtkRevealer*) _tmp1_);
#line 556 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = _tmp2_;
#line 556 "../Spice-up-1.9.1/src/Window.vala"
	gtk_revealer_set_reveal_child ((GtkRevealer*) _tmp0_, !_tmp3_);
#line 558 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = self->priv->presenter_notes;
#line 558 "../Spice-up-1.9.1/src/Window.vala"
	_tmp5_ = gtk_revealer_get_reveal_child ((GtkRevealer*) _tmp4_);
#line 558 "../Spice-up-1.9.1/src/Window.vala"
	_tmp6_ = _tmp5_;
#line 558 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp6_) {
#line 2542 "Window.c"
		SpicePresenterNotes* _tmp7_;
#line 559 "../Spice-up-1.9.1/src/Window.vala"
		_tmp7_ = self->priv->presenter_notes;
#line 559 "../Spice-up-1.9.1/src/Window.vala"
		spice_presenter_notes_focus_notes (_tmp7_);
#line 2548 "Window.c"
	}
#line 562 "../Spice-up-1.9.1/src/Window.vala"
	_tmp8_ = self->priv->headerbar;
#line 562 "../Spice-up-1.9.1/src/Window.vala"
	_tmp9_ = self->priv->presenter_notes;
#line 562 "../Spice-up-1.9.1/src/Window.vala"
	_tmp10_ = gtk_revealer_get_reveal_child ((GtkRevealer*) _tmp9_);
#line 562 "../Spice-up-1.9.1/src/Window.vala"
	_tmp11_ = _tmp10_;
#line 562 "../Spice-up-1.9.1/src/Window.vala"
	spice_headerbar_set_notes_shown (_tmp8_, _tmp11_);
#line 2560 "Window.c"
}

void
spice_window_action_export (SpiceWindow* self)
{
	SpiceSlideManager* _tmp0_;
#line 565 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 566 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 566 "../Spice-up-1.9.1/src/Window.vala"
	spice_services_file_manager_export_to_pdf (_tmp0_);
#line 2573 "Window.c"
}

void
spice_window_action_new_slide (SpiceWindow* self)
{
	SpiceSlideManager* _tmp0_;
#line 569 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 570 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 570 "../Spice-up-1.9.1/src/Window.vala"
	spice_utils_new_slide (_tmp0_);
#line 2586 "Window.c"
}

static void
spice_window_insert_item_action (SpiceWindow* self,
                                 SpiceCanvasItemType type)
{
	SpiceCanvasItem* item = NULL;
	SpiceSlideManager* _tmp0_;
	SpiceCanvasItem* _tmp1_;
	SpiceCanvasItem* _tmp2_;
#line 573 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 574 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 574 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_slide_manager_request_new_item (_tmp0_, type);
#line 574 "../Spice-up-1.9.1/src/Window.vala"
	item = _tmp1_;
#line 576 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = item;
#line 576 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp2_ != NULL) {
#line 2609 "Window.c"
		SpiceDynamicToolbar* _tmp3_;
		SpiceCanvasItem* _tmp4_;
#line 577 "../Spice-up-1.9.1/src/Window.vala"
		_tmp3_ = self->priv->toolbar;
#line 577 "../Spice-up-1.9.1/src/Window.vala"
		_tmp4_ = item;
#line 577 "../Spice-up-1.9.1/src/Window.vala"
		spice_dynamic_toolbar_item_selected (_tmp3_, _tmp4_, TRUE);
#line 2618 "Window.c"
	}
#line 573 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (item);
#line 2622 "Window.c"
}

void
spice_window_action_insert_txt (SpiceWindow* self)
{
#line 581 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 582 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_insert_item_action (self, SPICE_CANVAS_ITEM_TYPE_TEXT);
#line 2632 "Window.c"
}

void
spice_window_action_insert_img (SpiceWindow* self)
{
#line 585 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 586 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_insert_item_action (self, SPICE_CANVAS_ITEM_TYPE_IMAGE);
#line 2642 "Window.c"
}

void
spice_window_action_insert_shape (SpiceWindow* self)
{
#line 589 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 590 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_insert_item_action (self, SPICE_CANVAS_ITEM_TYPE_SHAPE);
#line 2652 "Window.c"
}

void
spice_window_action_bring_fwd (SpiceWindow* self)
{
	SpiceSlideManager* _tmp0_;
#line 593 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 594 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 594 "../Spice-up-1.9.1/src/Window.vala"
	spice_slide_manager_move_up_request (_tmp0_);
#line 2665 "Window.c"
}

void
spice_window_action_send_bwd (SpiceWindow* self)
{
	SpiceSlideManager* _tmp0_;
#line 597 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 598 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->slide_manager;
#line 598 "../Spice-up-1.9.1/src/Window.vala"
	spice_slide_manager_move_down_request (_tmp0_);
#line 2678 "Window.c"
}

static gboolean
__lambda94_ (SpiceWindow* self)
{
	gboolean result;
#line 614 "../Spice-up-1.9.1/src/Window.vala"
	_g_free0 (self->priv->hide_id);
#line 614 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->hide_id = NULL;
#line 615 "../Spice-up-1.9.1/src/Window.vala"
	result = spice_window_hide_cursor (self, TRUE);
#line 615 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 2693 "Window.c"
}

static gboolean
___lambda94__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda94_ ((SpiceWindow*) self);
#line 613 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 2703 "Window.c"
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
#line 613 "../Spice-up-1.9.1/src/Window.vala"
	dup = g_new0 (guint, 1);
#line 613 "../Spice-up-1.9.1/src/Window.vala"
	memcpy (dup, self, sizeof (guint));
#line 613 "../Spice-up-1.9.1/src/Window.vala"
	return dup;
#line 2716 "Window.c"
}

static gpointer
__uint_dup0 (gpointer self)
{
#line 613 "../Spice-up-1.9.1/src/Window.vala"
	return self ? _uint_dup (self) : NULL;
#line 2724 "Window.c"
}

static gboolean
spice_window_request_to_hide_mouse (SpiceWindow* self,
                                    GdkEvent* event)
{
	guint* _tmp0_;
	guint _tmp2_;
	guint* _tmp3_;
	gboolean result;
#line 604 "../Spice-up-1.9.1/src/Window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 605 "../Spice-up-1.9.1/src/Window.vala"
	if (self->priv->cursor_hidden) {
#line 606 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_hide_cursor (self, FALSE);
#line 2741 "Window.c"
	}
#line 609 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->hide_id;
#line 609 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp0_ != NULL) {
#line 2747 "Window.c"
		guint* _tmp1_;
#line 610 "../Spice-up-1.9.1/src/Window.vala"
		_tmp1_ = self->priv->hide_id;
#line 610 "../Spice-up-1.9.1/src/Window.vala"
		g_source_remove (*_tmp1_);
#line 2753 "Window.c"
	}
#line 613 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 3000, ___lambda94__gsource_func, g_object_ref (self), g_object_unref);
#line 613 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = __uint_dup0 (&_tmp2_);
#line 613 "../Spice-up-1.9.1/src/Window.vala"
	_g_free0 (self->priv->hide_id);
#line 613 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->hide_id = _tmp3_;
#line 618 "../Spice-up-1.9.1/src/Window.vala"
	result = FALSE;
#line 618 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 2767 "Window.c"
}

static gboolean
spice_window_hide_cursor (SpiceWindow* self,
                          gboolean hide)
{
	guint* _tmp0_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp2_;
	GdkDisplay* _tmp3_;
	GdkCursorType _tmp4_ = 0;
	GdkCursor* cursor = NULL;
	GdkDisplay* _tmp5_;
	GdkCursor* _tmp6_;
	GdkWindow* _tmp7_;
	gboolean result;
#line 621 "../Spice-up-1.9.1/src/Window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 622 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->hide_id;
#line 622 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp0_ != NULL) {
#line 2790 "Window.c"
		guint* _tmp1_;
#line 623 "../Spice-up-1.9.1/src/Window.vala"
		_tmp1_ = self->priv->hide_id;
#line 623 "../Spice-up-1.9.1/src/Window.vala"
		g_source_remove (*_tmp1_);
#line 624 "../Spice-up-1.9.1/src/Window.vala"
		_g_free0 (self->priv->hide_id);
#line 624 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->hide_id = NULL;
#line 2800 "Window.c"
	}
#line 627 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = gtk_widget_get_display ((GtkWidget*) self);
#line 627 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 627 "../Spice-up-1.9.1/src/Window.vala"
	display = _tmp3_;
#line 628 "../Spice-up-1.9.1/src/Window.vala"
	if (hide) {
#line 628 "../Spice-up-1.9.1/src/Window.vala"
		_tmp4_ = GDK_BLANK_CURSOR;
#line 2812 "Window.c"
	} else {
#line 628 "../Spice-up-1.9.1/src/Window.vala"
		_tmp4_ = GDK_ARROW;
#line 2816 "Window.c"
	}
#line 628 "../Spice-up-1.9.1/src/Window.vala"
	_tmp5_ = display;
#line 628 "../Spice-up-1.9.1/src/Window.vala"
	_tmp6_ = gdk_cursor_new_for_display (_tmp5_, _tmp4_);
#line 628 "../Spice-up-1.9.1/src/Window.vala"
	cursor = _tmp6_;
#line 629 "../Spice-up-1.9.1/src/Window.vala"
	_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
#line 629 "../Spice-up-1.9.1/src/Window.vala"
	gdk_window_set_cursor (_tmp7_, cursor);
#line 630 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->cursor_hidden = hide;
#line 631 "../Spice-up-1.9.1/src/Window.vala"
	result = G_SOURCE_REMOVE;
#line 631 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (cursor);
#line 631 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (display);
#line 631 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 2838 "Window.c"
}

gboolean
spice_window_get_is_presenting (SpiceWindow* self)
{
	gboolean result;
#line 31 "../Spice-up-1.9.1/src/Window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 32 "../Spice-up-1.9.1/src/Window.vala"
	result = self->priv->is_full_;
#line 32 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 2851 "Window.c"
}

static gboolean
_spice_window_request_to_hide_mouse_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                    GdkEventMotion* event,
                                                                    gpointer self)
{
	gboolean result;
	result = spice_window_request_to_hide_mouse ((SpiceWindow*) self, event);
#line 70 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 2863 "Window.c"
}

void
spice_window_set_is_presenting (SpiceWindow* self,
                                gboolean value)
{
	gint _tmp27_ = 0;
	GtkAspectFrame* _tmp28_;
	GtkRevealer* _tmp29_;
	GtkRevealer* _tmp30_;
	GtkRevealer* _tmp31_;
	SpiceHeaderbar* _tmp32_;
	SpicePresenterNotes* _tmp33_;
	SpiceSlideManager* _tmp34_;
	gboolean _tmp35_ = FALSE;
	GraniteWidgetsToast* _tmp36_;
	SpiceSlideManager* _tmp38_;
	SpiceSlide* _tmp39_;
	SpiceSlide* _tmp40_;
#line 33 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 34 "../Spice-up-1.9.1/src/Window.vala"
	if (value == self->priv->is_full_) {
#line 34 "../Spice-up-1.9.1/src/Window.vala"
		return;
#line 2889 "Window.c"
	}
#line 36 "../Spice-up-1.9.1/src/Window.vala"
	if (value) {
#line 2893 "Window.c"
		GdkScreen* screen = NULL;
		GdkScreen* _tmp0_;
		GdkScreen* _tmp1_;
		gint monitor_count = 0;
		GdkScreen* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 38 "../Spice-up-1.9.1/src/Window.vala"
		_tmp0_ = gdk_screen_get_default ();
#line 38 "../Spice-up-1.9.1/src/Window.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 38 "../Spice-up-1.9.1/src/Window.vala"
		screen = _tmp1_;
#line 39 "../Spice-up-1.9.1/src/Window.vala"
		_tmp2_ = screen;
#line 39 "../Spice-up-1.9.1/src/Window.vala"
		monitor_count = gdk_screen_get_n_monitors (_tmp2_);
#line 40 "../Spice-up-1.9.1/src/Window.vala"
		gtk_window_get_position ((GtkWindow*) self, &_tmp3_, &_tmp4_);
#line 40 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->old_x = _tmp3_;
#line 40 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->old_y = _tmp4_;
#line 42 "../Spice-up-1.9.1/src/Window.vala"
		gtk_window_fullscreen ((GtkWindow*) self);
#line 44 "../Spice-up-1.9.1/src/Window.vala"
		if (monitor_count > 1) {
#line 2921 "Window.c"
			SpiceSlideManager* _tmp5_;
			SpicePresenterWindow* _tmp6_;
			SpicePresenterWindow* _tmp7_;
			gint primary_monitor = 0;
			GdkScreen* _tmp8_;
			GdkRectangle rec = {0};
			gint _tmp9_ = 0;
			GdkScreen* _tmp10_;
			GdkRectangle _tmp11_ = {0};
			GdkRectangle _tmp12_;
			GdkRectangle _tmp13_;
#line 45 "../Spice-up-1.9.1/src/Window.vala"
			_tmp5_ = self->priv->slide_manager;
#line 45 "../Spice-up-1.9.1/src/Window.vala"
			_tmp6_ = spice_presenter_window_new (_tmp5_, self);
#line 45 "../Spice-up-1.9.1/src/Window.vala"
			g_object_ref_sink (_tmp6_);
#line 45 "../Spice-up-1.9.1/src/Window.vala"
			_g_object_unref0 (self->priv->presenter_window);
#line 45 "../Spice-up-1.9.1/src/Window.vala"
			self->priv->presenter_window = _tmp6_;
#line 46 "../Spice-up-1.9.1/src/Window.vala"
			_tmp7_ = self->priv->presenter_window;
#line 46 "../Spice-up-1.9.1/src/Window.vala"
			gtk_widget_show ((GtkWidget*) _tmp7_);
#line 48 "../Spice-up-1.9.1/src/Window.vala"
			_tmp8_ = screen;
#line 48 "../Spice-up-1.9.1/src/Window.vala"
			primary_monitor = gdk_screen_get_primary_monitor (_tmp8_);
#line 51 "../Spice-up-1.9.1/src/Window.vala"
			if (primary_monitor == 1) {
#line 51 "../Spice-up-1.9.1/src/Window.vala"
				_tmp9_ = 0;
#line 2955 "Window.c"
			} else {
#line 51 "../Spice-up-1.9.1/src/Window.vala"
				_tmp9_ = 1;
#line 2959 "Window.c"
			}
#line 51 "../Spice-up-1.9.1/src/Window.vala"
			_tmp10_ = screen;
#line 51 "../Spice-up-1.9.1/src/Window.vala"
			gdk_screen_get_monitor_geometry (_tmp10_, _tmp9_, &_tmp11_);
#line 51 "../Spice-up-1.9.1/src/Window.vala"
			rec = _tmp11_;
#line 53 "../Spice-up-1.9.1/src/Window.vala"
			_tmp12_ = rec;
#line 53 "../Spice-up-1.9.1/src/Window.vala"
			_tmp13_ = rec;
#line 53 "../Spice-up-1.9.1/src/Window.vala"
			gtk_window_move ((GtkWindow*) self, _tmp12_.x, _tmp13_.y);
#line 2973 "Window.c"
		} else {
#line 54 "../Spice-up-1.9.1/src/Window.vala"
			if (DEBUG) {
#line 2977 "Window.c"
				SpiceSlideManager* _tmp14_;
				SpicePresenterWindow* _tmp15_;
				SpicePresenterWindow* _tmp16_;
#line 55 "../Spice-up-1.9.1/src/Window.vala"
				_tmp14_ = self->priv->slide_manager;
#line 55 "../Spice-up-1.9.1/src/Window.vala"
				_tmp15_ = spice_presenter_window_new (_tmp14_, self);
#line 55 "../Spice-up-1.9.1/src/Window.vala"
				g_object_ref_sink (_tmp15_);
#line 55 "../Spice-up-1.9.1/src/Window.vala"
				_g_object_unref0 (self->priv->presenter_window);
#line 55 "../Spice-up-1.9.1/src/Window.vala"
				self->priv->presenter_window = _tmp15_;
#line 56 "../Spice-up-1.9.1/src/Window.vala"
				_tmp16_ = self->priv->presenter_window;
#line 56 "../Spice-up-1.9.1/src/Window.vala"
				gtk_widget_show ((GtkWidget*) _tmp16_);
#line 2995 "Window.c"
			}
		}
#line 59 "../Spice-up-1.9.1/src/Window.vala"
		if (self->priv->inhibit_token == ((guint) 0)) {
#line 3000 "Window.c"
			GtkApplication* _tmp17_;
			GtkApplication* _tmp18_;
			GtkApplication* _tmp19_;
			GtkApplication* _tmp20_;
			GtkWindow* _tmp21_;
#line 60 "../Spice-up-1.9.1/src/Window.vala"
			_tmp17_ = gtk_window_get_application ((GtkWindow*) self);
#line 60 "../Spice-up-1.9.1/src/Window.vala"
			_tmp18_ = _tmp17_;
#line 60 "../Spice-up-1.9.1/src/Window.vala"
			_tmp19_ = gtk_window_get_application ((GtkWindow*) self);
#line 60 "../Spice-up-1.9.1/src/Window.vala"
			_tmp20_ = _tmp19_;
#line 60 "../Spice-up-1.9.1/src/Window.vala"
			_tmp21_ = gtk_application_get_active_window (_tmp20_);
#line 60 "../Spice-up-1.9.1/src/Window.vala"
			self->priv->inhibit_token = gtk_application_inhibit (_tmp18_, _tmp21_, GTK_APPLICATION_INHIBIT_IDLE | GTK_APPLICATION_INHIBIT_SUSPEND, _ ("Spice-Up Presentation"));
#line 3018 "Window.c"
		}
#line 67 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_enable_action_group (self, SPICE_WINDOW_editing_actions, (gint) G_N_ELEMENTS (SPICE_WINDOW_editing_actions), FALSE);
#line 68 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_enable_action_group (self, SPICE_WINDOW_presenting_actions, (gint) G_N_ELEMENTS (SPICE_WINDOW_presenting_actions), TRUE);
#line 70 "../Spice-up-1.9.1/src/Window.vala"
		g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _spice_window_request_to_hide_mouse_gtk_widget_motion_notify_event, self, 0);
#line 71 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_request_to_hide_mouse (self, NULL);
#line 36 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (screen);
#line 3030 "Window.c"
	} else {
		SpicePresenterWindow* _tmp22_;
		guint _tmp26_;
#line 73 "../Spice-up-1.9.1/src/Window.vala"
		gtk_window_unfullscreen ((GtkWindow*) self);
#line 74 "../Spice-up-1.9.1/src/Window.vala"
		gtk_window_move ((GtkWindow*) self, self->priv->old_x, self->priv->old_y);
#line 76 "../Spice-up-1.9.1/src/Window.vala"
		_tmp22_ = self->priv->presenter_window;
#line 76 "../Spice-up-1.9.1/src/Window.vala"
		if (_tmp22_ != NULL) {
#line 3042 "Window.c"
			SpicePresenterWindow* _tmp23_;
#line 77 "../Spice-up-1.9.1/src/Window.vala"
			_tmp23_ = self->priv->presenter_window;
#line 77 "../Spice-up-1.9.1/src/Window.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp23_);
#line 78 "../Spice-up-1.9.1/src/Window.vala"
			_g_object_unref0 (self->priv->presenter_window);
#line 78 "../Spice-up-1.9.1/src/Window.vala"
			self->priv->presenter_window = NULL;
#line 3052 "Window.c"
		}
#line 81 "../Spice-up-1.9.1/src/Window.vala"
		if (self->priv->inhibit_token != ((guint) 0)) {
#line 3056 "Window.c"
			GtkApplication* _tmp24_;
			GtkApplication* _tmp25_;
#line 82 "../Spice-up-1.9.1/src/Window.vala"
			_tmp24_ = gtk_window_get_application ((GtkWindow*) self);
#line 82 "../Spice-up-1.9.1/src/Window.vala"
			_tmp25_ = _tmp24_;
#line 82 "../Spice-up-1.9.1/src/Window.vala"
			gtk_application_uninhibit (_tmp25_, self->priv->inhibit_token);
#line 83 "../Spice-up-1.9.1/src/Window.vala"
			self->priv->inhibit_token = (guint) 0;
#line 3067 "Window.c"
		}
#line 86 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_enable_action_group (self, SPICE_WINDOW_editing_actions, (gint) G_N_ELEMENTS (SPICE_WINDOW_editing_actions), TRUE);
#line 87 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_enable_action_group (self, SPICE_WINDOW_presenting_actions, (gint) G_N_ELEMENTS (SPICE_WINDOW_presenting_actions), FALSE);
#line 88 "../Spice-up-1.9.1/src/Window.vala"
		g_signal_parse_name ("motion-notify-event", gtk_widget_get_type (), &_tmp26_, NULL, FALSE);
#line 88 "../Spice-up-1.9.1/src/Window.vala"
		g_signal_handlers_disconnect_matched ((GtkWidget*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp26_, 0, NULL, (GCallback) _spice_window_request_to_hide_mouse_gtk_widget_motion_notify_event, self);
#line 89 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_hide_cursor (self, FALSE);
#line 3079 "Window.c"
	}
#line 92 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->is_full_ = value;
#line 93 "../Spice-up-1.9.1/src/Window.vala"
	if (value) {
#line 93 "../Spice-up-1.9.1/src/Window.vala"
		_tmp27_ = 0;
#line 3087 "Window.c"
	} else {
#line 93 "../Spice-up-1.9.1/src/Window.vala"
		_tmp27_ = 24;
#line 3091 "Window.c"
	}
#line 93 "../Spice-up-1.9.1/src/Window.vala"
	_tmp28_ = self->priv->aspect_frame;
#line 93 "../Spice-up-1.9.1/src/Window.vala"
	g_object_set ((GtkWidget*) _tmp28_, "margin", _tmp27_, NULL);
#line 95 "../Spice-up-1.9.1/src/Window.vala"
	_tmp29_ = self->priv->sidebar_revealer;
#line 95 "../Spice-up-1.9.1/src/Window.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp29_, !value);
#line 96 "../Spice-up-1.9.1/src/Window.vala"
	_tmp30_ = self->priv->sidebar_revealer;
#line 96 "../Spice-up-1.9.1/src/Window.vala"
	gtk_revealer_set_reveal_child (_tmp30_, !value);
#line 97 "../Spice-up-1.9.1/src/Window.vala"
	_tmp31_ = self->priv->toolbar_revealer;
#line 97 "../Spice-up-1.9.1/src/Window.vala"
	gtk_revealer_set_reveal_child (_tmp31_, !value);
#line 98 "../Spice-up-1.9.1/src/Window.vala"
	_tmp32_ = self->priv->headerbar;
#line 98 "../Spice-up-1.9.1/src/Window.vala"
	spice_headerbar_set_is_presenting (_tmp32_, value);
#line 99 "../Spice-up-1.9.1/src/Window.vala"
	_tmp33_ = self->priv->presenter_notes;
#line 99 "../Spice-up-1.9.1/src/Window.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp33_, !value);
#line 100 "../Spice-up-1.9.1/src/Window.vala"
	_tmp34_ = self->priv->slide_manager;
#line 100 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (_tmp34_->checkpoint);
#line 100 "../Spice-up-1.9.1/src/Window.vala"
	_tmp34_->checkpoint = NULL;
#line 102 "../Spice-up-1.9.1/src/Window.vala"
	_tmp36_ = self->priv->toast;
#line 102 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp36_ != NULL) {
#line 102 "../Spice-up-1.9.1/src/Window.vala"
		_tmp35_ = self->priv->notification_shown;
#line 3129 "Window.c"
	} else {
#line 102 "../Spice-up-1.9.1/src/Window.vala"
		_tmp35_ = FALSE;
#line 3133 "Window.c"
	}
#line 102 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp35_) {
#line 3137 "Window.c"
		GraniteWidgetsToast* _tmp37_;
#line 103 "../Spice-up-1.9.1/src/Window.vala"
		_tmp37_ = self->priv->toast;
#line 103 "../Spice-up-1.9.1/src/Window.vala"
		gtk_revealer_set_reveal_child ((GtkRevealer*) _tmp37_, !value);
#line 3143 "Window.c"
	}
#line 106 "../Spice-up-1.9.1/src/Window.vala"
	_tmp38_ = self->priv->slide_manager;
#line 106 "../Spice-up-1.9.1/src/Window.vala"
	_tmp39_ = spice_slide_manager_get_current_slide (_tmp38_);
#line 106 "../Spice-up-1.9.1/src/Window.vala"
	_tmp40_ = _tmp39_;
#line 106 "../Spice-up-1.9.1/src/Window.vala"
	if (_tmp40_ != NULL) {
#line 3153 "Window.c"
		SpiceSlideManager* _tmp41_;
		SpiceSlide* _tmp42_;
		SpiceSlide* _tmp43_;
		SpiceCanvas* _tmp44_;
#line 107 "../Spice-up-1.9.1/src/Window.vala"
		_tmp41_ = self->priv->slide_manager;
#line 107 "../Spice-up-1.9.1/src/Window.vala"
		_tmp42_ = spice_slide_manager_get_current_slide (_tmp41_);
#line 107 "../Spice-up-1.9.1/src/Window.vala"
		_tmp43_ = _tmp42_;
#line 107 "../Spice-up-1.9.1/src/Window.vala"
		_tmp44_ = _tmp43_->canvas;
#line 107 "../Spice-up-1.9.1/src/Window.vala"
		spice_canvas_unselect_all (_tmp44_, TRUE);
#line 3168 "Window.c"
	}
#line 110 "../Spice-up-1.9.1/src/Window.vala"
	if (!value) {
#line 3172 "Window.c"
		SpiceSlideManager* _tmp45_;
#line 111 "../Spice-up-1.9.1/src/Window.vala"
		_tmp45_ = self->priv->slide_manager;
#line 111 "../Spice-up-1.9.1/src/Window.vala"
		spice_slide_manager_end_presentation (_tmp45_);
#line 3178 "Window.c"
	}
#line 33 "../Spice-up-1.9.1/src/Window.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_window_properties[SPICE_WINDOW_IS_PRESENTING_PROPERTY]);
#line 3182 "Window.c"
}

SpiceServicesHistoryManager*
spice_window_get_history_manager (SpiceWindow* self)
{
	SpiceServicesHistoryManager* result;
	SpiceServicesHistoryManager* _tmp0_;
#line 136 "../Spice-up-1.9.1/src/Window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 136 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->_history_manager;
#line 136 "../Spice-up-1.9.1/src/Window.vala"
	result = _tmp0_;
#line 136 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 3198 "Window.c"
}

static void
spice_window_set_history_manager (SpiceWindow* self,
                                  SpiceServicesHistoryManager* value)
{
	SpiceServicesHistoryManager* old_value;
#line 136 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 136 "../Spice-up-1.9.1/src/Window.vala"
	old_value = spice_window_get_history_manager (self);
#line 136 "../Spice-up-1.9.1/src/Window.vala"
	if (old_value != value) {
#line 3212 "Window.c"
		SpiceServicesHistoryManager* _tmp0_;
#line 136 "../Spice-up-1.9.1/src/Window.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 136 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->_history_manager);
#line 136 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->_history_manager = _tmp0_;
#line 136 "../Spice-up-1.9.1/src/Window.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_window_properties[SPICE_WINDOW_HISTORY_MANAGER_PROPERTY]);
#line 3222 "Window.c"
	}
}

GFile*
spice_window_get_current_file (SpiceWindow* self)
{
	GFile* result;
	GFile* _tmp0_;
#line 137 "../Spice-up-1.9.1/src/Window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 137 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->_current_file;
#line 137 "../Spice-up-1.9.1/src/Window.vala"
	result = _tmp0_;
#line 137 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 3239 "Window.c"
}

static void
spice_window_set_current_file (SpiceWindow* self,
                               GFile* value)
{
	GFile* old_value;
#line 137 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 137 "../Spice-up-1.9.1/src/Window.vala"
	old_value = spice_window_get_current_file (self);
#line 137 "../Spice-up-1.9.1/src/Window.vala"
	if (old_value != value) {
#line 3253 "Window.c"
		GFile* _tmp0_;
#line 137 "../Spice-up-1.9.1/src/Window.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 137 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->_current_file);
#line 137 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->_current_file = _tmp0_;
#line 137 "../Spice-up-1.9.1/src/Window.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_window_properties[SPICE_WINDOW_CURRENT_FILE_PROPERTY]);
#line 3263 "Window.c"
	}
}

GSimpleActionGroup*
spice_window_get_actions (SpiceWindow* self)
{
	GSimpleActionGroup* result;
	GSimpleActionGroup* _tmp0_;
#line 139 "../Spice-up-1.9.1/src/Window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 139 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = self->priv->_actions;
#line 139 "../Spice-up-1.9.1/src/Window.vala"
	result = _tmp0_;
#line 139 "../Spice-up-1.9.1/src/Window.vala"
	return result;
#line 3280 "Window.c"
}

static void
spice_window_set_actions (SpiceWindow* self,
                          GSimpleActionGroup* value)
{
	GSimpleActionGroup* old_value;
#line 139 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (self != NULL);
#line 139 "../Spice-up-1.9.1/src/Window.vala"
	old_value = spice_window_get_actions (self);
#line 139 "../Spice-up-1.9.1/src/Window.vala"
	if (old_value != value) {
#line 3294 "Window.c"
		GSimpleActionGroup* _tmp0_;
#line 139 "../Spice-up-1.9.1/src/Window.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 139 "../Spice-up-1.9.1/src/Window.vala"
		_g_object_unref0 (self->priv->_actions);
#line 139 "../Spice-up-1.9.1/src/Window.vala"
		self->priv->_actions = _tmp0_;
#line 139 "../Spice-up-1.9.1/src/Window.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_window_properties[SPICE_WINDOW_ACTIONS_PROPERTY]);
#line 3304 "Window.c"
	}
}

static void
_spice_window___lambda143_ (SpiceWindow* self,
                            GFile* file)
{
#line 290 "../Spice-up-1.9.1/src/Window.vala"
	g_return_if_fail (file != NULL);
#line 291 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_open_file (self, file);
#line 3316 "Window.c"
}

static void
__spice_window___lambda143__spice_welcome_open_file (SpiceWelcome* _sender,
                                                     GFile* file,
                                                     gpointer self)
{
#line 290 "../Spice-up-1.9.1/src/Window.vala"
	_spice_window___lambda143_ ((SpiceWindow*) self, file);
#line 3326 "Window.c"
}

static GObject *
spice_window_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpiceWindow * self;
	SpiceServicesHistoryManager* _tmp0_;
	SpiceServicesHistoryManager* _tmp1_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp2_;
	GtkCssProvider* _tmp3_;
	GdkScreen* _tmp4_;
	GtkCssProvider* _tmp5_;
	SpiceSlideManager* _tmp6_;
	GtkOverlay* _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	GtkStack* _tmp10_;
	GtkOverlay* _tmp11_;
	GtkStack* _tmp12_;
	GtkOverlay* _tmp13_;
	SpiceSlideManager* _tmp14_;
	SpiceWelcome* _tmp15_;
	SpiceWelcome* _tmp16_;
	GtkStack* _tmp17_;
	SpiceWelcome* _tmp18_;
#line 270 "../Spice-up-1.9.1/src/Window.vala"
	parent_class = G_OBJECT_CLASS (spice_window_parent_class);
#line 270 "../Spice-up-1.9.1/src/Window.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 270 "../Spice-up-1.9.1/src/Window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_WINDOW, SpiceWindow);
#line 271 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = spice_services_history_manager_new ();
#line 271 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = _tmp0_;
#line 271 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_set_history_manager (self, _tmp1_);
#line 271 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (_tmp1_);
#line 273 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = gtk_css_provider_new ();
#line 273 "../Spice-up-1.9.1/src/Window.vala"
	provider = _tmp2_;
#line 274 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = provider;
#line 274 "../Spice-up-1.9.1/src/Window.vala"
	gtk_css_provider_load_from_resource (_tmp3_, "/com/github/philip-scott/spice-up/stylesheet.css");
#line 275 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = gdk_screen_get_default ();
#line 275 "../Spice-up-1.9.1/src/Window.vala"
	_tmp5_ = provider;
#line 275 "../Spice-up-1.9.1/src/Window.vala"
	gtk_style_context_add_provider_for_screen (_tmp4_, (GtkStyleProvider*) _tmp5_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 277 "../Spice-up-1.9.1/src/Window.vala"
	_tmp6_ = spice_slide_manager_new (self);
#line 277 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->slide_manager);
#line 277 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->slide_manager = _tmp6_;
#line 278 "../Spice-up-1.9.1/src/Window.vala"
	_tmp7_ = (GtkOverlay*) gtk_overlay_new ();
#line 278 "../Spice-up-1.9.1/src/Window.vala"
	g_object_ref_sink (_tmp7_);
#line 278 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->app_overlay);
#line 278 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->app_overlay = _tmp7_;
#line 279 "../Spice-up-1.9.1/src/Window.vala"
	_tmp8_ = (GtkStack*) gtk_stack_new ();
#line 279 "../Spice-up-1.9.1/src/Window.vala"
	g_object_ref_sink (_tmp8_);
#line 279 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->app_stack);
#line 279 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->app_stack = _tmp8_;
#line 280 "../Spice-up-1.9.1/src/Window.vala"
	_tmp9_ = self->priv->app_stack;
#line 280 "../Spice-up-1.9.1/src/Window.vala"
	gtk_stack_set_transition_duration (_tmp9_, (guint) 500);
#line 281 "../Spice-up-1.9.1/src/Window.vala"
	_tmp10_ = self->priv->app_stack;
#line 281 "../Spice-up-1.9.1/src/Window.vala"
	gtk_stack_set_homogeneous (_tmp10_, FALSE);
#line 283 "../Spice-up-1.9.1/src/Window.vala"
	_tmp11_ = self->priv->app_overlay;
#line 283 "../Spice-up-1.9.1/src/Window.vala"
	_tmp12_ = self->priv->app_stack;
#line 283 "../Spice-up-1.9.1/src/Window.vala"
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
#line 284 "../Spice-up-1.9.1/src/Window.vala"
	_tmp13_ = self->priv->app_overlay;
#line 284 "../Spice-up-1.9.1/src/Window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
#line 286 "../Spice-up-1.9.1/src/Window.vala"
	_tmp14_ = self->priv->slide_manager;
#line 286 "../Spice-up-1.9.1/src/Window.vala"
	spice_gamepad_slide_controller_startup (_tmp14_, self);
#line 288 "../Spice-up-1.9.1/src/Window.vala"
	_tmp15_ = spice_welcome_new ();
#line 288 "../Spice-up-1.9.1/src/Window.vala"
	g_object_ref_sink (_tmp15_);
#line 288 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->welcome);
#line 288 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->welcome = _tmp15_;
#line 290 "../Spice-up-1.9.1/src/Window.vala"
	_tmp16_ = self->priv->welcome;
#line 290 "../Spice-up-1.9.1/src/Window.vala"
	g_signal_connect_object (_tmp16_, "open-file", (GCallback) __spice_window___lambda143__spice_welcome_open_file, self, 0);
#line 294 "../Spice-up-1.9.1/src/Window.vala"
	_tmp17_ = self->priv->app_stack;
#line 294 "../Spice-up-1.9.1/src/Window.vala"
	_tmp18_ = self->priv->welcome;
#line 294 "../Spice-up-1.9.1/src/Window.vala"
	gtk_stack_add_named (_tmp17_, (GtkWidget*) _tmp18_, "welcome");
#line 270 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (provider);
#line 270 "../Spice-up-1.9.1/src/Window.vala"
	return obj;
#line 3451 "Window.c"
}

static void
spice_window_class_init (SpiceWindowClass * klass,
                         gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	GeeMultiMap* _tmp6_;
	GeeMultiMap* _tmp7_;
	GeeMultiMap* _tmp8_;
	GeeMultiMap* _tmp9_;
	GeeMultiMap* _tmp10_;
	GeeMultiMap* _tmp11_;
	GeeMultiMap* _tmp12_;
	GeeMultiMap* _tmp13_;
	GeeMultiMap* _tmp14_;
	GeeMultiMap* _tmp15_;
	GeeMultiMap* _tmp16_;
	GeeMultiMap* _tmp17_;
	GeeMultiMap* _tmp18_;
	GeeMultiMap* _tmp19_;
	GeeMultiMap* _tmp20_;
	GeeMultiMap* _tmp21_;
	GeeMultiMap* _tmp22_;
	GeeMultiMap* _tmp23_;
	GeeMultiMap* _tmp24_;
	GeeMultiMap* _tmp25_;
	GeeMultiMap* _tmp26_;
	GeeMultiMap* _tmp27_;
	GeeMultiMap* _tmp28_;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	g_type_class_adjust_private_offset (klass, &SpiceWindow_private_offset);
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	((GtkWidgetClass *) klass)->delete_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) spice_window_real_delete_event;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_window_get_property;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_window_set_property;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_window_constructor;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_window_finalize;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_WINDOW_IS_PRESENTING_PROPERTY, spice_window_properties[SPICE_WINDOW_IS_PRESENTING_PROPERTY] = g_param_spec_boolean ("is-presenting", "is-presenting", "is-presenting", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_WINDOW_HISTORY_MANAGER_PROPERTY, spice_window_properties[SPICE_WINDOW_HISTORY_MANAGER_PROPERTY] = g_param_spec_object ("history-manager", "history-manager", "history-manager", SPICE_SERVICES_TYPE_HISTORY_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_WINDOW_CURRENT_FILE_PROPERTY, spice_window_properties[SPICE_WINDOW_CURRENT_FILE_PROPERTY] = g_param_spec_object ("current-file", "current-file", "current-file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_WINDOW_ACTIONS_PROPERTY, spice_window_properties[SPICE_WINDOW_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", g_simple_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 140 "../Spice-up-1.9.1/src/Window.vala"
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 140 "../Spice-up-1.9.1/src/Window.vala"
	spice_window_action_accelerators = (GeeMultiMap*) _tmp0_;
#line 222 "../Spice-up-1.9.1/src/Window.vala"
	_tmp1_ = spice_window_action_accelerators;
#line 222 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp1_, SPICE_WINDOW_ACTION_UNDO, "<Control>Z");
#line 223 "../Spice-up-1.9.1/src/Window.vala"
	_tmp2_ = spice_window_action_accelerators;
#line 223 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp2_, SPICE_WINDOW_ACTION_REDO, "<Control><Shift>Z");
#line 224 "../Spice-up-1.9.1/src/Window.vala"
	_tmp3_ = spice_window_action_accelerators;
#line 224 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp3_, SPICE_WINDOW_ACTION_CLONE, "<Control>D");
#line 225 "../Spice-up-1.9.1/src/Window.vala"
	_tmp4_ = spice_window_action_accelerators;
#line 225 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp4_, SPICE_WINDOW_ACTION_PRESENT_START, "<Control><Alt>P");
#line 226 "../Spice-up-1.9.1/src/Window.vala"
	_tmp5_ = spice_window_action_accelerators;
#line 226 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp5_, SPICE_WINDOW_ACTION_PRESENT_STOP, "Escape");
#line 227 "../Spice-up-1.9.1/src/Window.vala"
	_tmp6_ = spice_window_action_accelerators;
#line 227 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp6_, SPICE_WINDOW_ACTION_PRESENT_STOP, "<Control><Alt>P");
#line 228 "../Spice-up-1.9.1/src/Window.vala"
	_tmp7_ = spice_window_action_accelerators;
#line 228 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp7_, SPICE_WINDOW_ACTION_SHOW_WELCOME, "<Control>W");
#line 229 "../Spice-up-1.9.1/src/Window.vala"
	_tmp8_ = spice_window_action_accelerators;
#line 229 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp8_, SPICE_WINDOW_ACTION_NOTES, "<Control>P");
#line 230 "../Spice-up-1.9.1/src/Window.vala"
	_tmp9_ = spice_window_action_accelerators;
#line 230 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp9_, SPICE_WINDOW_ACTION_EXPORT, "<Control><Shift>E");
#line 231 "../Spice-up-1.9.1/src/Window.vala"
	_tmp10_ = spice_window_action_accelerators;
#line 231 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp10_, SPICE_WINDOW_ACTION_NEW_SLIDE, "<Control><Shift>N");
#line 232 "../Spice-up-1.9.1/src/Window.vala"
	_tmp11_ = spice_window_action_accelerators;
#line 232 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp11_, SPICE_WINDOW_ACTION_INSERT_TEXT, "<Control><Shift>T");
#line 233 "../Spice-up-1.9.1/src/Window.vala"
	_tmp12_ = spice_window_action_accelerators;
#line 233 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp12_, SPICE_WINDOW_ACTION_INSERT_IMG, "<Control><Shift>Y");
#line 234 "../Spice-up-1.9.1/src/Window.vala"
	_tmp13_ = spice_window_action_accelerators;
#line 234 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp13_, SPICE_WINDOW_ACTION_INSERT_SHAPE, "<Control><Shift>U");
#line 236 "../Spice-up-1.9.1/src/Window.vala"
	_tmp14_ = spice_window_action_accelerators;
#line 236 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp14_, SPICE_WINDOW_ACTION_COPY, "<Control>C");
#line 237 "../Spice-up-1.9.1/src/Window.vala"
	_tmp15_ = spice_window_action_accelerators;
#line 237 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp15_, SPICE_WINDOW_ACTION_CUT, "<Control>X");
#line 238 "../Spice-up-1.9.1/src/Window.vala"
	_tmp16_ = spice_window_action_accelerators;
#line 238 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp16_, SPICE_WINDOW_ACTION_PASTE, "<Control>V");
#line 239 "../Spice-up-1.9.1/src/Window.vala"
	_tmp17_ = spice_window_action_accelerators;
#line 239 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp17_, SPICE_WINDOW_ACTION_DELETE, "<Control>Delete");
#line 240 "../Spice-up-1.9.1/src/Window.vala"
	_tmp18_ = spice_window_action_accelerators;
#line 240 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp18_, SPICE_WINDOW_ACTION_DELETE, "<Control>BackSpace");
#line 241 "../Spice-up-1.9.1/src/Window.vala"
	_tmp19_ = spice_window_action_accelerators;
#line 241 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp19_, SPICE_WINDOW_ACTION_NEXT, "Right");
#line 242 "../Spice-up-1.9.1/src/Window.vala"
	_tmp20_ = spice_window_action_accelerators;
#line 242 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp20_, SPICE_WINDOW_ACTION_NEXT, "Down");
#line 243 "../Spice-up-1.9.1/src/Window.vala"
	_tmp21_ = spice_window_action_accelerators;
#line 243 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp21_, SPICE_WINDOW_ACTION_NEXT, "space");
#line 244 "../Spice-up-1.9.1/src/Window.vala"
	_tmp22_ = spice_window_action_accelerators;
#line 244 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp22_, SPICE_WINDOW_ACTION_NEXT, "Return");
#line 245 "../Spice-up-1.9.1/src/Window.vala"
	_tmp23_ = spice_window_action_accelerators;
#line 245 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp23_, SPICE_WINDOW_ACTION_PREVIOUS, "Left");
#line 246 "../Spice-up-1.9.1/src/Window.vala"
	_tmp24_ = spice_window_action_accelerators;
#line 246 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp24_, SPICE_WINDOW_ACTION_PREVIOUS, "Up");
#line 247 "../Spice-up-1.9.1/src/Window.vala"
	_tmp25_ = spice_window_action_accelerators;
#line 247 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp25_, SPICE_WINDOW_ACTION_NEXT_EDIT, "Page_Down");
#line 248 "../Spice-up-1.9.1/src/Window.vala"
	_tmp26_ = spice_window_action_accelerators;
#line 248 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp26_, SPICE_WINDOW_ACTION_PREVIOUS_EDIT, "Page_Up");
#line 250 "../Spice-up-1.9.1/src/Window.vala"
	_tmp27_ = spice_window_action_accelerators;
#line 250 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp27_, SPICE_WINDOW_ACTION_BRING_FWD, "<Control><Alt>Page_Up");
#line 251 "../Spice-up-1.9.1/src/Window.vala"
	_tmp28_ = spice_window_action_accelerators;
#line 251 "../Spice-up-1.9.1/src/Window.vala"
	gee_multi_map_set (_tmp28_, SPICE_WINDOW_ACTION_BRING_BWD, "<Control><Alt>Page_Down");
#line 3625 "Window.c"
}

static void
spice_window_instance_init (SpiceWindow * self,
                            gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	self->priv = spice_window_get_instance_private (self);
#line 25 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->inhibit_token = (guint) 0;
#line 116 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->notification_shown = FALSE;
#line 117 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->is_full_ = FALSE;
#line 124 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->toast = NULL;
#line 128 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->aspect_frame = NULL;
#line 133 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->welcome = NULL;
#line 134 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->presenter_window = NULL;
#line 137 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->_current_file = NULL;
#line 602 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->hide_id = NULL;
#line 603 "../Spice-up-1.9.1/src/Window.vala"
	self->priv->cursor_hidden = FALSE;
#line 3654 "Window.c"
}

static void
spice_window_finalize (GObject * obj)
{
	SpiceWindow * self;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_WINDOW, SpiceWindow);
#line 119 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 120 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->slide_manager);
#line 121 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->slide_list);
#line 122 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->toolbar);
#line 126 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->sidebar_revealer);
#line 127 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->toolbar_revealer);
#line 128 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->aspect_frame);
#line 129 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->app_overlay);
#line 130 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->presenter_notes);
#line 132 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->app_stack);
#line 133 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->welcome);
#line 134 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->presenter_window);
#line 136 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->_history_manager);
#line 137 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->_current_file);
#line 139 "../Spice-up-1.9.1/src/Window.vala"
	_g_object_unref0 (self->priv->_actions);
#line 602 "../Spice-up-1.9.1/src/Window.vala"
	_g_free0 (self->priv->hide_id);
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	G_OBJECT_CLASS (spice_window_parent_class)->finalize (obj);
#line 3697 "Window.c"
}

static GType
spice_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceWindow), 0, (GInstanceInitFunc) spice_window_instance_init, NULL };
	GType spice_window_type_id;
	spice_window_type_id = g_type_register_static (gtk_application_window_get_type (), "SpiceWindow", &g_define_type_info, 0);
	SpiceWindow_private_offset = g_type_add_instance_private (spice_window_type_id, sizeof (SpiceWindowPrivate));
	return spice_window_type_id;
}

GType
spice_window_get_type (void)
{
	static volatile gsize spice_window_type_id__once = 0;
	if (g_once_init_enter (&spice_window_type_id__once)) {
		GType spice_window_type_id;
		spice_window_type_id = spice_window_get_type_once ();
		g_once_init_leave (&spice_window_type_id__once, spice_window_type_id);
	}
	return spice_window_type_id__once;
}

static void
_vala_spice_window_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SpiceWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_WINDOW, SpiceWindow);
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		case SPICE_WINDOW_IS_PRESENTING_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		g_value_set_boolean (value, spice_window_get_is_presenting (self));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		case SPICE_WINDOW_HISTORY_MANAGER_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		g_value_set_object (value, spice_window_get_history_manager (self));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		case SPICE_WINDOW_CURRENT_FILE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		g_value_set_object (value, spice_window_get_current_file (self));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		case SPICE_WINDOW_ACTIONS_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		g_value_set_object (value, spice_window_get_actions (self));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 3756 "Window.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 3762 "Window.c"
	}
}

static void
_vala_spice_window_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SpiceWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_WINDOW, SpiceWindow);
#line 22 "../Spice-up-1.9.1/src/Window.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		case SPICE_WINDOW_IS_PRESENTING_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_set_is_presenting (self, g_value_get_boolean (value));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		case SPICE_WINDOW_HISTORY_MANAGER_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_set_history_manager (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		case SPICE_WINDOW_CURRENT_FILE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_set_current_file (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		case SPICE_WINDOW_ACTIONS_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		spice_window_set_actions (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 3800 "Window.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Window.vala"
		break;
#line 3806 "Window.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

