/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkN4BiasFieldCorrectionImageFilter.h"
#include "itkN4BiasFieldCorrectionImageFilter.h"

// Additional include files
#include "sitkBiasFieldCorrectionImageFilter_helper.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
N4BiasFieldCorrectionImageFilter::N4BiasFieldCorrectionImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
N4BiasFieldCorrectionImageFilter::~N4BiasFieldCorrectionImageFilter(){
  if (this->m_Filter != nullptr)
    {
      m_Filter->UnRegister();
    }
}




//
// ToString
//
std::string N4BiasFieldCorrectionImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::N4BiasFieldCorrectionImageFilter\n";
  out << "  ConvergenceThreshold: ";
  this->ToStringHelper(out, this->m_ConvergenceThreshold);
  out << std::endl;
  out << "  MaximumNumberOfIterations: ";
  this->ToStringHelper(out, this->m_MaximumNumberOfIterations);
  out << std::endl;
  out << "  BiasFieldFullWidthAtHalfMaximum: ";
  this->ToStringHelper(out, this->m_BiasFieldFullWidthAtHalfMaximum);
  out << std::endl;
  out << "  WienerFilterNoise: ";
  this->ToStringHelper(out, this->m_WienerFilterNoise);
  out << std::endl;
  out << "  NumberOfHistogramBins: ";
  this->ToStringHelper(out, this->m_NumberOfHistogramBins);
  out << std::endl;
  out << "  NumberOfControlPoints: ";
  this->ToStringHelper(out, this->m_NumberOfControlPoints);
  out << std::endl;
  out << "  SplineOrder: ";
  this->ToStringHelper(out, this->m_SplineOrder);
  out << std::endl;
  out << "  UseMaskLabel: ";
  this->ToStringHelper(out, this->m_UseMaskLabel);
  out << std::endl;
  out << "  MaskLabel: ";
  this->ToStringHelper(out, this->m_MaskLabel);
  out << std::endl;
  out << "  CurrentLevel: ";
  if (bool(this->m_pfGetCurrentLevel))
  {
    this->ToStringHelper(out, this->m_pfGetCurrentLevel());
  }
  else
  {
    out << "(null)";
  }
  out << std::endl;  out << "  ElapsedIterations: ";
  if (bool(this->m_pfGetElapsedIterations))
  {
    this->ToStringHelper(out, this->m_pfGetElapsedIterations());
  }
  else
  {
    out << "(null)";
  }
  out << std::endl;  out << "  CurrentConvergenceMeasurement: ";
  if (bool(this->m_pfGetCurrentConvergenceMeasurement))
  {
    this->ToStringHelper(out, this->m_pfGetCurrentConvergenceMeasurement());
  }
  else
  {
    out << "(null)";
  }
  out << std::endl;
  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image N4BiasFieldCorrectionImageFilter::Execute ( const Image & image, const Image & maskImage )
{
  const PixelIDValueEnum type = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, maskImage, "maskImage" );
  CheckImageMatchingSize(  image, maskImage, "maskImage" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &image, &maskImage );
}
Image N4BiasFieldCorrectionImageFilter::Execute ( const Image & image )
{
  const PixelIDValueEnum type = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &image, nullptr );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image N4BiasFieldCorrectionImageFilter::ExecuteInternal ( const Image * inImage, const Image * inMaskImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;



  using FilterType = itk::N4BiasFieldCorrectionImageFilter<InputImageType, itk::Image< uint8_t, TImageType::ImageDimension>, OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  if ( inMaskImage != nullptr ) {
  filter->SetMaskImage( this->CastImageToITK<typename FilterType::MaskImageType>(*inMaskImage) );
  }


  filter->SetConvergenceThreshold ( this->m_ConvergenceThreshold );
  typename FilterType::VariableSizeArrayType maximumNumberOfIterations( this->m_MaximumNumberOfIterations.size() );
  for( unsigned int i = 0; i < this->m_MaximumNumberOfIterations.size(); ++i)
    maximumNumberOfIterations[i] = this->m_MaximumNumberOfIterations[i];
  filter->SetMaximumNumberOfIterations( maximumNumberOfIterations );
  filter->SetNumberOfFittingLevels( this->m_MaximumNumberOfIterations.size() );
  filter->SetBiasFieldFullWidthAtHalfMaximum ( this->m_BiasFieldFullWidthAtHalfMaximum );
  filter->SetWienerFilterNoise ( this->m_WienerFilterNoise );
  filter->SetNumberOfHistogramBins ( this->m_NumberOfHistogramBins );
  typename FilterType::ArrayType itkVecNumberOfControlPoints = sitkSTLVectorToITK<typename FilterType::ArrayType>( this->GetNumberOfControlPoints() );
  filter->SetNumberOfControlPoints( itkVecNumberOfControlPoints );
  filter->SetSplineOrder ( this->m_SplineOrder );
  filter->SetUseMaskLabel ( this->m_UseMaskLabel );
  filter->SetMaskLabel ( this->m_MaskLabel );



  // release the old filter ( and output data )
  if ( this->m_Filter != nullptr)
    {
      this->m_pfGetCurrentLevel = nullptr;
      this->m_pfGetElapsedIterations = nullptr;
      this->m_pfGetCurrentConvergenceMeasurement = nullptr;
      this->m_pfGetLogBiasFieldAsImage = nullptr;
      this->m_Filter->UnRegister();
      this->m_Filter = nullptr;
    }

  this->m_Filter = filter;
  this->m_Filter->Register();


  this->PreUpdate( filter.GetPointer() );

  this->m_pfGetCurrentLevel = [ f = filter.GetPointer() ] {
    const auto & value = f->GetCurrentLevel();
    return value;
  };
  this->m_pfGetElapsedIterations = [ f = filter.GetPointer() ] {
    const auto & value = f->GetElapsedIterations();
    return value;
  };
  this->m_pfGetCurrentConvergenceMeasurement = [ f = filter.GetPointer() ] {
    const auto & value = f->GetCurrentConvergenceMeasurement();
    return value;
  };
  this->m_pfGetLogBiasFieldAsImage = [ f = filter.GetPointer() ](auto && referenceImage) {
    const auto & value = BSplineLatticeToImage(f->GetLogBiasFieldControlPointLattice(), referenceImage, f->GetSplineOrder());
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return value;
  };


  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image N4BiasFieldCorrection ( const Image & image, const Image & maskImage, double convergenceThreshold, std::vector<uint32_t> maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, uint32_t numberOfHistogramBins, std::vector<uint32_t> numberOfControlPoints, uint32_t splineOrder, bool useMaskLabel, uint8_t maskLabel )
{
  N4BiasFieldCorrectionImageFilter filter;
  filter.SetConvergenceThreshold( convergenceThreshold );  filter.SetMaximumNumberOfIterations( maximumNumberOfIterations );  filter.SetBiasFieldFullWidthAtHalfMaximum( biasFieldFullWidthAtHalfMaximum );  filter.SetWienerFilterNoise( wienerFilterNoise );  filter.SetNumberOfHistogramBins( numberOfHistogramBins );  filter.SetNumberOfControlPoints( numberOfControlPoints );  filter.SetSplineOrder( splineOrder );  filter.SetUseMaskLabel( useMaskLabel );  filter.SetMaskLabel( maskLabel );
  return filter.Execute ( image, maskImage );
}
//
// Function to run the Execute method of this filter
//
Image N4BiasFieldCorrection ( const Image & image, double convergenceThreshold, std::vector<uint32_t> maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, uint32_t numberOfHistogramBins, std::vector<uint32_t> numberOfControlPoints, uint32_t splineOrder, bool useMaskLabel, uint8_t maskLabel )
{
  N4BiasFieldCorrectionImageFilter filter;
  filter.SetConvergenceThreshold( convergenceThreshold );  filter.SetMaximumNumberOfIterations( maximumNumberOfIterations );  filter.SetBiasFieldFullWidthAtHalfMaximum( biasFieldFullWidthAtHalfMaximum );  filter.SetWienerFilterNoise( wienerFilterNoise );  filter.SetNumberOfHistogramBins( numberOfHistogramBins );  filter.SetNumberOfControlPoints( numberOfControlPoints );  filter.SetSplineOrder( splineOrder );  filter.SetUseMaskLabel( useMaskLabel );  filter.SetMaskLabel( maskLabel );
  return filter.Execute ( image );
}


}
