/*=========================================================================
 *
 *  Copyright NumFOCUS
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         https://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/

#ifndef itkFFTImageFilterInitFactoryRegisterManager_h
#define itkFFTImageFilterInitFactoryRegisterManager_h

namespace itk {

//
//  The following code is intended to be expanded at the end of the
//  itk<config>FFTImageFilter.h files
//
void ITK_ABI_IMPORT FFTWFFTImageFilterInitFactoryRegister__Private();void ITK_ABI_IMPORT VnlFFTImageFilterInitFactoryRegister__Private();

class FFTImageFilterInitFactoryRegisterManager
{
  public:
  explicit FFTImageFilterInitFactoryRegisterManager(void (* const list[])(void))
  {
    for(;*list != nullptr; ++list)
      {
      (*list)();
      }
    }
};

//
// The code below registers available FFT helpers using static initialization in
// application translation units. Note that this code will be expanded in the
// ITK-based applications and not in ITK itself.
//
void (* const FFTImageFilterInitFactoryRegisterList[])(void) = {
  FFTWFFTImageFilterInitFactoryRegister__Private,VnlFFTImageFilterInitFactoryRegister__Private,
  nullptr};
const FFTImageFilterInitFactoryRegisterManager FFTImageFilterInitFactoryRegisterManagerInstance(FFTImageFilterInitFactoryRegisterList);

}

#endif
