/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkFastSymmetricForcesDemonsRegistrationFilter.h"
#include "itkFastSymmetricForcesDemonsRegistrationFilter.h"

// Additional include files
#include "sitkImageConvert.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
FastSymmetricForcesDemonsRegistrationFilter::FastSymmetricForcesDemonsRegistrationFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
FastSymmetricForcesDemonsRegistrationFilter::~FastSymmetricForcesDemonsRegistrationFilter(){
  if (this->m_Filter != nullptr)
    {
      m_Filter->UnRegister();
    }
}




//
// ToString
//
std::string FastSymmetricForcesDemonsRegistrationFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::FastSymmetricForcesDemonsRegistrationFilter\n";
  out << "  StandardDeviations: ";
  this->ToStringHelper(out, this->m_StandardDeviations);
  out << std::endl;
  out << "  NumberOfIterations: ";
  this->ToStringHelper(out, this->m_NumberOfIterations);
  out << std::endl;
  out << "  MaximumRMSError: ";
  this->ToStringHelper(out, this->m_MaximumRMSError);
  out << std::endl;
  out << "  UseGradientType: ";
  this->ToStringHelper(out, this->m_UseGradientType);
  out << std::endl;
  out << "  MaximumUpdateStepLength: ";
  this->ToStringHelper(out, this->m_MaximumUpdateStepLength);
  out << std::endl;
  out << "  SmoothDisplacementField: ";
  this->ToStringHelper(out, this->m_SmoothDisplacementField);
  out << std::endl;
  out << "  SmoothUpdateField: ";
  this->ToStringHelper(out, this->m_SmoothUpdateField);
  out << std::endl;
  out << "  UpdateFieldStandardDeviations: ";
  this->ToStringHelper(out, this->m_UpdateFieldStandardDeviations);
  out << std::endl;
  out << "  MaximumKernelWidth: ";
  this->ToStringHelper(out, this->m_MaximumKernelWidth);
  out << std::endl;
  out << "  MaximumError: ";
  this->ToStringHelper(out, this->m_MaximumError);
  out << std::endl;
  out << "  IntensityDifferenceThreshold: ";
  this->ToStringHelper(out, this->m_IntensityDifferenceThreshold);
  out << std::endl;
  out << "  UseImageSpacing: ";
  this->ToStringHelper(out, this->m_UseImageSpacing);
  out << std::endl;
  out << "  ElapsedIterations: ";
  if (bool(this->m_pfGetElapsedIterations))
  {
    this->ToStringHelper(out, this->m_pfGetElapsedIterations());
  }
  else
  {
    out << "(null)";
  }
  out << std::endl;  out << "  RMSChange: " << this->m_RMSChange << std::endl;
  out << "  Metric: ";
  if (bool(this->m_pfGetMetric))
  {
    this->ToStringHelper(out, this->m_pfGetMetric());
  }
  else
  {
    out << "(null)";
  }
  out << std::endl;
  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image FastSymmetricForcesDemonsRegistrationFilter::Execute ( const Image & fixedImage, const Image & movingImage, const Image & initialDisplacementField )
{
  const PixelIDValueEnum type = fixedImage.GetPixelID();
  const unsigned int dimension = fixedImage.GetDimension();
  CheckImageMatchingDimension(  fixedImage, movingImage, "movingImage" );
  CheckImageMatchingSize(  fixedImage, movingImage, "movingImage" );
  CheckImageMatchingDimension(  fixedImage, initialDisplacementField, "initialDisplacementField" );
  CheckImageMatchingSize(  fixedImage, initialDisplacementField, "initialDisplacementField" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &fixedImage, &movingImage, &initialDisplacementField );
}
Image FastSymmetricForcesDemonsRegistrationFilter::Execute ( const Image & fixedImage, const Image & movingImage )
{
  const PixelIDValueEnum type = fixedImage.GetPixelID();
  const unsigned int dimension = fixedImage.GetDimension();
  CheckImageMatchingDimension(  fixedImage, movingImage, "movingImage" );
  CheckImageMatchingSize(  fixedImage, movingImage, "movingImage" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &fixedImage, &movingImage, nullptr );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image FastSymmetricForcesDemonsRegistrationFilter::ExecuteInternal ( const Image * inFixedImage, const Image * inMovingImage, const Image * inInitialDisplacementField )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  //Define output image type
  using OutputImageType = itk::Image< Vector<double, TImageType::ImageDimension>, TImageType::ImageDimension >;



  using FilterType = itk::FastSymmetricForcesDemonsRegistrationFilter<TImageType, TImageType, OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inFixedImage != nullptr );
  filter->SetFixedImage( this->CastImageToITK<typename FilterType::FixedImageType>(*inFixedImage) );
  assert( inMovingImage != nullptr );
  typename FilterType::MovingImageType::ConstPointer image2 = this->CastImageToITK<typename FilterType::MovingImageType>( *inMovingImage );
  filter->SetMovingImage( image2 );
  if ( inInitialDisplacementField != nullptr ) {
    using VectorImageType = itk::VectorImage<double, FilterType::DisplacementFieldType::ImageDimension>;
      filter->SetInitialDisplacementField( GetImageFromVectorImage(const_cast<VectorImageType*>(CastImageToITK<VectorImageType>(*inInitialDisplacementField).GetPointer()) ) );
  }


  typename FilterType::StandardDeviationsType itkVecStandardDeviations = sitkSTLVectorToITK<typename FilterType::StandardDeviationsType>( this->GetStandardDeviations() );
  filter->SetStandardDeviations( itkVecStandardDeviations );
  filter->SetNumberOfIterations ( this->m_NumberOfIterations );
  filter->SetMaximumRMSError ( this->m_MaximumRMSError );
  filter->SetUseGradientType( static_cast<typename FilterType::GradientType>( this->GetUseGradientType()) );
  filter->SetMaximumUpdateStepLength ( this->m_MaximumUpdateStepLength );
  filter->SetSmoothDisplacementField ( this->m_SmoothDisplacementField );
  filter->SetSmoothUpdateField ( this->m_SmoothUpdateField );
  typename FilterType::StandardDeviationsType itkVecUpdateFieldStandardDeviations = sitkSTLVectorToITK<typename FilterType::StandardDeviationsType>( this->GetUpdateFieldStandardDeviations() );
  filter->SetUpdateFieldStandardDeviations( itkVecUpdateFieldStandardDeviations );
  filter->SetMaximumKernelWidth ( this->m_MaximumKernelWidth );
  filter->SetMaximumError ( this->m_MaximumError );
  filter->SetIntensityDifferenceThreshold ( this->m_IntensityDifferenceThreshold );
  filter->SetUseImageSpacing ( this->m_UseImageSpacing );



  // release the old filter ( and output data )
  if ( this->m_Filter != nullptr)
    {
      this->m_pfGetElapsedIterations = nullptr;
      this->m_pfGetMetric = nullptr;
      this->m_pfGetStopRegistration = nullptr;
      this->m_Filter->UnRegister();
      this->m_Filter = nullptr;
    }

  this->m_Filter = filter;
  this->m_Filter->Register();


  this->PreUpdate( filter.GetPointer() );

  this->m_pfGetElapsedIterations = [ f = filter.GetPointer() ] {
    const auto & value = f->GetElapsedIterations();
    return value;
  };
  this->m_pfGetMetric = [ f = filter.GetPointer() ] {
    const auto & value = f->GetMetric();
    return value;
  };
  this->m_pfGetStopRegistration = [ f = filter.GetPointer() ] {
    return f->StopRegistration();  //    return value;
  };


  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();

  this->m_RMSChange = filter->GetRMSChange();


  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------




}
