/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkErodeObjectMorphologyImageFilter.h"
#include "itkErodeObjectMorphologyImageFilter.h"

// Additional include files
#include "sitkCreateKernel.h"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
ErodeObjectMorphologyImageFilter::ErodeObjectMorphologyImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
ErodeObjectMorphologyImageFilter::~ErodeObjectMorphologyImageFilter() = default;



//
// ToString
//
std::string ErodeObjectMorphologyImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::ErodeObjectMorphologyImageFilter\n";
  out << "  KernelRadius: ";
  this->ToStringHelper(out, this->m_KernelRadius);
  out << std::endl;
  out << "  KernelType: ";
  this->ToStringHelper(out, this->m_KernelType);
  out << std::endl;
  out << "  ObjectValue: ";
  this->ToStringHelper(out, this->m_ObjectValue);
  out << std::endl;
  out << "  BackgroundValue: ";
  this->ToStringHelper(out, this->m_BackgroundValue);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image ErodeObjectMorphologyImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image ErodeObjectMorphologyImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType = itk::ErodeObjectMorphologyImageFilter<InputImageType, OutputImageType, itk::FlatStructuringElement< InputImageType::ImageDimension > >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  
  auto kernel = CreateKernel<InputImageType::ImageDimension>( m_KernelType, m_KernelRadius );
  filter->SetKernel( kernel );
  filter->SetObjectValue(static_cast<typename FilterType::PixelType>(this->GetObjectValue()) );
  filter->SetBackgroundValue ( static_cast< typename OutputImageType::PixelType> ( this->m_BackgroundValue ) );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image ErodeObjectMorphology ( const Image& image1, std::vector<unsigned int> kernelRadius, KernelEnum kernelType, double objectValue, double backgroundValue )
{
  ErodeObjectMorphologyImageFilter filter;
  filter.SetKernelRadius( kernelRadius );  filter.SetKernelType( kernelType );  filter.SetObjectValue( objectValue );  filter.SetBackgroundValue( backgroundValue );
  return filter.Execute ( image1 );
}


}
