/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_keycredlink.h"

_PUBLIC_ enum ndr_err_code ndr_push_KEYCREDENTIALLINK_ENTRY_Identifier(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum KEYCREDENTIALLINK_ENTRY_Identifier r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_KEYCREDENTIALLINK_ENTRY_Identifier(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum KEYCREDENTIALLINK_ENTRY_Identifier *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_KEYCREDENTIALLINK_ENTRY_Identifier(struct ndr_print *ndr, const char *name, enum KEYCREDENTIALLINK_ENTRY_Identifier r)
{
	const char *val = NULL;

	switch (r) {
		case KeyID: val = "KeyID"; break;
		case KeyHash: val = "KeyHash"; break;
		case KeyMaterial: val = "KeyMaterial"; break;
		case KeyUsage: val = "KeyUsage"; break;
		case KeySource: val = "KeySource"; break;
		case DeviceId: val = "DeviceId"; break;
		case CustomKeyInformation: val = "CustomKeyInformation"; break;
		case KeyApproximateLastLogonTimeStamp: val = "KeyApproximateLastLogonTimeStamp"; break;
		case KeyCreationTime: val = "KeyCreationTime"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_KEYCREDENTIALLINK_ENTRY_KeyUsage(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum KEYCREDENTIALLINK_ENTRY_KeyUsage r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_KEYCREDENTIALLINK_ENTRY_KeyUsage(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum KEYCREDENTIALLINK_ENTRY_KeyUsage *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_KEYCREDENTIALLINK_ENTRY_KeyUsage(struct ndr_print *ndr, const char *name, enum KEYCREDENTIALLINK_ENTRY_KeyUsage r)
{
	const char *val = NULL;

	switch (r) {
		case KEY_USAGE_NGC: val = "KEY_USAGE_NGC"; break;
		case KEY_USAGE_FIDO: val = "KEY_USAGE_FIDO"; break;
		case KEY_USAGE_FEK: val = "KEY_USAGE_FEK"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_KEYCREDENTIALLINK_ENTRY_KeySource(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum KEYCREDENTIALLINK_ENTRY_KeySource r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_KEYCREDENTIALLINK_ENTRY_KeySource(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum KEYCREDENTIALLINK_ENTRY_KeySource *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_KEYCREDENTIALLINK_ENTRY_KeySource(struct ndr_print *ndr, const char *name, enum KEYCREDENTIALLINK_ENTRY_KeySource r)
{
	const char *val = NULL;

	switch (r) {
		case KEY_SOURCE_AD: val = "KEY_SOURCE_AD"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_CUSTOM_KEY_INFO_Flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CUSTOM_KEY_INFO_Flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CUSTOM_KEY_INFO_Flags(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "CUSTOM_KEY_INFO_FLAGS_ATTESTATION", CUSTOM_KEY_INFO_FLAGS_ATTESTATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "CUSTOM_KEY_INFO_FLAGS_MFA_NOT_USED", CUSTOM_KEY_INFO_FLAGS_MFA_NOT_USED, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_CUSTOM_KEY_INFO_VolType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum CUSTOM_KEY_INFO_VolType r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CUSTOM_KEY_INFO_VolType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum CUSTOM_KEY_INFO_VolType *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CUSTOM_KEY_INFO_VolType(struct ndr_print *ndr, const char *name, enum CUSTOM_KEY_INFO_VolType r)
{
	const char *val = NULL;

	switch (r) {
		case Unspecified: val = "Unspecified"; break;
		case OSV: val = "OSV"; break;
		case FDV: val = "FDV"; break;
		case RDV: val = "RDV"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_CUSTOM_KEY_INFO_SupportsNotification(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum CUSTOM_KEY_INFO_SupportsNotification r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CUSTOM_KEY_INFO_SupportsNotification(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum CUSTOM_KEY_INFO_SupportsNotification *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CUSTOM_KEY_INFO_SupportsNotification(struct ndr_print *ndr, const char *name, enum CUSTOM_KEY_INFO_SupportsNotification r)
{
	const char *val = NULL;

	switch (r) {
		case Unsupported: val = "Unsupported"; break;
		case Supported: val = "Supported"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_CUSTOM_KEY_INFO_KeyStrength(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum CUSTOM_KEY_INFO_KeyStrength r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CUSTOM_KEY_INFO_KeyStrength(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum CUSTOM_KEY_INFO_KeyStrength *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CUSTOM_KEY_INFO_KeyStrength(struct ndr_print *ndr, const char *name, enum CUSTOM_KEY_INFO_KeyStrength r)
{
	const char *val = NULL;

	switch (r) {
		case Unknown: val = "Unknown"; break;
		case Weak: val = "Weak"; break;
		case Normal: val = "Normal"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_EncodedExtendedCKI(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct EncodedExtendedCKI *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->size));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_EncodedExtendedCKI(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct EncodedExtendedCKI *r)
{
	uint32_t size_data_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->version));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->size));
			size_data_0 = r->size;
			NDR_PULL_ALLOC_N(ndr, r->data, size_data_0);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, size_data_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_EncodedExtendedCKI(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct EncodedExtendedCKI *r)
{
	ndr_print_EncodedExtendedCKI(ndr, name, r);
}

_PUBLIC_ void ndr_print_EncodedExtendedCKI(struct ndr_print *ndr, const char *name, const struct EncodedExtendedCKI *r)
{
	ndr_print_struct(ndr, name, "EncodedExtendedCKI");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint8(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->version);
		ndr_print_uint8(ndr, "size", r->size);
		ndr_print_array_uint8(ndr, "data", r->data, r->size);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ void ndr_print_CUSTOM_KEY_INFORMATION(struct ndr_print *ndr, const char *name, const struct CUSTOM_KEY_INFORMATION *r)
{
	uint32_t cntr_cki_0;
	ndr_print_struct(ndr, name, "CUSTOM_KEY_INFORMATION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->version);
	ndr_print_CUSTOM_KEY_INFO_Flags(ndr, "flags", r->flags);
	ndr_print_uint8(ndr, "isExtended", r->isExtended);
	ndr_print_CUSTOM_KEY_INFO_VolType(ndr, "volType", r->volType);
	ndr_print_CUSTOM_KEY_INFO_SupportsNotification(ndr, "supportsNotification", r->supportsNotification);
	ndr_print_uint8(ndr, "fekKeyVersion", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->fekKeyVersion);
	ndr_print_CUSTOM_KEY_INFO_KeyStrength(ndr, "keyStrength", r->keyStrength);
	ndr_print_array_uint8(ndr, "reserved", r->reserved, 10);
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "cki", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_cki_0 = 0; cntr_cki_0 < (r->count); cntr_cki_0++) {
		ndr_print_EncodedExtendedCKI(ndr, "cki", &r->cki[cntr_cki_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_KEYCREDENTIALLINK_ENTRY_Value(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union KEYCREDENTIALLINK_ENTRY_Value *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_push_union_align(ndr, 4));
			switch (level) {
				case KeyID: {
					NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->keyId, 32));
				break; }

				case KeyHash: {
					NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->keyHash, 32));
				break; }

				case KeyUsage: {
					NDR_CHECK(ndr_push_KEYCREDENTIALLINK_ENTRY_KeyUsage(ndr, NDR_SCALARS, r->keyUsage));
				break; }

				case KeySource: {
					NDR_CHECK(ndr_push_KEYCREDENTIALLINK_ENTRY_KeySource(ndr, NDR_SCALARS, KEY_SOURCE_AD));
				break; }

				case KeyMaterial: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->keyMaterial));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

				case DeviceId: {
					NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->deviceId, 16));
				break; }

				case CustomKeyInformation: {
					NDR_CHECK(ndr_push_CUSTOM_KEY_INFORMATION(ndr, NDR_SCALARS, &r->customKeyInformation));
				break; }

				case KeyApproximateLastLogonTimeStamp: {
					NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->lastLogon));
				break; }

				case KeyCreationTime: {
					NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->created));
				break; }

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (!(ndr_flags & NDR_SCALARS)) {
				/* We didn't get it above, and the token is not needed after this. */
				NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			}
			switch (level) {
				case KeyID:
				break;

				case KeyHash:
				break;

				case KeyUsage:
				break;

				case KeySource:
				break;

				case KeyMaterial:
				break;

				case DeviceId:
				break;

				case CustomKeyInformation:
				break;

				case KeyApproximateLastLogonTimeStamp:
				break;

				case KeyCreationTime:
				break;

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_KEYCREDENTIALLINK_ENTRY_Value(struct ndr_print *ndr, const char *name, const union KEYCREDENTIALLINK_ENTRY_Value *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		level = ndr_print_steal_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "KEYCREDENTIALLINK_ENTRY_Value");
		switch (level) {
			case KeyID:
				ndr_print_array_uint8(ndr, "keyId", r->keyId, 32);
			break;

			case KeyHash:
				ndr_print_array_uint8(ndr, "keyHash", r->keyHash, 32);
			break;

			case KeyUsage:
				ndr_print_KEYCREDENTIALLINK_ENTRY_KeyUsage(ndr, "keyUsage", r->keyUsage);
			break;

			case KeySource:
				ndr_print_KEYCREDENTIALLINK_ENTRY_KeySource(ndr, "keySource", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?KEY_SOURCE_AD:r->keySource);
			break;

			case KeyMaterial:
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					ndr_print_DATA_BLOB(ndr, "keyMaterial", r->keyMaterial);
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break;

			case DeviceId:
				ndr_print_array_uint8(ndr, "deviceId", r->deviceId, 16);
			break;

			case CustomKeyInformation:
				ndr_print_CUSTOM_KEY_INFORMATION(ndr, "customKeyInformation", &r->customKeyInformation);
			break;

			case KeyApproximateLastLogonTimeStamp:
				ndr_print_NTTIME(ndr, "lastLogon", r->lastLogon);
			break;

			case KeyCreationTime:
				ndr_print_NTTIME(ndr, "created", r->created);
			break;

			default:
				ndr_print_bad_level(ndr, name, level);
		}
		ndr->flags = _flags_save_UNION;
	}
}

_PUBLIC_ size_t ndr_size_KEYCREDENTIALLINK_ENTRY_Value(const union KEYCREDENTIALLINK_ENTRY_Value *r, uint32_t level, libndr_flags flags)
{
	flags |= LIBNDR_FLAG_NOALIGN;
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_KEYCREDENTIALLINK_ENTRY_Value);
}

_PUBLIC_ enum ndr_err_code ndr_push_KEYCREDENTIALLINK_ENTRY(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct KEYCREDENTIALLINK_ENTRY *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_size_KEYCREDENTIALLINK_ENTRY_Value(&r->value, r->identifier, ndr->flags)));
			NDR_CHECK(ndr_push_KEYCREDENTIALLINK_ENTRY_Identifier(ndr, NDR_SCALARS, r->identifier));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->value, r->identifier));
			NDR_CHECK(ndr_push_KEYCREDENTIALLINK_ENTRY_Value(ndr, NDR_SCALARS, &r->value));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_KEYCREDENTIALLINK_ENTRY(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct KEYCREDENTIALLINK_ENTRY *r)
{
	ndr_print_KEYCREDENTIALLINK_ENTRY(ndr, name, r);
}

_PUBLIC_ void ndr_print_KEYCREDENTIALLINK_ENTRY(struct ndr_print *ndr, const char *name, const struct KEYCREDENTIALLINK_ENTRY *r)
{
	ndr_print_struct(ndr, name, "KEYCREDENTIALLINK_ENTRY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_KEYCREDENTIALLINK_ENTRY_Value(&r->value, r->identifier, ndr->flags):r->length);
		ndr_print_KEYCREDENTIALLINK_ENTRY_Identifier(ndr, "identifier", r->identifier);
		ndr_print_set_switch_value(ndr, &r->value, r->identifier);
		ndr_print_KEYCREDENTIALLINK_ENTRY_Value(ndr, "value", &r->value);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static void ndr_print_flags_KEYCREDENTIALLINK_BLOB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct KEYCREDENTIALLINK_BLOB *r)
{
	ndr_print_KEYCREDENTIALLINK_BLOB(ndr, name, r);
}

_PUBLIC_ void ndr_print_KEYCREDENTIALLINK_BLOB(struct ndr_print *ndr, const char *name, const struct KEYCREDENTIALLINK_BLOB *r)
{
	uint32_t cntr_entries_0;
	ndr_print_struct(ndr, name, "KEYCREDENTIALLINK_BLOB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x0200:r->version);
		ndr_print_uint32(ndr, "count", r->count);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "entries", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_entries_0 = 0; cntr_entries_0 < (r->count); cntr_entries_0++) {
			ndr_print_KEYCREDENTIALLINK_ENTRY(ndr, "entries", &r->entries[cntr_entries_0]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static void ndr_print_flags_KeyMaterialInternal(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct KeyMaterialInternal *r)
{
	ndr_print_KeyMaterialInternal(ndr, name, r);
}

_PUBLIC_ void ndr_print_KeyMaterialInternal(struct ndr_print *ndr, const char *name, const struct KeyMaterialInternal *r)
{
	ndr_print_struct(ndr, name, "KeyMaterialInternal");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "bit_size", r->bit_size);
	ndr_print_DATA_BLOB(ndr, "modulus", r->modulus);
	ndr_print_DATA_BLOB(ndr, "exponent", r->exponent);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_keycredlink
static const struct ndr_interface_public_struct keycredlink_public_structs[] = {
	{
		.name = "EncodedExtendedCKI",
		.struct_size = sizeof(struct EncodedExtendedCKI ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_EncodedExtendedCKI,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_EncodedExtendedCKI,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_EncodedExtendedCKI,
	},
	{
		.name = "KEYCREDENTIALLINK_ENTRY",
		.struct_size = sizeof(struct KEYCREDENTIALLINK_ENTRY ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_KEYCREDENTIALLINK_ENTRY,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_KEYCREDENTIALLINK_ENTRY,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_KEYCREDENTIALLINK_ENTRY,
	},
	{
		.name = "KEYCREDENTIALLINK_BLOB",
		.struct_size = sizeof(struct KEYCREDENTIALLINK_BLOB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_KEYCREDENTIALLINK_BLOB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_KEYCREDENTIALLINK_BLOB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_KEYCREDENTIALLINK_BLOB,
	},
	{
		.name = "KeyMaterialInternal",
		.struct_size = sizeof(struct KeyMaterialInternal ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_KeyMaterialInternal,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_KeyMaterialInternal,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_KeyMaterialInternal,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call keycredlink_calls[] = {
	{ .name = NULL }
};

static const char * const keycredlink_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\keycredlink]", 
};

static const struct ndr_interface_string_array keycredlink_endpoints = {
	.count	= 1,
	.names	= keycredlink_endpoint_strings
};

static const char * const keycredlink_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array keycredlink_authservices = {
	.count	= 1,
	.names	= keycredlink_authservice_strings
};


const struct ndr_interface_table ndr_table_keycredlink = {
	.name		= "keycredlink",
	.num_calls	= 0,
	.calls		= keycredlink_calls,
	.num_public_structs	= 4,
	.public_structs		= keycredlink_public_structs,
	.endpoints	= &keycredlink_endpoints,
	.authservices	= &keycredlink_authservices
};

#endif /* SKIP_NDR_TABLE_keycredlink */
