/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_svcctl
#define _PIDL_HEADER_svcctl

#include <stdint.h>


#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#ifndef _HEADER_svcctl
#define _HEADER_svcctl

#define MAX_SERVICE_NAME_LENGTH	( 256 )
#define SC_MAX_DEPEND_SIZE	( 4*1024 )
#define SC_MAX_NAME_LENGTH	( MAX_SERVICE_NAME_LENGTH+1 )
#define SC_MAX_PATH_LENGTH	( 32*1024 )
#define SC_MAX_PWD_SIZE	( 514 )
#define SC_MAX_COMPUTER_NAME_LENGTH	( 1024 )
#define SC_MAX_ACCOUNT_NAME_LENGTH	( 2*1024 )
#define SC_MAX_COMMENT_LENGTH	( 128 )
#define SC_MAX_ARGUMENT_LENGTH	( 1024 )
#define SC_MAX_ARGUMENTS	( 1024 )
#define SVCCTL_ACCEPT_NONE	( 0x00000000 )
#define SERVICE_TYPE_KERNEL_DRIVER	( 0x01 )
#define SERVICE_TYPE_FS_DRIVER	( 0x02 )
#define SERVICE_TYPE_ADAPTER	( 0x04 )
#define SERVICE_TYPE_RECOGNIZER_DRIVER	( 0x08 )
#define SERVICE_TYPE_DRIVER	( SERVICE_TYPE_KERNEL_DRIVER|SERVICE_TYPE_FS_DRIVER|SERVICE_TYPE_RECOGNIZER_DRIVER )
#define SERVICE_TYPE_WIN32_OWN_PROCESS	( 0x10 )
#define SERVICE_TYPE_WIN32_SHARE_PROCESS	( 0x20 )
#define SERVICE_TYPE_WIN32	( SERVICE_TYPE_WIN32_OWN_PROCESS|SERVICE_TYPE_WIN32_SHARE_PROCESS )
#define SERVICE_TYPE_INTERACTIVE_PROCESS	( 0x100 )
#define SC_MANAGER_READ_ACCESS	( (SEC_STD_READ_CONTROL|SC_RIGHT_MGR_CONNECT|SC_RIGHT_MGR_ENUMERATE_SERVICE|SC_RIGHT_MGR_QUERY_LOCK_STATUS) )
#define SC_MANAGER_EXECUTE_ACCESS	( SC_MANAGER_READ_ACCESS )
#define SC_MANAGER_WRITE_ACCESS	( (SEC_STD_REQUIRED|SC_MANAGER_READ_ACCESS|SC_RIGHT_MGR_CREATE_SERVICE|SC_RIGHT_MGR_LOCK|SC_RIGHT_MGR_MODIFY_BOOT_CONFIG) )
#define SC_MANAGER_ALL_ACCESS	( SC_MANAGER_WRITE_ACCESS )
#define SERVICE_READ_ACCESS	( (SEC_STD_READ_CONTROL|SC_RIGHT_SVC_ENUMERATE_DEPENDENTS|SC_RIGHT_SVC_INTERROGATE|SC_RIGHT_SVC_QUERY_CONFIG|SC_RIGHT_SVC_QUERY_STATUS|SC_RIGHT_SVC_USER_DEFINED_CONTROL) )
#define SERVICE_EXECUTE_ACCESS	( (SERVICE_READ_ACCESS|SC_RIGHT_SVC_START|SC_RIGHT_SVC_STOP|SC_RIGHT_SVC_PAUSE_CONTINUE) )
#define SERVICE_WRITE_ACCESS	( (SEC_STD_REQUIRED|SERVICE_READ_ACCESS|SERVICE_EXECUTE_ACCESS|SC_RIGHT_SVC_CHANGE_CONFIG) )
#define SERVICE_ALL_ACCESS	( SERVICE_WRITE_ACCESS )
#define SC_MAX_ARGUMENT_LENGTH	( 1024 )
#define SC_MAX_ARGUMENTS	( 1024 )
struct SERVICE_LOCK_STATUS {
	uint32_t is_locked;
	const char *lock_owner;/* [charset(UTF16),unique] */
	uint32_t lock_duration;
};

enum svcctl_ServiceStatus
#ifndef USE_UINT_ENUMS
 {
	SVCCTL_STATE_UNKNOWN=(int)(0x00000000),
	SVCCTL_STOPPED=(int)(0x00000001),
	SVCCTL_START_PENDING=(int)(0x00000002),
	SVCCTL_STOP_PENDING=(int)(0x00000003),
	SVCCTL_RUNNING=(int)(0x00000004),
	SVCCTL_CONTINUE_PENDING=(int)(0x00000005),
	SVCCTL_PAUSE_PENDING=(int)(0x00000006),
	SVCCTL_PAUSED=(int)(0x00000007)
}
#else
 { __do_not_use_enum_svcctl_ServiceStatus=INT_MAX}
#define SVCCTL_STATE_UNKNOWN ( 0x00000000 )
#define SVCCTL_STOPPED ( 0x00000001 )
#define SVCCTL_START_PENDING ( 0x00000002 )
#define SVCCTL_STOP_PENDING ( 0x00000003 )
#define SVCCTL_RUNNING ( 0x00000004 )
#define SVCCTL_CONTINUE_PENDING ( 0x00000005 )
#define SVCCTL_PAUSE_PENDING ( 0x00000006 )
#define SVCCTL_PAUSED ( 0x00000007 )
#endif
;

/* bitmap svcctl_ControlsAccepted */
#define SVCCTL_ACCEPT_STOP ( 0x00000001 )
#define SVCCTL_ACCEPT_PAUSE_CONTINUE ( 0x00000002 )
#define SVCCTL_ACCEPT_SHUTDOWN ( 0x00000004 )
#define SVCCTL_ACCEPT_PARAMCHANGE ( 0x00000008 )
#define SVCCTL_ACCEPT_NETBINDCHANGE ( 0x00000010 )
#define SVCCTL_ACCEPT_HARDWAREPROFILECHANGE ( 0x00000020 )
#define SVCCTL_ACCEPT_POWEREVENT ( 0x00000040 )

struct SERVICE_STATUS {
	uint32_t type;
	enum svcctl_ServiceStatus state;
	uint32_t controls_accepted;
	WERROR win32_exit_code;
	uint32_t service_exit_code;
	uint32_t check_point;
	uint32_t wait_hint;
};

struct SERVICE_STATUS_PROCESS {
	struct SERVICE_STATUS status;
	uint32_t process_id;
	uint32_t service_flags;
}/* [public] */;

struct ENUM_SERVICE_STATUSW {
	const char * service_name;/* [flag(LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2),relative] */
	const char * display_name;/* [flag(LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2),relative] */
	struct SERVICE_STATUS status;
}/* [gensize,public] */;

struct ENUM_SERVICE_STATUSA {
	const char * service_name;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM),relative] */
	const char * display_name;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM),relative] */
	struct SERVICE_STATUS status;
}/* [gensize,public] */;

enum SERVICE_CONTROL
#ifndef USE_UINT_ENUMS
 {
	SVCCTL_CONTROL_STOP=(int)(0x00000001),
	SVCCTL_CONTROL_PAUSE=(int)(0x00000002),
	SVCCTL_CONTROL_CONTINUE=(int)(0x00000003),
	SVCCTL_CONTROL_INTERROGATE=(int)(0x00000004),
	SVCCTL_CONTROL_SHUTDOWN=(int)(0x00000005),
	SVCCTL_CONTROL_PARAMCHANGE=(int)(0x00000006),
	SVCCTL_CONTROL_NETBINDADD=(int)(0x00000007),
	SVCCTL_CONTROL_NETBINDREMOVE=(int)(0x00000008),
	SVCCTL_CONTROL_NETBINDENABLE=(int)(0x00000009),
	SVCCTL_CONTROL_NETBINDDISABLE=(int)(0x0000000A)
}
#else
 { __do_not_use_enum_SERVICE_CONTROL=INT_MAX}
#define SVCCTL_CONTROL_STOP ( 0x00000001 )
#define SVCCTL_CONTROL_PAUSE ( 0x00000002 )
#define SVCCTL_CONTROL_CONTINUE ( 0x00000003 )
#define SVCCTL_CONTROL_INTERROGATE ( 0x00000004 )
#define SVCCTL_CONTROL_SHUTDOWN ( 0x00000005 )
#define SVCCTL_CONTROL_PARAMCHANGE ( 0x00000006 )
#define SVCCTL_CONTROL_NETBINDADD ( 0x00000007 )
#define SVCCTL_CONTROL_NETBINDREMOVE ( 0x00000008 )
#define SVCCTL_CONTROL_NETBINDENABLE ( 0x00000009 )
#define SVCCTL_CONTROL_NETBINDDISABLE ( 0x0000000A )
#endif
;

enum svcctl_ErrorControl
#ifndef USE_UINT_ENUMS
 {
	SVCCTL_SVC_ERROR_IGNORE=(int)(0x00000000),
	SVCCTL_SVC_ERROR_NORMAL=(int)(0x00000001),
	SVCCTL_SVC_ERROR_CRITICAL=(int)(0x00000002),
	SVCCTL_SVC_ERROR_SEVERE=(int)(0x00000003)
}
#else
 { __do_not_use_enum_svcctl_ErrorControl=INT_MAX}
#define SVCCTL_SVC_ERROR_IGNORE ( 0x00000000 )
#define SVCCTL_SVC_ERROR_NORMAL ( 0x00000001 )
#define SVCCTL_SVC_ERROR_CRITICAL ( 0x00000002 )
#define SVCCTL_SVC_ERROR_SEVERE ( 0x00000003 )
#endif
;

enum svcctl_StartType
#ifndef USE_UINT_ENUMS
 {
	SVCCTL_BOOT_START=(int)(0x00000000),
	SVCCTL_SYSTEM_START=(int)(0x00000001),
	SVCCTL_AUTO_START=(int)(0x00000002),
	SVCCTL_DEMAND_START=(int)(0x00000003),
	SVCCTL_DISABLED=(int)(0x00000004)
}
#else
 { __do_not_use_enum_svcctl_StartType=INT_MAX}
#define SVCCTL_BOOT_START ( 0x00000000 )
#define SVCCTL_SYSTEM_START ( 0x00000001 )
#define SVCCTL_AUTO_START ( 0x00000002 )
#define SVCCTL_DEMAND_START ( 0x00000003 )
#define SVCCTL_DISABLED ( 0x00000004 )
#endif
;

enum svcctl_ServiceState
#ifndef USE_UINT_ENUMS
 {
	SERVICE_STATE_ACTIVE=(int)(0x00000001),
	SERVICE_STATE_INACTIVE=(int)(0x00000002),
	SERVICE_STATE_ALL=(int)((SERVICE_STATE_ACTIVE|SERVICE_STATE_INACTIVE))
}
#else
 { __do_not_use_enum_svcctl_ServiceState=INT_MAX}
#define SERVICE_STATE_ACTIVE ( 0x00000001 )
#define SERVICE_STATE_INACTIVE ( 0x00000002 )
#define SERVICE_STATE_ALL ( (SERVICE_STATE_ACTIVE|SERVICE_STATE_INACTIVE) )
#endif
;

/* bitmap svcctl_MgrAccessMask */
#define SC_RIGHT_MGR_CONNECT ( 0x0001 )
#define SC_RIGHT_MGR_CREATE_SERVICE ( 0x0002 )
#define SC_RIGHT_MGR_ENUMERATE_SERVICE ( 0x0004 )
#define SC_RIGHT_MGR_LOCK ( 0x0008 )
#define SC_RIGHT_MGR_QUERY_LOCK_STATUS ( 0x0010 )
#define SC_RIGHT_MGR_MODIFY_BOOT_CONFIG ( 0x0020 )

/* bitmap svcctl_ServiceAccessMask */
#define SC_RIGHT_SVC_QUERY_CONFIG ( 0x0001 )
#define SC_RIGHT_SVC_CHANGE_CONFIG ( 0x0002 )
#define SC_RIGHT_SVC_QUERY_STATUS ( 0x0004 )
#define SC_RIGHT_SVC_ENUMERATE_DEPENDENTS ( 0x0008 )
#define SC_RIGHT_SVC_START ( 0x0010 )
#define SC_RIGHT_SVC_STOP ( 0x0020 )
#define SC_RIGHT_SVC_PAUSE_CONTINUE ( 0x0040 )
#define SC_RIGHT_SVC_INTERROGATE ( 0x0080 )
#define SC_RIGHT_SVC_USER_DEFINED_CONTROL ( 0x0100 )

struct QUERY_SERVICE_CONFIG {
	uint32_t service_type;
	enum svcctl_StartType start_type;
	enum svcctl_ErrorControl error_control;
	const char *executablepath;/* [charset(UTF16),range(0,8192),unique] */
	const char *loadordergroup;/* [charset(UTF16),range(0,8192),unique] */
	uint32_t tag_id;
	const char *dependencies;/* [charset(UTF16),range(0,8192),unique] */
	const char *startname;/* [charset(UTF16),range(0,8192),unique] */
	const char *displayname;/* [charset(UTF16),range(0,8192),unique] */
}/* [gensize,public] */;

struct svcctl_ArgumentString {
	const char *string;/* [charset(UTF16),range(0,SC_MAX_ARGUMENT_LENGTH),unique] */
};

enum svcctl_ConfigLevel
#ifndef USE_UINT_ENUMS
 {
	SERVICE_CONFIG_DESCRIPTION=(int)(0x00000001),
	SERVICE_CONFIG_FAILURE_ACTIONS=(int)(0x00000002)
}
#else
 { __do_not_use_enum_svcctl_ConfigLevel=INT_MAX}
#define SERVICE_CONFIG_DESCRIPTION ( 0x00000001 )
#define SERVICE_CONFIG_FAILURE_ACTIONS ( 0x00000002 )
#endif
;

struct SERVICE_DESCRIPTION {
	const char * description;/* [flag(LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2),relative] */
}/* [gensize,public] */;

enum SC_ACTION_TYPE
#ifndef USE_UINT_ENUMS
 {
	SC_ACTION_NONE=(int)(0),
	SC_ACTION_RESTART=(int)(1),
	SC_ACTION_REBOOT=(int)(2),
	SC_ACTION_RUN_COMMAND=(int)(3)
}
#else
 { __do_not_use_enum_SC_ACTION_TYPE=INT_MAX}
#define SC_ACTION_NONE ( 0 )
#define SC_ACTION_RESTART ( 1 )
#define SC_ACTION_REBOOT ( 2 )
#define SC_ACTION_RUN_COMMAND ( 3 )
#endif
;

struct SC_ACTION {
	enum SC_ACTION_TYPE type;
	uint32_t delay;
};

struct SERVICE_FAILURE_ACTIONSW {
	uint32_t reset_period;
	const char * rebootmsg;/* [flag(LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2),relative] */
	const char * command;/* [flag(LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2),relative] */
	uint32_t num_actions;/* [range(0,1024)] */
	struct SC_ACTION *actions;/* [relative,size_is(num_actions)] */
}/* [gensize,public] */;

enum svcctl_StatusLevel
#ifndef USE_UINT_ENUMS
 {
	SVC_STATUS_PROCESS_INFO=(int)(0x00000000)
}
#else
 { __do_not_use_enum_svcctl_StatusLevel=INT_MAX}
#define SVC_STATUS_PROCESS_INFO ( 0x00000000 )
#endif
;

struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 {
	uint64_t ullThreadId;
	uint32_t dwNotifyMask;
	uint8_t CallbackAddressArray[16];
	uint8_t CallbackParamAddressArray[16];
	struct SERVICE_STATUS_PROCESS ServiceStatus;
	uint32_t dwNotificationStatus;
	uint32_t dwSequence;
};

struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 {
	uint64_t ullThreadId;
	uint32_t dwNotifyMask;
	uint8_t CallbackAddressArray[16];
	uint8_t CallbackParamAddressArray[16];
	struct SERVICE_STATUS_PROCESS ServiceStatus;
	uint32_t dwNotificationStatus;
	uint32_t dwSequence;
	uint32_t dwNotificationTriggered;
	const char *pszServiceNames;/* [charset(UTF16),range(0,64*1024),unique] */
};

union SC_RPC_NOTIFY_PARAMS_u {
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *pStatusChangeParam1;/* [case,unique] */
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *pStatusChangeParams;/* [case(2),unique] */
}/* [switch_type(uint32)] */;

struct SC_RPC_NOTIFY_PARAMS {
	uint32_t dwInfoLevel;
	union SC_RPC_NOTIFY_PARAMS_u u;/* [switch_is(dwInfoLevel)] */
};

struct SC_RPC_NOTIFY_PARAMS_LIST {
	uint32_t cElements;/* [range(0,1024*4)] */
	struct SC_RPC_NOTIFY_PARAMS *NotifyParamsArray;/* [size_is(cElements)] */
};

enum svcctl_ServiceStopReasonMain
#ifndef USE_UINT_ENUMS
 {
	SERVICE_STOP_UNPLANNED=(int)(0x10000000),
	SERVICE_STOP_CUSTOM=(int)(0x20000000),
	SERVICE_STOP_PLANNED=(int)(0x40000000)
}
#else
 { __do_not_use_enum_svcctl_ServiceStopReasonMain=INT_MAX}
#define SERVICE_STOP_UNPLANNED ( 0x10000000 )
#define SERVICE_STOP_CUSTOM ( 0x20000000 )
#define SERVICE_STOP_PLANNED ( 0x40000000 )
#endif
;

enum svcctl_ServiceStopReasonMajor
#ifndef USE_UINT_ENUMS
 {
	SERVICE_STOP_REASON_MAJOR_OTHER=(int)(0x00010000),
	SERVICE_STOP_REASON_MAJOR_HARDWARE=(int)(0x00020000),
	SERVICE_STOP_REASON_MAJOR_OPERATINGSYSTEM=(int)(0x00030000),
	SERVICE_STOP_REASON_MAJOR_SOFTWARE=(int)(0x00040000),
	SERVICE_STOP_REASON_MAJOR_APPLICATION=(int)(0x00050000),
	SERVICE_STOP_REASON_MAJOR_NONE=(int)(0x00060000)
}
#else
 { __do_not_use_enum_svcctl_ServiceStopReasonMajor=INT_MAX}
#define SERVICE_STOP_REASON_MAJOR_OTHER ( 0x00010000 )
#define SERVICE_STOP_REASON_MAJOR_HARDWARE ( 0x00020000 )
#define SERVICE_STOP_REASON_MAJOR_OPERATINGSYSTEM ( 0x00030000 )
#define SERVICE_STOP_REASON_MAJOR_SOFTWARE ( 0x00040000 )
#define SERVICE_STOP_REASON_MAJOR_APPLICATION ( 0x00050000 )
#define SERVICE_STOP_REASON_MAJOR_NONE ( 0x00060000 )
#endif
;

enum svcctl_ServiceStopReasonMinor
#ifndef USE_UINT_ENUMS
 {
	SERVICE_STOP_REASON_MINOR_OTHER=(int)(0x00000001),
	SERVICE_STOP_REASON_MINOR_MAINTENANCE=(int)(0x00000002),
	SERVICE_STOP_REASON_MINOR_INSTALLATION=(int)(0x00000003),
	SERVICE_STOP_REASON_MINOR_UPGRADE=(int)(0x00000004),
	SERVICE_STOP_REASON_MINOR_RECONFIG=(int)(0x00000005),
	SERVICE_STOP_REASON_MINOR_HUNG=(int)(0x00000006),
	SERVICE_STOP_REASON_MINOR_UNSTABLE=(int)(0x00000007),
	SERVICE_STOP_REASON_MINOR_DISK=(int)(0x00000008),
	SERVICE_STOP_REASON_MINOR_NETWORKCARD=(int)(0x00000009),
	SERVICE_STOP_REASON_MINOR_ENVIRONMENT=(int)(0x0000000a),
	SERVICE_STOP_REASON_MINOR_HARDWARE_DRIVER=(int)(0x0000000b),
	SERVICE_STOP_REASON_MINOR_OTHERDRIVER=(int)(0x0000000c),
	SERVICE_STOP_REASON_MINOR_SERVICEPACK=(int)(0x0000000d),
	SERVICE_STOP_REASON_MINOR_SOFTWARE_UPDATE=(int)(0x0000000e),
	SERVICE_STOP_REASON_MINOR_SECURITYFIX=(int)(0x0000000f),
	SERVICE_STOP_REASON_MINOR_SECURITY=(int)(0x00000010),
	SERVICE_STOP_REASON_MINOR_NETWORK_CONNECTIVITY=(int)(0x00000011),
	SERVICE_STOP_REASON_MINOR_WMI=(int)(0x00000012),
	SERVICE_STOP_REASON_MINOR_SERVICEPACK_UNINSTALL=(int)(0x00000013),
	SERVICE_STOP_REASON_MINOR_SOFTWARE_UPDATE_UNINSTALL=(int)(0x00000014),
	SERVICE_STOP_REASON_MINOR_SECURITYFIX_UNINSTALL=(int)(0x00000015),
	SERVICE_STOP_REASON_MINOR_MMC=(int)(0x00000016),
	SERVICE_STOP_REASON_MINOR_NONE=(int)(0x00000017)
}
#else
 { __do_not_use_enum_svcctl_ServiceStopReasonMinor=INT_MAX}
#define SERVICE_STOP_REASON_MINOR_OTHER ( 0x00000001 )
#define SERVICE_STOP_REASON_MINOR_MAINTENANCE ( 0x00000002 )
#define SERVICE_STOP_REASON_MINOR_INSTALLATION ( 0x00000003 )
#define SERVICE_STOP_REASON_MINOR_UPGRADE ( 0x00000004 )
#define SERVICE_STOP_REASON_MINOR_RECONFIG ( 0x00000005 )
#define SERVICE_STOP_REASON_MINOR_HUNG ( 0x00000006 )
#define SERVICE_STOP_REASON_MINOR_UNSTABLE ( 0x00000007 )
#define SERVICE_STOP_REASON_MINOR_DISK ( 0x00000008 )
#define SERVICE_STOP_REASON_MINOR_NETWORKCARD ( 0x00000009 )
#define SERVICE_STOP_REASON_MINOR_ENVIRONMENT ( 0x0000000a )
#define SERVICE_STOP_REASON_MINOR_HARDWARE_DRIVER ( 0x0000000b )
#define SERVICE_STOP_REASON_MINOR_OTHERDRIVER ( 0x0000000c )
#define SERVICE_STOP_REASON_MINOR_SERVICEPACK ( 0x0000000d )
#define SERVICE_STOP_REASON_MINOR_SOFTWARE_UPDATE ( 0x0000000e )
#define SERVICE_STOP_REASON_MINOR_SECURITYFIX ( 0x0000000f )
#define SERVICE_STOP_REASON_MINOR_SECURITY ( 0x00000010 )
#define SERVICE_STOP_REASON_MINOR_NETWORK_CONNECTIVITY ( 0x00000011 )
#define SERVICE_STOP_REASON_MINOR_WMI ( 0x00000012 )
#define SERVICE_STOP_REASON_MINOR_SERVICEPACK_UNINSTALL ( 0x00000013 )
#define SERVICE_STOP_REASON_MINOR_SOFTWARE_UPDATE_UNINSTALL ( 0x00000014 )
#define SERVICE_STOP_REASON_MINOR_SECURITYFIX_UNINSTALL ( 0x00000015 )
#define SERVICE_STOP_REASON_MINOR_MMC ( 0x00000016 )
#define SERVICE_STOP_REASON_MINOR_NONE ( 0x00000017 )
#endif
;

struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA {
	uint32_t dwReason;
	const char *szComment;/* [charset(DOS),range(0,SC_MAX_COMMENT_LENGTH),unique] */
};

struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS {
	struct SERVICE_STATUS_PROCESS ServiceStatus;
};

union SC_RPC_SERVICE_CONTROL_IN_PARAMSA {
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA *psrInParams;/* [case,unique] */
}/* [switch_type(uint32)] */;

union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA {
	struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS *psrOutParams;/* [case,unique] */
}/* [switch_type(uint32)] */;

struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW {
	uint32_t dwReason;
	const char *pszComment;/* [charset(UTF16),range(0,SC_MAX_COMMENT_LENGTH),unique] */
};

union SC_RPC_SERVICE_CONTROL_IN_PARAMSW {
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW *psrInParams;/* [case,unique] */
}/* [switch_type(uint32)] */;

union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW {
	struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS *psrOutParams;/* [case,unique] */
}/* [switch_type(uint32)] */;

struct SERVICE_DESCRIPTIONW {
	const char *lpDescription;/* [charset(UTF16),range(0,8*1024),unique] */
};

struct SERVICE_DELAYED_AUTO_START_INFO {
	uint32_t fDelayedAutostart;
};

struct SERVICE_FAILURE_ACTIONS_FLAG {
	uint32_t fFailureActionsOnNonCrashFailures;
};

struct SERVICE_SID_INFO {
	uint32_t dwServiceSidType;
};

struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO {
	uint32_t cbRequiredPrivileges;/* [range(0,1024*4)] */
	uint8_t *pRequiredPrivileges;/* [size_is(cbRequiredPrivileges),unique] */
};

struct SERVICE_PRESHUTDOWN_INFO {
	uint32_t dwPreshutdownTimeout;
};

struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM {
	uint32_t dwDataType;
	uint32_t cbData;/* [range(0,1024)] */
	uint8_t *pData;/* [size_is(cbData),unique] */
};

struct SERVICE_TRIGGER {
	uint32_t dwTriggerType;
	uint32_t dwAction;
	struct GUID *pTriggerSubtype;/* [unique] */
	uint32_t cDataItems;/* [range(0,64)] */
	struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *pDataItems;/* [size_is(cDataItems),unique] */
};

struct SERVICE_TRIGGER_INFO {
	uint32_t cTriggers;/* [range(0,64)] */
	struct SERVICE_TRIGGER *pTriggers;/* [size_is(cTriggers),unique] */
	uint8_t *pReserved;/* [unique] */
};

struct SERVICE_PREFERRED_NODE_INFO {
	uint16_t usPreferredNode;
	uint32_t fDelete;
};

union SC_RPC_CONFIG_INFOW_u {
	struct SERVICE_DESCRIPTIONW *psd;/* [case,unique] */
	struct SERVICE_FAILURE_ACTIONSW *psfa;/* [case(2),unique] */
	struct SERVICE_DELAYED_AUTO_START_INFO *psda;/* [case(3),unique] */
	struct SERVICE_FAILURE_ACTIONS_FLAG *psfaf;/* [case(4),unique] */
	struct SERVICE_SID_INFO *pssid;/* [case(5),unique] */
	struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO *psrp;/* [case(6),unique] */
	struct SERVICE_PRESHUTDOWN_INFO *psps;/* [case(7),unique] */
	struct SERVICE_TRIGGER_INFO *psti;/* [case(8),unique] */
	struct SERVICE_PREFERRED_NODE_INFO *pspn;/* [case(9),unique] */
}/* [switch_type(uint32)] */;

struct SC_RPC_CONFIG_INFOW {
	uint32_t dwInfoLevel;
	union SC_RPC_CONFIG_INFOW_u u;/* [switch_is(dwInfoLevel)] */
};


struct svcctl_CloseServiceHandle {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_ControlService {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum SERVICE_CONTROL control;
	} in;

	struct {
		struct SERVICE_STATUS *service_status;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_DeleteService {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct svcctl_LockServiceDatabase {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *lock;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_QueryServiceObjectSecurity {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t security_flags;
		uint32_t offered;/* [range(0,0x40000)] */
	} in;

	struct {
		uint8_t *buffer;/* [ref,size_is(offered)] */
		uint32_t *needed;/* [range(0,0x40000),ref] */
		WERROR result;
	} out;

};


struct svcctl_SetServiceObjectSecurity {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t security_flags;
		uint8_t *buffer;/* [ref,size_is(offered)] */
		uint32_t offered;
	} in;

	struct {
		WERROR result;
	} out;

};


struct svcctl_QueryServiceStatus {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct SERVICE_STATUS *service_status;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_SetServiceStatus {
	struct {
		WERROR result;
	} out;

};


struct svcctl_UnlockServiceDatabase {
	struct {
		struct policy_handle *lock;/* [ref] */
	} in;

	struct {
		struct policy_handle *lock;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_NotifyBootConfigStatus {
	struct {
		WERROR result;
	} out;

};


struct svcctl_SCSetServiceBitsW {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t bits;
		uint32_t bitson;
		uint32_t immediate;
	} in;

	struct {
		WERROR result;
	} out;

};


struct svcctl_ChangeServiceConfigW {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t type;
		enum svcctl_StartType start_type;
		enum svcctl_ErrorControl error_control;
		const char *binary_path;/* [charset(UTF16),unique] */
		const char *load_order_group;/* [charset(UTF16),unique] */
		const char *dependencies;/* [charset(UTF16),size_is(dwDependSize),unique] */
		uint32_t dwDependSize;/* [range(0,SC_MAX_DEPEND_SIZE)] */
		const char *service_start_name;/* [charset(UTF16),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */
		const char *password;/* [charset(UTF16),size_is(dwPwSize),unique] */
		uint32_t dwPwSize;/* [range(0,SC_MAX_PWD_SIZE)] */
		const char *display_name;/* [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */
		uint32_t *tag_id;/* [unique] */
	} in;

	struct {
		uint32_t *tag_id;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_CreateServiceW {
	struct {
		struct policy_handle *scmanager_handle;/* [ref] */
		const char *ServiceName;/* [charset(UTF16)] */
		const char *DisplayName;/* [charset(UTF16),unique] */
		uint32_t desired_access;
		uint32_t type;
		enum svcctl_StartType start_type;
		enum svcctl_ErrorControl error_control;
		const char *binary_path;/* [charset(UTF16)] */
		const char *LoadOrderGroupKey;/* [charset(UTF16),unique] */
		uint8_t *dependencies;/* [size_is(dependencies_size),unique] */
		uint32_t dependencies_size;
		const char *service_start_name;/* [charset(UTF16),unique] */
		uint8_t *password;/* [size_is(password_size),unique] */
		uint32_t password_size;
		uint32_t *TagId;/* [unique] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t *TagId;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_EnumDependentServicesW {
	struct {
		struct policy_handle *service;/* [ref] */
		enum svcctl_ServiceState state;
		uint32_t offered;/* [range(0,0x40000)] */
	} in;

	struct {
		uint8_t *service_status;/* [ref,size_is(offered)] */
		uint32_t *needed;/* [range(0,0x40000),ref] */
		uint32_t *services_returned;/* [range(0,0x40000),ref] */
		WERROR result;
	} out;

};


struct svcctl_EnumServicesStatusW {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t type;
		enum svcctl_ServiceState state;
		uint32_t offered;/* [range(0,0x40000)] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint8_t *service;/* [ref,size_is(offered)] */
		uint32_t *needed;/* [range(0,0x40000),ref] */
		uint32_t *services_returned;/* [range(0,0x40000),ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_OpenSCManagerW {
	struct {
		const char *MachineName;/* [charset(UTF16),unique] */
		const char *DatabaseName;/* [charset(UTF16),unique] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_OpenServiceW {
	struct {
		struct policy_handle *scmanager_handle;/* [ref] */
		const char *ServiceName;/* [charset(UTF16)] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_QueryServiceConfigW {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t offered;/* [range(0,8192)] */
	} in;

	struct {
		struct QUERY_SERVICE_CONFIG *query;/* [ref] */
		uint32_t *needed;/* [range(0,8192),ref] */
		WERROR result;
	} out;

};


struct svcctl_QueryServiceLockStatusW {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t offered;
	} in;

	struct {
		struct SERVICE_LOCK_STATUS *lock_status;/* [ref] */
		uint32_t *needed;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_StartServiceW {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t NumArgs;/* [range(0,SC_MAX_ARGUMENTS)] */
		struct svcctl_ArgumentString *Arguments;/* [size_is(NumArgs),unique] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct svcctl_GetServiceDisplayNameW {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *service_name;/* [charset(UTF16),unique] */
		uint32_t *display_name_length;/* [unique] */
	} in;

	struct {
		const char **display_name;/* [charset(UTF16),ref] */
		uint32_t *display_name_length;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_GetServiceKeyNameW {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *service_name;/* [charset(UTF16),unique] */
		uint32_t *display_name_length;/* [unique] */
	} in;

	struct {
		const char **key_name;/* [charset(UTF16),ref] */
		uint32_t *display_name_length;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_SCSetServiceBitsA {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t bits;
		uint32_t bitson;
		uint32_t immediate;
	} in;

	struct {
		WERROR result;
	} out;

};


struct svcctl_ChangeServiceConfigA {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t type;
		enum svcctl_StartType start_type;
		enum svcctl_ErrorControl error_control;
		const char *binary_path;/* [charset(UTF16),unique] */
		const char *load_order_group;/* [charset(UTF16),unique] */
		const char *dependencies;/* [charset(UTF16),unique] */
		const char *service_start_name;/* [charset(UTF16),unique] */
		const char *password;/* [charset(UTF16),unique] */
		const char *display_name;/* [charset(UTF16),unique] */
	} in;

	struct {
		uint32_t *tag_id;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_CreateServiceA {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *ServiceName;/* [charset(UTF16),unique] */
		const char *DisplayName;/* [charset(UTF16),unique] */
		uint32_t desired_access;
		uint32_t type;
		enum svcctl_StartType start_type;
		enum svcctl_ErrorControl error_control;
		const char *binary_path;/* [charset(UTF16),unique] */
		const char *LoadOrderGroupKey;/* [charset(UTF16),unique] */
		const char *dependencies;/* [charset(UTF16),unique] */
		const char *service_start_name;/* [charset(UTF16),unique] */
		const char *password;/* [charset(UTF16),unique] */
	} in;

	struct {
		uint32_t *TagId;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_EnumDependentServicesA {
	struct {
		struct policy_handle *service;/* [ref] */
		enum svcctl_ServiceState state;
		uint32_t offered;
	} in;

	struct {
		struct ENUM_SERVICE_STATUSA *service_status;/* [unique] */
		uint32_t *needed;/* [ref] */
		uint32_t *services_returned;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_EnumServicesStatusA {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t type;
		enum svcctl_ServiceState state;
		uint32_t offered;
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint8_t *service;/* [size_is(offered)] */
		uint32_t *needed;/* [ref] */
		uint32_t *services_returned;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_OpenSCManagerA {
	struct {
		const char *MachineName;/* [charset(UTF16),unique] */
		const char *DatabaseName;/* [charset(UTF16),unique] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_OpenServiceA {
	struct {
		struct policy_handle *scmanager_handle;/* [ref] */
		const char *ServiceName;/* [charset(UTF16),unique] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_QueryServiceConfigA {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t offered;
	} in;

	struct {
		uint8_t *query;
		uint32_t *needed;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_QueryServiceLockStatusA {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t offered;
	} in;

	struct {
		struct SERVICE_LOCK_STATUS *lock_status;/* [ref] */
		uint32_t *needed;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_StartServiceA {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t NumArgs;
		const char *Arguments;/* [charset(UTF16),unique] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct svcctl_GetServiceDisplayNameA {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *service_name;/* [charset(UTF16),unique] */
		uint32_t *display_name_length;/* [unique] */
	} in;

	struct {
		const char **display_name;/* [charset(UTF16),ref] */
		uint32_t *display_name_length;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_GetServiceKeyNameA {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *service_name;/* [charset(UTF16),unique] */
		uint32_t *display_name_length;/* [unique] */
	} in;

	struct {
		const char **key_name;/* [charset(UTF16),ref] */
		uint32_t *display_name_length;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_GetCurrentGroupeStateW {
	struct {
		WERROR result;
	} out;

};


struct svcctl_EnumServiceGroupW {
	struct {
		WERROR result;
	} out;

};


struct svcctl_ChangeServiceConfig2A {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t info_level;
		uint8_t *info;/* [unique] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct svcctl_ChangeServiceConfig2W {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t info_level;
		uint8_t *info;/* [unique] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct svcctl_QueryServiceConfig2A {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum svcctl_ConfigLevel info_level;
		uint32_t offered;
	} in;

	struct {
		uint8_t *buffer;
		uint32_t *needed;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_QueryServiceConfig2W {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum svcctl_ConfigLevel info_level;
		uint32_t offered;/* [range(0,8192)] */
	} in;

	struct {
		uint8_t *buffer;/* [ref,size_is(offered)] */
		uint32_t *needed;/* [range(0,8192),ref] */
		WERROR result;
	} out;

};


struct svcctl_QueryServiceStatusEx {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum svcctl_StatusLevel info_level;
		uint32_t offered;/* [range(0,8192)] */
	} in;

	struct {
		uint8_t *buffer;/* [ref,size_is(offered)] */
		uint32_t *needed;/* [range(0,8192),ref] */
		WERROR result;
	} out;

};


struct svcctl_EnumServicesStatusExA {
	struct {
		struct policy_handle *scmanager;/* [ref] */
		uint32_t info_level;
		uint32_t type;
		enum svcctl_ServiceState state;
		uint32_t offered;
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint8_t *services;
		uint32_t *needed;/* [ref] */
		uint32_t *service_returned;/* [ref] */
		const char **group_name;/* [charset(UTF16),ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_EnumServicesStatusExW {
	struct {
		struct policy_handle *scmanager;/* [ref] */
		uint32_t info_level;
		uint32_t type;
		enum svcctl_ServiceState state;
		uint32_t offered;/* [range(0,0x40000)] */
		const char *group_name;/* [charset(UTF16),unique] */
		uint32_t *resume_handle;/* [range(0,0x40000),unique] */
	} in;

	struct {
		uint8_t *services;/* [ref,size_is(offered)] */
		uint32_t *needed;/* [range(0,0x40000),ref] */
		uint32_t *service_returned;/* [range(0,0x40000),ref] */
		uint32_t *resume_handle;/* [range(0,0x40000),unique] */
		WERROR result;
	} out;

};


struct svcctl_SCSendTSMessage {
	struct {
		WERROR result;
	} out;

};


struct svcctl_CreateServiceWOW64A {
	struct {
		struct policy_handle hSCManager;
		const char *lpServiceName;/* [charset(DOS),range(0,SC_MAX_NAME_LENGTH),ref] */
		const char *lpDisplayName;/* [charset(DOS),range(0,SC_MAX_NAME_LENGTH),unique] */
		uint32_t dwDesiredAccess;
		uint32_t dwServiceType;
		uint32_t dwStartType;
		uint32_t dwErrorControl;
		const char *lpBinaryPathName;/* [charset(DOS),range(0,SC_MAX_PATH_LENGTH),ref] */
		const char *lpLoadOrderGroup;/* [charset(DOS),range(0,SC_MAX_NAME_LENGTH),unique] */
		uint8_t *lpDependencies;/* [size_is(dwDependSize),unique] */
		uint32_t dwDependSize;/* [range(0,SC_MAX_DEPEND_SIZE)] */
		const char *lpServiceStartName;/* [charset(DOS),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */
		uint8_t *lpPassword;/* [size_is(dwPwSize),unique] */
		uint32_t dwPwSize;/* [range(0,SC_MAX_PWD_SIZE)] */
		uint32_t *lpdwTagId;/* [unique] */
	} in;

	struct {
		struct policy_handle *lpServiceHandle;/* [ref] */
		uint32_t *lpdwTagId;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_CreateServiceWOW64W {
	struct {
		struct policy_handle hSCManager;
		const char *lpServiceName;/* [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),ref] */
		const char *lpDisplayName;/* [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */
		uint32_t dwDesiredAccess;
		uint32_t dwServiceType;
		uint32_t dwStartType;
		uint32_t dwErrorControl;
		const char *lpBinaryPathName;/* [charset(UTF16),range(0,SC_MAX_PATH_LENGTH),ref] */
		const char *lpLoadOrderGroup;/* [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */
		uint8_t *lpDependencies;/* [size_is(dwDependSize),unique] */
		uint32_t dwDependSize;/* [range(0,SC_MAX_DEPEND_SIZE)] */
		const char *lpServiceStartName;/* [charset(UTF16),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */
		uint8_t *lpPassword;/* [size_is(dwPwSize),unique] */
		uint32_t dwPwSize;/* [range(0,SC_MAX_PWD_SIZE)] */
		uint32_t *lpdwTagId;/* [unique] */
	} in;

	struct {
		struct policy_handle *lpServiceHandle;/* [ref] */
		uint32_t *lpdwTagId;/* [unique] */
		WERROR result;
	} out;

};


struct Opnum46NotUsedOnWire {
	int _dummy_element;
};


struct svcctl_NotifyServiceStatusChange {
	struct {
		struct policy_handle hService;
		struct SC_RPC_NOTIFY_PARAMS NotifyParams;
		struct GUID *pClientProcessGuid;/* [ref] */
	} in;

	struct {
		struct GUID *pSCMProcessGuid;/* [ref] */
		uint32_t *pfCreateRemoteQueue;/* [ref] */
		struct policy_handle *phNotify;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_GetNotifyResults {
	struct {
		struct policy_handle hNotify;
	} in;

	struct {
		struct SC_RPC_NOTIFY_PARAMS_LIST *ppNotifyParams;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_CloseNotifyHandle {
	struct {
		struct policy_handle *phNotify;/* [ref] */
	} in;

	struct {
		uint32_t *pfApcFired;/* [ref] */
		struct policy_handle *phNotify;/* [ref] */
		WERROR result;
	} out;

};


struct svcctl_ControlServiceExA {
	struct {
		struct policy_handle hService;
		enum SERVICE_CONTROL dwControl;
		uint32_t dwInfoLevel;
		union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *pControlInParams;/* [ref,switch_is(dwInfoLevel)] */
	} in;

	struct {
		union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *pControlOutParams;/* [ref,switch_is(dwInfoLevel)] */
		WERROR result;
	} out;

};


struct svcctl_ControlServiceExW {
	struct {
		struct policy_handle hService;
		enum SERVICE_CONTROL dwControl;
		uint32_t dwInfoLevel;
		union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *pControlInParams;/* [ref,switch_is(dwInfoLevel)] */
	} in;

	struct {
		union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *pControlOutParams;/* [ref,switch_is(dwInfoLevel)] */
		WERROR result;
	} out;

};


struct Opnum52NotUsedOnWire {
	int _dummy_element;
};


struct Opnum53NotUsedOnWire {
	int _dummy_element;
};


struct Opnum54NotUsedOnWire {
	int _dummy_element;
};


struct Opnum55NotUsedOnWire {
	int _dummy_element;
};


struct svcctl_QueryServiceConfigEx {
	struct {
		struct policy_handle hService;
		uint32_t dwInfoLevel;
	} in;

	struct {
		struct SC_RPC_CONFIG_INFOW *pInfo;/* [ref] */
		WERROR result;
	} out;

};


struct Opnum57NotUsedOnWire {
	int _dummy_element;
};


struct Opnum58NotUsedOnWire {
	int _dummy_element;
};


struct Opnum59NotUsedOnWire {
	int _dummy_element;
};


struct svcctl_CreateWowService {
	struct {
		struct policy_handle hSCManager;
		const char *lpServiceName;/* [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),ref] */
		const char *lpDisplayName;/* [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */
		uint32_t dwDesiredAccess;
		uint32_t dwServiceType;
		uint32_t dwStartType;
		uint32_t dwErrorControl;
		const char *lpBinaryPathName;/* [charset(UTF16),range(0,SC_MAX_PATH_LENGTH),ref] */
		const char *lpLoadOrderGroup;/* [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */
		uint8_t *lpDependencies;/* [size_is(dwDependSize),unique] */
		uint32_t dwDependSize;/* [range(0,SC_MAX_DEPEND_SIZE)] */
		const char *lpServiceStartName;/* [charset(UTF16),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */
		uint8_t *lpPassword;/* [size_is(dwPwSize),unique] */
		uint32_t dwPwSize;/* [range(0,SC_MAX_PWD_SIZE)] */
		uint16_t dwServiceWowType;
		uint32_t *lpdwTagId;/* [unique] */
	} in;

	struct {
		struct policy_handle *lpServiceHandle;/* [ref] */
		uint32_t *lpdwTagId;/* [unique] */
		WERROR result;
	} out;

};


struct svcctl_OpenSCManager2 {
	struct {
		struct policy_handle BindingHandle;
		const char *DatabaseName;/* [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */
		uint32_t DesiredAccess;
	} in;

	struct {
		struct policy_handle *ScmHandle;/* [ref] */
		WERROR result;
	} out;

};

#endif /* _HEADER_svcctl */
#endif /* _PIDL_HEADER_svcctl */
