/* localsearch-metadata-container.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-metadata-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "rygel-server.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <tinysparql.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_LOCAL_SEARCH_METADATA_CONTAINER_0_PROPERTY,
	RYGEL_LOCAL_SEARCH_METADATA_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_local_search_metadata_container_properties[RYGEL_LOCAL_SEARCH_METADATA_CONTAINER_NUM_PROPERTIES];
#define _rygel_local_search_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_local_search_item_factory_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_local_search_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_local_search_query_unref (var), NULL)))
typedef struct _RygelLocalSearchMetadataContainerFetchMetadataValuesData RygelLocalSearchMetadataContainerFetchMetadataValuesData;
typedef struct _RygelLocalSearchMetadataContainerFindObjectData RygelLocalSearchMetadataContainerFindObjectData;

struct _RygelLocalSearchMetadataContainerPrivate {
	gboolean update_in_progress;
	gchar* child_class;
};

struct _RygelLocalSearchMetadataContainerFetchMetadataValuesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchMetadataContainer* self;
	RygelLocalSearchSelectionQuery* query;
	RygelLocalSearchSelectionQuery* _tmp0_;
	RygelLocalSearchSelectionQuery* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	gboolean _tmp3_;
	RygelLocalSearchSelectionQuery* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	RygelLocalSearchSelectionQuery* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	gchar* value;
	RygelLocalSearchSelectionQuery* _tmp8_;
	TrackerSparqlCursor* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* title;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* id;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	RygelLocalSearchSearchContainer* container;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	RygelLocalSearchSearchContainer* _tmp24_;
	const gchar* _tmp25_;
	RygelLocalSearchSearchContainer* _tmp26_;
	const gchar* _tmp27_;
	RygelLocalSearchSearchContainer* _tmp28_;
	RygelLocalSearchSelectionQuery* _tmp29_;
	TrackerSparqlCursor* _tmp30_;
	GError* _error_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GError* _tmp33_;
	const gchar* _tmp34_;
	GError* _inner_error0_;
};

struct _RygelLocalSearchMetadataContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchMetadataContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	GError* _inner_error0_;
};

static gint RygelLocalSearchMetadataContainer_private_offset;
static gpointer rygel_local_search_metadata_container_parent_class = NULL;

static void rygel_local_search_metadata_container_fetch_metadata_values_data_free (gpointer _data);
VALA_EXTERN void rygel_local_search_metadata_container_fetch_metadata_values (RygelLocalSearchMetadataContainer* self,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
VALA_EXTERN void rygel_local_search_metadata_container_fetch_metadata_values_finish (RygelLocalSearchMetadataContainer* self,
                                                                         GAsyncResult* _res_);
static gboolean rygel_local_search_metadata_container_fetch_metadata_values_co (RygelLocalSearchMetadataContainerFetchMetadataValuesData* _data_);
static void rygel_local_search_metadata_container_fetch_metadata_values_ready (GObject* source_object,
                                                                        GAsyncResult* _res_,
                                                                        gpointer _user_data_);
static RygelLocalSearchSelectionQuery* rygel_local_search_metadata_container_real_create_query (RygelLocalSearchMetadataContainer* self);
static RygelLocalSearchSearchContainer* rygel_local_search_metadata_container_real_create_container (RygelLocalSearchMetadataContainer* self,
                                                                                              const gchar* id,
                                                                                              const gchar* title,
                                                                                              const gchar* value);
static void rygel_local_search_metadata_container_real_find_object_data_free (gpointer _data);
static void rygel_local_search_metadata_container_real_find_object (RygelMediaContainer* base,
                                                             const gchar* id,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean rygel_local_search_metadata_container_real_find_object_co (RygelLocalSearchMetadataContainerFindObjectData* _data_);
static gboolean rygel_local_search_metadata_container_is_our_child (RygelLocalSearchMetadataContainer* self,
                                                             const gchar* id);
static void rygel_local_search_metadata_container_find_object_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static gchar* rygel_local_search_metadata_container_real_create_id_for_title (RygelLocalSearchMetadataContainer* self,
                                                                       const gchar* title);
static gchar* rygel_local_search_metadata_container_real_create_title_for_value (RygelLocalSearchMetadataContainer* self,
                                                                          const gchar* value);
static gchar* rygel_local_search_metadata_container_real_create_filter (RygelLocalSearchMetadataContainer* self,
                                                                 const gchar* variable,
                                                                 const gchar* value);
static void rygel_local_search_metadata_container_finalize (GObject * obj);
static GType rygel_local_search_metadata_container_get_type_once (void);

static inline gpointer
rygel_local_search_metadata_container_get_instance_private (RygelLocalSearchMetadataContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelLocalSearchMetadataContainer_private_offset);
}

static gpointer
_rygel_local_search_item_factory_ref0 (gpointer self)
{
	return self ? rygel_local_search_item_factory_ref (self) : NULL;
}

RygelLocalSearchMetadataContainer*
rygel_local_search_metadata_container_construct (GType object_type,
                                                 const gchar* id,
                                                 RygelMediaContainer* parent,
                                                 const gchar* title,
                                                 RygelLocalSearchItemFactory* item_factory,
                                                 const gchar* child_class)
{
	RygelLocalSearchMetadataContainer * self = NULL;
	RygelLocalSearchItemFactory* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (item_factory != NULL, NULL);
	self = (RygelLocalSearchMetadataContainer*) rygel_simple_container_construct (object_type, id, parent, title);
	_tmp0_ = _rygel_local_search_item_factory_ref0 (item_factory);
	_rygel_local_search_item_factory_unref0 (self->item_factory);
	self->item_factory = _tmp0_;
	_tmp1_ = g_strdup (child_class);
	_g_free0 (self->priv->child_class);
	self->priv->child_class = _tmp1_;
	return self;
}

static void
rygel_local_search_metadata_container_fetch_metadata_values_data_free (gpointer _data)
{
	RygelLocalSearchMetadataContainerFetchMetadataValuesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchMetadataContainerFetchMetadataValuesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
rygel_local_search_metadata_container_fetch_metadata_values (RygelLocalSearchMetadataContainer* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	RygelLocalSearchMetadataContainerFetchMetadataValuesData* _data_;
	RygelLocalSearchMetadataContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelLocalSearchMetadataContainerFetchMetadataValuesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_metadata_container_fetch_metadata_values_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_local_search_metadata_container_fetch_metadata_values_co (_data_);
}

void
rygel_local_search_metadata_container_fetch_metadata_values_finish (RygelLocalSearchMetadataContainer* self,
                                                                    GAsyncResult* _res_)
{
	RygelLocalSearchMetadataContainerFetchMetadataValuesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_local_search_metadata_container_fetch_metadata_values_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_)
{
	RygelLocalSearchMetadataContainerFetchMetadataValuesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_local_search_metadata_container_fetch_metadata_values_co (_data_);
}

static gboolean
rygel_local_search_metadata_container_fetch_metadata_values_co (RygelLocalSearchMetadataContainerFetchMetadataValuesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->update_in_progress) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->update_in_progress = TRUE;
	rygel_simple_container_clear ((RygelSimpleContainer*) _data_->self);
	_data_->_tmp0_ = rygel_local_search_metadata_container_create_query (_data_->self);
	_data_->query = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->query;
		_data_->_tmp2_ = rygel_local_search_root_container_connection;
		_data_->_state_ = 1;
		rygel_local_search_query_execute ((RygelLocalSearchQuery*) _data_->_tmp1_, _data_->_tmp2_, rygel_local_search_metadata_container_fetch_metadata_values_ready, _data_);
		return FALSE;
		_state_1:
		rygel_local_search_query_execute_finish ((RygelLocalSearchQuery*) _data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			_data_->_tmp4_ = _data_->query;
			_data_->_tmp5_ = _data_->_tmp4_->result;
			_data_->_tmp3_ = tracker_sparql_cursor_next (_data_->_tmp5_, NULL, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (!_data_->_tmp3_) {
				break;
			}
			_data_->_tmp6_ = _data_->query;
			_data_->_tmp7_ = _data_->_tmp6_->result;
			if (!tracker_sparql_cursor_is_bound (_data_->_tmp7_, 0)) {
				continue;
			}
			_data_->_tmp8_ = _data_->query;
			_data_->_tmp9_ = _data_->_tmp8_->result;
			_data_->_tmp10_ = tracker_sparql_cursor_get_string (_data_->_tmp9_, 0, NULL);
			_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
			_data_->value = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->value;
			if (g_strcmp0 (_data_->_tmp12_, "") == 0) {
				_g_free0 (_data_->value);
				continue;
			}
			_data_->_tmp13_ = _data_->value;
			_data_->_tmp14_ = rygel_local_search_metadata_container_create_title_for_value (_data_->self, _data_->_tmp13_);
			_data_->title = _data_->_tmp14_;
			_data_->_tmp15_ = _data_->title;
			if (_data_->_tmp15_ == NULL) {
				_g_free0 (_data_->title);
				_g_free0 (_data_->value);
				continue;
			}
			_data_->_tmp16_ = _data_->title;
			_data_->_tmp17_ = rygel_local_search_metadata_container_create_id_for_title (_data_->self, _data_->_tmp16_);
			_data_->id = _data_->_tmp17_;
			_data_->_tmp19_ = _data_->id;
			if (_data_->_tmp19_ == NULL) {
				_data_->_tmp18_ = TRUE;
			} else {
				_data_->_tmp20_ = _data_->id;
				_data_->_tmp18_ = !rygel_simple_container_is_child_id_unique ((RygelSimpleContainer*) _data_->self, _data_->_tmp20_);
			}
			if (_data_->_tmp18_) {
				_g_free0 (_data_->id);
				_g_free0 (_data_->title);
				_g_free0 (_data_->value);
				continue;
			}
			_data_->_tmp21_ = _data_->id;
			_data_->_tmp22_ = _data_->title;
			_data_->_tmp23_ = _data_->value;
			_data_->_tmp24_ = rygel_local_search_metadata_container_create_container (_data_->self, _data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_);
			_data_->container = _data_->_tmp24_;
			_data_->_tmp25_ = _data_->self->priv->child_class;
			if (_data_->_tmp25_ != NULL) {
				_data_->_tmp26_ = _data_->container;
				_data_->_tmp27_ = _data_->self->priv->child_class;
				rygel_media_object_set_upnp_class ((RygelMediaObject*) _data_->_tmp26_, _data_->_tmp27_);
			}
			_data_->_tmp28_ = _data_->container;
			rygel_simple_container_add_child_container ((RygelSimpleContainer*) _data_->self, (RygelMediaContainer*) _data_->_tmp28_);
			_g_object_unref0 (_data_->container);
			_g_free0 (_data_->id);
			_g_free0 (_data_->title);
			_g_free0 (_data_->value);
		}
		_data_->_tmp29_ = _data_->query;
		_data_->_tmp30_ = _data_->_tmp29_->result;
		tracker_sparql_cursor_close (_data_->_tmp30_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp31_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = _data_->_error_;
		_data_->_tmp34_ = _data_->_tmp33_->message;
		g_critical (_ ("Error getting all values for “%s”: %s"), _data_->_tmp32_, _data_->_tmp34_);
		_data_->self->priv->update_in_progress = FALSE;
		_g_error_free0 (_data_->_error_);
		_rygel_local_search_query_unref0 (_data_->query);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_rygel_local_search_query_unref0 (_data_->query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	_data_->self->priv->update_in_progress = FALSE;
	_rygel_local_search_query_unref0 (_data_->query);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static RygelLocalSearchSelectionQuery*
rygel_local_search_metadata_container_real_create_query (RygelLocalSearchMetadataContainer* self)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_local_search_metadata_container_create_query'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

RygelLocalSearchSelectionQuery*
rygel_local_search_metadata_container_create_query (RygelLocalSearchMetadataContainer* self)
{
	RygelLocalSearchMetadataContainerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_LOCAL_SEARCH_METADATA_CONTAINER_GET_CLASS (self);
	if (_klass_->create_query) {
		return _klass_->create_query (self);
	}
	return NULL;
}

static RygelLocalSearchSearchContainer*
rygel_local_search_metadata_container_real_create_container (RygelLocalSearchMetadataContainer* self,
                                                             const gchar* id,
                                                             const gchar* title,
                                                             const gchar* value)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_local_search_metadata_container_create_container'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

RygelLocalSearchSearchContainer*
rygel_local_search_metadata_container_create_container (RygelLocalSearchMetadataContainer* self,
                                                        const gchar* id,
                                                        const gchar* title,
                                                        const gchar* value)
{
	RygelLocalSearchMetadataContainerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_LOCAL_SEARCH_METADATA_CONTAINER_GET_CLASS (self);
	if (_klass_->create_container) {
		return _klass_->create_container (self, id, title, value);
	}
	return NULL;
}

static void
rygel_local_search_metadata_container_real_find_object_data_free (gpointer _data)
{
	RygelLocalSearchMetadataContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchMetadataContainerFindObjectData, _data_);
}

static void
rygel_local_search_metadata_container_real_find_object (RygelMediaContainer* base,
                                                        const gchar* id,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	RygelLocalSearchMetadataContainer * self;
	RygelLocalSearchMetadataContainerFindObjectData* _data_;
	RygelLocalSearchMetadataContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (id != NULL);
	self = (RygelLocalSearchMetadataContainer*) base;
	_data_ = g_slice_new0 (RygelLocalSearchMetadataContainerFindObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_metadata_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_local_search_metadata_container_real_find_object_co (_data_);
}

static RygelMediaObject*
rygel_local_search_metadata_container_find_object_finish (RygelMediaContainer* base,
                                                          GAsyncResult* _res_,
                                                          GError** error)
{
	RygelMediaObject* result;
	RygelLocalSearchMetadataContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_local_search_metadata_container_find_object_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	RygelLocalSearchMetadataContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_local_search_metadata_container_real_find_object_co (_data_);
}

static gboolean
rygel_local_search_metadata_container_real_find_object_co (RygelLocalSearchMetadataContainerFindObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (rygel_local_search_metadata_container_is_our_child (_data_->self, _data_->id)) {
		_data_->_state_ = 1;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_local_search_metadata_container_parent_class)->find_object ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer), _data_->id, _data_->cancellable, rygel_local_search_metadata_container_find_object_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_local_search_metadata_container_parent_class)->find_object_finish ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer), _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_data_->result = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static gchar*
rygel_local_search_metadata_container_real_create_id_for_title (RygelLocalSearchMetadataContainer* self,
                                                                const gchar* title)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ":", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_uri_escape_string (title, "", TRUE);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}

gchar*
rygel_local_search_metadata_container_create_id_for_title (RygelLocalSearchMetadataContainer* self,
                                                           const gchar* title)
{
	RygelLocalSearchMetadataContainerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_LOCAL_SEARCH_METADATA_CONTAINER_GET_CLASS (self);
	if (_klass_->create_id_for_title) {
		return _klass_->create_id_for_title (self, title);
	}
	return NULL;
}

static gchar*
rygel_local_search_metadata_container_real_create_title_for_value (RygelLocalSearchMetadataContainer* self,
                                                                   const gchar* value)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_strdup (value);
	result = _tmp0_;
	return result;
}

gchar*
rygel_local_search_metadata_container_create_title_for_value (RygelLocalSearchMetadataContainer* self,
                                                              const gchar* value)
{
	RygelLocalSearchMetadataContainerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_LOCAL_SEARCH_METADATA_CONTAINER_GET_CLASS (self);
	if (_klass_->create_title_for_value) {
		return _klass_->create_title_for_value (self, value);
	}
	return NULL;
}

static gchar*
rygel_local_search_metadata_container_real_create_filter (RygelLocalSearchMetadataContainer* self,
                                                          const gchar* variable,
                                                          const gchar* value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (variable != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_strconcat (variable, " = \"", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_local_search_query_escape_string (value);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "\"", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}

gchar*
rygel_local_search_metadata_container_create_filter (RygelLocalSearchMetadataContainer* self,
                                                     const gchar* variable,
                                                     const gchar* value)
{
	RygelLocalSearchMetadataContainerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_LOCAL_SEARCH_METADATA_CONTAINER_GET_CLASS (self);
	if (_klass_->create_filter) {
		return _klass_->create_filter (self, variable, value);
	}
	return NULL;
}

static gboolean
rygel_local_search_metadata_container_is_our_child (RygelLocalSearchMetadataContainer* self,
                                                    const gchar* id)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ":", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_str_has_prefix (id, _tmp3_);
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static void
rygel_local_search_metadata_container_class_init (RygelLocalSearchMetadataContainerClass * klass,
                                                  gpointer klass_data)
{
	rygel_local_search_metadata_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelLocalSearchMetadataContainer_private_offset);
	((RygelLocalSearchMetadataContainerClass *) klass)->create_query = (RygelLocalSearchSelectionQuery* (*) (RygelLocalSearchMetadataContainer*)) rygel_local_search_metadata_container_real_create_query;
	((RygelLocalSearchMetadataContainerClass *) klass)->create_container = (RygelLocalSearchSearchContainer* (*) (RygelLocalSearchMetadataContainer*, const gchar*, const gchar*, const gchar*)) rygel_local_search_metadata_container_real_create_container;
	((RygelMediaContainerClass *) klass)->find_object = (void (*) (RygelMediaContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_local_search_metadata_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = (RygelMediaObject* (*) (RygelMediaContainer*, GAsyncResult*, GError**)) rygel_local_search_metadata_container_find_object_finish;
	((RygelLocalSearchMetadataContainerClass *) klass)->create_id_for_title = (gchar* (*) (RygelLocalSearchMetadataContainer*, const gchar*)) rygel_local_search_metadata_container_real_create_id_for_title;
	((RygelLocalSearchMetadataContainerClass *) klass)->create_title_for_value = (gchar* (*) (RygelLocalSearchMetadataContainer*, const gchar*)) rygel_local_search_metadata_container_real_create_title_for_value;
	((RygelLocalSearchMetadataContainerClass *) klass)->create_filter = (gchar* (*) (RygelLocalSearchMetadataContainer*, const gchar*, const gchar*)) rygel_local_search_metadata_container_real_create_filter;
	G_OBJECT_CLASS (klass)->finalize = rygel_local_search_metadata_container_finalize;
}

static void
rygel_local_search_metadata_container_instance_init (RygelLocalSearchMetadataContainer * self,
                                                     gpointer klass)
{
	self->priv = rygel_local_search_metadata_container_get_instance_private (self);
	self->priv->update_in_progress = FALSE;
}

static void
rygel_local_search_metadata_container_finalize (GObject * obj)
{
	RygelLocalSearchMetadataContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LOCAL_SEARCH_TYPE_METADATA_CONTAINER, RygelLocalSearchMetadataContainer);
	_rygel_local_search_item_factory_unref0 (self->item_factory);
	_g_free0 (self->priv->child_class);
	_g_object_unref0 (self->triplets);
	G_OBJECT_CLASS (rygel_local_search_metadata_container_parent_class)->finalize (obj);
}

/**
 * Base class for containers listing possible values of a particular LocalSearch
 * metadata key.
 */
 G_GNUC_NO_INLINE static GType
rygel_local_search_metadata_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchMetadataContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_metadata_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLocalSearchMetadataContainer), 0, (GInstanceInitFunc) rygel_local_search_metadata_container_instance_init, NULL };
	GType rygel_local_search_metadata_container_type_id;
	rygel_local_search_metadata_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelLocalSearchMetadataContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	RygelLocalSearchMetadataContainer_private_offset = g_type_add_instance_private (rygel_local_search_metadata_container_type_id, sizeof (RygelLocalSearchMetadataContainerPrivate));
	return rygel_local_search_metadata_container_type_id;
}

GType
rygel_local_search_metadata_container_get_type (void)
{
	static volatile gsize rygel_local_search_metadata_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_metadata_container_type_id__once)) {
		GType rygel_local_search_metadata_container_type_id;
		rygel_local_search_metadata_container_type_id = rygel_local_search_metadata_container_get_type_once ();
		g_once_init_leave (&rygel_local_search_metadata_container_type_id__once, rygel_local_search_metadata_container_type_id);
	}
	return rygel_local_search_metadata_container_type_id__once;
}

