// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A7__F252

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx)xyzw" };
#else
{ R"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_64_T_T_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1152)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0xfeeccc5eu, 0x439f81fdu, 302, 83 }, // feeccc5e439f81fd = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_16_16_False__CO__wave1_warp2_stg1--Arch_gfx1152
    { 0x0ed94b19u, 0x72863296u, 302, 33 }, // 0ed94b1972863296 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_16_16_False__CO__wave3_warp2_stg1--Arch_gfx1152
    { 0x73604f10u, 0xb04cc9f6u, 302, 50 }, // 73604f10b04cc9f6 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1152
    { 0xcc00eda0u, 0x4e1c71d6u, 456, 83 }, // cc00eda04e1c71d6 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_16_16_True__CO__wave1_warp2_stg1--Arch_gfx1152
    { 0x423b23dbu, 0xdc42d953u, 456, 16 }, // 423b23dbdc42d953 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_16_16_True__CO__wave2_warp2_stg1--Arch_gfx1152
    { 0xd0978749u, 0x6709603au, 456, 33 }, // d09787496709603a = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_16_16_True__CO__wave3_warp2_stg1--Arch_gfx1152
    { 0x7d1dfcc2u, 0x3d66b943u, 456, 50 }, // 7d1dfcc23d66b943 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_16_16_True__CO__wave4_warp2_stg1--Arch_gfx1152
    { 0x611e5746u, 0x5c3eeafau, 0, 83 }, // 611e57465c3eeafa = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave1_warp2_stg1--Arch_gfx1152
    { 0x246649d0u, 0x47266474u, 0, 16 }, // 246649d047266474 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx1152
    { 0x0a2f87c4u, 0xefef5d73u, 0, 33 }, // 0a2f87c4efef5d73 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx1152
    { 0x581539a3u, 0x3a4b6799u, 366, 83 }, // 581539a33a4b6799 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave1_warp2_stg1--Arch_gfx1152
    { 0x289c7d56u, 0x7269e5b0u, 366, 16 }, // 289c7d567269e5b0 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave2_warp2_stg1--Arch_gfx1152
    { 0x21187c9cu, 0x80e95686u, 366, 33 }, // 21187c9c80e95686 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave3_warp2_stg1--Arch_gfx1152
    { 0x5af13eeeu, 0x11b698d3u, 366, 50 }, // 5af13eee11b698d3 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave4_warp2_stg1--Arch_gfx1152
    { 0x57d6c943u, 0x6774492bu, 366, 133 }, // 57d6c9436774492b = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave4_warp4_stg1--Arch_gfx1152
    { 0x9ed48596u, 0x89cb67abu, 318, 83 }, // 9ed4859689cb67ab = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave1_warp2_stg1--Arch_gfx1152
    { 0x0c7e6903u, 0x646f1bf5u, 318, 202 }, // 0c7e6903646f1bf5 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1152
    { 0xe3f1adf3u, 0x1a2cabfcu, 318, 16 }, // e3f1adf31a2cabfc = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave2_warp2_stg1--Arch_gfx1152
    { 0x6c57261fu, 0xdc346e94u, 318, 33 }, // 6c57261fdc346e94 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave3_warp2_stg1--Arch_gfx1152
    { 0x7d5d5618u, 0x91646900u, 318, 167 }, // 7d5d561891646900 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave3_warp4_stg1--Arch_gfx1152
    { 0x13db1080u, 0x3981478cu, 318, 133 }, // 13db10803981478c = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1152
    { 0xcef13c4cu, 0xf6d52ab9u, 381, 83 }, // cef13c4cf6d52ab9 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave1_warp2_stg1--Arch_gfx1152
    { 0xe9bb669cu, 0xac4b8abeu, 381, 16 }, // e9bb669cac4b8abe = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave2_warp2_stg1--Arch_gfx1152
    { 0x281f7590u, 0xadabf835u, 381, 116 }, // 281f7590adabf835 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave2_warp4_stg1--Arch_gfx1152
    { 0xb73bd651u, 0xccdfa53du, 381, 33 }, // b73bd651ccdfa53d = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave3_warp2_stg1--Arch_gfx1152
    { 0x6401fb1eu, 0xf8465cc3u, 381, 133 }, // 6401fb1ef8465cc3 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave4_warp4_stg1--Arch_gfx1152
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1152_mod0
{{14,16,20,23,23, 6, 5, 3, 5, 4},
 {19, 2, 1, 1, 3, 0,21,24,22,22},
 { 8, 7, 9,10,12,12,13,15,21,21},
 {25,11,12,11,12,11,17,18,15,15},
 {11,12,11,10,10,11,12,24,24,22},
 {13, 7,13,13,13,12,21,21,22,22},
 {13,12,13,10,12,12,21,21,24,15},
 {11,10,12,13,13,11,21,21,24,24},
 {13,11,11,11,10,10,24,22,21,22},
 {10,12,11,10,11, 7,24,24,17,15}}
// End of GPU gfx1152_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A7__F252 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 9;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 9;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 64
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1100_mod0') AND inputs$Q_dtype = 'torch.bfloat16' AND inputs$BLOCK_DMODEL = 64 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

