/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.57 from the
 * contents of MMV.xs. Do not edit this file, edit MMV.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "MMV.xs"
/*
 * Copyright (c) 2009 Aconex.  All Rights Reserved.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include "pmapi.h"
#include "mmv_stats.h"
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

static int
list_to_metric(SV *list, mmv_metric_t *metric)
{
    int		i, len;
    SV		**entry[8];
    AV		*mlist = (AV *) SvRV(list);

    if (SvTYPE((SV *)mlist) != SVt_PVAV) {
	warn("metric declaration is not an array reference");
	return -1;
    }
    len = av_len(mlist) + 1;
    if (len < 6) {
	warn("too few entries in metric array reference");
	return -1;
    }
    if (len > 8) {
	warn("too many entries in metric array reference");
	return -1;
    }
    for (i = 0; i < len; i++)
	entry[i] = av_fetch(mlist, i, 0);

    pmstrncpy(metric->name, MMV_NAMEMAX, SvPV_nolen(*entry[0]));
    metric->item = SvIV(*entry[1]);
    metric->type = SvIV(*entry[2]);
    metric->indom = SvIV(*entry[3]);
    i = SvIV(*entry[4]);
    memcpy(&metric->dimension, &i, sizeof(pmUnits));
    metric->semantics = SvIV(*entry[5]);
    if (len > 6)
	metric->shorttext = strdup(SvPV_nolen(*entry[6]));
    else
	metric->shorttext = NULL;
    if (len > 7)
	metric->helptext = strdup(SvPV_nolen(*entry[7]));
    else
	metric->helptext = NULL;
    return 0;
}

static int
list_to_instances(SV *list, mmv_instances_t **insts)
{
    mmv_instances_t	*instances;
    int			i, len;
    AV			*inlist = (AV *) SvRV(list);

    if (SvTYPE((SV *)inlist) != SVt_PVAV) {
	warn("instances declaration is not an array reference");
	return -1;
    }
    len = av_len(inlist) + 1;
    if (len++ % 2) {
	warn("odd number of entries in instance array reference");
	return -1;
    }

    len /= 2;
    instances = (mmv_instances_t *)calloc(len, sizeof(mmv_instances_t));
    if (instances == NULL) {
	warn("insufficient memory for instance array");
	return -1;
    }
    for (i = 0; i < len; i++) {
	SV **id = av_fetch(inlist, i*2, 0);
	SV **name = av_fetch(inlist, i*2+1, 0);
	instances[i].internal = SvIV(*id);
	pmstrncpy(instances[i].external, MMV_NAMEMAX, SvPV_nolen(*name));
    }
    *insts = instances;
    return len;
}

static int
list_to_indom(SV *list, mmv_indom_t *indom)
{
    int		i, len;
    SV		**entry[4];
    AV		*ilist = (AV *) SvRV(list);

    if (SvTYPE((SV *)ilist) != SVt_PVAV) {
	warn("indom declaration is not an array reference");
	return -1;
    }
    len = av_len(ilist) + 1;
    if (len < 2) {
	warn("too few entries in indom array reference");
	return -1;
    }
    if (len > 4) {
	warn("too many entries in indom array reference");
	return -1;
    }
    for (i = 0; i < len; i++)
	entry[i] = av_fetch(ilist, i, 0);

    indom->serial = SvIV(*entry[0]);
    if ((i = list_to_instances(*entry[1], &indom->instances)) < 0)
	return -1;
    indom->count = i;
    if (len > 2)
	indom->shorttext = strdup(SvPV_nolen(*entry[2]));
    else
	indom->shorttext = NULL;
    if (len > 3)
	indom->helptext = strdup(SvPV_nolen(*entry[3]));
    else
	indom->helptext = NULL;
    return 0;
}

static int
list_to_metrics(SV *list, mmv_metric_t **metriclist, int *mcount)
{
    mmv_metric_t	*metrics;
    int			i, len;
    AV			*mlist = (AV *) SvRV(list);

    if (SvTYPE((SV *)mlist) != SVt_PVAV) {
	warn("metrics list is not an array reference");
	return -1;
    }
    len = av_len(mlist) + 1;
    metrics = (mmv_metric_t *)calloc(len, sizeof(mmv_metric_t));
    if (metrics == NULL) {
	warn("insufficient memory for metrics array");
	return -1;
    }
    for (i = 0; i < len; i++) {
	SV **entry = av_fetch(mlist, i, 0);
	if (list_to_metric(*entry, &metrics[i]) < 0)
	    break;
    }
    *metriclist = metrics;
    *mcount = len;
    return (i == len);
}

static int
list_to_indoms(SV *list, mmv_indom_t **indomlist, int *icount)
{
    mmv_indom_t		*indoms;
    int			i, len;
    AV			*ilist = (AV *) SvRV(list);

    if (SvTYPE((SV *)ilist) != SVt_PVAV) {
	warn("indoms list is not an array reference");
	return -1;
    }
    len = av_len(ilist) + 1;
    indoms = (mmv_indom_t *)calloc(len, sizeof(mmv_indom_t));
    if (indoms == NULL) {
	warn("insufficient memory for indoms array");
	return -1;
    }
    for (i = 0; i < len; i++) {
	SV **entry = av_fetch(ilist, i, 0);
	if (list_to_indom(*entry, &indoms[i]) < 0)
	    break;
    }
    *indomlist = indoms;
    *icount = len;
    return (i == len);
}


#line 198 "MMV.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

/* simple backcompat versions of the TARGx() macros with no optimisation */
#ifndef TARGi
#  define TARGi(iv, do_taint) sv_setiv_mg(TARG, iv)
#  define TARGu(uv, do_taint) sv_setuv_mg(TARG, uv)
#  define TARGn(nv, do_taint) sv_setnv_mg(TARG, nv)
#endif

#line 349 "MMV.c"

XS_EUPXS(XS_PCP__MMV_mmv_stats_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_init)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "name, cl, fl, metrics, indoms");
    {
	char *	name = (char *)SvPV_nolen(ST(0))
;
	int	cl = (int)SvIV(ST(1))
;
	int	fl = (int)SvIV(ST(2))
;
	SV *	metrics = ST(3)
;
	SV *	indoms = ST(4)
;
#line 198 "MMV.xs"
	int			i, j;
	int			mcount = 0;
	int			icount = 0;
	mmv_metric_t *		mlist = NULL;
	mmv_indom_t *		ilist = NULL;
#line 374 "MMV.c"
	void *	RETVAL;
	dXSTARG;
#line 204 "MMV.xs"
	i = list_to_metrics(metrics, &mlist, &mcount);
	j = list_to_indoms(indoms, &ilist, &icount);

	if (i <= 0 || j <= 0) {
	    warn("mmv_stats_init: bad list conversion: metrics=%d indoms=%d\n", i, j);
	    RETVAL = NULL;
	}
	else {
	    RETVAL = mmv_stats_init(name, cl, fl, mlist, mcount, ilist, icount);
	    if (RETVAL == NULL)
		warn("mmv_stats_init failed: %s\n", osstrerror());
	}

	for (i = 0; i < icount; i++) {
	    if (ilist[i].shorttext)
		free(ilist[i].shorttext);
	    if (ilist[i].helptext)
		free(ilist[i].helptext);
	    free(ilist[i].instances);
	}
	if (ilist)
	    free(ilist);
	for (i = 0; i < mcount; i++) {
	    if (mlist[i].shorttext)
		free(mlist[i].shorttext);
	    if (mlist[i].helptext)
		free(mlist[i].helptext);
	}
	if (mlist)
	    free(mlist);

	if (!RETVAL)
	    XSRETURN_UNDEF;
#line 411 "MMV.c"
	TARGi(PTR2IV(RETVAL), 1);
	ST(0) = TARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_PCP__MMV_mmv_stats_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_stop)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, name");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	char *	name = (char *)SvPV_nolen(ST(1))
;
#line 245 "MMV.xs"
	mmv_stats_stop(handle, name);
#line 432 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_units); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_units)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "dim_space, dim_time, dim_count, scale_space, scale_time, scale_count");
    {
	unsigned int	dim_space = (unsigned int)SvUV(ST(0))
;
	unsigned int	dim_time = (unsigned int)SvUV(ST(1))
;
	unsigned int	dim_count = (unsigned int)SvUV(ST(2))
;
	unsigned int	scale_space = (unsigned int)SvUV(ST(3))
;
	unsigned int	scale_time = (unsigned int)SvUV(ST(4))
;
	unsigned int	scale_count = (unsigned int)SvUV(ST(5))
;
#line 256 "MMV.xs"
	pmUnits			units;
#line 459 "MMV.c"
	int	RETVAL;
	dXSTARG;
#line 258 "MMV.xs"
	units.pad = 0;
	units.dimSpace = dim_space;	units.scaleSpace = scale_space;
	units.dimTime = dim_time;	units.scaleTime = scale_time;
	units.dimCount = dim_count;	units.scaleCount = scale_count;
	RETVAL = *(int *)(&units);
#line 468 "MMV.c"
	TARGi((IV)RETVAL, 1);
	ST(0) = TARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_PCP__MMV_mmv_lookup_value_desc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_lookup_value_desc)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, metric, instance");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	char *	metric = (char *)SvPV_nolen(ST(1))
;
	char *	instance = (char *)SvPV_nolen(ST(2))
;
	pmAtomValue *	RETVAL;
#line 272 "MMV.xs"
	RETVAL = mmv_lookup_value_desc(handle, metric, instance);
#line 492 "MMV.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "pmAtomValuePtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_PCP__MMV_mmv_inc_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_inc_value)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, atom, value");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	pmAtomValue *	atom;
	double	value = (double)SvNV(ST(2))
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pmAtomValuePtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    atom = INT2PTR(pmAtomValue *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"PCP::MMV::mmv_inc_value",
			"atom", "pmAtomValuePtr",
			refstr, ST(1)
		);
	}
;
#line 282 "MMV.xs"
	mmv_inc_value(handle, atom, value);
#line 532 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_inc_atomvalue); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_inc_atomvalue)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, atom, value");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	pmAtomValue *	atom;
	pmAtomValue *	value;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pmAtomValuePtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    atom = INT2PTR(pmAtomValue *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"PCP::MMV::mmv_inc_atomvalue",
			"atom", "pmAtomValuePtr",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "pmAtomValuePtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    value = INT2PTR(pmAtomValue *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"PCP::MMV::mmv_inc_atomvalue",
			"value", "pmAtomValuePtr",
			refstr, ST(2)
		);
	}
;
#line 290 "MMV.xs"
	mmv_inc_atomvalue(handle, atom, value);
#line 579 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_set_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_set_value)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, atom, value");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	pmAtomValue *	atom;
	double	value = (double)SvNV(ST(2))
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pmAtomValuePtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    atom = INT2PTR(pmAtomValue *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"PCP::MMV::mmv_set_value",
			"atom", "pmAtomValuePtr",
			refstr, ST(1)
		);
	}
;
#line 298 "MMV.xs"
	mmv_set_value(handle, atom, value);
#line 613 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_set_atomvalue); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_set_atomvalue)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, atom, value");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	pmAtomValue *	atom;
	pmAtomValue *	value;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pmAtomValuePtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    atom = INT2PTR(pmAtomValue *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"PCP::MMV::mmv_set_atomvalue",
			"atom", "pmAtomValuePtr",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "pmAtomValuePtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    value = INT2PTR(pmAtomValue *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"PCP::MMV::mmv_set_atomvalue",
			"value", "pmAtomValuePtr",
			refstr, ST(2)
		);
	}
;
#line 306 "MMV.xs"
	mmv_set_atomvalue(handle, atom, value);
#line 660 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_set_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_set_string)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, atom, string");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	pmAtomValue *	atom;
	SV *	string = ST(2)
;
#line 314 "MMV.xs"
	int			length;
	char *			data;
#line 681 "MMV.c"

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pmAtomValuePtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    atom = INT2PTR(pmAtomValue *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"PCP::MMV::mmv_set_string",
			"atom", "pmAtomValuePtr",
			refstr, ST(1)
		);
	}
;
#line 317 "MMV.xs"
	data = SvPV_nolen(string);
	length = strlen(data);
	mmv_set_string(handle, atom, data, length);
#line 700 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_stats_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_add)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "handle, metric, instance, count");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	char *	metric = (char *)SvPV_nolen(ST(1))
;
	char *	instance = (char *)SvPV_nolen(ST(2))
;
	double	count = (double)SvNV(ST(3))
;
#line 328 "MMV.xs"
	mmv_stats_add(handle, metric, instance, count);
#line 723 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_stats_inc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_inc)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, metric, instance");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	char *	metric = (char *)SvPV_nolen(ST(1))
;
	char *	instance = (char *)SvPV_nolen(ST(2))
;
#line 336 "MMV.xs"
	mmv_stats_inc(handle, metric, instance);
#line 744 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_stats_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_set)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "handle, metric, instance, value");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	char *	metric = (char *)SvPV_nolen(ST(1))
;
	char *	instance = (char *)SvPV_nolen(ST(2))
;
	double	value = (double)SvNV(ST(3))
;
#line 345 "MMV.xs"
	mmv_stats_set(handle, metric, instance, value);
#line 767 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_stats_add_fallback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_add_fallback)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "handle, metric, instance, instance2, count");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	char *	metric = (char *)SvPV_nolen(ST(1))
;
	char *	instance = (char *)SvPV_nolen(ST(2))
;
	char *	instance2 = (char *)SvPV_nolen(ST(3))
;
	double	count = (double)SvNV(ST(4))
;
#line 355 "MMV.xs"
	mmv_stats_add_fallback(handle, metric, instance, instance2, count);
#line 792 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_stats_inc_fallback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_inc_fallback)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "handle, metric, instance, instance2");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	char *	metric = (char *)SvPV_nolen(ST(1))
;
	char *	instance = (char *)SvPV_nolen(ST(2))
;
	char *	instance2 = (char *)SvPV_nolen(ST(3))
;
#line 364 "MMV.xs"
	mmv_stats_inc_fallback(handle, metric, instance, instance2);
#line 815 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_stats_interval_start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_interval_start)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "handle, value, metric, instance");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	pmAtomValue *	value;
	char *	metric = (char *)SvPV_nolen(ST(2))
;
	char *	instance = (char *)SvPV_nolen(ST(3))
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pmAtomValuePtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    value = INT2PTR(pmAtomValue *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"PCP::MMV::mmv_stats_interval_start",
			"value", "pmAtomValuePtr",
			refstr, ST(1)
		);
	}
;
#line 373 "MMV.xs"
	mmv_stats_interval_start(handle, value, metric, instance);
#line 851 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_stats_interval_end); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_interval_end)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, value");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	pmAtomValue *	value;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pmAtomValuePtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    value = INT2PTR(pmAtomValue *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"PCP::MMV::mmv_stats_interval_end",
			"value", "pmAtomValuePtr",
			refstr, ST(1)
		);
	}
;
#line 380 "MMV.xs"
	mmv_stats_interval_end(handle, value);
#line 883 "MMV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_PCP__MMV_mmv_stats_set_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_PCP__MMV_mmv_stats_set_string)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "handle, metric, instance, string");
    {
	void *	handle = INT2PTR(void *,SvIV(ST(0)))
;
	char *	metric = (char *)SvPV_nolen(ST(1))
;
	char *	instance = (char *)SvPV_nolen(ST(2))
;
	SV *	string = ST(3)
;
#line 389 "MMV.xs"
	int			length;
	char *			data;
#line 907 "MMV.c"
#line 392 "MMV.xs"
	data = SvPV_nolen(string);
	length = strlen(data);
	mmv_stats_set_strlen(handle, metric, instance, data, length);
#line 912 "MMV.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_PCP__MMV); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_PCP__MMV)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("PCP::MMV::mmv_stats_init", XS_PCP__MMV_mmv_stats_init);
        newXS_deffile("PCP::MMV::mmv_stats_stop", XS_PCP__MMV_mmv_stats_stop);
        newXS_deffile("PCP::MMV::mmv_units", XS_PCP__MMV_mmv_units);
        newXS_deffile("PCP::MMV::mmv_lookup_value_desc", XS_PCP__MMV_mmv_lookup_value_desc);
        newXS_deffile("PCP::MMV::mmv_inc_value", XS_PCP__MMV_mmv_inc_value);
        newXS_deffile("PCP::MMV::mmv_inc_atomvalue", XS_PCP__MMV_mmv_inc_atomvalue);
        newXS_deffile("PCP::MMV::mmv_set_value", XS_PCP__MMV_mmv_set_value);
        newXS_deffile("PCP::MMV::mmv_set_atomvalue", XS_PCP__MMV_mmv_set_atomvalue);
        newXS_deffile("PCP::MMV::mmv_set_string", XS_PCP__MMV_mmv_set_string);
        newXS_deffile("PCP::MMV::mmv_stats_add", XS_PCP__MMV_mmv_stats_add);
        newXS_deffile("PCP::MMV::mmv_stats_inc", XS_PCP__MMV_mmv_stats_inc);
        newXS_deffile("PCP::MMV::mmv_stats_set", XS_PCP__MMV_mmv_stats_set);
        newXS_deffile("PCP::MMV::mmv_stats_add_fallback", XS_PCP__MMV_mmv_stats_add_fallback);
        newXS_deffile("PCP::MMV::mmv_stats_inc_fallback", XS_PCP__MMV_mmv_stats_inc_fallback);
        newXS_deffile("PCP::MMV::mmv_stats_interval_start", XS_PCP__MMV_mmv_stats_interval_start);
        newXS_deffile("PCP::MMV::mmv_stats_interval_end", XS_PCP__MMV_mmv_stats_interval_end);
        newXS_deffile("PCP::MMV::mmv_stats_set_string", XS_PCP__MMV_mmv_stats_set_string);
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
