/**
 * @file c_spm_scal.c
 *
 * SParse Matrix package scaling routine.
 *
 * @copyright 2016-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 1.2.4
 * @author Mathieu Faverge
 * @author Pierre Ramet
 * @author Matias Hastaran
 * @author Tony Delarue
 * @author Alycia Lisito
 * @author Gregoire Pichon
 * @date 2024-05-29
 * @generated from /build/pastix/src/pastix-6.4.0/spm/src/z_spm_scal.c, normal z -> c, Sun Feb 15 18:01:29 2026
 *
 **/
#include "common.h"

/**
 *******************************************************************************
 *
 * @ingroup spm_dev_scal
 *
 * @brief Scal the spm: A = alpha * A
 *
 *******************************************************************************
 *
 * @param[in] alpha
 *           The scaling parameter.
 *
 * @param[inout] spm
 *           The spm which needs to be scaled.
 *
 *******************************************************************************/
void
c_spmScal( const float  alpha,
           spmatrix_t   *spm )
{
    spm_int_t        nnzexp, i;
    spm_complex32_t *values;

    nnzexp = spm->nnzexp;
    values = spm->values;

    for (i=0; i<nnzexp; i++){
        values[i] *= alpha;
    }
}
