/**
 *
 * @file cpucblk_dpack.h
 *
 * Precision dependent routines to pack and unpack cblks.
 *
 * @copyright 2021-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Nolan Bredel
 * @date 2024-07-05
 *
 * @generated from /build/pastix/src/pastix-6.4.0/kernels/cpucblk_zpack.h, normal z -> d, Sun Feb 15 18:01:29 2026
 *
 **/

#ifndef _cpucblk_dpack_h_
#define _cpucblk_dpack_h_

size_t cpublok_dcompute_size_lr( pastix_coefside_t  side,
                                 pastix_int_t       N,
                                 const SolverBlok  *blok );

pastix_uint_t cpucblk_dcompute_size_lr( pastix_coefside_t  side,
                                        const SolverCblk  *cblk );

size_t cpucblk_dcompute_size( pastix_coefside_t  side,
                              const SolverCblk  *cblk );

char *cpublok_dpack_lr( pastix_coefside_t  side,
                        pastix_uint_t      N,
                        const SolverBlok  *blok,
                        char *             buffer );

void *cpucblk_dpack_lr( pastix_coefside_t  side,
                        SolverCblk        *cblk,
                        size_t             size );

char *cpublok_dunpack_lr( pastix_coefside_t  side,
                          pastix_int_t       N,
                          SolverBlok        *blok,
                          char              *buffer );

void cpucblk_dunpack_lr( pastix_coefside_t  side,
                         SolverCblk        *cblk,
                         void              *buffer );

void *cpucblk_dpack_fr( pastix_coefside_t  side,
                        const SolverCblk  *cblk );

void cpucblk_dunpack_fr( pastix_coefside_t   side,
                         SolverCblk         *cblk,
                         double *buffer );

void *cpucblk_dpack( pastix_coefside_t  side,
                     SolverCblk        *cblk,
                     size_t             size );

void cpucblk_dunpack( pastix_coefside_t  side,
                      SolverCblk        *cblk,
                      void              *buffer );

#endif /* _cpucblk_dpack_h_ */
