// python wrapper for vtkSMColorMapEditorHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMColorMapEditorHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMColorMapEditorHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMColorMapEditorHelper_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMColorMapEditorHelper_SelectedPropertiesTypes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMColorMapEditorHelper.SelectedPropertiesTypes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMColorMapEditorHelper_SelectedPropertiesTypes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMColorMapEditorHelper_SelectedPropertiesTypes_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMColorMapEditorHelper_BlockPropertyState_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMColorMapEditorHelper.BlockPropertyState", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMColorMapEditorHelper_BlockPropertyState_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMColorMapEditorHelper_BlockPropertyState_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMColorMapEditorHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMColorMapEditorHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMColorMapEditorHelper *tempr = vtkSMColorMapEditorHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMColorMapEditorHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMColorMapEditorHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMColorMapEditorHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMColorMapEditorHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedPropertiesType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedPropertiesType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSelectedPropertiesType(temp0);
    }
    else
    {
      op->vtkSMColorMapEditorHelper::SetSelectedPropertiesType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedPropertiesTypeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedPropertiesTypeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSelectedPropertiesTypeMinValue() :
      op->vtkSMColorMapEditorHelper::GetSelectedPropertiesTypeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedPropertiesTypeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedPropertiesTypeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSelectedPropertiesTypeMaxValue() :
      op->vtkSMColorMapEditorHelper::GetSelectedPropertiesTypeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedPropertiesTypeToRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedPropertiesTypeToRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetSelectedPropertiesTypeToRepresentation();
    }
    else
    {
      op->vtkSMColorMapEditorHelper::SetSelectedPropertiesTypeToRepresentation();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedPropertiesTypeToBlocks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedPropertiesTypeToBlocks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetSelectedPropertiesTypeToBlocks();
    }
    else
    {
      op->vtkSMColorMapEditorHelper::SetSelectedPropertiesTypeToBlocks();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedPropertiesType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedPropertiesType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSelectedPropertiesType() :
      op->vtkSMColorMapEditorHelper::GetSelectedPropertiesType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetPropertyType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetPropertyType");

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    typedef vtkSMColorMapEditorHelper::SelectedPropertiesTypes tempr_type;
  tempr_type tempr = vtkSMColorMapEditorHelper::GetPropertyType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = PyvtkSMColorMapEditorHelper_SelectedPropertiesTypes_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedBlockSelectors(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetSelectedBlockSelectors");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    std::vector<std::string> tempr = vtkSMColorMapEditorHelper::GetSelectedBlockSelectors(temp0);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetColorArraysBlockSelectors(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetColorArraysBlockSelectors");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    std::vector<std::string> tempr = vtkSMColorMapEditorHelper::GetColorArraysBlockSelectors(temp0);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetLUTProxy(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod GetLUTProxy."
    " (" "Use GetLookupTable instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(args, "GetLUTProxy");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    vtkSMProxy *tempr = vtkSMColorMapEditorHelper::GetLUTProxy(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetLookupTable_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetLookupTable");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProxy *tempr = vtkSMColorMapEditorHelper::GetLookupTable(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_GetLookupTable_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetLookupTable");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    vtkSMProxy *tempr = vtkSMColorMapEditorHelper::GetLookupTable(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_GetLookupTable(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMColorMapEditorHelper_GetLookupTable_s1(self, args);
    case 2:
      return PyvtkSMColorMapEditorHelper_GetLookupTable_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetLookupTable");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockLookupTable_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockLookupTable");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMProxy *tempr = vtkSMColorMapEditorHelper::GetBlockLookupTable(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockLookupTable_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockLookupTable");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  std::string temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    vtkSMProxy *tempr = vtkSMColorMapEditorHelper::GetBlockLookupTable(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockLookupTable(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMColorMapEditorHelper_GetBlockLookupTable_s1(self, args);
    case 3:
      return PyvtkSMColorMapEditorHelper_GetBlockLookupTable_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetBlockLookupTable");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetUsingScalarColoring(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetUsingScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::GetUsingScalarColoring(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockUsingScalarColoring(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockUsingScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    bool tempr = vtkSMColorMapEditorHelper::GetBlockUsingScalarColoring(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlocksUsingScalarColoring(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlocksUsingScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::GetBlocksUsingScalarColoring(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetAnyBlockUsingScalarColoring(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetAnyBlockUsingScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::GetAnyBlockUsingScalarColoring(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedUsingScalarColorings(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedUsingScalarColorings");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->GetSelectedUsingScalarColorings(temp0) :
      op->vtkSMColorMapEditorHelper::GetSelectedUsingScalarColorings(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetAnySelectedUsingScalarColoring(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnySelectedUsingScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAnySelectedUsingScalarColoring(temp0) :
      op->vtkSMColorMapEditorHelper::GetAnySelectedUsingScalarColoring(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetupLookupTable(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetupLookupTable");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMColorMapEditorHelper::SetupLookupTable(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetupBlocksLookupTables(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetupBlocksLookupTables");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMColorMapEditorHelper::SetupBlocksLookupTables(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_UpdateScalarBarRange(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "UpdateScalarBarRange");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    bool tempr = vtkSMColorMapEditorHelper::UpdateScalarBarRange(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_UpdateBlocksScalarBarRange(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "UpdateBlocksScalarBarRange");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::UpdateBlocksScalarBarRange(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetScalarColoring_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = vtkSMColorMapEditorHelper::SetScalarColoring(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_SetScalarColoring_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    bool tempr = vtkSMColorMapEditorHelper::SetScalarColoring(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_SetScalarColoring(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 3:
      return PyvtkSMColorMapEditorHelper_SetScalarColoring_s1(self, args);
    case 4:
      return PyvtkSMColorMapEditorHelper_SetScalarColoring_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetScalarColoring");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlockScalarColoring_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlockScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  const char *temp2 = nullptr;
  int temp3;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    bool tempr = vtkSMColorMapEditorHelper::SetBlockScalarColoring(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_SetBlockScalarColoring_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlockScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  const char *temp2 = nullptr;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(5) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    bool tempr = vtkSMColorMapEditorHelper::SetBlockScalarColoring(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_SetBlockScalarColoring(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 4:
      return PyvtkSMColorMapEditorHelper_SetBlockScalarColoring_s1(self, args);
    case 5:
      return PyvtkSMColorMapEditorHelper_SetBlockScalarColoring_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBlockScalarColoring");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlocksScalarColoring_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlocksScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  const char *temp2 = nullptr;
  int temp3;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::SetBlocksScalarColoring(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_SetBlocksScalarColoring_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlocksScalarColoring");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  const char *temp2 = nullptr;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(5) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::SetBlocksScalarColoring(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_SetBlocksScalarColoring(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 4:
      return PyvtkSMColorMapEditorHelper_SetBlocksScalarColoring_s1(self, args);
    case 5:
      return PyvtkSMColorMapEditorHelper_SetBlocksScalarColoring_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBlocksScalarColoring");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedScalarColoring_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->SetSelectedScalarColoring(temp0, temp1, temp2) :
      op->vtkSMColorMapEditorHelper::SetSelectedScalarColoring(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedScalarColoring_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->SetSelectedScalarColoring(temp0, temp1, temp2, temp3) :
      op->vtkSMColorMapEditorHelper::SetSelectedScalarColoring(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedScalarColoring(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkSMColorMapEditorHelper_SetSelectedScalarColoring_s1(self, args);
    case 4:
      return PyvtkSMColorMapEditorHelper_SetSelectedScalarColoring_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSelectedScalarColoring");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleTransferFunctionToDataRange");

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  bool temp2 = true;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleTransferFunctionToDataRange(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleTransferFunctionToDataRange");

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  bool temp3 = false;
  bool temp4 = true;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 5) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleTransferFunctionToDataRange(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange_Methods[] = {
  {"RescaleTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange_s1, METH_VARARGS | METH_STATIC,
   "V|qq *vtkSMProxy"},
  {"RescaleTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange_s2, METH_VARARGS | METH_STATIC,
   "Vzi|qq *vtkSMProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
    case 2:
      return PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange_s1(self, args);
    case 4:
    case 5:
      return PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange_s2(self, args);
    case 3:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleTransferFunctionToDataRange");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleBlockTransferFunctionToDataRange");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  bool temp2 = false;
  bool temp3 = true;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleBlockTransferFunctionToDataRange(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleBlockTransferFunctionToDataRange");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  const char *temp2 = nullptr;
  int temp3;
  bool temp4 = false;
  bool temp5 = true;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4, 6) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp5)))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleBlockTransferFunctionToDataRange(temp0, temp1, temp2, temp3, temp4, temp5);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange_Methods[] = {
  {"RescaleBlockTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange_s1, METH_VARARGS | METH_STATIC,
   "Vs|qq *vtkSMProxy"},
  {"RescaleBlockTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange_s2, METH_VARARGS | METH_STATIC,
   "Vszi|qq *vtkSMProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
    case 3:
      return PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange_s1(self, args);
    case 5:
    case 6:
      return PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange_s2(self, args);
    case 4:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleBlockTransferFunctionToDataRange");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleBlocksTransferFunctionToDataRange");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  bool temp2 = false;
  bool temp3 = true;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::RescaleBlocksTransferFunctionToDataRange(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleBlocksTransferFunctionToDataRange");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  const char *temp2 = nullptr;
  int temp3;
  bool temp4 = false;
  bool temp5 = true;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4, 6) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp5)))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::RescaleBlocksTransferFunctionToDataRange(temp0, temp1, temp2, temp3, temp4, temp5);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyMethodDef PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange_Methods[] = {
  {"RescaleBlocksTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange_s1, METH_VARARGS | METH_STATIC,
   "VT|qq *vtkSMProxy s"},
  {"RescaleBlocksTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange_s2, METH_VARARGS | METH_STATIC,
   "VTzi|qq *vtkSMProxy s"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
    case 3:
      return PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange_s1(self, args);
    case 5:
    case 6:
      return PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange_s2(self, args);
    case 4:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleBlocksTransferFunctionToDataRange");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleSelectedTransferFunctionToDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  bool temp2 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->RescaleSelectedTransferFunctionToDataRange(temp0, temp1, temp2) :
      op->vtkSMColorMapEditorHelper::RescaleSelectedTransferFunctionToDataRange(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleSelectedTransferFunctionToDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  bool temp3 = false;
  bool temp4 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 5) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->RescaleSelectedTransferFunctionToDataRange(temp0, temp1, temp2, temp3, temp4) :
      op->vtkSMColorMapEditorHelper::RescaleSelectedTransferFunctionToDataRange(temp0, temp1, temp2, temp3, temp4));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyMethodDef PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange_Methods[] = {
  {"RescaleSelectedTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange_s1, METH_VARARGS,
   "@V|qq *vtkSMProxy"},
  {"RescaleSelectedTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange_s2, METH_VARARGS,
   "@Vzi|qq *vtkSMProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
    case 2:
      return PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange_s1(self, args);
    case 4:
    case 5:
      return PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange_s2(self, args);
    case 3:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleSelectedTransferFunctionToDataRange");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRangeOverTime_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleTransferFunctionToDataRangeOverTime");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleTransferFunctionToDataRangeOverTime(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRangeOverTime_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleTransferFunctionToDataRangeOverTime");

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleTransferFunctionToDataRangeOverTime(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRangeOverTime(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRangeOverTime_s1(self, args);
    case 3:
      return PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRangeOverTime_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleTransferFunctionToDataRangeOverTime");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRangeOverTime_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleBlockTransferFunctionToDataRangeOverTime");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleBlockTransferFunctionToDataRangeOverTime(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRangeOverTime_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleBlockTransferFunctionToDataRangeOverTime");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  const char *temp2 = nullptr;
  int temp3;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleBlockTransferFunctionToDataRangeOverTime(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRangeOverTime(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRangeOverTime_s1(self, args);
    case 4:
      return PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRangeOverTime_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleBlockTransferFunctionToDataRangeOverTime");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRangeOverTime_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleBlocksTransferFunctionToDataRangeOverTime");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::RescaleBlocksTransferFunctionToDataRangeOverTime(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRangeOverTime_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleBlocksTransferFunctionToDataRangeOverTime");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  const char *temp2 = nullptr;
  int temp3;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::RescaleBlocksTransferFunctionToDataRangeOverTime(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRangeOverTime(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRangeOverTime_s1(self, args);
    case 4:
      return PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRangeOverTime_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleBlocksTransferFunctionToDataRangeOverTime");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRangeOverTime_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleSelectedTransferFunctionToDataRangeOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->RescaleSelectedTransferFunctionToDataRangeOverTime(temp0) :
      op->vtkSMColorMapEditorHelper::RescaleSelectedTransferFunctionToDataRangeOverTime(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRangeOverTime_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleSelectedTransferFunctionToDataRangeOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->RescaleSelectedTransferFunctionToDataRangeOverTime(temp0, temp1, temp2) :
      op->vtkSMColorMapEditorHelper::RescaleSelectedTransferFunctionToDataRangeOverTime(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRangeOverTime(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRangeOverTime_s1(self, args);
    case 3:
      return PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRangeOverTime_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleSelectedTransferFunctionToDataRangeOverTime");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToVisibleRange_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleTransferFunctionToVisibleRange");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleTransferFunctionToVisibleRange(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToVisibleRange_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleTransferFunctionToVisibleRange");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  const char *temp2 = nullptr;
  int temp3;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    bool tempr = vtkSMColorMapEditorHelper::RescaleTransferFunctionToVisibleRange(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToVisibleRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToVisibleRange_s1(self, args);
    case 4:
      return PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToVisibleRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleTransferFunctionToVisibleRange");
  return nullptr;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetScalarBarVisibility(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetScalarBarVisibility");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    bool tempr = vtkSMColorMapEditorHelper::SetScalarBarVisibility(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlockScalarBarVisibility(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlockScalarBarVisibility");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  std::string temp2;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    bool tempr = vtkSMColorMapEditorHelper::SetBlockScalarBarVisibility(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlocksScalarBarVisibility(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlocksScalarBarVisibility");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  std::vector<std::string> temp2(ap.GetArgSize(2));
  bool temp3 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetArray(temp2.data(), temp2.size()) &&
      ap.GetValue(temp3))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::SetBlocksScalarBarVisibility(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedScalarBarVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedScalarBarVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->SetSelectedScalarBarVisibility(temp0, temp1, temp2) :
      op->vtkSMColorMapEditorHelper::SetSelectedScalarBarVisibility(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_HideScalarBarIfNotNeeded(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "HideScalarBarIfNotNeeded");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::HideScalarBarIfNotNeeded(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_HideBlocksScalarBarIfNotNeeded(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "HideBlocksScalarBarIfNotNeeded");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::HideBlocksScalarBarIfNotNeeded(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsScalarBarVisible(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsScalarBarVisible");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::IsScalarBarVisible(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsBlockScalarBarVisible(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsBlockScalarBarVisible");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  std::string temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    bool tempr = vtkSMColorMapEditorHelper::IsBlockScalarBarVisible(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsBlocksScalarBarVisible(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsBlocksScalarBarVisible");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  std::vector<std::string> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::IsBlocksScalarBarVisible(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetArrayInformationForColorArray(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetArrayInformationForColorArray");

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = true;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkPVArrayInformation *tempr = vtkSMColorMapEditorHelper::GetArrayInformationForColorArray(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockArrayInformationForColorArray(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockArrayInformationForColorArray");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkPVArrayInformation *tempr = vtkSMColorMapEditorHelper::GetBlockArrayInformationForColorArray(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetDecoratedArrayName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDecoratedArrayName");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    std::string tempr = vtkSMColorMapEditorHelper::GetDecoratedArrayName(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockDecoratedArrayName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockDecoratedArrayName");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  std::string temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    std::string tempr = vtkSMColorMapEditorHelper::GetBlockDecoratedArrayName(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlocksDecoratedArrayNames(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlocksDecoratedArrayNames");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  std::string temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2))
  {
    std::vector<std::string> tempr = vtkSMColorMapEditorHelper::GetBlocksDecoratedArrayNames(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetProminentValuesInformationForColorArray(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetProminentValuesInformationForColorArray");

  vtkSMProxy *temp0 = nullptr;
  double temp1 = 1e-6;
  double temp2 = 1e-3;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 4) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPVProminentValuesInformation *tempr = vtkSMColorMapEditorHelper::GetProminentValuesInformationForColorArray(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockProminentValuesInformationForColorArray(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockProminentValuesInformationForColorArray");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  double temp2 = 1e-6;
  double temp3 = 1e-3;
  bool temp4 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 5) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    vtkPVProminentValuesInformation *tempr = vtkSMColorMapEditorHelper::GetBlockProminentValuesInformationForColorArray(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetEstimatedNumberOfAnnotationsOnScalarBar(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetEstimatedNumberOfAnnotationsOnScalarBar");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    int tempr = vtkSMColorMapEditorHelper::GetEstimatedNumberOfAnnotationsOnScalarBar(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockEstimatedNumberOfAnnotationsOnScalarBar(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockEstimatedNumberOfAnnotationsOnScalarBar");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  std::string temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    int tempr = vtkSMColorMapEditorHelper::GetBlockEstimatedNumberOfAnnotationsOnScalarBar(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlocksEstimatedNumberOfAnnotationsOnScalarBars(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlocksEstimatedNumberOfAnnotationsOnScalarBars");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  std::vector<std::string> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::GetBlocksEstimatedNumberOfAnnotationsOnScalarBars(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedEstimatedNumberOfAnnotationsOnScalarBars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedEstimatedNumberOfAnnotationsOnScalarBars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->GetSelectedEstimatedNumberOfAnnotationsOnScalarBars(temp0, temp1) :
      op->vtkSMColorMapEditorHelper::GetSelectedEstimatedNumberOfAnnotationsOnScalarBars(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetAnySelectedEstimatedNumberOfAnnotationsOnScalarBar(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnySelectedEstimatedNumberOfAnnotationsOnScalarBar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    int tempr = (ap.IsBound() ?
      op->GetAnySelectedEstimatedNumberOfAnnotationsOnScalarBar(temp0, temp1) :
      op->vtkSMColorMapEditorHelper::GetAnySelectedEstimatedNumberOfAnnotationsOnScalarBar(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsScalarBarStickyVisible(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsScalarBarStickyVisible");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    int tempr = vtkSMColorMapEditorHelper::IsScalarBarStickyVisible(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsBlockScalarBarStickyVisible(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsBlockScalarBarStickyVisible");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  std::string temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    int tempr = vtkSMColorMapEditorHelper::IsBlockScalarBarStickyVisible(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsBlocksScalarBarStickyVisible(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsBlocksScalarBarStickyVisible");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  std::vector<std::string> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::IsBlocksScalarBarStickyVisible(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlockColor(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlockColor");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMColorMapEditorHelper::RemoveBlockColor(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlocksColors(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlocksColors");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    vtkSMColorMapEditorHelper::RemoveBlocksColors(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetColorArrayProperty(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetColorArrayProperty");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProperty *tempr = vtkSMColorMapEditorHelper::GetColorArrayProperty(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockColorArrayProperty(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockColorArrayProperty");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProperty *tempr = vtkSMColorMapEditorHelper::GetBlockColorArrayProperty(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedColorArrayProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedColorArrayProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProperty *tempr = (ap.IsBound() ?
      op->GetSelectedColorArrayProperty(temp0) :
      op->vtkSMColorMapEditorHelper::GetSelectedColorArrayProperty(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockColorArrayAssociation(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockColorArrayAssociation");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    int tempr = vtkSMColorMapEditorHelper::GetBlockColorArrayAssociation(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockColorArrayName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockColorArrayName");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    std::string tempr = vtkSMColorMapEditorHelper::GetBlockColorArrayName(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetUseSeparateColorMapProperty(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetUseSeparateColorMapProperty");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProperty *tempr = vtkSMColorMapEditorHelper::GetUseSeparateColorMapProperty(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockUseSeparateColorMapProperty(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockUseSeparateColorMapProperty");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProperty *tempr = vtkSMColorMapEditorHelper::GetBlockUseSeparateColorMapProperty(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedUseSeparateColorMapProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedUseSeparateColorMapProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProperty *tempr = (ap.IsBound() ?
      op->GetSelectedUseSeparateColorMapProperty(temp0) :
      op->vtkSMColorMapEditorHelper::GetSelectedUseSeparateColorMapProperty(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsUseSeparateColorMapValid(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsUseSeparateColorMapValid");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = vtkSMColorMapEditorHelper::IsUseSeparateColorMapValid(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetUseSeparateColorMap(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetUseSeparateColorMap");

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMColorMapEditorHelper::SetUseSeparateColorMap(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlockUseSeparateColorMap(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlockUseSeparateColorMap");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::SetBlockUseSeparateColorMap(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlocksUseSeparateColorMap(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlocksUseSeparateColorMap");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::SetBlocksUseSeparateColorMap(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlockUseSeparateColorMap(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlockUseSeparateColorMap");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMColorMapEditorHelper::RemoveBlockUseSeparateColorMap(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlocksUseSeparateColorMaps(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlocksUseSeparateColorMaps");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    vtkSMColorMapEditorHelper::RemoveBlocksUseSeparateColorMaps(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedUseSeparateColorMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedUseSeparateColorMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSelectedUseSeparateColorMap(temp0, temp1);
    }
    else
    {
      op->vtkSMColorMapEditorHelper::SetSelectedUseSeparateColorMap(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetUseSeparateColorMap(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetUseSeparateColorMap");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::GetUseSeparateColorMap(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockUseSeparateColorMap(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockUseSeparateColorMap");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    int tempr = vtkSMColorMapEditorHelper::GetBlockUseSeparateColorMap(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlocksUseSeparateColorMaps(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlocksUseSeparateColorMaps");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::GetBlocksUseSeparateColorMaps(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedUseSeparateColorMaps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedUseSeparateColorMaps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->GetSelectedUseSeparateColorMaps(temp0) :
      op->vtkSMColorMapEditorHelper::GetSelectedUseSeparateColorMaps(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetAnySelectedUseSeparateColorMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnySelectedUseSeparateColorMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAnySelectedUseSeparateColorMap(temp0) :
      op->vtkSMColorMapEditorHelper::GetAnySelectedUseSeparateColorMap(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsMapScalarsValid(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsMapScalarsValid");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = vtkSMColorMapEditorHelper::IsMapScalarsValid(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetMapScalars(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetMapScalars");

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMColorMapEditorHelper::SetMapScalars(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlockMapScalars(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlockMapScalars");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::SetBlockMapScalars(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlocksMapScalars(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlocksMapScalars");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::SetBlocksMapScalars(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlockMapScalars(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlockMapScalars");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMColorMapEditorHelper::RemoveBlockMapScalars(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlocksMapScalars(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlocksMapScalars");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    vtkSMColorMapEditorHelper::RemoveBlocksMapScalars(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedMapScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedMapScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSelectedMapScalars(temp0, temp1);
    }
    else
    {
      op->vtkSMColorMapEditorHelper::SetSelectedMapScalars(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetMapScalars(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetMapScalars");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::GetMapScalars(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockMapScalars(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockMapScalars");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    int tempr = vtkSMColorMapEditorHelper::GetBlockMapScalars(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlocksMapScalars(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlocksMapScalars");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::GetBlocksMapScalars(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedMapScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedMapScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->GetSelectedMapScalars(temp0) :
      op->vtkSMColorMapEditorHelper::GetSelectedMapScalars(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetAnySelectedMapScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnySelectedMapScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAnySelectedMapScalars(temp0) :
      op->vtkSMColorMapEditorHelper::GetAnySelectedMapScalars(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsInterpolateScalarsBeforeMappingValid(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsInterpolateScalarsBeforeMappingValid");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = vtkSMColorMapEditorHelper::IsInterpolateScalarsBeforeMappingValid(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetInterpolateScalarsBeforeMapping(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetInterpolateScalarsBeforeMapping");

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMColorMapEditorHelper::SetInterpolateScalarsBeforeMapping(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlockInterpolateScalarsBeforeMapping(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlockInterpolateScalarsBeforeMapping");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::SetBlockInterpolateScalarsBeforeMapping(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlocksInterpolateScalarsBeforeMapping(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlocksInterpolateScalarsBeforeMapping");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::SetBlocksInterpolateScalarsBeforeMapping(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlockInterpolateScalarsBeforeMapping(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlockInterpolateScalarsBeforeMapping");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMColorMapEditorHelper::RemoveBlockInterpolateScalarsBeforeMapping(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlocksInterpolateScalarsBeforeMappings(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlocksInterpolateScalarsBeforeMappings");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    vtkSMColorMapEditorHelper::RemoveBlocksInterpolateScalarsBeforeMappings(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedInterpolateScalarsBeforeMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedInterpolateScalarsBeforeMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSelectedInterpolateScalarsBeforeMapping(temp0, temp1);
    }
    else
    {
      op->vtkSMColorMapEditorHelper::SetSelectedInterpolateScalarsBeforeMapping(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetInterpolateScalarsBeforeMapping(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInterpolateScalarsBeforeMapping");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = vtkSMColorMapEditorHelper::GetInterpolateScalarsBeforeMapping(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockInterpolateScalarsBeforeMapping(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockInterpolateScalarsBeforeMapping");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    int tempr = vtkSMColorMapEditorHelper::GetBlockInterpolateScalarsBeforeMapping(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlocksInterpolateScalarsBeforeMappings(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlocksInterpolateScalarsBeforeMappings");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    std::vector<int> tempr = vtkSMColorMapEditorHelper::GetBlocksInterpolateScalarsBeforeMappings(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedInterpolateScalarsBeforeMappings(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedInterpolateScalarsBeforeMappings");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->GetSelectedInterpolateScalarsBeforeMappings(temp0) :
      op->vtkSMColorMapEditorHelper::GetSelectedInterpolateScalarsBeforeMappings(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetAnySelectedInterpolateScalarsBeforeMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnySelectedInterpolateScalarsBeforeMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAnySelectedInterpolateScalarsBeforeMapping(temp0) :
      op->vtkSMColorMapEditorHelper::GetAnySelectedInterpolateScalarsBeforeMapping(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_IsOpacityValid(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsOpacityValid");

  double temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = vtkSMColorMapEditorHelper::IsOpacityValid(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetOpacity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetOpacity");

  vtkSMProxy *temp0 = nullptr;
  double temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMColorMapEditorHelper::SetOpacity(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlockOpacity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlockOpacity");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  double temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::SetBlockOpacity(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetBlocksOpacity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBlocksOpacity");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  double temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::SetBlocksOpacity(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlockOpacity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlockOpacity");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMColorMapEditorHelper::RemoveBlockOpacity(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlocksOpacities(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlocksOpacities");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    vtkSMColorMapEditorHelper::RemoveBlocksOpacities(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_SetSelectedOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSelectedOpacity(temp0, temp1);
    }
    else
    {
      op->vtkSMColorMapEditorHelper::SetSelectedOpacity(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetOpacity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetOpacity");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    double tempr = vtkSMColorMapEditorHelper::GetOpacity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlockOpacity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlockOpacity");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    double tempr = vtkSMColorMapEditorHelper::GetBlockOpacity(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetBlocksOpacities(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBlocksOpacities");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    std::vector<double> tempr = vtkSMColorMapEditorHelper::GetBlocksOpacities(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_GetSelectedOpacities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedOpacities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMColorMapEditorHelper *op = static_cast<vtkSMColorMapEditorHelper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    std::vector<double> tempr = (ap.IsBound() ?
      op->GetSelectedOpacities(temp0) :
      op->vtkSMColorMapEditorHelper::GetSelectedOpacities(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_ResetBlockProperty(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ResetBlockProperty");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  std::string temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::ResetBlockProperty(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_RemoveBlockProperties(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RemoveBlockProperties");

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  std::vector<std::string> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    vtkSMColorMapEditorHelper::RemoveBlockProperties(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_ResetBlocksProperty(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ResetBlocksProperty");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  std::string temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2))
  {
    vtkSMColorMapEditorHelper::ResetBlocksProperty(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMColorMapEditorHelper_ResetBlocksProperties(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ResetBlocksProperties");

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  std::vector<std::string> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    vtkSMColorMapEditorHelper::ResetBlocksProperties(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMColorMapEditorHelper_Methods[] = {
  {"IsTypeOf", PyvtkSMColorMapEditorHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMColorMapEditorHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMColorMapEditorHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMColorMapEditorHelper\nC++: static vtkSMColorMapEditorHelper *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMColorMapEditorHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMColorMapEditorHelper\nC++: vtkSMColorMapEditorHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMColorMapEditorHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMColorMapEditorHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSelectedPropertiesType", PyvtkSMColorMapEditorHelper_SetSelectedPropertiesType, METH_VARARGS,
   "SetSelectedPropertiesType(self, _arg:int) -> None\nC++: virtual void SetSelectedPropertiesType(int _arg)\n\nSet/Get the selected properties type.\n\nThis variable is used in all instance functions with the Selected\nkey-word in the name.\n\nIt decides whether to use a function that uses the representation's or\nblocks' properties.\n\nDefault is false.\n"},
  {"GetSelectedPropertiesTypeMinValue", PyvtkSMColorMapEditorHelper_GetSelectedPropertiesTypeMinValue, METH_VARARGS,
   "GetSelectedPropertiesTypeMinValue(self) -> int\nC++: virtual int GetSelectedPropertiesTypeMinValue()\n\n"},
  {"GetSelectedPropertiesTypeMaxValue", PyvtkSMColorMapEditorHelper_GetSelectedPropertiesTypeMaxValue, METH_VARARGS,
   "GetSelectedPropertiesTypeMaxValue(self) -> int\nC++: virtual int GetSelectedPropertiesTypeMaxValue()\n\n"},
  {"SetSelectedPropertiesTypeToRepresentation", PyvtkSMColorMapEditorHelper_SetSelectedPropertiesTypeToRepresentation, METH_VARARGS,
   "SetSelectedPropertiesTypeToRepresentation(self) -> None\nC++: void SetSelectedPropertiesTypeToRepresentation()\n\n"},
  {"SetSelectedPropertiesTypeToBlocks", PyvtkSMColorMapEditorHelper_SetSelectedPropertiesTypeToBlocks, METH_VARARGS,
   "SetSelectedPropertiesTypeToBlocks(self) -> None\nC++: void SetSelectedPropertiesTypeToBlocks()\n\n"},
  {"GetSelectedPropertiesType", PyvtkSMColorMapEditorHelper_GetSelectedPropertiesType, METH_VARARGS,
   "GetSelectedPropertiesType(self) -> int\nC++: virtual int GetSelectedPropertiesType()\n\n"},
  {"GetPropertyType", PyvtkSMColorMapEditorHelper_GetPropertyType, METH_VARARGS,
   "GetPropertyType(property:vtkSMProperty) -> SelectedPropertiesTypes\nC++: static SelectedPropertiesTypes GetPropertyType(\n    vtkSMProperty *property)\n\nDetermine if a property is a block property.\n"},
  {"GetSelectedBlockSelectors", PyvtkSMColorMapEditorHelper_GetSelectedBlockSelectors, METH_VARARGS,
   "GetSelectedBlockSelectors(proxy:vtkSMProxy) -> (str, ...)\nC++: static std::vector<std::string> GetSelectedBlockSelectors(\n    vtkSMProxy *proxy)\n\nReturns the selected block selectors for this representation.\n"},
  {"GetColorArraysBlockSelectors", PyvtkSMColorMapEditorHelper_GetColorArraysBlockSelectors, METH_VARARGS,
   "GetColorArraysBlockSelectors(proxy:vtkSMProxy) -> (str, ...)\nC++: static std::vector<std::string> GetColorArraysBlockSelectors(\n    vtkSMProxy *proxy)\n\nReturns the selectors that use a color array for this\nrepresentation.\n"},
  {"GetLUTProxy", PyvtkSMColorMapEditorHelper_GetLUTProxy, METH_VARARGS,
   "GetLUTProxy(proxy:vtkSMProxy, view:vtkSMProxy) -> vtkSMProxy\nC++: static vtkSMProxy *GetLUTProxy(vtkSMProxy *proxy,\n    vtkSMProxy *view)\n\nReturns the lut proxy of this representation in the given view.\n\nThe methods with a `view` parameter will return `nullptr` if the\nview is not a render view.\n"},
  {"GetLookupTable", PyvtkSMColorMapEditorHelper_GetLookupTable, METH_VARARGS,
   "GetLookupTable(proxy:vtkSMProxy) -> vtkSMProxy\nC++: static vtkSMProxy *GetLookupTable(vtkSMProxy *proxy)\nGetLookupTable(proxy:vtkSMProxy, view:vtkSMProxy) -> vtkSMProxy\nC++: static vtkSMProxy *GetLookupTable(vtkSMProxy *proxy,\n    vtkSMProxy *view)\n\n"},
  {"GetBlockLookupTable", PyvtkSMColorMapEditorHelper_GetBlockLookupTable, METH_VARARGS,
   "GetBlockLookupTable(proxy:vtkSMProxy, blockSelector:str)\n    -> vtkSMProxy\nC++: static vtkSMProxy *GetBlockLookupTable(vtkSMProxy *proxy,\n    const std::string &blockSelector)\nGetBlockLookupTable(proxy:vtkSMProxy, view:vtkSMProxy,\n    blockSelector:str) -> vtkSMProxy\nC++: static vtkSMProxy *GetBlockLookupTable(vtkSMProxy *proxy,\n    vtkSMProxy *view, const std::string &blockSelector)\n\n"},
  {"GetUsingScalarColoring", PyvtkSMColorMapEditorHelper_GetUsingScalarColoring, METH_VARARGS,
   "GetUsingScalarColoring(proxy:vtkSMProxy) -> bool\nC++: static bool GetUsingScalarColoring(vtkSMProxy *proxy)\n\nReturns true if scalar coloring is enabled. This checks whether a\nproperty named \"ColorArrayName\" exists and has a non-empty\nstring. This does not check for the validity of the array.\n"},
  {"GetBlockUsingScalarColoring", PyvtkSMColorMapEditorHelper_GetBlockUsingScalarColoring, METH_VARARGS,
   "GetBlockUsingScalarColoring(proxy:vtkSMProxy, blockSelector:str)\n    -> bool\nC++: static bool GetBlockUsingScalarColoring(vtkSMProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"GetBlocksUsingScalarColoring", PyvtkSMColorMapEditorHelper_GetBlocksUsingScalarColoring, METH_VARARGS,
   "GetBlocksUsingScalarColoring(proxy:vtkSMProxy, blockSelectors:(\n    str, ...)) -> (int, ...)\nC++: static std::vector<vtkTypeBool> GetBlocksUsingScalarColoring(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetAnyBlockUsingScalarColoring", PyvtkSMColorMapEditorHelper_GetAnyBlockUsingScalarColoring, METH_VARARGS,
   "GetAnyBlockUsingScalarColoring(proxy:vtkSMProxy) -> bool\nC++: static bool GetAnyBlockUsingScalarColoring(vtkSMProxy *proxy)\n\n"},
  {"GetSelectedUsingScalarColorings", PyvtkSMColorMapEditorHelper_GetSelectedUsingScalarColorings, METH_VARARGS,
   "GetSelectedUsingScalarColorings(self, proxy:vtkSMProxy) -> (int,\n    ...)\nC++: std::vector<vtkTypeBool> GetSelectedUsingScalarColorings(\n    vtkSMProxy *proxy)\n\n"},
  {"GetAnySelectedUsingScalarColoring", PyvtkSMColorMapEditorHelper_GetAnySelectedUsingScalarColoring, METH_VARARGS,
   "GetAnySelectedUsingScalarColoring(self, proxy:vtkSMProxy) -> bool\nC++: bool GetAnySelectedUsingScalarColoring(vtkSMProxy *proxy)\n\n"},
  {"SetupLookupTable", PyvtkSMColorMapEditorHelper_SetupLookupTable, METH_VARARGS,
   "SetupLookupTable(proxy:vtkSMProxy) -> None\nC++: static void SetupLookupTable(vtkSMProxy *proxy)\n\nGiven the input registered representation `proxy`, sets up a\nlookup table associated with the representation if a scalar bar\nis being used for `proxy`.\n"},
  {"SetupBlocksLookupTables", PyvtkSMColorMapEditorHelper_SetupBlocksLookupTables, METH_VARARGS,
   "SetupBlocksLookupTables(proxy:vtkSMProxy) -> None\nC++: static void SetupBlocksLookupTables(vtkSMProxy *proxy)\n\n"},
  {"UpdateScalarBarRange", PyvtkSMColorMapEditorHelper_UpdateScalarBarRange, METH_VARARGS,
   "UpdateScalarBarRange(proxy:vtkSMProxy, view:vtkSMProxy,\n    deleteRange:bool) -> bool\nC++: static bool UpdateScalarBarRange(vtkSMProxy *proxy,\n    vtkSMProxy *view, bool deleteRange)\n\nUpdates the ranges shown in the scalar bar. If deleteRange is\ntrue, then the range stored for current representation proxy is\ndeleted. This should be done when the scalar bar gets separated\nor becomes not visible. If deleteRange is false, then the range\nstored for current representation proxy is updated with the new\nrange value.\n"},
  {"UpdateBlocksScalarBarRange", PyvtkSMColorMapEditorHelper_UpdateBlocksScalarBarRange, METH_VARARGS,
   "UpdateBlocksScalarBarRange(proxy:vtkSMProxy, view:vtkSMProxy,\n    deleteRange:bool) -> (int, ...)\nC++: static std::vector<vtkTypeBool> UpdateBlocksScalarBarRange(\n    vtkSMProxy *proxy, vtkSMProxy *view, bool deleteRange)\n\n"},
  {"SetScalarColoring", PyvtkSMColorMapEditorHelper_SetScalarColoring, METH_VARARGS,
   "SetScalarColoring(proxy:vtkSMProxy, arrayName:str,\n    attributeType:int) -> bool\nC++: static bool SetScalarColoring(vtkSMProxy *proxy,\n    const char *arrayName, int attributeType)\nSetScalarColoring(proxy:vtkSMProxy, arrayName:str,\n    attributeType:int, component:int) -> bool\nC++: static bool SetScalarColoring(vtkSMProxy *proxy,\n    const char *arrayName, int attributeType, int component)\n\nEnable/disable scalar coloring using the specified array. This\nwill set up a color and opacity transfer functions using\nvtkSMTransferFunctionProxy instance. If arrayName is nullptr,\nthen scalar coloring is turned off.attributeType must be one of\nvtkDataObject::AttributeTypes.\n"},
  {"SetBlockScalarColoring", PyvtkSMColorMapEditorHelper_SetBlockScalarColoring, METH_VARARGS,
   "SetBlockScalarColoring(proxy:vtkSMProxy, blockSelector:str,\n    arrayName:str, attributeType:int) -> bool\nC++: static bool SetBlockScalarColoring(vtkSMProxy *proxy,\n    const std::string &blockSelector, const char *arrayName,\n    int attributeType)\nSetBlockScalarColoring(proxy:vtkSMProxy, blockSelector:str,\n    arrayName:str, attributeType:int, component:int) -> bool\nC++: static bool SetBlockScalarColoring(vtkSMProxy *proxy,\n    const std::string &blockSelector, const char *arrayName,\n    int attributeType, int component)\n\n"},
  {"SetBlocksScalarColoring", PyvtkSMColorMapEditorHelper_SetBlocksScalarColoring, METH_VARARGS,
   "SetBlocksScalarColoring(proxy:vtkSMProxy, blockSelectors:(str,\n    ...), arrayName:str, attributeType:int) -> (int, ...)\nC++: static std::vector<vtkTypeBool> SetBlocksScalarColoring(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    const char *arrayName, int attributeType)\nSetBlocksScalarColoring(proxy:vtkSMProxy, blockSelectors:(str,\n    ...), arrayName:str, attributeType:int, component:int) -> (\n    int, ...)\nC++: static std::vector<vtkTypeBool> SetBlocksScalarColoring(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    const char *arrayName, int attributeType, int component)\n\n"},
  {"SetSelectedScalarColoring", PyvtkSMColorMapEditorHelper_SetSelectedScalarColoring, METH_VARARGS,
   "SetSelectedScalarColoring(self, proxy:vtkSMProxy, arrayName:str,\n    attributeType:int) -> (int, ...)\nC++: std::vector<vtkTypeBool> SetSelectedScalarColoring(\n    vtkSMProxy *proxy, const char *arrayName, int attributeType)\nSetSelectedScalarColoring(self, proxy:vtkSMProxy, arrayName:str,\n    attributeType:int, component:int) -> (int, ...)\nC++: std::vector<vtkTypeBool> SetSelectedScalarColoring(\n    vtkSMProxy *proxy, const char *arrayName, int attributeType,\n    int component)\n\n"},
  {"RescaleTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRange, METH_VARARGS,
   "RescaleTransferFunctionToDataRange(proxy:vtkSMProxy,\n    extend:bool=False, force:bool=True) -> bool\nC++: static bool RescaleTransferFunctionToDataRange(\n    vtkSMProxy *proxy, bool extend=false, bool force=true)\nRescaleTransferFunctionToDataRange(proxy:vtkSMProxy,\n    arrayName:str, attributeType:int, extend:bool=False,\n    force:bool=True) -> bool\nC++: static bool RescaleTransferFunctionToDataRange(\n    vtkSMProxy *proxy, const char *arrayName, int attributeType,\n    bool extend=false, bool force=true)\n\nRescales the color transfer function and opacity transfer\nfunction using the current data range. Returns true if rescale\nwas successful. If extend is true (false by default), the\ntransfer function range will only be extended as needed to fit\nthe data range. If force is false (true by default), then the\ntransfer function range is not changed if locked.\n"},
  {"RescaleBlockTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRange, METH_VARARGS,
   "RescaleBlockTransferFunctionToDataRange(proxy:vtkSMProxy,\n    blockSelector:str, extend:bool=False, force:bool=True) -> bool\nC++: static bool RescaleBlockTransferFunctionToDataRange(\n    vtkSMProxy *proxy, const std::string &blockSelector,\n    bool extend=false, bool force=true)\nRescaleBlockTransferFunctionToDataRange(proxy:vtkSMProxy,\n    blockSelector:str, arrayName:str, attributeType:int,\n    extend:bool=False, force:bool=True) -> bool\nC++: static bool RescaleBlockTransferFunctionToDataRange(\n    vtkSMProxy *proxy, const std::string &blockSelector,\n    const char *arrayName, int attributeType, bool extend=false,\n    bool force=true)\n\n"},
  {"RescaleBlocksTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRange, METH_VARARGS,
   "RescaleBlocksTransferFunctionToDataRange(proxy:vtkSMProxy,\n    blockSelectors:(str, ...), extend:bool=False, force:bool=True)\n     -> (int, ...)\nC++: static std::vector<vtkTypeBool> RescaleBlocksTransferFunctionToDataRange(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    bool extend=false, bool force=true)\nRescaleBlocksTransferFunctionToDataRange(proxy:vtkSMProxy,\n    blockSelectors:(str, ...), arrayName:str, attributeType:int,\n    extend:bool=False, force:bool=True) -> (int, ...)\nC++: static std::vector<vtkTypeBool> RescaleBlocksTransferFunctionToDataRange(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    const char *arrayName, int attributeType, bool extend=false,\n    bool force=true)\n\n"},
  {"RescaleSelectedTransferFunctionToDataRange", PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRange, METH_VARARGS,
   "RescaleSelectedTransferFunctionToDataRange(self, proxy:vtkSMProxy,\n     extend:bool=False, force:bool=True) -> (int, ...)\nC++: std::vector<vtkTypeBool> RescaleSelectedTransferFunctionToDataRange(\n    vtkSMProxy *proxy, bool extend=false, bool force=true)\nRescaleSelectedTransferFunctionToDataRange(self, proxy:vtkSMProxy,\n     arrayName:str, attributeType:int, extend:bool=False,\n    force:bool=True) -> (int, ...)\nC++: std::vector<vtkTypeBool> RescaleSelectedTransferFunctionToDataRange(\n    vtkSMProxy *proxy, const char *arrayName, int attributeType,\n    bool extend=false, bool force=true)\n\n"},
  {"RescaleTransferFunctionToDataRangeOverTime", PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToDataRangeOverTime, METH_VARARGS,
   "RescaleTransferFunctionToDataRangeOverTime(proxy:vtkSMProxy)\n    -> bool\nC++: static bool RescaleTransferFunctionToDataRangeOverTime(\n    vtkSMProxy *proxy)\nRescaleTransferFunctionToDataRangeOverTime(proxy:vtkSMProxy,\n    arrayName:str, attributeType:int) -> bool\nC++: static bool RescaleTransferFunctionToDataRangeOverTime(\n    vtkSMProxy *proxy, const char *arrayName, int attributeType)\n\nRescales the color transfer function and opacity transfer\nfunction using the current data range over time. Returns true if\nrescale was successful.\n"},
  {"RescaleBlockTransferFunctionToDataRangeOverTime", PyvtkSMColorMapEditorHelper_RescaleBlockTransferFunctionToDataRangeOverTime, METH_VARARGS,
   "RescaleBlockTransferFunctionToDataRangeOverTime(proxy:vtkSMProxy,\n    blockSelector:str) -> bool\nC++: static bool RescaleBlockTransferFunctionToDataRangeOverTime(\n    vtkSMProxy *proxy, const std::string &blockSelector)\nRescaleBlockTransferFunctionToDataRangeOverTime(proxy:vtkSMProxy,\n    blockSelector:str, arrayName:str, attributeType:int) -> bool\nC++: static bool RescaleBlockTransferFunctionToDataRangeOverTime(\n    vtkSMProxy *proxy, const std::string &blockSelector,\n    const char *arrayName, int attributeType)\n\n"},
  {"RescaleBlocksTransferFunctionToDataRangeOverTime", PyvtkSMColorMapEditorHelper_RescaleBlocksTransferFunctionToDataRangeOverTime, METH_VARARGS,
   "RescaleBlocksTransferFunctionToDataRangeOverTime(proxy:vtkSMProxy,\n     blockSelectors:(str, ...)) -> (int, ...)\nC++: static std::vector<vtkTypeBool> RescaleBlocksTransferFunctionToDataRangeOverTime(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\nRescaleBlocksTransferFunctionToDataRangeOverTime(proxy:vtkSMProxy,\n     blockSelectors:(str, ...), arrayName:str, attributeType:int)\n    -> (int, ...)\nC++: static std::vector<vtkTypeBool> RescaleBlocksTransferFunctionToDataRangeOverTime(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    const char *arrayName, int attributeType)\n\n"},
  {"RescaleSelectedTransferFunctionToDataRangeOverTime", PyvtkSMColorMapEditorHelper_RescaleSelectedTransferFunctionToDataRangeOverTime, METH_VARARGS,
   "RescaleSelectedTransferFunctionToDataRangeOverTime(self,\n    proxy:vtkSMProxy) -> (int, ...)\nC++: std::vector<vtkTypeBool> RescaleSelectedTransferFunctionToDataRangeOverTime(\n    vtkSMProxy *proxy)\nRescaleSelectedTransferFunctionToDataRangeOverTime(self,\n    proxy:vtkSMProxy, arrayName:str, attributeType:int) -> (int,\n    ...)\nC++: std::vector<vtkTypeBool> RescaleSelectedTransferFunctionToDataRangeOverTime(\n    vtkSMProxy *proxy, const char *arrayName, int attributeType)\n\n"},
  {"RescaleTransferFunctionToVisibleRange", PyvtkSMColorMapEditorHelper_RescaleTransferFunctionToVisibleRange, METH_VARARGS,
   "RescaleTransferFunctionToVisibleRange(proxy:vtkSMProxy,\n    view:vtkSMProxy) -> bool\nC++: static bool RescaleTransferFunctionToVisibleRange(\n    vtkSMProxy *proxy, vtkSMProxy *view)\nRescaleTransferFunctionToVisibleRange(proxy:vtkSMProxy,\n    view:vtkSMProxy, arrayName:str, attributeType:int) -> bool\nC++: static bool RescaleTransferFunctionToVisibleRange(\n    vtkSMProxy *proxy, vtkSMProxy *view, const char *arrayName,\n    int attributeType)\n\nRescales the color transfer function and the opacity transfer\nfunction using the current data range, limited to the current\nvisible elements.\n"},
  {"SetScalarBarVisibility", PyvtkSMColorMapEditorHelper_SetScalarBarVisibility, METH_VARARGS,
   "SetScalarBarVisibility(proxy:vtkSMProxy, view:vtkSMProxy,\n    visible:bool) -> bool\nC++: static bool SetScalarBarVisibility(vtkSMProxy *proxy,\n    vtkSMProxy *view, bool visible)\n\nSet the scalar bar visibility. This will create a new scalar bar\nas needed. Scalar bar is only shown if scalar coloring is indeed\nbeing used.\n"},
  {"SetBlockScalarBarVisibility", PyvtkSMColorMapEditorHelper_SetBlockScalarBarVisibility, METH_VARARGS,
   "SetBlockScalarBarVisibility(proxy:vtkSMProxy, view:vtkSMProxy,\n    blockSelector:str, visible:bool) -> bool\nC++: static bool SetBlockScalarBarVisibility(vtkSMProxy *proxy,\n    vtkSMProxy *view, const std::string &blockSelector,\n    bool visible)\n\n"},
  {"SetBlocksScalarBarVisibility", PyvtkSMColorMapEditorHelper_SetBlocksScalarBarVisibility, METH_VARARGS,
   "SetBlocksScalarBarVisibility(proxy:vtkSMProxy, view:vtkSMProxy,\n    blockSelectors:(str, ...), visible:bool) -> (int, ...)\nC++: static std::vector<vtkTypeBool> SetBlocksScalarBarVisibility(\n    vtkSMProxy *proxy, vtkSMProxy *view,\n    const std::vector<std::string> &blockSelectors, bool visible)\n\n"},
  {"SetSelectedScalarBarVisibility", PyvtkSMColorMapEditorHelper_SetSelectedScalarBarVisibility, METH_VARARGS,
   "SetSelectedScalarBarVisibility(self, proxy:vtkSMProxy,\n    view:vtkSMProxy, visible:bool) -> (int, ...)\nC++: std::vector<vtkTypeBool> SetSelectedScalarBarVisibility(\n    vtkSMProxy *proxy, vtkSMProxy *view, bool visible)\n\n"},
  {"HideScalarBarIfNotNeeded", PyvtkSMColorMapEditorHelper_HideScalarBarIfNotNeeded, METH_VARARGS,
   "HideScalarBarIfNotNeeded(repr:vtkSMProxy, view:vtkSMProxy) -> bool\nC++: static bool HideScalarBarIfNotNeeded(vtkSMProxy *repr,\n    vtkSMProxy *view)\n\nWhile SetScalarBarVisibility can be used to hide a scalar bar, it\nwill always simply hide the scalar bar even if its being used by\nsome other representation. Use this method instead to only hide\nthe scalar/color bar if no other visible representation in the\nview is mapping data using the scalar bar.\n"},
  {"HideBlocksScalarBarIfNotNeeded", PyvtkSMColorMapEditorHelper_HideBlocksScalarBarIfNotNeeded, METH_VARARGS,
   "HideBlocksScalarBarIfNotNeeded(repr:vtkSMProxy, view:vtkSMProxy)\n    -> bool\nC++: static bool HideBlocksScalarBarIfNotNeeded(vtkSMProxy *repr,\n    vtkSMProxy *view)\n\n"},
  {"IsScalarBarVisible", PyvtkSMColorMapEditorHelper_IsScalarBarVisible, METH_VARARGS,
   "IsScalarBarVisible(repr:vtkSMProxy, view:vtkSMProxy) -> bool\nC++: static bool IsScalarBarVisible(vtkSMProxy *repr,\n    vtkSMProxy *view)\n\nCheck scalar bar visibility.  Return true if the scalar bar for\nthis representation and view is visible, return false otherwise.\n"},
  {"IsBlockScalarBarVisible", PyvtkSMColorMapEditorHelper_IsBlockScalarBarVisible, METH_VARARGS,
   "IsBlockScalarBarVisible(repr:vtkSMProxy, view:vtkSMProxy,\n    blockSelector:str) -> bool\nC++: static bool IsBlockScalarBarVisible(vtkSMProxy *repr,\n    vtkSMProxy *view, const std::string &blockSelector)\n\n"},
  {"IsBlocksScalarBarVisible", PyvtkSMColorMapEditorHelper_IsBlocksScalarBarVisible, METH_VARARGS,
   "IsBlocksScalarBarVisible(repr:vtkSMProxy, view:vtkSMProxy,\n    blockSelectors:(str, ...)) -> (int, ...)\nC++: static std::vector<vtkTypeBool> IsBlocksScalarBarVisible(\n    vtkSMProxy *repr, vtkSMProxy *view,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetArrayInformationForColorArray", PyvtkSMColorMapEditorHelper_GetArrayInformationForColorArray, METH_VARARGS,
   "GetArrayInformationForColorArray(proxy:vtkSMProxy,\n    checkRepresentedData:bool=True) -> vtkPVArrayInformation\nC++: static vtkPVArrayInformation *GetArrayInformationForColorArray(\n    vtkSMProxy *proxy, bool checkRepresentedData=true)\n\nReturns the array information for the data array used for scalar\ncoloring, from input data. If checkRepresentedData is true, it\nwill also check in the represented data. Default is true. If none\nis found, returns nullptr.\n"},
  {"GetBlockArrayInformationForColorArray", PyvtkSMColorMapEditorHelper_GetBlockArrayInformationForColorArray, METH_VARARGS,
   "GetBlockArrayInformationForColorArray(proxy:vtkSMProxy,\n    blockSelector:str) -> vtkPVArrayInformation\nC++: static vtkPVArrayInformation *GetBlockArrayInformationForColorArray(\n    vtkSMProxy *proxy, const std::string &blockSelector)\n\n"},
  {"GetDecoratedArrayName", PyvtkSMColorMapEditorHelper_GetDecoratedArrayName, METH_VARARGS,
   "GetDecoratedArrayName(proxy:vtkSMProxy, arrayName:str) -> str\nC++: static std::string GetDecoratedArrayName(vtkSMProxy *proxy,\n    const std::string &arrayName)\n\nIn case of UseSeparateColorMap enabled, this function prefix the\ngiven arrayName with unique identifier, otherwise it acts as a\npassthrough.\n"},
  {"GetBlockDecoratedArrayName", PyvtkSMColorMapEditorHelper_GetBlockDecoratedArrayName, METH_VARARGS,
   "GetBlockDecoratedArrayName(proxy:vtkSMProxy, blockSelector:str,\n    arrayName:str) -> str\nC++: static std::string GetBlockDecoratedArrayName(\n    vtkSMProxy *proxy, const std::string &blockSelector,\n    const std::string &arrayName)\n\n"},
  {"GetBlocksDecoratedArrayNames", PyvtkSMColorMapEditorHelper_GetBlocksDecoratedArrayNames, METH_VARARGS,
   "GetBlocksDecoratedArrayNames(proxy:vtkSMProxy, blockSelectors:(\n    str, ...), arrayName:str) -> (str, ...)\nC++: static std::vector<std::string> GetBlocksDecoratedArrayNames(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    const std::string &arrayName)\n\n"},
  {"GetProminentValuesInformationForColorArray", PyvtkSMColorMapEditorHelper_GetProminentValuesInformationForColorArray, METH_VARARGS,
   "GetProminentValuesInformationForColorArray(proxy:vtkSMProxy,\n    uncertaintyAllowed:float=1e-6, fraction:float=1e-3,\n    force:bool=False) -> vtkPVProminentValuesInformation\nC++: static vtkPVProminentValuesInformation *GetProminentValuesInformationForColorArray(\n    vtkSMProxy *proxy, double uncertaintyAllowed=1e-6,\n    double fraction=1e-3, bool force=false)\n\nCall vtkSMRepresentationProxy::GetProminentValuesInformation()\nfor the array used for scalar color, if any. Otherwise returns\nnullptr.\n"},
  {"GetBlockProminentValuesInformationForColorArray", PyvtkSMColorMapEditorHelper_GetBlockProminentValuesInformationForColorArray, METH_VARARGS,
   "GetBlockProminentValuesInformationForColorArray(proxy:vtkSMProxy,\n    blockSelector:str, uncertaintyAllowed:float=1e-6,\n    fraction:float=1e-3, force:bool=False)\n    -> vtkPVProminentValuesInformation\nC++: static vtkPVProminentValuesInformation *GetBlockProminentValuesInformationForColorArray(\n    vtkSMProxy *proxy, const std::string &blockSelector,\n    double uncertaintyAllowed=1e-6, double fraction=1e-3,\n    bool force=false)\n\n"},
  {"GetEstimatedNumberOfAnnotationsOnScalarBar", PyvtkSMColorMapEditorHelper_GetEstimatedNumberOfAnnotationsOnScalarBar, METH_VARARGS,
   "GetEstimatedNumberOfAnnotationsOnScalarBar(proxy:vtkSMProxy,\n    view:vtkSMProxy) -> int\nC++: static int GetEstimatedNumberOfAnnotationsOnScalarBar(\n    vtkSMProxy *proxy, vtkSMProxy *view)\n\nGet an estimated number of annotation shown on this\nrepresentation scalar bar\n\nIf the return value is -1, then the value is not set.\n"},
  {"GetBlockEstimatedNumberOfAnnotationsOnScalarBar", PyvtkSMColorMapEditorHelper_GetBlockEstimatedNumberOfAnnotationsOnScalarBar, METH_VARARGS,
   "GetBlockEstimatedNumberOfAnnotationsOnScalarBar(proxy:vtkSMProxy,\n    view:vtkSMProxy, blockSelector:str) -> int\nC++: static int GetBlockEstimatedNumberOfAnnotationsOnScalarBar(\n    vtkSMProxy *proxy, vtkSMProxy *view,\n    const std::string &blockSelector)\n\n"},
  {"GetBlocksEstimatedNumberOfAnnotationsOnScalarBars", PyvtkSMColorMapEditorHelper_GetBlocksEstimatedNumberOfAnnotationsOnScalarBars, METH_VARARGS,
   "GetBlocksEstimatedNumberOfAnnotationsOnScalarBars(\n    proxy:vtkSMProxy, view:vtkSMProxy, blockSelectors:(str, ...))\n    -> (int, ...)\nC++: static std::vector<int> GetBlocksEstimatedNumberOfAnnotationsOnScalarBars(\n    vtkSMProxy *proxy, vtkSMProxy *view,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetSelectedEstimatedNumberOfAnnotationsOnScalarBars", PyvtkSMColorMapEditorHelper_GetSelectedEstimatedNumberOfAnnotationsOnScalarBars, METH_VARARGS,
   "GetSelectedEstimatedNumberOfAnnotationsOnScalarBars(self,\n    proxy:vtkSMProxy, view:vtkSMProxy) -> (int, ...)\nC++: std::vector<int> GetSelectedEstimatedNumberOfAnnotationsOnScalarBars(\n    vtkSMProxy *proxy, vtkSMProxy *view)\n\n"},
  {"GetAnySelectedEstimatedNumberOfAnnotationsOnScalarBar", PyvtkSMColorMapEditorHelper_GetAnySelectedEstimatedNumberOfAnnotationsOnScalarBar, METH_VARARGS,
   "GetAnySelectedEstimatedNumberOfAnnotationsOnScalarBar(self,\n    proxy:vtkSMProxy, view:vtkSMProxy) -> int\nC++: int GetAnySelectedEstimatedNumberOfAnnotationsOnScalarBar(\n    vtkSMProxy *proxy, vtkSMProxy *view)\n\n"},
  {"IsScalarBarStickyVisible", PyvtkSMColorMapEditorHelper_IsScalarBarStickyVisible, METH_VARARGS,
   "IsScalarBarStickyVisible(proxy:vtkSMProxy, view:vtkSMProxy) -> int\nC++: static int IsScalarBarStickyVisible(vtkSMProxy *proxy,\n    vtkSMProxy *view)\n\nChecks if the scalar bar of this representation in view is sticky\nvisible, i.e. should be visible whenever this representation is\nalso visible. It returns 1 if the scalar bar is sticky visible, 0\nother wise. If any problem is encountered, for example if view ==\nnullptr, or if the scalar bar representation is not instantiated\n/ found, it returns -1.\n"},
  {"IsBlockScalarBarStickyVisible", PyvtkSMColorMapEditorHelper_IsBlockScalarBarStickyVisible, METH_VARARGS,
   "IsBlockScalarBarStickyVisible(proxy:vtkSMProxy, view:vtkSMProxy,\n    blockSelector:str) -> int\nC++: static int IsBlockScalarBarStickyVisible(vtkSMProxy *proxy,\n    vtkSMProxy *view, const std::string &blockSelector)\n\n"},
  {"IsBlocksScalarBarStickyVisible", PyvtkSMColorMapEditorHelper_IsBlocksScalarBarStickyVisible, METH_VARARGS,
   "IsBlocksScalarBarStickyVisible(proxy:vtkSMProxy, view:vtkSMProxy,\n    blockSelectors:(str, ...)) -> (int, ...)\nC++: static std::vector<int> IsBlocksScalarBarStickyVisible(\n    vtkSMProxy *proxy, vtkSMProxy *view,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"RemoveBlockColor", PyvtkSMColorMapEditorHelper_RemoveBlockColor, METH_VARARGS,
   "RemoveBlockColor(proxy:vtkSMProxy, blockSelector:str) -> None\nC++: static void RemoveBlockColor(vtkSMProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"RemoveBlocksColors", PyvtkSMColorMapEditorHelper_RemoveBlocksColors, METH_VARARGS,
   "RemoveBlocksColors(proxy:vtkSMProxy, blockSelectors:(str, ...))\n    -> None\nC++: static void RemoveBlocksColors(vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetColorArrayProperty", PyvtkSMColorMapEditorHelper_GetColorArrayProperty, METH_VARARGS,
   "GetColorArrayProperty(proxy:vtkSMProxy) -> vtkSMProperty\nC++: static vtkSMProperty *GetColorArrayProperty(\n    vtkSMProxy *proxy)\n\nGet Color array property\n"},
  {"GetBlockColorArrayProperty", PyvtkSMColorMapEditorHelper_GetBlockColorArrayProperty, METH_VARARGS,
   "GetBlockColorArrayProperty(proxy:vtkSMProxy) -> vtkSMProperty\nC++: static vtkSMProperty *GetBlockColorArrayProperty(\n    vtkSMProxy *proxy)\n\n"},
  {"GetSelectedColorArrayProperty", PyvtkSMColorMapEditorHelper_GetSelectedColorArrayProperty, METH_VARARGS,
   "GetSelectedColorArrayProperty(self, proxy:vtkSMProxy)\n    -> vtkSMProperty\nC++: vtkSMProperty *GetSelectedColorArrayProperty(\n    vtkSMProxy *proxy)\n\n"},
  {"GetBlockColorArrayAssociation", PyvtkSMColorMapEditorHelper_GetBlockColorArrayAssociation, METH_VARARGS,
   "GetBlockColorArrayAssociation(proxy:vtkSMProxy, blockSelector:str)\n     -> int\nC++: static int GetBlockColorArrayAssociation(vtkSMProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"GetBlockColorArrayName", PyvtkSMColorMapEditorHelper_GetBlockColorArrayName, METH_VARARGS,
   "GetBlockColorArrayName(proxy:vtkSMProxy, blockSelector:str) -> str\nC++: static std::string GetBlockColorArrayName(vtkSMProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"GetUseSeparateColorMapProperty", PyvtkSMColorMapEditorHelper_GetUseSeparateColorMapProperty, METH_VARARGS,
   "GetUseSeparateColorMapProperty(proxy:vtkSMProxy) -> vtkSMProperty\nC++: static vtkSMProperty *GetUseSeparateColorMapProperty(\n    vtkSMProxy *proxy)\n\nGet use separate color map property\n"},
  {"GetBlockUseSeparateColorMapProperty", PyvtkSMColorMapEditorHelper_GetBlockUseSeparateColorMapProperty, METH_VARARGS,
   "GetBlockUseSeparateColorMapProperty(proxy:vtkSMProxy)\n    -> vtkSMProperty\nC++: static vtkSMProperty *GetBlockUseSeparateColorMapProperty(\n    vtkSMProxy *proxy)\n\n"},
  {"GetSelectedUseSeparateColorMapProperty", PyvtkSMColorMapEditorHelper_GetSelectedUseSeparateColorMapProperty, METH_VARARGS,
   "GetSelectedUseSeparateColorMapProperty(self, proxy:vtkSMProxy)\n    -> vtkSMProperty\nC++: vtkSMProperty *GetSelectedUseSeparateColorMapProperty(\n    vtkSMProxy *proxy)\n\n"},
  {"IsUseSeparateColorMapValid", PyvtkSMColorMapEditorHelper_IsUseSeparateColorMapValid, METH_VARARGS,
   "IsUseSeparateColorMapValid(useSeparateColorMap:int) -> bool\nC++: static bool IsUseSeparateColorMapValid(\n    int useSeparateColorMap)\n\nSet/Get if we should use a separate color map.\n\note Use `IsUseSeparateColorMapValid` to check if the returned\nvalue is valid/set.\n"},
  {"SetUseSeparateColorMap", PyvtkSMColorMapEditorHelper_SetUseSeparateColorMap, METH_VARARGS,
   "SetUseSeparateColorMap(proxy:vtkSMProxy, use:bool) -> None\nC++: static void SetUseSeparateColorMap(vtkSMProxy *proxy,\n    bool use)\n\n"},
  {"SetBlockUseSeparateColorMap", PyvtkSMColorMapEditorHelper_SetBlockUseSeparateColorMap, METH_VARARGS,
   "SetBlockUseSeparateColorMap(proxy:vtkSMProxy, blockSelector:str,\n    use:bool) -> None\nC++: static void SetBlockUseSeparateColorMap(vtkSMProxy *proxy,\n    const std::string &blockSelector, bool use)\n\n"},
  {"SetBlocksUseSeparateColorMap", PyvtkSMColorMapEditorHelper_SetBlocksUseSeparateColorMap, METH_VARARGS,
   "SetBlocksUseSeparateColorMap(proxy:vtkSMProxy, blockSelectors:(\n    str, ...), use:bool) -> None\nC++: static void SetBlocksUseSeparateColorMap(vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors, bool use)\n\n"},
  {"RemoveBlockUseSeparateColorMap", PyvtkSMColorMapEditorHelper_RemoveBlockUseSeparateColorMap, METH_VARARGS,
   "RemoveBlockUseSeparateColorMap(proxy:vtkSMProxy,\n    blockSelector:str) -> None\nC++: static void RemoveBlockUseSeparateColorMap(vtkSMProxy *proxy,\n     const std::string &blockSelector)\n\n"},
  {"RemoveBlocksUseSeparateColorMaps", PyvtkSMColorMapEditorHelper_RemoveBlocksUseSeparateColorMaps, METH_VARARGS,
   "RemoveBlocksUseSeparateColorMaps(proxy:vtkSMProxy,\n    blockSelectors:(str, ...)) -> None\nC++: static void RemoveBlocksUseSeparateColorMaps(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"SetSelectedUseSeparateColorMap", PyvtkSMColorMapEditorHelper_SetSelectedUseSeparateColorMap, METH_VARARGS,
   "SetSelectedUseSeparateColorMap(self, proxy:vtkSMProxy, use:bool)\n    -> None\nC++: void SetSelectedUseSeparateColorMap(vtkSMProxy *proxy,\n    bool use)\n\n"},
  {"GetUseSeparateColorMap", PyvtkSMColorMapEditorHelper_GetUseSeparateColorMap, METH_VARARGS,
   "GetUseSeparateColorMap(proxy:vtkSMProxy) -> bool\nC++: static bool GetUseSeparateColorMap(vtkSMProxy *proxy)\n\n"},
  {"GetBlockUseSeparateColorMap", PyvtkSMColorMapEditorHelper_GetBlockUseSeparateColorMap, METH_VARARGS,
   "GetBlockUseSeparateColorMap(proxy:vtkSMProxy, blockSelector:str)\n    -> int\nC++: static int GetBlockUseSeparateColorMap(vtkSMProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"GetBlocksUseSeparateColorMaps", PyvtkSMColorMapEditorHelper_GetBlocksUseSeparateColorMaps, METH_VARARGS,
   "GetBlocksUseSeparateColorMaps(proxy:vtkSMProxy, blockSelectors:(\n    str, ...)) -> (int, ...)\nC++: static std::vector<int> GetBlocksUseSeparateColorMaps(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetSelectedUseSeparateColorMaps", PyvtkSMColorMapEditorHelper_GetSelectedUseSeparateColorMaps, METH_VARARGS,
   "GetSelectedUseSeparateColorMaps(self, proxy:vtkSMProxy) -> (int,\n    ...)\nC++: std::vector<int> GetSelectedUseSeparateColorMaps(\n    vtkSMProxy *proxy)\n\n"},
  {"GetAnySelectedUseSeparateColorMap", PyvtkSMColorMapEditorHelper_GetAnySelectedUseSeparateColorMap, METH_VARARGS,
   "GetAnySelectedUseSeparateColorMap(self, proxy:vtkSMProxy) -> bool\nC++: bool GetAnySelectedUseSeparateColorMap(vtkSMProxy *proxy)\n\n"},
  {"IsMapScalarsValid", PyvtkSMColorMapEditorHelper_IsMapScalarsValid, METH_VARARGS,
   "IsMapScalarsValid(mapScalars:int) -> bool\nC++: static bool IsMapScalarsValid(int mapScalars)\n\nSet/Get the map scalars of the representation.\n\note Use `IsMapScalarsValid` to check if the returned value is\nvalid/set.\n"},
  {"SetMapScalars", PyvtkSMColorMapEditorHelper_SetMapScalars, METH_VARARGS,
   "SetMapScalars(proxy:vtkSMProxy, mapScalars:bool) -> None\nC++: static void SetMapScalars(vtkSMProxy *proxy, bool mapScalars)\n\n"},
  {"SetBlockMapScalars", PyvtkSMColorMapEditorHelper_SetBlockMapScalars, METH_VARARGS,
   "SetBlockMapScalars(proxy:vtkSMProxy, blockSelector:str,\n    mapScalars:bool) -> None\nC++: static void SetBlockMapScalars(vtkSMProxy *proxy,\n    const std::string &blockSelector, bool mapScalars)\n\n"},
  {"SetBlocksMapScalars", PyvtkSMColorMapEditorHelper_SetBlocksMapScalars, METH_VARARGS,
   "SetBlocksMapScalars(proxy:vtkSMProxy, blockSelectors:(str, ...),\n    mapScalars:bool) -> None\nC++: static void SetBlocksMapScalars(vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    bool mapScalars)\n\n"},
  {"RemoveBlockMapScalars", PyvtkSMColorMapEditorHelper_RemoveBlockMapScalars, METH_VARARGS,
   "RemoveBlockMapScalars(proxy:vtkSMProxy, blockSelector:str) -> None\nC++: static void RemoveBlockMapScalars(vtkSMProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"RemoveBlocksMapScalars", PyvtkSMColorMapEditorHelper_RemoveBlocksMapScalars, METH_VARARGS,
   "RemoveBlocksMapScalars(proxy:vtkSMProxy, blockSelectors:(str, ...)\n    ) -> None\nC++: static void RemoveBlocksMapScalars(vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"SetSelectedMapScalars", PyvtkSMColorMapEditorHelper_SetSelectedMapScalars, METH_VARARGS,
   "SetSelectedMapScalars(self, proxy:vtkSMProxy, mapScalars:bool)\n    -> None\nC++: void SetSelectedMapScalars(vtkSMProxy *proxy,\n    bool mapScalars)\n\n"},
  {"GetMapScalars", PyvtkSMColorMapEditorHelper_GetMapScalars, METH_VARARGS,
   "GetMapScalars(proxy:vtkSMProxy) -> bool\nC++: static bool GetMapScalars(vtkSMProxy *proxy)\n\n"},
  {"GetBlockMapScalars", PyvtkSMColorMapEditorHelper_GetBlockMapScalars, METH_VARARGS,
   "GetBlockMapScalars(proxy:vtkSMProxy, blockSelector:str) -> int\nC++: static int GetBlockMapScalars(vtkSMProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"GetBlocksMapScalars", PyvtkSMColorMapEditorHelper_GetBlocksMapScalars, METH_VARARGS,
   "GetBlocksMapScalars(proxy:vtkSMProxy, blockSelectors:(str, ...))\n    -> (int, ...)\nC++: static std::vector<int> GetBlocksMapScalars(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetSelectedMapScalars", PyvtkSMColorMapEditorHelper_GetSelectedMapScalars, METH_VARARGS,
   "GetSelectedMapScalars(self, proxy:vtkSMProxy) -> (int, ...)\nC++: std::vector<int> GetSelectedMapScalars(vtkSMProxy *proxy)\n\n"},
  {"GetAnySelectedMapScalars", PyvtkSMColorMapEditorHelper_GetAnySelectedMapScalars, METH_VARARGS,
   "GetAnySelectedMapScalars(self, proxy:vtkSMProxy) -> bool\nC++: bool GetAnySelectedMapScalars(vtkSMProxy *proxy)\n\n"},
  {"IsInterpolateScalarsBeforeMappingValid", PyvtkSMColorMapEditorHelper_IsInterpolateScalarsBeforeMappingValid, METH_VARARGS,
   "IsInterpolateScalarsBeforeMappingValid(interpolate:int) -> bool\nC++: static bool IsInterpolateScalarsBeforeMappingValid(\n    int interpolate)\n\nSet/Get the map scalars of the representation.\n\note Use `IsInterpolateScalarsBeforeMappingValid` to check if the\nreturned value is valid/set.\n"},
  {"SetInterpolateScalarsBeforeMapping", PyvtkSMColorMapEditorHelper_SetInterpolateScalarsBeforeMapping, METH_VARARGS,
   "SetInterpolateScalarsBeforeMapping(proxy:vtkSMProxy,\n    interpolate:bool) -> None\nC++: static void SetInterpolateScalarsBeforeMapping(\n    vtkSMProxy *proxy, bool interpolate)\n\n"},
  {"SetBlockInterpolateScalarsBeforeMapping", PyvtkSMColorMapEditorHelper_SetBlockInterpolateScalarsBeforeMapping, METH_VARARGS,
   "SetBlockInterpolateScalarsBeforeMapping(proxy:vtkSMProxy,\n    blockSelector:str, interpolate:bool) -> None\nC++: static void SetBlockInterpolateScalarsBeforeMapping(\n    vtkSMProxy *proxy, const std::string &blockSelector,\n    bool interpolate)\n\n"},
  {"SetBlocksInterpolateScalarsBeforeMapping", PyvtkSMColorMapEditorHelper_SetBlocksInterpolateScalarsBeforeMapping, METH_VARARGS,
   "SetBlocksInterpolateScalarsBeforeMapping(proxy:vtkSMProxy,\n    blockSelectors:(str, ...), interpolate:bool) -> None\nC++: static void SetBlocksInterpolateScalarsBeforeMapping(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    bool interpolate)\n\n"},
  {"RemoveBlockInterpolateScalarsBeforeMapping", PyvtkSMColorMapEditorHelper_RemoveBlockInterpolateScalarsBeforeMapping, METH_VARARGS,
   "RemoveBlockInterpolateScalarsBeforeMapping(proxy:vtkSMProxy,\n    blockSelector:str) -> None\nC++: static void RemoveBlockInterpolateScalarsBeforeMapping(\n    vtkSMProxy *proxy, const std::string &blockSelector)\n\n"},
  {"RemoveBlocksInterpolateScalarsBeforeMappings", PyvtkSMColorMapEditorHelper_RemoveBlocksInterpolateScalarsBeforeMappings, METH_VARARGS,
   "RemoveBlocksInterpolateScalarsBeforeMappings(proxy:vtkSMProxy,\n    blockSelectors:(str, ...)) -> None\nC++: static void RemoveBlocksInterpolateScalarsBeforeMappings(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"SetSelectedInterpolateScalarsBeforeMapping", PyvtkSMColorMapEditorHelper_SetSelectedInterpolateScalarsBeforeMapping, METH_VARARGS,
   "SetSelectedInterpolateScalarsBeforeMapping(self, proxy:vtkSMProxy,\n     interpolate:bool) -> None\nC++: void SetSelectedInterpolateScalarsBeforeMapping(\n    vtkSMProxy *proxy, bool interpolate)\n\n"},
  {"GetInterpolateScalarsBeforeMapping", PyvtkSMColorMapEditorHelper_GetInterpolateScalarsBeforeMapping, METH_VARARGS,
   "GetInterpolateScalarsBeforeMapping(proxy:vtkSMProxy) -> bool\nC++: static bool GetInterpolateScalarsBeforeMapping(\n    vtkSMProxy *proxy)\n\n"},
  {"GetBlockInterpolateScalarsBeforeMapping", PyvtkSMColorMapEditorHelper_GetBlockInterpolateScalarsBeforeMapping, METH_VARARGS,
   "GetBlockInterpolateScalarsBeforeMapping(proxy:vtkSMProxy,\n    blockSelector:str) -> int\nC++: static int GetBlockInterpolateScalarsBeforeMapping(\n    vtkSMProxy *proxy, const std::string &blockSelector)\n\n"},
  {"GetBlocksInterpolateScalarsBeforeMappings", PyvtkSMColorMapEditorHelper_GetBlocksInterpolateScalarsBeforeMappings, METH_VARARGS,
   "GetBlocksInterpolateScalarsBeforeMappings(proxy:vtkSMProxy,\n    blockSelectors:(str, ...)) -> (int, ...)\nC++: static std::vector<int> GetBlocksInterpolateScalarsBeforeMappings(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetSelectedInterpolateScalarsBeforeMappings", PyvtkSMColorMapEditorHelper_GetSelectedInterpolateScalarsBeforeMappings, METH_VARARGS,
   "GetSelectedInterpolateScalarsBeforeMappings(self,\n    proxy:vtkSMProxy) -> (int, ...)\nC++: std::vector<int> GetSelectedInterpolateScalarsBeforeMappings(\n    vtkSMProxy *proxy)\n\n"},
  {"GetAnySelectedInterpolateScalarsBeforeMapping", PyvtkSMColorMapEditorHelper_GetAnySelectedInterpolateScalarsBeforeMapping, METH_VARARGS,
   "GetAnySelectedInterpolateScalarsBeforeMapping(self,\n    proxy:vtkSMProxy) -> bool\nC++: bool GetAnySelectedInterpolateScalarsBeforeMapping(\n    vtkSMProxy *proxy)\n\n"},
  {"IsOpacityValid", PyvtkSMColorMapEditorHelper_IsOpacityValid, METH_VARARGS,
   "IsOpacityValid(opacity:float) -> bool\nC++: static bool IsOpacityValid(double opacity)\n\nSet/Get the opacity of the representation.\n\note Use `IsOpacityValid` to check if the returned value is\nvalid/set.\n"},
  {"SetOpacity", PyvtkSMColorMapEditorHelper_SetOpacity, METH_VARARGS,
   "SetOpacity(proxy:vtkSMProxy, opacity:float) -> None\nC++: static void SetOpacity(vtkSMProxy *proxy, double opacity)\n\n"},
  {"SetBlockOpacity", PyvtkSMColorMapEditorHelper_SetBlockOpacity, METH_VARARGS,
   "SetBlockOpacity(proxy:vtkSMProxy, blockSelector:str,\n    opacity:float) -> None\nC++: static void SetBlockOpacity(vtkSMProxy *proxy,\n    const std::string &blockSelector, double opacity)\n\n"},
  {"SetBlocksOpacity", PyvtkSMColorMapEditorHelper_SetBlocksOpacity, METH_VARARGS,
   "SetBlocksOpacity(proxy:vtkSMProxy, blockSelectors:(str, ...),\n    opacity:float) -> None\nC++: static void SetBlocksOpacity(vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    double opacity)\n\n"},
  {"RemoveBlockOpacity", PyvtkSMColorMapEditorHelper_RemoveBlockOpacity, METH_VARARGS,
   "RemoveBlockOpacity(proxy:vtkSMProxy, blockSelector:str) -> None\nC++: static void RemoveBlockOpacity(vtkSMProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"RemoveBlocksOpacities", PyvtkSMColorMapEditorHelper_RemoveBlocksOpacities, METH_VARARGS,
   "RemoveBlocksOpacities(proxy:vtkSMProxy, blockSelectors:(str, ...))\n     -> None\nC++: static void RemoveBlocksOpacities(vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"SetSelectedOpacity", PyvtkSMColorMapEditorHelper_SetSelectedOpacity, METH_VARARGS,
   "SetSelectedOpacity(self, proxy:vtkSMProxy, opacity:float) -> None\nC++: void SetSelectedOpacity(vtkSMProxy *proxy, double opacity)\n\n"},
  {"GetOpacity", PyvtkSMColorMapEditorHelper_GetOpacity, METH_VARARGS,
   "GetOpacity(proxy:vtkSMProxy) -> float\nC++: static double GetOpacity(vtkSMProxy *proxy)\n\n"},
  {"GetBlockOpacity", PyvtkSMColorMapEditorHelper_GetBlockOpacity, METH_VARARGS,
   "GetBlockOpacity(proxy:vtkSMProxy, blockSelector:str) -> float\nC++: static double GetBlockOpacity(vtkSMProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"GetBlocksOpacities", PyvtkSMColorMapEditorHelper_GetBlocksOpacities, METH_VARARGS,
   "GetBlocksOpacities(proxy:vtkSMProxy, blockSelectors:(str, ...))\n    -> (float, ...)\nC++: static std::vector<double> GetBlocksOpacities(\n    vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetSelectedOpacities", PyvtkSMColorMapEditorHelper_GetSelectedOpacities, METH_VARARGS,
   "GetSelectedOpacities(self, proxy:vtkSMProxy) -> (float, ...)\nC++: std::vector<double> GetSelectedOpacities(vtkSMProxy *proxy)\n\n"},
  {"ResetBlockProperty", PyvtkSMColorMapEditorHelper_ResetBlockProperty, METH_VARARGS,
   "ResetBlockProperty(proxy:vtkSMProxy, blockSelector:str,\n    propertyName:str) -> None\nC++: static void ResetBlockProperty(vtkSMProxy *proxy,\n    const std::string &blockSelector,\n    const std::string &propertyName)\n\nReset a block property.\n"},
  {"RemoveBlockProperties", PyvtkSMColorMapEditorHelper_RemoveBlockProperties, METH_VARARGS,
   "RemoveBlockProperties(proxy:vtkSMProxy, blockSelector:str,\n    propertyNames:(str, ...)) -> None\nC++: static void RemoveBlockProperties(vtkSMProxy *proxy,\n    const std::string &blockSelector,\n    const std::vector<std::string> &propertyNames)\n\n"},
  {"ResetBlocksProperty", PyvtkSMColorMapEditorHelper_ResetBlocksProperty, METH_VARARGS,
   "ResetBlocksProperty(proxy:vtkSMProxy, blockSelectors:(str, ...),\n    propertyName:str) -> None\nC++: static void ResetBlocksProperty(vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    const std::string &propertyName)\n\n"},
  {"ResetBlocksProperties", PyvtkSMColorMapEditorHelper_ResetBlocksProperties, METH_VARARGS,
   "ResetBlocksProperties(proxy:vtkSMProxy, blockSelectors:(str, ...),\n     propertyNames:(str, ...)) -> None\nC++: static void ResetBlocksProperties(vtkSMProxy *proxy,\n    const std::vector<std::string> &blockSelectors,\n    const std::vector<std::string> &propertyNames)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMColorMapEditorHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("selected_properties_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMColorMapEditorHelper_GetSelectedPropertiesType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMColorMapEditorHelper_SetSelectedPropertiesType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMColorMapEditorHelper_SetSelectedPropertiesType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSelectedPropertiesType/SetSelectedPropertiesType\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMColorMapEditorHelper_Doc =
  "vtkSMColorMapEditorHelper - helper for color map editor handling\n\n"
  "Superclass: vtkObject\n\n"
  "It provides helper functions for controlling transfer functions,\n"
  "scalar coloring, etc. Scalar bar controlling is still working for\n"
  "RenderView only for now, as it's controlling the widget.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMColorMapEditorHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMColorMapEditorHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMColorMapEditorHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMColorMapEditorHelper_StaticNew()
{
  return vtkSMColorMapEditorHelper::New();
}

PyObject *PyvtkSMColorMapEditorHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMColorMapEditorHelper_Type, PyvtkSMColorMapEditorHelper_Methods,
    "vtkSMColorMapEditorHelper",
 &PyvtkSMColorMapEditorHelper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSMColorMapEditorHelper_SelectedPropertiesTypes_Type);
  PyVTKEnum_Add(&PyvtkSMColorMapEditorHelper_SelectedPropertiesTypes_Type, "vtkSMColorMapEditorHelper.SelectedPropertiesTypes");

  o = (PyObject *)&PyvtkSMColorMapEditorHelper_SelectedPropertiesTypes_Type;
  if (PyDict_SetItemString(d, "SelectedPropertiesTypes", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyvtkSMColorMapEditorHelper_BlockPropertyState_Type);
  PyVTKEnum_Add(&PyvtkSMColorMapEditorHelper_BlockPropertyState_Type, "vtkSMColorMapEditorHelper.BlockPropertyState");

  o = (PyObject *)&PyvtkSMColorMapEditorHelper_BlockPropertyState_Type;
  if (PyDict_SetItemString(d, "BlockPropertyState", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 2; c++)
  {
    typedef vtkSMColorMapEditorHelper::SelectedPropertiesTypes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[2] = {
        { "Representation", vtkSMColorMapEditorHelper::Representation },
        { "Blocks", vtkSMColorMapEditorHelper::Blocks },
      };

    o = PyvtkSMColorMapEditorHelper_SelectedPropertiesTypes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 9; c++)
  {
    typedef vtkSMColorMapEditorHelper::BlockPropertyState cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[9] = {
        { "Disabled", vtkSMColorMapEditorHelper::Disabled },
        { "RepresentationInherited", vtkSMColorMapEditorHelper::RepresentationInherited },
        { "BlockInherited", vtkSMColorMapEditorHelper::BlockInherited },
        { "MixedInherited", vtkSMColorMapEditorHelper::MixedInherited },
        { "Set", vtkSMColorMapEditorHelper::Set },
        { "SetAndRepresentationInherited", vtkSMColorMapEditorHelper::SetAndRepresentationInherited },
        { "SetAndBlockInherited", vtkSMColorMapEditorHelper::SetAndBlockInherited },
        { "SetAndMixedInherited", vtkSMColorMapEditorHelper::SetAndMixedInherited },
        { "NumberOfStates", vtkSMColorMapEditorHelper::NumberOfStates },
      };

    o = PyvtkSMColorMapEditorHelper_BlockPropertyState_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMColorMapEditorHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMColorMapEditorHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMColorMapEditorHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMColorMapEditorHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

