// python wrapper for vtkPVSynchronizedRenderer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVSynchronizedRenderer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVSynchronizedRenderer(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVSynchronizedRenderer_ClassNew(); }


static PyObject *
PyvtkPVSynchronizedRenderer_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVSynchronizedRenderer::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVSynchronizedRenderer::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVSynchronizedRenderer *tempr = vtkPVSynchronizedRenderer::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVSynchronizedRenderer *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVSynchronizedRenderer::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVSynchronizedRenderer::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVSynchronizedRenderer::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetDisableIceT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisableIceT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisableIceT(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetDisableIceT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetDisableIceT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisableIceT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisableIceT() :
      op->vtkPVSynchronizedRenderer::GetDisableIceT());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  vtkPVSession *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVSession"))
  {
    if (ap.IsBound())
    {
      op->Initialize(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::Initialize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetOrderedCompositingHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrderedCompositingHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  vtkOrderedCompositingHelper *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkOrderedCompositingHelper"))
  {
    if (ap.IsBound())
    {
      op->SetOrderedCompositingHelper(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetOrderedCompositingHelper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->SetRenderer(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnabled(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetEnabled(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnabled() :
      op->vtkPVSynchronizedRenderer::GetEnabled());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_EnabledOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnabledOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnabledOn();
    }
    else
    {
      op->vtkPVSynchronizedRenderer::EnabledOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_EnabledOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnabledOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnabledOff();
    }
    else
    {
      op->vtkPVSynchronizedRenderer::EnabledOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImageReductionFactor(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetImageReductionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetImageReductionFactor() :
      op->vtkPVSynchronizedRenderer::GetImageReductionFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetDataReplicatedOnAllProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataReplicatedOnAllProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDataReplicatedOnAllProcesses(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetDataReplicatedOnAllProcesses(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetDataReplicatedOnAllProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataReplicatedOnAllProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDataReplicatedOnAllProcesses() :
      op->vtkPVSynchronizedRenderer::GetDataReplicatedOnAllProcesses());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_DataReplicatedOnAllProcessesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataReplicatedOnAllProcessesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataReplicatedOnAllProcessesOn();
    }
    else
    {
      op->vtkPVSynchronizedRenderer::DataReplicatedOnAllProcessesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_DataReplicatedOnAllProcessesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataReplicatedOnAllProcessesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataReplicatedOnAllProcessesOff();
    }
    else
    {
      op->vtkPVSynchronizedRenderer::DataReplicatedOnAllProcessesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetImageProcessingPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageProcessingPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  vtkImageProcessingPass *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImageProcessingPass"))
  {
    if (ap.IsBound())
    {
      op->SetImageProcessingPass(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetImageProcessingPass(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetImageProcessingPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageProcessingPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImageProcessingPass *tempr = (ap.IsBound() ?
      op->GetImageProcessingPass() :
      op->vtkPVSynchronizedRenderer::GetImageProcessingPass());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  vtkRenderPass *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderPass"))
  {
    if (ap.IsBound())
    {
      op->SetRenderPass(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetRenderPass(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderPass *tempr = (ap.IsBound() ?
      op->GetRenderPass() :
      op->vtkPVSynchronizedRenderer::GetRenderPass());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_ConfigureCompressor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ConfigureCompressor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ConfigureCompressor(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::ConfigureCompressor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetLossLessCompression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLossLessCompression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLossLessCompression(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetLossLessCompression(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetUseDepthBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseDepthBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseDepthBuffer(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetUseDepthBuffer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetRenderEmptyImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderEmptyImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRenderEmptyImages(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetRenderEmptyImages(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetNVPipeSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNVPipeSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNVPipeSupport(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetNVPipeSupport(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetEnableRayTracing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableRayTracing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableRayTracing(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetEnableRayTracing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetEnableRayTracing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableRayTracing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableRayTracing() :
      op->vtkPVSynchronizedRenderer::GetEnableRayTracing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetEnablePathTracing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnablePathTracing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnablePathTracing(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetEnablePathTracing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetEnablePathTracing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnablePathTracing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnablePathTracing() :
      op->vtkPVSynchronizedRenderer::GetEnablePathTracing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetParallelSynchronizer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetParallelSynchronizer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSynchronizedRenderers *tempr = (ap.IsBound() ?
      op->GetParallelSynchronizer() :
      op->vtkPVSynchronizedRenderer::GetParallelSynchronizer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetCSSynchronizer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCSSynchronizer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSynchronizedRenderers *tempr = (ap.IsBound() ?
      op->GetCSSynchronizer() :
      op->vtkPVSynchronizedRenderer::GetCSSynchronizer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetUseFXAA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseFXAA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseFXAA(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetUseFXAA(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetUseFXAA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseFXAA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseFXAA() :
      op->vtkPVSynchronizedRenderer::GetUseFXAA());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_GetFXAAOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFXAAOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFXAAOptions *tempr = (ap.IsBound() ?
      op->GetFXAAOptions() :
      op->vtkPVSynchronizedRenderer::GetFXAAOptions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSynchronizedRenderer_SetFXAAOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFXAAOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSynchronizedRenderer *op = static_cast<vtkPVSynchronizedRenderer *>(vp);

  vtkFXAAOptions *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkFXAAOptions"))
  {
    if (ap.IsBound())
    {
      op->SetFXAAOptions(temp0);
    }
    else
    {
      op->vtkPVSynchronizedRenderer::SetFXAAOptions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVSynchronizedRenderer_Methods[] = {
  {"IsTypeOf", PyvtkPVSynchronizedRenderer_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVSynchronizedRenderer_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVSynchronizedRenderer_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVSynchronizedRenderer\nC++: static vtkPVSynchronizedRenderer *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVSynchronizedRenderer_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVSynchronizedRenderer\nC++: vtkPVSynchronizedRenderer *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVSynchronizedRenderer_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVSynchronizedRenderer_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetDisableIceT", PyvtkPVSynchronizedRenderer_SetDisableIceT, METH_VARARGS,
   "SetDisableIceT(self, _arg:bool) -> None\nC++: virtual void SetDisableIceT(bool _arg)\n\nSet this flag to true before calling Initialize() to disable\nusing vtkIceTSynchronizedRenderers for parallel rendering.\nDefault value is setup using\nvtkPVRenderViewSettings::GetDisableIceT.\n"},
  {"GetDisableIceT", PyvtkPVSynchronizedRenderer_GetDisableIceT, METH_VARARGS,
   "GetDisableIceT(self) -> bool\nC++: virtual bool GetDisableIceT()\n\n"},
  {"Initialize", PyvtkPVSynchronizedRenderer_Initialize, METH_VARARGS,
   "Initialize(self, session:vtkPVSession) -> None\nC++: void Initialize(vtkPVSession *session)\n\nMust be called once to initialize the instance. This will create\nappropriate internal vtkSynchronizedRenderers subclasses based on\nthe process type and session provided.\n"},
  {"SetOrderedCompositingHelper", PyvtkPVSynchronizedRenderer_SetOrderedCompositingHelper, METH_VARARGS,
   "SetOrderedCompositingHelper(self,\n    helper:vtkOrderedCompositingHelper) -> None\nC++: void SetOrderedCompositingHelper(\n    vtkOrderedCompositingHelper *helper)\n\nUsed to determine sorting order and use ordered compositing. Set\nto nullptr to not use ordered compositing and instead use\ndepth-buffer based compositing, if applicable.\n"},
  {"SetRenderer", PyvtkPVSynchronizedRenderer_SetRenderer, METH_VARARGS,
   "SetRenderer(self, __a:vtkRenderer) -> None\nC++: void SetRenderer(vtkRenderer *)\n\nSet the renderer that is being synchronized.\n"},
  {"SetEnabled", PyvtkPVSynchronizedRenderer_SetEnabled, METH_VARARGS,
   "SetEnabled(self, enabled:bool) -> None\nC++: virtual void SetEnabled(bool enabled)\n\nEnable/Disable parallel rendering.\n"},
  {"GetEnabled", PyvtkPVSynchronizedRenderer_GetEnabled, METH_VARARGS,
   "GetEnabled(self) -> bool\nC++: virtual bool GetEnabled()\n\n"},
  {"EnabledOn", PyvtkPVSynchronizedRenderer_EnabledOn, METH_VARARGS,
   "EnabledOn(self) -> None\nC++: virtual void EnabledOn()\n\n"},
  {"EnabledOff", PyvtkPVSynchronizedRenderer_EnabledOff, METH_VARARGS,
   "EnabledOff(self) -> None\nC++: virtual void EnabledOff()\n\n"},
  {"SetImageReductionFactor", PyvtkPVSynchronizedRenderer_SetImageReductionFactor, METH_VARARGS,
   "SetImageReductionFactor(self, __a:int) -> None\nC++: void SetImageReductionFactor(int)\n\nGet/Set the image reduction factor. This needs to be set on all\nprocesses and must match up.\n"},
  {"GetImageReductionFactor", PyvtkPVSynchronizedRenderer_GetImageReductionFactor, METH_VARARGS,
   "GetImageReductionFactor(self) -> int\nC++: virtual int GetImageReductionFactor()\n\n"},
  {"SetDataReplicatedOnAllProcesses", PyvtkPVSynchronizedRenderer_SetDataReplicatedOnAllProcesses, METH_VARARGS,
   "SetDataReplicatedOnAllProcesses(self, __a:bool) -> None\nC++: void SetDataReplicatedOnAllProcesses(bool)\n\nSet to true if data is replicated on all processes. This will\nenable IceT to minimize communications since data is available on\nall process. Off by default.\n"},
  {"GetDataReplicatedOnAllProcesses", PyvtkPVSynchronizedRenderer_GetDataReplicatedOnAllProcesses, METH_VARARGS,
   "GetDataReplicatedOnAllProcesses(self) -> bool\nC++: virtual bool GetDataReplicatedOnAllProcesses()\n\n"},
  {"DataReplicatedOnAllProcessesOn", PyvtkPVSynchronizedRenderer_DataReplicatedOnAllProcessesOn, METH_VARARGS,
   "DataReplicatedOnAllProcessesOn(self) -> None\nC++: virtual void DataReplicatedOnAllProcessesOn()\n\n"},
  {"DataReplicatedOnAllProcessesOff", PyvtkPVSynchronizedRenderer_DataReplicatedOnAllProcessesOff, METH_VARARGS,
   "DataReplicatedOnAllProcessesOff(self) -> None\nC++: virtual void DataReplicatedOnAllProcessesOff()\n\n"},
  {"SetImageProcessingPass", PyvtkPVSynchronizedRenderer_SetImageProcessingPass, METH_VARARGS,
   "SetImageProcessingPass(self, __a:vtkImageProcessingPass) -> None\nC++: void SetImageProcessingPass(vtkImageProcessingPass *)\n\nGet/Set an image processing pass to process the rendered images.\n"},
  {"GetImageProcessingPass", PyvtkPVSynchronizedRenderer_GetImageProcessingPass, METH_VARARGS,
   "GetImageProcessingPass(self) -> vtkImageProcessingPass\nC++: virtual vtkImageProcessingPass *GetImageProcessingPass()\n\n"},
  {"SetRenderPass", PyvtkPVSynchronizedRenderer_SetRenderPass, METH_VARARGS,
   "SetRenderPass(self, __a:vtkRenderPass) -> None\nC++: void SetRenderPass(vtkRenderPass *)\n\nGet/Set geometry rendering pass. This pass is used to render the\ngeometry. If none specified then default rendering pipeline is\nused. This is typically the render-pass pipeline after the\nCameraPass. The CameraPass is setup by ParaView specially since\nParaView needs some customizations for multiviews/icet etc.\n"},
  {"GetRenderPass", PyvtkPVSynchronizedRenderer_GetRenderPass, METH_VARARGS,
   "GetRenderPass(self) -> vtkRenderPass\nC++: virtual vtkRenderPass *GetRenderPass()\n\n"},
  {"ConfigureCompressor", PyvtkPVSynchronizedRenderer_ConfigureCompressor, METH_VARARGS,
   "ConfigureCompressor(self, configuration:str) -> None\nC++: void ConfigureCompressor(const char *configuration)\n\nPasses the compressor configuration to the client-server\nsynchronizer, if any. This affects the image compression used to\nrelay images back to the client. See\nvtkPVClientServerSynchronizedRenderers::ConfigureCompressor() for\ndetails.\n"},
  {"SetLossLessCompression", PyvtkPVSynchronizedRenderer_SetLossLessCompression, METH_VARARGS,
   "SetLossLessCompression(self, __a:bool) -> None\nC++: void SetLossLessCompression(bool)\n\n"},
  {"SetUseDepthBuffer", PyvtkPVSynchronizedRenderer_SetUseDepthBuffer, METH_VARARGS,
   "SetUseDepthBuffer(self, __a:bool) -> None\nC++: void SetUseDepthBuffer(bool)\n\nActivates or de-activated the use of Depth Buffer in an\nImageProcessingPass\n"},
  {"SetRenderEmptyImages", PyvtkPVSynchronizedRenderer_SetRenderEmptyImages, METH_VARARGS,
   "SetRenderEmptyImages(self, __a:bool) -> None\nC++: void SetRenderEmptyImages(bool)\n\nEnable/Disable empty images optimization.\n"},
  {"SetNVPipeSupport", PyvtkPVSynchronizedRenderer_SetNVPipeSupport, METH_VARARGS,
   "SetNVPipeSupport(self, __a:bool) -> None\nC++: void SetNVPipeSupport(bool)\n\nEnable/Disable NVPipe\n"},
  {"SetEnableRayTracing", PyvtkPVSynchronizedRenderer_SetEnableRayTracing, METH_VARARGS,
   "SetEnableRayTracing(self, val:bool) -> None\nC++: void SetEnableRayTracing(bool val)\n\nState flags to turn on specialized treatment for ray tracing.\n"},
  {"GetEnableRayTracing", PyvtkPVSynchronizedRenderer_GetEnableRayTracing, METH_VARARGS,
   "GetEnableRayTracing(self) -> bool\nC++: virtual bool GetEnableRayTracing()\n\n"},
  {"SetEnablePathTracing", PyvtkPVSynchronizedRenderer_SetEnablePathTracing, METH_VARARGS,
   "SetEnablePathTracing(self, val:bool) -> None\nC++: void SetEnablePathTracing(bool val)\n\n"},
  {"GetEnablePathTracing", PyvtkPVSynchronizedRenderer_GetEnablePathTracing, METH_VARARGS,
   "GetEnablePathTracing(self) -> bool\nC++: virtual bool GetEnablePathTracing()\n\n"},
  {"GetParallelSynchronizer", PyvtkPVSynchronizedRenderer_GetParallelSynchronizer, METH_VARARGS,
   "GetParallelSynchronizer(self) -> vtkSynchronizedRenderers\nC++: virtual vtkSynchronizedRenderers *GetParallelSynchronizer()\n\nNot for the faint hearted. This internal vtkSynchronizedRenderers\ninstances are exposed for advanced users that want to do advanced\ntricks with rendering. These will change without notice. Do not\nuse them unless you know what you are doing. ParallelSynchronizer\nis the vtkSynchronizedRenderers used to synchronize rendering\nbetween processes in an MPI group -- typically\nvtkIceTSynchronizedRenderers when available. CSSynchronizer is\nthe client-server vtkSynchronizedRenderers used in client-server\nconfigurations.\n"},
  {"GetCSSynchronizer", PyvtkPVSynchronizedRenderer_GetCSSynchronizer, METH_VARARGS,
   "GetCSSynchronizer(self) -> vtkSynchronizedRenderers\nC++: virtual vtkSynchronizedRenderers *GetCSSynchronizer()\n\n"},
  {"SetUseFXAA", PyvtkPVSynchronizedRenderer_SetUseFXAA, METH_VARARGS,
   "SetUseFXAA(self, use:bool) -> None\nC++: virtual void SetUseFXAA(bool use)\n\nEnable/disable FXAA antialiasing.\n"},
  {"GetUseFXAA", PyvtkPVSynchronizedRenderer_GetUseFXAA, METH_VARARGS,
   "GetUseFXAA(self) -> bool\nC++: virtual bool GetUseFXAA()\n\n"},
  {"GetFXAAOptions", PyvtkPVSynchronizedRenderer_GetFXAAOptions, METH_VARARGS,
   "GetFXAAOptions(self) -> vtkFXAAOptions\nC++: virtual vtkFXAAOptions *GetFXAAOptions()\n\nSet/Get FXAA options.\n"},
  {"SetFXAAOptions", PyvtkPVSynchronizedRenderer_SetFXAAOptions, METH_VARARGS,
   "SetFXAAOptions(self, __a:vtkFXAAOptions) -> None\nC++: virtual void SetFXAAOptions(vtkFXAAOptions *)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVSynchronizedRenderer_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("disable_ice_t"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetDisableIceT(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetDisableIceT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetDisableIceT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisableIceT/SetDisableIceT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ordered_compositing_helper"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetOrderedCompositingHelper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetOrderedCompositingHelper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrderedCompositingHelper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("renderer"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetRenderer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetRenderer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRenderer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enabled"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetEnabled(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetEnabled(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetEnabled(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnabled/SetEnabled\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_reduction_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetImageReductionFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetImageReductionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetImageReductionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImageReductionFactor/SetImageReductionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_replicated_on_all_processes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetDataReplicatedOnAllProcesses(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetDataReplicatedOnAllProcesses(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetDataReplicatedOnAllProcesses(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDataReplicatedOnAllProcesses/SetDataReplicatedOnAllProcesses\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_processing_pass"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetImageProcessingPass(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetImageProcessingPass(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetImageProcessingPass(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImageProcessingPass/SetImageProcessingPass\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_pass"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetRenderPass(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetRenderPass(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetRenderPass(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderPass/SetRenderPass\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("loss_less_compression"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetLossLessCompression(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetLossLessCompression(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLossLessCompression\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_depth_buffer"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetUseDepthBuffer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetUseDepthBuffer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseDepthBuffer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_empty_images"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetRenderEmptyImages(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetRenderEmptyImages(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRenderEmptyImages\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("nv_pipe_support"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetNVPipeSupport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetNVPipeSupport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNVPipeSupport\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_ray_tracing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetEnableRayTracing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetEnableRayTracing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetEnableRayTracing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableRayTracing/SetEnableRayTracing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_path_tracing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetEnablePathTracing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetEnablePathTracing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetEnablePathTracing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnablePathTracing/SetEnablePathTracing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_fxaa"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetUseFXAA(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetUseFXAA(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetUseFXAA(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseFXAA/SetUseFXAA\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fxaa_options"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetFXAAOptions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSynchronizedRenderer_SetFXAAOptions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSynchronizedRenderer_SetFXAAOptions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFXAAOptions/SetFXAAOptions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parallel_synchronizer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetParallelSynchronizer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetParallelSynchronizer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cs_synchronizer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSynchronizedRenderer_GetCSSynchronizer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCSSynchronizer\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVSynchronizedRenderer_Doc =
  "vtkPVSynchronizedRenderer - coordinates rendering between\ncorresponding renderers across multiple\n       processes\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVSynchronizedRenderer coordinates rendering between renderers\n"
  "that are split across multiple ranks. It internally uses other\n"
  "vtkSynchronizedRenderers subclasses based on the operation mode to do\n"
  "the actual coordination such as vtkCaveSynchronizedRenderers,\n"
  "vtkIceTSynchronizedRenderers, vtkPVClientServerSynchronizedRenderers\n"
  "and vtkCompositedSynchronizedRenderers.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVSynchronizedRenderer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVSynchronizedRenderer", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVSynchronizedRenderer_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVSynchronizedRenderer_StaticNew()
{
  return vtkPVSynchronizedRenderer::New();
}

PyObject *PyvtkPVSynchronizedRenderer_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVSynchronizedRenderer_Type, PyvtkPVSynchronizedRenderer_Methods,
    "vtkPVSynchronizedRenderer",
 &PyvtkPVSynchronizedRenderer_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVSynchronizedRenderer_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVSynchronizedRenderer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVSynchronizedRenderer_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVSynchronizedRenderer", o) != 0)
  {
    Py_DECREF(o);
  }

}

