// python wrapper for vtkPVRenderViewDataDeliveryManager
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkBoundingBox.h"
#include "vtkTimeStamp.h"
#include "vtkPVRenderViewDataDeliveryManager.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVRenderViewDataDeliveryManager(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVRenderViewDataDeliveryManager_ClassNew(); }

#ifndef DECLARED_PyvtkPVDataDeliveryManager_ClassNew
extern "C" { PyObject *PyvtkPVDataDeliveryManager_ClassNew(); }
#define DECLARED_PyvtkPVDataDeliveryManager_ClassNew
#endif

static PyObject *
PyvtkPVRenderViewDataDeliveryManager_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVRenderViewDataDeliveryManager::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVRenderViewDataDeliveryManager::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVRenderViewDataDeliveryManager *tempr = vtkPVRenderViewDataDeliveryManager::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVRenderViewDataDeliveryManager *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVRenderViewDataDeliveryManager::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVRenderViewDataDeliveryManager::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVRenderViewDataDeliveryManager::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetDeliverToAllProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeliverToAllProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  bool temp1 = false;
  bool temp2 = false;
  int temp3 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    if (ap.IsBound())
    {
      op->SetDeliverToAllProcesses(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetDeliverToAllProcesses(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetDeliverToClientAndRenderingProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeliverToClientAndRenderingProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  bool temp1 = false;
  bool temp2 = false;
  bool temp3 = false;
  int temp4 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4, 5) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    if (ap.IsBound())
    {
      op->SetDeliverToClientAndRenderingProcesses(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetDeliverToClientAndRenderingProcesses(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetRedistributionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRedistributionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  int temp1;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    if (ap.IsBound())
    {
      op->SetRedistributionMode(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetRedistributionMode(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetRedistributionModeToSplitBoundaryCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRedistributionModeToSplitBoundaryCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  int temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->SetRedistributionModeToSplitBoundaryCells(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetRedistributionModeToSplitBoundaryCells(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetRedistributionModeToDuplicateBoundaryCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRedistributionModeToDuplicateBoundaryCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  int temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->SetRedistributionModeToDuplicateBoundaryCells(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetRedistributionModeToDuplicateBoundaryCells(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetRedistributionModeToUniquelyAssignBoundaryCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRedistributionModeToUniquelyAssignBoundaryCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  int temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->SetRedistributionModeToUniquelyAssignBoundaryCells(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetRedistributionModeToUniquelyAssignBoundaryCells(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_RedistributeDataForOrderedCompositing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RedistributeDataForOrderedCompositing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RedistributeDataForOrderedCompositing(temp0);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::RedistributeDataForOrderedCompositing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_ClearRedistributedData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearRedistributedData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ClearRedistributedData(temp0);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::ClearRedistributedData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetOrderedCompositingConfiguration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrderedCompositingConfiguration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<double> store2(size2);
  double *temp2 = store2.Data();
  int temp3 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    if (ap.IsBound())
    {
      op->SetOrderedCompositingConfiguration(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetOrderedCompositingConfiguration(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetGeometryBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGeometryBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  const size_t size1 = 6;
  double temp1[6];
  vtkMatrix4x4 *temp2 = nullptr;
  int temp3 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 4) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetArray(temp1, size1) &&
      (ap.NoArgsLeft() || ap.GetVTKObject(temp2, "vtkMatrix4x4")) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    if (ap.IsBound())
    {
      op->SetGeometryBounds(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetGeometryBounds(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetGeometryBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGeometryBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  int temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkBoundingBox tempr = (ap.IsBound() ?
      op->GetGeometryBounds(temp0, temp1) :
      op->vtkPVRenderViewDataDeliveryManager::GetGeometryBounds(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkBoundingBox");
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetTransformedGeometryBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTransformedGeometryBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  int temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkBoundingBox tempr = (ap.IsBound() ?
      op->GetTransformedGeometryBounds(temp0, temp1) :
      op->vtkPVRenderViewDataDeliveryManager::GetTransformedGeometryBounds(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkBoundingBox");
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetStreamable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStreamable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  bool temp1 = false;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    if (ap.IsBound())
    {
      op->SetStreamable(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetStreamable(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetNextStreamedPiece(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNextStreamedPiece");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  vtkDataObject *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetVTKObject(temp1, "vtkDataObject") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    if (ap.IsBound())
    {
      op->SetNextStreamedPiece(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetNextStreamedPiece(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetCurrentStreamedPiece(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCurrentStreamedPiece");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  int temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetCurrentStreamedPiece(temp0, temp1) :
      op->vtkPVRenderViewDataDeliveryManager::GetCurrentStreamedPiece(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_ClearStreamedPieces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearStreamedPieces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearStreamedPieces();
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::ClearStreamedPieces();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_DeliverStreamedPieces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeliverStreamedPieces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  unsigned int temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned int> store1(2*size1);
  unsigned int *temp1 = store1.Data();
  unsigned int *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->DeliverStreamedPieces(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::DeliverStreamedPieces(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetRepresentationsReadyToStreamPieces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepresentationsReadyToStreamPieces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  std::vector<unsigned int> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRepresentationsReadyToStreamPieces(temp0) :
      op->vtkPVRenderViewDataDeliveryManager::GetRepresentationsReadyToStreamPieces(temp0));

    if (!ap.ErrorOccurred())
    {
      PyObject *vec = (temp0.empty() ?
        PyTuple_New(0) :
        vtkPythonArgs::BuildTuple(temp0.data(), temp0.size()));
      ap.SetContents(0, vec);
      Py_DECREF(vec);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetUseRedistributedDataAsDeliveredData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseRedistributedDataAsDeliveredData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseRedistributedDataAsDeliveredData() :
      op->vtkPVRenderViewDataDeliveryManager::GetUseRedistributedDataAsDeliveredData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_SetUseRedistributedDataAsDeliveredData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseRedistributedDataAsDeliveredData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseRedistributedDataAsDeliveredData(temp0);
    }
    else
    {
      op->vtkPVRenderViewDataDeliveryManager::SetUseRedistributedDataAsDeliveredData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetDeliveredDataKey(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeliveredDataKey");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDeliveredDataKey(temp0) :
      op->vtkPVRenderViewDataDeliveryManager::GetDeliveredDataKey(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetCutsMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCutsMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkTimeStamp tempr = (ap.IsBound() ?
      op->GetCutsMTime() :
      op->vtkPVRenderViewDataDeliveryManager::GetCutsMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTimeStamp");
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewDataDeliveryManager_GetRawCutsRankAssignments(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRawCutsRankAssignments");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewDataDeliveryManager *op = static_cast<vtkPVRenderViewDataDeliveryManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<int> *tempr = (ap.IsBound() ?
      &op->GetRawCutsRankAssignments() :
      &op->vtkPVRenderViewDataDeliveryManager::GetRawCutsRankAssignments());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}

static PyMethodDef PyvtkPVRenderViewDataDeliveryManager_Methods[] = {
  {"IsTypeOf", PyvtkPVRenderViewDataDeliveryManager_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVRenderViewDataDeliveryManager_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVRenderViewDataDeliveryManager_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkPVRenderViewDataDeliveryManager\nC++: static vtkPVRenderViewDataDeliveryManager *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVRenderViewDataDeliveryManager_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVRenderViewDataDeliveryManager\nC++: vtkPVRenderViewDataDeliveryManager *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVRenderViewDataDeliveryManager_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVRenderViewDataDeliveryManager_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetDeliverToAllProcesses", PyvtkPVRenderViewDataDeliveryManager_SetDeliverToAllProcesses, METH_VARARGS,
   "SetDeliverToAllProcesses(self, __a:vtkPVDataRepresentation,\n    flag:bool, low_res:bool, port:int=0) -> None\nC++: void SetDeliverToAllProcesses(vtkPVDataRepresentation *,\n    bool flag, bool low_res, int port=0)\n\nBy default, this class only delivers geometries to nodes that are\ndoing the rendering at a given stage. However, certain\nrepresentations, such as data-label representation, or cube-axes\nrepresentation, need to the geometry to be delivered to all nodes\nalways. That can be done by using this method (via\nvtkPVRenderView::SetDeliverToAllProcesses()).\n"},
  {"SetDeliverToClientAndRenderingProcesses", PyvtkPVRenderViewDataDeliveryManager_SetDeliverToClientAndRenderingProcesses, METH_VARARGS,
   "SetDeliverToClientAndRenderingProcesses(self,\n    __a:vtkPVDataRepresentation, deliver_to_client:bool,\n    gather_before_delivery:bool, low_res:bool, port:int=0) -> None\nC++: void SetDeliverToClientAndRenderingProcesses(\n    vtkPVDataRepresentation *, bool deliver_to_client,\n    bool gather_before_delivery, bool low_res, int port=0)\n\nBy default, this class only delivers geometries to nodes that are\ndoing the rendering at a given stage. However, certain\nrepresentations, such as text-source representation, need to the\ngeometry to be delivered to  the client as well.  That can be\ndone by using this method (via\nvtkPVRenderView::SetDeliverToAllProcesses()). The different\nbetween SetDeliverToAllProcesses() and this is that the former\ngather-and-scatters the data on the server nodes, while the\nlatter will optionally gather the data to deliver to the client\nand never scatter.\n"},
  {"SetRedistributionMode", PyvtkPVRenderViewDataDeliveryManager_SetRedistributionMode, METH_VARARGS,
   "SetRedistributionMode(self, __a:vtkPVDataRepresentation, mode:int,\n     port:int=0) -> None\nC++: void SetRedistributionMode(vtkPVDataRepresentation *,\n    int mode, int port=0)\n\nFor representations that have indicated that the data is\nredistributable (using SetOrderedCompositingConfiguration), this\ncontrol the mode for redistribution. Specifically, it indicates\nhow to handle cells that are on the boundary of the\nredistribution KdTree. Default is to split the cells, one can\nchange it to duplicate cells instead by using mode as\n`vtkDistributedDataFilter::ASSIGN_TO_ALL_INTERSECTING_REGIONS`.\n"},
  {"SetRedistributionModeToSplitBoundaryCells", PyvtkPVRenderViewDataDeliveryManager_SetRedistributionModeToSplitBoundaryCells, METH_VARARGS,
   "SetRedistributionModeToSplitBoundaryCells(self,\n    repr:vtkPVDataRepresentation, port:int=0) -> None\nC++: void SetRedistributionModeToSplitBoundaryCells(\n    vtkPVDataRepresentation *repr, int port=0)\n\n"},
  {"SetRedistributionModeToDuplicateBoundaryCells", PyvtkPVRenderViewDataDeliveryManager_SetRedistributionModeToDuplicateBoundaryCells, METH_VARARGS,
   "SetRedistributionModeToDuplicateBoundaryCells(self,\n    repr:vtkPVDataRepresentation, port:int=0) -> None\nC++: void SetRedistributionModeToDuplicateBoundaryCells(\n    vtkPVDataRepresentation *repr, int port=0)\n\n"},
  {"SetRedistributionModeToUniquelyAssignBoundaryCells", PyvtkPVRenderViewDataDeliveryManager_SetRedistributionModeToUniquelyAssignBoundaryCells, METH_VARARGS,
   "SetRedistributionModeToUniquelyAssignBoundaryCells(self,\n    repr:vtkPVDataRepresentation, port:int=0) -> None\nC++: void SetRedistributionModeToUniquelyAssignBoundaryCells(\n    vtkPVDataRepresentation *repr, int port=0)\n\n"},
  {"RedistributeDataForOrderedCompositing", PyvtkPVRenderViewDataDeliveryManager_RedistributeDataForOrderedCompositing, METH_VARARGS,
   "RedistributeDataForOrderedCompositing(self, use_lod:bool) -> None\nC++: void RedistributeDataForOrderedCompositing(bool use_lod)\n\nCalled by the view on every render when ordered compositing is to\nbe used to ensure that the geometries are redistributed, as\nneeded.\n"},
  {"ClearRedistributedData", PyvtkPVRenderViewDataDeliveryManager_ClearRedistributedData, METH_VARARGS,
   "ClearRedistributedData(self, use_load:bool) -> None\nC++: void ClearRedistributedData(bool use_load)\n\nRemoves all redistributed data that may have been redistributed\nfor ordered compositing earlier when using KdTree based\nredistribution.\n\nTODO: check is this is still needed.\n"},
  {"SetOrderedCompositingConfiguration", PyvtkPVRenderViewDataDeliveryManager_SetOrderedCompositingConfiguration, METH_VARARGS,
   "SetOrderedCompositingConfiguration(self,\n    repr:vtkPVDataRepresentation, config:int, bds:(float, ...),\n    port:int=0) -> None\nC++: void SetOrderedCompositingConfiguration(\n    vtkPVDataRepresentation *repr, int config, const double *bds,\n    int port=0)\n\nPass information how to handle data redistribution when using\nordered compositing.\n"},
  {"SetGeometryBounds", PyvtkPVRenderViewDataDeliveryManager_SetGeometryBounds, METH_VARARGS,
   "SetGeometryBounds(self, repr:vtkPVDataRepresentation, bds:(float,\n    float, float, float, float, float), matrix:vtkMatrix4x4=...,\n    port:int=0) -> None\nC++: void SetGeometryBounds(vtkPVDataRepresentation *repr,\n    const double bds[6], vtkMatrix4x4 *matrix=nullptr, int port=0)\n\nPass data bounds information.\n"},
  {"GetGeometryBounds", PyvtkPVRenderViewDataDeliveryManager_GetGeometryBounds, METH_VARARGS,
   "GetGeometryBounds(self, repr:vtkPVDataRepresentation, port:int=0)\n    -> vtkBoundingBox\nC++: vtkBoundingBox GetGeometryBounds(\n    vtkPVDataRepresentation *repr, int port=0)\n\n"},
  {"GetTransformedGeometryBounds", PyvtkPVRenderViewDataDeliveryManager_GetTransformedGeometryBounds, METH_VARARGS,
   "GetTransformedGeometryBounds(self, repr:vtkPVDataRepresentation,\n    port:int=0) -> vtkBoundingBox\nC++: vtkBoundingBox GetTransformedGeometryBounds(\n    vtkPVDataRepresentation *repr, int port=0)\n\n"},
  {"SetStreamable", PyvtkPVRenderViewDataDeliveryManager_SetStreamable, METH_VARARGS,
   "SetStreamable(self, __a:vtkPVDataRepresentation, __b:bool,\n    port:int=0) -> None\nC++: void SetStreamable(vtkPVDataRepresentation *, bool,\n    int port=0)\n\nMark a representation as streamable. Any representation can\nindicate that it is streamable i.e. the view can call streaming\npassses on it and it will deliver data incrementally.\n"},
  {"SetNextStreamedPiece", PyvtkPVRenderViewDataDeliveryManager_SetNextStreamedPiece, METH_VARARGS,
   "SetNextStreamedPiece(self, repr:vtkPVDataRepresentation,\n    piece:vtkDataObject, port:int=0) -> None\nC++: void SetNextStreamedPiece(vtkPVDataRepresentation *repr,\n    vtkDataObject *piece, int port=0)\n\nPasses the current streamed piece. This is the piece that will be\ndelivered to the rendering node.\n"},
  {"GetCurrentStreamedPiece", PyvtkPVRenderViewDataDeliveryManager_GetCurrentStreamedPiece, METH_VARARGS,
   "GetCurrentStreamedPiece(self, repr:vtkPVDataRepresentation,\n    port:int=0) -> vtkDataObject\nC++: vtkDataObject *GetCurrentStreamedPiece(\n    vtkPVDataRepresentation *repr, int port=0)\n\n"},
  {"ClearStreamedPieces", PyvtkPVRenderViewDataDeliveryManager_ClearStreamedPieces, METH_VARARGS,
   "ClearStreamedPieces(self) -> None\nC++: void ClearStreamedPieces()\n\n"},
  {"DeliverStreamedPieces", PyvtkPVRenderViewDataDeliveryManager_DeliverStreamedPieces, METH_VARARGS,
   "DeliverStreamedPieces(self, size:int, keys:[int, ...]) -> None\nC++: void DeliverStreamedPieces(unsigned int size,\n    unsigned int *keys)\n\nDeliver streamed pieces. Unlike regular data, streamed pieces are\ndelivered and released. Representations are expected to manage\nthe pieces once they are delivered to them.\n"},
  {"GetRepresentationsReadyToStreamPieces", PyvtkPVRenderViewDataDeliveryManager_GetRepresentationsReadyToStreamPieces, METH_VARARGS,
   "GetRepresentationsReadyToStreamPieces(self, keys:[int, ...])\n    -> bool\nC++: bool GetRepresentationsReadyToStreamPieces(\n    std::vector<unsigned int> &keys)\n\nFills up the vector with the keys for representations that have\nnon-null streaming pieces.\n"},
  {"GetUseRedistributedDataAsDeliveredData", PyvtkPVRenderViewDataDeliveryManager_GetUseRedistributedDataAsDeliveredData, METH_VARARGS,
   "GetUseRedistributedDataAsDeliveredData(self) -> bool\nC++: virtual bool GetUseRedistributedDataAsDeliveredData()\n\nWhen set to true GetDeliveredDataKey returns\n`REDISTRIBUTED_DATA_KEY` else returns the key returned by\nGetViewDataDistributionMode\n"},
  {"SetUseRedistributedDataAsDeliveredData", PyvtkPVRenderViewDataDeliveryManager_SetUseRedistributedDataAsDeliveredData, METH_VARARGS,
   "SetUseRedistributedDataAsDeliveredData(self, _arg:bool) -> None\nC++: virtual void SetUseRedistributedDataAsDeliveredData(\n    bool _arg)\n\n"},
  {"GetDeliveredDataKey", PyvtkPVRenderViewDataDeliveryManager_GetDeliveredDataKey, METH_VARARGS,
   "GetDeliveredDataKey(self, low_res:bool) -> int\nC++: int GetDeliveredDataKey(bool low_res) override;\n\nViews that support changing of which ranks do the rendering at\nruntime based on things like data sizes, etc. may override this\nmethod to provide a unique key for each different mode. This\nmakes it possible to keep delivered data object for each mode\nseparate and thus avoid transfers if the mode is changed on the\nfly.\n\nDefault implementation simply returns 0.\n"},
  {"GetCutsMTime", PyvtkPVRenderViewDataDeliveryManager_GetCutsMTime, METH_VARARGS,
   "GetCutsMTime(self) -> vtkTimeStamp\nC++: vtkTimeStamp GetCutsMTime()\n\n"},
  {"GetRawCutsRankAssignments", PyvtkPVRenderViewDataDeliveryManager_GetRawCutsRankAssignments, METH_VARARGS,
   "GetRawCutsRankAssignments(self) -> (int, ...)\nC++: const std::vector<int> &GetRawCutsRankAssignments()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVRenderViewDataDeliveryManager_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("use_redistributed_data_as_delivered_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewDataDeliveryManager_GetUseRedistributedDataAsDeliveredData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewDataDeliveryManager_SetUseRedistributedDataAsDeliveredData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewDataDeliveryManager_SetUseRedistributedDataAsDeliveredData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseRedistributedDataAsDeliveredData/SetUseRedistributedDataAsDeliveredData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cuts_m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewDataDeliveryManager_GetCutsMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCutsMTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("raw_cuts_rank_assignments"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewDataDeliveryManager_GetRawCutsRankAssignments(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRawCutsRankAssignments\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVRenderViewDataDeliveryManager_Doc =
  "vtkPVRenderViewDataDeliveryManager - vtkPVRenderView specific\nsubclass of vtkPVDataDeliveryManager.\n\n"
  "Superclass: vtkPVDataDeliveryManager\n\n"
  "This class adds vtkPVRenderView specific data movement logic to\n"
  "vtkPVDataDeliveryManager.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRenderViewDataDeliveryManager_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRenderViewDataDeliveryManager", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVRenderViewDataDeliveryManager_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVRenderViewDataDeliveryManager_StaticNew()
{
  return vtkPVRenderViewDataDeliveryManager::New();
}

PyObject *PyvtkPVRenderViewDataDeliveryManager_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVRenderViewDataDeliveryManager_Type, PyvtkPVRenderViewDataDeliveryManager_Methods,
    "vtkPVRenderViewDataDeliveryManager",
 &PyvtkPVRenderViewDataDeliveryManager_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVDataDeliveryManager_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVRenderViewDataDeliveryManager_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVRenderViewDataDeliveryManager(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVRenderViewDataDeliveryManager_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVRenderViewDataDeliveryManager", o) != 0)
  {
    Py_DECREF(o);
  }

}

