// ClientServer wrapper for vtkRedistributeDataSetFilter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkRedistributeDataSetFilter.h"
#include "vtkSystemIncludes.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkRedistributeDataSetFilterClientServerNewCommand(void* /*ctx*/)
{
  return vtkRedistributeDataSetFilter::New();
}


static int vtkRedistributeDataSetFilterCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkRedistributeDataSetFilter *op = vtkRedistributeDataSetFilter::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkRedistributeDataSetFilter.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkRedistributeDataSetFilter  *temp20;
      {
      temp20 = vtkRedistributeDataSetFilter::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkRedistributeDataSetFilter::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkRedistributeDataSetFilter  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkRedistributeDataSetFilter::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkRedistributeDataSetFilter  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkRedistributeDataSetFilter::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetMTime",method) && msg.GetNumberOfArguments(0) == 2)
    {
    unsigned long     temp20;
      {
      temp20 = (op)->GetMTime();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetController",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkMultiProcessController  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkMultiProcessController"))
      {
      op->SetController(temp0);
      return 1;
      }
    }
  if (!strcmp("GetController",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkMultiProcessController  *temp20;
      {
      temp20 = (op)->GetController();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetBoundaryMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetBoundaryMode(temp0);
      return 1;
      }
    }
  if (!strcmp("GetBoundaryModeMinValue",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetBoundaryModeMinValue();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetBoundaryModeMaxValue",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetBoundaryModeMaxValue();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetBoundaryMode",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetBoundaryMode();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetBoundaryModeToAssignToOneRegion",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetBoundaryModeToAssignToOneRegion();
      return 1;
      }
    }
  if (!strcmp("SetBoundaryModeToAssignToAllIntersectingRegions",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetBoundaryModeToAssignToAllIntersectingRegions();
      return 1;
      }
    }
  if (!strcmp("SetBoundaryModeToSplitBoundaryCells",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetBoundaryModeToSplitBoundaryCells();
      return 1;
      }
    }
  if (!strcmp("SetUseExplicitCuts",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetUseExplicitCuts(temp0);
      return 1;
      }
    }
  if (!strcmp("GetUseExplicitCuts",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetUseExplicitCuts();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("UseExplicitCutsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->UseExplicitCutsOn();
      return 1;
      }
    }
  if (!strcmp("UseExplicitCutsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->UseExplicitCutsOff();
      return 1;
      }
    }
  if (!strcmp("RemoveAllExplicitCuts",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveAllExplicitCuts();
      return 1;
      }
    }
  if (!strcmp("AddExplicitCut",method) && msg.GetNumberOfArguments(0) == 3)
    {
    double temp0[6];
    if(msg.GetArgument(0, 2, temp0, 6))
      {
      op->AddExplicitCut(temp0);
      return 1;
      }
    }
  if (!strcmp("GetNumberOfExplicitCuts",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetNumberOfExplicitCuts();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetExpandExplicitCuts",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetExpandExplicitCuts(temp0);
      return 1;
      }
    }
  if (!strcmp("GetExpandExplicitCuts",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetExpandExplicitCuts();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ExpandExplicitCutsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExpandExplicitCutsOn();
      return 1;
      }
    }
  if (!strcmp("ExpandExplicitCutsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExpandExplicitCutsOff();
      return 1;
      }
    }
  if (!strcmp("SetNumberOfPartitions",method) && msg.GetNumberOfArguments(0) == 3)
    {
    long long   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetNumberOfPartitions(temp0);
      return 1;
      }
    }
  if (!strcmp("GetNumberOfPartitions",method) && msg.GetNumberOfArguments(0) == 2)
    {
    long long   temp20;
      {
      temp20 = (op)->GetNumberOfPartitions();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetPreservePartitionsInOutput",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetPreservePartitionsInOutput(temp0);
      return 1;
      }
    }
  if (!strcmp("GetPreservePartitionsInOutput",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetPreservePartitionsInOutput();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("PreservePartitionsInOutputOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PreservePartitionsInOutputOn();
      return 1;
      }
    }
  if (!strcmp("PreservePartitionsInOutputOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PreservePartitionsInOutputOff();
      return 1;
      }
    }
  if (!strcmp("SetGenerateGlobalCellIds",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetGenerateGlobalCellIds(temp0);
      return 1;
      }
    }
  if (!strcmp("GetGenerateGlobalCellIds",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetGenerateGlobalCellIds();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GenerateGlobalCellIdsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->GenerateGlobalCellIdsOn();
      return 1;
      }
    }
  if (!strcmp("GenerateGlobalCellIdsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->GenerateGlobalCellIdsOff();
      return 1;
      }
    }
  if (!strcmp("SetEnableDebugging",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetEnableDebugging(temp0);
      return 1;
      }
    }
  if (!strcmp("GetEnableDebugging",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetEnableDebugging();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("EnableDebuggingOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->EnableDebuggingOn();
      return 1;
      }
    }
  if (!strcmp("EnableDebuggingOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->EnableDebuggingOff();
      return 1;
      }
    }
  if (!strcmp("SetLoadBalanceAcrossAllBlocks",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetLoadBalanceAcrossAllBlocks(temp0);
      return 1;
      }
    }
  if (!strcmp("GetLoadBalanceAcrossAllBlocks",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetLoadBalanceAcrossAllBlocks();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("LoadBalanceAcrossAllBlocksOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LoadBalanceAcrossAllBlocksOn();
      return 1;
      }
    }
  if (!strcmp("LoadBalanceAcrossAllBlocksOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LoadBalanceAcrossAllBlocksOff();
      return 1;
      }
    }
  if (!strcmp("GetStrategy",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkPartitioningStrategy  *temp20;
      {
      temp20 = (op)->GetStrategy();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetStrategy",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkPartitioningStrategy  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPartitioningStrategy"))
      {
      op->SetStrategy(temp0);
      return 1;
      }
    }

  {
    const char* commandName = "vtkDataObjectAlgorithm";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkRedistributeDataSetFilter, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkRedistributeDataSetFilter_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkRedistributeDataSetFilter", vtkRedistributeDataSetFilterClientServerNewCommand);
    csi->AddCommandFunction("vtkRedistributeDataSetFilter", vtkRedistributeDataSetFilterCommand);
    }
}
}
