#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkBilinearQuadIntersection_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCardinalSpline_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkKochanekSpline_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricBohemianDome_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricBour_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricBoy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricCatalanMinimal_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricConicSpiral_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricCrossCap_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricDini_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricEllipsoid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricEnneper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricFigure8Klein_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricFunction_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricHenneberg_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricKlein_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricKuen_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricMobius_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricPluckerConoid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricPseudosphere_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricRandomHills_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricRoman_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricSpline_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricSuperEllipsoid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricSuperToroid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParametricTorus_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkCommonComputationalGeometryCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkBilinearQuadIntersection_Init(csi);
  vtkCardinalSpline_Init(csi);
  vtkKochanekSpline_Init(csi);
  vtkParametricBohemianDome_Init(csi);
  vtkParametricBour_Init(csi);
  vtkParametricBoy_Init(csi);
  vtkParametricCatalanMinimal_Init(csi);
  vtkParametricConicSpiral_Init(csi);
  vtkParametricCrossCap_Init(csi);
  vtkParametricDini_Init(csi);
  vtkParametricEllipsoid_Init(csi);
  vtkParametricEnneper_Init(csi);
  vtkParametricFigure8Klein_Init(csi);
  vtkParametricFunction_Init(csi);
  vtkParametricHenneberg_Init(csi);
  vtkParametricKlein_Init(csi);
  vtkParametricKuen_Init(csi);
  vtkParametricMobius_Init(csi);
  vtkParametricPluckerConoid_Init(csi);
  vtkParametricPseudosphere_Init(csi);
  vtkParametricRandomHills_Init(csi);
  vtkParametricRoman_Init(csi);
  vtkParametricSpline_Init(csi);
  vtkParametricSuperEllipsoid_Init(csi);
  vtkParametricSuperToroid_Init(csi);
  vtkParametricTorus_Init(csi);
}
