/* FlatpakFile.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FlatpakFile.vala, do not modify */

/*
* Copyright 2021-2022 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <flatpak.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDELOAD_TYPE_FLATPAK_FILE (sideload_flatpak_file_get_type ())
#define SIDELOAD_FLATPAK_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFile))
#define SIDELOAD_FLATPAK_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFileClass))
#define SIDELOAD_IS_FLATPAK_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_FLATPAK_FILE))
#define SIDELOAD_IS_FLATPAK_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_FLATPAK_FILE))
#define SIDELOAD_FLATPAK_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFileClass))

typedef struct _SideloadFlatpakFile SideloadFlatpakFile;
typedef struct _SideloadFlatpakFileClass SideloadFlatpakFileClass;
typedef struct _SideloadFlatpakFilePrivate SideloadFlatpakFilePrivate;
typedef enum  {
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DEVICES = 1 << 0,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_FULL = 1 << 1,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_READ = 1 << 2,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_ESCAPE_SANDBOX = 1 << 3,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_FULL = 1 << 4,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_OTHER = 1 << 5,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_READ = 1 << 6,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_FULL = 1 << 7,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_READ = 1 << 8,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NETWORK = 1 << 9,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NONE = 1 << 10,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SESSION_BUS = 1 << 11,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SETTINGS = 1 << 12,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SYSTEM_BUS = 1 << 13,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_UNKNOWN = 1 << 14,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_X11 = 1 << 15
} SideloadFlatpakFilePermissionsFlags;

#define SIDELOAD_FLATPAK_FILE_TYPE_PERMISSIONS_FLAGS (sideload_flatpak_file_permissions_flags_get_type ())
enum  {
	SIDELOAD_FLATPAK_FILE_0_PROPERTY,
	SIDELOAD_FLATPAK_FILE_FILE_PROPERTY,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_PROPERTY,
	SIDELOAD_FLATPAK_FILE_SIZE_PROPERTY,
	SIDELOAD_FLATPAK_FILE_ALREADY_INSTALLED_PROPERTY,
	SIDELOAD_FLATPAK_FILE_EXTRA_REMOTES_NEEDED_PROPERTY,
	SIDELOAD_FLATPAK_FILE_NUM_PROPERTIES
};
static GParamSpec* sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _xmlXPathFreeObject0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeObject (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _SideloadFlatpakFileRunTransactionAsyncData SideloadFlatpakFileRunTransactionAsyncData;
enum  {
	SIDELOAD_FLATPAK_FILE_PROGRESS_CHANGED_SIGNAL,
	SIDELOAD_FLATPAK_FILE_INSTALLATION_FAILED_SIGNAL,
	SIDELOAD_FLATPAK_FILE_INSTALLATION_SUCCEEDED_SIGNAL,
	SIDELOAD_FLATPAK_FILE_DETAILS_READY_SIGNAL,
	SIDELOAD_FLATPAK_FILE_NUM_SIGNALS
};
static guint sideload_flatpak_file_signals[SIDELOAD_FLATPAK_FILE_NUM_SIGNALS] = {0};

struct _SideloadFlatpakFile {
	GObject parent_instance;
	SideloadFlatpakFilePrivate * priv;
	gchar* appdata_name;
	gint error_code;
	gchar* error_message;
};

struct _SideloadFlatpakFileClass {
	GObjectClass parent_class;
	void (*get_id) (SideloadFlatpakFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*get_id_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
	void (*get_name) (SideloadFlatpakFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*get_name_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
	void (*get_details) (SideloadFlatpakFile* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_details_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
	void (*install) (SideloadFlatpakFile* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_, GError** error);
	void (*launch) (SideloadFlatpakFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*launch_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
};

struct _SideloadFlatpakFilePrivate {
	GFile* _file;
	SideloadFlatpakFilePermissionsFlags _permissions_flags;
	gchar* _size;
	gboolean _already_installed;
	gboolean _extra_remotes_needed;
};

struct _Block5Data {
	int _ref_count_;
	SideloadFlatpakFile* self;
	FlatpakTransaction* transaction;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _SideloadFlatpakFileRunTransactionAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SideloadFlatpakFile* self;
	FlatpakTransaction* transaction;
	GCancellable* cancellable;
	Block5Data* _data5_;
	GThread* _tmp0_;
	GThread* _tmp1_;
	const gchar* _tmp2_;
};

static gint SideloadFlatpakFile_private_offset;
static gpointer sideload_flatpak_file_parent_class = NULL;
VALA_EXTERN FlatpakInstallation* sideload_flatpak_file_installation;
FlatpakInstallation* sideload_flatpak_file_installation = NULL;

VALA_EXTERN GType sideload_flatpak_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadFlatpakFile, g_object_unref)
VALA_EXTERN GType sideload_flatpak_file_permissions_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sideload_flatpak_file_get_id (SideloadFlatpakFile* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gchar* sideload_flatpak_file_get_id_finish (SideloadFlatpakFile* self,
                                            GAsyncResult* _res_);
VALA_EXTERN void sideload_flatpak_file_get_name (SideloadFlatpakFile* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN gchar* sideload_flatpak_file_get_name_finish (SideloadFlatpakFile* self,
                                              GAsyncResult* _res_);
VALA_EXTERN void sideload_flatpak_file_get_details (SideloadFlatpakFile* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_get_details_finish (SideloadFlatpakFile* self,
                                               GAsyncResult* _res_);
VALA_EXTERN void sideload_flatpak_file_install (SideloadFlatpakFile* self,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_install_finish (SideloadFlatpakFile* self,
                                           GAsyncResult* _res_,
                                           GError** error);
VALA_EXTERN void sideload_flatpak_file_launch (SideloadFlatpakFile* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_launch_finish (SideloadFlatpakFile* self,
                                          GAsyncResult* _res_);
VALA_EXTERN gboolean sideload_flatpak_file_parse_xml (SideloadFlatpakFile* self,
                                          GFile* appstream_file,
                                          const gchar* id);
static void sideload_flatpak_file_run_transaction_async_data_free (gpointer _data);
VALA_EXTERN void sideload_flatpak_file_run_transaction_async (SideloadFlatpakFile* self,
                                                  FlatpakTransaction* transaction,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_run_transaction_finish (SideloadFlatpakFile* self,
                                                   GAsyncResult* _res_);
static gboolean sideload_flatpak_file_run_transaction_async_co (SideloadFlatpakFileRunTransactionAsyncData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void* __lambda4_ (Block5Data* _data5_);
static gboolean _sideload_flatpak_file_run_transaction_async_co_gsource_func (gpointer self);
static gpointer ___lambda4__gthread_func (gpointer self);
VALA_EXTERN gboolean sideload_flatpak_file_on_operation_error (SideloadFlatpakFile* self,
                                                   FlatpakTransactionOperation* op,
                                                   GError* e,
                                                   FlatpakTransactionErrorDetails details);
static gboolean __lambda5_ (SideloadFlatpakFile* self);
static gboolean ___lambda5__gsource_func (gpointer self);
VALA_EXTERN SideloadFlatpakFile* sideload_flatpak_file_construct (GType object_type);
VALA_EXTERN GFile* sideload_flatpak_file_get_file (SideloadFlatpakFile* self);
static void sideload_flatpak_file_set_file (SideloadFlatpakFile* self,
                                     GFile* value);
VALA_EXTERN SideloadFlatpakFilePermissionsFlags sideload_flatpak_file_get_permissions_flags (SideloadFlatpakFile* self);
VALA_EXTERN void sideload_flatpak_file_set_permissions_flags (SideloadFlatpakFile* self,
                                                  SideloadFlatpakFilePermissionsFlags value);
VALA_EXTERN const gchar* sideload_flatpak_file_get_size (SideloadFlatpakFile* self);
VALA_EXTERN void sideload_flatpak_file_set_size (SideloadFlatpakFile* self,
                                     const gchar* value);
VALA_EXTERN gboolean sideload_flatpak_file_get_already_installed (SideloadFlatpakFile* self);
VALA_EXTERN void sideload_flatpak_file_set_already_installed (SideloadFlatpakFile* self,
                                                  gboolean value);
VALA_EXTERN gboolean sideload_flatpak_file_get_extra_remotes_needed (SideloadFlatpakFile* self);
VALA_EXTERN void sideload_flatpak_file_set_extra_remotes_needed (SideloadFlatpakFile* self,
                                                     gboolean value);
static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void sideload_flatpak_file_finalize (GObject * obj);
static GType sideload_flatpak_file_get_type_once (void);
static void _vala_sideload_flatpak_file_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_sideload_flatpak_file_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
sideload_flatpak_file_get_instance_private (SideloadFlatpakFile* self)
{
	return G_STRUCT_MEMBER_P (self, SideloadFlatpakFile_private_offset);
}

static GType
sideload_flatpak_file_permissions_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DEVICES, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DEVICES", "devices"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_FULL, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_FULL", "downloads-full"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_READ, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_READ", "downloads-read"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_ESCAPE_SANDBOX, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_ESCAPE_SANDBOX", "escape-sandbox"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_FULL, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_FULL", "filesystem-full"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_OTHER, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_OTHER", "filesystem-other"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_READ, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_READ", "filesystem-read"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_FULL, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_FULL", "home-full"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_READ, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_READ", "home-read"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NETWORK, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NETWORK", "network"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NONE, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NONE", "none"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SESSION_BUS, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SESSION_BUS", "session-bus"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SETTINGS, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SETTINGS", "settings"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SYSTEM_BUS, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SYSTEM_BUS", "system-bus"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_UNKNOWN, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_UNKNOWN", "unknown"}, {SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_X11, "SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_X11", "x11"}, {0, NULL, NULL}};
	GType sideload_flatpak_file_permissions_flags_type_id;
	sideload_flatpak_file_permissions_flags_type_id = g_flags_register_static ("SideloadFlatpakFilePermissionsFlags", values);
	return sideload_flatpak_file_permissions_flags_type_id;
}

GType
sideload_flatpak_file_permissions_flags_get_type (void)
{
	static volatile gsize sideload_flatpak_file_permissions_flags_type_id__once = 0;
	if (g_once_init_enter (&sideload_flatpak_file_permissions_flags_type_id__once)) {
		GType sideload_flatpak_file_permissions_flags_type_id;
		sideload_flatpak_file_permissions_flags_type_id = sideload_flatpak_file_permissions_flags_get_type_once ();
		g_once_init_leave (&sideload_flatpak_file_permissions_flags_type_id__once, sideload_flatpak_file_permissions_flags_type_id);
	}
	return sideload_flatpak_file_permissions_flags_type_id__once;
}

void
sideload_flatpak_file_get_id (SideloadFlatpakFile* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->get_id) {
		_klass_->get_id (self, _callback_, _user_data_);
	}
}

gchar*
sideload_flatpak_file_get_id_finish (SideloadFlatpakFile* self,
                                     GAsyncResult* _res_)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->get_id_finish) {
		return _klass_->get_id_finish (self, _res_);
	}
	return NULL;
}

void
sideload_flatpak_file_get_name (SideloadFlatpakFile* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->get_name) {
		_klass_->get_name (self, _callback_, _user_data_);
	}
}

gchar*
sideload_flatpak_file_get_name_finish (SideloadFlatpakFile* self,
                                       GAsyncResult* _res_)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->get_name_finish) {
		return _klass_->get_name_finish (self, _res_);
	}
	return NULL;
}

void
sideload_flatpak_file_get_details (SideloadFlatpakFile* self,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->get_details) {
		_klass_->get_details (self, cancellable, _callback_, _user_data_);
	}
}

void
sideload_flatpak_file_get_details_finish (SideloadFlatpakFile* self,
                                          GAsyncResult* _res_)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->get_details_finish) {
		_klass_->get_details_finish (self, _res_);
	}
}

void
sideload_flatpak_file_install (SideloadFlatpakFile* self,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->install) {
		_klass_->install (self, cancellable, _callback_, _user_data_);
	}
}

void
sideload_flatpak_file_install_finish (SideloadFlatpakFile* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->install_finish) {
		_klass_->install_finish (self, _res_, error);
	}
}

void
sideload_flatpak_file_launch (SideloadFlatpakFile* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->launch) {
		_klass_->launch (self, _callback_, _user_data_);
	}
}

void
sideload_flatpak_file_launch_finish (SideloadFlatpakFile* self,
                                     GAsyncResult* _res_)
{
	SideloadFlatpakFileClass* _klass_;
	_klass_ = SIDELOAD_FLATPAK_FILE_GET_CLASS (self);
	if (_klass_->launch_finish) {
		_klass_->launch_finish (self, _res_);
	}
}

gboolean
sideload_flatpak_file_parse_xml (SideloadFlatpakFile* self,
                                 GFile* appstream_file,
                                 const gchar* id)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	xmlDoc* doc = NULL;
	const gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlXPathContext* cntx = NULL;
	xmlDoc* _tmp5_;
	xmlXPathContext* _tmp6_;
	gchar* xpath = NULL;
	gchar* _tmp7_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp8_;
	const gchar* _tmp9_;
	xmlXPathObject* _tmp10_;
	xmlXPathObject* _tmp11_;
	gboolean _tmp13_ = FALSE;
	xmlXPathObject* _tmp14_;
	xmlNode* node = NULL;
	xmlXPathObject* _tmp19_;
	xmlNodeSet* _tmp20_;
	xmlNode* _tmp21_;
	xmlXPathObject* _tmp38_;
	xmlDoc* _tmp39_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (appstream_file != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = g_file_get_path (appstream_file);
	path = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = xmlParseFile (_tmp1_);
	doc = _tmp2_;
	_tmp3_ = doc;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		_tmp4_ = path;
		g_warning ("FlatpakFile.vala:82: Appstream XML file %s not found or permissions mi" \
"ssing", _tmp4_);
		result = FALSE;
		_g_free0 (path);
		return result;
	}
	_tmp5_ = doc;
	_tmp6_ = xmlXPathNewContext (_tmp5_);
	cntx = _tmp6_;
	_tmp7_ = g_strdup_printf ("/components/component/id[text()='%s']/parent::component", id);
	xpath = _tmp7_;
	_tmp8_ = cntx;
	_tmp9_ = xpath;
	_tmp10_ = xmlXPathEvalExpression ((xmlChar*) _tmp9_, _tmp8_);
	res = _tmp10_;
	_tmp11_ = res;
	if (_tmp11_ == NULL) {
		xmlDoc* _tmp12_;
		_tmp12_ = doc;
		_xmlFreeDoc0 (_tmp12_);
		result = FALSE;
		_g_free0 (xpath);
		_xmlXPathFreeContext0 (cntx);
		_g_free0 (path);
		return result;
	}
	_tmp14_ = res;
	if (_tmp14_->type != XPATH_NODESET) {
		_tmp13_ = TRUE;
	} else {
		xmlXPathObject* _tmp15_;
		xmlNodeSet* _tmp16_;
		_tmp15_ = res;
		_tmp16_ = _tmp15_->nodesetval;
		_tmp13_ = _tmp16_ == NULL;
	}
	if (_tmp13_) {
		xmlXPathObject* _tmp17_;
		xmlDoc* _tmp18_;
		_tmp17_ = res;
		_xmlXPathFreeObject0 (_tmp17_);
		_tmp18_ = doc;
		_xmlFreeDoc0 (_tmp18_);
		result = FALSE;
		_g_free0 (xpath);
		_xmlXPathFreeContext0 (cntx);
		_g_free0 (path);
		return result;
	}
	_tmp19_ = res;
	_tmp20_ = _tmp19_->nodesetval;
	_tmp21_ = xmlXPathNodeSetItem (_tmp20_, 0);
	node = _tmp21_;
	{
		xmlNode* iter = NULL;
		xmlNode* _tmp22_;
		xmlNode* _tmp23_;
		_tmp22_ = node;
		_tmp23_ = _tmp22_->children;
		iter = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp27_;
				xmlNode* _tmp28_;
				if (!_tmp24_) {
					xmlNode* _tmp25_;
					xmlNode* _tmp26_;
					_tmp25_ = iter;
					_tmp26_ = _tmp25_->next;
					iter = _tmp26_;
				}
				_tmp24_ = FALSE;
				_tmp27_ = iter;
				if (!(_tmp27_ != NULL)) {
					break;
				}
				_tmp28_ = iter;
				if (_tmp28_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					GQuark _tmp33_ = 0U;
					static GQuark _tmp32_label0 = 0;
					_tmp29_ = iter;
					_tmp30_ = _tmp29_->name;
					_tmp31_ = _tmp30_;
					_tmp33_ = (NULL == _tmp31_) ? 0 : g_quark_from_string (_tmp31_);
					if (_tmp33_ == ((0 != _tmp32_label0) ? _tmp32_label0 : (_tmp32_label0 = g_quark_from_static_string ("name")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp34_;
								xmlAttr* _tmp35_;
								_tmp34_ = iter;
								_tmp35_ = xmlHasProp (_tmp34_, (xmlChar*) "lang");
								if (_tmp35_ == NULL) {
									xmlNode* _tmp36_;
									gchar* _tmp37_;
									_tmp36_ = iter;
									_tmp37_ = (gchar*) xmlNodeGetContent (_tmp36_);
									_g_free0 (self->appdata_name);
									self->appdata_name = _tmp37_;
								}
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								break;
							}
						}
					}
				}
			}
		}
	}
	_tmp38_ = res;
	_xmlXPathFreeObject0 (_tmp38_);
	_tmp39_ = doc;
	_xmlFreeDoc0 (_tmp39_);
	result = TRUE;
	_g_free0 (xpath);
	_xmlXPathFreeContext0 (cntx);
	_g_free0 (path);
	return result;
}

static void
sideload_flatpak_file_run_transaction_async_data_free (gpointer _data)
{
	SideloadFlatpakFileRunTransactionAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SideloadFlatpakFileRunTransactionAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
sideload_flatpak_file_run_transaction_async (SideloadFlatpakFile* self,
                                             FlatpakTransaction* transaction,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	SideloadFlatpakFileRunTransactionAsyncData* _data_;
	SideloadFlatpakFile* _tmp0_;
	FlatpakTransaction* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transaction != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (SideloadFlatpakFileRunTransactionAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sideload_flatpak_file_run_transaction_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (transaction);
	_g_object_unref0 (_data_->transaction);
	_data_->transaction = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	sideload_flatpak_file_run_transaction_async_co (_data_);
}

void
sideload_flatpak_file_run_transaction_finish (SideloadFlatpakFile* self,
                                              GAsyncResult* _res_)
{
	SideloadFlatpakFileRunTransactionAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SideloadFlatpakFile* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->transaction);
		_g_object_unref0 (_data5_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
_sideload_flatpak_file_run_transaction_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = sideload_flatpak_file_run_transaction_async_co (self);
	return result;
}

static void*
__lambda4_ (Block5Data* _data5_)
{
	SideloadFlatpakFile* self;
	GError* _inner_error0_ = NULL;
	void* result;
	self = _data5_->self;
	{
		flatpak_transaction_run (_data5_->transaction, _data5_->cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		self->error_code = _tmp0_->code;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (self->error_message);
		self->error_message = _tmp3_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _sideload_flatpak_file_run_transaction_async_co_gsource_func, _data5_->_async_data_, NULL);
	result = NULL;
	return result;
}

static gpointer
___lambda4__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda4_ (self);
	block5_data_unref (self);
	return result;
}

static gboolean
sideload_flatpak_file_run_transaction_async_co (SideloadFlatpakFileRunTransactionAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data5_->transaction);
	_data_->_data5_->transaction = _data_->transaction;
	_g_object_unref0 (_data_->_data5_->cancellable);
	_data_->_data5_->cancellable = _data_->cancellable;
	_data_->_data5_->_async_data_ = _data_;
	_data_->self->error_code = -1;
	_data_->_tmp0_ = g_thread_new ("install-flatpak", ___lambda4__gthread_func, block5_data_ref (_data_->_data5_));
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_thread_unref0 (_data_->_tmp1_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (_data_->self->error_code >= 0) {
		_data_->_tmp2_ = _data_->self->error_message;
		g_signal_emit (_data_->self, sideload_flatpak_file_signals[SIDELOAD_FLATPAK_FILE_INSTALLATION_FAILED_SIGNAL], 0, _data_->self->error_code, _data_->_tmp2_);
	} else {
		g_signal_emit (_data_->self, sideload_flatpak_file_signals[SIDELOAD_FLATPAK_FILE_INSTALLATION_SUCCEEDED_SIGNAL], 0);
	}
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
__lambda5_ (SideloadFlatpakFile* self)
{
	const gchar* _tmp0_;
	gboolean result;
	_tmp0_ = self->error_message;
	g_signal_emit (self, sideload_flatpak_file_signals[SIDELOAD_FLATPAK_FILE_INSTALLATION_FAILED_SIGNAL], 0, self->error_code, _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((SideloadFlatpakFile*) self);
	return result;
}

gboolean
sideload_flatpak_file_on_operation_error (SideloadFlatpakFile* self,
                                          FlatpakTransactionOperation* op,
                                          GError* e,
                                          FlatpakTransactionErrorDetails details)
{
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (op != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if ((details & FLATPAK_TRANSACTION_ERROR_DETAILS_NON_FATAL) == FLATPAK_TRANSACTION_ERROR_DETAILS_NON_FATAL) {
		const gchar* _tmp0_;
		_tmp0_ = e->message;
		g_warning ("FlatpakFile.vala:149: transaction warning: %s", _tmp0_);
		result = TRUE;
		return result;
	}
	self->error_code = e->code;
	_tmp1_ = e->message;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->error_message);
	self->error_message = _tmp2_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	result = FALSE;
	return result;
}

SideloadFlatpakFile*
sideload_flatpak_file_construct (GType object_type)
{
	SideloadFlatpakFile * self = NULL;
	self = (SideloadFlatpakFile*) g_object_new (object_type, NULL);
	return self;
}

GFile*
sideload_flatpak_file_get_file (SideloadFlatpakFile* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
sideload_flatpak_file_set_file (SideloadFlatpakFile* self,
                                GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_flatpak_file_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_FILE_PROPERTY]);
	}
}

SideloadFlatpakFilePermissionsFlags
sideload_flatpak_file_get_permissions_flags (SideloadFlatpakFile* self)
{
	SideloadFlatpakFilePermissionsFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_permissions_flags;
	return result;
}

void
sideload_flatpak_file_set_permissions_flags (SideloadFlatpakFile* self,
                                             SideloadFlatpakFilePermissionsFlags value)
{
	SideloadFlatpakFilePermissionsFlags old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_flatpak_file_get_permissions_flags (self);
	if (old_value != value) {
		self->priv->_permissions_flags = value;
		g_object_notify_by_pspec ((GObject *) self, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_PROPERTY]);
	}
}

const gchar*
sideload_flatpak_file_get_size (SideloadFlatpakFile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}

void
sideload_flatpak_file_set_size (SideloadFlatpakFile* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_flatpak_file_get_size (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_size);
		self->priv->_size = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_SIZE_PROPERTY]);
	}
}

gboolean
sideload_flatpak_file_get_already_installed (SideloadFlatpakFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_already_installed;
	return result;
}

void
sideload_flatpak_file_set_already_installed (SideloadFlatpakFile* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_flatpak_file_get_already_installed (self);
	if (old_value != value) {
		self->priv->_already_installed = value;
		g_object_notify_by_pspec ((GObject *) self, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_ALREADY_INSTALLED_PROPERTY]);
	}
}

gboolean
sideload_flatpak_file_get_extra_remotes_needed (SideloadFlatpakFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_extra_remotes_needed;
	return result;
}

void
sideload_flatpak_file_set_extra_remotes_needed (SideloadFlatpakFile* self,
                                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_flatpak_file_get_extra_remotes_needed (self);
	if (old_value != value) {
		self->priv->_extra_remotes_needed = value;
		g_object_notify_by_pspec ((GObject *) self, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_EXTRA_REMOTES_NEEDED_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_DOUBLE) (gpointer data1, const char* arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_double (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
sideload_flatpak_file_class_init (SideloadFlatpakFileClass * klass,
                                  gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	sideload_flatpak_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SideloadFlatpakFile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sideload_flatpak_file_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sideload_flatpak_file_set_property;
	G_OBJECT_CLASS (klass)->finalize = sideload_flatpak_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_FLATPAK_FILE_FILE_PROPERTY, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_PROPERTY, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_PROPERTY] = g_param_spec_flags ("permissions-flags", "permissions-flags", "permissions-flags", SIDELOAD_FLATPAK_FILE_TYPE_PERMISSIONS_FLAGS, SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_FLATPAK_FILE_SIZE_PROPERTY, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_SIZE_PROPERTY] = g_param_spec_string ("size", "size", "size", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_FLATPAK_FILE_ALREADY_INSTALLED_PROPERTY, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_ALREADY_INSTALLED_PROPERTY] = g_param_spec_boolean ("already-installed", "already-installed", "already-installed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_FLATPAK_FILE_EXTRA_REMOTES_NEEDED_PROPERTY, sideload_flatpak_file_properties[SIDELOAD_FLATPAK_FILE_EXTRA_REMOTES_NEEDED_PROPERTY] = g_param_spec_boolean ("extra-remotes-needed", "extra-remotes-needed", "extra-remotes-needed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	sideload_flatpak_file_signals[SIDELOAD_FLATPAK_FILE_PROGRESS_CHANGED_SIGNAL] = g_signal_new ("progress-changed", SIDELOAD_TYPE_FLATPAK_FILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_DOUBLE, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_DOUBLE);
	sideload_flatpak_file_signals[SIDELOAD_FLATPAK_FILE_INSTALLATION_FAILED_SIGNAL] = g_signal_new ("installation-failed", SIDELOAD_TYPE_FLATPAK_FILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
	sideload_flatpak_file_signals[SIDELOAD_FLATPAK_FILE_INSTALLATION_SUCCEEDED_SIGNAL] = g_signal_new ("installation-succeeded", SIDELOAD_TYPE_FLATPAK_FILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sideload_flatpak_file_signals[SIDELOAD_FLATPAK_FILE_DETAILS_READY_SIGNAL] = g_signal_new ("details-ready", SIDELOAD_TYPE_FLATPAK_FILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	{
		FlatpakInstallation* _tmp0_ = NULL;
		FlatpakInstallation* _tmp1_;
		FlatpakInstallation* _tmp2_;
		_tmp1_ = flatpak_installation_new_user (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (sideload_flatpak_file_installation);
		sideload_flatpak_file_installation = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("FlatpakFile.vala:64: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
sideload_flatpak_file_instance_init (SideloadFlatpakFile * self,
                                     gpointer klass)
{
	gchar* _tmp0_;
	self->priv = sideload_flatpak_file_get_instance_private (self);
	self->priv->_permissions_flags = SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_UNKNOWN;
	self->priv->_size = NULL;
	self->priv->_already_installed = FALSE;
	self->priv->_extra_remotes_needed = FALSE;
	self->appdata_name = NULL;
	self->error_code = -1;
	_tmp0_ = g_strdup ("");
	self->error_message = _tmp0_;
}

static void
sideload_flatpak_file_finalize (GObject * obj)
{
	SideloadFlatpakFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFile);
	_g_object_unref0 (self->priv->_file);
	_g_free0 (self->priv->_size);
	_g_free0 (self->appdata_name);
	_g_free0 (self->error_message);
	G_OBJECT_CLASS (sideload_flatpak_file_parent_class)->finalize (obj);
}

static GType
sideload_flatpak_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SideloadFlatpakFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sideload_flatpak_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SideloadFlatpakFile), 0, (GInstanceInitFunc) sideload_flatpak_file_instance_init, NULL };
	GType sideload_flatpak_file_type_id;
	sideload_flatpak_file_type_id = g_type_register_static (G_TYPE_OBJECT, "SideloadFlatpakFile", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SideloadFlatpakFile_private_offset = g_type_add_instance_private (sideload_flatpak_file_type_id, sizeof (SideloadFlatpakFilePrivate));
	return sideload_flatpak_file_type_id;
}

GType
sideload_flatpak_file_get_type (void)
{
	static volatile gsize sideload_flatpak_file_type_id__once = 0;
	if (g_once_init_enter (&sideload_flatpak_file_type_id__once)) {
		GType sideload_flatpak_file_type_id;
		sideload_flatpak_file_type_id = sideload_flatpak_file_get_type_once ();
		g_once_init_leave (&sideload_flatpak_file_type_id__once, sideload_flatpak_file_type_id);
	}
	return sideload_flatpak_file_type_id__once;
}

static void
_vala_sideload_flatpak_file_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SideloadFlatpakFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFile);
	switch (property_id) {
		case SIDELOAD_FLATPAK_FILE_FILE_PROPERTY:
		g_value_set_object (value, sideload_flatpak_file_get_file (self));
		break;
		case SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_PROPERTY:
		g_value_set_flags (value, sideload_flatpak_file_get_permissions_flags (self));
		break;
		case SIDELOAD_FLATPAK_FILE_SIZE_PROPERTY:
		g_value_set_string (value, sideload_flatpak_file_get_size (self));
		break;
		case SIDELOAD_FLATPAK_FILE_ALREADY_INSTALLED_PROPERTY:
		g_value_set_boolean (value, sideload_flatpak_file_get_already_installed (self));
		break;
		case SIDELOAD_FLATPAK_FILE_EXTRA_REMOTES_NEEDED_PROPERTY:
		g_value_set_boolean (value, sideload_flatpak_file_get_extra_remotes_needed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sideload_flatpak_file_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SideloadFlatpakFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFile);
	switch (property_id) {
		case SIDELOAD_FLATPAK_FILE_FILE_PROPERTY:
		sideload_flatpak_file_set_file (self, g_value_get_object (value));
		break;
		case SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_PROPERTY:
		sideload_flatpak_file_set_permissions_flags (self, g_value_get_flags (value));
		break;
		case SIDELOAD_FLATPAK_FILE_SIZE_PROPERTY:
		sideload_flatpak_file_set_size (self, g_value_get_string (value));
		break;
		case SIDELOAD_FLATPAK_FILE_ALREADY_INSTALLED_PROPERTY:
		sideload_flatpak_file_set_already_installed (self, g_value_get_boolean (value));
		break;
		case SIDELOAD_FLATPAK_FILE_EXTRA_REMOTES_NEEDED_PROPERTY:
		sideload_flatpak_file_set_extra_remotes_needed (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

