/* CheckerboardLayout.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CheckerboardLayout.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <granite.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <gobject/gvaluecollector.h>

#define CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH 1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW (checkerboard_layout_layout_row_get_type ())
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))

typedef struct _CheckerboardLayoutLayoutRow CheckerboardLayoutLayoutRow;
typedef struct _CheckerboardLayoutLayoutRowClass CheckerboardLayoutLayoutRowClass;
enum  {
	CHECKERBOARD_LAYOUT_0_PROPERTY,
	CHECKERBOARD_LAYOUT_NUM_PROPERTIES
};
static GParamSpec* checkerboard_layout_properties[CHECKERBOARD_LAYOUT_NUM_PROPERTIES];
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _CheckerboardLayoutLayoutRowPrivate CheckerboardLayoutLayoutRowPrivate;
#define _checkerboard_layout_layout_row_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_layout_layout_row_unref (var), NULL)))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
typedef struct _CheckerboardLayoutParamSpecLayoutRow CheckerboardLayoutParamSpecLayoutRow;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CheckerboardLayoutPrivate {
	ViewCollection* view;
	gchar* page_name;
	CheckerboardLayoutLayoutRow** item_rows;
	gint item_rows_length1;
	gint _item_rows_size_;
	GeeHashSet* exposed_items;
	GtkAdjustment* hadjustment;
	GtkAdjustment* vadjustment;
	gchar* message;
	GdkRectangle visible_page;
	gint last_width;
	gint columns;
	gint rows;
	GdkPoint drag_origin;
	GdkPoint drag_endpoint;
	GdkRectangle selection_band;
	gint scale;
	gboolean flow_scheduled;
	gboolean exposure_dirty;
	CheckerboardItem* anchor;
	gboolean in_center_on_anchor;
	gboolean size_allocate_due_to_reflow;
	gboolean is_in_view;
	gboolean reflow_needed;
};

struct _CheckerboardLayoutLayoutRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardLayoutLayoutRowPrivate * priv;
	gint y;
	gint height;
	CheckerboardItem** items;
	gint items_length1;
	gint _items_size_;
};

struct _CheckerboardLayoutLayoutRowClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardLayoutLayoutRow *self);
};

struct _CheckerboardLayoutParamSpecLayoutRow {
	GParamSpec parent_instance;
};

static gint CheckerboardLayout_private_offset;
static gpointer checkerboard_layout_parent_class = NULL;
static gpointer checkerboard_layout_layout_row_parent_class = NULL;

static gpointer checkerboard_layout_layout_row_ref (gpointer instance);
static void checkerboard_layout_layout_row_unref (gpointer instance);
static GParamSpec* checkerboard_layout_param_spec_layout_row (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void checkerboard_layout_value_set_layout_row (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static void checkerboard_layout_value_take_layout_row (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer checkerboard_layout_value_get_layout_row (const GValue* value) G_GNUC_UNUSED ;
static GType checkerboard_layout_layout_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void checkerboard_layout_on_contents_altered (CheckerboardLayout* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
static void _checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                                GeeIterable* added,
                                                                                GeeIterable* removed,
                                                                                gpointer self);
static void checkerboard_layout_on_items_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender,
                                                                          GeeMap* items,
                                                                          gpointer self);
static void checkerboard_layout_on_items_state_changed (CheckerboardLayout* self,
                                                 GeeIterable* changed);
static void _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                                      GeeIterable* changed,
                                                                                      gpointer self);
static void checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self,
                                                      GeeIterable* changed);
static void _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                                                GeeCollection* changed,
                                                                                                gpointer self);
static void checkerboard_layout_on_ordering_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender,
                                                                                gpointer self);
static void checkerboard_layout_on_views_altered (CheckerboardLayout* self,
                                           GeeCollection* altered);
static void _checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender,
                                                                          GeeCollection* views,
                                                                          gpointer self);
static void checkerboard_layout_on_geometries_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender,
                                                                                    GeeCollection* views,
                                                                                    gpointer self);
static void checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender,
                                                                                     GeeIterable* selected,
                                                                                     gpointer self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender,
                                                                                       GeeIterable* unselected,
                                                                                       gpointer self);
static void checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                            gpointer self);
static void checkerboard_layout_on_viewport_resized (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                        GtkAllocation* allocation,
                                                                        gpointer self);
static void checkerboard_layout_viewport_resized (CheckerboardLayout* self);
static void checkerboard_layout_clear_anchor (CheckerboardLayout* self);
static void checkerboard_layout_update_visible_page (CheckerboardLayout* self);
static void checkerboard_layout_need_exposure (CheckerboardLayout* self,
                                        const gchar* caller);
static void checkerboard_layout_update_anchor (CheckerboardLayout* self);
static void checkerboard_layout_center_on_anchor (CheckerboardLayout* self,
                                           gdouble upper);
static void checkerboard_layout_need_reflow (CheckerboardLayout* self,
                                      const gchar* caller);
static void checkerboard_layout_items_dirty (CheckerboardLayout* self,
                                      const gchar* reason,
                                      GeeIterable* items);
static gboolean checkerboard_layout_do_reflow (CheckerboardLayout* self);
static gboolean _checkerboard_layout_do_reflow_gsource_func (gpointer self);
static void checkerboard_layout_reflow (CheckerboardLayout* self,
                                 const gchar* caller);
static void checkerboard_layout_unexpose_items (CheckerboardLayout* self,
                                         const gchar* caller);
static void checkerboard_layout_expose_items (CheckerboardLayout* self,
                                       const gchar* caller);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_new (gint y,
                                                                 gint height,
                                                                 gint num_in_row);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_construct (GType object_type,
                                                                       gint y,
                                                                       gint height,
                                                                       gint num_in_row);
static void checkerboard_layout_real_size_allocate (GtkWidget* base,
                                             GtkAllocation* allocation);
static gboolean checkerboard_layout_real_draw (GtkWidget* base,
                                        cairo_t* ctx);
static void checkerboard_layout_draw_selection_band (CheckerboardLayout* self,
                                              cairo_t* ctx);
static gboolean checkerboard_layout_real_query_tooltip (GtkWidget* base,
                                                 gint x,
                                                 gint y,
                                                 gboolean keyboard_mode,
                                                 GtkTooltip* tooltip);
static gboolean checkerboard_layout_real_focus_in_event (GtkWidget* base,
                                                  GdkEventFocus* event);
static gboolean checkerboard_layout_real_focus_out_event (GtkWidget* base,
                                                   GdkEventFocus* event);
static void checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow * obj);
static GType checkerboard_layout_layout_row_get_type_once (void);
static void checkerboard_layout_finalize (GObject * obj);
static GType checkerboard_layout_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
checkerboard_layout_get_instance_private (CheckerboardLayout* self)
{
	return G_STRUCT_MEMBER_P (self, CheckerboardLayout_private_offset);
}

static void
_checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                           GeeIterable* added,
                                                                           GeeIterable* removed,
                                                                           gpointer self)
{
	checkerboard_layout_on_contents_altered ((CheckerboardLayout*) self, added, removed);
}

static void
_checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender,
                                                                     GeeMap* items,
                                                                     gpointer self)
{
	checkerboard_layout_on_items_altered ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                                 GeeIterable* changed,
                                                                                 gpointer self)
{
	checkerboard_layout_on_items_state_changed ((CheckerboardLayout*) self, changed);
}

static void
_checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                                           GeeCollection* changed,
                                                                                           gpointer self)
{
	checkerboard_layout_on_items_visibility_changed ((CheckerboardLayout*) self, changed);
}

static void
_checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender,
                                                                           gpointer self)
{
	checkerboard_layout_on_ordering_changed ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender,
                                                                     GeeCollection* views,
                                                                     gpointer self)
{
	checkerboard_layout_on_views_altered ((CheckerboardLayout*) self, views);
}

static void
_checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender,
                                                                               GeeCollection* views,
                                                                               gpointer self)
{
	checkerboard_layout_on_geometries_altered ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender,
                                                                                GeeIterable* selected,
                                                                                gpointer self)
{
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender,
                                                                                  GeeIterable* unselected,
                                                                                  gpointer self)
{
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                       gpointer self)
{
	checkerboard_layout_on_viewport_shifted ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                   GtkAllocation* allocation,
                                                                   gpointer self)
{
	checkerboard_layout_on_viewport_resized ((CheckerboardLayout*) self);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

CheckerboardLayout*
checkerboard_layout_construct (GType object_type,
                               ViewCollection* view)
{
	CheckerboardLayout * self = NULL;
	ViewCollection* _tmp0_;
	g_return_val_if_fail (view != NULL, NULL);
	self = (CheckerboardLayout*) g_object_new (object_type, NULL);
	_tmp0_ = _data_collection_ref0 (view);
	_data_collection_unref0 (self->priv->view);
	self->priv->view = _tmp0_;
	checkerboard_layout_clear_drag_select (self);
	g_signal_connect_object ((DataCollection*) view, "contents-altered", (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self, 0);
	g_signal_connect_object ((DataCollection*) view, "items-altered", (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self, 0);
	g_signal_connect_object (view, "items-state-changed", (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self, 0);
	g_signal_connect_object (view, "items-visibility-changed", (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self, 0);
	g_signal_connect_object ((DataCollection*) view, "ordering-changed", (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self, 0);
	g_signal_connect_object (view, "views-altered", (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self, 0);
	g_signal_connect_object (view, "geometries-altered", (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self, 0);
	g_signal_connect_object (view, "items-selected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self, 0);
	g_signal_connect_object (view, "items-unselected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self, 0);
	gtk_widget_set_has_tooltip ((GtkWidget*) self, TRUE);
	return self;
}

CheckerboardLayout*
checkerboard_layout_new (ViewCollection* view)
{
	return checkerboard_layout_construct (TYPE_CHECKERBOARD_LAYOUT, view);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
checkerboard_layout_set_adjustments (CheckerboardLayout* self,
                                     GtkAdjustment* hadjustment,
                                     GtkAdjustment* vadjustment)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hadjustment != NULL);
	g_return_if_fail (vadjustment != NULL);
	_tmp0_ = _g_object_ref0 (hadjustment);
	_g_object_unref0 (self->priv->hadjustment);
	self->priv->hadjustment = _tmp0_;
	_tmp1_ = _g_object_ref0 (vadjustment);
	_g_object_unref0 (self->priv->vadjustment);
	self->priv->vadjustment = _tmp1_;
	g_signal_connect_object (hadjustment, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
	g_signal_connect_object (vadjustment, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
	_tmp2_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp3_ = _tmp2_;
	g_signal_connect_object ((GtkWidget*) _tmp3_, "size-allocate", (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self, 0);
}

void
checkerboard_layout_set_scale (CheckerboardLayout* self,
                               gint scale)
{
	g_return_if_fail (self != NULL);
	self->priv->scale = scale;
}

gint
checkerboard_layout_get_scale (CheckerboardLayout* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->scale;
	return result;
}

void
checkerboard_layout_set_name (CheckerboardLayout* self,
                              const gchar* name)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->page_name);
	self->priv->page_name = _tmp0_;
}

static void
checkerboard_layout_on_viewport_resized (CheckerboardLayout* self)
{
	GtkRequisition req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkAllocation parent_allocation = {0};
	GtkContainer* _tmp1_;
	GtkContainer* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	gtk_widget_get_preferred_size ((GtkWidget*) self, NULL, &_tmp0_);
	req = _tmp0_;
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) _tmp2_, &_tmp3_);
	parent_allocation = _tmp3_;
	_tmp4_ = self->priv->message;
	if (_tmp4_ == NULL) {
		GtkAllocation _tmp5_;
		GtkRequisition _tmp6_;
		_tmp5_ = parent_allocation;
		_tmp6_ = req;
		gtk_widget_set_size_request ((GtkWidget*) self, _tmp5_.width - CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH, _tmp6_.height);
	} else {
		GtkAllocation _tmp7_;
		GtkAllocation _tmp8_;
		_tmp7_ = parent_allocation;
		_tmp8_ = parent_allocation;
		gtk_widget_set_size_request ((GtkWidget*) self, _tmp7_.width, _tmp8_.height);
	}
	checkerboard_layout_viewport_resized (self);
	if (!self->priv->size_allocate_due_to_reflow) {
		checkerboard_layout_clear_anchor (self);
	} else {
		self->priv->size_allocate_due_to_reflow = FALSE;
	}
}

static void
checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self)
{
	g_return_if_fail (self != NULL);
	checkerboard_layout_update_visible_page (self);
	checkerboard_layout_need_exposure (self, "on_viewport_shift");
	checkerboard_layout_clear_anchor (self);
}

static void
checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self)
{
	g_return_if_fail (self != NULL);
	checkerboard_layout_clear_anchor (self);
}

static void
checkerboard_layout_clear_anchor (CheckerboardLayout* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->in_center_on_anchor) {
		return;
	}
	_g_object_unref0 (self->priv->anchor);
	self->priv->anchor = NULL;
}

static void
checkerboard_layout_update_anchor (CheckerboardLayout* self)
{
	GeeList* items_on_page = NULL;
	GdkRectangle _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkAdjustment* _tmp16_;
	GeeList* _tmp17_;
	GeeList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_;
	g_return_if_fail (self != NULL);
	_vala_assert (!self->priv->in_center_on_anchor, "!in_center_on_anchor");
	_tmp0_ = self->priv->visible_page;
	_tmp1_ = checkerboard_layout_intersection (self, &_tmp0_);
	items_on_page = _tmp1_;
	_tmp2_ = items_on_page;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		_g_object_unref0 (self->priv->anchor);
		self->priv->anchor = NULL;
		_g_object_unref0 (items_on_page);
		return;
	}
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp5_;
		gint _item_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _item_index = 0;
		_tmp5_ = items_on_page;
		_item_list = _tmp5_;
		_tmp6_ = _item_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_item_size = _tmp8_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			CheckerboardItem* _tmp13_;
			_item_index = _item_index + 1;
			_tmp9_ = _item_index;
			_tmp10_ = _item_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _item_list;
			_tmp12_ = gee_list_get (_tmp11_, _item_index);
			item = (CheckerboardItem*) _tmp12_;
			_tmp13_ = item;
			if (data_view_is_selected ((DataView*) _tmp13_)) {
				CheckerboardItem* _tmp14_;
				CheckerboardItem* _tmp15_;
				_tmp14_ = item;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				_g_object_unref0 (self->priv->anchor);
				self->priv->anchor = _tmp15_;
				_g_object_unref0 (item);
				_g_object_unref0 (items_on_page);
				return;
			}
			_g_object_unref0 (item);
		}
	}
	_tmp16_ = self->priv->vadjustment;
	if (gtk_adjustment_get_value (_tmp16_) == ((gdouble) 0)) {
		_g_object_unref0 (self->priv->anchor);
		self->priv->anchor = NULL;
		_g_object_unref0 (items_on_page);
		return;
	}
	_tmp17_ = items_on_page;
	_tmp18_ = items_on_page;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_list_get (_tmp17_, ((gint) _tmp20_) / 2);
	_g_object_unref0 (self->priv->anchor);
	self->priv->anchor = (CheckerboardItem*) _tmp21_;
	_g_object_unref0 (items_on_page);
}

static void
checkerboard_layout_center_on_anchor (CheckerboardLayout* self,
                                      gdouble upper)
{
	CheckerboardItem* _tmp0_;
	gdouble anchor_pos = 0.0;
	CheckerboardItem* _tmp1_;
	GdkRectangle _tmp2_;
	CheckerboardItem* _tmp3_;
	GdkRectangle _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->anchor;
	if (_tmp0_ == NULL) {
		return;
	}
	self->priv->in_center_on_anchor = TRUE;
	_tmp1_ = self->priv->anchor;
	_tmp2_ = _tmp1_->allocation;
	_tmp3_ = self->priv->anchor;
	_tmp4_ = _tmp3_->allocation;
	_tmp5_ = self->priv->vadjustment;
	anchor_pos = (_tmp2_.y + (_tmp4_.height / 2)) - (gtk_adjustment_get_page_size (_tmp5_) / 2);
	_tmp6_ = self->priv->vadjustment;
	_tmp7_ = self->priv->vadjustment;
	_tmp8_ = self->priv->vadjustment;
	_tmp9_ = self->priv->vadjustment;
	gtk_adjustment_set_value (_tmp6_, CLAMP (anchor_pos, gtk_adjustment_get_lower (_tmp7_), gtk_adjustment_get_upper (_tmp8_) - gtk_adjustment_get_page_size (_tmp9_)));
	self->priv->in_center_on_anchor = FALSE;
}

static void
checkerboard_layout_on_contents_altered (CheckerboardLayout* self,
                                         GeeIterable* added,
                                         GeeIterable* removed)
{
	g_return_if_fail (self != NULL);
	if (added != NULL) {
		_g_free0 (self->priv->message);
		self->priv->message = NULL;
	}
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (removed);
			_object_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				GeeHashSet* _tmp4_;
				DataObject* _tmp5_;
				_tmp1_ = _object_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _object_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				object = (DataObject*) _tmp3_;
				_tmp4_ = self->priv->exposed_items;
				_tmp5_ = object;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
	self->priv->item_rows = NULL;
	self->priv->item_rows_length1 = 0;
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
	checkerboard_layout_need_reflow (self, "on_contents_altered");
}

static void
checkerboard_layout_on_items_altered (CheckerboardLayout* self)
{
	g_return_if_fail (self != NULL);
	checkerboard_layout_need_reflow (self, "on_items_altered");
}

static void
checkerboard_layout_on_items_state_changed (CheckerboardLayout* self,
                                            GeeIterable* changed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed != NULL);
	checkerboard_layout_items_dirty (self, "on_items_state_changed", changed);
}

static void
checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self,
                                                 GeeIterable* changed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed != NULL);
	checkerboard_layout_need_reflow (self, "on_items_visibility_changed");
}

static void
checkerboard_layout_on_ordering_changed (CheckerboardLayout* self)
{
	g_return_if_fail (self != NULL);
	checkerboard_layout_need_reflow (self, "on_ordering_changed");
}

static void
checkerboard_layout_on_views_altered (CheckerboardLayout* self,
                                      GeeCollection* altered)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (altered != NULL);
	checkerboard_layout_items_dirty (self, "on_views_altered", (GeeIterable*) altered);
}

static void
checkerboard_layout_on_geometries_altered (CheckerboardLayout* self)
{
	g_return_if_fail (self != NULL);
	checkerboard_layout_need_reflow (self, "on_geometries_altered");
}

static gboolean
_checkerboard_layout_do_reflow_gsource_func (gpointer self)
{
	gboolean result;
	result = checkerboard_layout_do_reflow ((CheckerboardLayout*) self);
	return result;
}

static void
checkerboard_layout_need_reflow (CheckerboardLayout* self,
                                 const gchar* caller)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (caller != NULL);
	if (self->priv->flow_scheduled) {
		return;
	}
	if (!self->priv->is_in_view) {
		self->priv->reflow_needed = TRUE;
		return;
	}
	self->priv->flow_scheduled = TRUE;
	g_idle_add_full (G_PRIORITY_HIGH, _checkerboard_layout_do_reflow_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
checkerboard_layout_do_reflow (CheckerboardLayout* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	checkerboard_layout_reflow (self, "do_reflow");
	checkerboard_layout_need_exposure (self, "do_reflow");
	self->priv->flow_scheduled = FALSE;
	result = FALSE;
	return result;
}

static void
checkerboard_layout_need_exposure (CheckerboardLayout* self,
                                   const gchar* caller)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (caller != NULL);
	self->priv->exposure_dirty = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
checkerboard_layout_set_message (CheckerboardLayout* self,
                                 const gchar* text)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->message;
	if (g_strcmp0 (text, _tmp0_) == 0) {
		return;
	}
	_tmp1_ = g_strdup (text);
	_g_free0 (self->priv->message);
	self->priv->message = _tmp1_;
	if (text != NULL) {
		GtkContainer* _tmp2_;
		GtkContainer* _tmp3_;
		_tmp2_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			GtkAllocation parent_allocation = {0};
			GtkContainer* _tmp4_;
			GtkContainer* _tmp5_;
			GtkAllocation _tmp6_ = {0};
			GtkAllocation _tmp7_;
			GtkAllocation _tmp8_;
			_tmp4_ = gtk_widget_get_parent ((GtkWidget*) self);
			_tmp5_ = _tmp4_;
			gtk_widget_get_allocation ((GtkWidget*) _tmp5_, &_tmp6_);
			parent_allocation = _tmp6_;
			_tmp7_ = parent_allocation;
			_tmp8_ = parent_allocation;
			gtk_widget_set_size_request ((GtkWidget*) self, _tmp7_.width, _tmp8_.height);
		}
	} else {
		checkerboard_layout_need_reflow (self, "set_message");
	}
}

void
checkerboard_layout_unset_message (CheckerboardLayout* self)
{
	g_return_if_fail (self != NULL);
	checkerboard_layout_set_message (self, NULL);
}

static void
checkerboard_layout_update_visible_page (CheckerboardLayout* self)
{
	gboolean _tmp0_ = FALSE;
	GtkAdjustment* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->hadjustment;
	if (_tmp1_ != NULL) {
		GtkAdjustment* _tmp2_;
		_tmp2_ = self->priv->vadjustment;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		GdkRectangle _tmp5_ = {0};
		_tmp3_ = self->priv->hadjustment;
		_tmp4_ = self->priv->vadjustment;
		get_adjustment_page (_tmp3_, _tmp4_, &_tmp5_);
		self->priv->visible_page = _tmp5_;
	}
}

void
checkerboard_layout_set_in_view (CheckerboardLayout* self,
                                 gboolean in_view)
{
	g_return_if_fail (self != NULL);
	self->priv->is_in_view = in_view;
	if (in_view) {
		if (self->priv->reflow_needed) {
			checkerboard_layout_need_reflow (self, "set_in_view (true)");
		} else {
			checkerboard_layout_need_exposure (self, "set_in_view (true)");
		}
	} else {
		checkerboard_layout_unexpose_items (self, "set_in_view (false)");
	}
}

static gpointer
_checkerboard_layout_layout_row_ref0 (gpointer self)
{
	return self ? checkerboard_layout_layout_row_ref (self) : NULL;
}

CheckerboardItem*
checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self,
                                       gdouble xd,
                                       gdouble yd)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gint x = 0;
	gint y = 0;
	CheckerboardLayoutLayoutRow* in_range = NULL;
	gint min = 0;
	gint max = 0;
	CheckerboardLayoutLayoutRow** _tmp3_;
	gint _tmp3__length1;
	CheckerboardLayoutLayoutRow* _tmp15_;
	CheckerboardLayoutLayoutRow* _tmp16_;
	CheckerboardItem** _tmp17_;
	gint _tmp17__length1;
	CheckerboardItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->message;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		CheckerboardLayoutLayoutRow** _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->priv->item_rows;
		_tmp2__length1 = self->priv->item_rows_length1;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	x = (gint) xd;
	y = (gint) yd;
	in_range = NULL;
	min = 0;
	_tmp3_ = self->priv->item_rows;
	_tmp3__length1 = self->priv->item_rows_length1;
	max = _tmp3__length1;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			gint mid = 0;
			CheckerboardLayoutLayoutRow* row = NULL;
			CheckerboardLayoutLayoutRow** _tmp5_;
			gint _tmp5__length1;
			CheckerboardLayoutLayoutRow* _tmp6_;
			CheckerboardLayoutLayoutRow* _tmp7_;
			gboolean _tmp8_ = FALSE;
			CheckerboardLayoutLayoutRow* _tmp9_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			mid = min + ((max - min) / 2);
			_tmp5_ = self->priv->item_rows;
			_tmp5__length1 = self->priv->item_rows_length1;
			_tmp6_ = _tmp5_[mid];
			_tmp7_ = _checkerboard_layout_layout_row_ref0 (_tmp6_);
			row = _tmp7_;
			_tmp9_ = row;
			if (_tmp9_ == NULL) {
				_tmp8_ = TRUE;
			} else {
				CheckerboardLayoutLayoutRow* _tmp10_;
				_tmp10_ = row;
				_tmp8_ = y < _tmp10_->y;
			}
			if (_tmp8_) {
				max = mid - 1;
			} else {
				CheckerboardLayoutLayoutRow* _tmp11_;
				CheckerboardLayoutLayoutRow* _tmp12_;
				_tmp11_ = row;
				_tmp12_ = row;
				if (y > (_tmp11_->y + _tmp12_->height)) {
					min = mid + 1;
				} else {
					CheckerboardLayoutLayoutRow* _tmp13_;
					CheckerboardLayoutLayoutRow* _tmp14_;
					_tmp13_ = row;
					_tmp14_ = _checkerboard_layout_layout_row_ref0 (_tmp13_);
					_checkerboard_layout_layout_row_unref0 (in_range);
					in_range = _tmp14_;
					_checkerboard_layout_layout_row_unref0 (row);
					break;
				}
			}
			if (min > max) {
				_checkerboard_layout_layout_row_unref0 (row);
				break;
			}
			_checkerboard_layout_layout_row_unref0 (row);
		}
	}
	_tmp15_ = in_range;
	if (_tmp15_ == NULL) {
		result = NULL;
		_checkerboard_layout_layout_row_unref0 (in_range);
		return result;
	}
	_tmp16_ = in_range;
	_tmp17_ = _tmp16_->items;
	_tmp17__length1 = _tmp16_->items_length1;
	{
		CheckerboardItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp17_;
		item_collection_length1 = _tmp17__length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			CheckerboardItem* _tmp18_;
			CheckerboardItem* item = NULL;
			_tmp18_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp18_;
			{
				CheckerboardItem* _tmp19_;
				CheckerboardItem* _tmp20_;
				GdkRectangle _tmp21_;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				CheckerboardItem* _tmp24_;
				GdkRectangle _tmp25_;
				CheckerboardItem* _tmp26_;
				GdkRectangle _tmp27_;
				_tmp19_ = item;
				if (_tmp19_ == NULL) {
					_g_object_unref0 (item);
					continue;
				}
				_tmp20_ = item;
				_tmp21_ = _tmp20_->allocation;
				if (x < _tmp21_.x) {
					_g_object_unref0 (item);
					break;
				}
				_tmp24_ = item;
				_tmp25_ = _tmp24_->allocation;
				_tmp26_ = item;
				_tmp27_ = _tmp26_->allocation;
				if (x <= (_tmp25_.x + _tmp27_.width)) {
					CheckerboardItem* _tmp28_;
					GdkRectangle _tmp29_;
					_tmp28_ = item;
					_tmp29_ = _tmp28_->allocation;
					_tmp23_ = y >= _tmp29_.y;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					CheckerboardItem* _tmp30_;
					GdkRectangle _tmp31_;
					CheckerboardItem* _tmp32_;
					GdkRectangle _tmp33_;
					_tmp30_ = item;
					_tmp31_ = _tmp30_->allocation;
					_tmp32_ = item;
					_tmp33_ = _tmp32_->allocation;
					_tmp22_ = y <= (_tmp31_.y + _tmp33_.height);
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					result = item;
					_checkerboard_layout_layout_row_unref0 (in_range);
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = NULL;
	_checkerboard_layout_layout_row_unref0 (in_range);
	return result;
}

GeeList*
checkerboard_layout_get_visible_items (CheckerboardLayout* self)
{
	GdkRectangle _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->visible_page;
	_tmp1_ = checkerboard_layout_intersection (self, &_tmp0_);
	result = _tmp1_;
	return result;
}

GeeList*
checkerboard_layout_intersection (CheckerboardLayout* self,
                                  GdkRectangle* area)
{
	GeeArrayList* intersects = NULL;
	GeeArrayList* _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GdkRectangle bitbucket = {0};
	CheckerboardLayoutLayoutRow** _tmp2_;
	gint _tmp2__length1;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (area != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	intersects = _tmp0_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
	allocation = _tmp1_;
	memset (&bitbucket, 0, sizeof (GdkRectangle));
	_tmp2_ = self->priv->item_rows;
	_tmp2__length1 = self->priv->item_rows_length1;
	{
		CheckerboardLayoutLayoutRow** row_collection = NULL;
		gint row_collection_length1 = 0;
		gint _row_collection_size_ = 0;
		gint row_it = 0;
		row_collection = _tmp2_;
		row_collection_length1 = _tmp2__length1;
		for (row_it = 0; row_it < row_collection_length1; row_it = row_it + 1) {
			CheckerboardLayoutLayoutRow* _tmp3_;
			CheckerboardLayoutLayoutRow* row = NULL;
			_tmp3_ = _checkerboard_layout_layout_row_ref0 (row_collection[row_it]);
			row = _tmp3_;
			{
				CheckerboardLayoutLayoutRow* _tmp4_;
				GdkRectangle _tmp5_;
				GdkRectangle _tmp6_;
				CheckerboardLayoutLayoutRow* _tmp7_;
				CheckerboardLayoutLayoutRow* _tmp8_;
				CheckerboardLayoutLayoutRow* _tmp9_;
				GdkRectangle _tmp10_;
				GdkRectangle row_rect = {0};
				CheckerboardLayoutLayoutRow* _tmp11_;
				GtkAllocation _tmp12_;
				CheckerboardLayoutLayoutRow* _tmp13_;
				GdkRectangle _tmp14_;
				GdkRectangle _tmp15_ = {0};
				gboolean _tmp16_;
				_tmp4_ = row;
				if (_tmp4_ == NULL) {
					_checkerboard_layout_layout_row_unref0 (row);
					continue;
				}
				_tmp5_ = *area;
				_tmp6_ = *area;
				_tmp7_ = row;
				if ((_tmp5_.y + _tmp6_.height) < _tmp7_->y) {
					_checkerboard_layout_layout_row_unref0 (row);
					break;
				}
				_tmp8_ = row;
				_tmp9_ = row;
				_tmp10_ = *area;
				if ((_tmp8_->y + _tmp9_->height) < _tmp10_.y) {
					_checkerboard_layout_layout_row_unref0 (row);
					continue;
				}
				memset (&row_rect, 0, sizeof (GdkRectangle));
				row_rect.x = 0;
				_tmp11_ = row;
				row_rect.y = _tmp11_->y;
				_tmp12_ = allocation;
				row_rect.width = _tmp12_.width;
				_tmp13_ = row;
				row_rect.height = _tmp13_->height;
				_tmp14_ = row_rect;
				_tmp16_ = gdk_rectangle_intersect (area, &_tmp14_, &_tmp15_);
				bitbucket = _tmp15_;
				if (_tmp16_) {
					CheckerboardLayoutLayoutRow* _tmp17_;
					CheckerboardItem** _tmp18_;
					gint _tmp18__length1;
					_tmp17_ = row;
					_tmp18_ = _tmp17_->items;
					_tmp18__length1 = _tmp17_->items_length1;
					{
						CheckerboardItem** item_collection = NULL;
						gint item_collection_length1 = 0;
						gint _item_collection_size_ = 0;
						gint item_it = 0;
						item_collection = _tmp18_;
						item_collection_length1 = _tmp18__length1;
						for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
							CheckerboardItem* _tmp19_;
							CheckerboardItem* item = NULL;
							_tmp19_ = _g_object_ref0 (item_collection[item_it]);
							item = _tmp19_;
							{
								CheckerboardItem* _tmp20_;
								CheckerboardItem* _tmp21_;
								GdkRectangle _tmp22_;
								GdkRectangle _tmp23_ = {0};
								gboolean _tmp24_;
								_tmp20_ = item;
								if (_tmp20_ == NULL) {
									_g_object_unref0 (item);
									continue;
								}
								_tmp21_ = item;
								_tmp22_ = _tmp21_->allocation;
								_tmp24_ = gdk_rectangle_intersect (area, &_tmp22_, &_tmp23_);
								bitbucket = _tmp23_;
								if (_tmp24_) {
									GeeArrayList* _tmp25_;
									CheckerboardItem* _tmp26_;
									_tmp25_ = intersects;
									_tmp26_ = item;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
								}
								_g_object_unref0 (item);
							}
						}
					}
				}
				_checkerboard_layout_layout_row_unref0 (row);
			}
		}
	}
	result = (GeeList*) intersects;
	return result;
}

CheckerboardItem*
checkerboard_layout_get_item_relative_to (CheckerboardLayout* self,
                                          CheckerboardItem* item,
                                          GtkDirectionType direction)
{
	ViewCollection* _tmp0_;
	gint col = 0;
	gint row = 0;
	gboolean _tmp1_ = FALSE;
	CheckerboardItem* new_item = NULL;
	CheckerboardItem* _tmp13_;
	gboolean _tmp14_ = FALSE;
	CheckerboardItem* _tmp15_;
	CheckerboardItem* _tmp19_ = NULL;
	CheckerboardItem* _tmp20_;
	CheckerboardItem* _tmp22_;
	CheckerboardItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->view;
	if (data_collection_get_count ((DataCollection*) _tmp0_) == 0) {
		result = NULL;
		return result;
	}
	_vala_assert (self->priv->columns > 0, "columns > 0");
	_vala_assert (self->priv->rows > 0, "rows > 0");
	col = checkerboard_item_get_column (item);
	row = checkerboard_item_get_row (item);
	if (col < 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = row < 0;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = checkerboard_item_get_title (item);
		_tmp3_ = _tmp2_;
		g_critical ("CheckerboardLayout.vala:460: Attempting to locate item not placed in l" \
"ayout: %s", _tmp3_);
		_g_free0 (_tmp3_);
		result = NULL;
		return result;
	}
	switch (direction) {
		case GTK_DIR_UP:
		{
			gint _tmp4_;
			row = row - 1;
			_tmp4_ = row;
			if (_tmp4_ < 0) {
				row = 0;
			}
			break;
		}
		case GTK_DIR_DOWN:
		{
			gint _tmp5_;
			gint _tmp6_;
			row = row + 1;
			_tmp5_ = row;
			_tmp6_ = self->priv->rows;
			if (_tmp5_ >= _tmp6_) {
				row = self->priv->rows - 1;
			}
			break;
		}
		case GTK_DIR_RIGHT:
		{
			gint _tmp7_;
			gint _tmp8_;
			col = col + 1;
			_tmp7_ = col;
			_tmp8_ = self->priv->columns;
			if (_tmp7_ >= _tmp8_) {
				gint _tmp9_;
				gint _tmp10_;
				row = row + 1;
				_tmp9_ = row;
				_tmp10_ = self->priv->rows;
				if (_tmp9_ >= _tmp10_) {
					row = self->priv->rows - 1;
					col = self->priv->columns - 1;
				} else {
					col = 0;
				}
			}
			break;
		}
		case GTK_DIR_LEFT:
		{
			gint _tmp11_;
			col = col - 1;
			_tmp11_ = col;
			if (_tmp11_ < 0) {
				gint _tmp12_;
				row = row - 1;
				_tmp12_ = row;
				if (_tmp12_ < 0) {
					row = 0;
					col = 0;
				} else {
					col = self->priv->columns - 1;
				}
			}
			break;
		}
		default:
		{
			g_error ("CheckerboardLayout.vala:499: Bad compass direction %d", (gint) direction);
		}
	}
	_tmp13_ = checkerboard_layout_get_item_at_coordinate (self, col, row);
	new_item = _tmp13_;
	_tmp15_ = new_item;
	if (_tmp15_ == NULL) {
		_tmp14_ = direction == GTK_DIR_DOWN;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ViewCollection* _tmp16_;
		DataView* _tmp17_;
		CheckerboardItem* _tmp18_;
		_tmp16_ = self->priv->view;
		_tmp17_ = view_collection_get_last (_tmp16_);
		_g_object_unref0 (new_item);
		new_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
		_tmp18_ = new_item;
		if (checkerboard_item_get_row (_tmp18_) <= checkerboard_item_get_row (item)) {
			_g_object_unref0 (new_item);
			new_item = NULL;
		}
	}
	_tmp20_ = new_item;
	if (_tmp20_ != NULL) {
		CheckerboardItem* _tmp21_;
		_tmp21_ = new_item;
		_tmp19_ = _tmp21_;
	} else {
		_tmp19_ = item;
	}
	_tmp22_ = _g_object_ref0 (_tmp19_);
	result = _tmp22_;
	_g_object_unref0 (new_item);
	return result;
}

CheckerboardItem*
checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self,
                                            gint col,
                                            gint row)
{
	CheckerboardLayoutLayoutRow** _tmp0_;
	gint _tmp0__length1;
	CheckerboardLayoutLayoutRow* item_row = NULL;
	CheckerboardLayoutLayoutRow** _tmp1_;
	gint _tmp1__length1;
	CheckerboardLayoutLayoutRow* _tmp2_;
	CheckerboardLayoutLayoutRow* _tmp3_;
	CheckerboardLayoutLayoutRow* _tmp4_;
	CheckerboardLayoutLayoutRow* _tmp5_;
	CheckerboardItem** _tmp6_;
	gint _tmp6__length1;
	CheckerboardLayoutLayoutRow* _tmp7_;
	CheckerboardItem** _tmp8_;
	gint _tmp8__length1;
	CheckerboardItem* _tmp9_;
	CheckerboardItem* _tmp10_;
	CheckerboardItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->item_rows;
	_tmp0__length1 = self->priv->item_rows_length1;
	if (row >= _tmp0__length1) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->item_rows;
	_tmp1__length1 = self->priv->item_rows_length1;
	_tmp2_ = _tmp1_[row];
	_tmp3_ = _checkerboard_layout_layout_row_ref0 (_tmp2_);
	item_row = _tmp3_;
	_tmp4_ = item_row;
	if (_tmp4_ == NULL) {
		result = NULL;
		_checkerboard_layout_layout_row_unref0 (item_row);
		return result;
	}
	_tmp5_ = item_row;
	_tmp6_ = _tmp5_->items;
	_tmp6__length1 = _tmp5_->items_length1;
	if (col >= _tmp6__length1) {
		result = NULL;
		_checkerboard_layout_layout_row_unref0 (item_row);
		return result;
	}
	_tmp7_ = item_row;
	_tmp8_ = _tmp7_->items;
	_tmp8__length1 = _tmp7_->items_length1;
	_tmp9_ = _tmp8_[col];
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	_checkerboard_layout_layout_row_unref0 (item_row);
	return result;
}

void
checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self,
                                            gint x,
                                            gint y)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	g_return_if_fail (self != NULL);
	checkerboard_layout_clear_drag_select (self);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = allocation;
	self->priv->drag_origin.x = CLAMP (x, 0, _tmp1_.width);
	_tmp2_ = allocation;
	self->priv->drag_origin.y = CLAMP (y, 0, _tmp2_.height);
}

void
checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self,
                                              gint x,
                                              gint y)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	GdkRectangle old_selection_band = {0};
	GdkRectangle _tmp3_;
	GdkPoint _tmp4_;
	GdkPoint _tmp5_;
	Box _tmp6_ = {0};
	GdkRectangle _tmp7_ = {0};
	GdkWindow* _tmp8_;
	g_return_if_fail (self != NULL);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = allocation;
	self->priv->drag_endpoint.x = CLAMP (x, 0, _tmp1_.width);
	_tmp2_ = allocation;
	self->priv->drag_endpoint.y = CLAMP (y, 0, _tmp2_.height);
	_tmp3_ = self->priv->selection_band;
	old_selection_band = _tmp3_;
	_tmp4_ = self->priv->drag_origin;
	_tmp5_ = self->priv->drag_endpoint;
	box_from_points (&_tmp4_, &_tmp5_, &_tmp6_);
	box_get_rectangle (&_tmp6_, &_tmp7_);
	self->priv->selection_band = _tmp7_;
	_tmp8_ = gtk_widget_get_window ((GtkWidget*) self);
	if (_tmp8_ != NULL) {
		GdkRectangle _union_ = {0};
		GdkRectangle _tmp9_;
		GdkRectangle _tmp10_ = {0};
		GdkWindow* _tmp11_;
		GdkRectangle _tmp12_;
		_tmp9_ = old_selection_band;
		gdk_rectangle_union (&self->priv->selection_band, &_tmp9_, &_tmp10_);
		_union_ = _tmp10_;
		_tmp11_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp12_ = _union_;
		gdk_window_invalidate_rect (_tmp11_, &_tmp12_, FALSE);
	}
}

GeeList*
checkerboard_layout_items_in_selection_band (CheckerboardLayout* self)
{
	GdkRectangle _tmp0_;
	Dimensions _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GeeList* _tmp3_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selection_band;
	dimensions_for_rectangle (&_tmp0_, &_tmp1_);
	if (!dimensions_has_area (&_tmp1_)) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->selection_band;
	_tmp3_ = checkerboard_layout_intersection (self, &_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
checkerboard_layout_is_drag_select_active (CheckerboardLayout* self)
{
	gboolean _tmp0_ = FALSE;
	GdkPoint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->drag_origin;
	if (_tmp1_.x >= 0) {
		GdkPoint _tmp2_;
		_tmp2_ = self->priv->drag_origin;
		_tmp0_ = _tmp2_.y >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
checkerboard_layout_clear_drag_select (CheckerboardLayout* self)
{
	g_return_if_fail (self != NULL);
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
	self->priv->drag_origin.x = -1;
	self->priv->drag_origin.y = -1;
	self->priv->drag_endpoint.x = -1;
	self->priv->drag_endpoint.y = -1;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
checkerboard_layout_viewport_resized (CheckerboardLayout* self)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (self != NULL);
	checkerboard_layout_update_visible_page (self);
	_tmp0_ = self->priv->visible_page;
	if (_tmp0_.width != self->priv->last_width) {
		gint old_width = 0;
		GdkRectangle _tmp1_;
		GdkRectangle _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		old_width = self->priv->last_width;
		_tmp1_ = self->priv->visible_page;
		self->priv->last_width = _tmp1_.width;
		_tmp2_ = self->priv->visible_page;
		_tmp3_ = g_strdup_printf ("viewport_resized (%d -> %d)", old_width, _tmp2_.width);
		_tmp4_ = _tmp3_;
		checkerboard_layout_need_reflow (self, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup_printf ("viewport_resized (same width=%d)", self->priv->last_width);
		_tmp6_ = _tmp5_;
		checkerboard_layout_need_exposure (self, _tmp6_);
		_g_free0 (_tmp6_);
	}
}

static void
checkerboard_layout_expose_items (CheckerboardLayout* self,
                                  const gchar* caller)
{
	GeeHashSet* new_exposed_items = NULL;
	GeeHashSet* _tmp0_;
	ViewCollection* _tmp1_;
	GeeList* items = NULL;
	GeeList* _tmp2_;
	GeeHashSet* _tmp22_;
	GeeHashSet* _tmp23_;
	ViewCollection* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (caller != NULL);
	_tmp0_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	new_exposed_items = _tmp0_;
	_tmp1_ = self->priv->view;
	data_collection_freeze_notifications ((DataCollection*) _tmp1_);
	_tmp2_ = checkerboard_layout_get_visible_items (self);
	items = _tmp2_;
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp3_;
		gint _item_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _item_index = 0;
		_tmp3_ = items;
		_item_list = _tmp3_;
		_tmp4_ = _item_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_item_size = _tmp6_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			GeeHashSet* _tmp11_;
			CheckerboardItem* _tmp12_;
			GeeHashSet* _tmp13_;
			CheckerboardItem* _tmp14_;
			_item_index = _item_index + 1;
			_tmp7_ = _item_index;
			_tmp8_ = _item_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _item_list;
			_tmp10_ = gee_list_get (_tmp9_, _item_index);
			item = (CheckerboardItem*) _tmp10_;
			_tmp11_ = new_exposed_items;
			_tmp12_ = item;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
			_tmp13_ = self->priv->exposed_items;
			_tmp14_ = item;
			if (!gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp13_, _tmp14_)) {
				CheckerboardItem* _tmp15_;
				_tmp15_ = item;
				checkerboard_item_exposed (_tmp15_);
			}
			_g_object_unref0 (item);
		}
	}
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp16_;
		GeeIterator* _tmp17_;
		_tmp16_ = self->priv->exposed_items;
		_tmp17_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp16_);
		_item_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp19_;
			gpointer _tmp20_;
			CheckerboardItem* _tmp21_;
			_tmp18_ = _item_it;
			if (!gee_iterator_next (_tmp18_)) {
				break;
			}
			_tmp19_ = _item_it;
			_tmp20_ = gee_iterator_get (_tmp19_);
			item = (CheckerboardItem*) _tmp20_;
			_tmp21_ = item;
			checkerboard_item_unexposed (_tmp21_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	_tmp22_ = new_exposed_items;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (self->priv->exposed_items);
	self->priv->exposed_items = _tmp23_;
	self->priv->exposure_dirty = FALSE;
	_tmp24_ = self->priv->view;
	data_collection_thaw_notifications ((DataCollection*) _tmp24_);
	_g_object_unref0 (items);
	_g_object_unref0 (new_exposed_items);
}

static void
checkerboard_layout_unexpose_items (CheckerboardLayout* self,
                                    const gchar* caller)
{
	ViewCollection* _tmp0_;
	GeeHashSet* _tmp7_;
	ViewCollection* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (caller != NULL);
	_tmp0_ = self->priv->view;
	data_collection_freeze_notifications ((DataCollection*) _tmp0_);
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->exposed_items;
		_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
		_item_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			CheckerboardItem* _tmp6_;
			_tmp3_ = _item_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _item_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			item = (CheckerboardItem*) _tmp5_;
			_tmp6_ = item;
			checkerboard_item_unexposed (_tmp6_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	_tmp7_ = self->priv->exposed_items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
	self->priv->exposure_dirty = FALSE;
	_tmp8_ = self->priv->view;
	data_collection_thaw_notifications ((DataCollection*) _tmp8_);
}

static void
checkerboard_layout_reflow (CheckerboardLayout* self,
                            const gchar* caller)
{
	const gchar* _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkRectangle _tmp3_;
	gint visible_width = 0;
	gint total_items = 0;
	ViewCollection* _tmp6_;
	gboolean _tmp8_ = FALSE;
	CheckerboardItem* _tmp9_;
	gint max_cols = 0;
	gint max_rows = 0;
	gint row = 0;
	gint tallest = 0;
	gint widest = 0;
	gint row_alignment_point = 0;
	gint total_width = 0;
	gint col = 0;
	gint* column_widths = NULL;
	gint* _tmp23_;
	gint column_widths_length1;
	gint _column_widths_size_;
	gint* row_heights = NULL;
	gint* _tmp24_;
	gint row_heights_length1;
	gint _row_heights_size_;
	gint* alignment_points = NULL;
	gint* _tmp25_;
	gint alignment_points_length1;
	gint _alignment_points_size_;
	gint gutter = 0;
	CheckerboardLayoutLayoutRow** _tmp76_;
	gint x = 0;
	gint y = 0;
	CheckerboardLayoutLayoutRow* current_row = NULL;
	CheckerboardLayoutLayoutRow* _tmp115_;
	gint total_height = 0;
	gint* _tmp119_;
	gint _tmp119__length1;
	gint _tmp120_;
	gboolean _tmp121_ = FALSE;
	GtkAllocation _tmp122_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (caller != NULL);
	self->priv->reflow_needed = FALSE;
	_tmp0_ = self->priv->message;
	if (_tmp0_ != NULL) {
		return;
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
	allocation = _tmp1_;
	_tmp3_ = self->priv->visible_page;
	if (_tmp3_.width > 0) {
		GdkRectangle _tmp4_;
		_tmp4_ = self->priv->visible_page;
		_tmp2_ = _tmp4_.width;
	} else {
		GtkAllocation _tmp5_;
		_tmp5_ = allocation;
		_tmp2_ = _tmp5_.width;
	}
	visible_width = _tmp2_;
	if (visible_width <= 1) {
		return;
	}
	_tmp6_ = self->priv->view;
	total_items = data_collection_get_count ((DataCollection*) _tmp6_);
	if (total_items == 0) {
		CheckerboardLayoutLayoutRow** _tmp7_;
		gtk_widget_set_size_request ((GtkWidget*) self, visible_width, 0);
		_tmp7_ = g_new0 (CheckerboardLayoutLayoutRow*, 0 + 1);
		self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
		self->priv->item_rows = _tmp7_;
		self->priv->item_rows_length1 = 0;
		self->priv->_item_rows_size_ = self->priv->item_rows_length1;
		return;
	}
	_tmp9_ = self->priv->anchor;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		CheckerboardItem* _tmp10_;
		_tmp10_ = self->priv->anchor;
		_tmp8_ = !data_view_is_visible ((DataView*) _tmp10_);
	}
	if (_tmp8_) {
		checkerboard_layout_update_anchor (self);
	}
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
	self->priv->item_rows = NULL;
	self->priv->item_rows_length1 = 0;
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
	max_cols = 0;
	if (self->priv->scale > 0) {
		gint remaining_width = 0;
		gint max_item_width = 0;
		remaining_width = visible_width - (CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING * 2);
		max_item_width = checkerboard_item_get_max_width (self->priv->scale);
		max_cols = remaining_width / max_item_width;
		if (max_cols <= 0) {
			max_cols = 1;
		}
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			gint _tmp12_;
			if (max_cols > 1) {
				_tmp11_ = ((max_cols * max_item_width) + ((max_cols - 1) * CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING)) > remaining_width;
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = max_cols;
			max_cols = _tmp12_ - 1;
		}
		if (total_items < max_cols) {
			max_cols = total_items;
		}
	} else {
		gint x = 0;
		gint col = 0;
		gint row_width = 0;
		gint widest_row = 0;
		x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
		col = 0;
		row_width = 0;
		widest_row = 0;
		{
			gint ctr = 0;
			ctr = 0;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					CheckerboardItem* item = NULL;
					ViewCollection* _tmp15_;
					DataObject* _tmp16_;
					Dimensions req = {0};
					CheckerboardItem* _tmp17_;
					Dimensions _tmp18_;
					Dimensions _tmp19_;
					Dimensions _tmp20_;
					Dimensions _tmp21_;
					gint _tmp22_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = ctr;
						ctr = _tmp14_ + 1;
					}
					_tmp13_ = FALSE;
					if (!(ctr < total_items)) {
						break;
					}
					_tmp15_ = self->priv->view;
					_tmp16_ = data_collection_get_at ((DataCollection*) _tmp15_, ctr);
					item = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
					_tmp17_ = item;
					_tmp18_ = _tmp17_->requisition;
					req = _tmp18_;
					_vala_assert (dimensions_has_area (&req), "req.has_area ()");
					_tmp19_ = req;
					if (((x + _tmp19_.width) + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) > visible_width) {
						if (row_width > widest_row) {
							widest_row = row_width;
							max_cols = col;
						}
						col = 0;
						x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
						row_width = 0;
					}
					_tmp20_ = req;
					x += _tmp20_.width + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
					_tmp21_ = req;
					row_width += _tmp21_.width;
					_tmp22_ = col;
					col = _tmp22_ + 1;
					_g_object_unref0 (item);
				}
			}
		}
		if (row_width > widest_row) {
			max_cols = col;
		}
	}
	_vala_assert (max_cols > 0, "max_cols > 0");
	max_rows = (total_items / max_cols) + 1;
	row = 0;
	tallest = 0;
	widest = 0;
	row_alignment_point = 0;
	total_width = 0;
	col = 0;
	_tmp23_ = g_new0 (gint, max_cols);
	column_widths = _tmp23_;
	column_widths_length1 = max_cols;
	_column_widths_size_ = column_widths_length1;
	_tmp24_ = g_new0 (gint, max_rows);
	row_heights = _tmp24_;
	row_heights_length1 = max_rows;
	_row_heights_size_ = row_heights_length1;
	_tmp25_ = g_new0 (gint, max_rows);
	alignment_points = _tmp25_;
	alignment_points_length1 = max_rows;
	_alignment_points_size_ = alignment_points_length1;
	gutter = 0;
	{
		gboolean _tmp26_ = FALSE;
		_tmp26_ = TRUE;
		while (TRUE) {
			if (!_tmp26_) {
			}
			_tmp26_ = FALSE;
			{
				gint ctr = 0;
				ctr = 0;
				{
					gboolean _tmp27_ = FALSE;
					_tmp27_ = TRUE;
					while (TRUE) {
						CheckerboardItem* item = NULL;
						ViewCollection* _tmp29_;
						DataObject* _tmp30_;
						Dimensions req = {0};
						CheckerboardItem* _tmp31_;
						Dimensions _tmp32_;
						gint alignment_point = 0;
						CheckerboardItem* _tmp33_;
						Dimensions _tmp34_;
						Dimensions _tmp35_;
						Dimensions _tmp37_;
						gint* _tmp39_;
						gint _tmp39__length1;
						gint _tmp40_;
						Dimensions _tmp41_;
						gint _tmp47_;
						gint _tmp48_;
						if (!_tmp27_) {
							gint _tmp28_;
							_tmp28_ = ctr;
							ctr = _tmp28_ + 1;
						}
						_tmp27_ = FALSE;
						if (!(ctr < total_items)) {
							break;
						}
						_tmp29_ = self->priv->view;
						_tmp30_ = data_collection_get_at ((DataCollection*) _tmp29_, ctr);
						item = G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
						_tmp31_ = item;
						_tmp32_ = _tmp31_->requisition;
						req = _tmp32_;
						_tmp33_ = item;
						alignment_point = checkerboard_item_get_alignment_point (_tmp33_);
						_tmp34_ = req;
						_vala_assert (alignment_point < _tmp34_.height, "alignment_point < req.height");
						_tmp35_ = req;
						if (_tmp35_.height > tallest) {
							Dimensions _tmp36_;
							_tmp36_ = req;
							tallest = _tmp36_.height;
						}
						_tmp37_ = req;
						if (_tmp37_.width > widest) {
							Dimensions _tmp38_;
							_tmp38_ = req;
							widest = _tmp38_.width;
						}
						if (alignment_point > row_alignment_point) {
							row_alignment_point = alignment_point;
						}
						_tmp39_ = column_widths;
						_tmp39__length1 = column_widths_length1;
						_tmp40_ = _tmp39_[col];
						_tmp41_ = req;
						if (_tmp40_ < _tmp41_.width) {
							gint* _tmp42_;
							gint _tmp42__length1;
							gint _tmp43_;
							gint* _tmp44_;
							gint _tmp44__length1;
							Dimensions _tmp45_;
							Dimensions _tmp46_;
							_tmp42_ = column_widths;
							_tmp42__length1 = column_widths_length1;
							_tmp43_ = _tmp42_[col];
							total_width -= _tmp43_;
							_tmp44_ = column_widths;
							_tmp44__length1 = column_widths_length1;
							_tmp45_ = req;
							_tmp44_[col] = _tmp45_.width;
							_tmp46_ = req;
							total_width += _tmp46_.width;
						}
						col = col + 1;
						_tmp47_ = col;
						_tmp48_ = max_cols;
						if (_tmp47_ >= _tmp48_) {
							gint* _tmp49_;
							gint _tmp49__length1;
							gint* _tmp50_;
							gint _tmp50__length1;
							gint _tmp51_;
							gint _tmp52_;
							_tmp49_ = alignment_points;
							_tmp49__length1 = alignment_points_length1;
							_tmp49_[row] = row_alignment_point;
							_tmp50_ = row_heights;
							_tmp50__length1 = row_heights_length1;
							_tmp51_ = row;
							row = _tmp51_ + 1;
							_tmp52_ = tallest;
							_tmp50_[_tmp51_] = _tmp52_;
							col = 0;
							row_alignment_point = 0;
							tallest = 0;
						}
						_g_object_unref0 (item);
					}
				}
			}
			if (col != 0) {
				gint* _tmp53_;
				gint _tmp53__length1;
				gint* _tmp54_;
				gint _tmp54__length1;
				_tmp53_ = alignment_points;
				_tmp53__length1 = alignment_points_length1;
				_tmp53_[row] = row_alignment_point;
				_tmp54_ = row_heights;
				_tmp54__length1 = row_heights_length1;
				_tmp54_[row] = tallest;
			}
			gutter = (visible_width - total_width) / (max_cols + 1);
			if (max_cols == 1) {
				break;
			}
			if (gutter < CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) {
				gint _tmp55_;
				gint* _tmp56_;
				gint* _tmp57_;
				gint* _tmp58_;
				_tmp55_ = max_cols;
				max_cols = _tmp55_ - 1;
				max_rows = (total_items / max_cols) + 1;
				col = 0;
				row = 0;
				tallest = 0;
				widest = 0;
				total_width = 0;
				row_alignment_point = 0;
				_tmp56_ = g_new0 (gint, max_cols);
				column_widths = (g_free (column_widths), NULL);
				column_widths = _tmp56_;
				column_widths_length1 = max_cols;
				_column_widths_size_ = column_widths_length1;
				_tmp57_ = g_new0 (gint, max_rows);
				row_heights = (g_free (row_heights), NULL);
				row_heights = _tmp57_;
				row_heights_length1 = max_rows;
				_row_heights_size_ = row_heights_length1;
				_tmp58_ = g_new0 (gint, max_rows);
				alignment_points = (g_free (alignment_points), NULL);
				alignment_points = _tmp58_;
				alignment_points_length1 = max_rows;
				_alignment_points_size_ = alignment_points_length1;
			} else {
				break;
			}
		}
	}
	col = 0;
	row = 0;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp59_ = FALSE;
			_tmp59_ = TRUE;
			while (TRUE) {
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp61_;
				DataObject* _tmp62_;
				Dimensions req = {0};
				CheckerboardItem* _tmp63_;
				Dimensions _tmp64_;
				gint true_height = 0;
				Dimensions _tmp65_;
				gint* _tmp66_;
				gint _tmp66__length1;
				gint _tmp67_;
				CheckerboardItem* _tmp68_;
				Dimensions _tmp69_;
				gint* _tmp70_;
				gint _tmp70__length1;
				gint _tmp71_;
				gint _tmp73_;
				gint _tmp74_;
				if (!_tmp59_) {
					gint _tmp60_;
					_tmp60_ = ctr;
					ctr = _tmp60_ + 1;
				}
				_tmp59_ = FALSE;
				if (!(ctr < total_items)) {
					break;
				}
				_tmp61_ = self->priv->view;
				_tmp62_ = data_collection_get_at ((DataCollection*) _tmp61_, ctr);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
				_tmp63_ = item;
				_tmp64_ = _tmp63_->requisition;
				req = _tmp64_;
				_tmp65_ = req;
				_tmp66_ = alignment_points;
				_tmp66__length1 = alignment_points_length1;
				_tmp67_ = _tmp66_[row];
				_tmp68_ = item;
				true_height = _tmp65_.height + (_tmp67_ - checkerboard_item_get_alignment_point (_tmp68_));
				_tmp69_ = req;
				_vala_assert (true_height >= _tmp69_.height, "true_height >= req.height");
				_tmp70_ = row_heights;
				_tmp70__length1 = row_heights_length1;
				_tmp71_ = _tmp70_[row];
				if (true_height > _tmp71_) {
					gint* _tmp72_;
					gint _tmp72__length1;
					_tmp72_ = row_heights;
					_tmp72__length1 = row_heights_length1;
					_tmp72_[row] = true_height;
				}
				col = col + 1;
				_tmp73_ = col;
				_tmp74_ = max_cols;
				if (_tmp73_ >= _tmp74_) {
					gint _tmp75_;
					col = 0;
					_tmp75_ = row;
					row = _tmp75_ + 1;
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp76_ = g_new0 (CheckerboardLayoutLayoutRow*, max_rows + 1);
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
	self->priv->item_rows = _tmp76_;
	self->priv->item_rows_length1 = max_rows;
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
	x = gutter;
	y = CHECKERBOARD_LAYOUT_TOP_PADDING;
	col = 0;
	row = 0;
	current_row = NULL;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp77_ = FALSE;
			_tmp77_ = TRUE;
			while (TRUE) {
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp79_;
				DataObject* _tmp80_;
				Dimensions req = {0};
				CheckerboardItem* _tmp81_;
				Dimensions _tmp82_;
				gint xpadding = 0;
				gint* _tmp83_;
				gint _tmp83__length1;
				gint _tmp84_;
				Dimensions _tmp85_;
				gint ypadding = 0;
				gint* _tmp86_;
				gint _tmp86__length1;
				gint _tmp87_;
				CheckerboardItem* _tmp88_;
				CheckerboardItem* _tmp89_;
				CheckerboardItem* _tmp90_;
				CheckerboardItem* _tmp91_;
				Dimensions _tmp92_;
				CheckerboardItem* _tmp93_;
				Dimensions _tmp94_;
				CheckerboardItem* _tmp95_;
				CheckerboardLayoutLayoutRow* _tmp96_;
				CheckerboardLayoutLayoutRow* _tmp100_;
				CheckerboardItem** _tmp101_;
				gint _tmp101__length1;
				CheckerboardItem* _tmp102_;
				CheckerboardItem* _tmp103_;
				gint* _tmp104_;
				gint _tmp104__length1;
				gint _tmp105_;
				gint _tmp106_;
				gint _tmp107_;
				if (!_tmp77_) {
					gint _tmp78_;
					_tmp78_ = ctr;
					ctr = _tmp78_ + 1;
				}
				_tmp77_ = FALSE;
				if (!(ctr < total_items)) {
					break;
				}
				_tmp79_ = self->priv->view;
				_tmp80_ = data_collection_get_at ((DataCollection*) _tmp79_, ctr);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
				_tmp81_ = item;
				_tmp82_ = _tmp81_->requisition;
				req = _tmp82_;
				_tmp83_ = column_widths;
				_tmp83__length1 = column_widths_length1;
				_tmp84_ = _tmp83_[col];
				_tmp85_ = req;
				xpadding = (_tmp84_ - _tmp85_.width) / 2;
				_vala_assert (xpadding >= 0, "xpadding >= 0");
				_tmp86_ = alignment_points;
				_tmp86__length1 = alignment_points_length1;
				_tmp87_ = _tmp86_[row];
				_tmp88_ = item;
				ypadding = _tmp87_ - checkerboard_item_get_alignment_point (_tmp88_);
				_vala_assert (ypadding >= 0, "ypadding >= 0");
				_tmp89_ = item;
				_tmp89_->allocation.x = x + xpadding;
				_tmp90_ = item;
				_tmp90_->allocation.y = y + ypadding;
				_tmp91_ = item;
				_tmp92_ = req;
				_tmp91_->allocation.width = _tmp92_.width;
				_tmp93_ = item;
				_tmp94_ = req;
				_tmp93_->allocation.height = _tmp94_.height;
				_tmp95_ = item;
				checkerboard_item_set_grid_coordinates (_tmp95_, col, row);
				_tmp96_ = current_row;
				if (_tmp96_ == NULL) {
					gint* _tmp97_;
					gint _tmp97__length1;
					gint _tmp98_;
					CheckerboardLayoutLayoutRow* _tmp99_;
					_tmp97_ = row_heights;
					_tmp97__length1 = row_heights_length1;
					_tmp98_ = _tmp97_[row];
					_tmp99_ = checkerboard_layout_layout_row_new (y, _tmp98_, max_cols);
					_checkerboard_layout_layout_row_unref0 (current_row);
					current_row = _tmp99_;
				}
				_tmp100_ = current_row;
				_tmp101_ = _tmp100_->items;
				_tmp101__length1 = _tmp100_->items_length1;
				_tmp102_ = item;
				_tmp103_ = _g_object_ref0 (_tmp102_);
				_g_object_unref0 (_tmp101_[col]);
				_tmp101_[col] = _tmp103_;
				_tmp104_ = column_widths;
				_tmp104__length1 = column_widths_length1;
				_tmp105_ = _tmp104_[col];
				x += _tmp105_ + gutter;
				col = col + 1;
				_tmp106_ = col;
				_tmp107_ = max_cols;
				if (_tmp106_ >= _tmp107_) {
					CheckerboardLayoutLayoutRow* _tmp108_;
					CheckerboardLayoutLayoutRow** _tmp109_;
					gint _tmp109__length1;
					CheckerboardLayoutLayoutRow* _tmp110_;
					CheckerboardLayoutLayoutRow* _tmp111_;
					gint* _tmp112_;
					gint _tmp112__length1;
					gint _tmp113_;
					gint _tmp114_;
					_tmp108_ = current_row;
					_vala_assert (_tmp108_ != NULL, "current_row != null");
					_tmp109_ = self->priv->item_rows;
					_tmp109__length1 = self->priv->item_rows_length1;
					_tmp110_ = current_row;
					_tmp111_ = _checkerboard_layout_layout_row_ref0 (_tmp110_);
					_checkerboard_layout_layout_row_unref0 (_tmp109_[row]);
					_tmp109_[row] = _tmp111_;
					_checkerboard_layout_layout_row_unref0 (current_row);
					current_row = NULL;
					x = gutter;
					_tmp112_ = row_heights;
					_tmp112__length1 = row_heights_length1;
					_tmp113_ = _tmp112_[row];
					y += _tmp113_ + CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING;
					col = 0;
					_tmp114_ = row;
					row = _tmp114_ + 1;
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp115_ = current_row;
	if (_tmp115_ != NULL) {
		CheckerboardLayoutLayoutRow** _tmp116_;
		gint _tmp116__length1;
		CheckerboardLayoutLayoutRow* _tmp117_;
		CheckerboardLayoutLayoutRow* _tmp118_;
		_tmp116_ = self->priv->item_rows;
		_tmp116__length1 = self->priv->item_rows_length1;
		_tmp117_ = current_row;
		_tmp118_ = _checkerboard_layout_layout_row_ref0 (_tmp117_);
		_checkerboard_layout_layout_row_unref0 (_tmp116_[row]);
		_tmp116_[row] = _tmp118_;
	}
	self->priv->columns = max_cols;
	self->priv->rows = row + 1;
	_vala_assert (self->priv->rows == max_rows, "rows == max_rows");
	_tmp119_ = row_heights;
	_tmp119__length1 = row_heights_length1;
	_tmp120_ = _tmp119_[row];
	total_height = (y + _tmp120_) + CHECKERBOARD_LAYOUT_BOTTOM_PADDING;
	_tmp122_ = allocation;
	if (visible_width != _tmp122_.width) {
		_tmp121_ = TRUE;
	} else {
		GtkAllocation _tmp123_;
		_tmp123_ = allocation;
		_tmp121_ = total_height != _tmp123_.height;
	}
	if (_tmp121_) {
		gtk_widget_set_size_request ((GtkWidget*) self, visible_width, total_height);
		self->priv->size_allocate_due_to_reflow = TRUE;
		checkerboard_layout_center_on_anchor (self, (gdouble) total_height);
	}
	_checkerboard_layout_layout_row_unref0 (current_row);
	alignment_points = (g_free (alignment_points), NULL);
	row_heights = (g_free (row_heights), NULL);
	column_widths = (g_free (column_widths), NULL);
}

static void
checkerboard_layout_items_dirty (CheckerboardLayout* self,
                                 const gchar* reason,
                                 GeeIterable* items)
{
	GdkRectangle dirty = {0};
	gboolean _tmp26_ = FALSE;
	GdkRectangle _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reason != NULL);
	g_return_if_fail (items != NULL);
	memset (&dirty, 0, sizeof (GdkRectangle));
	{
		GeeIterator* _data_view_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (items);
		_data_view_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataView* data_view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			CheckerboardItem* item = NULL;
			DataView* _tmp4_;
			CheckerboardItem* _tmp5_;
			CheckerboardItem* _tmp6_;
			ViewCollection* _tmp7_;
			CheckerboardItem* _tmp8_;
			gboolean _tmp9_ = FALSE;
			CheckerboardItem* _tmp10_;
			GdkRectangle _tmp11_;
			GdkRectangle intersection = {0};
			CheckerboardItem* _tmp16_;
			GdkRectangle _tmp17_;
			GdkRectangle _tmp18_ = {0};
			gboolean _tmp19_;
			gboolean _tmp20_ = FALSE;
			GdkRectangle _tmp21_;
			_tmp1_ = _data_view_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _data_view_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			data_view = (DataView*) _tmp3_;
			_tmp4_ = data_view;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
			item = _tmp5_;
			_tmp6_ = item;
			if (!data_view_is_visible ((DataView*) _tmp6_)) {
				_g_object_unref0 (item);
				_g_object_unref0 (data_view);
				continue;
			}
			_tmp7_ = self->priv->view;
			_tmp8_ = item;
			_vala_assert (data_collection_contains ((DataCollection*) _tmp7_, (DataObject*) _tmp8_), "view.contains (item)");
			_tmp10_ = item;
			_tmp11_ = _tmp10_->allocation;
			if (_tmp11_.width <= 0) {
				_tmp9_ = TRUE;
			} else {
				CheckerboardItem* _tmp12_;
				GdkRectangle _tmp13_;
				_tmp12_ = item;
				_tmp13_ = _tmp12_->allocation;
				_tmp9_ = _tmp13_.height <= 0;
			}
			if (_tmp9_) {
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = g_strdup_printf ("items_dirty: %s", reason);
				_tmp15_ = _tmp14_;
				checkerboard_layout_need_reflow (self, _tmp15_);
				_g_free0 (_tmp15_);
				_g_object_unref0 (item);
				_g_object_unref0 (data_view);
				_g_object_unref0 (_data_view_it);
				return;
			}
			memset (&intersection, 0, sizeof (GdkRectangle));
			_tmp16_ = item;
			_tmp17_ = _tmp16_->allocation;
			_tmp19_ = gdk_rectangle_intersect (&self->priv->visible_page, &_tmp17_, &_tmp18_);
			intersection = _tmp18_;
			if (!_tmp19_) {
				_g_object_unref0 (item);
				_g_object_unref0 (data_view);
				continue;
			}
			_tmp21_ = dirty;
			if (_tmp21_.width == 0) {
				_tmp20_ = TRUE;
			} else {
				GdkRectangle _tmp22_;
				_tmp22_ = dirty;
				_tmp20_ = _tmp22_.height == 0;
			}
			if (_tmp20_) {
				GdkRectangle _tmp23_;
				_tmp23_ = intersection;
				dirty = _tmp23_;
			} else {
				GdkRectangle _tmp24_;
				GdkRectangle _tmp25_ = {0};
				_tmp24_ = intersection;
				gdk_rectangle_union (&dirty, &_tmp24_, &_tmp25_);
				dirty = _tmp25_;
			}
			_g_object_unref0 (item);
			_g_object_unref0 (data_view);
		}
		_g_object_unref0 (_data_view_it);
	}
	_tmp27_ = dirty;
	if (_tmp27_.width > 0) {
		GdkRectangle _tmp28_;
		_tmp28_ = dirty;
		_tmp26_ = _tmp28_.height > 0;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		GdkRectangle _tmp29_;
		GdkRectangle _tmp30_;
		GdkRectangle _tmp31_;
		GdkRectangle _tmp32_;
		_tmp29_ = dirty;
		_tmp30_ = dirty;
		_tmp31_ = dirty;
		_tmp32_ = dirty;
		gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp29_.x, _tmp30_.y, _tmp31_.width, _tmp32_.height);
	}
}

static void
checkerboard_layout_real_size_allocate (GtkWidget* base,
                                        GtkAllocation* allocation)
{
	CheckerboardLayout * self;
	GtkAllocation _tmp0_;
	self = (CheckerboardLayout*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), &_tmp0_);
	checkerboard_layout_viewport_resized (self);
}

static gboolean
checkerboard_layout_real_draw (GtkWidget* base,
                               cairo_t* ctx)
{
	CheckerboardLayout * self;
	const gchar* _tmp0_;
	gboolean _tmp33_ = FALSE;
	gboolean _result_ = FALSE;
	gboolean result;
	self = (CheckerboardLayout*) base;
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->message;
	if (_tmp0_ == NULL) {
		GtkStyleContext* style_context = NULL;
		GtkStyleContext* _tmp1_;
		GtkStyleContext* _tmp2_;
		GdkRectangle _tmp3_;
		GdkRectangle _tmp4_;
		GdkRectangle _tmp5_;
		GdkRectangle _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkStyleContext* _tmp8_;
		GtkStyleContext* _tmp9_;
		GtkStyleContext* _tmp21_;
		if (self->priv->exposure_dirty) {
			checkerboard_layout_expose_items (self, "draw");
		}
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		style_context = _tmp1_;
		_tmp2_ = style_context;
		_tmp3_ = self->priv->visible_page;
		_tmp4_ = self->priv->visible_page;
		_tmp5_ = self->priv->visible_page;
		_tmp6_ = self->priv->visible_page;
		gtk_render_background (_tmp2_, ctx, (gdouble) _tmp3_.x, (gdouble) _tmp4_.y, (gdouble) _tmp5_.width, (gdouble) _tmp6_.height);
		_tmp7_ = style_context;
		gtk_style_context_save (_tmp7_);
		_tmp8_ = style_context;
		gtk_style_context_add_class (_tmp8_, GRANITE_STYLE_CLASS_CARD);
		_tmp9_ = style_context;
		gtk_style_context_add_class (_tmp9_, GRANITE_STYLE_CLASS_CHECKERBOARD);
		{
			GeeList* _item_list = NULL;
			GdkRectangle _tmp10_;
			GeeList* _tmp11_;
			gint _item_size = 0;
			GeeList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _item_index = 0;
			_tmp10_ = self->priv->visible_page;
			_tmp11_ = checkerboard_layout_intersection (self, &_tmp10_);
			_item_list = _tmp11_;
			_tmp12_ = _item_list;
			_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_item_size = _tmp14_;
			_item_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				CheckerboardItem* item = NULL;
				GeeList* _tmp17_;
				gpointer _tmp18_;
				CheckerboardItem* _tmp19_;
				GtkStyleContext* _tmp20_;
				_item_index = _item_index + 1;
				_tmp15_ = _item_index;
				_tmp16_ = _item_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _item_list;
				_tmp18_ = gee_list_get (_tmp17_, _item_index);
				item = (CheckerboardItem*) _tmp18_;
				_tmp19_ = item;
				_tmp20_ = style_context;
				checkerboard_item_paint (_tmp19_, ctx, _tmp20_);
				_g_object_unref0 (item);
			}
			_g_object_unref0 (_item_list);
		}
		_tmp21_ = style_context;
		gtk_style_context_restore (_tmp21_);
	} else {
		PangoLayout* pango_layout = NULL;
		const gchar* _tmp22_;
		PangoLayout* _tmp23_;
		gint text_width = 0;
		gint text_height = 0;
		PangoLayout* _tmp24_;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		GtkAllocation allocation = {0};
		GtkAllocation _tmp27_ = {0};
		gint x = 0;
		GtkAllocation _tmp28_;
		gint _tmp29_ = 0;
		gint y = 0;
		GtkAllocation _tmp30_;
		gint _tmp31_ = 0;
		PangoLayout* _tmp32_;
		_tmp22_ = self->priv->message;
		_tmp23_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp22_);
		pango_layout = _tmp23_;
		_tmp24_ = pango_layout;
		pango_layout_get_pixel_size (_tmp24_, &_tmp25_, &_tmp26_);
		text_width = _tmp25_;
		text_height = _tmp26_;
		gtk_widget_get_allocation ((GtkWidget*) self, &_tmp27_);
		allocation = _tmp27_;
		_tmp28_ = allocation;
		x = _tmp28_.width - text_width;
		if (x > 0) {
			_tmp29_ = x / 2;
		} else {
			_tmp29_ = 0;
		}
		x = _tmp29_;
		_tmp30_ = allocation;
		y = _tmp30_.height - text_height;
		if (y > 0) {
			_tmp31_ = y / 2;
		} else {
			_tmp31_ = 0;
		}
		y = _tmp31_;
		cairo_move_to (ctx, (gdouble) x, (gdouble) y);
		_tmp32_ = pango_layout;
		pango_cairo_show_layout (ctx, _tmp32_);
		_g_object_unref0 (pango_layout);
	}
	if (GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw != NULL) {
		_tmp33_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), ctx);
	} else {
		_tmp33_ = TRUE;
	}
	_result_ = _tmp33_;
	checkerboard_layout_draw_selection_band (self, ctx);
	result = _result_;
	return result;
}

static void
checkerboard_layout_draw_selection_band (CheckerboardLayout* self,
                                         cairo_t* ctx)
{
	gboolean _tmp0_ = FALSE;
	GdkRectangle _tmp1_;
	gboolean _tmp3_ = FALSE;
	GtkAdjustment* _tmp4_;
	GdkRectangle visible_page = {0};
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	GdkRectangle _tmp8_ = {0};
	GdkRectangle visible_band = {0};
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_ = {0};
	GtkWidgetPath* label_widget_path = NULL;
	GtkWidgetPath* _tmp11_;
	GtkWidgetPath* _tmp12_;
	GtkWidgetPath* _tmp13_;
	GtkStyleContext* rubberband_context = NULL;
	GtkStyleContext* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkWidgetPath* _tmp16_;
	GtkStyleContext* _tmp17_;
	GdkRectangle _tmp18_;
	GdkRectangle _tmp19_;
	GdkRectangle _tmp20_;
	GdkRectangle _tmp21_;
	GtkStyleContext* _tmp22_;
	GdkRectangle _tmp23_;
	GdkRectangle _tmp24_;
	GdkRectangle _tmp25_;
	GdkRectangle _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	_tmp1_ = self->priv->selection_band;
	if (_tmp1_.width <= 1) {
		_tmp0_ = TRUE;
	} else {
		GdkRectangle _tmp2_;
		_tmp2_ = self->priv->selection_band;
		_tmp0_ = _tmp2_.height <= 1;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->hadjustment;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GtkAdjustment* _tmp5_;
		_tmp5_ = self->priv->vadjustment;
		_tmp3_ = _tmp5_ == NULL;
	}
	if (_tmp3_) {
		return;
	}
	cairo_save (ctx);
	_tmp6_ = self->priv->hadjustment;
	_tmp7_ = self->priv->vadjustment;
	get_adjustment_page (_tmp6_, _tmp7_, &_tmp8_);
	visible_page = _tmp8_;
	memset (&visible_band, 0, sizeof (GdkRectangle));
	_tmp9_ = self->priv->selection_band;
	gdk_rectangle_intersect (&visible_page, &_tmp9_, &_tmp10_);
	visible_band = _tmp10_;
	_tmp11_ = gtk_widget_path_new ();
	label_widget_path = _tmp11_;
	_tmp12_ = label_widget_path;
	gtk_widget_path_append_type (_tmp12_, gtk_icon_view_get_type ());
	_tmp13_ = label_widget_path;
	gtk_widget_path_iter_set_object_name (_tmp13_, -1, "rubberband");
	_tmp14_ = gtk_style_context_new ();
	rubberband_context = _tmp14_;
	_tmp15_ = rubberband_context;
	_tmp16_ = label_widget_path;
	gtk_style_context_set_path (_tmp15_, _tmp16_);
	_tmp17_ = rubberband_context;
	_tmp18_ = visible_band;
	_tmp19_ = visible_band;
	_tmp20_ = visible_band;
	_tmp21_ = visible_band;
	gtk_render_background (_tmp17_, ctx, (gdouble) _tmp18_.x, (gdouble) _tmp19_.y, (gdouble) _tmp20_.width, (gdouble) _tmp21_.height);
	_tmp22_ = rubberband_context;
	_tmp23_ = visible_band;
	_tmp24_ = visible_band;
	_tmp25_ = visible_band;
	_tmp26_ = visible_band;
	gtk_render_frame (_tmp22_, ctx, (gdouble) _tmp23_.x, (gdouble) _tmp24_.y, (gdouble) _tmp25_.width, (gdouble) _tmp26_.height);
	cairo_restore (ctx);
	_g_object_unref0 (rubberband_context);
	_gtk_widget_path_unref0 (label_widget_path);
}

static gboolean
checkerboard_layout_real_query_tooltip (GtkWidget* base,
                                        gint x,
                                        gint y,
                                        gboolean keyboard_mode,
                                        GtkTooltip* tooltip)
{
	CheckerboardLayout * self;
	CheckerboardItem* item = NULL;
	CheckerboardItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	CheckerboardItem* _tmp2_;
	gboolean result;
	self = (CheckerboardLayout*) base;
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = checkerboard_layout_get_item_at_pixel (self, (gdouble) x, (gdouble) y);
	item = _tmp0_;
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		CheckerboardItem* _tmp3_;
		_tmp3_ = item;
		_tmp1_ = checkerboard_item_query_tooltip (_tmp3_, x, y, tooltip);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (item);
	return result;
}

static gboolean
checkerboard_layout_real_focus_in_event (GtkWidget* base,
                                         GdkEventFocus* event)
{
	CheckerboardLayout * self;
	ViewCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gboolean result;
	self = (CheckerboardLayout*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->view;
	_tmp1_ = view_collection_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	checkerboard_layout_items_dirty (self, "focus_in_event", (GeeIterable*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	result = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_in_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), event);
	return result;
}

static gboolean
checkerboard_layout_real_focus_out_event (GtkWidget* base,
                                          GdkEventFocus* event)
{
	CheckerboardLayout * self;
	ViewCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gboolean result;
	self = (CheckerboardLayout*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->view;
	_tmp1_ = view_collection_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	checkerboard_layout_items_dirty (self, "focus_out_event", (GeeIterable*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	result = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_out_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), event);
	return result;
}

static CheckerboardLayoutLayoutRow*
checkerboard_layout_layout_row_construct (GType object_type,
                                          gint y,
                                          gint height,
                                          gint num_in_row)
{
	CheckerboardLayoutLayoutRow* self = NULL;
	CheckerboardItem** _tmp0_;
	self = (CheckerboardLayoutLayoutRow*) g_type_create_instance (object_type);
	self->y = y;
	self->height = height;
	_tmp0_ = g_new0 (CheckerboardItem*, num_in_row + 1);
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->items = _tmp0_;
	self->items_length1 = num_in_row;
	self->_items_size_ = self->items_length1;
	return self;
}

static CheckerboardLayoutLayoutRow*
checkerboard_layout_layout_row_new (gint y,
                                    gint height,
                                    gint num_in_row)
{
	return checkerboard_layout_layout_row_construct (CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, y, height, num_in_row);
}

static void
checkerboard_layout_value_layout_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
checkerboard_layout_value_layout_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		checkerboard_layout_layout_row_unref (value->data[0].v_pointer);
	}
}

static void
checkerboard_layout_value_layout_row_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = checkerboard_layout_layout_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
checkerboard_layout_value_layout_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
checkerboard_layout_value_layout_row_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CheckerboardLayoutLayoutRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = checkerboard_layout_layout_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
checkerboard_layout_value_layout_row_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	CheckerboardLayoutLayoutRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
checkerboard_layout_param_spec_layout_row (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	CheckerboardLayoutParamSpecLayoutRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
checkerboard_layout_value_get_layout_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
	return value->data[0].v_pointer;
}

static void
checkerboard_layout_value_set_layout_row (GValue* value,
                                          gpointer v_object)
{
	CheckerboardLayoutLayoutRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		checkerboard_layout_layout_row_unref (old);
	}
}

static void
checkerboard_layout_value_take_layout_row (GValue* value,
                                           gpointer v_object)
{
	CheckerboardLayoutLayoutRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		checkerboard_layout_layout_row_unref (old);
	}
}

static void
checkerboard_layout_layout_row_class_init (CheckerboardLayoutLayoutRowClass * klass,
                                           gpointer klass_data)
{
	checkerboard_layout_layout_row_parent_class = g_type_class_peek_parent (klass);
	((CheckerboardLayoutLayoutRowClass *) klass)->finalize = checkerboard_layout_layout_row_finalize;
}

static void
checkerboard_layout_layout_row_instance_init (CheckerboardLayoutLayoutRow * self,
                                              gpointer klass)
{
	self->ref_count = 1;
}

static void
checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow * obj)
{
	CheckerboardLayoutLayoutRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow);
	g_signal_handlers_destroy (self);
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
}

static GType
checkerboard_layout_layout_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { checkerboard_layout_value_layout_row_init, checkerboard_layout_value_layout_row_free_value, checkerboard_layout_value_layout_row_copy_value, checkerboard_layout_value_layout_row_peek_pointer, "p", checkerboard_layout_value_layout_row_collect_value, "p", checkerboard_layout_value_layout_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutLayoutRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_layout_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayoutLayoutRow), 0, (GInstanceInitFunc) checkerboard_layout_layout_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType checkerboard_layout_layout_row_type_id;
	checkerboard_layout_layout_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardLayoutLayoutRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return checkerboard_layout_layout_row_type_id;
}

static GType
checkerboard_layout_layout_row_get_type (void)
{
	static volatile gsize checkerboard_layout_layout_row_type_id__once = 0;
	if (g_once_init_enter (&checkerboard_layout_layout_row_type_id__once)) {
		GType checkerboard_layout_layout_row_type_id;
		checkerboard_layout_layout_row_type_id = checkerboard_layout_layout_row_get_type_once ();
		g_once_init_leave (&checkerboard_layout_layout_row_type_id__once, checkerboard_layout_layout_row_type_id);
	}
	return checkerboard_layout_layout_row_type_id__once;
}

static gpointer
checkerboard_layout_layout_row_ref (gpointer instance)
{
	CheckerboardLayoutLayoutRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
checkerboard_layout_layout_row_unref (gpointer instance)
{
	CheckerboardLayoutLayoutRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
checkerboard_layout_class_init (CheckerboardLayoutClass * klass,
                                gpointer klass_data)
{
	checkerboard_layout_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CheckerboardLayout_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) checkerboard_layout_real_size_allocate;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) checkerboard_layout_real_draw;
	((GtkWidgetClass *) klass)->query_tooltip = (gboolean (*) (GtkWidget*, gint, gint, gboolean, GtkTooltip*)) checkerboard_layout_real_query_tooltip;
	((GtkWidgetClass *) klass)->focus_in_event = (gboolean (*) (GtkWidget*, GdkEventFocus*)) checkerboard_layout_real_focus_in_event;
	((GtkWidgetClass *) klass)->focus_out_event = (gboolean (*) (GtkWidget*, GdkEventFocus*)) checkerboard_layout_real_focus_out_event;
	G_OBJECT_CLASS (klass)->finalize = checkerboard_layout_finalize;
}

static void
checkerboard_layout_instance_init (CheckerboardLayout * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = checkerboard_layout_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->page_name = _tmp0_;
	self->priv->item_rows = NULL;
	self->priv->item_rows_length1 = 0;
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
	_tmp1_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->exposed_items = _tmp1_;
	self->priv->hadjustment = NULL;
	self->priv->vadjustment = NULL;
	self->priv->message = NULL;
	memset (&self->priv->visible_page, 0, sizeof (GdkRectangle));
	self->priv->last_width = 0;
	self->priv->columns = 0;
	self->priv->rows = 0;
	memset (&self->priv->drag_origin, 0, sizeof (GdkPoint));
	memset (&self->priv->drag_endpoint, 0, sizeof (GdkPoint));
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
	self->priv->scale = 0;
	self->priv->flow_scheduled = FALSE;
	self->priv->exposure_dirty = TRUE;
	self->priv->anchor = NULL;
	self->priv->in_center_on_anchor = FALSE;
	self->priv->size_allocate_due_to_reflow = FALSE;
	self->priv->is_in_view = FALSE;
	self->priv->reflow_needed = FALSE;
}

static void
checkerboard_layout_finalize (GObject * obj)
{
	CheckerboardLayout * self;
	ViewCollection* _tmp0_;
	guint _tmp1_;
	ViewCollection* _tmp2_;
	guint _tmp3_;
	ViewCollection* _tmp4_;
	guint _tmp5_;
	ViewCollection* _tmp6_;
	guint _tmp7_;
	ViewCollection* _tmp8_;
	guint _tmp9_;
	ViewCollection* _tmp10_;
	guint _tmp11_;
	ViewCollection* _tmp12_;
	guint _tmp13_;
	ViewCollection* _tmp14_;
	guint _tmp15_;
	ViewCollection* _tmp16_;
	guint _tmp17_;
	GtkAdjustment* _tmp18_;
	GtkAdjustment* _tmp21_;
	GtkContainer* _tmp24_;
	GtkContainer* _tmp25_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
	_tmp0_ = self->priv->view;
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self);
	_tmp2_ = self->priv->view;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self);
	_tmp4_ = self->priv->view;
	g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self);
	_tmp6_ = self->priv->view;
	g_signal_parse_name ("items-visibility-changed", TYPE_VIEW_COLLECTION, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self);
	_tmp8_ = self->priv->view;
	g_signal_parse_name ("ordering-changed", TYPE_DATA_COLLECTION, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self);
	_tmp10_ = self->priv->view;
	g_signal_parse_name ("views-altered", TYPE_VIEW_COLLECTION, &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self);
	_tmp12_ = self->priv->view;
	g_signal_parse_name ("geometries-altered", TYPE_VIEW_COLLECTION, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self);
	_tmp14_ = self->priv->view;
	g_signal_parse_name ("items-selected", TYPE_VIEW_COLLECTION, &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self);
	_tmp16_ = self->priv->view;
	g_signal_parse_name ("items-unselected", TYPE_VIEW_COLLECTION, &_tmp17_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self);
	_tmp18_ = self->priv->hadjustment;
	if (_tmp18_ != NULL) {
		GtkAdjustment* _tmp19_;
		guint _tmp20_;
		_tmp19_ = self->priv->hadjustment;
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp20_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
	}
	_tmp21_ = self->priv->vadjustment;
	if (_tmp21_ != NULL) {
		GtkAdjustment* _tmp22_;
		guint _tmp23_;
		_tmp22_ = self->priv->vadjustment;
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp23_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
	}
	_tmp24_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		GtkContainer* _tmp26_;
		GtkContainer* _tmp27_;
		guint _tmp28_;
		_tmp26_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp27_ = _tmp26_;
		g_signal_parse_name ("size-allocate", gtk_widget_get_type (), &_tmp28_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp27_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp28_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self);
	}
	_data_collection_unref0 (self->priv->view);
	_g_free0 (self->priv->page_name);
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
	_g_object_unref0 (self->priv->exposed_items);
	_g_object_unref0 (self->priv->hadjustment);
	_g_object_unref0 (self->priv->vadjustment);
	_g_free0 (self->priv->message);
	_g_object_unref0 (self->priv->anchor);
	G_OBJECT_CLASS (checkerboard_layout_parent_class)->finalize (obj);
}

static GType
checkerboard_layout_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayout), 0, (GInstanceInitFunc) checkerboard_layout_instance_init, NULL };
	GType checkerboard_layout_type_id;
	checkerboard_layout_type_id = g_type_register_static (gtk_drawing_area_get_type (), "CheckerboardLayout", &g_define_type_info, 0);
	CheckerboardLayout_private_offset = g_type_add_instance_private (checkerboard_layout_type_id, sizeof (CheckerboardLayoutPrivate));
	return checkerboard_layout_type_id;
}

GType
checkerboard_layout_get_type (void)
{
	static volatile gsize checkerboard_layout_type_id__once = 0;
	if (g_once_init_enter (&checkerboard_layout_type_id__once)) {
		GType checkerboard_layout_type_id;
		checkerboard_layout_type_id = checkerboard_layout_get_type_once ();
		g_once_init_leave (&checkerboard_layout_type_id__once, checkerboard_layout_type_id);
	}
	return checkerboard_layout_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

