/* Utils.c generated by valac 0.56.17, the Vala compiler
 * generated from Utils.vala, do not modify */

/*-
 * Copyright 2014-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 *              Marvin Beckers <beckersmarvin@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UTILS (utils_get_type ())
#define UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UTILS, Utils))
#define UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UTILS, UtilsClass))
#define IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UTILS))
#define IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UTILS))
#define UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UTILS, UtilsClass))

typedef struct _Utils Utils;
typedef struct _UtilsClass UtilsClass;
typedef struct _UtilsPrivate UtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecUtils ParamSpecUtils;

struct _Utils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UtilsPrivate * priv;
};

struct _UtilsClass {
	GTypeClass parent_class;
	void (*finalize) (Utils *self);
};

struct _ParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer utils_parent_class = NULL;
static gchar* utils__documentation_url;
static gchar* utils__documentation_url = NULL;
static gchar* utils__support_url;
static gchar* utils__support_url = NULL;
static gchar* utils__os_name;
static gchar* utils__os_name = NULL;
static gchar* utils__logo_icon_name;
static gchar* utils__logo_icon_name = NULL;

VALA_EXTERN gpointer utils_ref (gpointer instance);
VALA_EXTERN void utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_utils (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_utils (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_utils (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_utils (const GValue* value);
VALA_EXTERN GType utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Utils, utils_unref)
VALA_EXTERN Utils* utils_new (void);
VALA_EXTERN Utils* utils_construct (GType object_type);
VALA_EXTERN const gchar* utils_get_documentation_url (void);
VALA_EXTERN const gchar* utils_get_support_url (void);
VALA_EXTERN const gchar* utils_get_os_name (void);
VALA_EXTERN const gchar* utils_get_logo_icon_name (void);
static void utils_finalize (Utils * obj);
static GType utils_get_type_once (void);

Utils*
utils_construct (GType object_type)
{
	Utils* self = NULL;
	self = (Utils*) g_type_create_instance (object_type);
	return self;
}

Utils*
utils_new (void)
{
	return utils_construct (TYPE_UTILS);
}

const gchar*
utils_get_documentation_url (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	_tmp0_ = utils__documentation_url;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_get_os_info (G_OS_INFO_KEY_DOCUMENTATION_URL);
		_g_free0 (utils__documentation_url);
		utils__documentation_url = _tmp1_;
		_tmp2_ = utils__documentation_url;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("https://elementary.io/docs/learning-the-basics");
			_g_free0 (utils__documentation_url);
			utils__documentation_url = _tmp3_;
		}
	}
	_tmp4_ = utils__documentation_url;
	result = _tmp4_;
	return result;
}

const gchar*
utils_get_support_url (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	_tmp0_ = utils__support_url;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_get_os_info (G_OS_INFO_KEY_SUPPORT_URL);
		_g_free0 (utils__support_url);
		utils__support_url = _tmp1_;
		_tmp2_ = utils__support_url;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("https://elementary.io/support");
			_g_free0 (utils__support_url);
			utils__support_url = _tmp3_;
		}
	}
	_tmp4_ = utils__support_url;
	result = _tmp4_;
	return result;
}

const gchar*
utils_get_os_name (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	_tmp0_ = utils__os_name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_get_os_info (G_OS_INFO_KEY_NAME);
		_g_free0 (utils__os_name);
		utils__os_name = _tmp1_;
		_tmp2_ = utils__os_name;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("elementary OS");
			_g_free0 (utils__os_name);
			utils__os_name = _tmp3_;
		}
	}
	_tmp4_ = utils__os_name;
	result = _tmp4_;
	return result;
}

const gchar*
utils_get_logo_icon_name (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	_tmp0_ = utils__logo_icon_name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_get_os_info ("LOGO");
		_g_free0 (utils__logo_icon_name);
		utils__logo_icon_name = _tmp1_;
		_tmp2_ = utils__logo_icon_name;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("distributor-logo");
			_g_free0 (utils__logo_icon_name);
			utils__logo_icon_name = _tmp3_;
		}
	}
	_tmp4_ = utils__logo_icon_name;
	result = _tmp4_;
	return result;
}

static void
value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		utils_unref (value->data[0].v_pointer);
	}
}

static void
value_utils_copy_value (const GValue* src_value,
                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_utils_collect_value (GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Utils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_utils_lcopy_value (const GValue* value,
                         guint n_collect_values,
                         GTypeCValue* collect_values,
                         guint collect_flags)
{
	Utils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_utils (const gchar* name,
                  const gchar* nick,
                  const gchar* blurb,
                  GType object_type,
                  GParamFlags flags)
{
	ParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_utils (GValue* value,
                 gpointer v_object)
{
	Utils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		utils_unref (old);
	}
}

void
value_take_utils (GValue* value,
                  gpointer v_object)
{
	Utils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		utils_unref (old);
	}
}

static void
utils_class_init (UtilsClass * klass,
                  gpointer klass_data)
{
	utils_parent_class = g_type_class_peek_parent (klass);
	((UtilsClass *) klass)->finalize = utils_finalize;
}

static void
utils_instance_init (Utils * self,
                     gpointer klass)
{
	self->ref_count = 1;
}

static void
utils_finalize (Utils * obj)
{
	Utils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UTILS, Utils);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_utils_init, value_utils_free_value, value_utils_copy_value, value_utils_peek_pointer, "p", value_utils_collect_value, "p", value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Utils), 0, (GInstanceInitFunc) utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType utils_type_id;
	utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Utils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return utils_type_id;
}

GType
utils_get_type (void)
{
	static volatile gsize utils_type_id__once = 0;
	if (g_once_init_enter (&utils_type_id__once)) {
		GType utils_type_id;
		utils_type_id = utils_get_type_once ();
		g_once_init_leave (&utils_type_id__once, utils_type_id);
	}
	return utils_type_id__once;
}

gpointer
utils_ref (gpointer instance)
{
	Utils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
utils_unref (gpointer instance)
{
	Utils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

