/* AppMenu.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppMenu.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0
 * SPDX-FileCopyrightText: 2020-2023 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "pantheon-files-core.h"
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_APP_MENU (files_app_menu_get_type ())
#define FILES_APP_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_APP_MENU, FilesAppMenu))
#define FILES_APP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_APP_MENU, FilesAppMenuClass))
#define FILES_IS_APP_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_APP_MENU))
#define FILES_IS_APP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_APP_MENU))
#define FILES_APP_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_APP_MENU, FilesAppMenuClass))

typedef struct _FilesAppMenu FilesAppMenu;
typedef struct _FilesAppMenuClass FilesAppMenuClass;
typedef struct _FilesAppMenuPrivate FilesAppMenuPrivate;
enum  {
	FILES_APP_MENU_0_PROPERTY,
	FILES_APP_MENU_NUM_PROPERTIES
};
static GParamSpec* files_app_menu_properties[FILES_APP_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block54Data Block54Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _FilesAppMenu {
	GtkPopover parent_instance;
	FilesAppMenuPrivate * priv;
};

struct _FilesAppMenuClass {
	GtkPopoverClass parent_class;
};

struct _FilesAppMenuPrivate {
	GtkButton* redo_button;
	GtkButton* undo_button;
	GtkButton* zoom_default_button;
	GtkButton* zoom_in_button;
	GtkButton* zoom_out_button;
	gchar** redo_accels;
	gint redo_accels_length1;
	gint _redo_accels_size_;
	gchar** undo_accels;
	gint undo_accels_length1;
	gint _undo_accels_size_;
	FilesUndoManager* undo_manager;
};

struct _Block54Data {
	int _ref_count_;
	FilesAppMenu* self;
	GtkRadioButton* iso_button;
	GtkRadioButton* locale_button;
	GtkRadioButton* informal_button;
};

static gint FilesAppMenu_private_offset;
static gpointer files_app_menu_parent_class = NULL;
VALA_EXTERN GSettings* files_icon_view_settings;
VALA_EXTERN GSettings* files_list_view_settings;
VALA_EXTERN GSettings* files_column_view_settings;
VALA_EXTERN GSettings* files_app_settings;

VALA_EXTERN GType files_app_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAppMenu, g_object_unref)
static void files_app_menu_set_undo_redo_tooltips (FilesAppMenu* self);
VALA_EXTERN void files_app_menu_on_zoom_setting_changed (FilesAppMenu* self,
                                             GSettings* settings,
                                             const gchar* key);
VALA_EXTERN FilesAppMenu* files_app_menu_new (void);
VALA_EXTERN FilesAppMenu* files_app_menu_construct (GType object_type);
static GObject * files_app_menu_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static GVariant* _variant_new18 (const gchar* value);
static GVariant* _variant_new19 (const gchar* value);
static GVariant* _variant_new20 (const gchar* value);
static void _files_app_menu_set_undo_redo_tooltips_files_undo_manager_request_menu_update (FilesUndoManager* _sender,
                                                                                    gpointer self);
static void _files_app_menu_on_zoom_setting_changed_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self);
static void _files_app_menu___lambda151_ (Block54Data* _data54_);
static void __files_app_menu___lambda151__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                              gpointer self);
static void _files_app_menu___lambda152_ (Block54Data* _data54_);
static void __files_app_menu___lambda152__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                              gpointer self);
static void _files_app_menu___lambda153_ (Block54Data* _data54_);
static void __files_app_menu___lambda153__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                              gpointer self);
static void files_app_menu_finalize (GObject * obj);
static GType files_app_menu_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
files_app_menu_get_instance_private (FilesAppMenu* self)
{
	return G_STRUCT_MEMBER_P (self, FilesAppMenu_private_offset);
}

static void
files_app_menu_set_undo_redo_tooltips (FilesAppMenu* self)
{
	const gchar* undo_action_s = NULL;
	FilesUndoManager* _tmp0_;
	const gchar* _tmp1_;
	const gchar* redo_action_s = NULL;
	FilesUndoManager* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	GtkButton* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_;
	GtkButton* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_manager;
	_tmp1_ = files_undo_manager_get_next_undo_description (_tmp0_);
	undo_action_s = _tmp1_;
	_tmp2_ = self->priv->undo_manager;
	_tmp3_ = files_undo_manager_get_next_redo_description (_tmp2_);
	redo_action_s = _tmp3_;
	_tmp5_ = undo_action_s;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = undo_action_s;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = _ ("No operation to undo");
	}
	_tmp7_ = self->priv->undo_button;
	_tmp8_ = self->priv->undo_accels;
	_tmp8__length1 = self->priv->undo_accels_length1;
	_tmp9_ = granite_markup_accel_tooltip (_tmp8_, (gint) _tmp8__length1, _tmp4_);
	_tmp10_ = _tmp9_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp12_ = redo_action_s;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		_tmp13_ = redo_action_s;
		_tmp11_ = _tmp13_;
	} else {
		_tmp11_ = _ ("No operation to redo");
	}
	_tmp14_ = self->priv->redo_button;
	_tmp15_ = self->priv->redo_accels;
	_tmp15__length1 = self->priv->redo_accels_length1;
	_tmp16_ = granite_markup_accel_tooltip (_tmp15_, (gint) _tmp15__length1, _tmp11_);
	_tmp17_ = _tmp16_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
}

void
files_app_menu_on_zoom_setting_changed (FilesAppMenu* self,
                                        GSettings* settings,
                                        const gchar* key)
{
	FilesZoomLevel default_zoom = 0;
	FilesZoomLevel zoom_level = 0;
	GtkButton* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint max_zoom = 0;
	gint min_zoom = 0;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	if (settings == NULL) {
		GtkButton* _tmp0_;
		g_critical ("AppMenu.vala:212: Zoom string from settinggs: Null settings");
		_tmp0_ = self->priv->zoom_default_button;
		gtk_button_set_label (_tmp0_, "");
		return;
	}
	default_zoom = (FilesZoomLevel) g_settings_get_enum (settings, "default-zoom-level");
	zoom_level = (FilesZoomLevel) g_settings_get_enum (settings, "zoom-level");
	_tmp1_ = self->priv->zoom_default_button;
	_tmp2_ = g_strdup_printf ("%.0f%%", (((gdouble) files_zoom_level_to_icon_size (zoom_level)) / ((gdouble) files_zoom_level_to_icon_size (default_zoom))) * 100);
	_tmp3_ = _tmp2_;
	gtk_button_set_label (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	max_zoom = g_settings_get_enum (settings, "maximum-zoom-level");
	min_zoom = g_settings_get_enum (settings, "minimum-zoom-level");
	_tmp4_ = self->priv->zoom_in_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, zoom_level < max_zoom);
	_tmp5_ = self->priv->zoom_out_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, zoom_level > min_zoom);
}

FilesAppMenu*
files_app_menu_construct (GType object_type)
{
	FilesAppMenu * self = NULL;
	self = (FilesAppMenu*) g_object_new (object_type, NULL);
	return self;
}

FilesAppMenu*
files_app_menu_new (void)
{
	return files_app_menu_construct (FILES_TYPE_APP_MENU);
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		FilesAppMenu* self;
		self = _data54_->self;
		_g_object_unref0 (_data54_->informal_button);
		_g_object_unref0 (_data54_->locale_button);
		_g_object_unref0 (_data54_->iso_button);
		_g_object_unref0 (self);
		g_slice_free (Block54Data, _data54_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GVariant*
_variant_new18 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new19 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new20 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_files_app_menu_set_undo_redo_tooltips_files_undo_manager_request_menu_update (FilesUndoManager* _sender,
                                                                               gpointer self)
{
	files_app_menu_set_undo_redo_tooltips ((FilesAppMenu*) self);
}

static void
_files_app_menu_on_zoom_setting_changed_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self)
{
	files_app_menu_on_zoom_setting_changed ((FilesAppMenu*) self, _sender, key);
}

static void
_files_app_menu___lambda151_ (Block54Data* _data54_)
{
	FilesAppMenu* self;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data54_->self;
	_tmp0_ = _data54_->iso_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSettings* _tmp3_;
		_tmp3_ = files_app_settings;
		g_settings_set_enum (_tmp3_, "date-format", (gint) FILES_DATE_FORMAT_MODE_ISO);
	}
}

static void
__files_app_menu___lambda151__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                         gpointer self)
{
	_files_app_menu___lambda151_ (self);
}

static void
_files_app_menu___lambda152_ (Block54Data* _data54_)
{
	FilesAppMenu* self;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data54_->self;
	_tmp0_ = _data54_->locale_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSettings* _tmp3_;
		_tmp3_ = files_app_settings;
		g_settings_set_enum (_tmp3_, "date-format", (gint) FILES_DATE_FORMAT_MODE_LOCALE);
	}
}

static void
__files_app_menu___lambda152__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                         gpointer self)
{
	_files_app_menu___lambda152_ (self);
}

static void
_files_app_menu___lambda153_ (Block54Data* _data54_)
{
	FilesAppMenu* self;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data54_->self;
	_tmp0_ = _data54_->informal_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSettings* _tmp3_;
		_tmp3_ = files_app_settings;
		g_settings_set_enum (_tmp3_, "date-format", (gint) FILES_DATE_FORMAT_MODE_INFORMAL);
	}
}

static void
__files_app_menu___lambda153__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                         gpointer self)
{
	_files_app_menu___lambda153_ (self);
}

static GObject *
files_app_menu_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesAppMenu * self;
	Block54Data* _data54_;
	GtkApplication* app_instance = NULL;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gchar* _tmp2_;
	GVariant* _tmp3_;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkApplication* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GVariant* _tmp13_;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_;
	GtkApplication* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GVariant* _tmp23_;
	GtkButton* _tmp24_ = NULL;
	GtkButton* _tmp25_;
	GtkApplication* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkBox* icon_size_box = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkBox* _tmp33_;
	GtkStyleContext* _tmp34_;
	GtkBox* _tmp35_;
	GtkButton* _tmp36_;
	GtkBox* _tmp37_;
	GtkButton* _tmp38_;
	GtkBox* _tmp39_;
	GtkButton* _tmp40_;
	GtkBox* undo_redo_box = NULL;
	GtkBox* _tmp41_ = NULL;
	GtkBox* _tmp42_;
	GtkStyleContext* _tmp43_;
	gchar* _tmp44_;
	GtkButton* _tmp45_ = NULL;
	gchar* _tmp46_;
	GtkButton* _tmp47_ = NULL;
	GtkBox* _tmp48_;
	GtkButton* _tmp49_;
	GtkBox* _tmp50_;
	GtkButton* _tmp51_;
	GtkApplication* _tmp52_;
	gchar** _tmp53_;
	gchar** _tmp54_;
	GtkApplication* _tmp55_;
	gchar** _tmp56_;
	gchar** _tmp57_;
	GraniteSwitchModelButton* double_click_button = NULL;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GraniteSwitchModelButton* _tmp60_ = NULL;
	GraniteSwitchModelButton* folders_before_files = NULL;
	gchar* _tmp61_;
	GraniteSwitchModelButton* _tmp62_ = NULL;
	GraniteSwitchModelButton* restore_tabs = NULL;
	gchar* _tmp63_;
	GraniteSwitchModelButton* _tmp64_ = NULL;
	GraniteHeaderLabel* show_header = NULL;
	GraniteHeaderLabel* _tmp65_;
	GtkCheckButton* show_hidden_button = NULL;
	gchar* _tmp66_;
	GtkCheckButton* _tmp67_ = NULL;
	GtkCheckButton* _tmp68_;
	GtkStyleContext* _tmp69_;
	GtkCheckButton* _tmp70_;
	GraniteAccelLabel* _tmp71_;
	GraniteAccelLabel* _tmp72_;
	GtkCheckButton* show_local_thumbnails = NULL;
	gchar* _tmp73_;
	GtkCheckButton* _tmp74_ = NULL;
	GtkCheckButton* _tmp75_;
	GtkStyleContext* _tmp76_;
	GtkCheckButton* show_remote_thumbnails = NULL;
	gchar* _tmp77_;
	GtkCheckButton* _tmp78_ = NULL;
	GtkCheckButton* _tmp79_;
	GtkStyleContext* _tmp80_;
	GraniteHeaderLabel* datetimeformat_header = NULL;
	GraniteHeaderLabel* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	GtkRadioButton* _tmp84_;
	GtkRadioButton* _tmp85_;
	GtkRadioButton* _tmp86_;
	GtkStyleContext* _tmp87_;
	GtkRadioButton* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	GtkRadioButton* _tmp91_;
	GtkRadioButton* _tmp92_;
	GtkRadioButton* _tmp93_;
	GtkStyleContext* _tmp94_;
	GtkRadioButton* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	GtkRadioButton* _tmp98_;
	GtkRadioButton* _tmp99_;
	GtkRadioButton* _tmp100_;
	GtkStyleContext* _tmp101_;
	GtkBox* menu_box = NULL;
	GtkBox* _tmp102_ = NULL;
	GtkBox* _tmp103_;
	GtkBox* _tmp104_;
	GtkBox* _tmp105_;
	GtkBox* _tmp106_;
	GtkBox* _tmp107_;
	GtkSeparator* _tmp108_ = NULL;
	GtkSeparator* _tmp109_;
	GtkBox* _tmp110_;
	GraniteSwitchModelButton* _tmp111_;
	GtkBox* _tmp112_;
	GraniteSwitchModelButton* _tmp113_;
	GtkBox* _tmp114_;
	GraniteSwitchModelButton* _tmp115_;
	GtkBox* _tmp116_;
	GtkSeparator* _tmp117_ = NULL;
	GtkSeparator* _tmp118_;
	GtkBox* _tmp119_;
	GraniteHeaderLabel* _tmp120_;
	GtkBox* _tmp121_;
	GtkCheckButton* _tmp122_;
	GtkBox* _tmp123_;
	GtkCheckButton* _tmp124_;
	GtkBox* _tmp125_;
	GtkCheckButton* _tmp126_;
	GtkBox* _tmp127_;
	GtkSeparator* _tmp128_ = NULL;
	GtkSeparator* _tmp129_;
	GtkBox* _tmp130_;
	GraniteHeaderLabel* _tmp131_;
	GtkBox* _tmp132_;
	GtkRadioButton* _tmp133_;
	GtkBox* _tmp134_;
	GtkRadioButton* _tmp135_;
	GtkBox* _tmp136_;
	GtkRadioButton* _tmp137_;
	GtkBox* _tmp138_;
	GtkBox* _tmp139_;
	FilesUndoManager* _tmp140_;
	FilesUndoManager* _tmp141_;
	GSettings* _tmp142_;
	GSettings* _tmp143_;
	GSettings* _tmp144_;
	GSettings* _tmp145_;
	GtkRadioButton* _tmp149_;
	GtkRadioButton* _tmp150_;
	GtkRadioButton* _tmp151_;
	parent_class = G_OBJECT_CLASS (files_app_menu_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_APP_MENU, FilesAppMenu);
	_data54_ = g_slice_new0 (Block54Data);
	_data54_->_ref_count_ = 1;
	_data54_->self = g_object_ref (self);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	app_instance = _tmp1_;
	_tmp2_ = g_strdup ("win.zoom");
	_tmp3_ = _variant_new18 ("ZOOM_OUT");
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-out-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp4_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_set ((GtkActionable*) _tmp4_, "action-target", _tmp3_, NULL);
	_g_variant_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->zoom_out_button);
	self->priv->zoom_out_button = _tmp4_;
	_tmp5_ = self->priv->zoom_out_button;
	_tmp6_ = app_instance;
	_tmp8_ = _tmp7_ = gtk_application_get_accels_for_action (_tmp6_, "win.zoom::ZOOM_OUT");
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _vala_array_length (_tmp7_);
	_tmp10_ = granite_markup_accel_tooltip (_tmp9_, (gint) _vala_array_length (_tmp7_), _ ("Zoom Out"));
	_tmp11_ = _tmp10_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp5_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("win.zoom");
	_tmp13_ = _variant_new19 ("ZOOM_NORMAL");
	_tmp14_ = (GtkButton*) gtk_button_new_with_label ("100%");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp14_, _tmp12_);
	_g_free0 (_tmp12_);
	g_object_set ((GtkActionable*) _tmp14_, "action-target", _tmp13_, NULL);
	_g_variant_unref0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->zoom_default_button);
	self->priv->zoom_default_button = _tmp14_;
	_tmp15_ = self->priv->zoom_default_button;
	_tmp16_ = app_instance;
	_tmp18_ = _tmp17_ = gtk_application_get_accels_for_action (_tmp16_, "win.zoom::ZOOM_NORMAL");
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _vala_array_length (_tmp17_);
	_tmp20_ = granite_markup_accel_tooltip (_tmp19_, (gint) _vala_array_length (_tmp17_), _ ("Zoom 1:1"));
	_tmp21_ = _tmp20_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp15_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = g_strdup ("win.zoom");
	_tmp23_ = _variant_new20 ("ZOOM_IN");
	_tmp24_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-in-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp24_, _tmp22_);
	_g_free0 (_tmp22_);
	g_object_set ((GtkActionable*) _tmp24_, "action-target", _tmp23_, NULL);
	_g_variant_unref0 (_tmp23_);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->zoom_in_button);
	self->priv->zoom_in_button = _tmp24_;
	_tmp25_ = self->priv->zoom_in_button;
	_tmp26_ = app_instance;
	_tmp28_ = _tmp27_ = gtk_application_get_accels_for_action (_tmp26_, "win.zoom::ZOOM_IN");
	_tmp29_ = _tmp28_;
	_tmp29__length1 = _vala_array_length (_tmp27_);
	_tmp30_ = granite_markup_accel_tooltip (_tmp29_, (gint) _vala_array_length (_tmp27_), _ ("Zoom In"));
	_tmp31_ = _tmp30_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp25_, _tmp31_);
	_g_free0 (_tmp31_);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp32_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp32_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp32_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp32_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp32_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp32_, 12);
	g_object_ref_sink (_tmp32_);
	icon_size_box = _tmp32_;
	_tmp33_ = icon_size_box;
	_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) _tmp33_);
	gtk_style_context_add_class (_tmp34_, GTK_STYLE_CLASS_LINKED);
	_tmp35_ = icon_size_box;
	_tmp36_ = self->priv->zoom_out_button;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = icon_size_box;
	_tmp38_ = self->priv->zoom_default_button;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = icon_size_box;
	_tmp40_ = self->priv->zoom_in_button;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp41_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp41_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp41_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp41_, 12);
	g_object_ref_sink (_tmp41_);
	undo_redo_box = _tmp41_;
	_tmp42_ = undo_redo_box;
	_tmp43_ = gtk_widget_get_style_context ((GtkWidget*) _tmp42_);
	gtk_style_context_add_class (_tmp43_, GTK_STYLE_CLASS_LINKED);
	_tmp44_ = g_strdup ("win.undo");
	_tmp45_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp45_, _tmp44_);
	_g_free0 (_tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->undo_button);
	self->priv->undo_button = _tmp45_;
	_tmp46_ = g_strdup ("win.redo");
	_tmp47_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-redo-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp47_, _tmp46_);
	_g_free0 (_tmp46_);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->redo_button);
	self->priv->redo_button = _tmp47_;
	_tmp48_ = undo_redo_box;
	_tmp49_ = self->priv->undo_button;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = undo_redo_box;
	_tmp51_ = self->priv->redo_button;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = app_instance;
	_tmp54_ = _tmp53_ = gtk_application_get_accels_for_action (_tmp52_, "win.undo");
	self->priv->undo_accels = (_vala_array_free (self->priv->undo_accels, self->priv->undo_accels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_accels = _tmp54_;
	self->priv->undo_accels_length1 = _vala_array_length (_tmp53_);
	self->priv->_undo_accels_size_ = self->priv->undo_accels_length1;
	_tmp55_ = app_instance;
	_tmp57_ = _tmp56_ = gtk_application_get_accels_for_action (_tmp55_, "win.redo");
	self->priv->redo_accels = (_vala_array_free (self->priv->redo_accels, self->priv->redo_accels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->redo_accels = _tmp57_;
	self->priv->redo_accels_length1 = _vala_array_length (_tmp56_);
	self->priv->_redo_accels_size_ = self->priv->redo_accels_length1;
	_tmp58_ = g_strdup (_ ("Double-click on a folder opens it, single-click selects it"));
	_tmp59_ = g_strdup ("win.singleclick-select");
	_tmp60_ = granite_switch_model_button_new (_ ("Double-click to Navigate"));
	granite_switch_model_button_set_description (_tmp60_, _tmp58_);
	_g_free0 (_tmp58_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp60_, _tmp59_);
	_g_free0 (_tmp59_);
	g_object_ref_sink (_tmp60_);
	double_click_button = _tmp60_;
	_tmp61_ = g_strdup ("win.folders-before-files");
	_tmp62_ = granite_switch_model_button_new (_ ("Sort Folders before Files"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp62_, _tmp61_);
	_g_free0 (_tmp61_);
	g_object_ref_sink (_tmp62_);
	folders_before_files = _tmp62_;
	_tmp63_ = g_strdup ("win.restore-tabs-on-startup");
	_tmp64_ = granite_switch_model_button_new (_ ("Restore Tabs from Last Time"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp64_, _tmp63_);
	_g_free0 (_tmp63_);
	g_object_ref_sink (_tmp64_);
	restore_tabs = _tmp64_;
	_tmp65_ = granite_header_label_new (_ ("Show in View"));
	g_object_ref_sink (_tmp65_);
	show_header = _tmp65_;
	_tmp66_ = g_strdup ("win.show-hidden");
	_tmp67_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp67_, _tmp66_);
	_g_free0 (_tmp66_);
	g_object_ref_sink (_tmp67_);
	show_hidden_button = _tmp67_;
	_tmp68_ = show_hidden_button;
	_tmp69_ = gtk_widget_get_style_context ((GtkWidget*) _tmp68_);
	gtk_style_context_add_class (_tmp69_, GTK_STYLE_CLASS_MENUITEM);
	_tmp70_ = show_hidden_button;
	_tmp71_ = granite_accel_label_new (_ ("Hidden Files"), "<Ctrl>h");
	g_object_ref_sink (_tmp71_);
	_tmp72_ = _tmp71_;
	gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp72_);
	_g_object_unref0 (_tmp72_);
	_tmp73_ = g_strdup ("win.show-local-thumbnails");
	_tmp74_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Local Thumbnails"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp74_, _tmp73_);
	_g_free0 (_tmp73_);
	g_object_ref_sink (_tmp74_);
	show_local_thumbnails = _tmp74_;
	_tmp75_ = show_local_thumbnails;
	_tmp76_ = gtk_widget_get_style_context ((GtkWidget*) _tmp75_);
	gtk_style_context_add_class (_tmp76_, GTK_STYLE_CLASS_MENUITEM);
	_tmp77_ = g_strdup ("win.show-remote-thumbnails");
	_tmp78_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Remote Thumbnails"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp78_, _tmp77_);
	_g_free0 (_tmp77_);
	g_object_ref_sink (_tmp78_);
	show_remote_thumbnails = _tmp78_;
	_tmp79_ = show_remote_thumbnails;
	_tmp80_ = gtk_widget_get_style_context ((GtkWidget*) _tmp79_);
	gtk_style_context_add_class (_tmp80_, GTK_STYLE_CLASS_MENUITEM);
	_tmp81_ = granite_header_label_new (_ ("Date & Time Format"));
	g_object_ref_sink (_tmp81_);
	datetimeformat_header = _tmp81_;
	_tmp82_ = files_date_format_mode_to_string (FILES_DATE_FORMAT_MODE_ISO);
	_tmp83_ = _tmp82_;
	_tmp84_ = (GtkRadioButton*) gtk_radio_button_new_with_label (NULL, _tmp83_);
	g_object_ref_sink (_tmp84_);
	_tmp85_ = _tmp84_;
	_g_free0 (_tmp83_);
	_data54_->iso_button = _tmp85_;
	_tmp86_ = _data54_->iso_button;
	_tmp87_ = gtk_widget_get_style_context ((GtkWidget*) _tmp86_);
	gtk_style_context_add_class (_tmp87_, GTK_STYLE_CLASS_MENUITEM);
	_tmp88_ = _data54_->iso_button;
	_tmp89_ = files_date_format_mode_to_string (FILES_DATE_FORMAT_MODE_LOCALE);
	_tmp90_ = _tmp89_;
	_tmp91_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp88_, _tmp90_);
	g_object_ref_sink (_tmp91_);
	_tmp92_ = _tmp91_;
	_g_free0 (_tmp90_);
	_data54_->locale_button = _tmp92_;
	_tmp93_ = _data54_->locale_button;
	_tmp94_ = gtk_widget_get_style_context ((GtkWidget*) _tmp93_);
	gtk_style_context_add_class (_tmp94_, GTK_STYLE_CLASS_MENUITEM);
	_tmp95_ = _data54_->iso_button;
	_tmp96_ = files_date_format_mode_to_string (FILES_DATE_FORMAT_MODE_INFORMAL);
	_tmp97_ = _tmp96_;
	_tmp98_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp95_, _tmp97_);
	g_object_ref_sink (_tmp98_);
	_tmp99_ = _tmp98_;
	_g_free0 (_tmp97_);
	_data54_->informal_button = _tmp99_;
	_tmp100_ = _data54_->informal_button;
	_tmp101_ = gtk_widget_get_style_context ((GtkWidget*) _tmp100_);
	gtk_style_context_add_class (_tmp101_, GTK_STYLE_CLASS_MENUITEM);
	_tmp102_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp102_, 6);
	g_object_ref_sink (_tmp102_);
	menu_box = _tmp102_;
	_tmp103_ = menu_box;
	_tmp104_ = icon_size_box;
	gtk_container_add ((GtkContainer*) _tmp103_, (GtkWidget*) _tmp104_);
	_tmp105_ = menu_box;
	_tmp106_ = undo_redo_box;
	gtk_container_add ((GtkContainer*) _tmp105_, (GtkWidget*) _tmp106_);
	_tmp107_ = menu_box;
	_tmp108_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp108_, 3);
	g_object_ref_sink (_tmp108_);
	_tmp109_ = _tmp108_;
	gtk_container_add ((GtkContainer*) _tmp107_, (GtkWidget*) _tmp109_);
	_g_object_unref0 (_tmp109_);
	_tmp110_ = menu_box;
	_tmp111_ = double_click_button;
	gtk_container_add ((GtkContainer*) _tmp110_, (GtkWidget*) _tmp111_);
	_tmp112_ = menu_box;
	_tmp113_ = folders_before_files;
	gtk_container_add ((GtkContainer*) _tmp112_, (GtkWidget*) _tmp113_);
	_tmp114_ = menu_box;
	_tmp115_ = restore_tabs;
	gtk_container_add ((GtkContainer*) _tmp114_, (GtkWidget*) _tmp115_);
	_tmp116_ = menu_box;
	_tmp117_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp117_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp117_, 3);
	g_object_ref_sink (_tmp117_);
	_tmp118_ = _tmp117_;
	gtk_container_add ((GtkContainer*) _tmp116_, (GtkWidget*) _tmp118_);
	_g_object_unref0 (_tmp118_);
	_tmp119_ = menu_box;
	_tmp120_ = show_header;
	gtk_container_add ((GtkContainer*) _tmp119_, (GtkWidget*) _tmp120_);
	_tmp121_ = menu_box;
	_tmp122_ = show_hidden_button;
	gtk_container_add ((GtkContainer*) _tmp121_, (GtkWidget*) _tmp122_);
	_tmp123_ = menu_box;
	_tmp124_ = show_local_thumbnails;
	gtk_container_add ((GtkContainer*) _tmp123_, (GtkWidget*) _tmp124_);
	_tmp125_ = menu_box;
	_tmp126_ = show_remote_thumbnails;
	gtk_container_add ((GtkContainer*) _tmp125_, (GtkWidget*) _tmp126_);
	_tmp127_ = menu_box;
	_tmp128_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp128_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp128_, 3);
	g_object_ref_sink (_tmp128_);
	_tmp129_ = _tmp128_;
	gtk_container_add ((GtkContainer*) _tmp127_, (GtkWidget*) _tmp129_);
	_g_object_unref0 (_tmp129_);
	_tmp130_ = menu_box;
	_tmp131_ = datetimeformat_header;
	gtk_container_add ((GtkContainer*) _tmp130_, (GtkWidget*) _tmp131_);
	_tmp132_ = menu_box;
	_tmp133_ = _data54_->iso_button;
	gtk_container_add ((GtkContainer*) _tmp132_, (GtkWidget*) _tmp133_);
	_tmp134_ = menu_box;
	_tmp135_ = _data54_->locale_button;
	gtk_container_add ((GtkContainer*) _tmp134_, (GtkWidget*) _tmp135_);
	_tmp136_ = menu_box;
	_tmp137_ = _data54_->informal_button;
	gtk_container_add ((GtkContainer*) _tmp136_, (GtkWidget*) _tmp137_);
	_tmp138_ = menu_box;
	gtk_widget_show_all ((GtkWidget*) _tmp138_);
	_tmp139_ = menu_box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp139_, NULL);
	_tmp140_ = files_undo_manager_instance ();
	self->priv->undo_manager = _tmp140_;
	_tmp141_ = self->priv->undo_manager;
	g_signal_connect_object (_tmp141_, "request-menu-update", (GCallback) _files_app_menu_set_undo_redo_tooltips_files_undo_manager_request_menu_update, self, 0);
	files_app_menu_set_undo_redo_tooltips (self);
	_tmp142_ = files_icon_view_settings;
	g_signal_connect_object (_tmp142_, "changed::zoom-level", (GCallback) _files_app_menu_on_zoom_setting_changed_g_settings_changed, self, 0);
	_tmp143_ = files_list_view_settings;
	g_signal_connect_object (_tmp143_, "changed::zoom-level", (GCallback) _files_app_menu_on_zoom_setting_changed_g_settings_changed, self, 0);
	_tmp144_ = files_column_view_settings;
	g_signal_connect_object (_tmp144_, "changed::zoom-level", (GCallback) _files_app_menu_on_zoom_setting_changed_g_settings_changed, self, 0);
	_tmp145_ = files_app_settings;
	switch (g_settings_get_enum (_tmp145_, "date-format")) {
		case FILES_DATE_FORMAT_MODE_ISO:
		{
			GtkRadioButton* _tmp146_;
			_tmp146_ = _data54_->iso_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp146_, TRUE);
			break;
		}
		case FILES_DATE_FORMAT_MODE_LOCALE:
		{
			GtkRadioButton* _tmp147_;
			_tmp147_ = _data54_->locale_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp147_, TRUE);
			break;
		}
		case FILES_DATE_FORMAT_MODE_INFORMAL:
		{
			GtkRadioButton* _tmp148_;
			_tmp148_ = _data54_->informal_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp148_, TRUE);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp149_ = _data54_->iso_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp149_, "toggled", (GCallback) __files_app_menu___lambda151__gtk_toggle_button_toggled, block54_data_ref (_data54_), (GClosureNotify) block54_data_unref, 0);
	_tmp150_ = _data54_->locale_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp150_, "toggled", (GCallback) __files_app_menu___lambda152__gtk_toggle_button_toggled, block54_data_ref (_data54_), (GClosureNotify) block54_data_unref, 0);
	_tmp151_ = _data54_->informal_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp151_, "toggled", (GCallback) __files_app_menu___lambda153__gtk_toggle_button_toggled, block54_data_ref (_data54_), (GClosureNotify) block54_data_unref, 0);
	_g_object_unref0 (menu_box);
	_g_object_unref0 (datetimeformat_header);
	_g_object_unref0 (show_remote_thumbnails);
	_g_object_unref0 (show_local_thumbnails);
	_g_object_unref0 (show_hidden_button);
	_g_object_unref0 (show_header);
	_g_object_unref0 (restore_tabs);
	_g_object_unref0 (folders_before_files);
	_g_object_unref0 (double_click_button);
	_g_object_unref0 (undo_redo_box);
	_g_object_unref0 (icon_size_box);
	_g_object_unref0 (app_instance);
	block54_data_unref (_data54_);
	_data54_ = NULL;
	return obj;
}

static void
files_app_menu_class_init (FilesAppMenuClass * klass,
                           gpointer klass_data)
{
	files_app_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesAppMenu_private_offset);
	G_OBJECT_CLASS (klass)->constructor = files_app_menu_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_app_menu_finalize;
}

static void
files_app_menu_instance_init (FilesAppMenu * self,
                              gpointer klass)
{
	self->priv = files_app_menu_get_instance_private (self);
}

static void
files_app_menu_finalize (GObject * obj)
{
	FilesAppMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_APP_MENU, FilesAppMenu);
	_g_object_unref0 (self->priv->redo_button);
	_g_object_unref0 (self->priv->undo_button);
	_g_object_unref0 (self->priv->zoom_default_button);
	_g_object_unref0 (self->priv->zoom_in_button);
	_g_object_unref0 (self->priv->zoom_out_button);
	self->priv->redo_accels = (_vala_array_free (self->priv->redo_accels, self->priv->redo_accels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_accels = (_vala_array_free (self->priv->undo_accels, self->priv->undo_accels_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (files_app_menu_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_app_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesAppMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_app_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesAppMenu), 0, (GInstanceInitFunc) files_app_menu_instance_init, NULL };
	GType files_app_menu_type_id;
	files_app_menu_type_id = g_type_register_static (gtk_popover_get_type (), "FilesAppMenu", &g_define_type_info, 0);
	FilesAppMenu_private_offset = g_type_add_instance_private (files_app_menu_type_id, sizeof (FilesAppMenuPrivate));
	return files_app_menu_type_id;
}

GType
files_app_menu_get_type (void)
{
	static volatile gsize files_app_menu_type_id__once = 0;
	if (g_once_init_enter (&files_app_menu_type_id__once)) {
		GType files_app_menu_type_id;
		files_app_menu_type_id = files_app_menu_get_type_once ();
		g_once_init_leave (&files_app_menu_type_id__once, files_app_menu_type_id);
	}
	return files_app_menu_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

