/* PageChecker.c generated by valac 0.56.18, the Vala compiler
 * generated from PageChecker.vala, do not modify */

/*
 * Copyright (c) 2017-2019 elementary, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "slingshot.h"
#include <handy.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_WIDGETS_PAGE_CHECKER_0_PROPERTY,
	SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGINATOR_PROPERTY,
	SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGE_PROPERTY,
	SLINGSHOT_WIDGETS_PAGE_CHECKER_NUM_PROPERTIES
};
static GParamSpec* slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SlingshotWidgetsPageCheckerPrivate {
	HdyCarousel* _paginator;
	GtkWidget* _page;
	gint page_number;
};

static gint SlingshotWidgetsPageChecker_private_offset;
static gpointer slingshot_widgets_page_checker_parent_class = NULL;
static GtkCssProvider* slingshot_widgets_page_checker_provider;
static GtkCssProvider* slingshot_widgets_page_checker_provider = NULL;

static void slingshot_widgets_page_checker_update_opacity (SlingshotWidgetsPageChecker* self);
static GObject * slingshot_widgets_page_checker_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void _slingshot_widgets_page_checker___lambda47_ (SlingshotWidgetsPageChecker* self);
static void __slingshot_widgets_page_checker___lambda47__gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void _slingshot_widgets_page_checker___lambda48_ (SlingshotWidgetsPageChecker* self);
static void __slingshot_widgets_page_checker___lambda48__g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _slingshot_widgets_page_checker___lambda49_ (SlingshotWidgetsPageChecker* self);
static void __slingshot_widgets_page_checker___lambda49__gtk_widget_destroy (GtkWidget* _sender,
                                                                      gpointer self);
static void slingshot_widgets_page_checker_finalize (GObject * obj);
static GType slingshot_widgets_page_checker_get_type_once (void);
static void _vala_slingshot_widgets_page_checker_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_slingshot_widgets_page_checker_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

static inline gpointer
slingshot_widgets_page_checker_get_instance_private (SlingshotWidgetsPageChecker* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotWidgetsPageChecker_private_offset);
}

SlingshotWidgetsPageChecker*
slingshot_widgets_page_checker_construct (GType object_type,
                                          HdyCarousel* paginator,
                                          GtkWidget* page)
{
	SlingshotWidgetsPageChecker * self = NULL;
	g_return_val_if_fail (paginator != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	self = (SlingshotWidgetsPageChecker*) g_object_new (object_type, "paginator", paginator, "page", page, NULL);
	return self;
}

SlingshotWidgetsPageChecker*
slingshot_widgets_page_checker_new (HdyCarousel* paginator,
                                    GtkWidget* page)
{
	return slingshot_widgets_page_checker_construct (SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, paginator, page);
}

static void
slingshot_widgets_page_checker_update_opacity (SlingshotWidgetsPageChecker* self)
{
	gdouble progress = 0.0;
	HdyCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_paginator;
	_tmp1_ = hdy_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	progress = MAX (1 - fabs (_tmp2_ - self->priv->page_number), (gdouble) 0);
	gtk_widget_set_opacity ((GtkWidget*) self, SLINGSHOT_WIDGETS_PAGE_CHECKER_MIN_OPACITY + ((1 - SLINGSHOT_WIDGETS_PAGE_CHECKER_MIN_OPACITY) * progress));
}

HdyCarousel*
slingshot_widgets_page_checker_get_paginator (SlingshotWidgetsPageChecker* self)
{
	HdyCarousel* result;
	HdyCarousel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_paginator;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_page_checker_set_paginator (SlingshotWidgetsPageChecker* self,
                                              HdyCarousel* value)
{
	HdyCarousel* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_page_checker_get_paginator (self);
	if (old_value != value) {
		self->priv->_paginator = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGINATOR_PROPERTY]);
	}
}

GtkWidget*
slingshot_widgets_page_checker_get_page (SlingshotWidgetsPageChecker* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_page;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_page_checker_set_page (SlingshotWidgetsPageChecker* self,
                                         GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_page_checker_get_page (self);
	if (old_value != value) {
		self->priv->_page = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGE_PROPERTY]);
	}
}

static void
_slingshot_widgets_page_checker___lambda47_ (SlingshotWidgetsPageChecker* self)
{
	HdyCarousel* _tmp0_;
	GtkWidget* _tmp1_;
	_tmp0_ = self->priv->_paginator;
	_tmp1_ = self->priv->_page;
	hdy_carousel_scroll_to (_tmp0_, _tmp1_);
}

static void
__slingshot_widgets_page_checker___lambda47__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	_slingshot_widgets_page_checker___lambda47_ ((SlingshotWidgetsPageChecker*) self);
}

static void
_slingshot_widgets_page_checker___lambda48_ (SlingshotWidgetsPageChecker* self)
{
	slingshot_widgets_page_checker_update_opacity (self);
}

static void
__slingshot_widgets_page_checker___lambda48__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	_slingshot_widgets_page_checker___lambda48_ ((SlingshotWidgetsPageChecker*) self);
}

static void
_slingshot_widgets_page_checker___lambda49_ (SlingshotWidgetsPageChecker* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
__slingshot_widgets_page_checker___lambda49__gtk_widget_destroy (GtkWidget* _sender,
                                                                 gpointer self)
{
	_slingshot_widgets_page_checker___lambda49_ ((SlingshotWidgetsPageChecker*) self);
}

static GObject *
slingshot_widgets_page_checker_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotWidgetsPageChecker * self;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkCssProvider* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	HdyCarousel* _tmp7_;
	GList* _tmp8_;
	GList* _tmp9_;
	GtkWidget* _tmp10_;
	HdyCarousel* _tmp11_;
	GtkWidget* _tmp12_;
	parent_class = G_OBJECT_CLASS (slingshot_widgets_page_checker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, SlingshotWidgetsPageChecker);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	style_context = _tmp0_;
	_tmp1_ = style_context;
	gtk_style_context_add_class (_tmp1_, GTK_STYLE_CLASS_FLAT);
	_tmp2_ = style_context;
	gtk_style_context_add_class (_tmp2_, "switcher");
	_tmp3_ = style_context;
	_tmp4_ = slingshot_widgets_page_checker_provider;
	gtk_style_context_add_provider (_tmp3_, (GtkStyleProvider*) _tmp4_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("pager-checked-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->_paginator;
	_tmp8_ = gtk_container_get_children ((GtkContainer*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_page;
	self->priv->page_number = g_list_index (_tmp9_, _tmp10_);
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (g_list_free (_tmp9_), NULL));
	slingshot_widgets_page_checker_update_opacity (self);
	g_signal_connect_object ((GtkButton*) self, "clicked", (GCallback) __slingshot_widgets_page_checker___lambda47__gtk_button_clicked, self, 0);
	_tmp11_ = self->priv->_paginator;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::position", (GCallback) __slingshot_widgets_page_checker___lambda48__g_object_notify, self, 0);
	_tmp12_ = self->priv->_page;
	g_signal_connect_object (_tmp12_, "destroy", (GCallback) __slingshot_widgets_page_checker___lambda49__gtk_widget_destroy, self, 0);
	return obj;
}

static void
slingshot_widgets_page_checker_class_init (SlingshotWidgetsPageCheckerClass * klass,
                                           gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	slingshot_widgets_page_checker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotWidgetsPageChecker_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_widgets_page_checker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_widgets_page_checker_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_widgets_page_checker_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_widgets_page_checker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGINATOR_PROPERTY, slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGINATOR_PROPERTY] = g_param_spec_object ("paginator", "paginator", "paginator", hdy_carousel_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGE_PROPERTY, slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGE_PROPERTY] = g_param_spec_object ("page", "page", "page", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (slingshot_widgets_page_checker_provider);
	slingshot_widgets_page_checker_provider = _tmp0_;
	_tmp1_ = slingshot_widgets_page_checker_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/desktop/wingpanel/applications-menu/PageChecker.css");
}

static void
slingshot_widgets_page_checker_instance_init (SlingshotWidgetsPageChecker * self,
                                              gpointer klass)
{
	self->priv = slingshot_widgets_page_checker_get_instance_private (self);
}

static void
slingshot_widgets_page_checker_finalize (GObject * obj)
{
	SlingshotWidgetsPageChecker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, SlingshotWidgetsPageChecker);
	G_OBJECT_CLASS (slingshot_widgets_page_checker_parent_class)->finalize (obj);
}

static GType
slingshot_widgets_page_checker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotWidgetsPageCheckerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_widgets_page_checker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotWidgetsPageChecker), 0, (GInstanceInitFunc) slingshot_widgets_page_checker_instance_init, NULL };
	GType slingshot_widgets_page_checker_type_id;
	slingshot_widgets_page_checker_type_id = g_type_register_static (gtk_button_get_type (), "SlingshotWidgetsPageChecker", &g_define_type_info, 0);
	SlingshotWidgetsPageChecker_private_offset = g_type_add_instance_private (slingshot_widgets_page_checker_type_id, sizeof (SlingshotWidgetsPageCheckerPrivate));
	return slingshot_widgets_page_checker_type_id;
}

GType
slingshot_widgets_page_checker_get_type (void)
{
	static volatile gsize slingshot_widgets_page_checker_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_page_checker_type_id__once)) {
		GType slingshot_widgets_page_checker_type_id;
		slingshot_widgets_page_checker_type_id = slingshot_widgets_page_checker_get_type_once ();
		g_once_init_leave (&slingshot_widgets_page_checker_type_id__once, slingshot_widgets_page_checker_type_id);
	}
	return slingshot_widgets_page_checker_type_id__once;
}

static void
_vala_slingshot_widgets_page_checker_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	SlingshotWidgetsPageChecker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, SlingshotWidgetsPageChecker);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGINATOR_PROPERTY:
		g_value_set_object (value, slingshot_widgets_page_checker_get_paginator (self));
		break;
		case SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGE_PROPERTY:
		g_value_set_object (value, slingshot_widgets_page_checker_get_page (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_widgets_page_checker_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	SlingshotWidgetsPageChecker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, SlingshotWidgetsPageChecker);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGINATOR_PROPERTY:
		slingshot_widgets_page_checker_set_paginator (self, g_value_get_object (value));
		break;
		case SLINGSHOT_WIDGETS_PAGE_CHECKER_PAGE_PROPERTY:
		slingshot_widgets_page_checker_set_page (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

