// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/kms/v1/ekm_service.proto

package kmspb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EkmService_ListEkmConnections_FullMethodName  = "/google.cloud.kms.v1.EkmService/ListEkmConnections"
	EkmService_GetEkmConnection_FullMethodName    = "/google.cloud.kms.v1.EkmService/GetEkmConnection"
	EkmService_CreateEkmConnection_FullMethodName = "/google.cloud.kms.v1.EkmService/CreateEkmConnection"
	EkmService_UpdateEkmConnection_FullMethodName = "/google.cloud.kms.v1.EkmService/UpdateEkmConnection"
	EkmService_GetEkmConfig_FullMethodName        = "/google.cloud.kms.v1.EkmService/GetEkmConfig"
	EkmService_UpdateEkmConfig_FullMethodName     = "/google.cloud.kms.v1.EkmService/UpdateEkmConfig"
	EkmService_VerifyConnectivity_FullMethodName  = "/google.cloud.kms.v1.EkmService/VerifyConnectivity"
)

// EkmServiceClient is the client API for EkmService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EkmServiceClient interface {
	// Lists [EkmConnections][google.cloud.kms.v1.EkmConnection].
	ListEkmConnections(ctx context.Context, in *ListEkmConnectionsRequest, opts ...grpc.CallOption) (*ListEkmConnectionsResponse, error)
	// Returns metadata for a given
	// [EkmConnection][google.cloud.kms.v1.EkmConnection].
	GetEkmConnection(ctx context.Context, in *GetEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error)
	// Creates a new [EkmConnection][google.cloud.kms.v1.EkmConnection] in a given
	// Project and Location.
	CreateEkmConnection(ctx context.Context, in *CreateEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error)
	// Updates an [EkmConnection][google.cloud.kms.v1.EkmConnection]'s metadata.
	UpdateEkmConnection(ctx context.Context, in *UpdateEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error)
	// Returns the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
	// for a given project and location.
	GetEkmConfig(ctx context.Context, in *GetEkmConfigRequest, opts ...grpc.CallOption) (*EkmConfig, error)
	// Updates the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
	// for a given project and location.
	UpdateEkmConfig(ctx context.Context, in *UpdateEkmConfigRequest, opts ...grpc.CallOption) (*EkmConfig, error)
	// Verifies that Cloud KMS can successfully connect to the external key
	// manager specified by an [EkmConnection][google.cloud.kms.v1.EkmConnection].
	// If there is an error connecting to the EKM, this method returns a
	// FAILED_PRECONDITION status containing structured information as described
	// at https://cloud.google.com/kms/docs/reference/ekm_errors.
	VerifyConnectivity(ctx context.Context, in *VerifyConnectivityRequest, opts ...grpc.CallOption) (*VerifyConnectivityResponse, error)
}

type ekmServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEkmServiceClient(cc grpc.ClientConnInterface) EkmServiceClient {
	return &ekmServiceClient{cc}
}

func (c *ekmServiceClient) ListEkmConnections(ctx context.Context, in *ListEkmConnectionsRequest, opts ...grpc.CallOption) (*ListEkmConnectionsResponse, error) {
	out := new(ListEkmConnectionsResponse)
	err := c.cc.Invoke(ctx, EkmService_ListEkmConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) GetEkmConnection(ctx context.Context, in *GetEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error) {
	out := new(EkmConnection)
	err := c.cc.Invoke(ctx, EkmService_GetEkmConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) CreateEkmConnection(ctx context.Context, in *CreateEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error) {
	out := new(EkmConnection)
	err := c.cc.Invoke(ctx, EkmService_CreateEkmConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) UpdateEkmConnection(ctx context.Context, in *UpdateEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error) {
	out := new(EkmConnection)
	err := c.cc.Invoke(ctx, EkmService_UpdateEkmConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) GetEkmConfig(ctx context.Context, in *GetEkmConfigRequest, opts ...grpc.CallOption) (*EkmConfig, error) {
	out := new(EkmConfig)
	err := c.cc.Invoke(ctx, EkmService_GetEkmConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) UpdateEkmConfig(ctx context.Context, in *UpdateEkmConfigRequest, opts ...grpc.CallOption) (*EkmConfig, error) {
	out := new(EkmConfig)
	err := c.cc.Invoke(ctx, EkmService_UpdateEkmConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) VerifyConnectivity(ctx context.Context, in *VerifyConnectivityRequest, opts ...grpc.CallOption) (*VerifyConnectivityResponse, error) {
	out := new(VerifyConnectivityResponse)
	err := c.cc.Invoke(ctx, EkmService_VerifyConnectivity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EkmServiceServer is the server API for EkmService service.
// All implementations should embed UnimplementedEkmServiceServer
// for forward compatibility
type EkmServiceServer interface {
	// Lists [EkmConnections][google.cloud.kms.v1.EkmConnection].
	ListEkmConnections(context.Context, *ListEkmConnectionsRequest) (*ListEkmConnectionsResponse, error)
	// Returns metadata for a given
	// [EkmConnection][google.cloud.kms.v1.EkmConnection].
	GetEkmConnection(context.Context, *GetEkmConnectionRequest) (*EkmConnection, error)
	// Creates a new [EkmConnection][google.cloud.kms.v1.EkmConnection] in a given
	// Project and Location.
	CreateEkmConnection(context.Context, *CreateEkmConnectionRequest) (*EkmConnection, error)
	// Updates an [EkmConnection][google.cloud.kms.v1.EkmConnection]'s metadata.
	UpdateEkmConnection(context.Context, *UpdateEkmConnectionRequest) (*EkmConnection, error)
	// Returns the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
	// for a given project and location.
	GetEkmConfig(context.Context, *GetEkmConfigRequest) (*EkmConfig, error)
	// Updates the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
	// for a given project and location.
	UpdateEkmConfig(context.Context, *UpdateEkmConfigRequest) (*EkmConfig, error)
	// Verifies that Cloud KMS can successfully connect to the external key
	// manager specified by an [EkmConnection][google.cloud.kms.v1.EkmConnection].
	// If there is an error connecting to the EKM, this method returns a
	// FAILED_PRECONDITION status containing structured information as described
	// at https://cloud.google.com/kms/docs/reference/ekm_errors.
	VerifyConnectivity(context.Context, *VerifyConnectivityRequest) (*VerifyConnectivityResponse, error)
}

// UnimplementedEkmServiceServer should be embedded to have forward compatible implementations.
type UnimplementedEkmServiceServer struct {
}

func (UnimplementedEkmServiceServer) ListEkmConnections(context.Context, *ListEkmConnectionsRequest) (*ListEkmConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEkmConnections not implemented")
}
func (UnimplementedEkmServiceServer) GetEkmConnection(context.Context, *GetEkmConnectionRequest) (*EkmConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEkmConnection not implemented")
}
func (UnimplementedEkmServiceServer) CreateEkmConnection(context.Context, *CreateEkmConnectionRequest) (*EkmConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEkmConnection not implemented")
}
func (UnimplementedEkmServiceServer) UpdateEkmConnection(context.Context, *UpdateEkmConnectionRequest) (*EkmConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEkmConnection not implemented")
}
func (UnimplementedEkmServiceServer) GetEkmConfig(context.Context, *GetEkmConfigRequest) (*EkmConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEkmConfig not implemented")
}
func (UnimplementedEkmServiceServer) UpdateEkmConfig(context.Context, *UpdateEkmConfigRequest) (*EkmConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEkmConfig not implemented")
}
func (UnimplementedEkmServiceServer) VerifyConnectivity(context.Context, *VerifyConnectivityRequest) (*VerifyConnectivityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyConnectivity not implemented")
}

// UnsafeEkmServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EkmServiceServer will
// result in compilation errors.
type UnsafeEkmServiceServer interface {
	mustEmbedUnimplementedEkmServiceServer()
}

func RegisterEkmServiceServer(s grpc.ServiceRegistrar, srv EkmServiceServer) {
	s.RegisterService(&EkmService_ServiceDesc, srv)
}

func _EkmService_ListEkmConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEkmConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).ListEkmConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EkmService_ListEkmConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).ListEkmConnections(ctx, req.(*ListEkmConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_GetEkmConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEkmConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).GetEkmConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EkmService_GetEkmConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).GetEkmConnection(ctx, req.(*GetEkmConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_CreateEkmConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEkmConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).CreateEkmConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EkmService_CreateEkmConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).CreateEkmConnection(ctx, req.(*CreateEkmConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_UpdateEkmConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEkmConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).UpdateEkmConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EkmService_UpdateEkmConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).UpdateEkmConnection(ctx, req.(*UpdateEkmConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_GetEkmConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEkmConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).GetEkmConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EkmService_GetEkmConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).GetEkmConfig(ctx, req.(*GetEkmConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_UpdateEkmConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEkmConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).UpdateEkmConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EkmService_UpdateEkmConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).UpdateEkmConfig(ctx, req.(*UpdateEkmConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_VerifyConnectivity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyConnectivityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).VerifyConnectivity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EkmService_VerifyConnectivity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).VerifyConnectivity(ctx, req.(*VerifyConnectivityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EkmService_ServiceDesc is the grpc.ServiceDesc for EkmService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EkmService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.v1.EkmService",
	HandlerType: (*EkmServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEkmConnections",
			Handler:    _EkmService_ListEkmConnections_Handler,
		},
		{
			MethodName: "GetEkmConnection",
			Handler:    _EkmService_GetEkmConnection_Handler,
		},
		{
			MethodName: "CreateEkmConnection",
			Handler:    _EkmService_CreateEkmConnection_Handler,
		},
		{
			MethodName: "UpdateEkmConnection",
			Handler:    _EkmService_UpdateEkmConnection_Handler,
		},
		{
			MethodName: "GetEkmConfig",
			Handler:    _EkmService_GetEkmConfig_Handler,
		},
		{
			MethodName: "UpdateEkmConfig",
			Handler:    _EkmService_UpdateEkmConfig_Handler,
		},
		{
			MethodName: "VerifyConnectivity",
			Handler:    _EkmService_VerifyConnectivity_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/v1/ekm_service.proto",
}
