#pragma once

/**

 * @namespace onnxruntime::nv::provider_option_names
 * @details The `provider_option_names` namespace contains the following constants:
 * - `kDeviceId`: Specifies the GPU device ID to use.
 * - `kHasUserComputeStream`: Indicates whether a user-provided compute stream is used.
 * - `kUserComputeStream`: Specifies the user-provided compute stream.
 * - `kUserAuxStreamArray`: Specifies the user-provided aux stream.
 * - `kMaxWorkspaceSize`: Sets the maximum workspace size for GPU memory allocation.
 * - 'kMaxSharedMemSize': Sets the maximum amount of shared memory that TensorRT kernels are allowed to use
 * - `kLengthAuxStreamArray`: Specifies the length/size of the auxiliary streams array (kUserAuxStreamArray). Also sets the maximum number of auxiliary streams for TensorRT execution.
 * - `kDumpSubgraphs`: Enables or disables dumping of subgraphs for debugging.
 * - `kDetailedBuildLog`: Enables or disables detailed build logs for debugging.
 * - `kProfilesMinShapes`: Specifies the minimum shapes for profiling.
 * - `kProfilesMaxShapes`: Specifies the maximum shapes for profiling.
 * - `kProfilesOptShapes`: Specifies the optimal shapes for profiling.
 * - `kCudaGraphEnable`: Enables or disables CUDA graph optimizations.
 * - `kONNXBytestream`: Specifies the ONNX model as a bytestream.
 * - `kONNXBytestreamSize`: Specifies the size of the ONNX bytestream.
 */
namespace onnxruntime {
namespace nv {
namespace provider_option_names {
constexpr const char* kDeviceId = "device_id";
constexpr const char* kHasUserComputeStream = "has_user_compute_stream";
constexpr const char* kUserComputeStream = "user_compute_stream";
constexpr const char* kUserAuxStreamArray = "user_aux_stream_array";
constexpr const char* kMaxWorkspaceSize = "nv_max_workspace_size";
constexpr const char* kMaxSharedMemSize = "nv_max_shared_mem_size";
constexpr const char* kLengthAuxStreamArray = "nv_length_aux_stream_array";
constexpr const char* kDumpSubgraphs = "nv_dump_subgraphs";
constexpr const char* kDetailedBuildLog = "nv_detailed_build_log";
constexpr const char* kProfilesMinShapes = "nv_profile_min_shapes";
constexpr const char* kProfilesMaxShapes = "nv_profile_max_shapes";
constexpr const char* kProfilesOptShapes = "nv_profile_opt_shapes";
constexpr const char* kCudaGraphEnable = "enable_cuda_graph";
constexpr const char* kMultiProfileEnable = "nv_multi_profile_enable";
constexpr const char* kUseExternalDataInitializer = "nv_use_external_data_initializer";
constexpr const char* kRuntimeCacheFile = "nv_runtime_cache_path";

}  // namespace provider_option_names
namespace run_option_names {
constexpr const char* kProfileIndex = "nv_profile_index";
}
}  // namespace nv
}  // namespace onnxruntime
