/* Page.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Page.vala, do not modify */

/*
* Copyright (c) 2011-2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <sqlite3.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;
enum  {
	ENOTES_PAGE_0_PROPERTY,
	ENOTES_PAGE_NUM_PROPERTIES
};
static GParamSpec* enotes_page_properties[ENOTES_PAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define ENOTES_TYPE_PAGE_TABLE (enotes_page_table_get_type ())
#define ENOTES_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTable))
#define ENOTES_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))
#define ENOTES_IS_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_IS_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_PAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))

typedef struct _ENotesPageTable ENotesPageTable;
typedef struct _ENotesPageTableClass ENotesPageTableClass;
typedef struct _ENotesPageTablePrivate ENotesPageTablePrivate;

#define TYPE_BL_MEMBER (bl_member_get_type ())
#define BL_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BL_MEMBER, BLMember))
#define BL_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BL_MEMBER, BLMemberClass))
#define IS_BL_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BL_MEMBER))
#define IS_BL_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BL_MEMBER))
#define BL_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BL_MEMBER, BLMemberClass))

typedef struct _BLMember BLMember;
typedef struct _BLMemberClass BLMemberClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define ENOTES_TYPE_PLUGIN_MANAGER (enotes_plugin_manager_get_type ())
#define ENOTES_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PLUGIN_MANAGER, ENotesPluginManager))
#define ENOTES_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PLUGIN_MANAGER, ENotesPluginManagerClass))
#define ENOTES_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PLUGIN_MANAGER))
#define ENOTES_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PLUGIN_MANAGER))
#define ENOTES_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PLUGIN_MANAGER, ENotesPluginManagerClass))

typedef struct _ENotesPluginManager ENotesPluginManager;
typedef struct _ENotesPluginManagerClass ENotesPluginManagerClass;
#define _bl_member_unref0(var) ((var == NULL) ? NULL : (var = (bl_member_unref (var), NULL)))

#define ENOTES_TYPE_IMAGE_TABLE (enotes_image_table_get_type ())
#define ENOTES_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTable))
#define ENOTES_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))
#define ENOTES_IS_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IS_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IMAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))

typedef struct _ENotesImageTable ENotesImageTable;
typedef struct _ENotesImageTableClass ENotesImageTableClass;

#define ENOTES_TYPE_TAGS_TABLE (enotes_tags_table_get_type ())
#define ENOTES_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTable))
#define ENOTES_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))
#define ENOTES_IS_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_IS_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_TAGS_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))

typedef struct _ENotesTagsTable ENotesTagsTable;
typedef struct _ENotesTagsTableClass ENotesTagsTableClass;

#define ENOTES_TYPE_BOOKMARK_TABLE (enotes_bookmark_table_get_type ())
#define ENOTES_BOOKMARK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTable))
#define ENOTES_BOOKMARK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTableClass))
#define ENOTES_IS_BOOKMARK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_BOOKMARK_TABLE))
#define ENOTES_IS_BOOKMARK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_BOOKMARK_TABLE))
#define ENOTES_BOOKMARK_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTableClass))

typedef struct _ENotesBookmarkTable ENotesBookmarkTable;
typedef struct _ENotesBookmarkTableClass ENotesBookmarkTableClass;
typedef struct _BLMemberPrivate BLMemberPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	ENOTES_PAGE_TABLE_PAGE_SAVED_SIGNAL,
	ENOTES_PAGE_TABLE_NUM_SIGNALS
};
static guint enotes_page_table_signals[ENOTES_PAGE_TABLE_NUM_SIGNALS] = {0};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _ENotesPageTable {
	DatabaseTable parent_instance;
	ENotesPageTablePrivate * priv;
};

struct _ENotesPageTableClass {
	DatabaseTableClass parent_class;
};

struct _ENotesPageTablePrivate {
	GeeLinkedList* regex_complex_commands;
	BLMember** regex_simple_elements;
	gint regex_simple_elements_length1;
	gint _regex_simple_elements_size_;
	gboolean bold_state;
	gboolean italics_state;
};

struct _BLMember {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BLMemberPrivate * priv;
	GRegex* reg;
	gchar* replace;
};

struct _BLMemberClass {
	GTypeClass parent_class;
	void (*finalize) (BLMember *self);
};

static gpointer enotes_page_parent_class = NULL;
static gint ENotesPageTable_private_offset;
static gpointer enotes_page_table_parent_class = NULL;
static ENotesPageTable* enotes_page_table_instance;
static ENotesPageTable* enotes_page_table_instance = NULL;

VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN gboolean enotes_page_equals (ENotesPage* self,
                             ENotesPage* page);
VALA_EXTERN gchar* enotes_page_get_text (ENotesPage* self);
VALA_EXTERN ENotesPage* enotes_page_new (void);
VALA_EXTERN ENotesPage* enotes_page_construct (GType object_type);
static void enotes_page_finalize (GObject * obj);
static GType enotes_page_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_page_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPageTable, database_table_unref)
VALA_EXTERN gpointer bl_member_ref (gpointer instance);
VALA_EXTERN void bl_member_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_bl_member (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_bl_member (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_bl_member (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_bl_member (const GValue* value);
VALA_EXTERN GType bl_member_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BLMember, bl_member_unref)
VALA_EXTERN BLMember* bl_member_new (GRegex* reg,
                         const gchar* replace);
VALA_EXTERN BLMember* bl_member_construct (GType object_type,
                               GRegex* reg,
                               const gchar* replace);
VALA_EXTERN ENotesPageTable* enotes_page_table_get_instance (void);
static ENotesPageTable* enotes_page_table_new (void);
static ENotesPageTable* enotes_page_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN sqlite3_stmt* database_table_create_stmt (const gchar* data);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN GType enotes_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPluginManager, g_object_unref)
VALA_EXTERN ENotesPluginManager* enotes_plugin_manager_get_instance (void);
VALA_EXTERN GeeList* enotes_plugin_manager_get_all_blacklist_members (ENotesPluginManager* self);
VALA_EXTERN ENotesPage* enotes_page_table_get_page (ENotesPageTable* self,
                                        gint64 page_id);
VALA_EXTERN void database_table_bind_int (sqlite3_stmt* stmt,
                              gint column,
                              gint64 data);
VALA_EXTERN void enotes_page_table_save_page (ENotesPageTable* self,
                                  ENotesPage* page);
static void enotes_page_table_load_page_info (ENotesPageTable* self,
                                       ENotesPage* page);
VALA_EXTERN void database_table_bind_text (sqlite3_stmt* stmt,
                               gint column,
                               const gchar* data);
VALA_EXTERN void enotes_page_table_move_to_notebook (ENotesPageTable* self,
                                         ENotesPage* page,
                                         gint64 notebook);
VALA_EXTERN void enotes_page_table_clear_cache_on (ENotesPageTable* self,
                                       gint64 id);
VALA_EXTERN ENotesPage* enotes_page_table_new_page (ENotesPageTable* self,
                                        gint64 notebook_id);
VALA_EXTERN gint64 database_table_last_insert_row (DatabaseTable* self);
VALA_EXTERN GeeArrayList* enotes_page_table_get_pages (ENotesPageTable* self,
                                           gint64 notebook_id);
VALA_EXTERN GeeArrayList* enotes_page_table_get_all_pages (ENotesPageTable* self);
VALA_EXTERN void enotes_page_table_delete_page (ENotesPageTable* self,
                                    gint64 id);
VALA_EXTERN GType enotes_image_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesImageTable, database_table_unref)
VALA_EXTERN ENotesImageTable* enotes_image_table_get_instance (void);
VALA_EXTERN void enotes_image_table_delete_all_from_page (ENotesImageTable* self,
                                              gint64 page_id);
VALA_EXTERN GType enotes_tags_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTagsTable, database_table_unref)
VALA_EXTERN ENotesTagsTable* enotes_tags_table_get_instance (void);
VALA_EXTERN void enotes_tags_table_remove_tags_from_page (ENotesTagsTable* self,
                                              gint64 page_id);
VALA_EXTERN GType enotes_bookmark_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesBookmarkTable, database_table_unref)
VALA_EXTERN ENotesBookmarkTable* enotes_bookmark_table_get_instance (void);
VALA_EXTERN void enotes_bookmark_table_remove (ENotesBookmarkTable* self,
                                   gint64 page_id);
VALA_EXTERN gboolean enotes_page_table_is_bookmarked (ENotesPageTable* self);
static gchar* enotes_page_table_cleanup (ENotesPageTable* self,
                                  const gchar* line);
static gchar* enotes_page_table_convert (ENotesPageTable* self,
                                  const gchar* raw_content);
static gchar* enotes_page_table_replace (ENotesPageTable* self,
                                  const gchar* line_,
                                  const gchar* looking_for,
                                  const gchar* opening,
                                  const gchar* closing,
                                  gboolean* type_state);
VALA_EXTERN void enotes_page_table_reset_instance (void);
static void enotes_page_table_finalize (DatabaseTable * obj);
static GType enotes_page_table_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;
static GRegex* _tmp_regex_2 = NULL;
static GRegex* _tmp_regex_3 = NULL;

gboolean
enotes_page_equals (ENotesPage* self,
                    ENotesPage* page)
{
	gboolean result;
#line 37 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 37 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (page != NULL, FALSE);
#line 38 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = self->id == page->id;
#line 38 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 362 "Page.c"
}

gchar*
enotes_page_get_text (ENotesPage* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 41 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = self->data;
#line 42 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 42 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = _tmp1_;
#line 42 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 381 "Page.c"
}

ENotesPage*
enotes_page_construct (GType object_type)
{
	ENotesPage * self = NULL;
#line 22 "../Notes-up-2.0.6/src/Services/Page.vala"
	self = (ENotesPage*) g_object_new (object_type, NULL);
#line 22 "../Notes-up-2.0.6/src/Services/Page.vala"
	return self;
#line 392 "Page.c"
}

ENotesPage*
enotes_page_new (void)
{
#line 22 "../Notes-up-2.0.6/src/Services/Page.vala"
	return enotes_page_construct (ENOTES_TYPE_PAGE);
#line 400 "Page.c"
}

static void
enotes_page_class_init (ENotesPageClass * klass,
                        gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Services/Page.vala"
	enotes_page_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Services/Page.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_page_finalize;
#line 411 "Page.c"
}

static void
enotes_page_instance_init (ENotesPage * self,
                           gpointer klass)
{
	gchar* _tmp0_;
#line 23 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->id = (gint64) -1;
#line 24 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->notebook_id = (gint64) -1;
#line 31 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->new_page = FALSE;
#line 33 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->cache_changed = FALSE;
#line 35 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = g_strdup ("");
#line 35 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->full_path = _tmp0_;
#line 431 "Page.c"
}

static void
enotes_page_finalize (GObject * obj)
{
	ENotesPage * self;
#line 22 "../Notes-up-2.0.6/src/Services/Page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_PAGE, ENotesPage);
#line 25 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (self->name);
#line 26 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (self->data);
#line 27 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (self->subtitle);
#line 28 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (self->html_cache);
#line 35 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (self->full_path);
#line 22 "../Notes-up-2.0.6/src/Services/Page.vala"
	G_OBJECT_CLASS (enotes_page_parent_class)->finalize (obj);
#line 452 "Page.c"
}

static GType
enotes_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesPage), 0, (GInstanceInitFunc) enotes_page_instance_init, NULL };
	GType enotes_page_type_id;
	enotes_page_type_id = g_type_register_static (G_TYPE_OBJECT, "ENotesPage", &g_define_type_info, 0);
	return enotes_page_type_id;
}

GType
enotes_page_get_type (void)
{
	static volatile gsize enotes_page_type_id__once = 0;
	if (g_once_init_enter (&enotes_page_type_id__once)) {
		GType enotes_page_type_id;
		enotes_page_type_id = enotes_page_get_type_once ();
		g_once_init_leave (&enotes_page_type_id__once, enotes_page_type_id);
	}
	return enotes_page_type_id__once;
}

static inline gpointer
enotes_page_table_get_instance_private (ENotesPageTable* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesPageTable_private_offset);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (g_once_init_enter ((volatile gsize*) re)) {
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
#line 493 "Page.c"
	}
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	return *re;
#line 497 "Page.c"
}

static gpointer
_database_table_ref0 (gpointer self)
{
#line 64 "../Notes-up-2.0.6/src/Services/Page.vala"
	return self ? database_table_ref (self) : NULL;
#line 505 "Page.c"
}

ENotesPageTable*
enotes_page_table_get_instance (void)
{
	ENotesPageTable* _tmp0_;
	ENotesPageTable* _tmp2_;
	ENotesPageTable* _tmp3_;
	ENotesPageTable* result;
#line 60 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = enotes_page_table_instance;
#line 60 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (_tmp0_ == NULL) {
#line 519 "Page.c"
		ENotesPageTable* _tmp1_;
#line 61 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp1_ = enotes_page_table_new ();
#line 61 "../Notes-up-2.0.6/src/Services/Page.vala"
		_database_table_unref0 (enotes_page_table_instance);
#line 61 "../Notes-up-2.0.6/src/Services/Page.vala"
		enotes_page_table_instance = _tmp1_;
#line 527 "Page.c"
	}
#line 64 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = enotes_page_table_instance;
#line 64 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 64 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = _tmp3_;
#line 64 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 537 "Page.c"
}

static ENotesPageTable*
enotes_page_table_construct (GType object_type)
{
	ENotesPageTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	BLMember* link = NULL;
	BLMember* _tmp4_;
	BLMember* anchor = NULL;
	BLMember* _tmp5_;
	ENotesPluginManager* _tmp6_;
	ENotesPluginManager* _tmp7_;
	GeeList* _tmp8_;
	GeeLinkedList* _tmp9_;
	GeeLinkedList* _tmp10_;
#line 67 "../Notes-up-2.0.6/src/Services/Page.vala"
	self = (ENotesPageTable*) database_table_construct (object_type);
#line 68 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = database_table_create_stmt ("CREATE TABLE IF NOT EXISTS Page (" "id INTEGER PRIMARY KEY AUTOINCREMENT, " "name TEXT NOT NULL DEFAULT '', " "data TEXT NOT NULL DEFAULT '', " "subtitle TEXT NOT NULL DEFAULT '', " "html_cache TEXT NOT NULL DEFAULT '', " "creation_date INTEGER," "modification_date INTEGER," "notebook_id INTEGER)");
#line 68 "../Notes-up-2.0.6/src/Services/Page.vala"
	stmt = _tmp0_;
#line 77 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = stmt;
#line 77 "../Notes-up-2.0.6/src/Services/Page.vala"
	res = sqlite3_step (_tmp1_);
#line 79 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (res != SQLITE_DONE) {
#line 80 "../Notes-up-2.0.6/src/Services/Page.vala"
		database_table_fatal ("create page table", res);
#line 573 "Page.c"
	}
#line 83 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = database_table_create_stmt ("CREATE INDEX IF NOT EXISTS NotebookIDIndex ON Page (notebook_id)");
#line 83 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 83 "../Notes-up-2.0.6/src/Services/Page.vala"
	stmt = _tmp2_;
#line 85 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_ = stmt;
#line 85 "../Notes-up-2.0.6/src/Services/Page.vala"
	res = sqlite3_step (_tmp3_);
#line 86 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (res != SQLITE_DONE) {
#line 87 "../Notes-up-2.0.6/src/Services/Page.vala"
		database_table_fatal ("create page table", res);
#line 589 "Page.c"
	}
#line 90 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_set_table_name ((DatabaseTable*) self, "Page");
#line 94 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp4_ = bl_member_new (_thread_safe_regex_init (&_tmp_regex_2, "\\[[\\p{L}\\d_\\.\\?\\/:\\=\\+&\\-'\" ]*\\]\\([\\p{L}\\d_\\.\\?\\/:\\=\\+&\\-'\"]*\\)", 0), "");
#line 94 "../Notes-up-2.0.6/src/Services/Page.vala"
	link = _tmp4_;
#line 97 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp5_ = bl_member_new (_thread_safe_regex_init (&_tmp_regex_3, "\\[\\^\\d+\\]:?", 0), "");
#line 97 "../Notes-up-2.0.6/src/Services/Page.vala"
	anchor = _tmp5_;
#line 99 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp6_ = enotes_plugin_manager_get_instance ();
#line 99 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp7_ = _tmp6_;
#line 99 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp8_ = enotes_plugin_manager_get_all_blacklist_members (_tmp7_);
#line 99 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_object_unref0 (self->priv->regex_complex_commands);
#line 99 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->priv->regex_complex_commands = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_LINKED_LIST, GeeLinkedList);
#line 99 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_object_unref0 (_tmp7_);
#line 100 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp9_ = self->priv->regex_complex_commands;
#line 100 "../Notes-up-2.0.6/src/Services/Page.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, link);
#line 101 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp10_ = self->priv->regex_complex_commands;
#line 101 "../Notes-up-2.0.6/src/Services/Page.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, anchor);
#line 67 "../Notes-up-2.0.6/src/Services/Page.vala"
	_bl_member_unref0 (anchor);
#line 67 "../Notes-up-2.0.6/src/Services/Page.vala"
	_bl_member_unref0 (link);
#line 67 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 67 "../Notes-up-2.0.6/src/Services/Page.vala"
	return self;
#line 629 "Page.c"
}

static ENotesPageTable*
enotes_page_table_new (void)
{
#line 67 "../Notes-up-2.0.6/src/Services/Page.vala"
	return enotes_page_table_construct (ENOTES_TYPE_PAGE_TABLE);
#line 637 "Page.c"
}

ENotesPage*
enotes_page_table_get_page (ENotesPageTable* self,
                            gint64 page_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	ENotesPage* row = NULL;
	ENotesPage* _tmp3_;
	ENotesPage* _tmp4_;
	ENotesPage* _tmp5_;
	sqlite3_stmt* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	ENotesPage* _tmp9_;
	sqlite3_stmt* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	ENotesPage* _tmp13_;
	sqlite3_stmt* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	ENotesPage* _tmp17_;
	sqlite3_stmt* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	ENotesPage* _tmp21_;
	sqlite3_stmt* _tmp22_;
	ENotesPage* _tmp23_;
	sqlite3_stmt* _tmp24_;
	ENotesPage* _tmp25_;
	sqlite3_stmt* _tmp26_;
	ENotesPage* result;
#line 105 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 106 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = database_table_create_stmt ("SELECT name, data, subtitle, html_cache, creation_date, modification_d" \
"ate, " "notebook_id " "FROM Page WHERE id = ?");
#line 106 "../Notes-up-2.0.6/src/Services/Page.vala"
	stmt = _tmp0_;
#line 110 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = stmt;
#line 110 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_int (_tmp1_, 1, page_id);
#line 112 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = stmt;
#line 112 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (sqlite3_step (_tmp2_) != SQLITE_ROW) {
#line 113 "../Notes-up-2.0.6/src/Services/Page.vala"
		result = NULL;
#line 113 "../Notes-up-2.0.6/src/Services/Page.vala"
		_sqlite3_finalize0 (stmt);
#line 113 "../Notes-up-2.0.6/src/Services/Page.vala"
		return result;
#line 694 "Page.c"
	}
#line 115 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_ = enotes_page_new ();
#line 115 "../Notes-up-2.0.6/src/Services/Page.vala"
	row = _tmp3_;
#line 116 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp4_ = row;
#line 116 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp4_->id = page_id;
#line 117 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp5_ = row;
#line 117 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp6_ = stmt;
#line 117 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp7_ = (const gchar*) sqlite3_column_text (_tmp6_, 0);
#line 117 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 117 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (_tmp5_->name);
#line 117 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp5_->name = _tmp8_;
#line 118 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp9_ = row;
#line 118 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp10_ = stmt;
#line 118 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 1);
#line 118 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 118 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (_tmp9_->data);
#line 118 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp9_->data = _tmp12_;
#line 119 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp13_ = row;
#line 119 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp14_ = stmt;
#line 119 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp15_ = (const gchar*) sqlite3_column_text (_tmp14_, 2);
#line 119 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 119 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (_tmp13_->subtitle);
#line 119 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp13_->subtitle = _tmp16_;
#line 120 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp17_ = row;
#line 120 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp18_ = stmt;
#line 120 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp19_ = (const gchar*) sqlite3_column_text (_tmp18_, 3);
#line 120 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 120 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (_tmp17_->html_cache);
#line 120 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp17_->html_cache = _tmp20_;
#line 121 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp21_ = row;
#line 121 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp22_ = stmt;
#line 121 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp21_->creation_date = sqlite3_column_int64 (_tmp22_, 4);
#line 122 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp23_ = row;
#line 122 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp24_ = stmt;
#line 122 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp23_->modification_date = sqlite3_column_int64 (_tmp24_, 5);
#line 123 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp25_ = row;
#line 123 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp26_ = stmt;
#line 123 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp25_->notebook_id = sqlite3_column_int64 (_tmp26_, 6);
#line 125 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = row;
#line 125 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 125 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 776 "Page.c"
}

void
enotes_page_table_save_page (ENotesPageTable* self,
                             ENotesPage* page)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 128 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_if_fail (self != NULL);
#line 128 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_if_fail (page != NULL);
#line 129 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = database_table_create_stmt ("UPDATE Page SET name = ?, subtitle = ?, data = ?, html_cache = ?, modi" \
"fication_date = CAST(strftime('%s', 'now') AS INT) WHERE id = ?");
#line 129 "../Notes-up-2.0.6/src/Services/Page.vala"
	stmt = _tmp0_;
#line 130 "../Notes-up-2.0.6/src/Services/Page.vala"
	enotes_page_table_load_page_info (self, page);
#line 132 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = page->name;
#line 132 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_text (stmt, 1, _tmp1_);
#line 133 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = page->subtitle;
#line 133 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_text (stmt, 2, _tmp2_);
#line 134 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_ = page->data;
#line 134 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_text (stmt, 3, _tmp3_);
#line 135 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp4_ = page->html_cache;
#line 135 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_text (stmt, 4, _tmp4_);
#line 136 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_int (stmt, 5, page->id);
#line 137 "../Notes-up-2.0.6/src/Services/Page.vala"
	sqlite3_step (stmt);
#line 139 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_signal_emit (self, enotes_page_table_signals[ENOTES_PAGE_TABLE_PAGE_SAVED_SIGNAL], 0, page);
#line 128 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 823 "Page.c"
}

void
enotes_page_table_move_to_notebook (ENotesPageTable* self,
                                    ENotesPage* page,
                                    gint64 notebook)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
#line 142 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_if_fail (self != NULL);
#line 142 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_if_fail (page != NULL);
#line 143 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = database_table_create_stmt ("UPDATE Page SET notebook_id = ?, modification_date = CAST(strftime('%s" \
"', 'now') AS INT) WHERE id = ?");
#line 143 "../Notes-up-2.0.6/src/Services/Page.vala"
	stmt = _tmp0_;
#line 144 "../Notes-up-2.0.6/src/Services/Page.vala"
	enotes_page_table_load_page_info (self, page);
#line 146 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_int (stmt, 1, notebook);
#line 147 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_int (stmt, 2, page->id);
#line 148 "../Notes-up-2.0.6/src/Services/Page.vala"
	sqlite3_step (stmt);
#line 142 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 851 "Page.c"
}

void
enotes_page_table_clear_cache_on (ENotesPageTable* self,
                                  gint64 id)
{
	sqlite3_stmt* stmt = NULL;
	FILE* _tmp0_;
#line 152 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_if_fail (self != NULL);
#line 154 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = stderr;
#line 154 "../Notes-up-2.0.6/src/Services/Page.vala"
	fprintf (_tmp0_, "Clearing cache on: %d\n", (gint) id);
#line 155 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (id > ((gint64) 0)) {
#line 868 "Page.c"
		sqlite3_stmt* _tmp1_;
		sqlite3_stmt* _tmp2_;
		sqlite3_stmt* _tmp3_;
		sqlite3_stmt* _tmp4_;
#line 156 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp1_ = database_table_create_stmt ("UPDATE Page SET html_cache = ? WHERE notebook_id = ?");
#line 156 "../Notes-up-2.0.6/src/Services/Page.vala"
		_sqlite3_finalize0 (stmt);
#line 156 "../Notes-up-2.0.6/src/Services/Page.vala"
		stmt = _tmp1_;
#line 157 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp2_ = stmt;
#line 157 "../Notes-up-2.0.6/src/Services/Page.vala"
		database_table_bind_text (_tmp2_, 1, "");
#line 158 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp3_ = stmt;
#line 158 "../Notes-up-2.0.6/src/Services/Page.vala"
		database_table_bind_int (_tmp3_, 2, id);
#line 159 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp4_ = stmt;
#line 159 "../Notes-up-2.0.6/src/Services/Page.vala"
		sqlite3_step (_tmp4_);
#line 891 "Page.c"
	} else {
		sqlite3_stmt* _tmp5_;
		sqlite3_stmt* _tmp6_;
		sqlite3_stmt* _tmp7_;
#line 161 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp5_ = database_table_create_stmt ("UPDATE Page SET html_cache = ?");
#line 161 "../Notes-up-2.0.6/src/Services/Page.vala"
		_sqlite3_finalize0 (stmt);
#line 161 "../Notes-up-2.0.6/src/Services/Page.vala"
		stmt = _tmp5_;
#line 162 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp6_ = stmt;
#line 162 "../Notes-up-2.0.6/src/Services/Page.vala"
		database_table_bind_text (_tmp6_, 1, "");
#line 163 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp7_ = stmt;
#line 163 "../Notes-up-2.0.6/src/Services/Page.vala"
		sqlite3_step (_tmp7_);
#line 910 "Page.c"
	}
#line 152 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 914 "Page.c"
}

ENotesPage*
enotes_page_table_new_page (ENotesPageTable* self,
                            gint64 notebook_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	ENotesPage* _tmp1_;
	ENotesPage* result;
#line 167 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 168 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = database_table_create_stmt ("INSERT INTO Page (notebook_id, name, creation_date, modification_date)" \
" " "VALUES (?, ?, CAST(strftime('%s', 'now') AS INT), CAST(strftime('%s', " \
"'now') AS INT))");
#line 168 "../Notes-up-2.0.6/src/Services/Page.vala"
	stmt = _tmp0_;
#line 171 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_int (stmt, 1, notebook_id);
#line 172 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_text (stmt, 2, _ ("New Page"));
#line 174 "../Notes-up-2.0.6/src/Services/Page.vala"
	sqlite3_step (stmt);
#line 176 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = enotes_page_table_get_page (self, database_table_last_insert_row ((DatabaseTable*) self));
#line 176 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = _tmp1_;
#line 176 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 176 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 945 "Page.c"
}

GeeArrayList*
enotes_page_table_get_pages (ENotesPageTable* self,
                             gint64 notebook_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	GeeArrayList* pages = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* result;
#line 179 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 180 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = database_table_create_stmt ("SELECT id, name, subtitle, data FROM Page Where notebook_id = ?");
#line 180 "../Notes-up-2.0.6/src/Services/Page.vala"
	stmt = _tmp0_;
#line 181 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = stmt;
#line 181 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_int (_tmp1_, 1, notebook_id);
#line 183 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = gee_array_list_new (ENOTES_TYPE_PAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 183 "../Notes-up-2.0.6/src/Services/Page.vala"
	pages = _tmp2_;
#line 972 "Page.c"
	{
		gboolean _tmp3_ = FALSE;
#line 185 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp3_ = TRUE;
#line 185 "../Notes-up-2.0.6/src/Services/Page.vala"
		while (TRUE) {
#line 979 "Page.c"
			gint res = 0;
			sqlite3_stmt* _tmp4_;
			ENotesPage* row = NULL;
			ENotesPage* _tmp5_;
			ENotesPage* _tmp6_;
			sqlite3_stmt* _tmp7_;
			ENotesPage* _tmp8_;
			sqlite3_stmt* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			ENotesPage* _tmp12_;
			sqlite3_stmt* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			ENotesPage* _tmp16_;
			sqlite3_stmt* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			GeeArrayList* _tmp20_;
			ENotesPage* _tmp21_;
#line 185 "../Notes-up-2.0.6/src/Services/Page.vala"
			if (!_tmp3_) {
#line 1002 "Page.c"
			}
#line 185 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp3_ = FALSE;
#line 186 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp4_ = stmt;
#line 186 "../Notes-up-2.0.6/src/Services/Page.vala"
			res = sqlite3_step (_tmp4_);
#line 187 "../Notes-up-2.0.6/src/Services/Page.vala"
			if (res == SQLITE_DONE) {
#line 188 "../Notes-up-2.0.6/src/Services/Page.vala"
				break;
#line 1014 "Page.c"
			} else {
#line 189 "../Notes-up-2.0.6/src/Services/Page.vala"
				if (res != SQLITE_ROW) {
#line 190 "../Notes-up-2.0.6/src/Services/Page.vala"
					database_table_fatal ("get_notebooks", res);
#line 191 "../Notes-up-2.0.6/src/Services/Page.vala"
					break;
#line 1022 "Page.c"
				}
			}
#line 194 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp5_ = enotes_page_new ();
#line 194 "../Notes-up-2.0.6/src/Services/Page.vala"
			row = _tmp5_;
#line 196 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp6_ = row;
#line 196 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp7_ = stmt;
#line 196 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp6_->id = sqlite3_column_int64 (_tmp7_, 0);
#line 197 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp8_ = row;
#line 197 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp9_ = stmt;
#line 197 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp10_ = (const gchar*) sqlite3_column_text (_tmp9_, 1);
#line 197 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 197 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_free0 (_tmp8_->name);
#line 197 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp8_->name = _tmp11_;
#line 198 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp12_ = row;
#line 198 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp13_ = stmt;
#line 198 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp14_ = (const gchar*) sqlite3_column_text (_tmp13_, 2);
#line 198 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp15_ = g_strdup (_tmp14_);
#line 198 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_free0 (_tmp12_->subtitle);
#line 198 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp12_->subtitle = _tmp15_;
#line 199 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp16_ = row;
#line 199 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp17_ = stmt;
#line 199 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp18_ = (const gchar*) sqlite3_column_text (_tmp17_, 3);
#line 199 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp19_ = g_strdup (_tmp18_);
#line 199 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_free0 (_tmp16_->data);
#line 199 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp16_->data = _tmp19_;
#line 201 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp20_ = pages;
#line 201 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp21_ = row;
#line 201 "../Notes-up-2.0.6/src/Services/Page.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
#line 185 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_object_unref0 (row);
#line 1079 "Page.c"
		}
	}
#line 204 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = pages;
#line 204 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 204 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 1088 "Page.c"
}

GeeArrayList*
enotes_page_table_get_all_pages (ENotesPageTable* self)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeArrayList* pages = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
#line 207 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 208 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = database_table_create_stmt ("SELECT id, name, subtitle, data FROM Page");
#line 208 "../Notes-up-2.0.6/src/Services/Page.vala"
	stmt = _tmp0_;
#line 210 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = gee_array_list_new (ENOTES_TYPE_PAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 210 "../Notes-up-2.0.6/src/Services/Page.vala"
	pages = _tmp1_;
#line 1109 "Page.c"
	{
		gboolean _tmp2_ = FALSE;
#line 212 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp2_ = TRUE;
#line 212 "../Notes-up-2.0.6/src/Services/Page.vala"
		while (TRUE) {
#line 1116 "Page.c"
			gint res = 0;
			sqlite3_stmt* _tmp3_;
			ENotesPage* row = NULL;
			ENotesPage* _tmp4_;
			ENotesPage* _tmp5_;
			sqlite3_stmt* _tmp6_;
			ENotesPage* _tmp7_;
			sqlite3_stmt* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			ENotesPage* _tmp11_;
			sqlite3_stmt* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			ENotesPage* _tmp15_;
			sqlite3_stmt* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			GeeArrayList* _tmp19_;
			ENotesPage* _tmp20_;
#line 212 "../Notes-up-2.0.6/src/Services/Page.vala"
			if (!_tmp2_) {
#line 1139 "Page.c"
			}
#line 212 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp2_ = FALSE;
#line 213 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp3_ = stmt;
#line 213 "../Notes-up-2.0.6/src/Services/Page.vala"
			res = sqlite3_step (_tmp3_);
#line 214 "../Notes-up-2.0.6/src/Services/Page.vala"
			if (res == SQLITE_DONE) {
#line 215 "../Notes-up-2.0.6/src/Services/Page.vala"
				break;
#line 1151 "Page.c"
			} else {
#line 216 "../Notes-up-2.0.6/src/Services/Page.vala"
				if (res != SQLITE_ROW) {
#line 217 "../Notes-up-2.0.6/src/Services/Page.vala"
					database_table_fatal ("get_notebooks", res);
#line 218 "../Notes-up-2.0.6/src/Services/Page.vala"
					break;
#line 1159 "Page.c"
				}
			}
#line 221 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp4_ = enotes_page_new ();
#line 221 "../Notes-up-2.0.6/src/Services/Page.vala"
			row = _tmp4_;
#line 223 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp5_ = row;
#line 223 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp6_ = stmt;
#line 223 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp5_->id = sqlite3_column_int64 (_tmp6_, 0);
#line 224 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp7_ = row;
#line 224 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp8_ = stmt;
#line 224 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 1);
#line 224 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 224 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_free0 (_tmp7_->name);
#line 224 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp7_->name = _tmp10_;
#line 225 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp11_ = row;
#line 225 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp12_ = stmt;
#line 225 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 2);
#line 225 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp14_ = g_strdup (_tmp13_);
#line 225 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_free0 (_tmp11_->subtitle);
#line 225 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp11_->subtitle = _tmp14_;
#line 226 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp15_ = row;
#line 226 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp16_ = stmt;
#line 226 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp17_ = (const gchar*) sqlite3_column_text (_tmp16_, 3);
#line 226 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 226 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_free0 (_tmp15_->data);
#line 226 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp15_->data = _tmp18_;
#line 228 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp19_ = pages;
#line 228 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp20_ = row;
#line 228 "../Notes-up-2.0.6/src/Services/Page.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
#line 212 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_object_unref0 (row);
#line 1216 "Page.c"
		}
	}
#line 231 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = pages;
#line 231 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 231 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 1225 "Page.c"
}

void
enotes_page_table_delete_page (ENotesPageTable* self,
                               gint64 id)
{
	ENotesImageTable* _tmp0_;
	ENotesImageTable* _tmp1_;
	ENotesTagsTable* _tmp2_;
	ENotesTagsTable* _tmp3_;
	ENotesBookmarkTable* _tmp4_;
	ENotesBookmarkTable* _tmp5_;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp6_;
#line 234 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_if_fail (self != NULL);
#line 235 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = enotes_image_table_get_instance ();
#line 235 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = _tmp0_;
#line 235 "../Notes-up-2.0.6/src/Services/Page.vala"
	enotes_image_table_delete_all_from_page (_tmp1_, id);
#line 235 "../Notes-up-2.0.6/src/Services/Page.vala"
	_database_table_unref0 (_tmp1_);
#line 236 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = enotes_tags_table_get_instance ();
#line 236 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_ = _tmp2_;
#line 236 "../Notes-up-2.0.6/src/Services/Page.vala"
	enotes_tags_table_remove_tags_from_page (_tmp3_, id);
#line 236 "../Notes-up-2.0.6/src/Services/Page.vala"
	_database_table_unref0 (_tmp3_);
#line 237 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp4_ = enotes_bookmark_table_get_instance ();
#line 237 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp5_ = _tmp4_;
#line 237 "../Notes-up-2.0.6/src/Services/Page.vala"
	enotes_bookmark_table_remove (_tmp5_, id);
#line 237 "../Notes-up-2.0.6/src/Services/Page.vala"
	_database_table_unref0 (_tmp5_);
#line 239 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp6_ = database_table_create_stmt ("DELETE FROM Page WHERE id = ?");
#line 239 "../Notes-up-2.0.6/src/Services/Page.vala"
	stmt = _tmp6_;
#line 240 "../Notes-up-2.0.6/src/Services/Page.vala"
	database_table_bind_int (stmt, 1, id);
#line 242 "../Notes-up-2.0.6/src/Services/Page.vala"
	sqlite3_step (stmt);
#line 234 "../Notes-up-2.0.6/src/Services/Page.vala"
	_sqlite3_finalize0 (stmt);
#line 1276 "Page.c"
}

gboolean
enotes_page_table_is_bookmarked (ENotesPageTable* self)
{
	gboolean result;
#line 245 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 246 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = FALSE;
#line 246 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 1289 "Page.c"
}

static void
enotes_page_table_load_page_info (ENotesPageTable* self,
                                  ENotesPage* page)
{
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar* preview = NULL;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp18_;
#line 249 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_if_fail (self != NULL);
#line 249 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_if_fail (page != NULL);
#line 252 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = page->data;
#line 252 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "\n", 0);
#line 252 "../Notes-up-2.0.6/src/Services/Page.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 252 "../Notes-up-2.0.6/src/Services/Page.vala"
	lines = _tmp2_;
#line 252 "../Notes-up-2.0.6/src/Services/Page.vala"
	lines_length1 = _vala_array_length (_tmp1_);
#line 252 "../Notes-up-2.0.6/src/Services/Page.vala"
	_lines_size_ = lines_length1;
#line 253 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_ = g_strdup ("");
#line 253 "../Notes-up-2.0.6/src/Services/Page.vala"
	preview = _tmp3_;
#line 255 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp4_ = lines;
#line 255 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp4__length1 = lines_length1;
#line 255 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (_tmp4__length1 > 0) {
#line 1333 "Page.c"
		const gchar* _tmp5_;
#line 256 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp5_ = page->name;
#line 256 "../Notes-up-2.0.6/src/Services/Page.vala"
		if (g_strcmp0 (_tmp5_, _ ("New Page")) == 0) {
#line 1339 "Page.c"
			gchar** _tmp6_;
			gint _tmp6__length1;
			const gchar* _tmp7_;
			gchar* _tmp8_;
#line 257 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp6_ = lines;
#line 257 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp6__length1 = lines_length1;
#line 257 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp7_ = _tmp6_[0];
#line 257 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp8_ = enotes_page_table_cleanup (self, _tmp7_);
#line 257 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_free0 (page->name);
#line 257 "../Notes-up-2.0.6/src/Services/Page.vala"
			page->name = _tmp8_;
#line 1356 "Page.c"
		}
		{
			gint i = 0;
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
			i = 1;
#line 1362 "Page.c"
			{
				gboolean _tmp9_ = FALSE;
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp9_ = TRUE;
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
				while (TRUE) {
#line 1369 "Page.c"
					gchar** _tmp11_;
					gint _tmp11__length1;
					gchar** _tmp12_;
					gint _tmp12__length1;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
					if (!_tmp9_) {
#line 1379 "Page.c"
						gint _tmp10_;
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
						_tmp10_ = i;
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
						i = _tmp10_ + 1;
#line 1385 "Page.c"
					}
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp9_ = FALSE;
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp11_ = lines;
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp11__length1 = lines_length1;
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
					if (!(i < _tmp11__length1)) {
#line 260 "../Notes-up-2.0.6/src/Services/Page.vala"
						break;
#line 1397 "Page.c"
					}
#line 261 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp12_ = lines;
#line 261 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp12__length1 = lines_length1;
#line 261 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp13_ = _tmp12_[i];
#line 261 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp14_ = enotes_page_table_cleanup (self, _tmp13_);
#line 261 "../Notes-up-2.0.6/src/Services/Page.vala"
					_g_free0 (preview);
#line 261 "../Notes-up-2.0.6/src/Services/Page.vala"
					preview = _tmp14_;
#line 262 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp15_ = preview;
#line 262 "../Notes-up-2.0.6/src/Services/Page.vala"
					if (g_strcmp0 (_tmp15_, "") != 0) {
#line 263 "../Notes-up-2.0.6/src/Services/Page.vala"
						break;
#line 1417 "Page.c"
					}
				}
			}
		}
	} else {
		gchar** _tmp16_;
		gint _tmp16__length1;
#line 266 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp16_ = lines;
#line 266 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp16__length1 = lines_length1;
#line 266 "../Notes-up-2.0.6/src/Services/Page.vala"
		if (_tmp16__length1 == 0) {
#line 1431 "Page.c"
			gchar* _tmp17_;
#line 267 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp17_ = g_strdup (_ ("New Page"));
#line 267 "../Notes-up-2.0.6/src/Services/Page.vala"
			_g_free0 (page->name);
#line 267 "../Notes-up-2.0.6/src/Services/Page.vala"
			page->name = _tmp17_;
#line 1439 "Page.c"
		}
	}
#line 270 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp18_ = preview;
#line 270 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (_tmp18_ != NULL) {
#line 1446 "Page.c"
		const gchar* _tmp19_;
		gchar* _tmp20_;
#line 271 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp19_ = preview;
#line 271 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp20_ = enotes_page_table_convert (self, _tmp19_);
#line 271 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (page->subtitle);
#line 271 "../Notes-up-2.0.6/src/Services/Page.vala"
		page->subtitle = _tmp20_;
#line 1457 "Page.c"
	} else {
		gchar* _tmp21_;
#line 273 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp21_ = g_strdup ("");
#line 273 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (page->subtitle);
#line 273 "../Notes-up-2.0.6/src/Services/Page.vala"
		page->subtitle = _tmp21_;
#line 1466 "Page.c"
	}
#line 249 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (preview);
#line 249 "../Notes-up-2.0.6/src/Services/Page.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 1472 "Page.c"
}

static gpointer
_bl_member_ref0 (gpointer self)
{
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
	return self ? bl_member_ref (self) : NULL;
#line 1480 "Page.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1499 "Page.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1521 "Page.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1525 "Page.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1531 "Page.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1535 "Page.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1539 "Page.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1547 "Page.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1575 "Page.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1584 "Page.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1598 "Page.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1607 "Page.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1621 "Page.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1630 "Page.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1639 "Page.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 1656 "Page.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 1683 "Page.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 1689 "Page.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1695 "Page.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1699 "Page.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1707 "Page.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1711 "Page.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 1723 "Page.c"
}

static gchar*
enotes_page_table_cleanup (ENotesPageTable* self,
                           const gchar* line)
{
	gchar* output = NULL;
	gchar* _tmp0_;
	const gchar* _tmp29_;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 277 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 277 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 278 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = g_strdup (line);
#line 278 "../Notes-up-2.0.6/src/Services/Page.vala"
	output = _tmp0_;
#line 1747 "Page.c"
	{
		BLMember** _tmp17_;
		gint _tmp17__length1;
		{
			GeeLinkedList* _item_list = NULL;
			GeeLinkedList* _tmp1_;
			gint _item_size = 0;
			GeeLinkedList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _item_index = 0;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp1_ = self->priv->regex_complex_commands;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
			_item_list = _tmp1_;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp2_ = _item_list;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp4_ = _tmp3_;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
			_item_size = _tmp4_;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
			_item_index = -1;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
			while (TRUE) {
#line 1775 "Page.c"
				gint _tmp5_;
				gint _tmp6_;
				BLMember* item = NULL;
				GeeLinkedList* _tmp7_;
				gpointer _tmp8_;
				gchar* _tmp9_ = NULL;
				BLMember* _tmp10_;
				GRegex* _tmp11_;
				const gchar* _tmp12_;
				BLMember* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
				_item_index = _item_index + 1;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp5_ = _item_index;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp6_ = _item_size;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
					break;
#line 1799 "Page.c"
				}
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp7_ = _item_list;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _item_index);
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
				item = (BLMember*) _tmp8_;
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp10_ = item;
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp11_ = _tmp10_->reg;
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp12_ = output;
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp13_ = item;
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp14_ = _tmp13_->replace;
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp15_ = g_regex_replace (_tmp11_, _tmp12_, (gssize) -1, 0, _tmp14_, 0, &_inner_error0_);
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp9_ = _tmp15_;
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
					_bl_member_unref0 (item);
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
					if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1827 "Page.c"
						goto __catch0_g_regex_error;
					}
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
					_g_free0 (output);
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
					g_clear_error (&_inner_error0_);
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
					return NULL;
#line 1838 "Page.c"
				}
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp16_ = _tmp9_;
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp9_ = NULL;
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				_g_free0 (output);
#line 282 "../Notes-up-2.0.6/src/Services/Page.vala"
				output = _tmp16_;
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
				_g_free0 (_tmp9_);
#line 281 "../Notes-up-2.0.6/src/Services/Page.vala"
				_bl_member_unref0 (item);
#line 1852 "Page.c"
			}
		}
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp17_ = self->priv->regex_simple_elements;
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp17__length1 = self->priv->regex_simple_elements_length1;
#line 1859 "Page.c"
		{
			BLMember** item_collection = NULL;
			gint item_collection_length1 = 0;
			gint _item_collection_size_ = 0;
			gint item_it = 0;
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
			item_collection = _tmp17_;
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
			item_collection_length1 = _tmp17__length1;
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
			for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
#line 1871 "Page.c"
				BLMember* _tmp18_;
				BLMember* item = NULL;
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp18_ = _bl_member_ref0 (item_collection[item_it]);
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
				item = _tmp18_;
#line 1878 "Page.c"
				{
					gchar* _tmp19_ = NULL;
					BLMember* _tmp20_;
					GRegex* _tmp21_;
					const gchar* _tmp22_;
					BLMember* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp20_ = item;
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp21_ = _tmp20_->reg;
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp22_ = output;
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp23_ = item;
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp24_ = _tmp23_->replace;
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp25_ = g_regex_replace (_tmp21_, _tmp22_, (gssize) -1, 0, _tmp24_, 0, &_inner_error0_);
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp19_ = _tmp25_;
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
						_bl_member_unref0 (item);
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
						if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1908 "Page.c"
							goto __catch0_g_regex_error;
						}
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
						_g_free0 (output);
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
						g_clear_error (&_inner_error0_);
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
						return NULL;
#line 1919 "Page.c"
					}
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp26_ = _tmp19_;
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp19_ = NULL;
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					_g_free0 (output);
#line 286 "../Notes-up-2.0.6/src/Services/Page.vala"
					output = _tmp26_;
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
					_g_free0 (_tmp19_);
#line 285 "../Notes-up-2.0.6/src/Services/Page.vala"
					_bl_member_unref0 (item);
#line 1933 "Page.c"
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		gchar* _tmp27_;
#line 280 "../Notes-up-2.0.6/src/Services/Page.vala"
		g_clear_error (&_inner_error0_);
#line 289 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp27_ = g_strdup ("");
#line 289 "../Notes-up-2.0.6/src/Services/Page.vala"
		result = _tmp27_;
#line 289 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (output);
#line 289 "../Notes-up-2.0.6/src/Services/Page.vala"
		return result;
#line 1952 "Page.c"
	}
	__finally0:
#line 280 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 280 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (output);
#line 280 "../Notes-up-2.0.6/src/Services/Page.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 280 "../Notes-up-2.0.6/src/Services/Page.vala"
		g_clear_error (&_inner_error0_);
#line 280 "../Notes-up-2.0.6/src/Services/Page.vala"
		return NULL;
#line 1965 "Page.c"
	}
#line 292 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (string_contains (line, "---")) {
#line 1969 "Page.c"
		gchar* _tmp28_;
#line 292 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp28_ = g_strdup ("");
#line 292 "../Notes-up-2.0.6/src/Services/Page.vala"
		result = _tmp28_;
#line 292 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (output);
#line 292 "../Notes-up-2.0.6/src/Services/Page.vala"
		return result;
#line 1979 "Page.c"
	}
#line 294 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp29_ = output;
#line 294 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (string_contains (_tmp29_, "&")) {
#line 1985 "Page.c"
		const gchar* _tmp30_;
		gchar* _tmp31_;
#line 294 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp30_ = output;
#line 294 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp31_ = string_replace (_tmp30_, "&", "&amp;");
#line 294 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (output);
#line 294 "../Notes-up-2.0.6/src/Services/Page.vala"
		output = _tmp31_;
#line 1996 "Page.c"
	}
#line 296 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp33_ = output;
#line 296 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp34_ = strlen (_tmp33_);
#line 296 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp35_ = _tmp34_;
#line 296 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (_tmp35_ > 0) {
#line 2006 "Page.c"
		const gchar* _tmp36_;
#line 296 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp36_ = output;
#line 296 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp32_ = string_get (_tmp36_, (glong) 0) == ' ';
#line 2012 "Page.c"
	} else {
#line 296 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp32_ = FALSE;
#line 2016 "Page.c"
	}
#line 296 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (_tmp32_) {
#line 2020 "Page.c"
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gchar* _tmp41_;
#line 297 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp37_ = output;
#line 297 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp38_ = output;
#line 297 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp39_ = strlen (_tmp38_);
#line 297 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp40_ = _tmp39_;
#line 297 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp41_ = string_slice (_tmp37_, (glong) 1, (glong) _tmp40_);
#line 297 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (output);
#line 297 "../Notes-up-2.0.6/src/Services/Page.vala"
		output = _tmp41_;
#line 2040 "Page.c"
	}
#line 300 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = output;
#line 300 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 2046 "Page.c"
}

static gchar*
enotes_page_table_convert (ENotesPageTable* self,
                           const gchar* raw_content)
{
	gboolean _tmp0_ = FALSE;
	gchar* line = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp6_;
	const gchar* _tmp9_;
	gchar* result;
#line 305 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 305 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (raw_content != NULL, NULL);
#line 306 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->priv->bold_state = TRUE;
#line 307 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->priv->italics_state = TRUE;
#line 309 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (raw_content == NULL) {
#line 309 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp0_ = TRUE;
#line 2072 "Page.c"
	} else {
#line 309 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp0_ = g_strcmp0 (raw_content, "") == 0;
#line 2076 "Page.c"
	}
#line 309 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (_tmp0_) {
#line 2080 "Page.c"
		gchar* _tmp1_;
#line 309 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp1_ = g_strdup ("");
#line 309 "../Notes-up-2.0.6/src/Services/Page.vala"
		result = _tmp1_;
#line 309 "../Notes-up-2.0.6/src/Services/Page.vala"
		return result;
#line 2088 "Page.c"
	}
#line 311 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = g_strdup (raw_content);
#line 311 "../Notes-up-2.0.6/src/Services/Page.vala"
	line = _tmp2_;
#line 313 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_ = line;
#line 313 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (string_contains (_tmp3_, "	")) {
#line 2098 "Page.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 314 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp4_ = line;
#line 314 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp5_ = string_replace (_tmp4_, "	", "&nbsp;&nbsp;&nbsp;&nbsp;");
#line 314 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (line);
#line 314 "../Notes-up-2.0.6/src/Services/Page.vala"
		line = _tmp5_;
#line 2109 "Page.c"
	}
#line 317 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp6_ = line;
#line 317 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (string_contains (_tmp6_, "**")) {
#line 2115 "Page.c"
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 318 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp7_ = line;
#line 318 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp8_ = enotes_page_table_replace (self, _tmp7_, "**", "<b>", "</b>", &self->priv->bold_state);
#line 318 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (line);
#line 318 "../Notes-up-2.0.6/src/Services/Page.vala"
		line = _tmp8_;
#line 2126 "Page.c"
	}
#line 321 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp9_ = line;
#line 321 "../Notes-up-2.0.6/src/Services/Page.vala"
	if (string_contains (_tmp9_, "_")) {
#line 2132 "Page.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
#line 322 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp10_ = line;
#line 322 "../Notes-up-2.0.6/src/Services/Page.vala"
		_tmp11_ = enotes_page_table_replace (self, _tmp10_, "_", "<i>", "</i>", &self->priv->italics_state);
#line 322 "../Notes-up-2.0.6/src/Services/Page.vala"
		_g_free0 (line);
#line 322 "../Notes-up-2.0.6/src/Services/Page.vala"
		line = _tmp11_;
#line 2143 "Page.c"
	}
#line 325 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = line;
#line 325 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 2149 "Page.c"
}

static gchar*
enotes_page_table_replace (ENotesPageTable* self,
                           const gchar* line_,
                           const gchar* looking_for,
                           const gchar* opening,
                           const gchar* closing,
                           gboolean* type_state)
{
	gint chars = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint replace_size = 0;
	gint _tmp2_;
	gint _tmp3_;
	gchar* line = NULL;
	gchar* _tmp4_;
	GString* final = NULL;
	GString* _tmp5_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* result;
#line 328 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 328 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (line_ != NULL, NULL);
#line 328 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (looking_for != NULL, NULL);
#line 328 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (opening != NULL, NULL);
#line 328 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_return_val_if_fail (closing != NULL, NULL);
#line 329 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = strlen (line_);
#line 329 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = _tmp0_;
#line 329 "../Notes-up-2.0.6/src/Services/Page.vala"
	chars = _tmp1_;
#line 330 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = strlen (looking_for);
#line 330 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_ = _tmp2_;
#line 330 "../Notes-up-2.0.6/src/Services/Page.vala"
	replace_size = _tmp3_;
#line 331 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp4_ = g_strconcat (line_, "     ", NULL);
#line 331 "../Notes-up-2.0.6/src/Services/Page.vala"
	line = _tmp4_;
#line 333 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp5_ = g_string_new ("");
#line 333 "../Notes-up-2.0.6/src/Services/Page.vala"
	final = _tmp5_;
#line 2204 "Page.c"
	{
		gint i = 0;
#line 334 "../Notes-up-2.0.6/src/Services/Page.vala"
		i = 0;
#line 2209 "Page.c"
		{
			gboolean _tmp6_ = FALSE;
#line 334 "../Notes-up-2.0.6/src/Services/Page.vala"
			_tmp6_ = TRUE;
#line 334 "../Notes-up-2.0.6/src/Services/Page.vala"
			while (TRUE) {
#line 2216 "Page.c"
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
#line 334 "../Notes-up-2.0.6/src/Services/Page.vala"
				if (!_tmp6_) {
#line 2223 "Page.c"
					gint _tmp7_;
#line 334 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp7_ = i;
#line 334 "../Notes-up-2.0.6/src/Services/Page.vala"
					i = _tmp7_ + 1;
#line 2229 "Page.c"
				}
#line 334 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp6_ = FALSE;
#line 334 "../Notes-up-2.0.6/src/Services/Page.vala"
				if (!(i < chars)) {
#line 334 "../Notes-up-2.0.6/src/Services/Page.vala"
					break;
#line 2237 "Page.c"
				}
#line 335 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp8_ = line;
#line 335 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp9_ = string_slice (_tmp8_, (glong) i, (glong) (i + replace_size));
#line 335 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp10_ = _tmp9_;
#line 335 "../Notes-up-2.0.6/src/Services/Page.vala"
				_tmp11_ = g_strcmp0 (_tmp10_, looking_for) == 0;
#line 335 "../Notes-up-2.0.6/src/Services/Page.vala"
				_g_free0 (_tmp10_);
#line 335 "../Notes-up-2.0.6/src/Services/Page.vala"
				if (_tmp11_) {
#line 336 "../Notes-up-2.0.6/src/Services/Page.vala"
					if (*type_state) {
#line 2253 "Page.c"
						GString* _tmp12_;
#line 337 "../Notes-up-2.0.6/src/Services/Page.vala"
						*type_state = FALSE;
#line 338 "../Notes-up-2.0.6/src/Services/Page.vala"
						_tmp12_ = final;
#line 338 "../Notes-up-2.0.6/src/Services/Page.vala"
						g_string_append (_tmp12_, opening);
#line 2261 "Page.c"
					} else {
						GString* _tmp13_;
#line 340 "../Notes-up-2.0.6/src/Services/Page.vala"
						*type_state = TRUE;
#line 341 "../Notes-up-2.0.6/src/Services/Page.vala"
						_tmp13_ = final;
#line 341 "../Notes-up-2.0.6/src/Services/Page.vala"
						g_string_append (_tmp13_, closing);
#line 2270 "Page.c"
					}
#line 343 "../Notes-up-2.0.6/src/Services/Page.vala"
					i = (i + replace_size) - 1;
#line 2274 "Page.c"
				} else {
					GString* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
#line 346 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp14_ = final;
#line 346 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp15_ = line;
#line 346 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp16_ = string_slice (_tmp15_, (glong) i, (glong) (i + 1));
#line 346 "../Notes-up-2.0.6/src/Services/Page.vala"
					_tmp17_ = _tmp16_;
#line 346 "../Notes-up-2.0.6/src/Services/Page.vala"
					g_string_append (_tmp14_, _tmp17_);
#line 346 "../Notes-up-2.0.6/src/Services/Page.vala"
					_g_free0 (_tmp17_);
#line 2292 "Page.c"
				}
			}
		}
	}
#line 350 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp18_ = final;
#line 350 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp19_ = _tmp18_->str;
#line 350 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 350 "../Notes-up-2.0.6/src/Services/Page.vala"
	result = _tmp20_;
#line 350 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_string_free0 (final);
#line 350 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_free0 (line);
#line 350 "../Notes-up-2.0.6/src/Services/Page.vala"
	return result;
#line 2311 "Page.c"
}

void
enotes_page_table_reset_instance (void)
{
#line 354 "../Notes-up-2.0.6/src/Services/Page.vala"
	_database_table_unref0 (enotes_page_table_instance);
#line 354 "../Notes-up-2.0.6/src/Services/Page.vala"
	enotes_page_table_instance = NULL;
#line 2321 "Page.c"
}

static void
enotes_page_table_class_init (ENotesPageTableClass * klass,
                              gpointer klass_data)
{
#line 46 "../Notes-up-2.0.6/src/Services/Page.vala"
	enotes_page_table_parent_class = g_type_class_peek_parent (klass);
#line 46 "../Notes-up-2.0.6/src/Services/Page.vala"
	((DatabaseTableClass *) klass)->finalize = enotes_page_table_finalize;
#line 46 "../Notes-up-2.0.6/src/Services/Page.vala"
	g_type_class_adjust_private_offset (klass, &ENotesPageTable_private_offset);
#line 46 "../Notes-up-2.0.6/src/Services/Page.vala"
	enotes_page_table_signals[ENOTES_PAGE_TABLE_PAGE_SAVED_SIGNAL] = g_signal_new ("page-saved", ENOTES_TYPE_PAGE_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ENOTES_TYPE_PAGE);
#line 2336 "Page.c"
}

static void
enotes_page_table_instance_init (ENotesPageTable * self,
                                 gpointer klass)
{
	GeeLinkedList* _tmp0_;
	BLMember* _tmp1_;
	BLMember* _tmp2_;
	BLMember** _tmp3_;
#line 46 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->priv = enotes_page_table_get_instance_private (self);
#line 52 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp0_ = gee_linked_list_new (TYPE_BL_MEMBER, (GBoxedCopyFunc) bl_member_ref, (GDestroyNotify) bl_member_unref, NULL, NULL, NULL);
#line 52 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->priv->regex_complex_commands = _tmp0_;
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp1_ = bl_member_new (_thread_safe_regex_init (&_tmp_regex_0, "[#\\n\\t<>`]+", 0), "");
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp2_ = bl_member_new (_thread_safe_regex_init (&_tmp_regex_1, "<br>", 0), "");
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_ = g_new0 (BLMember*, 2 + 1);
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_[0] = _tmp1_;
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	_tmp3_[1] = _tmp2_;
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->priv->regex_simple_elements = _tmp3_;
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->priv->regex_simple_elements_length1 = 2;
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->priv->_regex_simple_elements_size_ = self->priv->regex_simple_elements_length1;
#line 2369 "Page.c"
}

static void
enotes_page_table_finalize (DatabaseTable * obj)
{
	ENotesPageTable * self;
#line 46 "../Notes-up-2.0.6/src/Services/Page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_PAGE_TABLE, ENotesPageTable);
#line 52 "../Notes-up-2.0.6/src/Services/Page.vala"
	_g_object_unref0 (self->priv->regex_complex_commands);
#line 57 "../Notes-up-2.0.6/src/Services/Page.vala"
	self->priv->regex_simple_elements = (_vala_array_free (self->priv->regex_simple_elements, self->priv->regex_simple_elements_length1, (GDestroyNotify) bl_member_unref), NULL);
#line 46 "../Notes-up-2.0.6/src/Services/Page.vala"
	DATABASE_TABLE_CLASS (enotes_page_table_parent_class)->finalize (obj);
#line 2384 "Page.c"
}

static GType
enotes_page_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesPageTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_page_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesPageTable), 0, (GInstanceInitFunc) enotes_page_table_instance_init, NULL };
	GType enotes_page_table_type_id;
	enotes_page_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "ENotesPageTable", &g_define_type_info, 0);
	ENotesPageTable_private_offset = g_type_add_instance_private (enotes_page_table_type_id, sizeof (ENotesPageTablePrivate));
	return enotes_page_table_type_id;
}

GType
enotes_page_table_get_type (void)
{
	static volatile gsize enotes_page_table_type_id__once = 0;
	if (g_once_init_enter (&enotes_page_table_type_id__once)) {
		GType enotes_page_table_type_id;
		enotes_page_table_type_id = enotes_page_table_get_type_once ();
		g_once_init_leave (&enotes_page_table_type_id__once, enotes_page_table_type_id);
	}
	return enotes_page_table_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

