/* SequenceNum.c generated by valac 0.56.18, the Vala compiler
 * generated from SequenceNum.vala, do not modify */

/*
* Copyright (c) 2024 (https://github.com/phase1geo/MosaicNote)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SEQUENCE_NUM_TYPE_NUM,
	SEQUENCE_NUM_TYPE_LETTER
} SequenceNumType;

#define TYPE_SEQUENCE_NUM_TYPE (sequence_num_type_get_type ())

#define TYPE_SEQUENCE_NUM (sequence_num_get_type ())
#define SEQUENCE_NUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEQUENCE_NUM, SequenceNum))
#define SEQUENCE_NUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEQUENCE_NUM, SequenceNumClass))
#define IS_SEQUENCE_NUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEQUENCE_NUM))
#define IS_SEQUENCE_NUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEQUENCE_NUM))
#define SEQUENCE_NUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEQUENCE_NUM, SequenceNumClass))

typedef struct _SequenceNum SequenceNum;
typedef struct _SequenceNumClass SequenceNumClass;
typedef struct _SequenceNumPrivate SequenceNumPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _ParamSpecSequenceNum ParamSpecSequenceNum;

struct _SequenceNum {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SequenceNumPrivate * priv;
};

struct _SequenceNumClass {
	GTypeClass parent_class;
	void (*finalize) (SequenceNum *self);
};

struct _SequenceNumPrivate {
	PangoLayout* _layout;
	gint _font_size;
	gdouble _width;
	gdouble _height;
	SequenceNumType _seq_type;
};

struct _ParamSpecSequenceNum {
	GParamSpec parent_instance;
};

static gint SequenceNum_private_offset;
static gpointer sequence_num_parent_class = NULL;

VALA_EXTERN GType sequence_num_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* sequence_num_type_to_string (SequenceNumType self,
                                    gint index);
VALA_EXTERN gpointer sequence_num_ref (gpointer instance);
VALA_EXTERN void sequence_num_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_sequence_num (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_sequence_num (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_sequence_num (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_sequence_num (const GValue* value);
VALA_EXTERN GType sequence_num_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SequenceNum, sequence_num_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN SequenceNum* sequence_num_new (DrawArea* da);
VALA_EXTERN SequenceNum* sequence_num_construct (GType object_type,
                                     DrawArea* da);
static void sequence_num_initialize_font (SequenceNum* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void sequence_num_set_font (SequenceNum* self,
                            const gchar* family,
                            gint* size,
                            gdouble zoom_factor);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static void sequence_num_update_size (SequenceNum* self);
VALA_EXTERN void sequence_num_set_num (SequenceNum* self,
                           gint index,
                           SequenceNumType type);
static void sequence_num_set_seq_type (SequenceNum* self,
                                SequenceNumType value);
static void sequence_num_set_width (SequenceNum* self,
                             gdouble value);
static void sequence_num_set_height (SequenceNum* self,
                              gdouble value);
VALA_EXTERN gdouble sequence_num_get_width (SequenceNum* self);
VALA_EXTERN gdouble sequence_num_get_height (SequenceNum* self);
VALA_EXTERN SequenceNumType sequence_num_get_seq_type (SequenceNum* self);
VALA_EXTERN PangoLayout* sequence_num_get_layout (SequenceNum* self);
static void sequence_num_finalize (SequenceNum * obj);
static GType sequence_num_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
sequence_num_type_to_string (SequenceNumType self,
                             gint index)
{
	gchar* result;
	switch (self) {
		case SEQUENCE_NUM_TYPE_NUM:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup_printf ("%d", index + 1);
			result = _tmp0_;
			return result;
		}
		case SEQUENCE_NUM_TYPE_LETTER:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup_printf ("%c", 'a' + index);
			result = _tmp1_;
			return result;
		}
		default:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("");
			result = _tmp2_;
			return result;
		}
	}
}

static GType
sequence_num_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SEQUENCE_NUM_TYPE_NUM, "SEQUENCE_NUM_TYPE_NUM", "num"}, {SEQUENCE_NUM_TYPE_LETTER, "SEQUENCE_NUM_TYPE_LETTER", "letter"}, {0, NULL, NULL}};
	GType sequence_num_type_type_id;
	sequence_num_type_type_id = g_enum_register_static ("SequenceNumType", values);
	return sequence_num_type_type_id;
}

GType
sequence_num_type_get_type (void)
{
	static volatile gsize sequence_num_type_type_id__once = 0;
	if (g_once_init_enter (&sequence_num_type_type_id__once)) {
		GType sequence_num_type_type_id;
		sequence_num_type_type_id = sequence_num_type_get_type_once ();
		g_once_init_leave (&sequence_num_type_type_id__once, sequence_num_type_type_id);
	}
	return sequence_num_type_type_id__once;
}

static inline gpointer
sequence_num_get_instance_private (SequenceNum* self)
{
	return G_STRUCT_MEMBER_P (self, SequenceNum_private_offset);
}

SequenceNum*
sequence_num_construct (GType object_type,
                        DrawArea* da)
{
	SequenceNum* self = NULL;
	PangoLayout* _tmp0_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (SequenceNum*) g_type_create_instance (object_type);
	_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) da, "1");
	_g_object_unref0 (self->priv->_layout);
	self->priv->_layout = _tmp0_;
	sequence_num_initialize_font (self);
	return self;
}

SequenceNum*
sequence_num_new (DrawArea* da)
{
	return sequence_num_construct (TYPE_SEQUENCE_NUM, da);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
sequence_num_initialize_font (SequenceNum* self)
{
	PangoFontDescription* fd = NULL;
	PangoFontDescription* _tmp0_;
	PangoLayout* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pango_font_description_new ();
	fd = _tmp0_;
	pango_font_description_set_size (fd, self->priv->_font_size * PANGO_SCALE);
	_tmp1_ = self->priv->_layout;
	pango_layout_set_font_description (_tmp1_, fd);
	__vala_PangoFontDescription_free0 (fd);
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

void
sequence_num_set_font (SequenceNum* self,
                       const gchar* family,
                       gint* size,
                       gdouble zoom_factor)
{
	PangoFontDescription* fd = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
	gint int_fsize = 0;
	PangoFontDescription* _tmp4_;
	PangoLayout* _tmp5_;
	PangoFontDescription* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_layout;
	_tmp1_ = pango_layout_get_font_description (_tmp0_);
	_tmp2_ = __vala_PangoFontDescription_copy0 (_tmp1_);
	fd = _tmp2_;
	if (family != NULL) {
		PangoFontDescription* _tmp3_;
		_tmp3_ = fd;
		pango_font_description_set_family (_tmp3_, family);
	}
	if (size != NULL) {
		self->priv->_font_size = *size;
	}
	int_fsize = (gint) ((self->priv->_font_size * zoom_factor) * PANGO_SCALE);
	_tmp4_ = fd;
	pango_font_description_set_size (_tmp4_, int_fsize);
	_tmp5_ = self->priv->_layout;
	_tmp6_ = fd;
	pango_layout_set_font_description (_tmp5_, _tmp6_);
	sequence_num_update_size (self);
	__vala_PangoFontDescription_free0 (fd);
}

void
sequence_num_set_num (SequenceNum* self,
                      gint index,
                      SequenceNumType type)
{
	gchar* numstr = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PangoAttrList* attr_list = NULL;
	PangoAttrList* _tmp4_;
	PangoAttribute* bold = NULL;
	PangoAttribute* _tmp5_;
	PangoAttribute* _tmp6_;
	PangoAttribute* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	PangoAttribute* _tmp10_;
	PangoLayout* _tmp11_;
	PangoLayout* _tmp12_;
	g_return_if_fail (self != NULL);
	sequence_num_set_seq_type (self, type);
	_tmp0_ = sequence_num_type_to_string (type, index);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s. ", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	numstr = _tmp3_;
	_tmp4_ = pango_attr_list_new ();
	attr_list = _tmp4_;
	_tmp5_ = pango_attr_weight_new (PANGO_WEIGHT_ULTRABOLD);
	bold = _tmp5_;
	_tmp6_ = bold;
	_tmp6_->start_index = (guint) 0;
	_tmp7_ = bold;
	_tmp8_ = strlen (numstr);
	_tmp9_ = _tmp8_;
	_tmp7_->end_index = (guint) _tmp9_;
	_tmp10_ = bold;
	bold = NULL;
	pango_attr_list_change (attr_list, _tmp10_);
	_tmp11_ = self->priv->_layout;
	pango_layout_set_text (_tmp11_, numstr, -1);
	_tmp12_ = self->priv->_layout;
	pango_layout_set_attributes (_tmp12_, attr_list);
	sequence_num_update_size (self);
	_pango_attribute_destroy0 (bold);
	_pango_attr_list_unref0 (attr_list);
	_g_free0 (numstr);
}

static void
sequence_num_update_size (SequenceNum* self)
{
	gint text_width = 0;
	gint text_height = 0;
	PangoLayout* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_layout;
	pango_layout_get_size (_tmp0_, &_tmp1_, &_tmp2_);
	text_width = _tmp1_;
	text_height = _tmp2_;
	sequence_num_set_width (self, (gdouble) (text_width / PANGO_SCALE));
	sequence_num_set_height (self, (gdouble) (text_height / PANGO_SCALE));
}

gdouble
sequence_num_get_width (SequenceNum* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_width;
	return result;
}

static void
sequence_num_set_width (SequenceNum* self,
                        gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_width = value;
}

gdouble
sequence_num_get_height (SequenceNum* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_height;
	return result;
}

static void
sequence_num_set_height (SequenceNum* self,
                         gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_height = value;
}

SequenceNumType
sequence_num_get_seq_type (SequenceNum* self)
{
	SequenceNumType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_seq_type;
	return result;
}

static void
sequence_num_set_seq_type (SequenceNum* self,
                           SequenceNumType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_seq_type = value;
}

PangoLayout*
sequence_num_get_layout (SequenceNum* self)
{
	PangoLayout* result;
	PangoLayout* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_layout;
	result = _tmp0_;
	return result;
}

static void
value_sequence_num_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_sequence_num_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		sequence_num_unref (value->data[0].v_pointer);
	}
}

static void
value_sequence_num_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sequence_num_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_sequence_num_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_sequence_num_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SequenceNum * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sequence_num_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_sequence_num_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	SequenceNum ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sequence_num_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_sequence_num (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecSequenceNum* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SEQUENCE_NUM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_sequence_num (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEQUENCE_NUM), NULL);
	return value->data[0].v_pointer;
}

void
value_set_sequence_num (GValue* value,
                        gpointer v_object)
{
	SequenceNum * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEQUENCE_NUM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEQUENCE_NUM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sequence_num_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sequence_num_unref (old);
	}
}

void
value_take_sequence_num (GValue* value,
                         gpointer v_object)
{
	SequenceNum * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEQUENCE_NUM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEQUENCE_NUM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sequence_num_unref (old);
	}
}

static void
sequence_num_class_init (SequenceNumClass * klass,
                         gpointer klass_data)
{
	sequence_num_parent_class = g_type_class_peek_parent (klass);
	((SequenceNumClass *) klass)->finalize = sequence_num_finalize;
	g_type_class_adjust_private_offset (klass, &SequenceNum_private_offset);
}

static void
sequence_num_instance_init (SequenceNum * self,
                            gpointer klass)
{
	self->priv = sequence_num_get_instance_private (self);
	self->priv->_font_size = 12;
	self->priv->_width = 0.0;
	self->priv->_height = 0.0;
	self->priv->_seq_type = SEQUENCE_NUM_TYPE_NUM;
	self->ref_count = 1;
}

static void
sequence_num_finalize (SequenceNum * obj)
{
	SequenceNum * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEQUENCE_NUM, SequenceNum);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_layout);
}

static GType
sequence_num_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_sequence_num_init, value_sequence_num_free_value, value_sequence_num_copy_value, value_sequence_num_peek_pointer, "p", value_sequence_num_collect_value, "p", value_sequence_num_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SequenceNumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sequence_num_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SequenceNum), 0, (GInstanceInitFunc) sequence_num_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType sequence_num_type_id;
	sequence_num_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SequenceNum", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SequenceNum_private_offset = g_type_add_instance_private (sequence_num_type_id, sizeof (SequenceNumPrivate));
	return sequence_num_type_id;
}

GType
sequence_num_get_type (void)
{
	static volatile gsize sequence_num_type_id__once = 0;
	if (g_once_init_enter (&sequence_num_type_id__once)) {
		GType sequence_num_type_id;
		sequence_num_type_id = sequence_num_get_type_once ();
		g_once_init_leave (&sequence_num_type_id__once, sequence_num_type_id);
	}
	return sequence_num_type_id__once;
}

gpointer
sequence_num_ref (gpointer instance)
{
	SequenceNum * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
sequence_num_unref (gpointer instance)
{
	SequenceNum * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SEQUENCE_NUM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

