/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* AMDGPUPreLegalizerCombinerImpl Combiner Match Table                        *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GICOMBINER_DEPS
#include "llvm/ADT/SparseBitVector.h"
namespace llvm {
extern cl::OptionCategory GICombinerOptionCategory;
} // end namespace llvm
#endif // ifdef GET_GICOMBINER_DEPS

#ifdef GET_GICOMBINER_TYPES
struct AMDGPUPreLegalizerCombinerImplRuleConfig {
  SparseBitVector<> DisabledRules;

  bool isRuleEnabled(unsigned RuleID) const;
  bool parseCommandLineOption();
  bool setRuleEnabled(StringRef RuleIdentifier);
  bool setRuleDisabled(StringRef RuleIdentifier);
};

static std::optional<uint64_t> getRuleIdxForIdentifier(StringRef RuleIdentifier) {
  uint64_t I;
  // getAtInteger(...) returns false on success
  bool Parsed = !RuleIdentifier.getAsInteger(0, I);
  if (Parsed)
    return I;

#ifndef NDEBUG
  switch (RuleIdentifier.size()) {
  default: break;
  case 9:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "opy_prop", 8) != 0)
        break;
      return 13;	 // "copy_prop"
    case 'm':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_ors", 7) != 0)
          break;
        return 198;	 // "match_ors"
      case 'u':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "lo_by_", 6) != 0)
          break;
        switch (RuleIdentifier[8]) {
        default: break;
        case '0':	 // 1 string to match.
          return 145;	 // "mulo_by_0"
        case '2':	 // 1 string to match.
          return 144;	 // "mulo_by_2"
        }
        break;
      }
      break;
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "neg_zext", 8) != 0)
        break;
      return 203;	 // "nneg_zext"
    }
    break;
  case 10:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2p_to_p2i", 9) != 0)
        break;
      return 89;	 // "i2p_to_p2i"
    case 'm':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_ands", 8) != 0)
          break;
        return 197;	 // "match_ands"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_to_shl", 8) != 0)
          break;
        return 14;	 // "mul_to_shl"
      }
      break;
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2i_to_i2p", 9) != 0)
        break;
      return 88;	 // "p2i_to_i2p"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "xt_trunc", 8) != 0)
          break;
        return 201;	 // "sext_trunc"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "b_to_add", 8) != 0)
          break;
        return 15;	 // "sub_to_add"
      }
      break;
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_trunc", 9) != 0)
        break;
      return 202;	 // "zext_trunc"
    }
    break;
  case 11:	 // 8 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dd_sub_reg", 10) != 0)
        break;
      return 94;	 // "add_sub_reg"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_addos", 10) != 0)
        break;
      return 217;	 // "match_addos"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ub_add_reg", 10) != 0)
        break;
      return 192;	 // "sub_add_reg"
    case 't':	 // 4 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_", 5) != 0)
        break;
      switch (RuleIdentifier[6]) {
      default: break;
      case 's':	 // 3 strings to match.
        switch (RuleIdentifier[7]) {
        default: break;
        case 'h':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+8, "ift", 3) != 0)
            break;
          return 132;	 // "trunc_shift"
        case 's':	 // 2 strings to match.
          if (memcmp(RuleIdentifier.data()+8, "at", 2) != 0)
            break;
          switch (RuleIdentifier[10]) {
          default: break;
          case 's':	 // 1 string to match.
            return 219;	 // "trunc_ssats"
          case 'u':	 // 1 string to match.
            return 220;	 // "trunc_ssatu"
          }
          break;
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+7, "satu", 4) != 0)
          break;
        return 221;	 // "trunc_usatu"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_cst", 10) != 0)
        break;
      return 211;	 // "unmerge_cst"
    }
    break;
  case 12:	 // 11 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "PlusBMinusB", 11) != 0)
        break;
      return 2;	 // "APlusBMinusB"
    case 'B':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "MinusAPlusA", 11) != 0)
        break;
      return 3;	 // "BMinusAPlusA"
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dde_to_addo", 11) != 0)
        break;
      return 146;	 // "adde_to_addo"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "sub_to_fneg", 11) != 0)
        break;
      return 194;	 // "fsub_to_fneg"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ulh_to_lshr", 11) != 0)
        break;
      return 174;	 // "mulh_to_lshr"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ot_cmp_fold", 11) != 0)
        break;
      return 133;	 // "not_cmp_fold"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_or", 11) != 0)
        break;
      return 128;	 // "redundant_or"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_pow2", 10) != 0)
          break;
        return 189;	 // "sdiv_by_pow2"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "xt_of_sext", 10) != 0)
          break;
        return 48;	 // "sext_of_sext"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "div_by_pow2", 11) != 0)
        break;
      return 188;	 // "udiv_by_pow2"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_zext", 11) != 0)
        break;
      return 46;	 // "zext_of_zext"
    }
    break;
  case 13:	 // 16 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dd_of_vscale", 12) != 0)
        break;
      return 37;	 // "add_of_vscale"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_shift", 12) != 0)
        break;
      return 164;	 // "commute_shift"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oldable_fneg", 12) != 0)
        break;
      return 226;	 // "foldable_fneg"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_and_mask", 12) != 0)
        break;
      return 69;	 // "load_and_mask"
    case 'm':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_selects", 11) != 0)
          break;
        return 125;	 // "match_selects"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "rge_unmerge", 11) != 0)
          break;
        return 210;	 // "merge_unmerge"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_of_vscale", 11) != 0)
          break;
        return 38;	 // "mul_of_vscale"
      }
      break;
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_and", 12) != 0)
        break;
      return 126;	 // "redundant_and"
    case 's':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_const", 11) != 0)
          break;
        return 191;	 // "sdiv_by_const"
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_of_vscale", 11) != 0)
          break;
        return 39;	 // "shl_of_vscale"
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_by_const", 11) != 0)
          break;
        return 187;	 // "srem_by_const"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "b_of_vscale", 11) != 0)
          break;
        return 40;	 // "sub_of_vscale"
      }
      break;
    case 'u':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_const", 11) != 0)
          break;
        return 190;	 // "udiv_by_const"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "merge_", 6) != 0)
          break;
        switch (RuleIdentifier[8]) {
        default: break;
        case 'm':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+9, "erge", 4) != 0)
            break;
          return 209;	 // "unmerge_merge"
        case 'u':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+9, "ndef", 4) != 0)
            break;
          return 212;	 // "unmerge_undef"
        }
        break;
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_by_const", 11) != 0)
          break;
        return 186;	 // "urem_by_const"
      }
      break;
    }
    break;
  case 14:	 // 15 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'M':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "inusC1PlusC2", 12) != 0)
          break;
        return 12;	 // "AMinusC1PlusC2"
      case 'P':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lusC1MinusC2", 12) != 0)
          break;
        return 8;	 // "APlusC1MinusC2"
      }
      break;
    case 'C':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2MinusAPlusC1", 13) != 0)
        break;
      return 9;	 // "C2MinusAPlusC1"
    case 'a':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_", 9) != 0)
        break;
      switch (RuleIdentifier[10]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 52;	 // "anyext_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 51;	 // "anyext_of_zext"
      }
      break;
    case 'b':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'i')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "op_same_val", 11) != 0)
          break;
        return 85;	 // "binop_same_val"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "reverse_shl", 11) != 0)
          break;
        return 162;	 // "bitreverse_shl"
      }
      break;
    case 'f':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "bs_fneg_fold", 12) != 0)
          break;
        return 173;	 // "fabs_fneg_fold"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "eg_fneg_fold", 12) != 0)
          break;
        return 91;	 // "fneg_fneg_fold"
      }
      break;
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ul_by_neg_one", 13) != 0)
        break;
      return 17;	 // "mul_by_neg_one"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eassoc_ptradd", 13) != 0)
        break;
      return 107;	 // "reassoc_ptradd"
    case 's':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 2 strings to match.
        switch (RuleIdentifier[2]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+3, "ect_of_zext", 11) != 0)
            break;
          return 54;	 // "select_of_zext"
        case 'x':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+3, "t_of_anyext", 11) != 0)
            break;
          return 49;	 // "sext_of_anyext"
        }
        break;
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ifts_too_big", 12) != 0)
          break;
        return 106;	 // "shifts_too_big"
      }
      break;
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_anyext", 13) != 0)
        break;
      return 47;	 // "zext_of_anyext"
    }
    break;
  case 15:	 // 12 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'M':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "inusC1MinusC2", 13) != 0)
          break;
        return 10;	 // "AMinusC1MinusC2"
      case 'P':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lusZeroMinusB", 13) != 0)
          break;
        return 1;	 // "APlusZeroMinusB"
      }
      break;
    case 'C':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "1Minus2MinusC2", 14) != 0)
        break;
      return 11;	 // "C1Minus2MinusC2"
    case 'Z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eroMinusAPlusB", 14) != 0)
        break;
      return 0;	 // "ZeroMinusAPlusB"
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itreverse_lshr", 14) != 0)
        break;
      return 163;	 // "bitreverse_lshr"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtending_loads", 14) != 0)
        break;
      return 68;	 // "extending_loads"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dempotent_prop", 14) != 0)
        break;
      return 18;	 // "idempotent_prop"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_or_combine", 14) != 0)
        break;
      return 153;	 // "load_or_combine"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_or", 14) != 0)
        break;
      return 62;	 // "narrow_binop_or"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "verlapping_and", 14) != 0)
        break;
      return 143;	 // "overlapping_and"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_same_val", 14) != 0)
        break;
      return 83;	 // "select_same_val"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_trunc_fold", 14) != 0)
        break;
      return 130;	 // "zext_trunc_fold"
    }
    break;
  case 16:	 // 13 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_anyext", 15) != 0)
        break;
      return 50;	 // "anyext_of_anyext"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "lamp_i64_to_i16", 15) != 0)
        break;
      return 225;	 // "clamp_i64_to_i16"
    case 'n':	 // 5 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_", 12) != 0)
        break;
      switch (RuleIdentifier[13]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (RuleIdentifier[14]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (RuleIdentifier[15] != 'd')
            break;
          return 58;	 // "narrow_binop_add"
        case 'n':	 // 1 string to match.
          if (RuleIdentifier[15] != 'd')
            break;
          return 61;	 // "narrow_binop_and"
        }
        break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "ul", 2) != 0)
          break;
        return 60;	 // "narrow_binop_mul"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "ub", 2) != 0)
          break;
        return 59;	 // "narrow_binop_sub"
      case 'x':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "or", 2) != 0)
          break;
        return 63;	 // "narrow_binop_xor"
      }
      break;
    case 's':	 // 3 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_", 6) != 0)
        break;
      switch (RuleIdentifier[7]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "f_anyext", 8) != 0)
          break;
        return 55;	 // "select_of_anyext"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "o_minmax", 8) != 0)
          break;
        return 193;	 // "select_to_minmax"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "ndef_cmp", 8) != 0)
          break;
        return 122;	 // "select_undef_cmp"
      }
      break;
    case 't':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_", 11) != 0)
        break;
      switch (RuleIdentifier[12]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 44;	 // "truncate_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 43;	 // "truncate_of_zext"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ndef_to_fp_zero", 15) != 0)
        break;
      return 71;	 // "undef_to_fp_zero"
    }
    break;
  case 17:	 // 14 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "PlusBMinus", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'A':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "plusC", 5) != 0)
          break;
        return 6;	 // "APlusBMinusAplusC"
      case 'C':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "PlusA", 5) != 0)
          break;
        return 7;	 // "APlusBMinusCPlusA"
      }
      break;
    case 'a':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "d_p2i_to_ptradd", 15) != 0)
          break;
        return 16;	 // "add_p2i_to_ptradd"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "yext_trunc_fold", 15) != 0)
          break;
        return 90;	 // "anyext_trunc_fold"
      }
      break;
    case 'c':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "nonicalize_", 11) != 0)
          break;
        switch (RuleIdentifier[13]) {
        default: break;
        case 'f':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "cmp", 3) != 0)
            break;
          return 111;	 // "canonicalize_fcmp"
        case 'i':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "cmp", 3) != 0)
            break;
          return 110;	 // "canonicalize_icmp"
        }
        break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "nstant_fold_fma", 15) != 0)
          break;
        return 171;	 // "constant_fold_fma"
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "iv_rem_to_divrem", 16) != 0)
        break;
      return 154;	 // "div_rem_to_divrem"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "rase_undef_store", 16) != 0)
        break;
      return 81;	 // "erase_undef_store"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "tr_add_with_zero", 16) != 0)
        break;
      return 150;	 // "ptr_add_with_zero"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lect_to_iminmax", 15) != 0)
          break;
        return 124;	 // "select_to_iminmax"
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ift_immed_chain", 15) != 0)
          break;
        return 151;	 // "shift_immed_chain"
      }
      break;
    case 'u':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "def_to_int_zero", 15) != 0)
          break;
        return 72;	 // "undef_to_int_zero"
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_pow2_to_mask", 15) != 0)
          break;
        return 129;	 // "urem_pow2_to_mask"
      }
      break;
    }
    break;
  case 18:	 // 11 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "MinusBPlus", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'B':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "MinusC", 6) != 0)
          break;
        return 5;	 // "AMinusBPlusBMinusC"
      case 'C':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "MinusA", 6) != 0)
          break;
        return 4;	 // "AMinusBPlusCMinusA"
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_to_zero", 17) != 0)
        break;
      return 86;	 // "binop_left_to_zero"
    case 'c':	 // 3 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_minmax_nan", 15) != 0)
          break;
        return 147;	 // "combine_minmax_nan"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_f", 12) != 0)
          break;
        switch (RuleIdentifier[15]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+16, "bs", 2) != 0)
            break;
          return 136;	 // "constant_fold_fabs"
        case 'n':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+16, "eg", 2) != 0)
            break;
          return 135;	 // "constant_fold_fneg"
        }
        break;
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xpand_const_fpowi", 17) != 0)
        break;
      return 148;	 // "expand_const_fpowi"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ptrunc_fpext_fold", 17) != 0)
        break;
      return 99;	 // "fptrunc_fpext_fold"
    case 's':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'e')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ect_of_truncate", 15) != 0)
          break;
        return 56;	 // "select_of_truncate"
      case 'x':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "t_inreg_of_load", 15) != 0)
          break;
        return 119;	 // "sext_inreg_of_load"
      }
      break;
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_anyext", 17) != 0)
        break;
      return 45;	 // "truncate_of_anyext"
    }
    break;
  case 19:	 // 15 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_to_zero", 18) != 0)
        break;
      return 87;	 // "binop_right_to_zero"
    case 'c':	 // 4 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "onst", 4) != 0)
        break;
      switch (RuleIdentifier[5]) {
      default: break;
      case '_':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+6, "ptradd_to_i2p", 13) != 0)
          break;
        return 142;	 // "const_ptradd_to_i2p"
      case 'a':	 // 3 strings to match.
        if (memcmp(RuleIdentifier.data()+6, "nt_fold_", 8) != 0)
          break;
        switch (RuleIdentifier[14]) {
        default: break;
        case 'b':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "inop", 4) != 0)
            break;
          return 169;	 // "constant_fold_binop"
        case 'f':	 // 2 strings to match.
          switch (RuleIdentifier[15]) {
          default: break;
          case 'l':	 // 1 string to match.
            if (memcmp(RuleIdentifier.data()+16, "og2", 3) != 0)
              break;
            return 138;	 // "constant_fold_flog2"
          case 's':	 // 1 string to match.
            if (memcmp(RuleIdentifier.data()+16, "qrt", 3) != 0)
              break;
            return 137;	 // "constant_fold_fsqrt"
          }
          break;
        }
        break;
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtend_through_phis", 18) != 0)
        break;
      return 103;	 // "extend_through_phis"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nteger_of_truncate", 18) != 0)
        break;
      return 64;	 // "integer_of_truncate"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_zero", 18) != 0)
        break;
      return 216;	 // "merge_of_x_and_zero"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "tr_add_immed_chain", 18) != 0)
        break;
      return 109;	 // "ptr_add_immed_chain"
    case 'r':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "assoc_comm_binops", 17) != 0)
          break;
        return 108;	 // "reassoc_comm_binops"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ght_identity_zero", 17) != 0)
          break;
        return 84;	 // "right_identity_zero"
      }
      break;
    case 's':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lect_constant_cmp", 17) != 0)
          break;
        return 123;	 // "select_constant_cmp"
      case 'i':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "mplify_", 7) != 0)
          break;
        switch (RuleIdentifier[9]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+10, "dd_to_sub", 9) != 0)
            break;
          return 104;	 // "simplify_add_to_sub"
        case 'n':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+10, "eg_minmax", 9) != 0)
            break;
          return 199;	 // "simplify_neg_minmax"
        }
        break;
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nary_undef_to_zero", 18) != 0)
        break;
      return 76;	 // "unary_undef_to_zero"
    }
    break;
  case 20:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nd_or_disjoint_mask", 19) != 0)
        break;
      return 176;	 // "and_or_disjoint_mask"
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itcast_bitcast_fold", 19) != 0)
        break;
      return 98;	 // "bitcast_bitcast_fold"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_undef", 19) != 0)
        break;
      return 215;	 // "merge_of_x_and_undef"
    case 'r':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "edu", 3) != 0)
        break;
      switch (RuleIdentifier[4]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+5, "e_shl_of_extend", 15) != 0)
          break;
        return 120;	 // "reduce_shl_of_extend"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+5, "dant_sext_inreg", 15) != 0)
          break;
        return 127;	 // "redundant_sext_inreg"
      }
      break;
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ry_undef_to_undef", 17) != 0)
          break;
        return 77;	 // "unary_undef_to_undef"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_zext_to_zext", 17) != 0)
          break;
        return 214;	 // "unmerge_zext_to_zext"
      }
      break;
    }
    break;
  case 21:	 // 8 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 3 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_concat_vector", 18) != 0)
          break;
        return 200;	 // "combine_concat_vector"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_", 11) != 0)
          break;
        switch (RuleIdentifier[14]) {
        default: break;
        case 'c':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "ast_op", 6) != 0)
            break;
          return 172;	 // "constant_fold_cast_op"
        case 'f':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "ptrunc", 6) != 0)
            break;
          return 139;	 // "constant_fold_fptrunc"
        }
        break;
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nsert_vector_elt_oob", 20) != 0)
        break;
      return 24;	 // "insert_vector_elt_oob"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "shr_of_trunc_of_lshr", 20) != 0)
        break;
      return 223;	 // "lshr_of_trunc_of_lshr"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_one_fp", 20) != 0)
        break;
      return 93;	 // "right_identity_one_fp"
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ef_to_negative_one", 18) != 0)
          break;
        return 73;	 // "undef_to_negative_one"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_dead_to_trunc", 18) != 0)
          break;
        return 213;	 // "unmerge_dead_to_trunc"
      }
      break;
    }
    break;
  case 22:	 // 13 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_shuffle_concat", 19) != 0)
          break;
        return 204;	 // "combine_shuffle_concat"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_fp_binop", 19) != 0)
          break;
        return 170;	 // "constant_fold_fp_binop"
      }
      break;
    case 'f':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ld_binop_into_select", 20) != 0)
          break;
        return 185;	 // "fold_binop_into_select"
      case 'u':	 // 3 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "nnel_shift_", 11) != 0)
          break;
        switch (RuleIdentifier[13]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "eft_zero", 8) != 0)
            break;
          return 158;	 // "funnel_shift_left_zero"
        case 'o':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "vershift", 8) != 0)
            break;
          return 159;	 // "funnel_shift_overshift"
        case 't':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "o_rotate", 8) != 0)
            break;
          return 156;	 // "funnel_shift_to_rotate"
        }
        break;
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "cmp_to_lhs_known_bits", 21) != 0)
        break;
      return 113;	 // "icmp_to_lhs_known_bits"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_subo_no_overflow", 21) != 0)
        break;
      return 218;	 // "match_subo_no_overflow"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_any_op", 21) != 0)
        break;
      return 78;	 // "propagate_undef_any_op"
    case 'r':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "dundant_neg_operands", 20) != 0)
          break;
        return 175;	 // "redundant_neg_operands"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ght_identity_one_int", 20) != 0)
          break;
        return 92;	 // "right_identity_one_int"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "hl_ashr_to_sext_inreg", 21) != 0)
        break;
      return 117;	 // "shl_ashr_to_sext_inreg"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_buildvector_fold", 21) != 0)
        break;
      return 96;	 // "trunc_buildvector_fold"
    }
    break;
  case 23:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "uildvector_of_truncate", 22) != 0)
        break;
      return 57;	 // "buildvector_of_truncate"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_right_zero", 22) != 0)
        break;
      return 157;	 // "funnel_shift_right_zero"
    case 'i':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "tof_const_zero_fold_", 20) != 0)
        break;
      switch (RuleIdentifier[21]) {
      default: break;
      case 's':	 // 1 string to match.
        if (RuleIdentifier[22] != 'i')
          break;
        return 140;	 // "itof_const_zero_fold_si"
      case 'u':	 // 1 string to match.
        if (RuleIdentifier[22] != 'i')
          break;
        return 141;	 // "itof_const_zero_fold_ui"
      }
      break;
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_all_ops", 22) != 0)
        break;
      return 79;	 // "propagate_undef_all_ops"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runcusatu_to_fptouisat", 22) != 0)
        break;
      return 222;	 // "truncusatu_to_fptouisat"
    }
    break;
  case 24:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_undef_to_zero", 23) != 0)
        break;
      return 74;	 // "binop_left_undef_to_zero"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element", 23) != 0)
        break;
      return 23;	 // "match_extract_of_element"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_feeding_and", 23) != 0)
        break;
      return 121;	 // "narrow_binop_feeding_and"
    case 's':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_inreg_", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "f_sext_inreg", 12) != 0)
          break;
        return 53;	 // "sext_inreg_of_sext_inreg"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "o_zext_inreg", 12) != 0)
          break;
        return 131;	 // "sext_inreg_to_zext_inreg"
      }
      break;
    case 'x':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "or_of_and_with_same_reg", 23) != 0)
        break;
      return 149;	 // "xor_of_and_with_same_reg"
    }
    break;
  case 25:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'i':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "tfield_extract_from_", 20) != 0)
          break;
        switch (RuleIdentifier[22]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "nd", 2) != 0)
            break;
          return 166;	 // "bitfield_extract_from_and"
        case 's':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "hr", 2) != 0)
            break;
          return 167;	 // "bitfield_extract_from_shr"
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ildvector_identity_fold", 23) != 0)
          break;
        return 95;	 // "buildvector_identity_fold"
      }
      break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_shuffle_undef_rhs", 24) != 0)
        break;
      return 205;	 // "combine_shuffle_undef_rhs"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vec_elt_build_vec", 24) != 0)
        break;
      return 66;	 // "extract_vec_elt_build_vec"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eg_and_one_to_sext_inreg", 24) != 0)
        break;
      return 118;	 // "neg_and_one_to_sext_inreg"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_one_fp", 24) != 0)
        break;
      return 102;	 // "right_identity_neg_one_fp"
    }
    break;
  case 26:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_undef_to_undef", 25) != 0)
        break;
      return 75;	 // "binop_right_undef_to_undef"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_fp_constant_to_rhs", 25) != 0)
        break;
      return 196;	 // "commute_fp_constant_to_rhs"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_from_or_shift", 25) != 0)
        break;
      return 155;	 // "funnel_shift_from_or_shift"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_zero_fp", 25) != 0)
        break;
      return 100;	 // "right_identity_neg_zero_fp"
    }
    break;
  case 27:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "om", 2) != 0)
        break;
      switch (RuleIdentifier[3]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ine_use_vector_truncate", 23) != 0)
          break;
        return 207;	 // "combine_use_vector_truncate"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ute_int_constant_to_rhs", 23) != 0)
          break;
        return 195;	 // "commute_int_constant_to_rhs"
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ouble_icmp_zero_or_combine", 26) != 0)
        break;
      return 115;	 // "double_icmp_zero_or_combine"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_binop_in_equality", 26) != 0)
        break;
      return 116;	 // "redundant_binop_in_equality"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_lshr_buildvector_fold", 26) != 0)
        break;
      return 97;	 // "trunc_lshr_buildvector_fold"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_anyext_build_vector", 26) != 0)
        break;
      return 208;	 // "unmerge_anyext_build_vector"
    }
    break;
  case 28:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_or_s64_with_s32_mask", 27) != 0)
        break;
      return 228;	 // "combine_or_s64_with_s32_mask"
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ouble_icmp_zero_and_combine", 27) != 0)
        break;
      return 114;	 // "double_icmp_zero_and_combine"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "pt_brcond_by_inverting_cond", 27) != 0)
        break;
      return 134;	 // "opt_brcond_by_inverting_cond"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_shuffle_mask", 27) != 0)
        break;
      return 80;	 // "propagate_undef_shuffle_mask"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "hift_of_shifted_logic_chain", 27) != 0)
        break;
      return 152;	 // "shift_of_shifted_logic_chain"
    }
    break;
  case 29:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itfield_extract_from_shr_and", 28) != 0)
        break;
      return 168;	 // "bitfield_extract_from_shr_and"
    case 'c':	 // 3 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_", 7) != 0)
        break;
      switch (RuleIdentifier[8]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "nd_s64_with_s32_mask", 20) != 0)
          break;
        return 229;	 // "combine_and_s64_with_s32_mask"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "xtracted_vector_load", 20) != 0)
          break;
        return 70;	 // "combine_extracted_vector_load"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "huffle_disjoint_mask", 20) != 0)
          break;
        return 206;	 // "combine_shuffle_disjoint_mask"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "cmp_to_true_false_known_bits", 28) != 0)
        break;
      return 112;	 // "icmp_to_true_false_known_bits"
    }
    break;
  case 30:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "reeze_of_non_undef_non_poison", 29) != 0)
        break;
      return 41;	 // "freeze_of_non_undef_non_poison"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_zero_fp_nsz", 29) != 0)
        break;
      return 101;	 // "right_identity_neg_zero_fp_nsz"
    }
    break;
  case 31:	 // 2 strings to match.
    if (memcmp(RuleIdentifier.data()+0, "insert_vector_element_", 22) != 0)
      break;
    switch (RuleIdentifier[22]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+23, "lt_undef", 8) != 0)
        break;
      return 22;	 // "insert_vector_element_elt_undef"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+23, "dx_undef", 8) != 0)
        break;
      return 21;	 // "insert_vector_element_idx_undef"
    }
    break;
  case 32:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itfield_extract_from_sext_inreg", 31) != 0)
        break;
      return 165;	 // "bitfield_extract_from_sext_inreg"
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_f", 8) != 0)
        break;
      switch (RuleIdentifier[9]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "dd_fmul_to_fmad_or_fma", 22) != 0)
          break;
        return 177;	 // "combine_fadd_fmul_to_fmad_or_fma"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "ub_fmul_to_fmad_or_fma", 22) != 0)
          break;
        return 181;	 // "combine_fsub_fmul_to_fmad_or_fma"
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_not_const", 31) != 0)
        break;
      return 25;	 // "extract_vector_element_not_const"
    }
    break;
  case 34:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fmul_with_select_to_fldexp", 33) != 0)
        break;
      return 224;	 // "combine_fmul_with_select_to_fldexp"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_all_elts_from_build_vector", 33) != 0)
        break;
      return 67;	 // "extract_all_elts_from_build_vector"
    }
    break;
  case 35:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_vector_element_build_vector", 35) != 0)
      break;
    return 27;	 // "extract_vector_element_build_vector"
  case 36:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_", 7) != 0)
        break;
      switch (RuleIdentifier[8]) {
      default: break;
      case 'f':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "add_fma_fmul_to_fmad_or_fma", 27) != 0)
          break;
        return 179;	 // "combine_fadd_fma_fmul_to_fmad_or_fma"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "nsert_vec_elts_build_vector", 27) != 0)
          break;
        return 65;	 // "combine_insert_vec_elts_build_vector"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nsert_extract_vec_elt_out_of_bounds", 35) != 0)
        break;
      return 82;	 // "insert_extract_vec_elt_out_of_bounds"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element_undef_index", 35) != 0)
        break;
      return 20;	 // "match_extract_of_element_undef_index"
    }
    break;
  case 37:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fsub_fneg_fmul_to_fmad_or_fma", 36) != 0)
        break;
      return 182;	 // "combine_fsub_fneg_fmul_to_fmad_or_fma"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_shuffle_vector", 36) != 0)
        break;
      return 35;	 // "extract_vector_element_shuffle_vector"
    case 'h':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oist_logic_op_with_same_opcode_hands", 36) != 0)
        break;
      return 105;	 // "hoist_logic_op_with_same_opcode_hands"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element_undef_vector", 36) != 0)
        break;
      return 19;	 // "match_extract_of_element_undef_vector"
    }
    break;
  case 38:	 // 3 strings to match.
    if (memcmp(RuleIdentifier.data()+0, "combine_", 8) != 0)
      break;
    switch (RuleIdentifier[8]) {
    default: break;
    case 'f':	 // 2 strings to match.
      switch (RuleIdentifier[9]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "dd_fpext_fmul_to_fmad_or_fma", 28) != 0)
          break;
        return 178;	 // "combine_fadd_fpext_fmul_to_fmad_or_fma"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "ub_fpext_fmul_to_fmad_or_fma", 28) != 0)
          break;
        return 183;	 // "combine_fsub_fpext_fmul_to_fmad_or_fma"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+9, "huffle_vector_to_build_vector", 29) != 0)
        break;
      return 227;	 // "combine_shuffle_vector_to_build_vector"
    }
    break;
  case 40:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_vector_element_different_indices", 40) != 0)
      break;
    return 26;	 // "extract_vector_element_different_indices"
  case 42:	 // 9 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fadd_fpext_fma_fmul_to_fmad_or_fma", 41) != 0)
        break;
      return 180;	 // "combine_fadd_fpext_fma_fmul_to_fmad_or_fma"
    case 'e':	 // 7 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_build_vector_trunc", 40) != 0)
        break;
      switch (RuleIdentifier[41]) {
      default: break;
      case '2':	 // 1 string to match.
        return 28;	 // "extract_vector_element_build_vector_trunc2"
      case '3':	 // 1 string to match.
        return 29;	 // "extract_vector_element_build_vector_trunc3"
      case '4':	 // 1 string to match.
        return 30;	 // "extract_vector_element_build_vector_trunc4"
      case '5':	 // 1 string to match.
        return 31;	 // "extract_vector_element_build_vector_trunc5"
      case '6':	 // 1 string to match.
        return 32;	 // "extract_vector_element_build_vector_trunc6"
      case '7':	 // 1 string to match.
        return 33;	 // "extract_vector_element_build_vector_trunc7"
      case '8':	 // 1 string to match.
        return 34;	 // "extract_vector_element_build_vector_trunc8"
      }
      break;
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_or_shift_to_funnel_shift_left", 41) != 0)
        break;
      return 160;	 // "funnel_shift_or_shift_to_funnel_shift_left"
    }
    break;
  case 43:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fsub_fpext_fneg_fmul_to_fmad_or_fma", 42) != 0)
        break;
      return 184;	 // "combine_fsub_fpext_fneg_fmul_to_fmad_or_fma"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_or_shift_to_funnel_shift_right", 42) != 0)
        break;
      return 161;	 // "funnel_shift_or_shift_to_funnel_shift_right"
    }
    break;
  case 44:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "insert_vector_element_extract_vector_element", 44) != 0)
      break;
    return 36;	 // "insert_vector_element_extract_vector_element"
  case 46:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "push_freeze_to_prevent_poison_from_propagating", 46) != 0)
      break;
    return 42;	 // "push_freeze_to_prevent_poison_from_propagating"
  }
#endif // ifndef NDEBUG

  return std::nullopt;
}
static std::optional<std::pair<uint64_t, uint64_t>> getRuleRangeForIdentifier(StringRef RuleIdentifier) {
  std::pair<StringRef, StringRef> RangePair = RuleIdentifier.split('-');
  if (!RangePair.second.empty()) {
    const auto First = getRuleIdxForIdentifier(RangePair.first);
    const auto Last = getRuleIdxForIdentifier(RangePair.second);
    if (!First || !Last)
      return std::nullopt;
    if (First >= Last)
      report_fatal_error("Beginning of range should be before end of range");
    return {{*First, *Last + 1}};
  }
  if (RangePair.first == "*") {
    return {{0, 230}};
  }
  const auto I = getRuleIdxForIdentifier(RangePair.first);
  if (!I)
    return std::nullopt;
  return {{*I, *I + 1}};
}

bool AMDGPUPreLegalizerCombinerImplRuleConfig::setRuleEnabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.reset(I);
  return true;
}

bool AMDGPUPreLegalizerCombinerImplRuleConfig::setRuleDisabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.set(I);
  return true;
}

static std::vector<std::string> AMDGPUPreLegalizerCombinerOption;
static cl::list<std::string> AMDGPUPreLegalizerCombinerDisableOption(
    "amdgpuprelegalizercombiner-disable-rule",
    cl::desc("Disable one or more combiner rules temporarily in the AMDGPUPreLegalizerCombiner pass"),
    cl::CommaSeparated,
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &Str) {
      AMDGPUPreLegalizerCombinerOption.push_back(Str);
    }));
static cl::list<std::string> AMDGPUPreLegalizerCombinerOnlyEnableOption(
    "amdgpuprelegalizercombiner-only-enable-rule",
    cl::desc("Disable all rules in the AMDGPUPreLegalizerCombiner pass then re-enable the specified ones"),
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &CommaSeparatedArg) {
      StringRef Str = CommaSeparatedArg;
      AMDGPUPreLegalizerCombinerOption.push_back("*");
      do {
        auto X = Str.split(",");
        AMDGPUPreLegalizerCombinerOption.push_back(("!" + X.first).str());
        Str = X.second;
      } while (!Str.empty());
    }));


bool AMDGPUPreLegalizerCombinerImplRuleConfig::isRuleEnabled(unsigned RuleID) const {
    return  !DisabledRules.test(RuleID);
}
bool AMDGPUPreLegalizerCombinerImplRuleConfig::parseCommandLineOption() {
  for (StringRef Identifier : AMDGPUPreLegalizerCombinerOption) {
    bool Enabled = Identifier.consume_front("!");
    if (Enabled && !setRuleEnabled(Identifier))
      return false;
    if (!Enabled && !setRuleDisabled(Identifier))
      return false;
  }
  return true;
}

#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_TYPES
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_CLASS_MEMBERS
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS
#ifdef GET_GICOMBINER_CLASS_MEMBERS
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUPreLegalizerCombinerImpl::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUPreLegalizerCombinerImpl::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPUPreLegalizerCombinerImpl::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUPreLegalizerCombinerImpl::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS

#ifdef GET_GICOMBINER_IMPL
// LLT Objects.
enum {
  GILLT_s32,
  GILLT_s64,
};
const static size_t NumTypeObjects = 2;
const static LLT TypeObjects[] = {
  LLT::scalar(32),
  LLT::scalar(64),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset AMDGPUPreLegalizerCombinerImpl::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features{};
  return Features;
}

void AMDGPUPreLegalizerCombinerImpl::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUPreLegalizerCombinerImpl::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

AMDGPUPreLegalizerCombinerImpl::ComplexMatcherMemFn
AMDGPUPreLegalizerCombinerImpl::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

enum {
  GICXXPred_MI_Predicate_GICombiner0 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_GICombiner1,
  GICXXPred_MI_Predicate_GICombiner2,
  GICXXPred_MI_Predicate_GICombiner3,
  GICXXPred_MI_Predicate_GICombiner4,
  GICXXPred_MI_Predicate_GICombiner5,
  GICXXPred_MI_Predicate_GICombiner6,
  GICXXPred_MI_Predicate_GICombiner7,
  GICXXPred_MI_Predicate_GICombiner8,
  GICXXPred_MI_Predicate_GICombiner9,
  GICXXPred_MI_Predicate_GICombiner10,
  GICXXPred_MI_Predicate_GICombiner11,
  GICXXPred_MI_Predicate_GICombiner12,
  GICXXPred_MI_Predicate_GICombiner13,
};
bool AMDGPUPreLegalizerCombinerImpl::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_GICombiner0: {
    return isGuaranteedNotToBePoison(State.MIs[0]->getOperand(1).getReg(), MRI);
  }
  case GICXXPred_MI_Predicate_GICombiner1: {
    return isGuaranteedNotToBeUndefOrPoison(State.MIs[0]->getOperand(1).getReg(), MRI);
  }
  case GICXXPred_MI_Predicate_GICombiner2: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), 1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner3: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -0.0);
  }
  case GICXXPred_MI_Predicate_GICombiner4: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), 0.0);
  }
  case GICXXPred_MI_Predicate_GICombiner5: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner6: {
    return State.MIs[1]->getOperand(1).getPredicate() == CmpInst::ICMP_EQ &&
                               !MRI.getType(State.MIs[1]->getOperand(2).getReg()).getScalarType().isPointer() &&
                               (MRI.getType(State.MIs[1]->getOperand(2).getReg()) ==
                                   MRI.getType(State.MIs[2]->getOperand(2).getReg()));
  }
  case GICXXPred_MI_Predicate_GICombiner7: {
    return State.MIs[1]->getOperand(1).getPredicate() == CmpInst::ICMP_NE &&
                               !MRI.getType(State.MIs[1]->getOperand(2).getReg()).getScalarType().isPointer() &&
                               (MRI.getType(State.MIs[1]->getOperand(2).getReg()) ==
                                   MRI.getType(State.MIs[2]->getOperand(2).getReg()));
  }
  case GICXXPred_MI_Predicate_GICombiner8: {
    return MRI.hasOneNonDBGUse(State.MIs[0]->getOperand(2).getReg()) &&
                    Helper.isLegalOrBeforeLegalizer(
                      {TargetOpcode::G_SEXT_INREG, {MRI.getType(State.MIs[1]->getOperand(1).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner9: {
    return Helper.isLegalOrBeforeLegalizer({TargetOpcode::G_LSHR,
                                                           {MRI.getType(State.MIs[2]->getOperand(1).getReg()),
                                                            MRI.getType(State.MIs[1]->getOperand(2).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner10: {
    return Helper.isLegalOrBeforeLegalizer({TargetOpcode::G_SHL,
                                                           {MRI.getType(State.MIs[2]->getOperand(1).getReg()),
                                                            MRI.getType(State.MIs[1]->getOperand(2).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner11: {
    return Helper.matchTruncUSatU(*State.MIs[0], *State.MIs[1]);
  }
  case GICXXPred_MI_Predicate_GICombiner12: {
    return Helper.matchTruncUSatUToFPTOUISat(*State.MIs[0], *State.MIs[1]);
  }
  case GICXXPred_MI_Predicate_GICombiner13: {
    return Helper.matchConstantIs32BitMask(State.MIs[0]->getOperand(1).getReg()) ||
                           Helper.matchConstantIs32BitMask(State.MIs[0]->getOperand(2).getReg());
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
enum {
  GICXXPred_Simple_IsRule0Enabled = GICXXPred_Invalid + 1,
  GICXXPred_Simple_IsRule1Enabled,
  GICXXPred_Simple_IsRule2Enabled,
  GICXXPred_Simple_IsRule3Enabled,
  GICXXPred_Simple_IsRule4Enabled,
  GICXXPred_Simple_IsRule5Enabled,
  GICXXPred_Simple_IsRule6Enabled,
  GICXXPred_Simple_IsRule7Enabled,
  GICXXPred_Simple_IsRule8Enabled,
  GICXXPred_Simple_IsRule9Enabled,
  GICXXPred_Simple_IsRule10Enabled,
  GICXXPred_Simple_IsRule11Enabled,
  GICXXPred_Simple_IsRule12Enabled,
  GICXXPred_Simple_IsRule13Enabled,
  GICXXPred_Simple_IsRule14Enabled,
  GICXXPred_Simple_IsRule15Enabled,
  GICXXPred_Simple_IsRule16Enabled,
  GICXXPred_Simple_IsRule17Enabled,
  GICXXPred_Simple_IsRule18Enabled,
  GICXXPred_Simple_IsRule19Enabled,
  GICXXPred_Simple_IsRule20Enabled,
  GICXXPred_Simple_IsRule21Enabled,
  GICXXPred_Simple_IsRule22Enabled,
  GICXXPred_Simple_IsRule23Enabled,
  GICXXPred_Simple_IsRule24Enabled,
  GICXXPred_Simple_IsRule25Enabled,
  GICXXPred_Simple_IsRule26Enabled,
  GICXXPred_Simple_IsRule27Enabled,
  GICXXPred_Simple_IsRule28Enabled,
  GICXXPred_Simple_IsRule29Enabled,
  GICXXPred_Simple_IsRule30Enabled,
  GICXXPred_Simple_IsRule31Enabled,
  GICXXPred_Simple_IsRule32Enabled,
  GICXXPred_Simple_IsRule33Enabled,
  GICXXPred_Simple_IsRule34Enabled,
  GICXXPred_Simple_IsRule35Enabled,
  GICXXPred_Simple_IsRule36Enabled,
  GICXXPred_Simple_IsRule37Enabled,
  GICXXPred_Simple_IsRule38Enabled,
  GICXXPred_Simple_IsRule39Enabled,
  GICXXPred_Simple_IsRule40Enabled,
  GICXXPred_Simple_IsRule41Enabled,
  GICXXPred_Simple_IsRule42Enabled,
  GICXXPred_Simple_IsRule43Enabled,
  GICXXPred_Simple_IsRule44Enabled,
  GICXXPred_Simple_IsRule45Enabled,
  GICXXPred_Simple_IsRule46Enabled,
  GICXXPred_Simple_IsRule47Enabled,
  GICXXPred_Simple_IsRule48Enabled,
  GICXXPred_Simple_IsRule49Enabled,
  GICXXPred_Simple_IsRule50Enabled,
  GICXXPred_Simple_IsRule51Enabled,
  GICXXPred_Simple_IsRule52Enabled,
  GICXXPred_Simple_IsRule53Enabled,
  GICXXPred_Simple_IsRule54Enabled,
  GICXXPred_Simple_IsRule55Enabled,
  GICXXPred_Simple_IsRule56Enabled,
  GICXXPred_Simple_IsRule57Enabled,
  GICXXPred_Simple_IsRule58Enabled,
  GICXXPred_Simple_IsRule59Enabled,
  GICXXPred_Simple_IsRule60Enabled,
  GICXXPred_Simple_IsRule61Enabled,
  GICXXPred_Simple_IsRule62Enabled,
  GICXXPred_Simple_IsRule63Enabled,
  GICXXPred_Simple_IsRule64Enabled,
  GICXXPred_Simple_IsRule65Enabled,
  GICXXPred_Simple_IsRule66Enabled,
  GICXXPred_Simple_IsRule67Enabled,
  GICXXPred_Simple_IsRule68Enabled,
  GICXXPred_Simple_IsRule69Enabled,
  GICXXPred_Simple_IsRule70Enabled,
  GICXXPred_Simple_IsRule71Enabled,
  GICXXPred_Simple_IsRule72Enabled,
  GICXXPred_Simple_IsRule73Enabled,
  GICXXPred_Simple_IsRule74Enabled,
  GICXXPred_Simple_IsRule75Enabled,
  GICXXPred_Simple_IsRule76Enabled,
  GICXXPred_Simple_IsRule77Enabled,
  GICXXPred_Simple_IsRule78Enabled,
  GICXXPred_Simple_IsRule79Enabled,
  GICXXPred_Simple_IsRule80Enabled,
  GICXXPred_Simple_IsRule81Enabled,
  GICXXPred_Simple_IsRule82Enabled,
  GICXXPred_Simple_IsRule83Enabled,
  GICXXPred_Simple_IsRule84Enabled,
  GICXXPred_Simple_IsRule85Enabled,
  GICXXPred_Simple_IsRule86Enabled,
  GICXXPred_Simple_IsRule87Enabled,
  GICXXPred_Simple_IsRule88Enabled,
  GICXXPred_Simple_IsRule89Enabled,
  GICXXPred_Simple_IsRule90Enabled,
  GICXXPred_Simple_IsRule91Enabled,
  GICXXPred_Simple_IsRule92Enabled,
  GICXXPred_Simple_IsRule93Enabled,
  GICXXPred_Simple_IsRule94Enabled,
  GICXXPred_Simple_IsRule95Enabled,
  GICXXPred_Simple_IsRule96Enabled,
  GICXXPred_Simple_IsRule97Enabled,
  GICXXPred_Simple_IsRule98Enabled,
  GICXXPred_Simple_IsRule99Enabled,
  GICXXPred_Simple_IsRule100Enabled,
  GICXXPred_Simple_IsRule101Enabled,
  GICXXPred_Simple_IsRule102Enabled,
  GICXXPred_Simple_IsRule103Enabled,
  GICXXPred_Simple_IsRule104Enabled,
  GICXXPred_Simple_IsRule105Enabled,
  GICXXPred_Simple_IsRule106Enabled,
  GICXXPred_Simple_IsRule107Enabled,
  GICXXPred_Simple_IsRule108Enabled,
  GICXXPred_Simple_IsRule109Enabled,
  GICXXPred_Simple_IsRule110Enabled,
  GICXXPred_Simple_IsRule111Enabled,
  GICXXPred_Simple_IsRule112Enabled,
  GICXXPred_Simple_IsRule113Enabled,
  GICXXPred_Simple_IsRule114Enabled,
  GICXXPred_Simple_IsRule115Enabled,
  GICXXPred_Simple_IsRule116Enabled,
  GICXXPred_Simple_IsRule117Enabled,
  GICXXPred_Simple_IsRule118Enabled,
  GICXXPred_Simple_IsRule119Enabled,
  GICXXPred_Simple_IsRule120Enabled,
  GICXXPred_Simple_IsRule121Enabled,
  GICXXPred_Simple_IsRule122Enabled,
  GICXXPred_Simple_IsRule123Enabled,
  GICXXPred_Simple_IsRule124Enabled,
  GICXXPred_Simple_IsRule125Enabled,
  GICXXPred_Simple_IsRule126Enabled,
  GICXXPred_Simple_IsRule127Enabled,
  GICXXPred_Simple_IsRule128Enabled,
  GICXXPred_Simple_IsRule129Enabled,
  GICXXPred_Simple_IsRule130Enabled,
  GICXXPred_Simple_IsRule131Enabled,
  GICXXPred_Simple_IsRule132Enabled,
  GICXXPred_Simple_IsRule133Enabled,
  GICXXPred_Simple_IsRule134Enabled,
  GICXXPred_Simple_IsRule135Enabled,
  GICXXPred_Simple_IsRule136Enabled,
  GICXXPred_Simple_IsRule137Enabled,
  GICXXPred_Simple_IsRule138Enabled,
  GICXXPred_Simple_IsRule139Enabled,
  GICXXPred_Simple_IsRule140Enabled,
  GICXXPred_Simple_IsRule141Enabled,
  GICXXPred_Simple_IsRule142Enabled,
  GICXXPred_Simple_IsRule143Enabled,
  GICXXPred_Simple_IsRule144Enabled,
  GICXXPred_Simple_IsRule145Enabled,
  GICXXPred_Simple_IsRule146Enabled,
  GICXXPred_Simple_IsRule147Enabled,
  GICXXPred_Simple_IsRule148Enabled,
  GICXXPred_Simple_IsRule149Enabled,
  GICXXPred_Simple_IsRule150Enabled,
  GICXXPred_Simple_IsRule151Enabled,
  GICXXPred_Simple_IsRule152Enabled,
  GICXXPred_Simple_IsRule153Enabled,
  GICXXPred_Simple_IsRule154Enabled,
  GICXXPred_Simple_IsRule155Enabled,
  GICXXPred_Simple_IsRule156Enabled,
  GICXXPred_Simple_IsRule157Enabled,
  GICXXPred_Simple_IsRule158Enabled,
  GICXXPred_Simple_IsRule159Enabled,
  GICXXPred_Simple_IsRule160Enabled,
  GICXXPred_Simple_IsRule161Enabled,
  GICXXPred_Simple_IsRule162Enabled,
  GICXXPred_Simple_IsRule163Enabled,
  GICXXPred_Simple_IsRule164Enabled,
  GICXXPred_Simple_IsRule165Enabled,
  GICXXPred_Simple_IsRule166Enabled,
  GICXXPred_Simple_IsRule167Enabled,
  GICXXPred_Simple_IsRule168Enabled,
  GICXXPred_Simple_IsRule169Enabled,
  GICXXPred_Simple_IsRule170Enabled,
  GICXXPred_Simple_IsRule171Enabled,
  GICXXPred_Simple_IsRule172Enabled,
  GICXXPred_Simple_IsRule173Enabled,
  GICXXPred_Simple_IsRule174Enabled,
  GICXXPred_Simple_IsRule175Enabled,
  GICXXPred_Simple_IsRule176Enabled,
  GICXXPred_Simple_IsRule177Enabled,
  GICXXPred_Simple_IsRule178Enabled,
  GICXXPred_Simple_IsRule179Enabled,
  GICXXPred_Simple_IsRule180Enabled,
  GICXXPred_Simple_IsRule181Enabled,
  GICXXPred_Simple_IsRule182Enabled,
  GICXXPred_Simple_IsRule183Enabled,
  GICXXPred_Simple_IsRule184Enabled,
  GICXXPred_Simple_IsRule185Enabled,
  GICXXPred_Simple_IsRule186Enabled,
  GICXXPred_Simple_IsRule187Enabled,
  GICXXPred_Simple_IsRule188Enabled,
  GICXXPred_Simple_IsRule189Enabled,
  GICXXPred_Simple_IsRule190Enabled,
  GICXXPred_Simple_IsRule191Enabled,
  GICXXPred_Simple_IsRule192Enabled,
  GICXXPred_Simple_IsRule193Enabled,
  GICXXPred_Simple_IsRule194Enabled,
  GICXXPred_Simple_IsRule195Enabled,
  GICXXPred_Simple_IsRule196Enabled,
  GICXXPred_Simple_IsRule197Enabled,
  GICXXPred_Simple_IsRule198Enabled,
  GICXXPred_Simple_IsRule199Enabled,
  GICXXPred_Simple_IsRule200Enabled,
  GICXXPred_Simple_IsRule201Enabled,
  GICXXPred_Simple_IsRule202Enabled,
  GICXXPred_Simple_IsRule203Enabled,
  GICXXPred_Simple_IsRule204Enabled,
  GICXXPred_Simple_IsRule205Enabled,
  GICXXPred_Simple_IsRule206Enabled,
  GICXXPred_Simple_IsRule207Enabled,
  GICXXPred_Simple_IsRule208Enabled,
  GICXXPred_Simple_IsRule209Enabled,
  GICXXPred_Simple_IsRule210Enabled,
  GICXXPred_Simple_IsRule211Enabled,
  GICXXPred_Simple_IsRule212Enabled,
  GICXXPred_Simple_IsRule213Enabled,
  GICXXPred_Simple_IsRule214Enabled,
  GICXXPred_Simple_IsRule215Enabled,
  GICXXPred_Simple_IsRule216Enabled,
  GICXXPred_Simple_IsRule217Enabled,
  GICXXPred_Simple_IsRule218Enabled,
  GICXXPred_Simple_IsRule219Enabled,
  GICXXPred_Simple_IsRule220Enabled,
  GICXXPred_Simple_IsRule221Enabled,
  GICXXPred_Simple_IsRule222Enabled,
  GICXXPred_Simple_IsRule223Enabled,
  GICXXPred_Simple_IsRule224Enabled,
  GICXXPred_Simple_IsRule225Enabled,
  GICXXPred_Simple_IsRule226Enabled,
  GICXXPred_Simple_IsRule227Enabled,
  GICXXPred_Simple_IsRule228Enabled,
  GICXXPred_Simple_IsRule229Enabled,
};

bool AMDGPUPreLegalizerCombinerImpl::testSimplePredicate(unsigned Predicate) const {
    return RuleConfig.isRuleEnabled(Predicate - GICXXPred_Invalid - 1);
}
// Custom renderers.
enum {
  GICR_Invalid,
};
AMDGPUPreLegalizerCombinerImpl::CustomRendererFn
AMDGPUPreLegalizerCombinerImpl::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool AMDGPUPreLegalizerCombinerImpl::tryCombineAllImpl(MachineInstr &I) const {
  const TargetSubtargetInfo &ST = MF.getSubtarget();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  B.setInstrAndDebugLoc(I);
  State.MIs.clear();
  State.MIs.push_back(&I);
  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), *ST.getInstrInfo(), MRI, *MRI.getTargetRegisterInfo(), *ST.getRegBankInfo(), AvailableFeatures, /*CoverageInfo*/ nullptr)) {
    return true;
  }

  return false;
}

enum {
  GICXXCustomAction_GICombiner0 = GICXXCustomAction_Invalid + 1,
  GICXXCustomAction_GICombiner1,
  GICXXCustomAction_GICombiner2,
  GICXXCustomAction_GICombiner3,
  GICXXCustomAction_GICombiner4,
  GICXXCustomAction_GICombiner5,
  GICXXCustomAction_GICombiner6,
  GICXXCustomAction_GICombiner7,
  GICXXCustomAction_GICombiner8,
  GICXXCustomAction_GICombiner9,
  GICXXCustomAction_GICombiner10,
  GICXXCustomAction_GICombiner11,
  GICXXCustomAction_GICombiner12,
  GICXXCustomAction_GICombiner13,
  GICXXCustomAction_GICombiner14,
  GICXXCustomAction_GICombiner15,
  GICXXCustomAction_GICombiner16,
  GICXXCustomAction_GICombiner17,
  GICXXCustomAction_GICombiner18,
  GICXXCustomAction_GICombiner19,
  GICXXCustomAction_GICombiner20,
  GICXXCustomAction_GICombiner21,
  GICXXCustomAction_GICombiner22,
  GICXXCustomAction_GICombiner23,
  GICXXCustomAction_GICombiner24,
  GICXXCustomAction_GICombiner25,
  GICXXCustomAction_GICombiner26,
  GICXXCustomAction_GICombiner27,
  GICXXCustomAction_GICombiner28,
  GICXXCustomAction_GICombiner29,
  GICXXCustomAction_GICombiner30,
  GICXXCustomAction_GICombiner31,
  GICXXCustomAction_GICombiner32,
  GICXXCustomAction_GICombiner33,
  GICXXCustomAction_GICombiner34,
  GICXXCustomAction_GICombiner35,
  GICXXCustomAction_GICombiner36,
  GICXXCustomAction_GICombiner37,
  GICXXCustomAction_GICombiner38,
  GICXXCustomAction_GICombiner39,
  GICXXCustomAction_GICombiner40,
  GICXXCustomAction_GICombiner41,
  GICXXCustomAction_GICombiner42,
  GICXXCustomAction_GICombiner43,
  GICXXCustomAction_GICombiner44,
  GICXXCustomAction_GICombiner45,
  GICXXCustomAction_GICombiner46,
  GICXXCustomAction_GICombiner47,
  GICXXCustomAction_GICombiner48,
  GICXXCustomAction_GICombiner49,
  GICXXCustomAction_GICombiner50,
  GICXXCustomAction_GICombiner51,
  GICXXCustomAction_GICombiner52,
  GICXXCustomAction_GICombiner53,
  GICXXCustomAction_GICombiner54,
  GICXXCustomAction_GICombiner55,
  GICXXCustomAction_GICombiner56,
  GICXXCustomAction_GICombiner57,
  GICXXCustomAction_GICombiner58,
  GICXXCustomAction_GICombiner59,
  GICXXCustomAction_GICombiner60,
  GICXXCustomAction_GICombiner61,
  GICXXCustomAction_GICombiner62,
  GICXXCustomAction_GICombiner63,
  GICXXCustomAction_GICombiner64,
  GICXXCustomAction_GICombiner65,
  GICXXCustomAction_GICombiner66,
  GICXXCustomAction_GICombiner67,
  GICXXCustomAction_GICombiner68,
  GICXXCustomAction_GICombiner69,
  GICXXCustomAction_GICombiner70,
  GICXXCustomAction_GICombiner71,
  GICXXCustomAction_GICombiner72,
  GICXXCustomAction_GICombiner73,
  GICXXCustomAction_GICombiner74,
  GICXXCustomAction_GICombiner75,
  GICXXCustomAction_GICombiner76,
  GICXXCustomAction_GICombiner77,
  GICXXCustomAction_GICombiner78,
  GICXXCustomAction_GICombiner79,
  GICXXCustomAction_GICombiner80,
  GICXXCustomAction_GICombiner81,
  GICXXCustomAction_GICombiner82,
  GICXXCustomAction_GICombiner83,
  GICXXCustomAction_GICombiner84,
  GICXXCustomAction_GICombiner85,
  GICXXCustomAction_GICombiner86,
  GICXXCustomAction_GICombiner87,
  GICXXCustomAction_GICombiner88,
  GICXXCustomAction_GICombiner89,
  GICXXCustomAction_GICombiner90,
  GICXXCustomAction_GICombiner91,
  GICXXCustomAction_GICombiner92,
  GICXXCustomAction_GICombiner93,
  GICXXCustomAction_GICombiner94,
  GICXXCustomAction_GICombiner95,
  GICXXCustomAction_GICombiner96,
  GICXXCustomAction_GICombiner97,
  GICXXCustomAction_GICombiner98,
  GICXXCustomAction_GICombiner99,
  GICXXCustomAction_GICombiner100,
  GICXXCustomAction_GICombiner101,
  GICXXCustomAction_GICombiner102,
  GICXXCustomAction_GICombiner103,
  GICXXCustomAction_GICombiner104,
  GICXXCustomAction_GICombiner105,
  GICXXCustomAction_GICombiner106,
  GICXXCustomAction_GICombiner107,
  GICXXCustomAction_GICombiner108,
  GICXXCustomAction_GICombiner109,
  GICXXCustomAction_GICombiner110,
  GICXXCustomAction_GICombiner111,
  GICXXCustomAction_GICombiner112,
  GICXXCustomAction_GICombiner113,
  GICXXCustomAction_GICombiner114,
  GICXXCustomAction_GICombiner115,
  GICXXCustomAction_GICombiner116,
  GICXXCustomAction_GICombiner117,
  GICXXCustomAction_GICombiner118,
  GICXXCustomAction_GICombiner119,
  GICXXCustomAction_GICombiner120,
  GICXXCustomAction_GICombiner121,
  GICXXCustomAction_GICombiner122,
  GICXXCustomAction_GICombiner123,
  GICXXCustomAction_GICombiner124,
  GICXXCustomAction_GICombiner125,
  GICXXCustomAction_GICombiner126,
  GICXXCustomAction_GICombiner127,
  GICXXCustomAction_GICombiner128,
  GICXXCustomAction_GICombiner129,
  GICXXCustomAction_GICombiner130,
  GICXXCustomAction_GICombiner131,
  GICXXCustomAction_GICombiner132,
  GICXXCustomAction_GICombiner133,
  GICXXCustomAction_GICombiner134,
  GICXXCustomAction_GICombiner135,
  GICXXCustomAction_GICombiner136,
  GICXXCustomAction_GICombiner137,
  GICXXCustomAction_GICombiner138,
  GICXXCustomAction_GICombiner139,
  GICXXCustomAction_GICombiner140,
  GICXXCustomAction_GICombiner141,
  GICXXCustomAction_GICombiner142,
  GICXXCustomAction_GICombiner143,
  GICXXCustomAction_GICombiner144,
  GICXXCustomAction_GICombiner145,
  GICXXCustomAction_GICombiner146,
  GICXXCustomAction_GICombiner147,
  GICXXCustomAction_GICombiner148,
  GICXXCustomAction_GICombiner149,
  GICXXCustomAction_GICombiner150,
  GICXXCustomAction_GICombiner151,
  GICXXCustomAction_GICombiner152,
  GICXXCustomAction_GICombiner153,
  GICXXCustomAction_GICombiner154,
  GICXXCustomAction_GICombiner155,
  GICXXCustomAction_GICombiner156,
  GICXXCustomAction_GICombiner157,
};
bool AMDGPUPreLegalizerCombinerImpl::runCustomAction(unsigned ApplyID, const MatcherState &State, NewMIVector &OutMIs) const {
  Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
  switch(ApplyID) {
  case GICXXCustomAction_GICombiner0:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAPlusC1MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner1:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldC2MinusAPlusC1(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner2:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAMinusC1MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner3:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldC1Minus2MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner4:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAMinusC1PlusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner5:{
    // Match Patterns
    if(![&](){return Helper.matchCombineCopy(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineCopy(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner6:{
    unsigned GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineMulToShl(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineMulToShl(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner7:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineSubToAdd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner8:{
    std::pair<Register, bool> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineAddP2IToPtrAdd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineAddP2IToPtrAdd(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner9:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElement(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner10:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchInsertVectorElementOOB(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner11:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithDifferentIndices(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner12:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithBuildVector(*State.MIs[0], *State.MIs[1],
              GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner13:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithBuildVectorTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner14:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithShuffleVector(*State.MIs[0], *State.MIs[1],
              GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner15:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner16:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner17:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShlOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner18:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSubOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner19:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return !isGuaranteedNotToBePoison(State.MIs[0]->getOperand(1).getReg(), MRI) && Helper.matchFreezeOfSingleMaybePoisonOperand(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner20:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncateOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner21:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner22:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantSextInReg(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner23:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfSelect(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner24:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfBuildVector(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner25:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNarrowBinop(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner26:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfInteger(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner27:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineInsertVecElts(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineInsertVecElts(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner28:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner29:{
    SmallVector<std::pair<Register, MachineInstr*>> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner30:{
    PreferredTuple GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner31:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineLoadWithAndMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner32:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtractedVectorLoad(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner33:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], 0.0);
    return true;
  }
  case GICXXCustomAction_GICombiner34:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner35:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], -1);
    return true;
  }
  case GICXXCustomAction_GICombiner36:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner37:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 2);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner38:{
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]->getOperand(0).getParent());
    return true;
  }
  case GICXXCustomAction_GICombiner39:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner40:{
    // Match Patterns
    if(![&](){return Helper.matchAllExplicitUsesAreUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner41:{
    // Match Patterns
    if(![&](){return Helper.matchUndefShuffleVectorMask(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner42:{
    // Match Patterns
    if(![&](){return Helper.matchUndefStore(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.eraseInst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner43:{
    // Match Patterns
    if(![&](){return Helper.matchInsertExtractVecEltOutOfBounds(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner44:{
    // Match Patterns
    if(![&](){return Helper.matchSelectSameVal(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 2);
    return true;
  }
  case GICXXCustomAction_GICombiner45:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsZero(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner46:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineI2PToP2I(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineI2PToP2I(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner47:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){GIMatchData_info = State.MIs[1]->getOperand(1).getReg(); return true;}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineP2IToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner48:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineAnyExtTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner49:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchBuildVectorIdentityFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner50:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner51:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncLshrBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner52:{
    // Match Patterns
    if(![&](){return MRI.getType(State.MIs[1]->getOperand(1).getReg()) == MRI.getType(State.MIs[0]->getOperand(0).getReg());}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], State.MIs[1]->getOperand(1).getReg());
    return true;
  }
  case GICXXCustomAction_GICombiner53:{
    MachineInstr* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtendThroughPhis(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtendThroughPhis(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner54:{
    std::tuple<Register, Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSimplifyAddToSub(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySimplifyAddToSub(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner55:{
    InstructionStepsMatchInfo GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchHoistLogicOpWithSameOpcodeHands(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildInstructionSteps(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner56:{
    std::optional<int64_t> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftsTooBig(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    if (GIMatchData_matchinfo) {
              Helper.replaceInstWithConstant(*State.MIs[0], *GIMatchData_matchinfo);
            } else {
              Helper.replaceInstWithUndef(*State.MIs[0]);
            }
    return true;
  }
  case GICXXCustomAction_GICombiner57:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchReassocPtrAdd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner58:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchReassocCommBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner59:{
    PtrAddChain GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner60:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCanonicalizeICmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner61:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCanonicalizeFCmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner62:{
    int64_t GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchICmpToTrueFalseKnownBits(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner63:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchICmpToLHSKnownBits(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner64:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchRedundantBinOpInEquality(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner65:{
    std::tuple<Register, int64_t> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchAshrShlToSextInreg(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyAshShlToSextInreg(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner66:{
    std::tuple<Register, unsigned> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSextInRegOfLoad(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySextInRegOfLoad(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner67:{
    RegisterImmPair GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineShlOfExtend(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShlOfExtend(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner68:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNarrowBinopFeedingAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner69:{
    unsigned GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantSelectCmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner70:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSelectIMinMax(State.MIs[0]->getOperand(0), GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner71:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSelect(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner72:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner73:{
    // Match Patterns
    if(![&](){return Helper.matchRedundantSExtInReg(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner74:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantOr(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner75:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsKnownToBeAPowerOfTwo(*State.MIs[0], 2);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySimplifyURemByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner76:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineZextTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner77:{
    // Match Patterns
    if(![&](){unsigned BitWidth = MRI.getType(State.MIs[0]->getOperand(1).getReg()).getScalarSizeInBits();
                return Helper.getValueTracking()->maskedValueIsZero(State.MIs[0]->getOperand(1).getReg(),
                         APInt::getOneBitSet(BitWidth, State.MIs[0]->getOperand(2).getImm() - 1));}()) {
      return false;
    }
    // Apply Patterns
    Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
              Helper.getBuilder().buildZExtInReg(State.MIs[0]->getOperand(0), State.MIs[0]->getOperand(1), State.MIs[0]->getOperand(2).getImm());
              State.MIs[0]->eraseFromParent();
    return true;
  }
  case GICXXCustomAction_GICombiner78:{
    std::pair<MachineInstr*, LLT> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineTruncOfShift(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineTruncOfShift(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner79:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchNotCmp(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyNotCmp(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner80:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchOptBrCondByInvertingCond(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyOptBrCondByInvertingCond(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner81:{
    // Apply Patterns
    Helper.applyCombineConstantFoldFpUnary(*State.MIs[0], State.MIs[1]->getOperand(1).getFPImm());
    return true;
  }
  case GICXXCustomAction_GICombiner82:{
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0]->getOperand(0).getParent(), 0.0);
    return true;
  }
  case GICXXCustomAction_GICombiner83:{
    APInt GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineConstPtrAddToI2P(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineConstPtrAddToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner84:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchOverlappingAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner85:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOBy2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner86:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOBy0(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner87:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddEToAddO(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner88:{
    unsigned GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFMinMaxNaN(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner89:{
    // Match Patterns
    if(![&](){return Helper.matchFPowIExpansion(*State.MIs[0], State.MIs[1]->getOperand(1).getCImm()->getSExtValue());}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExpandFPowI(*State.MIs[0], State.MIs[1]->getOperand(1).getCImm()->getSExtValue());
    return true;
  }
  case GICXXCustomAction_GICombiner90:{
    std::pair<Register, Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner91:{
    // Match Patterns
    if(![&](){return Helper.matchPtrAddZero(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyPtrAddZero(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner92:{
    RegisterImmPair GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner93:{
    ShiftOfShiftedLogic GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftOfShiftedLogic(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyShiftOfShiftedLogic(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner94:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchLoadOrCombine(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner95:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineDivRem(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineDivRem(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner96:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchOrShiftToFunnelShift(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner97:{
    // Match Patterns
    if(![&](){return Helper.matchFunnelShiftToRotate(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFunnelShiftToRotate(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner98:{
    // Match Patterns
    if(![&](){return Helper.matchConstantLargerBitWidth(*State.MIs[0], 3);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFunnelShiftConstantModulo(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner99:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCommuteShift(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner100:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromSExtInReg(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner101:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner102:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShr(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner103:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShrAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner104:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner105:{
    ConstantFP* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldFPBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner106:{
    ConstantFP* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldFMA(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner107:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldCastOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner108:{
    // Match Patterns
    if(![&](){return Helper.matchUMulHToLShr(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUMulHToLShr(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner109:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantNegOperands(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner110:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchAndOrDisjointMask(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner111:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFMulToFMadOrFMA(*State.MIs[0],
                                                                  GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner112:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFpExtFMulToFMadOrFMA(*State.MIs[0],
                                                                       GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner113:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFMAFMulToFMadOrFMA(*State.MIs[0],
                                                                     GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner114:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFpExtFMulToFMadOrFMAAggressive(
                                                          *State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner115:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFMulToFMadOrFMA(*State.MIs[0],
                                                                  GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner116:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFNegFMulToFMadOrFMA(*State.MIs[0],
                                                                      GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner117:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFpExtFMulToFMadOrFMA(*State.MIs[0],
                                                                       GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner118:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFpExtFNegFMulToFMadOrFMA(
                                                    *State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner119:{
    unsigned GIMatchData_select_op_no;
    // Match Patterns
    if(![&](){return Helper.matchFoldBinOpIntoSelect(*State.MIs[0], GIMatchData_select_op_no);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFoldBinOpIntoSelect(*State.MIs[0], GIMatchData_select_op_no);
    return true;
  }
  case GICXXCustomAction_GICombiner120:{
    // Match Patterns
    if(![&](){return Helper.matchUDivOrURemByConst(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUDivOrURemByConst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner121:{
    // Match Patterns
    if(![&](){return Helper.matchSDivOrSRemByConst(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySDivOrSRemByConst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner122:{
    // Match Patterns
    if(![&](){return Helper.matchDivByPow2(*State.MIs[0], /*IsSigned=*/false);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUDivByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner123:{
    // Match Patterns
    if(![&](){return Helper.matchDivByPow2(*State.MIs[0], /*IsSigned=*/true);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySDivByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner124:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSubAddSameReg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner125:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSimplifySelectToMinMax(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner126:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFsubToFneg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFsubToFneg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner127:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner128:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteFPConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner129:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner130:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchOr(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner131:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSimplifyNegMinMax(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner132:{
    SmallVector<Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner133:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSextOfTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner134:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchZextOfTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner135:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNonNegZext(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner136:{
    SmallVector<Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineShuffleConcat(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShuffleConcat(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner137:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShuffleUndefRHS(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner138:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShuffleDisjointMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner139:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner140:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUnmergeValuesAnyExtBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner141:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner142:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineMergeUnmerge(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner143:{
    SmallVector<APInt, 8> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner144:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeUndef(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner145:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner146:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeZExtToZExt(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeZExtToZExt(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner147:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndUndef(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner148:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndZero(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner149:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddOverflow(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner150:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSuboCarryOut(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner151:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncSSatS(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyTruncSSatS(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner152:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncSSatU(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyTruncSSatU(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner153:{
    LshrOfTruncOfLshr GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchLshrOfTruncOfLshr(*State.MIs[0], GIMatchData_matchinfo, *State.MIs[2]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyLshrOfTruncOfLshr(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner154:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineFmulWithSelectToFldexp(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner155:{
    ClampI64ToI16MatchInfo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchClampI64ToI16(*State.MIs[0], MRI, MF, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyClampI64ToI16(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner156:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldableFneg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFoldableFneg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner157:{
    // Match Patterns
    if(![&](){return Helper.matchCombineShuffleToBuildVector(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShuffleToBuildVector(*State.MIs[0]);
    return true;
  }
  }
  llvm_unreachable("Unknown Apply Action");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((Val) >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24),  uint8_t(uint64_t(Val) >> 32), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t(uint64_t(Val) >> 56), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 32),  uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#endif
const uint8_t *AMDGPUPreLegalizerCombinerImpl::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*    0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(20), GIMT_Encode2(268), /*)*//*default:*//*Label 96*/ GIMT_Encode4(7672),
     /*   10 */ /*TargetOpcode::COPY*//*Label 0*/ GIMT_Encode4(1002), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  142 */ /*TargetOpcode::G_ADD*//*Label 1*/ GIMT_Encode4(1014),
     /*  146 */ /*TargetOpcode::G_SUB*//*Label 2*/ GIMT_Encode4(1571),
     /*  150 */ /*TargetOpcode::G_MUL*//*Label 3*/ GIMT_Encode4(1889),
     /*  154 */ /*TargetOpcode::G_SDIV*//*Label 4*/ GIMT_Encode4(2055),
     /*  158 */ /*TargetOpcode::G_UDIV*//*Label 5*/ GIMT_Encode4(2128),
     /*  162 */ /*TargetOpcode::G_SREM*//*Label 6*/ GIMT_Encode4(2212),
     /*  166 */ /*TargetOpcode::G_UREM*//*Label 7*/ GIMT_Encode4(2268), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  178 */ /*TargetOpcode::G_AND*//*Label 8*/ GIMT_Encode4(2346),
     /*  182 */ /*TargetOpcode::G_OR*//*Label 9*/ GIMT_Encode4(2741),
     /*  186 */ /*TargetOpcode::G_XOR*//*Label 10*/ GIMT_Encode4(3288), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  202 */ /*TargetOpcode::G_PHI*//*Label 11*/ GIMT_Encode4(3389), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  226 */ /*TargetOpcode::G_UNMERGE_VALUES*//*Label 12*/ GIMT_Encode4(3401), GIMT_Encode4(0),
     /*  234 */ /*TargetOpcode::G_MERGE_VALUES*//*Label 13*/ GIMT_Encode4(3468),
     /*  238 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 14*/ GIMT_Encode4(3542),
     /*  242 */ /*TargetOpcode::G_BUILD_VECTOR_TRUNC*//*Label 15*/ GIMT_Encode4(3590),
     /*  246 */ /*TargetOpcode::G_CONCAT_VECTORS*//*Label 16*/ GIMT_Encode4(3602),
     /*  250 */ /*TargetOpcode::G_PTRTOINT*//*Label 17*/ GIMT_Encode4(3614),
     /*  254 */ /*TargetOpcode::G_INTTOPTR*//*Label 18*/ GIMT_Encode4(3657),
     /*  258 */ /*TargetOpcode::G_BITCAST*//*Label 19*/ GIMT_Encode4(3690),
     /*  262 */ /*TargetOpcode::G_FREEZE*//*Label 20*/ GIMT_Encode4(3733), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  302 */ /*TargetOpcode::G_LOAD*//*Label 21*/ GIMT_Encode4(3797),
     /*  306 */ /*TargetOpcode::G_SEXTLOAD*//*Label 22*/ GIMT_Encode4(3809),
     /*  310 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 23*/ GIMT_Encode4(3821), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  326 */ /*TargetOpcode::G_STORE*//*Label 24*/ GIMT_Encode4(3833), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  462 */ /*TargetOpcode::G_ANYEXT*//*Label 25*/ GIMT_Encode4(3845),
     /*  466 */ /*TargetOpcode::G_TRUNC*//*Label 26*/ GIMT_Encode4(3973), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  478 */ /*TargetOpcode::G_TRUNC_USAT_U*//*Label 27*/ GIMT_Encode4(4396), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  498 */ /*TargetOpcode::G_SEXT*//*Label 28*/ GIMT_Encode4(4429),
     /*  502 */ /*TargetOpcode::G_SEXT_INREG*//*Label 29*/ GIMT_Encode4(4504),
     /*  506 */ /*TargetOpcode::G_ZEXT*//*Label 30*/ GIMT_Encode4(4570),
     /*  510 */ /*TargetOpcode::G_SHL*//*Label 31*/ GIMT_Encode4(4700),
     /*  514 */ /*TargetOpcode::G_LSHR*//*Label 32*/ GIMT_Encode4(4869),
     /*  518 */ /*TargetOpcode::G_ASHR*//*Label 33*/ GIMT_Encode4(5021),
     /*  522 */ /*TargetOpcode::G_FSHL*//*Label 34*/ GIMT_Encode4(5155),
     /*  526 */ /*TargetOpcode::G_FSHR*//*Label 35*/ GIMT_Encode4(5198),
     /*  530 */ /*TargetOpcode::G_ROTR*//*Label 36*/ GIMT_Encode4(5241),
     /*  534 */ /*TargetOpcode::G_ROTL*//*Label 37*/ GIMT_Encode4(5265),
     /*  538 */ /*TargetOpcode::G_ICMP*//*Label 38*/ GIMT_Encode4(5289),
     /*  542 */ /*TargetOpcode::G_FCMP*//*Label 39*/ GIMT_Encode4(5334), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  554 */ /*TargetOpcode::G_SELECT*//*Label 40*/ GIMT_Encode4(5346),
     /*  558 */ /*TargetOpcode::G_UADDO*//*Label 41*/ GIMT_Encode4(5441),
     /*  562 */ /*TargetOpcode::G_UADDE*//*Label 42*/ GIMT_Encode4(5464),
     /*  566 */ /*TargetOpcode::G_USUBO*//*Label 43*/ GIMT_Encode4(5476),
     /*  570 */ /*TargetOpcode::G_USUBE*//*Label 44*/ GIMT_Encode4(5488),
     /*  574 */ /*TargetOpcode::G_SADDO*//*Label 45*/ GIMT_Encode4(5500),
     /*  578 */ /*TargetOpcode::G_SADDE*//*Label 46*/ GIMT_Encode4(5523),
     /*  582 */ /*TargetOpcode::G_SSUBO*//*Label 47*/ GIMT_Encode4(5535),
     /*  586 */ /*TargetOpcode::G_SSUBE*//*Label 48*/ GIMT_Encode4(5547),
     /*  590 */ /*TargetOpcode::G_UMULO*//*Label 49*/ GIMT_Encode4(5559),
     /*  594 */ /*TargetOpcode::G_SMULO*//*Label 50*/ GIMT_Encode4(5593),
     /*  598 */ /*TargetOpcode::G_UMULH*//*Label 51*/ GIMT_Encode4(5627),
     /*  602 */ /*TargetOpcode::G_SMULH*//*Label 52*/ GIMT_Encode4(5650),
     /*  606 */ /*TargetOpcode::G_UADDSAT*//*Label 53*/ GIMT_Encode4(5662),
     /*  610 */ /*TargetOpcode::G_SADDSAT*//*Label 54*/ GIMT_Encode4(5674), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  622 */ /*TargetOpcode::G_USHLSAT*//*Label 55*/ GIMT_Encode4(5686),
     /*  626 */ /*TargetOpcode::G_SSHLSAT*//*Label 56*/ GIMT_Encode4(5709),
     /*  630 */ /*TargetOpcode::G_SMULFIX*//*Label 57*/ GIMT_Encode4(5732),
     /*  634 */ /*TargetOpcode::G_UMULFIX*//*Label 58*/ GIMT_Encode4(5744),
     /*  638 */ /*TargetOpcode::G_SMULFIXSAT*//*Label 59*/ GIMT_Encode4(5756),
     /*  642 */ /*TargetOpcode::G_UMULFIXSAT*//*Label 60*/ GIMT_Encode4(5768), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  662 */ /*TargetOpcode::G_FADD*//*Label 61*/ GIMT_Encode4(5780),
     /*  666 */ /*TargetOpcode::G_FSUB*//*Label 62*/ GIMT_Encode4(5921),
     /*  670 */ /*TargetOpcode::G_FMUL*//*Label 63*/ GIMT_Encode4(6010),
     /*  674 */ /*TargetOpcode::G_FMA*//*Label 64*/ GIMT_Encode4(6119),
     /*  678 */ /*TargetOpcode::G_FMAD*//*Label 65*/ GIMT_Encode4(6142),
     /*  682 */ /*TargetOpcode::G_FDIV*//*Label 66*/ GIMT_Encode4(6165),
     /*  686 */ /*TargetOpcode::G_FREM*//*Label 67*/ GIMT_Encode4(6199), GIMT_Encode4(0),
     /*  694 */ /*TargetOpcode::G_FPOWI*//*Label 68*/ GIMT_Encode4(6211), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  714 */ /*TargetOpcode::G_FLOG2*//*Label 69*/ GIMT_Encode4(6233), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  730 */ /*TargetOpcode::G_FNEG*//*Label 70*/ GIMT_Encode4(6255), GIMT_Encode4(0),
     /*  738 */ /*TargetOpcode::G_FPTRUNC*//*Label 71*/ GIMT_Encode4(6317),
     /*  742 */ /*TargetOpcode::G_FPTOSI*//*Label 72*/ GIMT_Encode4(6360),
     /*  746 */ /*TargetOpcode::G_FPTOUI*//*Label 73*/ GIMT_Encode4(6382),
     /*  750 */ /*TargetOpcode::G_SITOFP*//*Label 74*/ GIMT_Encode4(6404),
     /*  754 */ /*TargetOpcode::G_UITOFP*//*Label 75*/ GIMT_Encode4(6431), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  766 */ /*TargetOpcode::G_FABS*//*Label 76*/ GIMT_Encode4(6458), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  778 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 77*/ GIMT_Encode4(6537),
     /*  782 */ /*TargetOpcode::G_FMINNUM*//*Label 78*/ GIMT_Encode4(6567),
     /*  786 */ /*TargetOpcode::G_FMAXNUM*//*Label 79*/ GIMT_Encode4(6601),
     /*  790 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 80*/ GIMT_Encode4(6635),
     /*  794 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 81*/ GIMT_Encode4(6647),
     /*  798 */ /*TargetOpcode::G_FMINIMUM*//*Label 82*/ GIMT_Encode4(6659),
     /*  802 */ /*TargetOpcode::G_FMAXIMUM*//*Label 83*/ GIMT_Encode4(6693), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  842 */ /*TargetOpcode::G_PTR_ADD*//*Label 84*/ GIMT_Encode4(6727), GIMT_Encode4(0),
     /*  850 */ /*TargetOpcode::G_SMIN*//*Label 85*/ GIMT_Encode4(6817),
     /*  854 */ /*TargetOpcode::G_SMAX*//*Label 86*/ GIMT_Encode4(6851),
     /*  858 */ /*TargetOpcode::G_UMIN*//*Label 87*/ GIMT_Encode4(6885),
     /*  862 */ /*TargetOpcode::G_UMAX*//*Label 88*/ GIMT_Encode4(6919),
     /*  866 */ /*TargetOpcode::G_ABS*//*Label 89*/ GIMT_Encode4(6953), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  878 */ /*TargetOpcode::G_BR*//*Label 90*/ GIMT_Encode4(6965), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  898 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 91*/ GIMT_Encode4(6977),
     /*  902 */ /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 92*/ GIMT_Encode4(7107),
     /*  906 */ /*TargetOpcode::G_SHUFFLE_VECTOR*//*Label 93*/ GIMT_Encode4(7484), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  946 */ /*TargetOpcode::G_BITREVERSE*//*Label 94*/ GIMT_Encode4(7561), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  998 */ /*TargetOpcode::G_FSQRT*//*Label 95*/ GIMT_Encode4(7650),
     /* 1002 */ // Label 0: @1002
     /* 1002 */ GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1013), // Rule ID 13 //
     /* 1007 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule13Enabled),
     /* 1010 */   // MIs[0] d
     /* 1010 */   // No operand predicates
     /* 1010 */   // MIs[0] s
     /* 1010 */   // No operand predicates
     /* 1010 */   // Combiner Rule #13: copy_prop
     /* 1010 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /* 1013 */ // Label 97: @1013
     /* 1013 */ GIM_Reject,
     /* 1014 */ // Label 1: @1014
     /* 1014 */ GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1025), // Rule ID 16 //
     /* 1019 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule16Enabled),
     /* 1022 */   // Combiner Rule #16: add_p2i_to_ptradd; wip_match_opcode 'G_ADD'
     /* 1022 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner8),
     /* 1025 */ // Label 98: @1025
     /* 1025 */ GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1036), // Rule ID 94 //
     /* 1030 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1033 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_ADD'
     /* 1033 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1036 */ // Label 99: @1036
     /* 1036 */ GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1047), // Rule ID 142 //
     /* 1041 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule104Enabled),
     /* 1044 */   // Combiner Rule #104: simplify_add_to_sub; wip_match_opcode 'G_ADD'
     /* 1044 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner54),
     /* 1047 */ // Label 100: @1047
     /* 1047 */ GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1058), // Rule ID 236 //
     /* 1052 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 1055 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_ADD'
     /* 1055 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1058 */ // Label 101: @1058
     /* 1058 */ GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1069), // Rule ID 280 //
     /* 1063 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 1066 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_ADD'
     /* 1066 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 1069 */ // Label 102: @1069
     /* 1069 */ GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1080), // Rule ID 315 //
     /* 1074 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 1077 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_ADD'
     /* 1077 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 1080 */ // Label 103: @1080
     /* 1080 */ GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1114), // Rule ID 0 //
     /* 1085 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule0Enabled),
     /* 1088 */   // MIs[0] root
     /* 1088 */   // No operand predicates
     /* 1088 */   // MIs[0] sub
     /* 1088 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1092 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1096 */   // MIs[1] Operand 1
     /* 1096 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
     /* 1100 */   // MIs[1] A
     /* 1100 */   // No operand predicates
     /* 1100 */   // MIs[0] B
     /* 1100 */   // No operand predicates
     /* 1100 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1102 */   // Combiner Rule #0: ZeroMinusAPlusB
     /* 1102 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1105 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1107 */   GIR_RootToRootCopy, /*OpIdx*/2, // B
     /* 1109 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // A
     /* 1113 */   GIR_EraseRootFromParent_Done,
     /* 1114 */ // Label 104: @1114
     /* 1114 */ GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1151), // Rule ID 12 //
     /* 1119 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule12Enabled),
     /* 1122 */   // MIs[0] root
     /* 1122 */   // No operand predicates
     /* 1122 */   // MIs[0] sub
     /* 1122 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1126 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1130 */   // MIs[1] A
     /* 1130 */   // No operand predicates
     /* 1130 */   // MIs[1] c1
     /* 1130 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1134 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1138 */   // MIs[2] imm1
     /* 1138 */   // No operand predicates
     /* 1138 */   // MIs[0] c2
     /* 1138 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1142 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1146 */   // MIs[3] imm2
     /* 1146 */   // No operand predicates
     /* 1146 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1148 */   // Combiner Rule #12: AMinusC1PlusC2
     /* 1148 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner4),
     /* 1151 */ // Label 105: @1151
     /* 1151 */ GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1185), // Rule ID 3 //
     /* 1156 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule3Enabled),
     /* 1159 */   // MIs[0] root
     /* 1159 */   // No operand predicates
     /* 1159 */   // MIs[0] sub
     /* 1159 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1163 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1167 */   // MIs[1] B
     /* 1167 */   // No operand predicates
     /* 1167 */   // MIs[1] A
     /* 1167 */   // No operand predicates
     /* 1167 */   // MIs[0] A
     /* 1167 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1172 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1177 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1179 */   // Combiner Rule #3: BMinusAPlusA
     /* 1179 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1184 */   GIR_EraseRootFromParent_Done,
     /* 1185 */ // Label 106: @1185
     /* 1185 */ GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1219), // Rule ID 131 //
     /* 1190 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule94Enabled),
     /* 1193 */   // MIs[0] dst
     /* 1193 */   // No operand predicates
     /* 1193 */   // MIs[0] __add_sub_reg_match_0.tmp
     /* 1193 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1197 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1201 */   // MIs[1] src
     /* 1201 */   // No operand predicates
     /* 1201 */   // MIs[1] __add_sub_reg_match_0.x
     /* 1201 */   // No operand predicates
     /* 1201 */   // MIs[0] __add_sub_reg_match_0.x
     /* 1201 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1206 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1211 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1213 */   // Combiner Rule #94: add_sub_reg @ [__add_sub_reg_match_0[1]]
     /* 1213 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1218 */   GIR_EraseRootFromParent_Done,
     /* 1219 */ // Label 107: @1219
     /* 1219 */ GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1264), // Rule ID 5 //
     /* 1224 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1227 */   // MIs[0] root
     /* 1227 */   // No operand predicates
     /* 1227 */   // MIs[0] sub1
     /* 1227 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1231 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1235 */   // MIs[1] A
     /* 1235 */   // No operand predicates
     /* 1235 */   // MIs[1] B
     /* 1235 */   // No operand predicates
     /* 1235 */   // MIs[0] sub2
     /* 1235 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1239 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1243 */   // MIs[2] B
     /* 1243 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1248 */   // MIs[2] C
     /* 1248 */   // No operand predicates
     /* 1248 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1250 */   // Combiner Rule #5: AMinusBPlusBMinusC
     /* 1250 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1253 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1255 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // A
     /* 1259 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // C
     /* 1263 */   GIR_EraseRootFromParent_Done,
     /* 1264 */ // Label 108: @1264
     /* 1264 */ GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1309), // Rule ID 4 //
     /* 1269 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule4Enabled),
     /* 1272 */   // MIs[0] root
     /* 1272 */   // No operand predicates
     /* 1272 */   // MIs[0] sub1
     /* 1272 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1276 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1280 */   // MIs[1] A
     /* 1280 */   // No operand predicates
     /* 1280 */   // MIs[1] B
     /* 1280 */   // No operand predicates
     /* 1280 */   // MIs[0] sub2
     /* 1280 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1284 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1288 */   // MIs[2] C
     /* 1288 */   // No operand predicates
     /* 1288 */   // MIs[2] A
     /* 1288 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 1293 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1295 */   // Combiner Rule #4: AMinusBPlusCMinusA
     /* 1295 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1298 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1300 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
     /* 1304 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
     /* 1308 */   GIR_EraseRootFromParent_Done,
     /* 1309 */ // Label 109: @1309
     /* 1309 */ GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1344), // Rule ID 39 //
     /* 1314 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule37Enabled),
     /* 1317 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1323 */   // MIs[0] root
     /* 1323 */   // No operand predicates
     /* 1323 */   // MIs[0] left
     /* 1323 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1327 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1331 */   // MIs[1] imm1
     /* 1331 */   // No operand predicates
     /* 1331 */   // MIs[0] right
     /* 1331 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1335 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1339 */   // MIs[2] imm2
     /* 1339 */   // No operand predicates
     /* 1339 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1341 */   // Combiner Rule #37: add_of_vscale
     /* 1341 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1344 */ // Label 110: @1344
     /* 1344 */ GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1378), // Rule ID 1 //
     /* 1349 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule1Enabled),
     /* 1352 */   // MIs[0] root
     /* 1352 */   // No operand predicates
     /* 1352 */   // MIs[0] A
     /* 1352 */   // No operand predicates
     /* 1352 */   // MIs[0] sub
     /* 1352 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1356 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1360 */   // MIs[1] Operand 1
     /* 1360 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
     /* 1364 */   // MIs[1] B
     /* 1364 */   // No operand predicates
     /* 1364 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1366 */   // Combiner Rule #1: APlusZeroMinusB
     /* 1366 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1369 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1371 */   GIR_RootToRootCopy, /*OpIdx*/1, // A
     /* 1373 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
     /* 1377 */   GIR_EraseRootFromParent_Done,
     /* 1378 */ // Label 111: @1378
     /* 1378 */ GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1412), // Rule ID 2 //
     /* 1383 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule2Enabled),
     /* 1386 */   // MIs[0] root
     /* 1386 */   // No operand predicates
     /* 1386 */   // MIs[0] A
     /* 1386 */   // No operand predicates
     /* 1386 */   // MIs[0] sub
     /* 1386 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1390 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1394 */   // MIs[1] B
     /* 1394 */   // No operand predicates
     /* 1394 */   // MIs[1] A
     /* 1394 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1399 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1404 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1406 */   // Combiner Rule #2: APlusBMinusB
     /* 1406 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1411 */   GIR_EraseRootFromParent_Done,
     /* 1412 */ // Label 112: @1412
     /* 1412 */ GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1446), // Rule ID 130 //
     /* 1417 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule94Enabled),
     /* 1420 */   // MIs[0] dst
     /* 1420 */   // No operand predicates
     /* 1420 */   // MIs[0] __add_sub_reg_match_0.x
     /* 1420 */   // No operand predicates
     /* 1420 */   // MIs[0] __add_sub_reg_match_0.tmp
     /* 1420 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1424 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1428 */   // MIs[1] src
     /* 1428 */   // No operand predicates
     /* 1428 */   // MIs[1] __add_sub_reg_match_0.x
     /* 1428 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1433 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1438 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1440 */   // Combiner Rule #94: add_sub_reg @ [__add_sub_reg_match_0[0]]
     /* 1440 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1445 */   GIR_EraseRootFromParent_Done,
     /* 1446 */ // Label 113: @1446
     /* 1446 */ GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1491), // Rule ID 6 //
     /* 1451 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule6Enabled),
     /* 1454 */   // MIs[0] root
     /* 1454 */   // No operand predicates
     /* 1454 */   // MIs[0] A
     /* 1454 */   // No operand predicates
     /* 1454 */   // MIs[0] sub1
     /* 1454 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1458 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1462 */   // MIs[1] B
     /* 1462 */   // No operand predicates
     /* 1462 */   // MIs[1] add1
     /* 1462 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1466 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1470 */   // MIs[2] A
     /* 1470 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1475 */   // MIs[2] C
     /* 1475 */   // No operand predicates
     /* 1475 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1477 */   // Combiner Rule #6: APlusBMinusAplusC
     /* 1477 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1480 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1482 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
     /* 1486 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // C
     /* 1490 */   GIR_EraseRootFromParent_Done,
     /* 1491 */ // Label 114: @1491
     /* 1491 */ GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(1536), // Rule ID 7 //
     /* 1496 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /* 1499 */   // MIs[0] root
     /* 1499 */   // No operand predicates
     /* 1499 */   // MIs[0] A
     /* 1499 */   // No operand predicates
     /* 1499 */   // MIs[0] sub1
     /* 1499 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1503 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1507 */   // MIs[1] B
     /* 1507 */   // No operand predicates
     /* 1507 */   // MIs[1] add1
     /* 1507 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1511 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1515 */   // MIs[2] C
     /* 1515 */   // No operand predicates
     /* 1515 */   // MIs[2] A
     /* 1515 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1520 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1522 */   // Combiner Rule #7: APlusBMinusCPlusA
     /* 1522 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1525 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1527 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
     /* 1531 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
     /* 1535 */   GIR_EraseRootFromParent_Done,
     /* 1536 */ // Label 115: @1536
     /* 1536 */ GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1559), // Rule ID 105 //
     /* 1541 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 1544 */   // MIs[0] dst
     /* 1544 */   // No operand predicates
     /* 1544 */   // MIs[0] lhs
     /* 1544 */   // No operand predicates
     /* 1544 */   // MIs[0] Operand 2
     /* 1544 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1548 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1553 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[1]]
     /* 1553 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1558 */   GIR_EraseRootFromParent_Done,
     /* 1559 */ // Label 116: @1559
     /* 1559 */ GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1570), // Rule ID 150 //
     /* 1564 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule108Enabled),
     /* 1567 */   // MIs[0] root
     /* 1567 */   // No operand predicates
     /* 1567 */   // MIs[0] src1
     /* 1567 */   // No operand predicates
     /* 1567 */   // MIs[0] src2
     /* 1567 */   // No operand predicates
     /* 1567 */   // Combiner Rule #108: reassoc_comm_binops
     /* 1567 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 1570 */ // Label 117: @1570
     /* 1570 */ GIM_Reject,
     /* 1571 */ // Label 2: @1571
     /* 1571 */ GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1582), // Rule ID 95 //
     /* 1576 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1579 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_SUB'
     /* 1579 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1582 */ // Label 118: @1582
     /* 1582 */ GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1593), // Rule ID 244 //
     /* 1587 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 1590 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SUB'
     /* 1590 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1593 */ // Label 119: @1593
     /* 1593 */ GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1604), // Rule ID 281 //
     /* 1598 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 1601 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SUB'
     /* 1601 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 1604 */ // Label 120: @1604
     /* 1604 */ GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1615), // Rule ID 312 //
     /* 1609 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 1612 */   // Combiner Rule #192: sub_add_reg; wip_match_opcode 'G_SUB'
     /* 1612 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner124),
     /* 1615 */ // Label 121: @1615
     /* 1615 */ GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1626), // Rule ID 346 //
     /* 1620 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule199Enabled),
     /* 1623 */   // Combiner Rule #199: simplify_neg_minmax; wip_match_opcode 'G_SUB'
     /* 1623 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner131),
     /* 1626 */ // Label 122: @1626
     /* 1626 */ GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1663), // Rule ID 8 //
     /* 1631 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule8Enabled),
     /* 1634 */   // MIs[0] root
     /* 1634 */   // No operand predicates
     /* 1634 */   // MIs[0] add
     /* 1634 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1638 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1642 */   // MIs[1] A
     /* 1642 */   // No operand predicates
     /* 1642 */   // MIs[1] c1
     /* 1642 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1646 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1650 */   // MIs[2] imm1
     /* 1650 */   // No operand predicates
     /* 1650 */   // MIs[0] c2
     /* 1650 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1654 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1658 */   // MIs[3] imm2
     /* 1658 */   // No operand predicates
     /* 1658 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1660 */   // Combiner Rule #8: APlusC1MinusC2
     /* 1660 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner0),
     /* 1663 */ // Label 123: @1663
     /* 1663 */ GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1700), // Rule ID 11 //
     /* 1668 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule11Enabled),
     /* 1671 */   // MIs[0] root
     /* 1671 */   // No operand predicates
     /* 1671 */   // MIs[0] sub1
     /* 1671 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1675 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1679 */   // MIs[1] c1
     /* 1679 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 1683 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1687 */   // MIs[2] imm1
     /* 1687 */   // No operand predicates
     /* 1687 */   // MIs[1] A
     /* 1687 */   // No operand predicates
     /* 1687 */   // MIs[0] c2
     /* 1687 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1691 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1695 */   // MIs[3] imm2
     /* 1695 */   // No operand predicates
     /* 1695 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1697 */   // Combiner Rule #11: C1Minus2MinusC2
     /* 1697 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner3),
     /* 1700 */ // Label 124: @1700
     /* 1700 */ GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1737), // Rule ID 10 //
     /* 1705 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule10Enabled),
     /* 1708 */   // MIs[0] root
     /* 1708 */   // No operand predicates
     /* 1708 */   // MIs[0] sub1
     /* 1708 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1712 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1716 */   // MIs[1] A
     /* 1716 */   // No operand predicates
     /* 1716 */   // MIs[1] c1
     /* 1716 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1720 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1724 */   // MIs[2] imm1
     /* 1724 */   // No operand predicates
     /* 1724 */   // MIs[0] c2
     /* 1724 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1728 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1732 */   // MIs[3] imm2
     /* 1732 */   // No operand predicates
     /* 1732 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1734 */   // Combiner Rule #10: AMinusC1MinusC2
     /* 1734 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 1737 */ // Label 125: @1737
     /* 1737 */ GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1780), // Rule ID 160 //
     /* 1742 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule118Enabled),
     /* 1745 */   // MIs[0] dst
     /* 1745 */   // No operand predicates
     /* 1745 */   // MIs[0] Operand 1
     /* 1745 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 1749 */   // MIs[0] and
     /* 1749 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1753 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /* 1757 */   // MIs[1] x
     /* 1757 */   // No operand predicates
     /* 1757 */   // MIs[1] Operand 2
     /* 1757 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /* 1761 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner8),
     /* 1765 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1767 */   // Combiner Rule #118: neg_and_one_to_sext_inreg
     /* 1767 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /* 1770 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 1772 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 1776 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /* 1779 */   GIR_EraseRootFromParent_Done,
     /* 1780 */ // Label 126: @1780
     /* 1780 */ GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1817), // Rule ID 9 //
     /* 1785 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule9Enabled),
     /* 1788 */   // MIs[0] root
     /* 1788 */   // No operand predicates
     /* 1788 */   // MIs[0] c2
     /* 1788 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1792 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1796 */   // MIs[1] imm2
     /* 1796 */   // No operand predicates
     /* 1796 */   // MIs[0] add
     /* 1796 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1800 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1804 */   // MIs[2] A
     /* 1804 */   // No operand predicates
     /* 1804 */   // MIs[2] c1
     /* 1804 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /* 1808 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1812 */   // MIs[3] imm1
     /* 1812 */   // No operand predicates
     /* 1812 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1814 */   // Combiner Rule #9: C2MinusAPlusC1
     /* 1814 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 1817 */ // Label 127: @1817
     /* 1817 */ GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1844), // Rule ID 42 //
     /* 1822 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule40Enabled),
     /* 1825 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1831 */   // MIs[0] root
     /* 1831 */   // No operand predicates
     /* 1831 */   // MIs[0] x
     /* 1831 */   // No operand predicates
     /* 1831 */   // MIs[0] right
     /* 1831 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1835 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1839 */   // MIs[1] imm
     /* 1839 */   // No operand predicates
     /* 1839 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1841 */   // Combiner Rule #40: sub_of_vscale
     /* 1841 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner18),
     /* 1844 */ // Label 128: @1844
     /* 1844 */ GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1867), // Rule ID 104 //
     /* 1849 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 1852 */   // MIs[0] dst
     /* 1852 */   // No operand predicates
     /* 1852 */   // MIs[0] lhs
     /* 1852 */   // No operand predicates
     /* 1852 */   // MIs[0] Operand 2
     /* 1852 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1856 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1861 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[0]]
     /* 1861 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1866 */   GIR_EraseRootFromParent_Done,
     /* 1867 */ // Label 129: @1867
     /* 1867 */ GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1888), // Rule ID 15 //
     /* 1872 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /* 1875 */   // MIs[0] d
     /* 1875 */   // No operand predicates
     /* 1875 */   // MIs[0] op1
     /* 1875 */   // No operand predicates
     /* 1875 */   // MIs[0] c
     /* 1875 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1879 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1883 */   // MIs[1] imm
     /* 1883 */   // No operand predicates
     /* 1883 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1885 */   // Combiner Rule #15: sub_to_add
     /* 1885 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner7),
     /* 1888 */ // Label 130: @1888
     /* 1888 */ GIM_Reject,
     /* 1889 */ // Label 3: @1889
     /* 1889 */ GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1900), // Rule ID 78 //
     /* 1894 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 1897 */   // Combiner Rule #72: undef_to_int_zero; wip_match_opcode 'G_MUL'
     /* 1897 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner34),
     /* 1900 */ // Label 131: @1900
     /* 1900 */ GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1911), // Rule ID 241 //
     /* 1905 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 1908 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_MUL'
     /* 1908 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1911 */ // Label 132: @1911
     /* 1911 */ GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1922), // Rule ID 316 //
     /* 1916 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 1919 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_MUL'
     /* 1919 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 1922 */ // Label 133: @1922
     /* 1922 */ GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1962), // Rule ID 17 //
     /* 1927 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /* 1930 */   // MIs[0] dst
     /* 1930 */   GIM_RecordRegType, /*MI*/0, /*Op*/0, /*TempTypeIdx*/255,
     /* 1934 */   // MIs[0] x
     /* 1934 */   // No operand predicates
     /* 1934 */   // MIs[0] Operand 2
     /* 1934 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /* 1938 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/255,
     /* 1941 */   GIR_BuildConstant, /*TempRegID*/0, /*Val*/GIMT_Encode8(0),
     /* 1951 */   // Combiner Rule #17: mul_by_neg_one
     /* 1951 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1954 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 1956 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 1959 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 1961 */   GIR_EraseRootFromParent_Done,
     /* 1962 */ // Label 134: @1962
     /* 1962 */ GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(1997), // Rule ID 40 //
     /* 1967 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule38Enabled),
     /* 1970 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1976 */   // MIs[0] root
     /* 1976 */   // No operand predicates
     /* 1976 */   // MIs[0] left
     /* 1976 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1980 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1984 */   // MIs[1] scale
     /* 1984 */   // No operand predicates
     /* 1984 */   // MIs[0] x
     /* 1984 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1988 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1992 */   // MIs[2] imm1
     /* 1992 */   // No operand predicates
     /* 1992 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1994 */   // Combiner Rule #38: mul_of_vscale
     /* 1994 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner16),
     /* 1997 */ // Label 135: @1997
     /* 1997 */ GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2020), // Rule ID 123 //
     /* 2002 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 2005 */   // MIs[0] dst
     /* 2005 */   // No operand predicates
     /* 2005 */   // MIs[0] lhs
     /* 2005 */   // No operand predicates
     /* 2005 */   // MIs[0] zero
     /* 2005 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2009 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 2014 */   // Combiner Rule #87: binop_right_to_zero
     /* 2014 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 2019 */   GIR_EraseRootFromParent_Done,
     /* 2020 */ // Label 136: @2020
     /* 2020 */ GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2043), // Rule ID 128 //
     /* 2025 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule92Enabled),
     /* 2028 */   // MIs[0] dst
     /* 2028 */   // No operand predicates
     /* 2028 */   // MIs[0] x
     /* 2028 */   // No operand predicates
     /* 2028 */   // MIs[0] Operand 2
     /* 2028 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /* 2032 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2037 */   // Combiner Rule #92: right_identity_one_int
     /* 2037 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2042 */   GIR_EraseRootFromParent_Done,
     /* 2043 */ // Label 137: @2043
     /* 2043 */ GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2054), // Rule ID 14 //
     /* 2048 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule14Enabled),
     /* 2051 */   // MIs[0] d
     /* 2051 */   // No operand predicates
     /* 2051 */   // MIs[0] op1
     /* 2051 */   // No operand predicates
     /* 2051 */   // MIs[0] op2
     /* 2051 */   // No operand predicates
     /* 2051 */   // Combiner Rule #14: mul_to_shl
     /* 2051 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner6),
     /* 2054 */ // Label 138: @2054
     /* 2054 */ GIM_Reject,
     /* 2055 */ // Label 4: @2055
     /* 2055 */ GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2066), // Rule ID 119 //
     /* 2060 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2063 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SDIV'
     /* 2063 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2066 */ // Label 139: @2066
     /* 2066 */ GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2077), // Rule ID 212 //
     /* 2071 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2074 */   // Combiner Rule #154: div_rem_to_divrem; wip_match_opcode 'G_SDIV'
     /* 2074 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2077 */ // Label 140: @2077
     /* 2077 */ GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2088), // Rule ID 247 //
     /* 2082 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2085 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SDIV'
     /* 2085 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2088 */ // Label 141: @2088
     /* 2088 */ GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2099), // Rule ID 286 //
     /* 2093 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2096 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SDIV'
     /* 2096 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2099 */ // Label 142: @2099
     /* 2099 */ GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2116), // Rule ID 309 //
     /* 2104 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule189Enabled),
     /* 2107 */   GIM_MIFlagsNot, /*MI*/0, GIMT_Encode4(MachineInstr::IsExact),
     /* 2113 */   // MIs[0] dst
     /* 2113 */   // No operand predicates
     /* 2113 */   // MIs[0] x
     /* 2113 */   // No operand predicates
     /* 2113 */   // MIs[0] y
     /* 2113 */   // No operand predicates
     /* 2113 */   // Combiner Rule #189: sdiv_by_pow2
     /* 2113 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner123),
     /* 2116 */ // Label 143: @2116
     /* 2116 */ GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2127), // Rule ID 311 //
     /* 2121 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 2124 */   // MIs[0] dst
     /* 2124 */   // No operand predicates
     /* 2124 */   // MIs[0] x
     /* 2124 */   // No operand predicates
     /* 2124 */   // MIs[0] y
     /* 2124 */   // No operand predicates
     /* 2124 */   // Combiner Rule #191: sdiv_by_const
     /* 2124 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner121),
     /* 2127 */ // Label 144: @2127
     /* 2127 */ GIM_Reject,
     /* 2128 */ // Label 5: @2128
     /* 2128 */ GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2139), // Rule ID 81 //
     /* 2133 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 2136 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_UDIV'
     /* 2136 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 2139 */ // Label 145: @2139
     /* 2139 */ GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2150), // Rule ID 120 //
     /* 2144 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2147 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_UDIV'
     /* 2147 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2150 */ // Label 146: @2150
     /* 2150 */ GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2161), // Rule ID 213 //
     /* 2155 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2158 */   // Combiner Rule #154: div_rem_to_divrem; wip_match_opcode 'G_UDIV'
     /* 2158 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2161 */ // Label 147: @2161
     /* 2161 */ GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2172), // Rule ID 246 //
     /* 2166 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2169 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_UDIV'
     /* 2169 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2172 */ // Label 148: @2172
     /* 2172 */ GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2183), // Rule ID 288 //
     /* 2177 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2180 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_UDIV'
     /* 2180 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2183 */ // Label 149: @2183
     /* 2183 */ GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2200), // Rule ID 308 //
     /* 2188 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule188Enabled),
     /* 2191 */   GIM_MIFlagsNot, /*MI*/0, GIMT_Encode4(MachineInstr::IsExact),
     /* 2197 */   // MIs[0] dst
     /* 2197 */   // No operand predicates
     /* 2197 */   // MIs[0] x
     /* 2197 */   // No operand predicates
     /* 2197 */   // MIs[0] y
     /* 2197 */   // No operand predicates
     /* 2197 */   // Combiner Rule #188: udiv_by_pow2
     /* 2197 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner122),
     /* 2200 */ // Label 150: @2200
     /* 2200 */ GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2211), // Rule ID 310 //
     /* 2205 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule190Enabled),
     /* 2208 */   // MIs[0] dst
     /* 2208 */   // No operand predicates
     /* 2208 */   // MIs[0] x
     /* 2208 */   // No operand predicates
     /* 2208 */   // MIs[0] y
     /* 2208 */   // No operand predicates
     /* 2208 */   // Combiner Rule #190: udiv_by_const
     /* 2208 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner120),
     /* 2211 */ // Label 151: @2211
     /* 2211 */ GIM_Reject,
     /* 2212 */ // Label 6: @2212
     /* 2212 */ GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2223), // Rule ID 121 //
     /* 2217 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2220 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SREM'
     /* 2220 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2223 */ // Label 152: @2223
     /* 2223 */ GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(2234), // Rule ID 214 //
     /* 2228 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2231 */   // Combiner Rule #154: div_rem_to_divrem; wip_match_opcode 'G_SREM'
     /* 2231 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2234 */ // Label 153: @2234
     /* 2234 */ GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(2245), // Rule ID 249 //
     /* 2239 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2242 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SREM'
     /* 2242 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2245 */ // Label 154: @2245
     /* 2245 */ GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(2256), // Rule ID 287 //
     /* 2250 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2253 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SREM'
     /* 2253 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2256 */ // Label 155: @2256
     /* 2256 */ GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(2267), // Rule ID 307 //
     /* 2261 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule187Enabled),
     /* 2264 */   // MIs[0] dst
     /* 2264 */   // No operand predicates
     /* 2264 */   // MIs[0] x
     /* 2264 */   // No operand predicates
     /* 2264 */   // MIs[0] y
     /* 2264 */   // No operand predicates
     /* 2264 */   // Combiner Rule #187: srem_by_const
     /* 2264 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner121),
     /* 2267 */ // Label 156: @2267
     /* 2267 */ GIM_Reject,
     /* 2268 */ // Label 7: @2268
     /* 2268 */ GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(2279), // Rule ID 82 //
     /* 2273 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 2276 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_UREM'
     /* 2276 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 2279 */ // Label 157: @2279
     /* 2279 */ GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(2290), // Rule ID 122 //
     /* 2284 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2287 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_UREM'
     /* 2287 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2290 */ // Label 158: @2290
     /* 2290 */ GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(2301), // Rule ID 171 //
     /* 2295 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule129Enabled),
     /* 2298 */   // Combiner Rule #129: urem_pow2_to_mask; wip_match_opcode 'G_UREM'
     /* 2298 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner75),
     /* 2301 */ // Label 159: @2301
     /* 2301 */ GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(2312), // Rule ID 215 //
     /* 2306 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2309 */   // Combiner Rule #154: div_rem_to_divrem; wip_match_opcode 'G_UREM'
     /* 2309 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2312 */ // Label 160: @2312
     /* 2312 */ GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(2323), // Rule ID 248 //
     /* 2317 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2320 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_UREM'
     /* 2320 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2323 */ // Label 161: @2323
     /* 2323 */ GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(2334), // Rule ID 289 //
     /* 2328 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2331 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_UREM'
     /* 2331 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2334 */ // Label 162: @2334
     /* 2334 */ GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(2345), // Rule ID 306 //
     /* 2339 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule186Enabled),
     /* 2342 */   // MIs[0] dst
     /* 2342 */   // No operand predicates
     /* 2342 */   // MIs[0] x
     /* 2342 */   // No operand predicates
     /* 2342 */   // MIs[0] y
     /* 2342 */   // No operand predicates
     /* 2342 */   // Combiner Rule #186: urem_by_const
     /* 2342 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner120),
     /* 2345 */ // Label 163: @2345
     /* 2345 */ GIM_Reject,
     /* 2346 */ // Label 8: @2346
     /* 2346 */ GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(2357), // Rule ID 73 //
     /* 2351 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule69Enabled),
     /* 2354 */   // Combiner Rule #69: load_and_mask; wip_match_opcode 'G_AND'
     /* 2354 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner31),
     /* 2357 */ // Label 164: @2357
     /* 2357 */ GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(2368), // Rule ID 77 //
     /* 2362 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 2365 */   // Combiner Rule #72: undef_to_int_zero; wip_match_opcode 'G_AND'
     /* 2365 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner34),
     /* 2368 */ // Label 165: @2368
     /* 2368 */ GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(2379), // Rule ID 143 //
     /* 2373 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 2376 */   // Combiner Rule #105: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_AND'
     /* 2376 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2379 */ // Label 166: @2379
     /* 2379 */ GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(2390), // Rule ID 163 //
     /* 2384 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule121Enabled),
     /* 2387 */   // Combiner Rule #121: narrow_binop_feeding_and; wip_match_opcode 'G_AND'
     /* 2387 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 2390 */ // Label 167: @2390
     /* 2390 */ GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(2401), // Rule ID 168 //
     /* 2395 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule126Enabled),
     /* 2398 */   // Combiner Rule #126: redundant_and; wip_match_opcode 'G_AND'
     /* 2398 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner72),
     /* 2401 */ // Label 168: @2401
     /* 2401 */ GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2412), // Rule ID 185 //
     /* 2406 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule143Enabled),
     /* 2409 */   // Combiner Rule #143: overlapping_and; wip_match_opcode 'G_AND'
     /* 2409 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner84),
     /* 2412 */ // Label 169: @2412
     /* 2412 */ GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(2423), // Rule ID 238 //
     /* 2417 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2420 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_AND'
     /* 2420 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2423 */ // Label 170: @2423
     /* 2423 */ GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(2434), // Rule ID 271 //
     /* 2428 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule176Enabled),
     /* 2431 */   // Combiner Rule #176: and_or_disjoint_mask; wip_match_opcode 'G_AND'
     /* 2431 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner110),
     /* 2434 */ // Label 171: @2434
     /* 2434 */ GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2445), // Rule ID 283 //
     /* 2439 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2442 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_AND'
     /* 2442 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2445 */ // Label 172: @2445
     /* 2445 */ GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2456), // Rule ID 317 //
     /* 2450 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 2453 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_AND'
     /* 2453 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2456 */ // Label 173: @2456
     /* 2456 */ GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(2467), // Rule ID 344 //
     /* 2461 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule197Enabled),
     /* 2464 */   // Combiner Rule #197: match_ands; wip_match_opcode 'G_AND'
     /* 2464 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner129),
     /* 2467 */ // Label 174: @2467
     /* 2467 */ GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(2565), // Rule ID 156 //
     /* 2472 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule114Enabled),
     /* 2475 */   // MIs[0] root
     /* 2475 */   // No operand predicates
     /* 2475 */   // MIs[0] d1
     /* 2475 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2479 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2483 */   // MIs[1] p
     /* 2483 */   // No operand predicates
     /* 2483 */   // MIs[1] s1
     /* 2483 */   GIM_RecordRegType, /*MI*/1, /*Op*/2, /*TempTypeIdx*/255,
     /* 2487 */   // MIs[1] Operand 3
     /* 2487 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 2491 */   // MIs[0] d2
     /* 2491 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2495 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2499 */   // MIs[2] p
     /* 2499 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2504 */   // MIs[2] s2
     /* 2504 */   // No operand predicates
     /* 2504 */   // MIs[2] Operand 3
     /* 2504 */   GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 0,
     /* 2508 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner6),
     /* 2512 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2514 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/255,
     /* 2517 */   GIR_BuildConstant, /*TempRegID*/1, /*Val*/GIMT_Encode8(0),
     /* 2527 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/255,
     /* 2530 */   // Combiner Rule #114: double_icmp_zero_and_combine
     /* 2530 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 2533 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2538 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // s1
     /* 2542 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // s2
     /* 2546 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2550 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/0, // root
     /* 2554 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // p
     /* 2558 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
     /* 2561 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 2564 */   GIR_EraseRootFromParent_Done,
     /* 2565 */ // Label 175: @2565
     /* 2565 */ GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(2602), // Rule ID 231 //
     /* 2570 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2573 */   // MIs[0] root
     /* 2573 */   // No operand predicates
     /* 2573 */   // MIs[0] shift
     /* 2573 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2577 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 2581 */   // MIs[1] x
     /* 2581 */   // No operand predicates
     /* 2581 */   // MIs[1] lsb
     /* 2581 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 2585 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2589 */   // MIs[2] imm1
     /* 2589 */   // No operand predicates
     /* 2589 */   // MIs[0] mask
     /* 2589 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 2593 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2597 */   // MIs[3] imm2
     /* 2597 */   // No operand predicates
     /* 2597 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 2599 */   // Combiner Rule #166: bitfield_extract_from_and
     /* 2599 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner101),
     /* 2602 */ // Label 176: @2602
     /* 2602 */ GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(2716), // Rule ID 378 //
     /* 2607 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule229Enabled),
     /* 2610 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 2613 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 2616 */   // MIs[0] dst
     /* 2616 */   // No operand predicates
     /* 2616 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner13),
     /* 2620 */   GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
     /* 2623 */   GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
     /* 2626 */   GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /* 2629 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /* 2632 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /* 2635 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 2638 */   // Combiner Rule #229: combine_and_s64_with_s32_mask
     /* 2638 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_UNMERGE_VALUES),
     /* 2641 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2646 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2651 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 2653 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_UNMERGE_VALUES),
     /* 2657 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2662 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2667 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // y
     /* 2671 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::G_AND),
     /* 2675 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2680 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/0,
     /* 2683 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /* 2686 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::G_AND),
     /* 2690 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2695 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/1,
     /* 2698 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
     /* 2701 */   GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::G_MERGE_VALUES),
     /* 2705 */   GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/0, // dst
     /* 2709 */   GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /* 2712 */   GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/5,
     /* 2715 */   GIR_EraseRootFromParent_Done,
     /* 2716 */ // Label 177: @2716
     /* 2716 */ GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(2740), // Rule ID 114 //
     /* 2721 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule85Enabled),
     /* 2724 */   // MIs[0] dst
     /* 2724 */   // No operand predicates
     /* 2724 */   // MIs[0] src
     /* 2724 */   // No operand predicates
     /* 2724 */   // MIs[0] src
     /* 2724 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 2729 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2734 */   // Combiner Rule #85: binop_same_val @ [__binop_same_val_match_0[0]]
     /* 2734 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2739 */   GIR_EraseRootFromParent_Done,
     /* 2740 */ // Label 178: @2740
     /* 2740 */ GIM_Reject,
     /* 2741 */ // Label 9: @2741
     /* 2741 */ GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(2752), // Rule ID 79 //
     /* 2746 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule73Enabled),
     /* 2749 */   // Combiner Rule #73: undef_to_negative_one; wip_match_opcode 'G_OR'
     /* 2749 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner35),
     /* 2752 */ // Label 179: @2752
     /* 2752 */ GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(2763), // Rule ID 144 //
     /* 2757 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 2760 */   // Combiner Rule #105: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_OR'
     /* 2760 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2763 */ // Label 180: @2763
     /* 2763 */ GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(2774), // Rule ID 170 //
     /* 2768 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule128Enabled),
     /* 2771 */   // Combiner Rule #128: redundant_or; wip_match_opcode 'G_OR'
     /* 2771 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner74),
     /* 2774 */ // Label 181: @2774
     /* 2774 */ GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(2785), // Rule ID 211 //
     /* 2779 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2782 */   // Combiner Rule #153: load_or_combine; wip_match_opcode 'G_OR'
     /* 2782 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner94),
     /* 2785 */ // Label 182: @2785
     /* 2785 */ GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(2796), // Rule ID 216 //
     /* 2790 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule155Enabled),
     /* 2793 */   // Combiner Rule #155: funnel_shift_from_or_shift; wip_match_opcode 'G_OR'
     /* 2793 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner96),
     /* 2796 */ // Label 183: @2796
     /* 2796 */ GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(2807), // Rule ID 242 //
     /* 2801 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2804 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_OR'
     /* 2804 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2807 */ // Label 184: @2807
     /* 2807 */ GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(2818), // Rule ID 284 //
     /* 2812 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2815 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_OR'
     /* 2815 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2818 */ // Label 185: @2818
     /* 2818 */ GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(2829), // Rule ID 318 //
     /* 2823 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 2826 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_OR'
     /* 2826 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2829 */ // Label 186: @2829
     /* 2829 */ GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(2840), // Rule ID 345 //
     /* 2834 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule198Enabled),
     /* 2837 */   // Combiner Rule #198: match_ors; wip_match_opcode 'G_OR'
     /* 2837 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner130),
     /* 2840 */ // Label 187: @2840
     /* 2840 */ GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(2887), // Rule ID 223 //
     /* 2845 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule160Enabled),
     /* 2848 */   // MIs[0] root
     /* 2848 */   // No operand predicates
     /* 2848 */   // MIs[0] out1
     /* 2848 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2852 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FSHL),
     /* 2856 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.x
     /* 2856 */   // No operand predicates
     /* 2856 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.z
     /* 2856 */   // No operand predicates
     /* 2856 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.y
     /* 2856 */   // No operand predicates
     /* 2856 */   // MIs[0] out2
     /* 2856 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2860 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 2864 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.x
     /* 2864 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2869 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.y
     /* 2869 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/3,
     /* 2874 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2879 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2881 */   // Combiner Rule #160: funnel_shift_or_shift_to_funnel_shift_left @ [__funnel_shift_or_shift_to_funnel_shift_left_match_0[0]]
     /* 2881 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2886 */   GIR_EraseRootFromParent_Done,
     /* 2887 */ // Label 188: @2887
     /* 2887 */ GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(2934), // Rule ID 225 //
     /* 2892 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule161Enabled),
     /* 2895 */   // MIs[0] root
     /* 2895 */   // No operand predicates
     /* 2895 */   // MIs[0] out1
     /* 2895 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2899 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FSHR),
     /* 2903 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.z
     /* 2903 */   // No operand predicates
     /* 2903 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.x
     /* 2903 */   // No operand predicates
     /* 2903 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.y
     /* 2903 */   // No operand predicates
     /* 2903 */   // MIs[0] out2
     /* 2903 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2907 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 2911 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.x
     /* 2911 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 2916 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.y
     /* 2916 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/3,
     /* 2921 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2926 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2928 */   // Combiner Rule #161: funnel_shift_or_shift_to_funnel_shift_right @ [__funnel_shift_or_shift_to_funnel_shift_right_match_0[0]]
     /* 2928 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2933 */   GIR_EraseRootFromParent_Done,
     /* 2934 */ // Label 189: @2934
     /* 2934 */ GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(3032), // Rule ID 157 //
     /* 2939 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule115Enabled),
     /* 2942 */   // MIs[0] root
     /* 2942 */   // No operand predicates
     /* 2942 */   // MIs[0] d1
     /* 2942 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2946 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2950 */   // MIs[1] p
     /* 2950 */   // No operand predicates
     /* 2950 */   // MIs[1] s1
     /* 2950 */   GIM_RecordRegType, /*MI*/1, /*Op*/2, /*TempTypeIdx*/255,
     /* 2954 */   // MIs[1] Operand 3
     /* 2954 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 2958 */   // MIs[0] d2
     /* 2958 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2962 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2966 */   // MIs[2] p
     /* 2966 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2971 */   // MIs[2] s2
     /* 2971 */   // No operand predicates
     /* 2971 */   // MIs[2] Operand 3
     /* 2971 */   GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 0,
     /* 2975 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner7),
     /* 2979 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2981 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/255,
     /* 2984 */   GIR_BuildConstant, /*TempRegID*/1, /*Val*/GIMT_Encode8(0),
     /* 2994 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/255,
     /* 2997 */   // Combiner Rule #115: double_icmp_zero_or_combine
     /* 2997 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 3000 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3005 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // s1
     /* 3009 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // s2
     /* 3013 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 3017 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/0, // root
     /* 3021 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // p
     /* 3025 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
     /* 3028 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 3031 */   GIR_EraseRootFromParent_Done,
     /* 3032 */ // Label 190: @3032
     /* 3032 */ GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(3079), // Rule ID 226 //
     /* 3037 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule161Enabled),
     /* 3040 */   // MIs[0] root
     /* 3040 */   // No operand predicates
     /* 3040 */   // MIs[0] out2
     /* 3040 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3044 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 3048 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.x
     /* 3048 */   // No operand predicates
     /* 3048 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.y
     /* 3048 */   // No operand predicates
     /* 3048 */   // MIs[0] out1
     /* 3048 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 3052 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FSHR),
     /* 3056 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.z
     /* 3056 */   // No operand predicates
     /* 3056 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.x
     /* 3056 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 3061 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.y
     /* 3061 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 3066 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 3071 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3073 */   // Combiner Rule #161: funnel_shift_or_shift_to_funnel_shift_right @ [__funnel_shift_or_shift_to_funnel_shift_right_match_0[1]]
     /* 3073 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 3078 */   GIR_EraseRootFromParent_Done,
     /* 3079 */ // Label 191: @3079
     /* 3079 */ GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(3126), // Rule ID 224 //
     /* 3084 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule160Enabled),
     /* 3087 */   // MIs[0] root
     /* 3087 */   // No operand predicates
     /* 3087 */   // MIs[0] out2
     /* 3087 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3091 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 3095 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.x
     /* 3095 */   // No operand predicates
     /* 3095 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.y
     /* 3095 */   // No operand predicates
     /* 3095 */   // MIs[0] out1
     /* 3095 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 3099 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FSHL),
     /* 3103 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.x
     /* 3103 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 3108 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.z
     /* 3108 */   // No operand predicates
     /* 3108 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.y
     /* 3108 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 3113 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 3118 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3120 */   // Combiner Rule #160: funnel_shift_or_shift_to_funnel_shift_left @ [__funnel_shift_or_shift_to_funnel_shift_left_match_0[1]]
     /* 3120 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 3125 */   GIR_EraseRootFromParent_Done,
     /* 3126 */ // Label 192: @3126
     /* 3126 */ GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(3240), // Rule ID 377 //
     /* 3131 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule228Enabled),
     /* 3134 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 3137 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 3140 */   // MIs[0] dst
     /* 3140 */   // No operand predicates
     /* 3140 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner13),
     /* 3144 */   GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
     /* 3147 */   GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
     /* 3150 */   GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /* 3153 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /* 3156 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /* 3159 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 3162 */   // Combiner Rule #228: combine_or_s64_with_s32_mask
     /* 3162 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_UNMERGE_VALUES),
     /* 3165 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3170 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3175 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 3177 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_UNMERGE_VALUES),
     /* 3181 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3186 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3191 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // y
     /* 3195 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 3199 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3204 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/0,
     /* 3207 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /* 3210 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 3214 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3219 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/1,
     /* 3222 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
     /* 3225 */   GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::G_MERGE_VALUES),
     /* 3229 */   GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/0, // dst
     /* 3233 */   GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /* 3236 */   GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/5,
     /* 3239 */   GIR_EraseRootFromParent_Done,
     /* 3240 */ // Label 193: @3240
     /* 3240 */ GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(3264), // Rule ID 115 //
     /* 3245 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule85Enabled),
     /* 3248 */   // MIs[0] dst
     /* 3248 */   // No operand predicates
     /* 3248 */   // MIs[0] src
     /* 3248 */   // No operand predicates
     /* 3248 */   // MIs[0] src
     /* 3248 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 3253 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3258 */   // Combiner Rule #85: binop_same_val @ [__binop_same_val_match_0[1]]
     /* 3258 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3263 */   GIR_EraseRootFromParent_Done,
     /* 3264 */ // Label 194: @3264
     /* 3264 */ GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(3287), // Rule ID 106 //
     /* 3269 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 3272 */   // MIs[0] dst
     /* 3272 */   // No operand predicates
     /* 3272 */   // MIs[0] lhs
     /* 3272 */   // No operand predicates
     /* 3272 */   // MIs[0] Operand 2
     /* 3272 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 3276 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3281 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[2]]
     /* 3281 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3286 */   GIR_EraseRootFromParent_Done,
     /* 3287 */ // Label 195: @3287
     /* 3287 */ GIM_Reject,
     /* 3288 */ // Label 10: @3288
     /* 3288 */ GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(3299), // Rule ID 96 //
     /* 3293 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 3296 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_XOR'
     /* 3296 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 3299 */ // Label 196: @3299
     /* 3299 */ GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(3310), // Rule ID 145 //
     /* 3304 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 3307 */   // Combiner Rule #105: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_XOR'
     /* 3307 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 3310 */ // Label 197: @3310
     /* 3310 */ GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(3321), // Rule ID 175 //
     /* 3315 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule133Enabled),
     /* 3318 */   // Combiner Rule #133: not_cmp_fold; wip_match_opcode 'G_XOR'
     /* 3318 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner79),
     /* 3321 */ // Label 198: @3321
     /* 3321 */ GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(3332), // Rule ID 199 //
     /* 3326 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule149Enabled),
     /* 3329 */   // Combiner Rule #149: xor_of_and_with_same_reg; wip_match_opcode 'G_XOR'
     /* 3329 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner90),
     /* 3332 */ // Label 199: @3332
     /* 3332 */ GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3343), // Rule ID 245 //
     /* 3337 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 3340 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_XOR'
     /* 3340 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 3343 */ // Label 200: @3343
     /* 3343 */ GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(3354), // Rule ID 285 //
     /* 3348 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 3351 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_XOR'
     /* 3351 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 3354 */ // Label 201: @3354
     /* 3354 */ GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(3365), // Rule ID 319 //
     /* 3359 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 3362 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_XOR'
     /* 3362 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 3365 */ // Label 202: @3365
     /* 3365 */ GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(3388), // Rule ID 107 //
     /* 3370 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 3373 */   // MIs[0] dst
     /* 3373 */   // No operand predicates
     /* 3373 */   // MIs[0] lhs
     /* 3373 */   // No operand predicates
     /* 3373 */   // MIs[0] Operand 2
     /* 3373 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 3377 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3382 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[3]]
     /* 3382 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3387 */   GIR_EraseRootFromParent_Done,
     /* 3388 */ // Label 203: @3388
     /* 3388 */ GIM_Reject,
     /* 3389 */ // Label 11: @3389
     /* 3389 */ GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(3400), // Rule ID 141 //
     /* 3394 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule103Enabled),
     /* 3397 */   // Combiner Rule #103: extend_through_phis; wip_match_opcode 'G_PHI'
     /* 3397 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner53),
     /* 3400 */ // Label 204: @3400
     /* 3400 */ GIM_Reject,
     /* 3401 */ // Label 12: @3401
     /* 3401 */ GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(3412), // Rule ID 355 //
     /* 3406 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule208Enabled),
     /* 3409 */   // Combiner Rule #208: unmerge_anyext_build_vector; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3409 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner140),
     /* 3412 */ // Label 205: @3412
     /* 3412 */ GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(3423), // Rule ID 356 //
     /* 3417 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule209Enabled),
     /* 3420 */   // Combiner Rule #209: unmerge_merge; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3420 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner141),
     /* 3423 */ // Label 206: @3423
     /* 3423 */ GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(3434), // Rule ID 358 //
     /* 3428 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule211Enabled),
     /* 3431 */   // Combiner Rule #211: unmerge_cst; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3431 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner143),
     /* 3434 */ // Label 207: @3434
     /* 3434 */ GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(3445), // Rule ID 359 //
     /* 3439 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule212Enabled),
     /* 3442 */   // Combiner Rule #212: unmerge_undef; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3442 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner144),
     /* 3445 */ // Label 208: @3445
     /* 3445 */ GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(3456), // Rule ID 360 //
     /* 3450 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule213Enabled),
     /* 3453 */   // Combiner Rule #213: unmerge_dead_to_trunc; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3453 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner145),
     /* 3456 */ // Label 209: @3456
     /* 3456 */ GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(3467), // Rule ID 361 //
     /* 3461 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule214Enabled),
     /* 3464 */   // Combiner Rule #214: unmerge_zext_to_zext; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3464 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner146),
     /* 3467 */ // Label 210: @3467
     /* 3467 */ GIM_Reject,
     /* 3468 */ // Label 13: @3468
     /* 3468 */ GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(3479), // Rule ID 357 //
     /* 3473 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule210Enabled),
     /* 3476 */   // Combiner Rule #210: merge_unmerge; wip_match_opcode 'G_MERGE_VALUES'
     /* 3476 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner142),
     /* 3479 */ // Label 211: @3479
     /* 3479 */ GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(3541),
     /* 3484 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /* 3487 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(3508), // Rule ID 362 //
     /* 3492 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule215Enabled),
     /* 3495 */     // MIs[0] root
     /* 3495 */     // No operand predicates
     /* 3495 */     // MIs[0] x
     /* 3495 */     // No operand predicates
     /* 3495 */     // MIs[0] undef
     /* 3495 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 3499 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3503 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3505 */     // Combiner Rule #215: merge_of_x_and_undef
     /* 3505 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner147),
     /* 3508 */   // Label 213: @3508
     /* 3508 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(3540), // Rule ID 363 //
     /* 3513 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule216Enabled),
     /* 3516 */     // MIs[0] root
     /* 3516 */     // No operand predicates
     /* 3516 */     // MIs[0] x
     /* 3516 */     // No operand predicates
     /* 3516 */     // MIs[0] zero
     /* 3516 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 3520 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3524 */     // MIs[1] Operand 1
     /* 3524 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/1, GIMT_Encode8(0),
     /* 3535 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3537 */     // Combiner Rule #216: merge_of_x_and_zero
     /* 3537 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner148),
     /* 3540 */   // Label 214: @3540
     /* 3540 */   GIM_Reject,
     /* 3541 */ // Label 212: @3541
     /* 3541 */ GIM_Reject,
     /* 3542 */ // Label 14: @3542
     /* 3542 */ GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(3553), // Rule ID 69 //
     /* 3547 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule67Enabled),
     /* 3550 */   // Combiner Rule #67: extract_all_elts_from_build_vector; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3550 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner29),
     /* 3553 */ // Label 215: @3553
     /* 3553 */ GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(3564), // Rule ID 98 //
     /* 3558 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 3561 */   // Combiner Rule #79: propagate_undef_all_ops; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3561 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 3564 */ // Label 216: @3564
     /* 3564 */ GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(3575), // Rule ID 133 //
     /* 3569 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule95Enabled),
     /* 3572 */   // Combiner Rule #95: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3572 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 3575 */ // Label 217: @3575
     /* 3575 */ GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(3589), // Rule ID 354 //
     /* 3580 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule207Enabled),
     /* 3583 */   GIM_CheckNumOperandsGE, /*MI*/0, /*Expected*/2,
     /* 3586 */   // MIs[0] dst
     /* 3586 */   // No operand predicates
     /* 3586 */   // MIs[0] unused
     /* 3586 */   // No operand predicates
     /* 3586 */   // Combiner Rule #207: combine_use_vector_truncate
     /* 3586 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner139),
     /* 3589 */ // Label 218: @3589
     /* 3589 */ GIM_Reject,
     /* 3590 */ // Label 15: @3590
     /* 3590 */ GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(3601), // Rule ID 132 //
     /* 3595 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule95Enabled),
     /* 3598 */   // Combiner Rule #95: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR_TRUNC'
     /* 3598 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 3601 */ // Label 219: @3601
     /* 3601 */ GIM_Reject,
     /* 3602 */ // Label 16: @3602
     /* 3602 */ GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(3613), // Rule ID 347 //
     /* 3607 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule200Enabled),
     /* 3610 */   // Combiner Rule #200: combine_concat_vector; wip_match_opcode 'G_CONCAT_VECTORS'
     /* 3610 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner132),
     /* 3613 */ // Label 220: @3613
     /* 3613 */ GIM_Reject,
     /* 3614 */ // Label 17: @3614
     /* 3614 */ GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(3635), // Rule ID 125 //
     /* 3619 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule89Enabled),
     /* 3622 */   // MIs[0] dst
     /* 3622 */   // No operand predicates
     /* 3622 */   // MIs[0] t
     /* 3622 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3626 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTTOPTR),
     /* 3630 */   // MIs[1] ptr
     /* 3630 */   // No operand predicates
     /* 3630 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3632 */   // Combiner Rule #89: i2p_to_p2i
     /* 3632 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner47),
     /* 3635 */ // Label 221: @3635
     /* 3635 */ GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(3656), // Rule ID 90 //
     /* 3640 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3643 */   // MIs[0] dst
     /* 3643 */   // No operand predicates
     /* 3643 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3643 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3647 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3651 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3653 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[3]]
     /* 3653 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3656 */ // Label 222: @3656
     /* 3656 */ GIM_Reject,
     /* 3657 */ // Label 18: @3657
     /* 3657 */ GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(3668), // Rule ID 124 //
     /* 3662 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3665 */   // Combiner Rule #88: p2i_to_i2p; wip_match_opcode 'G_INTTOPTR'
     /* 3665 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner46),
     /* 3668 */ // Label 223: @3668
     /* 3668 */ GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(3689), // Rule ID 91 //
     /* 3673 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3676 */   // MIs[0] dst
     /* 3676 */   // No operand predicates
     /* 3676 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3676 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3680 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3684 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3686 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[4]]
     /* 3686 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3689 */ // Label 224: @3689
     /* 3689 */ GIM_Reject,
     /* 3690 */ // Label 19: @3690
     /* 3690 */ GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(3711), // Rule ID 136 //
     /* 3695 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule98Enabled),
     /* 3698 */   // MIs[0] dst
     /* 3698 */   // No operand predicates
     /* 3698 */   // MIs[0] src1
     /* 3698 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3702 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /* 3706 */   // MIs[1] src0
     /* 3706 */   // No operand predicates
     /* 3706 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3708 */   // Combiner Rule #98: bitcast_bitcast_fold
     /* 3708 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner52),
     /* 3711 */ // Label 225: @3711
     /* 3711 */ GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(3732), // Rule ID 88 //
     /* 3716 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3719 */   // MIs[0] dst
     /* 3719 */   // No operand predicates
     /* 3719 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3719 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3723 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3727 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3729 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[1]]
     /* 3729 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3732 */ // Label 226: @3732
     /* 3732 */ GIM_Reject,
     /* 3733 */ // Label 20: @3733
     /* 3733 */ GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(3762), // Rule ID 18 //
     /* 3738 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 3741 */   // MIs[0] dst
     /* 3741 */   // No operand predicates
     /* 3741 */   // MIs[0] src
     /* 3741 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3745 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FREEZE),
     /* 3749 */   // MIs[1] __idempotent_prop_match_0.x
     /* 3749 */   // No operand predicates
     /* 3749 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3754 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3756 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[0]]
     /* 3756 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3761 */   GIR_EraseRootFromParent_Done,
     /* 3762 */ // Label 227: @3762
     /* 3762 */ GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(3785), // Rule ID 43 //
     /* 3767 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule41Enabled),
     /* 3770 */   // MIs[0] root
     /* 3770 */   // No operand predicates
     /* 3770 */   // MIs[0] src
     /* 3770 */   // No operand predicates
     /* 3770 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner1),
     /* 3774 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3779 */   // Combiner Rule #41: freeze_of_non_undef_non_poison
     /* 3779 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3784 */   GIR_EraseRootFromParent_Done,
     /* 3785 */ // Label 228: @3785
     /* 3785 */ GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(3796), // Rule ID 44 //
     /* 3790 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule42Enabled),
     /* 3793 */   // MIs[0] dst
     /* 3793 */   // No operand predicates
     /* 3793 */   // MIs[0] src
     /* 3793 */   // No operand predicates
     /* 3793 */   // Combiner Rule #42: push_freeze_to_prevent_poison_from_propagating
     /* 3793 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner19),
     /* 3796 */ // Label 229: @3796
     /* 3796 */ GIM_Reject,
     /* 3797 */ // Label 21: @3797
     /* 3797 */ GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(3808), // Rule ID 70 //
     /* 3802 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3805 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_LOAD'
     /* 3805 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3808 */ // Label 230: @3808
     /* 3808 */ GIM_Reject,
     /* 3809 */ // Label 22: @3809
     /* 3809 */ GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(3820), // Rule ID 71 //
     /* 3814 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3817 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_SEXTLOAD'
     /* 3817 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3820 */ // Label 231: @3820
     /* 3820 */ GIM_Reject,
     /* 3821 */ // Label 23: @3821
     /* 3821 */ GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(3832), // Rule ID 72 //
     /* 3826 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3829 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_ZEXTLOAD'
     /* 3829 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3832 */ // Label 232: @3832
     /* 3832 */ GIM_Reject,
     /* 3833 */ // Label 24: @3833
     /* 3833 */ GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(3844), // Rule ID 100 //
     /* 3838 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule81Enabled),
     /* 3841 */   // Combiner Rule #81: erase_undef_store; wip_match_opcode 'G_STORE'
     /* 3841 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 3844 */ // Label 233: @3844
     /* 3844 */ GIM_Reject,
     /* 3845 */ // Label 25: @3845
     /* 3845 */ GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(3856), // Rule ID 126 //
     /* 3850 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule90Enabled),
     /* 3853 */   // Combiner Rule #90: anyext_trunc_fold; wip_match_opcode 'G_ANYEXT'
     /* 3853 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner48),
     /* 3856 */ // Label 234: @3856
     /* 3856 */ GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(3867), // Rule ID 262 //
     /* 3861 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 3864 */   // Combiner Rule #172: constant_fold_cast_op; wip_match_opcode 'G_ANYEXT'
     /* 3864 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 3867 */ // Label 235: @3867
     /* 3867 */ GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(3888), // Rule ID 57 //
     /* 3872 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule55Enabled),
     /* 3875 */   // MIs[0] root
     /* 3875 */   // No operand predicates
     /* 3875 */   // MIs[0] select
     /* 3875 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3879 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 3883 */   // MIs[1] cond
     /* 3883 */   // No operand predicates
     /* 3883 */   // MIs[1] true
     /* 3883 */   // No operand predicates
     /* 3883 */   // MIs[1] false
     /* 3883 */   // No operand predicates
     /* 3883 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3885 */   // Combiner Rule #55: select_of_anyext
     /* 3885 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 3888 */ // Label 236: @3888
     /* 3888 */ GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(3909), // Rule ID 52 //
     /* 3893 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule50Enabled),
     /* 3896 */   // MIs[0] root
     /* 3896 */   // No operand predicates
     /* 3896 */   // MIs[0] second
     /* 3896 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3900 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 3904 */   // MIs[1] src
     /* 3904 */   // No operand predicates
     /* 3904 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3906 */   // Combiner Rule #50: anyext_of_anyext
     /* 3906 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3909 */ // Label 237: @3909
     /* 3909 */ GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(3930), // Rule ID 54 //
     /* 3914 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule52Enabled),
     /* 3917 */   // MIs[0] root
     /* 3917 */   // No operand predicates
     /* 3917 */   // MIs[0] second
     /* 3917 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3921 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 3925 */   // MIs[1] src
     /* 3925 */   // No operand predicates
     /* 3925 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3927 */   // Combiner Rule #52: anyext_of_sext
     /* 3927 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3930 */ // Label 238: @3930
     /* 3930 */ GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(3951), // Rule ID 53 //
     /* 3935 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 3938 */   // MIs[0] root
     /* 3938 */   // No operand predicates
     /* 3938 */   // MIs[0] second
     /* 3938 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3942 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 3946 */   // MIs[1] src
     /* 3946 */   // No operand predicates
     /* 3946 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3948 */   // Combiner Rule #51: anyext_of_zext
     /* 3948 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3951 */ // Label 239: @3951
     /* 3951 */ GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(3972), // Rule ID 89 //
     /* 3956 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3959 */   // MIs[0] dst
     /* 3959 */   // No operand predicates
     /* 3959 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3959 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3963 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3967 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3969 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[2]]
     /* 3969 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3972 */ // Label 240: @3972
     /* 3972 */ GIM_Reject,
     /* 3973 */ // Label 26: @3973
     /* 3973 */ GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(3984), // Rule ID 134 //
     /* 3978 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule96Enabled),
     /* 3981 */   // Combiner Rule #96: trunc_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 3981 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner50),
     /* 3984 */ // Label 241: @3984
     /* 3984 */ GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(3995), // Rule ID 135 //
     /* 3989 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule97Enabled),
     /* 3992 */   // Combiner Rule #97: trunc_lshr_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 3992 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner51),
     /* 3995 */ // Label 242: @3995
     /* 3995 */ GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(4006), // Rule ID 174 //
     /* 4000 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule132Enabled),
     /* 4003 */   // Combiner Rule #132: trunc_shift; wip_match_opcode 'G_TRUNC'
     /* 4003 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner78),
     /* 4006 */ // Label 243: @4006
     /* 4006 */ GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(4017), // Rule ID 374 //
     /* 4011 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule225Enabled),
     /* 4014 */   // Combiner Rule #225: clamp_i64_to_i16; wip_match_opcode 'G_TRUNC'
     /* 4014 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner155),
     /* 4017 */ // Label 244: @4017
     /* 4017 */ GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(4038), // Rule ID 58 //
     /* 4022 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule56Enabled),
     /* 4025 */   // MIs[0] root
     /* 4025 */   // No operand predicates
     /* 4025 */   // MIs[0] select
     /* 4025 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4029 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 4033 */   // MIs[1] cond
     /* 4033 */   // No operand predicates
     /* 4033 */   // MIs[1] true
     /* 4033 */   // No operand predicates
     /* 4033 */   // MIs[1] false
     /* 4033 */   // No operand predicates
     /* 4033 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4035 */   // Combiner Rule #56: select_of_truncate
     /* 4035 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 4038 */ // Label 245: @4038
     /* 4038 */ GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(4067), // Rule ID 60 //
     /* 4043 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule58Enabled),
     /* 4046 */   // MIs[0] root
     /* 4046 */   // No operand predicates
     /* 4046 */   // MIs[0] binop
     /* 4046 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4050 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 4054 */   // MIs[1] x
     /* 4054 */   // No operand predicates
     /* 4054 */   // MIs[1] const
     /* 4054 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4058 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4062 */   // MIs[2] imm
     /* 4062 */   // No operand predicates
     /* 4062 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4064 */   // Combiner Rule #58: narrow_binop_add
     /* 4064 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4067 */ // Label 246: @4067
     /* 4067 */ GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(4096), // Rule ID 63 //
     /* 4072 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule61Enabled),
     /* 4075 */   // MIs[0] root
     /* 4075 */   // No operand predicates
     /* 4075 */   // MIs[0] binop
     /* 4075 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4079 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /* 4083 */   // MIs[1] x
     /* 4083 */   // No operand predicates
     /* 4083 */   // MIs[1] const
     /* 4083 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4087 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4091 */   // MIs[2] imm
     /* 4091 */   // No operand predicates
     /* 4091 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4093 */   // Combiner Rule #61: narrow_binop_and
     /* 4093 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4096 */ // Label 247: @4096
     /* 4096 */ GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(4125), // Rule ID 62 //
     /* 4101 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule60Enabled),
     /* 4104 */   // MIs[0] root
     /* 4104 */   // No operand predicates
     /* 4104 */   // MIs[0] binop
     /* 4104 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4108 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /* 4112 */   // MIs[1] x
     /* 4112 */   // No operand predicates
     /* 4112 */   // MIs[1] const
     /* 4112 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4116 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4120 */   // MIs[2] imm
     /* 4120 */   // No operand predicates
     /* 4120 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4122 */   // Combiner Rule #60: narrow_binop_mul
     /* 4122 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4125 */ // Label 248: @4125
     /* 4125 */ GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(4154), // Rule ID 64 //
     /* 4130 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule62Enabled),
     /* 4133 */   // MIs[0] root
     /* 4133 */   // No operand predicates
     /* 4133 */   // MIs[0] binop
     /* 4133 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4137 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /* 4141 */   // MIs[1] x
     /* 4141 */   // No operand predicates
     /* 4141 */   // MIs[1] const
     /* 4141 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4145 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4149 */   // MIs[2] imm
     /* 4149 */   // No operand predicates
     /* 4149 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4151 */   // Combiner Rule #62: narrow_binop_or
     /* 4151 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4154 */ // Label 249: @4154
     /* 4154 */ GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(4183), // Rule ID 61 //
     /* 4159 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule59Enabled),
     /* 4162 */   // MIs[0] root
     /* 4162 */   // No operand predicates
     /* 4162 */   // MIs[0] binop
     /* 4162 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4166 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 4170 */   // MIs[1] x
     /* 4170 */   // No operand predicates
     /* 4170 */   // MIs[1] const
     /* 4170 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4174 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4178 */   // MIs[2] imm
     /* 4178 */   // No operand predicates
     /* 4178 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4180 */   // Combiner Rule #59: narrow_binop_sub
     /* 4180 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4183 */ // Label 250: @4183
     /* 4183 */ GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(4215), // Rule ID 370 //
     /* 4188 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule221Enabled),
     /* 4191 */   // MIs[0] dst
     /* 4191 */   // No operand predicates
     /* 4191 */   // MIs[0] min
     /* 4191 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4195 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UMIN),
     /* 4199 */   // MIs[1] x
     /* 4199 */   // No operand predicates
     /* 4199 */   // MIs[1] y
     /* 4199 */   // No operand predicates
     /* 4199 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner11),
     /* 4203 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4205 */   // Combiner Rule #221: trunc_usatu
     /* 4205 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_TRUNC_USAT_U),
     /* 4208 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 4210 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 4214 */   GIR_EraseRootFromParent_Done,
     /* 4215 */ // Label 251: @4215
     /* 4215 */ GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(4244), // Rule ID 65 //
     /* 4220 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule63Enabled),
     /* 4223 */   // MIs[0] root
     /* 4223 */   // No operand predicates
     /* 4223 */   // MIs[0] binop
     /* 4223 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4227 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /* 4231 */   // MIs[1] x
     /* 4231 */   // No operand predicates
     /* 4231 */   // MIs[1] const
     /* 4231 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4235 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4239 */   // MIs[2] imm
     /* 4239 */   // No operand predicates
     /* 4239 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4241 */   // Combiner Rule #63: narrow_binop_xor
     /* 4241 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4244 */ // Label 252: @4244
     /* 4244 */ GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(4265), // Rule ID 47 //
     /* 4249 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule45Enabled),
     /* 4252 */   // MIs[0] root
     /* 4252 */   // No operand predicates
     /* 4252 */   // MIs[0] ext
     /* 4252 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4256 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 4260 */   // MIs[1] src
     /* 4260 */   // No operand predicates
     /* 4260 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4262 */   // Combiner Rule #45: truncate_of_anyext
     /* 4262 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 4265 */ // Label 253: @4265
     /* 4265 */ GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(4289), // Rule ID 59 //
     /* 4270 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule57Enabled),
     /* 4273 */   // MIs[0] root
     /* 4273 */   // No operand predicates
     /* 4273 */   // MIs[0] bv
     /* 4273 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4277 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
     /* 4281 */   GIM_CheckNumOperandsGE, /*MI*/1, /*Expected*/2,
     /* 4284 */   // MIs[1] unused
     /* 4284 */   // No operand predicates
     /* 4284 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4286 */   // Combiner Rule #57: buildvector_of_truncate
     /* 4286 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner24),
     /* 4289 */ // Label 254: @4289
     /* 4289 */ GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(4310), // Rule ID 46 //
     /* 4294 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule44Enabled),
     /* 4297 */   // MIs[0] root
     /* 4297 */   // No operand predicates
     /* 4297 */   // MIs[0] ext
     /* 4297 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4301 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 4305 */   // MIs[1] src
     /* 4305 */   // No operand predicates
     /* 4305 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4307 */   // Combiner Rule #44: truncate_of_sext
     /* 4307 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 4310 */ // Label 255: @4310
     /* 4310 */ GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(4331), // Rule ID 45 //
     /* 4315 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule43Enabled),
     /* 4318 */   // MIs[0] root
     /* 4318 */   // No operand predicates
     /* 4318 */   // MIs[0] ext
     /* 4318 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4322 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 4326 */   // MIs[1] src
     /* 4326 */   // No operand predicates
     /* 4326 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4328 */   // Combiner Rule #43: truncate_of_zext
     /* 4328 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 4331 */ // Label 256: @4331
     /* 4331 */ GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(4352), // Rule ID 87 //
     /* 4336 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 4339 */   // MIs[0] dst
     /* 4339 */   // No operand predicates
     /* 4339 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 4339 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4343 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 4347 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4349 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[0]]
     /* 4349 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 4352 */ // Label 257: @4352
     /* 4352 */ GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(4373), // Rule ID 66 //
     /* 4357 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule64Enabled),
     /* 4360 */   // MIs[0] root
     /* 4360 */   // No operand predicates
     /* 4360 */   // MIs[0] int
     /* 4360 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4364 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4368 */   // MIs[1] imm
     /* 4368 */   // No operand predicates
     /* 4368 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4370 */   // Combiner Rule #64: integer_of_truncate
     /* 4370 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner26),
     /* 4373 */ // Label 258: @4373
     /* 4373 */ GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(4384), // Rule ID 368 //
     /* 4378 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule219Enabled),
     /* 4381 */   // MIs[0] dst
     /* 4381 */   // No operand predicates
     /* 4381 */   // MIs[0] src
     /* 4381 */   // No operand predicates
     /* 4381 */   // Combiner Rule #219: trunc_ssats
     /* 4381 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner151),
     /* 4384 */ // Label 259: @4384
     /* 4384 */ GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(4395), // Rule ID 369 //
     /* 4389 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule220Enabled),
     /* 4392 */   // MIs[0] dst
     /* 4392 */   // No operand predicates
     /* 4392 */   // MIs[0] src
     /* 4392 */   // No operand predicates
     /* 4392 */   // Combiner Rule #220: trunc_ssatu
     /* 4392 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner152),
     /* 4395 */ // Label 260: @4395
     /* 4395 */ GIM_Reject,
     /* 4396 */ // Label 27: @4396
     /* 4396 */ GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(4428), // Rule ID 371 //
     /* 4401 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule222Enabled),
     /* 4404 */   // MIs[0] dst
     /* 4404 */   // No operand predicates
     /* 4404 */   // MIs[0] src
     /* 4404 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4408 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPTOUI),
     /* 4412 */   // MIs[1] x
     /* 4412 */   // No operand predicates
     /* 4412 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner12),
     /* 4416 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4418 */   // Combiner Rule #222: truncusatu_to_fptouisat
     /* 4418 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FPTOUI_SAT),
     /* 4421 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 4423 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 4427 */   GIR_EraseRootFromParent_Done,
     /* 4428 */ // Label 261: @4428
     /* 4428 */ GIM_Reject,
     /* 4429 */ // Label 28: @4429
     /* 4429 */ GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(4440), // Rule ID 261 //
     /* 4434 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 4437 */   // Combiner Rule #172: constant_fold_cast_op; wip_match_opcode 'G_SEXT'
     /* 4437 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 4440 */ // Label 262: @4440
     /* 4440 */ GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(4461), // Rule ID 51 //
     /* 4445 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule49Enabled),
     /* 4448 */   // MIs[0] root
     /* 4448 */   // No operand predicates
     /* 4448 */   // MIs[0] second
     /* 4448 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4452 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 4456 */   // MIs[1] src
     /* 4456 */   // No operand predicates
     /* 4456 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4458 */   // Combiner Rule #49: sext_of_anyext
     /* 4458 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4461 */ // Label 263: @4461
     /* 4461 */ GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(4482), // Rule ID 50 //
     /* 4466 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 4469 */   // MIs[0] root
     /* 4469 */   // No operand predicates
     /* 4469 */   // MIs[0] second
     /* 4469 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4473 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 4477 */   // MIs[1] src
     /* 4477 */   // No operand predicates
     /* 4477 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4479 */   // Combiner Rule #48: sext_of_sext
     /* 4479 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4482 */ // Label 264: @4482
     /* 4482 */ GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(4503), // Rule ID 348 //
     /* 4487 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule201Enabled),
     /* 4490 */   // MIs[0] root
     /* 4490 */   // No operand predicates
     /* 4490 */   // MIs[0] src
     /* 4490 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4494 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 4498 */   // MIs[1] x
     /* 4498 */   // No operand predicates
     /* 4498 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4500 */   // Combiner Rule #201: sext_trunc
     /* 4500 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner133),
     /* 4503 */ // Label 265: @4503
     /* 4503 */ GIM_Reject,
     /* 4504 */ // Label 29: @4504
     /* 4504 */ GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(4515), // Rule ID 161 //
     /* 4509 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule119Enabled),
     /* 4512 */   // Combiner Rule #119: sext_inreg_of_load; wip_match_opcode 'G_SEXT_INREG'
     /* 4512 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner66),
     /* 4515 */ // Label 266: @4515
     /* 4515 */ GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(4526), // Rule ID 169 //
     /* 4520 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule127Enabled),
     /* 4523 */   // Combiner Rule #127: redundant_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 4523 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner73),
     /* 4526 */ // Label 267: @4526
     /* 4526 */ GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(4537), // Rule ID 230 //
     /* 4531 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule165Enabled),
     /* 4534 */   // Combiner Rule #165: bitfield_extract_from_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 4534 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner100),
     /* 4537 */ // Label 268: @4537
     /* 4537 */ GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(4558), // Rule ID 55 //
     /* 4542 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 4545 */   // MIs[0] dst
     /* 4545 */   // No operand predicates
     /* 4545 */   // MIs[0] x
     /* 4545 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4549 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /* 4553 */   // MIs[1] src
     /* 4553 */   // No operand predicates
     /* 4553 */   // MIs[1] a
     /* 4553 */   // No operand predicates
     /* 4553 */   // MIs[0] b
     /* 4553 */   // No operand predicates
     /* 4553 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4555 */   // Combiner Rule #53: sext_inreg_of_sext_inreg
     /* 4555 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner22),
     /* 4558 */ // Label 269: @4558
     /* 4558 */ GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(4569), // Rule ID 173 //
     /* 4563 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule131Enabled),
     /* 4566 */   // MIs[0] dst
     /* 4566 */   // No operand predicates
     /* 4566 */   // MIs[0] src
     /* 4566 */   // No operand predicates
     /* 4566 */   // MIs[0] imm
     /* 4566 */   // No operand predicates
     /* 4566 */   // Combiner Rule #131: sext_inreg_to_zext_inreg
     /* 4566 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner77),
     /* 4569 */ // Label 270: @4569
     /* 4569 */ GIM_Reject,
     /* 4570 */ // Label 30: @4570
     /* 4570 */ GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(4581), // Rule ID 172 //
     /* 4575 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule130Enabled),
     /* 4578 */   // Combiner Rule #130: zext_trunc_fold; wip_match_opcode 'G_ZEXT'
     /* 4578 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner76),
     /* 4581 */ // Label 271: @4581
     /* 4581 */ GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(4592), // Rule ID 260 //
     /* 4586 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 4589 */   // Combiner Rule #172: constant_fold_cast_op; wip_match_opcode 'G_ZEXT'
     /* 4589 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 4592 */ // Label 272: @4592
     /* 4592 */ GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(4613), // Rule ID 56 //
     /* 4597 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule54Enabled),
     /* 4600 */   // MIs[0] root
     /* 4600 */   // No operand predicates
     /* 4600 */   // MIs[0] select
     /* 4600 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4604 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 4608 */   // MIs[1] cond
     /* 4608 */   // No operand predicates
     /* 4608 */   // MIs[1] true
     /* 4608 */   // No operand predicates
     /* 4608 */   // MIs[1] false
     /* 4608 */   // No operand predicates
     /* 4608 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4610 */   // Combiner Rule #54: select_of_zext
     /* 4610 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 4613 */ // Label 273: @4613
     /* 4613 */ GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(4634), // Rule ID 49 //
     /* 4618 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule47Enabled),
     /* 4621 */   // MIs[0] root
     /* 4621 */   // No operand predicates
     /* 4621 */   // MIs[0] second
     /* 4621 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4625 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 4629 */   // MIs[1] src
     /* 4629 */   // No operand predicates
     /* 4629 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4631 */   // Combiner Rule #47: zext_of_anyext
     /* 4631 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4634 */ // Label 274: @4634
     /* 4634 */ GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(4661), // Rule ID 349 //
     /* 4639 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule202Enabled),
     /* 4642 */   // MIs[0] root
     /* 4642 */   // No operand predicates
     /* 4642 */   // MIs[0] src
     /* 4642 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4646 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 4650 */   GIM_MIFlags, /*MI*/1, GIMT_Encode4(MachineInstr::NoUWrap),
     /* 4656 */   // MIs[1] x
     /* 4656 */   // No operand predicates
     /* 4656 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4658 */   // Combiner Rule #202: zext_trunc
     /* 4658 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner134),
     /* 4661 */ // Label 275: @4661
     /* 4661 */ GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(4682), // Rule ID 48 //
     /* 4666 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule46Enabled),
     /* 4669 */   // MIs[0] root
     /* 4669 */   // No operand predicates
     /* 4669 */   // MIs[0] second
     /* 4669 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4673 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 4677 */   // MIs[1] src
     /* 4677 */   // No operand predicates
     /* 4677 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4679 */   // Combiner Rule #46: zext_of_zext
     /* 4679 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4682 */ // Label 276: @4682
     /* 4682 */ GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(4699), // Rule ID 350 //
     /* 4687 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule203Enabled),
     /* 4690 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NonNeg),
     /* 4696 */   // MIs[0] root
     /* 4696 */   // No operand predicates
     /* 4696 */   // MIs[0] x
     /* 4696 */   // No operand predicates
     /* 4696 */   // Combiner Rule #203: nneg_zext
     /* 4696 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner135),
     /* 4699 */ // Label 277: @4699
     /* 4699 */ GIM_Reject,
     /* 4700 */ // Label 31: @4700
     /* 4700 */ GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(4711), // Rule ID 80 //
     /* 4705 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 4708 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_SHL'
     /* 4708 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 4711 */ // Label 278: @4711
     /* 4711 */ GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(4722), // Rule ID 83 //
     /* 4716 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4719 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_SHL'
     /* 4719 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4722 */ // Label 279: @4722
     /* 4722 */ GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(4733), // Rule ID 116 //
     /* 4727 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4730 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SHL'
     /* 4730 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4733 */ // Label 280: @4733
     /* 4733 */ GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(4744), // Rule ID 201 //
     /* 4738 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4741 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_SHL'
     /* 4741 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4744 */ // Label 281: @4744
     /* 4744 */ GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(4755), // Rule ID 206 //
     /* 4749 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 4752 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_SHL'
     /* 4752 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4755 */ // Label 282: @4755
     /* 4755 */ GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(4766), // Rule ID 229 //
     /* 4760 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule164Enabled),
     /* 4763 */   // Combiner Rule #164: commute_shift; wip_match_opcode 'G_SHL'
     /* 4763 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner99),
     /* 4766 */ // Label 283: @4766
     /* 4766 */ GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(4777), // Rule ID 243 //
     /* 4771 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 4774 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SHL'
     /* 4774 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4777 */ // Label 284: @4777
     /* 4777 */ GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(4788), // Rule ID 292 //
     /* 4782 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 4785 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SHL'
     /* 4785 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4788 */ // Label 285: @4788
     /* 4788 */ GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(4823), // Rule ID 41 //
     /* 4793 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule39Enabled),
     /* 4796 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 4802 */   // MIs[0] root
     /* 4802 */   // No operand predicates
     /* 4802 */   // MIs[0] left
     /* 4802 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4806 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 4810 */   // MIs[1] imm
     /* 4810 */   // No operand predicates
     /* 4810 */   // MIs[0] x
     /* 4810 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 4814 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4818 */   // MIs[2] imm1
     /* 4818 */   // No operand predicates
     /* 4818 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4820 */   // Combiner Rule #39: shl_of_vscale
     /* 4820 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner17),
     /* 4823 */ // Label 286: @4823
     /* 4823 */ GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(4846), // Rule ID 108 //
     /* 4828 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4831 */   // MIs[0] dst
     /* 4831 */   // No operand predicates
     /* 4831 */   // MIs[0] lhs
     /* 4831 */   // No operand predicates
     /* 4831 */   // MIs[0] Operand 2
     /* 4831 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4835 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4840 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[4]]
     /* 4840 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4845 */   GIR_EraseRootFromParent_Done,
     /* 4846 */ // Label 287: @4846
     /* 4846 */ GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(4857), // Rule ID 146 //
     /* 4851 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule106Enabled),
     /* 4854 */   // MIs[0] root
     /* 4854 */   // No operand predicates
     /* 4854 */   // MIs[0] mi.shifted
     /* 4854 */   // No operand predicates
     /* 4854 */   // MIs[0] mi.amt
     /* 4854 */   // No operand predicates
     /* 4854 */   // Combiner Rule #106: shifts_too_big @ [mi[0]]
     /* 4854 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 4857 */ // Label 288: @4857
     /* 4857 */ GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(4868), // Rule ID 162 //
     /* 4862 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule120Enabled),
     /* 4865 */   // MIs[0] dst
     /* 4865 */   // No operand predicates
     /* 4865 */   // MIs[0] src0
     /* 4865 */   // No operand predicates
     /* 4865 */   // MIs[0] src1
     /* 4865 */   // No operand predicates
     /* 4865 */   // Combiner Rule #120: reduce_shl_of_extend
     /* 4865 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 4868 */ // Label 289: @4868
     /* 4868 */ GIM_Reject,
     /* 4869 */ // Label 32: @4869
     /* 4869 */ GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(4880), // Rule ID 85 //
     /* 4874 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4877 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_LSHR'
     /* 4877 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4880 */ // Label 290: @4880
     /* 4880 */ GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(4891), // Rule ID 117 //
     /* 4885 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4888 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_LSHR'
     /* 4888 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4891 */ // Label 291: @4891
     /* 4891 */ GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(4902), // Rule ID 203 //
     /* 4896 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4899 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_LSHR'
     /* 4899 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4902 */ // Label 292: @4902
     /* 4902 */ GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(4913), // Rule ID 208 //
     /* 4907 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 4910 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_LSHR'
     /* 4910 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4913 */ // Label 293: @4913
     /* 4913 */ GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(4924), // Rule ID 233 //
     /* 4918 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 4921 */   // Combiner Rule #167: bitfield_extract_from_shr; wip_match_opcode 'G_LSHR'
     /* 4921 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner102),
     /* 4924 */ // Label 294: @4924
     /* 4924 */ GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(4935), // Rule ID 235 //
     /* 4929 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule168Enabled),
     /* 4932 */   // Combiner Rule #168: bitfield_extract_from_shr_and; wip_match_opcode 'G_LSHR'
     /* 4932 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner103),
     /* 4935 */ // Label 295: @4935
     /* 4935 */ GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(4946), // Rule ID 240 //
     /* 4940 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 4943 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_LSHR'
     /* 4943 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4946 */ // Label 296: @4946
     /* 4946 */ GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(4957), // Rule ID 290 //
     /* 4951 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 4954 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_LSHR'
     /* 4954 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4957 */ // Label 297: @4957
     /* 4957 */ GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(4986), // Rule ID 372 //
     /* 4962 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule223Enabled),
     /* 4965 */   // MIs[0] dst
     /* 4965 */   // No operand predicates
     /* 4965 */   // MIs[0] d2
     /* 4965 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4969 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 4973 */   // MIs[1] d1
     /* 4973 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 4977 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 4981 */   // MIs[2] x
     /* 4981 */   // No operand predicates
     /* 4981 */   // MIs[2] y
     /* 4981 */   // No operand predicates
     /* 4981 */   // MIs[0] z
     /* 4981 */   // No operand predicates
     /* 4981 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4983 */   // Combiner Rule #223: lshr_of_trunc_of_lshr
     /* 4983 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner153),
     /* 4986 */ // Label 298: @4986
     /* 4986 */ GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(5009), // Rule ID 110 //
     /* 4991 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4994 */   // MIs[0] dst
     /* 4994 */   // No operand predicates
     /* 4994 */   // MIs[0] lhs
     /* 4994 */   // No operand predicates
     /* 4994 */   // MIs[0] Operand 2
     /* 4994 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4998 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5003 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[6]]
     /* 5003 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5008 */   GIR_EraseRootFromParent_Done,
     /* 5009 */ // Label 299: @5009
     /* 5009 */ GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(5020), // Rule ID 148 //
     /* 5014 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule106Enabled),
     /* 5017 */   // MIs[0] root
     /* 5017 */   // No operand predicates
     /* 5017 */   // MIs[0] mi.shifted
     /* 5017 */   // No operand predicates
     /* 5017 */   // MIs[0] mi.amt
     /* 5017 */   // No operand predicates
     /* 5017 */   // Combiner Rule #106: shifts_too_big @ [mi[2]]
     /* 5017 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 5020 */ // Label 300: @5020
     /* 5020 */ GIM_Reject,
     /* 5021 */ // Label 33: @5021
     /* 5021 */ GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(5032), // Rule ID 84 //
     /* 5026 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 5029 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_ASHR'
     /* 5029 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 5032 */ // Label 301: @5032
     /* 5032 */ GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(5043), // Rule ID 118 //
     /* 5037 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 5040 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_ASHR'
     /* 5040 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 5043 */ // Label 302: @5043
     /* 5043 */ GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(5054), // Rule ID 159 //
     /* 5048 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule117Enabled),
     /* 5051 */   // Combiner Rule #117: shl_ashr_to_sext_inreg; wip_match_opcode 'G_ASHR'
     /* 5051 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner65),
     /* 5054 */ // Label 303: @5054
     /* 5054 */ GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(5065), // Rule ID 202 //
     /* 5059 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5062 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_ASHR'
     /* 5062 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5065 */ // Label 304: @5065
     /* 5065 */ GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(5076), // Rule ID 207 //
     /* 5070 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 5073 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_ASHR'
     /* 5073 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5076 */ // Label 305: @5076
     /* 5076 */ GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(5087), // Rule ID 232 //
     /* 5081 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5084 */   // Combiner Rule #167: bitfield_extract_from_shr; wip_match_opcode 'G_ASHR'
     /* 5084 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner102),
     /* 5087 */ // Label 306: @5087
     /* 5087 */ GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(5098), // Rule ID 234 //
     /* 5092 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule168Enabled),
     /* 5095 */   // Combiner Rule #168: bitfield_extract_from_shr_and; wip_match_opcode 'G_ASHR'
     /* 5095 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner103),
     /* 5098 */ // Label 307: @5098
     /* 5098 */ GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(5109), // Rule ID 239 //
     /* 5103 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 5106 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_ASHR'
     /* 5106 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 5109 */ // Label 308: @5109
     /* 5109 */ GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(5120), // Rule ID 291 //
     /* 5114 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 5117 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_ASHR'
     /* 5117 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5120 */ // Label 309: @5120
     /* 5120 */ GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(5143), // Rule ID 109 //
     /* 5125 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 5128 */   // MIs[0] dst
     /* 5128 */   // No operand predicates
     /* 5128 */   // MIs[0] lhs
     /* 5128 */   // No operand predicates
     /* 5128 */   // MIs[0] Operand 2
     /* 5128 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 5132 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5137 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[5]]
     /* 5137 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5142 */   GIR_EraseRootFromParent_Done,
     /* 5143 */ // Label 310: @5143
     /* 5143 */ GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(5154), // Rule ID 147 //
     /* 5148 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule106Enabled),
     /* 5151 */   // MIs[0] root
     /* 5151 */   // No operand predicates
     /* 5151 */   // MIs[0] mi.shifted
     /* 5151 */   // No operand predicates
     /* 5151 */   // MIs[0] mi.amt
     /* 5151 */   // No operand predicates
     /* 5151 */   // Combiner Rule #106: shifts_too_big @ [mi[1]]
     /* 5151 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 5154 */ // Label 311: @5154
     /* 5154 */ GIM_Reject,
     /* 5155 */ // Label 34: @5155
     /* 5155 */ GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(5166), // Rule ID 217 //
     /* 5160 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule156Enabled),
     /* 5163 */   // Combiner Rule #156: funnel_shift_to_rotate; wip_match_opcode 'G_FSHL'
     /* 5163 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner97),
     /* 5166 */ // Label 312: @5166
     /* 5166 */ GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(5177), // Rule ID 221 //
     /* 5171 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule159Enabled),
     /* 5174 */   // Combiner Rule #159: funnel_shift_overshift; wip_match_opcode 'G_FSHL'
     /* 5174 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner98),
     /* 5177 */ // Label 313: @5177
     /* 5177 */ GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(5197), // Rule ID 220 //
     /* 5182 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule158Enabled),
     /* 5185 */   // MIs[0] x
     /* 5185 */   // No operand predicates
     /* 5185 */   // MIs[0] y
     /* 5185 */   // No operand predicates
     /* 5185 */   // MIs[0] z
     /* 5185 */   // No operand predicates
     /* 5185 */   // MIs[0] Operand 3
     /* 5185 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
     /* 5189 */   // Combiner Rule #158: funnel_shift_left_zero
     /* 5189 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 5192 */   GIR_RootToRootCopy, /*OpIdx*/0, // x
     /* 5194 */   GIR_RootToRootCopy, /*OpIdx*/1, // y
     /* 5196 */   GIR_EraseRootFromParent_Done,
     /* 5197 */ // Label 314: @5197
     /* 5197 */ GIM_Reject,
     /* 5198 */ // Label 35: @5198
     /* 5198 */ GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(5209), // Rule ID 218 //
     /* 5203 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule156Enabled),
     /* 5206 */   // Combiner Rule #156: funnel_shift_to_rotate; wip_match_opcode 'G_FSHR'
     /* 5206 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner97),
     /* 5209 */ // Label 315: @5209
     /* 5209 */ GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(5220), // Rule ID 222 //
     /* 5214 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule159Enabled),
     /* 5217 */   // Combiner Rule #159: funnel_shift_overshift; wip_match_opcode 'G_FSHR'
     /* 5217 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner98),
     /* 5220 */ // Label 316: @5220
     /* 5220 */ GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(5240), // Rule ID 219 //
     /* 5225 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule157Enabled),
     /* 5228 */   // MIs[0] x
     /* 5228 */   // No operand predicates
     /* 5228 */   // MIs[0] y
     /* 5228 */   // No operand predicates
     /* 5228 */   // MIs[0] z
     /* 5228 */   // No operand predicates
     /* 5228 */   // MIs[0] Operand 3
     /* 5228 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
     /* 5232 */   // Combiner Rule #157: funnel_shift_right_zero
     /* 5232 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 5235 */   GIR_RootToRootCopy, /*OpIdx*/0, // x
     /* 5237 */   GIR_RootToRootCopy, /*OpIdx*/2, // z
     /* 5239 */   GIR_EraseRootFromParent_Done,
     /* 5240 */ // Label 317: @5240
     /* 5240 */ GIM_Reject,
     /* 5241 */ // Label 36: @5241
     /* 5241 */ GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(5264), // Rule ID 113 //
     /* 5246 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 5249 */   // MIs[0] dst
     /* 5249 */   // No operand predicates
     /* 5249 */   // MIs[0] lhs
     /* 5249 */   // No operand predicates
     /* 5249 */   // MIs[0] Operand 2
     /* 5249 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 5253 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5258 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[9]]
     /* 5258 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5263 */   GIR_EraseRootFromParent_Done,
     /* 5264 */ // Label 318: @5264
     /* 5264 */ GIM_Reject,
     /* 5265 */ // Label 37: @5265
     /* 5265 */ GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(5288), // Rule ID 112 //
     /* 5270 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 5273 */   // MIs[0] dst
     /* 5273 */   // No operand predicates
     /* 5273 */   // MIs[0] lhs
     /* 5273 */   // No operand predicates
     /* 5273 */   // MIs[0] Operand 2
     /* 5273 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 5277 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5282 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[8]]
     /* 5282 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5287 */   GIR_EraseRootFromParent_Done,
     /* 5288 */ // Label 319: @5288
     /* 5288 */ GIM_Reject,
     /* 5289 */ // Label 38: @5289
     /* 5289 */ GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(5300), // Rule ID 154 //
     /* 5294 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule112Enabled),
     /* 5297 */   // Combiner Rule #112: icmp_to_true_false_known_bits; wip_match_opcode 'G_ICMP'
     /* 5297 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner62),
     /* 5300 */ // Label 320: @5300
     /* 5300 */ GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(5311), // Rule ID 155 //
     /* 5305 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule113Enabled),
     /* 5308 */   // Combiner Rule #113: icmp_to_lhs_known_bits; wip_match_opcode 'G_ICMP'
     /* 5308 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner63),
     /* 5311 */ // Label 321: @5311
     /* 5311 */ GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(5322), // Rule ID 158 //
     /* 5316 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule116Enabled),
     /* 5319 */   // Combiner Rule #116: redundant_binop_in_equality; wip_match_opcode 'G_ICMP'
     /* 5319 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner64),
     /* 5322 */ // Label 322: @5322
     /* 5322 */ GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(5333), // Rule ID 152 //
     /* 5327 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule110Enabled),
     /* 5330 */   // MIs[0] root
     /* 5330 */   // No operand predicates
     /* 5330 */   // MIs[0] pred
     /* 5330 */   // No operand predicates
     /* 5330 */   // MIs[0] lhs
     /* 5330 */   // No operand predicates
     /* 5330 */   // MIs[0] rhs
     /* 5330 */   // No operand predicates
     /* 5330 */   // Combiner Rule #110: canonicalize_icmp
     /* 5330 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner60),
     /* 5333 */ // Label 323: @5333
     /* 5333 */ GIM_Reject,
     /* 5334 */ // Label 39: @5334
     /* 5334 */ GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(5345), // Rule ID 153 //
     /* 5339 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule111Enabled),
     /* 5342 */   // MIs[0] root
     /* 5342 */   // No operand predicates
     /* 5342 */   // MIs[0] pred
     /* 5342 */   // No operand predicates
     /* 5342 */   // MIs[0] lhs
     /* 5342 */   // No operand predicates
     /* 5342 */   // MIs[0] rhs
     /* 5342 */   // No operand predicates
     /* 5342 */   // Combiner Rule #111: canonicalize_fcmp
     /* 5342 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner61),
     /* 5345 */ // Label 324: @5345
     /* 5345 */ GIM_Reject,
     /* 5346 */ // Label 40: @5346
     /* 5346 */ GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(5357), // Rule ID 103 //
     /* 5351 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule83Enabled),
     /* 5354 */   // Combiner Rule #83: select_same_val; wip_match_opcode 'G_SELECT'
     /* 5354 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner44),
     /* 5357 */ // Label 325: @5357
     /* 5357 */ GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(5368), // Rule ID 165 //
     /* 5362 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule123Enabled),
     /* 5365 */   // Combiner Rule #123: select_constant_cmp; wip_match_opcode 'G_SELECT'
     /* 5365 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner69),
     /* 5368 */ // Label 326: @5368
     /* 5368 */ GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(5379), // Rule ID 167 //
     /* 5373 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule125Enabled),
     /* 5376 */   // Combiner Rule #125: match_selects; wip_match_opcode 'G_SELECT'
     /* 5376 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner71),
     /* 5379 */ // Label 327: @5379
     /* 5379 */ GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(5390), // Rule ID 313 //
     /* 5384 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 5387 */   // Combiner Rule #193: select_to_minmax; wip_match_opcode 'G_SELECT'
     /* 5387 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner125),
     /* 5390 */ // Label 328: @5390
     /* 5390 */ GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(5411), // Rule ID 166 //
     /* 5395 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule124Enabled),
     /* 5398 */   // MIs[0] root
     /* 5398 */   // No operand predicates
     /* 5398 */   // MIs[0] tst
     /* 5398 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5402 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 5406 */   // MIs[1] tst1
     /* 5406 */   // No operand predicates
     /* 5406 */   // MIs[1] a
     /* 5406 */   // No operand predicates
     /* 5406 */   // MIs[1] b
     /* 5406 */   // No operand predicates
     /* 5406 */   // MIs[0] x
     /* 5406 */   // No operand predicates
     /* 5406 */   // MIs[0] y
     /* 5406 */   // No operand predicates
     /* 5406 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5408 */   // Combiner Rule #124: select_to_iminmax
     /* 5408 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner70),
     /* 5411 */ // Label 329: @5411
     /* 5411 */ GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(5440), // Rule ID 164 //
     /* 5416 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule122Enabled),
     /* 5419 */   // MIs[0] dst
     /* 5419 */   // No operand predicates
     /* 5419 */   // MIs[0] undef
     /* 5419 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5423 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 5427 */   // MIs[0] x
     /* 5427 */   // No operand predicates
     /* 5427 */   // MIs[0] y
     /* 5427 */   // No operand predicates
     /* 5427 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 5432 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5434 */   // Combiner Rule #122: select_undef_cmp
     /* 5434 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 5439 */   GIR_EraseRootFromParent_Done,
     /* 5440 */ // Label 330: @5440
     /* 5440 */ GIM_Reject,
     /* 5441 */ // Label 41: @5441
     /* 5441 */ GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(5452), // Rule ID 324 //
     /* 5446 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5449 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDO'
     /* 5449 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5452 */ // Label 331: @5452
     /* 5452 */ GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(5463), // Rule ID 365 //
     /* 5457 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule217Enabled),
     /* 5460 */   // Combiner Rule #217: match_addos; wip_match_opcode 'G_UADDO'
     /* 5460 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner149),
     /* 5463 */ // Label 332: @5463
     /* 5463 */ GIM_Reject,
     /* 5464 */ // Label 42: @5464
     /* 5464 */ GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(5475), // Rule ID 190 //
     /* 5469 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5472 */   // Combiner Rule #146: adde_to_addo; wip_match_opcode 'G_UADDE'
     /* 5472 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5475 */ // Label 333: @5475
     /* 5475 */ GIM_Reject,
     /* 5476 */ // Label 43: @5476
     /* 5476 */ GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(5487), // Rule ID 367 //
     /* 5481 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule218Enabled),
     /* 5484 */   // Combiner Rule #218: match_subo_no_overflow; wip_match_opcode 'G_USUBO'
     /* 5484 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner150),
     /* 5487 */ // Label 334: @5487
     /* 5487 */ GIM_Reject,
     /* 5488 */ // Label 44: @5488
     /* 5488 */ GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(5499), // Rule ID 192 //
     /* 5493 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5496 */   // Combiner Rule #146: adde_to_addo; wip_match_opcode 'G_USUBE'
     /* 5496 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5499 */ // Label 335: @5499
     /* 5499 */ GIM_Reject,
     /* 5500 */ // Label 45: @5500
     /* 5500 */ GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(5511), // Rule ID 325 //
     /* 5505 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5508 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDO'
     /* 5508 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5511 */ // Label 336: @5511
     /* 5511 */ GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(5522), // Rule ID 364 //
     /* 5516 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule217Enabled),
     /* 5519 */   // Combiner Rule #217: match_addos; wip_match_opcode 'G_SADDO'
     /* 5519 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner149),
     /* 5522 */ // Label 337: @5522
     /* 5522 */ GIM_Reject,
     /* 5523 */ // Label 46: @5523
     /* 5523 */ GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(5534), // Rule ID 191 //
     /* 5528 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5531 */   // Combiner Rule #146: adde_to_addo; wip_match_opcode 'G_SADDE'
     /* 5531 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5534 */ // Label 338: @5534
     /* 5534 */ GIM_Reject,
     /* 5535 */ // Label 47: @5535
     /* 5535 */ GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(5546), // Rule ID 366 //
     /* 5540 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule218Enabled),
     /* 5543 */   // Combiner Rule #218: match_subo_no_overflow; wip_match_opcode 'G_SSUBO'
     /* 5543 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner150),
     /* 5546 */ // Label 339: @5546
     /* 5546 */ GIM_Reject,
     /* 5547 */ // Label 48: @5547
     /* 5547 */ GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(5558), // Rule ID 193 //
     /* 5552 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5555 */   // Combiner Rule #146: adde_to_addo; wip_match_opcode 'G_SSUBE'
     /* 5555 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5558 */ // Label 340: @5558
     /* 5558 */ GIM_Reject,
     /* 5559 */ // Label 49: @5559
     /* 5559 */ GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(5570), // Rule ID 186 //
     /* 5564 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule144Enabled),
     /* 5567 */   // Combiner Rule #144: mulo_by_2; wip_match_opcode 'G_UMULO'
     /* 5567 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner85),
     /* 5570 */ // Label 341: @5570
     /* 5570 */ GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(5581), // Rule ID 188 //
     /* 5575 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 5578 */   // Combiner Rule #145: mulo_by_0; wip_match_opcode 'G_UMULO'
     /* 5578 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner86),
     /* 5581 */ // Label 342: @5581
     /* 5581 */ GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(5592), // Rule ID 326 //
     /* 5586 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5589 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULO'
     /* 5589 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5592 */ // Label 343: @5592
     /* 5592 */ GIM_Reject,
     /* 5593 */ // Label 50: @5593
     /* 5593 */ GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(5604), // Rule ID 187 //
     /* 5598 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule144Enabled),
     /* 5601 */   // Combiner Rule #144: mulo_by_2; wip_match_opcode 'G_SMULO'
     /* 5601 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner85),
     /* 5604 */ // Label 344: @5604
     /* 5604 */ GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(5615), // Rule ID 189 //
     /* 5609 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 5612 */   // Combiner Rule #145: mulo_by_0; wip_match_opcode 'G_SMULO'
     /* 5612 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner86),
     /* 5615 */ // Label 345: @5615
     /* 5615 */ GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(5626), // Rule ID 327 //
     /* 5620 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5623 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULO'
     /* 5623 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5626 */ // Label 346: @5626
     /* 5626 */ GIM_Reject,
     /* 5627 */ // Label 51: @5627
     /* 5627 */ GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(5638), // Rule ID 264 //
     /* 5632 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule174Enabled),
     /* 5635 */   // Combiner Rule #174: mulh_to_lshr; wip_match_opcode 'G_UMULH'
     /* 5635 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner108),
     /* 5638 */ // Label 347: @5638
     /* 5638 */ GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(5649), // Rule ID 328 //
     /* 5643 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5646 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULH'
     /* 5646 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5649 */ // Label 348: @5649
     /* 5649 */ GIM_Reject,
     /* 5650 */ // Label 52: @5650
     /* 5650 */ GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(5661), // Rule ID 329 //
     /* 5655 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5658 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULH'
     /* 5658 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5661 */ // Label 349: @5661
     /* 5661 */ GIM_Reject,
     /* 5662 */ // Label 53: @5662
     /* 5662 */ GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(5673), // Rule ID 330 //
     /* 5667 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5670 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDSAT'
     /* 5670 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5673 */ // Label 350: @5673
     /* 5673 */ GIM_Reject,
     /* 5674 */ // Label 54: @5674
     /* 5674 */ GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(5685), // Rule ID 331 //
     /* 5679 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5682 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDSAT'
     /* 5682 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5685 */ // Label 351: @5685
     /* 5685 */ GIM_Reject,
     /* 5686 */ // Label 55: @5686
     /* 5686 */ GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(5697), // Rule ID 205 //
     /* 5691 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5694 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_USHLSAT'
     /* 5694 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5697 */ // Label 352: @5697
     /* 5697 */ GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(5708), // Rule ID 209 //
     /* 5702 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 5705 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_USHLSAT'
     /* 5705 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5708 */ // Label 353: @5708
     /* 5708 */ GIM_Reject,
     /* 5709 */ // Label 56: @5709
     /* 5709 */ GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(5720), // Rule ID 204 //
     /* 5714 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5717 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_SSHLSAT'
     /* 5717 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5720 */ // Label 354: @5720
     /* 5720 */ GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(5731), // Rule ID 210 //
     /* 5725 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 5728 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_SSHLSAT'
     /* 5728 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5731 */ // Label 355: @5731
     /* 5731 */ GIM_Reject,
     /* 5732 */ // Label 57: @5732
     /* 5732 */ GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(5743), // Rule ID 332 //
     /* 5737 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5740 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIX'
     /* 5740 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5743 */ // Label 356: @5743
     /* 5743 */ GIM_Reject,
     /* 5744 */ // Label 58: @5744
     /* 5744 */ GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(5755), // Rule ID 333 //
     /* 5749 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5752 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIX'
     /* 5752 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5755 */ // Label 357: @5755
     /* 5755 */ GIM_Reject,
     /* 5756 */ // Label 59: @5756
     /* 5756 */ GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(5767), // Rule ID 334 //
     /* 5761 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5764 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIXSAT'
     /* 5764 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5767 */ // Label 358: @5767
     /* 5767 */ GIM_Reject,
     /* 5768 */ // Label 60: @5768
     /* 5768 */ GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(5779), // Rule ID 335 //
     /* 5773 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5776 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIXSAT'
     /* 5776 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5779 */ // Label 359: @5779
     /* 5779 */ GIM_Reject,
     /* 5780 */ // Label 61: @5780
     /* 5780 */ GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(5791), // Rule ID 254 //
     /* 5785 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 5788 */   // Combiner Rule #170: constant_fold_fp_binop; wip_match_opcode 'G_FADD'
     /* 5788 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5791 */ // Label 360: @5791
     /* 5791 */ GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(5802), // Rule ID 265 //
     /* 5796 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 5799 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FADD'
     /* 5799 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5802 */ // Label 361: @5802
     /* 5802 */ GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(5813), // Rule ID 272 //
     /* 5807 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule177Enabled),
     /* 5810 */   // Combiner Rule #177: combine_fadd_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5810 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner111),
     /* 5813 */ // Label 362: @5813
     /* 5813 */ GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(5824), // Rule ID 273 //
     /* 5818 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule178Enabled),
     /* 5821 */   // Combiner Rule #178: combine_fadd_fpext_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5821 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner112),
     /* 5824 */ // Label 363: @5824
     /* 5824 */ GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(5835), // Rule ID 274 //
     /* 5829 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule179Enabled),
     /* 5832 */   // Combiner Rule #179: combine_fadd_fma_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5832 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner113),
     /* 5835 */ // Label 364: @5835
     /* 5835 */ GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(5846), // Rule ID 275 //
     /* 5840 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule180Enabled),
     /* 5843 */   // Combiner Rule #180: combine_fadd_fpext_fma_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5843 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner114),
     /* 5846 */ // Label 365: @5846
     /* 5846 */ GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(5857), // Rule ID 298 //
     /* 5851 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 5854 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FADD'
     /* 5854 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5857 */ // Label 366: @5857
     /* 5857 */ GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(5868), // Rule ID 336 //
     /* 5862 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 5865 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FADD'
     /* 5865 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 5868 */ // Label 367: @5868
     /* 5868 */ GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(5891), // Rule ID 138 //
     /* 5873 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule100Enabled),
     /* 5876 */   // MIs[0] dst
     /* 5876 */   // No operand predicates
     /* 5876 */   // MIs[0] x
     /* 5876 */   // No operand predicates
     /* 5876 */   // MIs[0] y
     /* 5876 */   // No operand predicates
     /* 5876 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner3),
     /* 5880 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5885 */   // Combiner Rule #100: right_identity_neg_zero_fp
     /* 5885 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5890 */   GIR_EraseRootFromParent_Done,
     /* 5891 */ // Label 368: @5891
     /* 5891 */ GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(5920), // Rule ID 139 //
     /* 5896 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule101Enabled),
     /* 5899 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::FmNsz),
     /* 5905 */   // MIs[0] dst
     /* 5905 */   // No operand predicates
     /* 5905 */   // MIs[0] x
     /* 5905 */   // No operand predicates
     /* 5905 */   // MIs[0] y
     /* 5905 */   // No operand predicates
     /* 5905 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner4),
     /* 5909 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5914 */   // Combiner Rule #101: right_identity_neg_zero_fp_nsz
     /* 5914 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5919 */   GIR_EraseRootFromParent_Done,
     /* 5920 */ // Label 369: @5920
     /* 5920 */ GIM_Reject,
     /* 5921 */ // Label 62: @5921
     /* 5921 */ GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(5932), // Rule ID 255 //
     /* 5926 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 5929 */   // Combiner Rule #170: constant_fold_fp_binop; wip_match_opcode 'G_FSUB'
     /* 5929 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5932 */ // Label 370: @5932
     /* 5932 */ GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(5943), // Rule ID 266 //
     /* 5937 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 5940 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FSUB'
     /* 5940 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5943 */ // Label 371: @5943
     /* 5943 */ GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(5954), // Rule ID 276 //
     /* 5948 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule181Enabled),
     /* 5951 */   // Combiner Rule #181: combine_fsub_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5951 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner115),
     /* 5954 */ // Label 372: @5954
     /* 5954 */ GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(5965), // Rule ID 277 //
     /* 5959 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5962 */   // Combiner Rule #182: combine_fsub_fneg_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5962 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner116),
     /* 5965 */ // Label 373: @5965
     /* 5965 */ GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(5976), // Rule ID 278 //
     /* 5970 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule183Enabled),
     /* 5973 */   // Combiner Rule #183: combine_fsub_fpext_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5973 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner117),
     /* 5976 */ // Label 374: @5976
     /* 5976 */ GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(5987), // Rule ID 279 //
     /* 5981 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule184Enabled),
     /* 5984 */   // Combiner Rule #184: combine_fsub_fpext_fneg_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5984 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner118),
     /* 5987 */ // Label 375: @5987
     /* 5987 */ GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(5998), // Rule ID 299 //
     /* 5992 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 5995 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FSUB'
     /* 5995 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5998 */ // Label 376: @5998
     /* 5998 */ GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(6009), // Rule ID 314 //
     /* 6003 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule194Enabled),
     /* 6006 */   // Combiner Rule #194: fsub_to_fneg; wip_match_opcode 'G_FSUB'
     /* 6006 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner126),
     /* 6009 */ // Label 377: @6009
     /* 6009 */ GIM_Reject,
     /* 6010 */ // Label 63: @6010
     /* 6010 */ GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(6021), // Rule ID 256 //
     /* 6015 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 6018 */   // Combiner Rule #170: constant_fold_fp_binop; wip_match_opcode 'G_FMUL'
     /* 6018 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 6021 */ // Label 378: @6021
     /* 6021 */ GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(6032), // Rule ID 267 //
     /* 6026 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 6029 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FMUL'
     /* 6029 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 6032 */ // Label 379: @6032
     /* 6032 */ GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(6043), // Rule ID 297 //
     /* 6037 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6040 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMUL'
     /* 6040 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6043 */ // Label 380: @6043
     /* 6043 */ GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(6054), // Rule ID 337 //
     /* 6048 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6051 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMUL'
     /* 6051 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6054 */ // Label 381: @6054
     /* 6054 */ GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(6075), // Rule ID 373 //
     /* 6059 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule224Enabled),
     /* 6062 */   // MIs[0] dst
     /* 6062 */   // No operand predicates
     /* 6062 */   // MIs[0] x
     /* 6062 */   // No operand predicates
     /* 6062 */   // MIs[0] select
     /* 6062 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6066 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 6070 */   // MIs[1] y
     /* 6070 */   // No operand predicates
     /* 6070 */   // MIs[1] A
     /* 6070 */   // No operand predicates
     /* 6070 */   // MIs[1] B
     /* 6070 */   // No operand predicates
     /* 6070 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6072 */   // Combiner Rule #224: combine_fmul_with_select_to_fldexp
     /* 6072 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner154),
     /* 6075 */ // Label 382: @6075
     /* 6075 */ GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(6098), // Rule ID 129 //
     /* 6080 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule93Enabled),
     /* 6083 */   // MIs[0] dst
     /* 6083 */   // No operand predicates
     /* 6083 */   // MIs[0] x
     /* 6083 */   // No operand predicates
     /* 6083 */   // MIs[0] y
     /* 6083 */   // No operand predicates
     /* 6083 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner2),
     /* 6087 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6092 */   // Combiner Rule #93: right_identity_one_fp
     /* 6092 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6097 */   GIR_EraseRootFromParent_Done,
     /* 6098 */ // Label 383: @6098
     /* 6098 */ GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(6118), // Rule ID 140 //
     /* 6103 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule102Enabled),
     /* 6106 */   // MIs[0] dst
     /* 6106 */   // No operand predicates
     /* 6106 */   // MIs[0] x
     /* 6106 */   // No operand predicates
     /* 6106 */   // MIs[0] y
     /* 6106 */   // No operand predicates
     /* 6106 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner5),
     /* 6110 */   // Combiner Rule #102: right_identity_neg_one_fp
     /* 6110 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 6113 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 6115 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 6117 */   GIR_EraseRootFromParent_Done,
     /* 6118 */ // Label 384: @6118
     /* 6118 */ GIM_Reject,
     /* 6119 */ // Label 64: @6119
     /* 6119 */ GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(6130), // Rule ID 259 //
     /* 6124 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule171Enabled),
     /* 6127 */   // Combiner Rule #171: constant_fold_fma; wip_match_opcode 'G_FMA'
     /* 6127 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner106),
     /* 6130 */ // Label 385: @6130
     /* 6130 */ GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(6141), // Rule ID 270 //
     /* 6135 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 6138 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FMA'
     /* 6138 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 6141 */ // Label 386: @6141
     /* 6141 */ GIM_Reject,
     /* 6142 */ // Label 65: @6142
     /* 6142 */ GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(6153), // Rule ID 258 //
     /* 6147 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule171Enabled),
     /* 6150 */   // Combiner Rule #171: constant_fold_fma; wip_match_opcode 'G_FMAD'
     /* 6150 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner106),
     /* 6153 */ // Label 387: @6153
     /* 6153 */ GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(6164), // Rule ID 269 //
     /* 6158 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 6161 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FMAD'
     /* 6161 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 6164 */ // Label 388: @6164
     /* 6164 */ GIM_Reject,
     /* 6165 */ // Label 66: @6165
     /* 6165 */ GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(6176), // Rule ID 257 //
     /* 6170 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 6173 */   // Combiner Rule #170: constant_fold_fp_binop; wip_match_opcode 'G_FDIV'
     /* 6173 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 6176 */ // Label 389: @6176
     /* 6176 */ GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(6187), // Rule ID 268 //
     /* 6181 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 6184 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FDIV'
     /* 6184 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 6187 */ // Label 390: @6187
     /* 6187 */ GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(6198), // Rule ID 300 //
     /* 6192 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6195 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FDIV'
     /* 6195 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6198 */ // Label 391: @6198
     /* 6198 */ GIM_Reject,
     /* 6199 */ // Label 67: @6199
     /* 6199 */ GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(6210), // Rule ID 301 //
     /* 6204 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6207 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FREM'
     /* 6207 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6210 */ // Label 392: @6210
     /* 6210 */ GIM_Reject,
     /* 6211 */ // Label 68: @6211
     /* 6211 */ GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(6232), // Rule ID 198 //
     /* 6216 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule148Enabled),
     /* 6219 */   // MIs[0] dst
     /* 6219 */   // No operand predicates
     /* 6219 */   // MIs[0] float
     /* 6219 */   // No operand predicates
     /* 6219 */   // MIs[0] int
     /* 6219 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6223 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 6227 */   // MIs[1] imm
     /* 6227 */   // No operand predicates
     /* 6227 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6229 */   // Combiner Rule #148: expand_const_fpowi
     /* 6229 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner89),
     /* 6232 */ // Label 393: @6232
     /* 6232 */ GIM_Reject,
     /* 6233 */ // Label 69: @6233
     /* 6233 */ GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(6254), // Rule ID 180 //
     /* 6238 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule138Enabled),
     /* 6241 */   // MIs[0] dst
     /* 6241 */   // No operand predicates
     /* 6241 */   // MIs[0] src0
     /* 6241 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6245 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 6249 */   // MIs[1] cst
     /* 6249 */   // No operand predicates
     /* 6249 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6251 */   // Combiner Rule #138: constant_fold_flog2
     /* 6251 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 6254 */ // Label 394: @6254
     /* 6254 */ GIM_Reject,
     /* 6255 */ // Label 70: @6255
     /* 6255 */ GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(6266), // Rule ID 375 //
     /* 6260 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule226Enabled),
     /* 6263 */   // Combiner Rule #226: foldable_fneg; wip_match_opcode 'G_FNEG'
     /* 6263 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner156),
     /* 6266 */ // Label 395: @6266
     /* 6266 */ GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(6287), // Rule ID 177 //
     /* 6271 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule135Enabled),
     /* 6274 */   // MIs[0] dst
     /* 6274 */   // No operand predicates
     /* 6274 */   // MIs[0] src0
     /* 6274 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6278 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 6282 */   // MIs[1] cst
     /* 6282 */   // No operand predicates
     /* 6282 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6284 */   // Combiner Rule #135: constant_fold_fneg
     /* 6284 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 6287 */ // Label 396: @6287
     /* 6287 */ GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(6316), // Rule ID 127 //
     /* 6292 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule91Enabled),
     /* 6295 */   // MIs[0] dst
     /* 6295 */   // No operand predicates
     /* 6295 */   // MIs[0] t
     /* 6295 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6299 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 6303 */   // MIs[1] src
     /* 6303 */   // No operand predicates
     /* 6303 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 6308 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6310 */   // Combiner Rule #91: fneg_fneg_fold
     /* 6310 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 6315 */   GIR_EraseRootFromParent_Done,
     /* 6316 */ // Label 397: @6316
     /* 6316 */ GIM_Reject,
     /* 6317 */ // Label 71: @6317
     /* 6317 */ GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(6338), // Rule ID 181 //
     /* 6322 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule139Enabled),
     /* 6325 */   // MIs[0] dst
     /* 6325 */   // No operand predicates
     /* 6325 */   // MIs[0] src0
     /* 6325 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6329 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 6333 */   // MIs[1] cst
     /* 6333 */   // No operand predicates
     /* 6333 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6335 */   // Combiner Rule #139: constant_fold_fptrunc
     /* 6335 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 6338 */ // Label 398: @6338
     /* 6338 */ GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(6359), // Rule ID 137 //
     /* 6343 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule99Enabled),
     /* 6346 */   // MIs[0] dst
     /* 6346 */   // No operand predicates
     /* 6346 */   // MIs[0] src1
     /* 6346 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6350 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPEXT),
     /* 6354 */   // MIs[1] src0
     /* 6354 */   // No operand predicates
     /* 6354 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6356 */   // Combiner Rule #99: fptrunc_fpext_fold
     /* 6356 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner52),
     /* 6359 */ // Label 399: @6359
     /* 6359 */ GIM_Reject,
     /* 6360 */ // Label 72: @6360
     /* 6360 */ GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(6381), // Rule ID 92 //
     /* 6365 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 6368 */   // MIs[0] dst
     /* 6368 */   // No operand predicates
     /* 6368 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 6368 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6372 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6376 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6378 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[5]]
     /* 6378 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 6381 */ // Label 400: @6381
     /* 6381 */ GIM_Reject,
     /* 6382 */ // Label 73: @6382
     /* 6382 */ GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(6403), // Rule ID 93 //
     /* 6387 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 6390 */   // MIs[0] dst
     /* 6390 */   // No operand predicates
     /* 6390 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 6390 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6394 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6398 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6400 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[6]]
     /* 6400 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 6403 */ // Label 401: @6403
     /* 6403 */ GIM_Reject,
     /* 6404 */ // Label 74: @6404
     /* 6404 */ GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(6415), // Rule ID 76 //
     /* 6409 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule71Enabled),
     /* 6412 */   // Combiner Rule #71: undef_to_fp_zero; wip_match_opcode 'G_SITOFP'
     /* 6412 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner33),
     /* 6415 */ // Label 402: @6415
     /* 6415 */ GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(6430), // Rule ID 182 //
     /* 6420 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule140Enabled),
     /* 6423 */   // MIs[0] dst
     /* 6423 */   // No operand predicates
     /* 6423 */   // MIs[0] Operand 1
     /* 6423 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 6427 */   // Combiner Rule #140: itof_const_zero_fold_si
     /* 6427 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner82),
     /* 6430 */ // Label 403: @6430
     /* 6430 */ GIM_Reject,
     /* 6431 */ // Label 75: @6431
     /* 6431 */ GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(6442), // Rule ID 75 //
     /* 6436 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule71Enabled),
     /* 6439 */   // Combiner Rule #71: undef_to_fp_zero; wip_match_opcode 'G_UITOFP'
     /* 6439 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner33),
     /* 6442 */ // Label 404: @6442
     /* 6442 */ GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(6457), // Rule ID 183 //
     /* 6447 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule141Enabled),
     /* 6450 */   // MIs[0] dst
     /* 6450 */   // No operand predicates
     /* 6450 */   // MIs[0] Operand 1
     /* 6450 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 6454 */   // Combiner Rule #141: itof_const_zero_fold_ui
     /* 6454 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner82),
     /* 6457 */ // Label 405: @6457
     /* 6457 */ GIM_Reject,
     /* 6458 */ // Label 76: @6458
     /* 6458 */ GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(6487), // Rule ID 19 //
     /* 6463 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 6466 */   // MIs[0] dst
     /* 6466 */   // No operand predicates
     /* 6466 */   // MIs[0] src
     /* 6466 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6470 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FABS),
     /* 6474 */   // MIs[1] __idempotent_prop_match_0.x
     /* 6474 */   // No operand predicates
     /* 6474 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6479 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6481 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[1]]
     /* 6481 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6486 */   GIR_EraseRootFromParent_Done,
     /* 6487 */ // Label 406: @6487
     /* 6487 */ GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(6508), // Rule ID 178 //
     /* 6492 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule136Enabled),
     /* 6495 */   // MIs[0] dst
     /* 6495 */   // No operand predicates
     /* 6495 */   // MIs[0] src0
     /* 6495 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6499 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 6503 */   // MIs[1] cst
     /* 6503 */   // No operand predicates
     /* 6503 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6505 */   // Combiner Rule #136: constant_fold_fabs
     /* 6505 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 6508 */ // Label 407: @6508
     /* 6508 */ GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(6536), // Rule ID 263 //
     /* 6513 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule173Enabled),
     /* 6516 */   // MIs[0] dst
     /* 6516 */   // No operand predicates
     /* 6516 */   // MIs[0] tmp
     /* 6516 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6520 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 6524 */   // MIs[1] x
     /* 6524 */   // No operand predicates
     /* 6524 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6526 */   // Combiner Rule #173: fabs_fneg_fold
     /* 6526 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FABS),
     /* 6529 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 6531 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 6535 */   GIR_EraseRootFromParent_Done,
     /* 6536 */ // Label 408: @6536
     /* 6536 */ GIM_Reject,
     /* 6537 */ // Label 77: @6537
     /* 6537 */ GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(6566), // Rule ID 20 //
     /* 6542 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 6545 */   // MIs[0] dst
     /* 6545 */   // No operand predicates
     /* 6545 */   // MIs[0] src
     /* 6545 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6549 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCANONICALIZE),
     /* 6553 */   // MIs[1] __idempotent_prop_match_0.x
     /* 6553 */   // No operand predicates
     /* 6553 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6558 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6560 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[2]]
     /* 6560 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6565 */   GIR_EraseRootFromParent_Done,
     /* 6566 */ // Label 409: @6566
     /* 6566 */ GIM_Reject,
     /* 6567 */ // Label 78: @6567
     /* 6567 */ GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(6578), // Rule ID 194 //
     /* 6572 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 6575 */   // Combiner Rule #147: combine_minmax_nan; wip_match_opcode 'G_FMINNUM'
     /* 6575 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6578 */ // Label 410: @6578
     /* 6578 */ GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(6589), // Rule ID 302 //
     /* 6583 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6586 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMINNUM'
     /* 6586 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6589 */ // Label 411: @6589
     /* 6589 */ GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(6600), // Rule ID 338 //
     /* 6594 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6597 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM'
     /* 6597 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6600 */ // Label 412: @6600
     /* 6600 */ GIM_Reject,
     /* 6601 */ // Label 79: @6601
     /* 6601 */ GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(6612), // Rule ID 195 //
     /* 6606 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 6609 */   // Combiner Rule #147: combine_minmax_nan; wip_match_opcode 'G_FMAXNUM'
     /* 6609 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6612 */ // Label 413: @6612
     /* 6612 */ GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(6623), // Rule ID 303 //
     /* 6617 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6620 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMAXNUM'
     /* 6620 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6623 */ // Label 414: @6623
     /* 6623 */ GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(6634), // Rule ID 339 //
     /* 6628 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6631 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM'
     /* 6631 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6634 */ // Label 415: @6634
     /* 6634 */ GIM_Reject,
     /* 6635 */ // Label 80: @6635
     /* 6635 */ GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(6646), // Rule ID 340 //
     /* 6640 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6643 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM_IEEE'
     /* 6643 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6646 */ // Label 416: @6646
     /* 6646 */ GIM_Reject,
     /* 6647 */ // Label 81: @6647
     /* 6647 */ GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(6658), // Rule ID 341 //
     /* 6652 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6655 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM_IEEE'
     /* 6655 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6658 */ // Label 417: @6658
     /* 6658 */ GIM_Reject,
     /* 6659 */ // Label 82: @6659
     /* 6659 */ GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(6670), // Rule ID 196 //
     /* 6664 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 6667 */   // Combiner Rule #147: combine_minmax_nan; wip_match_opcode 'G_FMINIMUM'
     /* 6667 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6670 */ // Label 418: @6670
     /* 6670 */ GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(6681), // Rule ID 304 //
     /* 6675 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6678 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMINIMUM'
     /* 6678 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6681 */ // Label 419: @6681
     /* 6681 */ GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(6692), // Rule ID 342 //
     /* 6686 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6689 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINIMUM'
     /* 6689 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6692 */ // Label 420: @6692
     /* 6692 */ GIM_Reject,
     /* 6693 */ // Label 83: @6693
     /* 6693 */ GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(6704), // Rule ID 197 //
     /* 6698 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 6701 */   // Combiner Rule #147: combine_minmax_nan; wip_match_opcode 'G_FMAXIMUM'
     /* 6701 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6704 */ // Label 421: @6704
     /* 6704 */ GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(6715), // Rule ID 305 //
     /* 6709 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6712 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMAXIMUM'
     /* 6712 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6715 */ // Label 422: @6715
     /* 6715 */ GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(6726), // Rule ID 343 //
     /* 6720 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6723 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXIMUM'
     /* 6723 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6726 */ // Label 423: @6726
     /* 6726 */ GIM_Reject,
     /* 6727 */ // Label 84: @6727
     /* 6727 */ GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(6738), // Rule ID 149 //
     /* 6732 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule107Enabled),
     /* 6735 */   // Combiner Rule #107: reassoc_ptradd; wip_match_opcode 'G_PTR_ADD'
     /* 6735 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner57),
     /* 6738 */ // Label 424: @6738
     /* 6738 */ GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(6749), // Rule ID 151 //
     /* 6743 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule109Enabled),
     /* 6746 */   // Combiner Rule #109: ptr_add_immed_chain; wip_match_opcode 'G_PTR_ADD'
     /* 6746 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner59),
     /* 6749 */ // Label 425: @6749
     /* 6749 */ GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(6760), // Rule ID 184 //
     /* 6754 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule142Enabled),
     /* 6757 */   // Combiner Rule #142: const_ptradd_to_i2p; wip_match_opcode 'G_PTR_ADD'
     /* 6757 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner83),
     /* 6760 */ // Label 426: @6760
     /* 6760 */ GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(6771), // Rule ID 200 //
     /* 6765 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 6768 */   // Combiner Rule #150: ptr_add_with_zero; wip_match_opcode 'G_PTR_ADD'
     /* 6768 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner91),
     /* 6771 */ // Label 427: @6771
     /* 6771 */ GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(6782), // Rule ID 237 //
     /* 6776 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6779 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_PTR_ADD'
     /* 6779 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6782 */ // Label 428: @6782
     /* 6782 */ GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(6793), // Rule ID 282 //
     /* 6787 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6790 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_PTR_ADD'
     /* 6790 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6793 */ // Label 429: @6793
     /* 6793 */ GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(6816), // Rule ID 111 //
     /* 6798 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 6801 */   // MIs[0] dst
     /* 6801 */   // No operand predicates
     /* 6801 */   // MIs[0] lhs
     /* 6801 */   // No operand predicates
     /* 6801 */   // MIs[0] Operand 2
     /* 6801 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 6805 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6810 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[7]]
     /* 6810 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6815 */   GIR_EraseRootFromParent_Done,
     /* 6816 */ // Label 430: @6816
     /* 6816 */ GIM_Reject,
     /* 6817 */ // Label 85: @6817
     /* 6817 */ GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(6828), // Rule ID 250 //
     /* 6822 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6825 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SMIN'
     /* 6825 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6828 */ // Label 431: @6828
     /* 6828 */ GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(6839), // Rule ID 293 //
     /* 6833 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6836 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SMIN'
     /* 6836 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6839 */ // Label 432: @6839
     /* 6839 */ GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(6850), // Rule ID 320 //
     /* 6844 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 6847 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMIN'
     /* 6847 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6850 */ // Label 433: @6850
     /* 6850 */ GIM_Reject,
     /* 6851 */ // Label 86: @6851
     /* 6851 */ GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(6862), // Rule ID 251 //
     /* 6856 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6859 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SMAX'
     /* 6859 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6862 */ // Label 434: @6862
     /* 6862 */ GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(6873), // Rule ID 294 //
     /* 6867 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6870 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SMAX'
     /* 6870 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6873 */ // Label 435: @6873
     /* 6873 */ GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(6884), // Rule ID 321 //
     /* 6878 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 6881 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMAX'
     /* 6881 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6884 */ // Label 436: @6884
     /* 6884 */ GIM_Reject,
     /* 6885 */ // Label 87: @6885
     /* 6885 */ GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(6896), // Rule ID 252 //
     /* 6890 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6893 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_UMIN'
     /* 6893 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6896 */ // Label 437: @6896
     /* 6896 */ GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(6907), // Rule ID 295 //
     /* 6901 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6904 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_UMIN'
     /* 6904 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6907 */ // Label 438: @6907
     /* 6907 */ GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(6918), // Rule ID 322 //
     /* 6912 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 6915 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMIN'
     /* 6915 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6918 */ // Label 439: @6918
     /* 6918 */ GIM_Reject,
     /* 6919 */ // Label 88: @6919
     /* 6919 */ GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(6930), // Rule ID 253 //
     /* 6924 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6927 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_UMAX'
     /* 6927 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6930 */ // Label 440: @6930
     /* 6930 */ GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(6941), // Rule ID 296 //
     /* 6935 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6938 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_UMAX'
     /* 6938 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6941 */ // Label 441: @6941
     /* 6941 */ GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(6952), // Rule ID 323 //
     /* 6946 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 6949 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMAX'
     /* 6949 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6952 */ // Label 442: @6952
     /* 6952 */ GIM_Reject,
     /* 6953 */ // Label 89: @6953
     /* 6953 */ GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(6964), // Rule ID 86 //
     /* 6958 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule76Enabled),
     /* 6961 */   // Combiner Rule #76: unary_undef_to_zero; wip_match_opcode 'G_ABS'
     /* 6961 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 6964 */ // Label 443: @6964
     /* 6964 */ GIM_Reject,
     /* 6965 */ // Label 90: @6965
     /* 6965 */ GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(6976), // Rule ID 176 //
     /* 6970 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule134Enabled),
     /* 6973 */   // Combiner Rule #134: opt_brcond_by_inverting_cond; wip_match_opcode 'G_BR'
     /* 6973 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner80),
     /* 6976 */ // Label 444: @6976
     /* 6976 */ GIM_Reject,
     /* 6977 */ // Label 91: @6977
     /* 6977 */ GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(6988), // Rule ID 26 //
     /* 6982 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 6985 */   // Combiner Rule #24: insert_vector_elt_oob; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 6985 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner10),
     /* 6988 */ // Label 445: @6988
     /* 6988 */ GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(6999), // Rule ID 67 //
     /* 6993 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule65Enabled),
     /* 6996 */   // Combiner Rule #65: combine_insert_vec_elts_build_vector; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 6996 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner27),
     /* 6999 */ // Label 446: @6999
     /* 6999 */ GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(7010), // Rule ID 101 //
     /* 7004 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule82Enabled),
     /* 7007 */   // Combiner Rule #82: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 7007 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner43),
     /* 7010 */ // Label 447: @7010
     /* 7010 */ GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(7049), // Rule ID 38 //
     /* 7015 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule36Enabled),
     /* 7018 */   // MIs[0] root
     /* 7018 */   // No operand predicates
     /* 7018 */   // MIs[0] src
     /* 7018 */   // No operand predicates
     /* 7018 */   // MIs[0] elt
     /* 7018 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 7022 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
     /* 7026 */   // MIs[1] src
     /* 7026 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 7031 */   // MIs[1] idx
     /* 7031 */   // No operand predicates
     /* 7031 */   // MIs[0] idx
     /* 7031 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 7036 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 7041 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7043 */   // Combiner Rule #36: insert_vector_element_extract_vector_element
     /* 7043 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 7048 */   GIR_EraseRootFromParent_Done,
     /* 7049 */ // Label 448: @7049
     /* 7049 */ GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(7082), // Rule ID 24 //
     /* 7054 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule22Enabled),
     /* 7057 */   // MIs[0] root
     /* 7057 */   // No operand predicates
     /* 7057 */   // MIs[0] src
     /* 7057 */   // No operand predicates
     /* 7057 */   // MIs[0] elt
     /* 7057 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 7061 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7065 */   // MIs[0] idx
     /* 7065 */   // No operand predicates
     /* 7065 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner0),
     /* 7069 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 7074 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7076 */   // Combiner Rule #22: insert_vector_element_elt_undef
     /* 7076 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 7081 */   GIR_EraseRootFromParent_Done,
     /* 7082 */ // Label 449: @7082
     /* 7082 */ GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(7106), // Rule ID 23 //
     /* 7087 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule21Enabled),
     /* 7090 */   // MIs[0] root
     /* 7090 */   // No operand predicates
     /* 7090 */   // MIs[0] src
     /* 7090 */   // No operand predicates
     /* 7090 */   // MIs[0] elt
     /* 7090 */   // No operand predicates
     /* 7090 */   // MIs[0] idx
     /* 7090 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 7094 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7098 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7100 */   // Combiner Rule #21: insert_vector_element_idx_undef
     /* 7100 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7103 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 7105 */   GIR_EraseRootFromParent_Done,
     /* 7106 */ // Label 450: @7106
     /* 7106 */ GIM_Reject,
     /* 7107 */ // Label 92: @7107
     /* 7107 */ GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(7118), // Rule ID 25 //
     /* 7112 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 7115 */   // Combiner Rule #23: match_extract_of_element; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 7115 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 7118 */ // Label 451: @7118
     /* 7118 */ GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(7129), // Rule ID 68 //
     /* 7123 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule66Enabled),
     /* 7126 */   // Combiner Rule #66: extract_vec_elt_build_vec; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 7126 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner28),
     /* 7129 */ // Label 452: @7129
     /* 7129 */ GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(7140), // Rule ID 74 //
     /* 7134 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule70Enabled),
     /* 7137 */   // Combiner Rule #70: combine_extracted_vector_load; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 7137 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner32),
     /* 7140 */ // Label 453: @7140
     /* 7140 */ GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(7151), // Rule ID 102 //
     /* 7145 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule82Enabled),
     /* 7148 */   // Combiner Rule #82: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 7148 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner43),
     /* 7151 */ // Label 454: @7151
     /* 7151 */ GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(7175), // Rule ID 36 //
     /* 7156 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule34Enabled),
     /* 7159 */   // MIs[0] root
     /* 7159 */   // No operand predicates
     /* 7159 */   // MIs[0] src
     /* 7159 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7163 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7167 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/9,
     /* 7170 */   // MIs[1] x
     /* 7170 */   // No operand predicates
     /* 7170 */   // MIs[1] y
     /* 7170 */   // No operand predicates
     /* 7170 */   // MIs[1] z
     /* 7170 */   // No operand predicates
     /* 7170 */   // MIs[1] a
     /* 7170 */   // No operand predicates
     /* 7170 */   // MIs[1] b
     /* 7170 */   // No operand predicates
     /* 7170 */   // MIs[1] c
     /* 7170 */   // No operand predicates
     /* 7170 */   // MIs[1] d
     /* 7170 */   // No operand predicates
     /* 7170 */   // MIs[1] e
     /* 7170 */   // No operand predicates
     /* 7170 */   // MIs[0] idx
     /* 7170 */   // No operand predicates
     /* 7170 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7172 */   // Combiner Rule #34: extract_vector_element_build_vector_trunc8
     /* 7172 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7175 */ // Label 455: @7175
     /* 7175 */ GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(7199), // Rule ID 35 //
     /* 7180 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule33Enabled),
     /* 7183 */   // MIs[0] root
     /* 7183 */   // No operand predicates
     /* 7183 */   // MIs[0] src
     /* 7183 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7187 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7191 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/8,
     /* 7194 */   // MIs[1] x
     /* 7194 */   // No operand predicates
     /* 7194 */   // MIs[1] y
     /* 7194 */   // No operand predicates
     /* 7194 */   // MIs[1] z
     /* 7194 */   // No operand predicates
     /* 7194 */   // MIs[1] a
     /* 7194 */   // No operand predicates
     /* 7194 */   // MIs[1] b
     /* 7194 */   // No operand predicates
     /* 7194 */   // MIs[1] c
     /* 7194 */   // No operand predicates
     /* 7194 */   // MIs[1] d
     /* 7194 */   // No operand predicates
     /* 7194 */   // MIs[0] idx
     /* 7194 */   // No operand predicates
     /* 7194 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7196 */   // Combiner Rule #33: extract_vector_element_build_vector_trunc7
     /* 7196 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7199 */ // Label 456: @7199
     /* 7199 */ GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(7223), // Rule ID 34 //
     /* 7204 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule32Enabled),
     /* 7207 */   // MIs[0] root
     /* 7207 */   // No operand predicates
     /* 7207 */   // MIs[0] src
     /* 7207 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7211 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7215 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/7,
     /* 7218 */   // MIs[1] x
     /* 7218 */   // No operand predicates
     /* 7218 */   // MIs[1] y
     /* 7218 */   // No operand predicates
     /* 7218 */   // MIs[1] z
     /* 7218 */   // No operand predicates
     /* 7218 */   // MIs[1] a
     /* 7218 */   // No operand predicates
     /* 7218 */   // MIs[1] b
     /* 7218 */   // No operand predicates
     /* 7218 */   // MIs[1] c
     /* 7218 */   // No operand predicates
     /* 7218 */   // MIs[0] idx
     /* 7218 */   // No operand predicates
     /* 7218 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7220 */   // Combiner Rule #32: extract_vector_element_build_vector_trunc6
     /* 7220 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7223 */ // Label 457: @7223
     /* 7223 */ GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(7247), // Rule ID 33 //
     /* 7228 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule31Enabled),
     /* 7231 */   // MIs[0] root
     /* 7231 */   // No operand predicates
     /* 7231 */   // MIs[0] src
     /* 7231 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7235 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7239 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/6,
     /* 7242 */   // MIs[1] x
     /* 7242 */   // No operand predicates
     /* 7242 */   // MIs[1] y
     /* 7242 */   // No operand predicates
     /* 7242 */   // MIs[1] z
     /* 7242 */   // No operand predicates
     /* 7242 */   // MIs[1] a
     /* 7242 */   // No operand predicates
     /* 7242 */   // MIs[1] b
     /* 7242 */   // No operand predicates
     /* 7242 */   // MIs[0] idx
     /* 7242 */   // No operand predicates
     /* 7242 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7244 */   // Combiner Rule #31: extract_vector_element_build_vector_trunc5
     /* 7244 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7247 */ // Label 458: @7247
     /* 7247 */ GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(7271), // Rule ID 32 //
     /* 7252 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule30Enabled),
     /* 7255 */   // MIs[0] root
     /* 7255 */   // No operand predicates
     /* 7255 */   // MIs[0] src
     /* 7255 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7259 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7263 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/5,
     /* 7266 */   // MIs[1] x
     /* 7266 */   // No operand predicates
     /* 7266 */   // MIs[1] y
     /* 7266 */   // No operand predicates
     /* 7266 */   // MIs[1] z
     /* 7266 */   // No operand predicates
     /* 7266 */   // MIs[1] a
     /* 7266 */   // No operand predicates
     /* 7266 */   // MIs[0] idx
     /* 7266 */   // No operand predicates
     /* 7266 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7268 */   // Combiner Rule #30: extract_vector_element_build_vector_trunc4
     /* 7268 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7271 */ // Label 459: @7271
     /* 7271 */ GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(7295), // Rule ID 31 //
     /* 7276 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule29Enabled),
     /* 7279 */   // MIs[0] root
     /* 7279 */   // No operand predicates
     /* 7279 */   // MIs[0] src
     /* 7279 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7283 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7287 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /* 7290 */   // MIs[1] x
     /* 7290 */   // No operand predicates
     /* 7290 */   // MIs[1] y
     /* 7290 */   // No operand predicates
     /* 7290 */   // MIs[1] z
     /* 7290 */   // No operand predicates
     /* 7290 */   // MIs[0] idx
     /* 7290 */   // No operand predicates
     /* 7290 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7292 */   // Combiner Rule #29: extract_vector_element_build_vector_trunc3
     /* 7292 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7295 */ // Label 460: @7295
     /* 7295 */ GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(7329), // Rule ID 27 //
     /* 7300 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 7303 */   // MIs[0] root
     /* 7303 */   // No operand predicates
     /* 7303 */   // MIs[0] src
     /* 7303 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7307 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INSERT_VECTOR_ELT),
     /* 7311 */   // MIs[1] x
     /* 7311 */   // No operand predicates
     /* 7311 */   // MIs[1] value
     /* 7311 */   // No operand predicates
     /* 7311 */   // MIs[1] idx
     /* 7311 */   // No operand predicates
     /* 7311 */   // MIs[0] idx
     /* 7311 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/3,
     /* 7316 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/2,
     /* 7321 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7323 */   // Combiner Rule #25: extract_vector_element_not_const
     /* 7323 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/2,
     /* 7328 */   GIR_EraseRootFromParent_Done,
     /* 7329 */ // Label 461: @7329
     /* 7329 */ GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(7350), // Rule ID 28 //
     /* 7334 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule26Enabled),
     /* 7337 */   // MIs[0] root
     /* 7337 */   // No operand predicates
     /* 7337 */   // MIs[0] src
     /* 7337 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7341 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INSERT_VECTOR_ELT),
     /* 7345 */   // MIs[1] x
     /* 7345 */   // No operand predicates
     /* 7345 */   // MIs[1] value
     /* 7345 */   // No operand predicates
     /* 7345 */   // MIs[1] idx2
     /* 7345 */   // No operand predicates
     /* 7345 */   // MIs[0] idx1
     /* 7345 */   // No operand predicates
     /* 7345 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7347 */   // Combiner Rule #26: extract_vector_element_different_indices
     /* 7347 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner11),
     /* 7350 */ // Label 462: @7350
     /* 7350 */ GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(7379), // Rule ID 37 //
     /* 7355 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule35Enabled),
     /* 7358 */   // MIs[0] root
     /* 7358 */   // No operand predicates
     /* 7358 */   // MIs[0] src
     /* 7358 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7362 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHUFFLE_VECTOR),
     /* 7366 */   // MIs[1] src1
     /* 7366 */   // No operand predicates
     /* 7366 */   // MIs[1] src2
     /* 7366 */   // No operand predicates
     /* 7366 */   // MIs[1] mask
     /* 7366 */   // No operand predicates
     /* 7366 */   // MIs[0] idx
     /* 7366 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 7370 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 7374 */   // MIs[2] imm
     /* 7374 */   // No operand predicates
     /* 7374 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7376 */   // Combiner Rule #35: extract_vector_element_shuffle_vector
     /* 7376 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 7379 */ // Label 463: @7379
     /* 7379 */ GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(7403), // Rule ID 30 //
     /* 7384 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule28Enabled),
     /* 7387 */   // MIs[0] root
     /* 7387 */   // No operand predicates
     /* 7387 */   // MIs[0] src
     /* 7387 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7391 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7395 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /* 7398 */   // MIs[1] x
     /* 7398 */   // No operand predicates
     /* 7398 */   // MIs[1] y
     /* 7398 */   // No operand predicates
     /* 7398 */   // MIs[0] idx
     /* 7398 */   // No operand predicates
     /* 7398 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7400 */   // Combiner Rule #28: extract_vector_element_build_vector_trunc2
     /* 7400 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7403 */ // Label 464: @7403
     /* 7403 */ GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(7435), // Rule ID 29 //
     /* 7408 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule27Enabled),
     /* 7411 */   // MIs[0] root
     /* 7411 */   // No operand predicates
     /* 7411 */   // MIs[0] src
     /* 7411 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7415 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
     /* 7419 */   GIM_CheckNumOperandsGE, /*MI*/1, /*Expected*/2,
     /* 7422 */   // MIs[1] unused
     /* 7422 */   // No operand predicates
     /* 7422 */   // MIs[0] idx
     /* 7422 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 7426 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 7430 */   // MIs[2] imm
     /* 7430 */   // No operand predicates
     /* 7430 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7432 */   // Combiner Rule #27: extract_vector_element_build_vector
     /* 7432 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner12),
     /* 7435 */ // Label 465: @7435
     /* 7435 */ GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(7459), // Rule ID 21 //
     /* 7440 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule19Enabled),
     /* 7443 */   // MIs[0] root
     /* 7443 */   // No operand predicates
     /* 7443 */   // MIs[0] vector
     /* 7443 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7447 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7451 */   // MIs[0] idx
     /* 7451 */   // No operand predicates
     /* 7451 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7453 */   // Combiner Rule #19: match_extract_of_element_undef_vector
     /* 7453 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7456 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 7458 */   GIR_EraseRootFromParent_Done,
     /* 7459 */ // Label 466: @7459
     /* 7459 */ GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(7483), // Rule ID 22 //
     /* 7464 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule20Enabled),
     /* 7467 */   // MIs[0] root
     /* 7467 */   // No operand predicates
     /* 7467 */   // MIs[0] vector
     /* 7467 */   // No operand predicates
     /* 7467 */   // MIs[0] idx
     /* 7467 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 7471 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7475 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7477 */   // Combiner Rule #20: match_extract_of_element_undef_index
     /* 7477 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7480 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 7482 */   GIR_EraseRootFromParent_Done,
     /* 7483 */ // Label 467: @7483
     /* 7483 */ GIM_Reject,
     /* 7484 */ // Label 93: @7484
     /* 7484 */ GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(7495), // Rule ID 97 //
     /* 7489 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 7492 */   // Combiner Rule #79: propagate_undef_all_ops; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 7492 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 7495 */ // Label 468: @7495
     /* 7495 */ GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(7506), // Rule ID 99 //
     /* 7500 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule80Enabled),
     /* 7503 */   // Combiner Rule #80: propagate_undef_shuffle_mask; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 7503 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner41),
     /* 7506 */ // Label 469: @7506
     /* 7506 */ GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(7517), // Rule ID 351 //
     /* 7511 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule204Enabled),
     /* 7514 */   // Combiner Rule #204: combine_shuffle_concat; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 7514 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner136),
     /* 7517 */ // Label 470: @7517
     /* 7517 */ GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(7528), // Rule ID 353 //
     /* 7522 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule206Enabled),
     /* 7525 */   // Combiner Rule #206: combine_shuffle_disjoint_mask; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 7525 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner138),
     /* 7528 */ // Label 471: @7528
     /* 7528 */ GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(7549), // Rule ID 352 //
     /* 7533 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule205Enabled),
     /* 7536 */   // MIs[0] root
     /* 7536 */   // No operand predicates
     /* 7536 */   // MIs[0] src1
     /* 7536 */   // No operand predicates
     /* 7536 */   // MIs[0] undef
     /* 7536 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 7540 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7544 */   // MIs[0] mask
     /* 7544 */   // No operand predicates
     /* 7544 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7546 */   // Combiner Rule #205: combine_shuffle_undef_rhs
     /* 7546 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner137),
     /* 7549 */ // Label 472: @7549
     /* 7549 */ GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(7560), // Rule ID 376 //
     /* 7554 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule227Enabled),
     /* 7557 */   // MIs[0] dst
     /* 7557 */   // No operand predicates
     /* 7557 */   // MIs[0] src1
     /* 7557 */   // No operand predicates
     /* 7557 */   // MIs[0] src2
     /* 7557 */   // No operand predicates
     /* 7557 */   // MIs[0] mask
     /* 7557 */   // No operand predicates
     /* 7557 */   // Combiner Rule #227: combine_shuffle_vector_to_build_vector
     /* 7557 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner157),
     /* 7560 */ // Label 473: @7560
     /* 7560 */ GIM_Reject,
     /* 7561 */ // Label 94: @7561
     /* 7561 */ GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(7605), // Rule ID 228 //
     /* 7566 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule163Enabled),
     /* 7569 */   // MIs[0] d
     /* 7569 */   // No operand predicates
     /* 7569 */   // MIs[0] src
     /* 7569 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7573 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 7577 */   // MIs[1] rev
     /* 7577 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 7581 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITREVERSE),
     /* 7585 */   // MIs[2] val
     /* 7585 */   // No operand predicates
     /* 7585 */   // MIs[1] amt
     /* 7585 */   // No operand predicates
     /* 7585 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner10),
     /* 7589 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7591 */   // Combiner Rule #163: bitreverse_lshr
     /* 7591 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SHL),
     /* 7594 */   GIR_RootToRootCopy, /*OpIdx*/0, // d
     /* 7596 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // val
     /* 7600 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // amt
     /* 7604 */   GIR_EraseRootFromParent_Done,
     /* 7605 */ // Label 474: @7605
     /* 7605 */ GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(7649), // Rule ID 227 //
     /* 7610 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule162Enabled),
     /* 7613 */   // MIs[0] d
     /* 7613 */   // No operand predicates
     /* 7613 */   // MIs[0] src
     /* 7613 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7617 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 7621 */   // MIs[1] rev
     /* 7621 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 7625 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITREVERSE),
     /* 7629 */   // MIs[2] val
     /* 7629 */   // No operand predicates
     /* 7629 */   // MIs[1] amt
     /* 7629 */   // No operand predicates
     /* 7629 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner9),
     /* 7633 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7635 */   // Combiner Rule #162: bitreverse_shl
     /* 7635 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 7638 */   GIR_RootToRootCopy, /*OpIdx*/0, // d
     /* 7640 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // val
     /* 7644 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // amt
     /* 7648 */   GIR_EraseRootFromParent_Done,
     /* 7649 */ // Label 475: @7649
     /* 7649 */ GIM_Reject,
     /* 7650 */ // Label 95: @7650
     /* 7650 */ GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(7671), // Rule ID 179 //
     /* 7655 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule137Enabled),
     /* 7658 */   // MIs[0] dst
     /* 7658 */   // No operand predicates
     /* 7658 */   // MIs[0] src0
     /* 7658 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7662 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 7666 */   // MIs[1] cst
     /* 7666 */   // No operand predicates
     /* 7666 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7668 */   // Combiner Rule #137: constant_fold_fsqrt
     /* 7668 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 7671 */ // Label 476: @7671
     /* 7671 */ GIM_Reject,
     /* 7672 */ // Label 96: @7672
     /* 7672 */ GIM_Reject,
     /* 7673 */ }; // Size: 7673 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GICOMBINER_IMPL

#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS

