/* File automatically generated by u_indices_gen.py */

/*
 * Copyright 2009 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.  IN NO EVENT SHALL
 * VMWARE AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 */



/**
 * @file
 * Functions to translate and generate index lists
 */

#include "indices/u_indices_priv.h"
#include "util/u_debug.h"
#include "util/u_memory.h"


static unsigned out_size_idx( unsigned index_size )
{
   switch (index_size) {
   case 4: return OUT_UINT;
   case 2: return OUT_USHORT;
   default: assert(0); return OUT_USHORT;
   }
}

static unsigned in_size_idx( unsigned index_size )
{
   switch (index_size) {
   case 4: return IN_UINT;
   case 2: return IN_USHORT;
   case 1: return IN_UBYTE;
   default: assert(0); return IN_UBYTE;
   }
}


static u_translate_func translate[IN_COUNT][OUT_COUNT][PV_COUNT][PV_COUNT][PR_COUNT][PRIM_COUNT];
static u_generate_func  generate[OUT_COUNT][PV_COUNT][PV_COUNT][PRIM_COUNT];



static void generate_points_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)(i);
   }
}
static void generate_lines_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1);
   }
}
static void generate_linestrip_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1);
   }
}
static void generate_lineloop_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1);
      end = i+1;
   }
      (out+j)[0] = (ushort)(end);
      (out+j)[1] = (ushort)(start);
}
static void generate_tris_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
   }
}
static void generate_tristrip_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1+(i&1));
      (out+j)[2] = (ushort)(i+2-(i&1));
   }
}
static void generate_trifan_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i+2);
      (out+j)[2] = (ushort)(start);
   }
}
static void generate_quads_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)(i+0);
      (out+j+0)[1] = (ushort)(i+1);
      (out+j+0)[2] = (ushort)(i+2);
      (out+j+3)[0] = (ushort)(i+0);
      (out+j+3)[1] = (ushort)(i+2);
      (out+j+3)[2] = (ushort)(i+3);
   }
}
static void generate_quadstrip_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)(i+0);
      (out+j+0)[1] = (ushort)(i+1);
      (out+j+0)[2] = (ushort)(i+3);
      (out+j+3)[0] = (ushort)(i+0);
      (out+j+3)[1] = (ushort)(i+3);
      (out+j+3)[2] = (ushort)(i+2);
   }
}
static void generate_polygon_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(start);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
   }
}
static void generate_linesadj_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)(i+0);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i+3);
  }
}
static void generate_linestripadj_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)(i+0);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i+3);
  }
}
static void generate_trisadj_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)(i+0);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i+3);
      (out+j)[4] = (ushort)(i+4);
      (out+j)[5] = (ushort)(i+5);
  }
}
static void generate_tristripadj_ushort_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)(i+0);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i+3);
      (out+j)[4] = (ushort)(i+4);
      (out+j)[5] = (ushort)(i+5);
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)(i+2);
      (out+j)[1] = (ushort)(i-2);
      (out+j)[2] = (ushort)(i+0);
      (out+j)[3] = (ushort)(i+3);
      (out+j)[4] = (ushort)(i+4);
      (out+j)[5] = (ushort)(i+6);
    }
  }
}
static void generate_points_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)(i);
   }
}
static void generate_lines_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i);
   }
}
static void generate_linestrip_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i);
   }
}
static void generate_lineloop_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i);
      end = i+1;
   }
      (out+j)[0] = (ushort)(start);
      (out+j)[1] = (ushort)(end);
}
static void generate_tris_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i+2);
      (out+j)[2] = (ushort)(i);
   }
}
static void generate_tristrip_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(i+1+(i&1));
      (out+j)[1] = (ushort)(i+2-(i&1));
      (out+j)[2] = (ushort)(i);
   }
}
static void generate_trifan_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(i+2);
      (out+j)[1] = (ushort)(start);
      (out+j)[2] = (ushort)(i+1);
   }
}
static void generate_quads_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)(i+1);
      (out+j+0)[1] = (ushort)(i+2);
      (out+j+0)[2] = (ushort)(i+0);
      (out+j+3)[0] = (ushort)(i+2);
      (out+j+3)[1] = (ushort)(i+3);
      (out+j+3)[2] = (ushort)(i+0);
   }
}
static void generate_quadstrip_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)(i+1);
      (out+j+0)[1] = (ushort)(i+3);
      (out+j+0)[2] = (ushort)(i+0);
      (out+j+3)[0] = (ushort)(i+3);
      (out+j+3)[1] = (ushort)(i+2);
      (out+j+3)[2] = (ushort)(i+0);
   }
}
static void generate_polygon_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i+2);
      (out+j)[2] = (ushort)(start);
   }
}
static void generate_linesadj_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)(i+3);
      (out+j)[1] = (ushort)(i+2);
      (out+j)[2] = (ushort)(i+1);
      (out+j)[3] = (ushort)(i+0);
  }
}
static void generate_linestripadj_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)(i+3);
      (out+j)[1] = (ushort)(i+2);
      (out+j)[2] = (ushort)(i+1);
      (out+j)[3] = (ushort)(i+0);
  }
}
static void generate_trisadj_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)(i+4);
      (out+j)[1] = (ushort)(i+5);
      (out+j)[2] = (ushort)(i+0);
      (out+j)[3] = (ushort)(i+1);
      (out+j)[4] = (ushort)(i+2);
      (out+j)[5] = (ushort)(i+3);
  }
}
static void generate_tristripadj_ushort_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)(i+4);
      (out+j)[1] = (ushort)(i+5);
      (out+j)[2] = (ushort)(i+0);
      (out+j)[3] = (ushort)(i+1);
      (out+j)[4] = (ushort)(i+2);
      (out+j)[5] = (ushort)(i+3);
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)(i+4);
      (out+j)[1] = (ushort)(i+6);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i-2);
      (out+j)[4] = (ushort)(i+0);
      (out+j)[5] = (ushort)(i+3);
    }
  }
}
static void generate_points_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)(i);
   }
}
static void generate_lines_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i);
   }
}
static void generate_linestrip_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i);
   }
}
static void generate_lineloop_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i);
      end = i+1;
   }
      (out+j)[0] = (ushort)(start);
      (out+j)[1] = (ushort)(end);
}
static void generate_tris_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)(i+2);
      (out+j)[1] = (ushort)(i);
      (out+j)[2] = (ushort)(i+1);
   }
}
static void generate_tristrip_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(i+2);
      (out+j)[1] = (ushort)(i+(i&1));
      (out+j)[2] = (ushort)(i+1-(i&1));
   }
}
static void generate_trifan_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(i+2);
      (out+j)[1] = (ushort)(start);
      (out+j)[2] = (ushort)(i+1);
   }
}
static void generate_quads_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)(i+3);
      (out+j+0)[1] = (ushort)(i+0);
      (out+j+0)[2] = (ushort)(i+1);
      (out+j+3)[0] = (ushort)(i+3);
      (out+j+3)[1] = (ushort)(i+1);
      (out+j+3)[2] = (ushort)(i+2);
   }
}
static void generate_quadstrip_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)(i+3);
      (out+j+0)[1] = (ushort)(i+2);
      (out+j+0)[2] = (ushort)(i+0);
      (out+j+3)[0] = (ushort)(i+3);
      (out+j+3)[1] = (ushort)(i+0);
      (out+j+3)[2] = (ushort)(i+1);
   }
}
static void generate_polygon_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(start);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
   }
}
static void generate_linesadj_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)(i+3);
      (out+j)[1] = (ushort)(i+2);
      (out+j)[2] = (ushort)(i+1);
      (out+j)[3] = (ushort)(i+0);
  }
}
static void generate_linestripadj_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)(i+3);
      (out+j)[1] = (ushort)(i+2);
      (out+j)[2] = (ushort)(i+1);
      (out+j)[3] = (ushort)(i+0);
  }
}
static void generate_trisadj_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)(i+4);
      (out+j)[1] = (ushort)(i+5);
      (out+j)[2] = (ushort)(i+0);
      (out+j)[3] = (ushort)(i+1);
      (out+j)[4] = (ushort)(i+2);
      (out+j)[5] = (ushort)(i+3);
  }
}
static void generate_tristripadj_ushort_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)(i+4);
      (out+j)[1] = (ushort)(i+5);
      (out+j)[2] = (ushort)(i+0);
      (out+j)[3] = (ushort)(i+1);
      (out+j)[4] = (ushort)(i+2);
      (out+j)[5] = (ushort)(i+3);
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)(i+4);
      (out+j)[1] = (ushort)(i+6);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i-2);
      (out+j)[4] = (ushort)(i+0);
      (out+j)[5] = (ushort)(i+3);
    }
  }
}
static void generate_points_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)(i);
   }
}
static void generate_lines_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1);
   }
}
static void generate_linestrip_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1);
   }
}
static void generate_lineloop_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1);
      end = i+1;
   }
      (out+j)[0] = (ushort)(end);
      (out+j)[1] = (ushort)(start);
}
static void generate_tris_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
   }
}
static void generate_tristrip_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(i+(i&1));
      (out+j)[1] = (ushort)(i+1-(i&1));
      (out+j)[2] = (ushort)(i+2);
   }
}
static void generate_trifan_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(start);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
   }
}
static void generate_quads_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)(i+0);
      (out+j+0)[1] = (ushort)(i+1);
      (out+j+0)[2] = (ushort)(i+3);
      (out+j+3)[0] = (ushort)(i+1);
      (out+j+3)[1] = (ushort)(i+2);
      (out+j+3)[2] = (ushort)(i+3);
   }
}
static void generate_quadstrip_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)(i+2);
      (out+j+0)[1] = (ushort)(i+0);
      (out+j+0)[2] = (ushort)(i+3);
      (out+j+3)[0] = (ushort)(i+0);
      (out+j+3)[1] = (ushort)(i+1);
      (out+j+3)[2] = (ushort)(i+3);
   }
}
static void generate_polygon_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)(i+1);
      (out+j)[1] = (ushort)(i+2);
      (out+j)[2] = (ushort)(start);
   }
}
static void generate_linesadj_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)(i+0);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i+3);
  }
}
static void generate_linestripadj_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)(i+0);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i+3);
  }
}
static void generate_trisadj_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)(i+0);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i+3);
      (out+j)[4] = (ushort)(i+4);
      (out+j)[5] = (ushort)(i+5);
  }
}
static void generate_tristripadj_ushort_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)(i+0);
      (out+j)[1] = (ushort)(i+1);
      (out+j)[2] = (ushort)(i+2);
      (out+j)[3] = (ushort)(i+3);
      (out+j)[4] = (ushort)(i+4);
      (out+j)[5] = (ushort)(i+5);
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)(i+2);
      (out+j)[1] = (ushort)(i-2);
      (out+j)[2] = (ushort)(i+0);
      (out+j)[3] = (ushort)(i+3);
      (out+j)[4] = (ushort)(i+4);
      (out+j)[5] = (ushort)(i+6);
    }
  }
}
static void generate_points_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)(i);
   }
}
static void generate_lines_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1);
   }
}
static void generate_linestrip_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1);
   }
}
static void generate_lineloop_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1);
      end = i+1;
   }
      (out+j)[0] = (uint)(end);
      (out+j)[1] = (uint)(start);
}
static void generate_tris_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
   }
}
static void generate_tristrip_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1+(i&1));
      (out+j)[2] = (uint)(i+2-(i&1));
   }
}
static void generate_trifan_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i+2);
      (out+j)[2] = (uint)(start);
   }
}
static void generate_quads_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)(i+0);
      (out+j+0)[1] = (uint)(i+1);
      (out+j+0)[2] = (uint)(i+2);
      (out+j+3)[0] = (uint)(i+0);
      (out+j+3)[1] = (uint)(i+2);
      (out+j+3)[2] = (uint)(i+3);
   }
}
static void generate_quadstrip_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)(i+0);
      (out+j+0)[1] = (uint)(i+1);
      (out+j+0)[2] = (uint)(i+3);
      (out+j+3)[0] = (uint)(i+0);
      (out+j+3)[1] = (uint)(i+3);
      (out+j+3)[2] = (uint)(i+2);
   }
}
static void generate_polygon_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(start);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
   }
}
static void generate_linesadj_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)(i+0);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i+3);
  }
}
static void generate_linestripadj_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)(i+0);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i+3);
  }
}
static void generate_trisadj_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)(i+0);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i+3);
      (out+j)[4] = (uint)(i+4);
      (out+j)[5] = (uint)(i+5);
  }
}
static void generate_tristripadj_uint_first2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)(i+0);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i+3);
      (out+j)[4] = (uint)(i+4);
      (out+j)[5] = (uint)(i+5);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)(i+2);
      (out+j)[1] = (uint)(i-2);
      (out+j)[2] = (uint)(i+0);
      (out+j)[3] = (uint)(i+3);
      (out+j)[4] = (uint)(i+4);
      (out+j)[5] = (uint)(i+6);
    }
  }
}
static void generate_points_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)(i);
   }
}
static void generate_lines_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i);
   }
}
static void generate_linestrip_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i);
   }
}
static void generate_lineloop_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i);
      end = i+1;
   }
      (out+j)[0] = (uint)(start);
      (out+j)[1] = (uint)(end);
}
static void generate_tris_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i+2);
      (out+j)[2] = (uint)(i);
   }
}
static void generate_tristrip_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(i+1+(i&1));
      (out+j)[1] = (uint)(i+2-(i&1));
      (out+j)[2] = (uint)(i);
   }
}
static void generate_trifan_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(i+2);
      (out+j)[1] = (uint)(start);
      (out+j)[2] = (uint)(i+1);
   }
}
static void generate_quads_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)(i+1);
      (out+j+0)[1] = (uint)(i+2);
      (out+j+0)[2] = (uint)(i+0);
      (out+j+3)[0] = (uint)(i+2);
      (out+j+3)[1] = (uint)(i+3);
      (out+j+3)[2] = (uint)(i+0);
   }
}
static void generate_quadstrip_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)(i+1);
      (out+j+0)[1] = (uint)(i+3);
      (out+j+0)[2] = (uint)(i+0);
      (out+j+3)[0] = (uint)(i+3);
      (out+j+3)[1] = (uint)(i+2);
      (out+j+3)[2] = (uint)(i+0);
   }
}
static void generate_polygon_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i+2);
      (out+j)[2] = (uint)(start);
   }
}
static void generate_linesadj_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)(i+3);
      (out+j)[1] = (uint)(i+2);
      (out+j)[2] = (uint)(i+1);
      (out+j)[3] = (uint)(i+0);
  }
}
static void generate_linestripadj_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)(i+3);
      (out+j)[1] = (uint)(i+2);
      (out+j)[2] = (uint)(i+1);
      (out+j)[3] = (uint)(i+0);
  }
}
static void generate_trisadj_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)(i+4);
      (out+j)[1] = (uint)(i+5);
      (out+j)[2] = (uint)(i+0);
      (out+j)[3] = (uint)(i+1);
      (out+j)[4] = (uint)(i+2);
      (out+j)[5] = (uint)(i+3);
  }
}
static void generate_tristripadj_uint_first2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)(i+4);
      (out+j)[1] = (uint)(i+5);
      (out+j)[2] = (uint)(i+0);
      (out+j)[3] = (uint)(i+1);
      (out+j)[4] = (uint)(i+2);
      (out+j)[5] = (uint)(i+3);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)(i+4);
      (out+j)[1] = (uint)(i+6);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i-2);
      (out+j)[4] = (uint)(i+0);
      (out+j)[5] = (uint)(i+3);
    }
  }
}
static void generate_points_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)(i);
   }
}
static void generate_lines_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i);
   }
}
static void generate_linestrip_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i);
   }
}
static void generate_lineloop_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i);
      end = i+1;
   }
      (out+j)[0] = (uint)(start);
      (out+j)[1] = (uint)(end);
}
static void generate_tris_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)(i+2);
      (out+j)[1] = (uint)(i);
      (out+j)[2] = (uint)(i+1);
   }
}
static void generate_tristrip_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(i+2);
      (out+j)[1] = (uint)(i+(i&1));
      (out+j)[2] = (uint)(i+1-(i&1));
   }
}
static void generate_trifan_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(i+2);
      (out+j)[1] = (uint)(start);
      (out+j)[2] = (uint)(i+1);
   }
}
static void generate_quads_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)(i+3);
      (out+j+0)[1] = (uint)(i+0);
      (out+j+0)[2] = (uint)(i+1);
      (out+j+3)[0] = (uint)(i+3);
      (out+j+3)[1] = (uint)(i+1);
      (out+j+3)[2] = (uint)(i+2);
   }
}
static void generate_quadstrip_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)(i+3);
      (out+j+0)[1] = (uint)(i+2);
      (out+j+0)[2] = (uint)(i+0);
      (out+j+3)[0] = (uint)(i+3);
      (out+j+3)[1] = (uint)(i+0);
      (out+j+3)[2] = (uint)(i+1);
   }
}
static void generate_polygon_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(start);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
   }
}
static void generate_linesadj_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)(i+3);
      (out+j)[1] = (uint)(i+2);
      (out+j)[2] = (uint)(i+1);
      (out+j)[3] = (uint)(i+0);
  }
}
static void generate_linestripadj_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)(i+3);
      (out+j)[1] = (uint)(i+2);
      (out+j)[2] = (uint)(i+1);
      (out+j)[3] = (uint)(i+0);
  }
}
static void generate_trisadj_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)(i+4);
      (out+j)[1] = (uint)(i+5);
      (out+j)[2] = (uint)(i+0);
      (out+j)[3] = (uint)(i+1);
      (out+j)[4] = (uint)(i+2);
      (out+j)[5] = (uint)(i+3);
  }
}
static void generate_tristripadj_uint_last2first(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)(i+4);
      (out+j)[1] = (uint)(i+5);
      (out+j)[2] = (uint)(i+0);
      (out+j)[3] = (uint)(i+1);
      (out+j)[4] = (uint)(i+2);
      (out+j)[5] = (uint)(i+3);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)(i+4);
      (out+j)[1] = (uint)(i+6);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i-2);
      (out+j)[4] = (uint)(i+0);
      (out+j)[5] = (uint)(i+3);
    }
  }
}
static void generate_points_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)(i);
   }
}
static void generate_lines_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1);
   }
}
static void generate_linestrip_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1);
   }
}
static void generate_lineloop_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1);
      end = i+1;
   }
      (out+j)[0] = (uint)(end);
      (out+j)[1] = (uint)(start);
}
static void generate_tris_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
   }
}
static void generate_tristrip_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(i+(i&1));
      (out+j)[1] = (uint)(i+1-(i&1));
      (out+j)[2] = (uint)(i+2);
   }
}
static void generate_trifan_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(start);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
   }
}
static void generate_quads_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)(i+0);
      (out+j+0)[1] = (uint)(i+1);
      (out+j+0)[2] = (uint)(i+3);
      (out+j+3)[0] = (uint)(i+1);
      (out+j+3)[1] = (uint)(i+2);
      (out+j+3)[2] = (uint)(i+3);
   }
}
static void generate_quadstrip_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)(i+2);
      (out+j+0)[1] = (uint)(i+0);
      (out+j+0)[2] = (uint)(i+3);
      (out+j+3)[0] = (uint)(i+0);
      (out+j+3)[1] = (uint)(i+1);
      (out+j+3)[2] = (uint)(i+3);
   }
}
static void generate_polygon_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)(i+1);
      (out+j)[1] = (uint)(i+2);
      (out+j)[2] = (uint)(start);
   }
}
static void generate_linesadj_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)(i+0);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i+3);
  }
}
static void generate_linestripadj_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)(i+0);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i+3);
  }
}
static void generate_trisadj_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)(i+0);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i+3);
      (out+j)[4] = (uint)(i+4);
      (out+j)[5] = (uint)(i+5);
  }
}
static void generate_tristripadj_uint_last2last(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)(i+0);
      (out+j)[1] = (uint)(i+1);
      (out+j)[2] = (uint)(i+2);
      (out+j)[3] = (uint)(i+3);
      (out+j)[4] = (uint)(i+4);
      (out+j)[5] = (uint)(i+5);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)(i+2);
      (out+j)[1] = (uint)(i-2);
      (out+j)[2] = (uint)(i+0);
      (out+j)[3] = (uint)(i+3);
      (out+j)[4] = (uint)(i+4);
      (out+j)[5] = (uint)(i+6);
    }
  }
}
static void translate_points_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1+(i&1)];
      (out+j)[2] = (ushort)in[i+2-(i&1)];
   }
}
static void translate_trifan_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_quads_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+2];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_polygon_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_ubyte2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1+(i&1)];
      (out+j)[2] = (ushort)in[i+2-(i&1)];
   }
}
static void translate_trifan_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_quads_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+2];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_polygon_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_ubyte2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_tristrip_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1+(i&1)];
      (out+j)[1] = (ushort)in[i+2-(i&1)];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_trifan_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+2];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_quadstrip_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+3];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_polygon_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_ubyte2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_tristrip_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1+(i&1)];
      (out+j)[1] = (ushort)in[i+2-(i&1)];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_trifan_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+2];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_quadstrip_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+3];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_polygon_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_ubyte2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_tristrip_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i+(i&1)];
      (out+j)[2] = (ushort)in[i+1-(i&1)];
   }
}
static void translate_trifan_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+1];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_quadstrip_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+0];
      (out+j+3)[2] = (ushort)in[i+1];
   }
}
static void translate_polygon_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_ubyte2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_tristrip_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i+(i&1)];
      (out+j)[2] = (ushort)in[i+1-(i&1)];
   }
}
static void translate_trifan_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+1];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_quadstrip_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+0];
      (out+j+3)[2] = (ushort)in[i+1];
   }
}
static void translate_polygon_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_ubyte2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+(i&1)];
      (out+j)[1] = (ushort)in[i+1-(i&1)];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_trifan_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_quads_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+1];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+2];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_polygon_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_ubyte2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+(i&1)];
      (out+j)[1] = (ushort)in[i+1-(i&1)];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_trifan_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_quads_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+1];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+2];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_polygon_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_ubyte2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1+(i&1)];
      (out+j)[2] = (uint)in[i+2-(i&1)];
   }
}
static void translate_trifan_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_quads_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+2];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_polygon_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_ubyte2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1+(i&1)];
      (out+j)[2] = (uint)in[i+2-(i&1)];
   }
}
static void translate_trifan_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_quads_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+2];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_polygon_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_ubyte2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_tristrip_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1+(i&1)];
      (out+j)[1] = (uint)in[i+2-(i&1)];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_trifan_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+2];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_quadstrip_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+3];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_polygon_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_ubyte2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_tristrip_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1+(i&1)];
      (out+j)[1] = (uint)in[i+2-(i&1)];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_trifan_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+2];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_quadstrip_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+3];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_polygon_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_ubyte2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_tristrip_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i+(i&1)];
      (out+j)[2] = (uint)in[i+1-(i&1)];
   }
}
static void translate_trifan_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+1];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_quadstrip_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+0];
      (out+j+3)[2] = (uint)in[i+1];
   }
}
static void translate_polygon_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_ubyte2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_tristrip_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i+(i&1)];
      (out+j)[2] = (uint)in[i+1-(i&1)];
   }
}
static void translate_trifan_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+1];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_quadstrip_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+0];
      (out+j+3)[2] = (uint)in[i+1];
   }
}
static void translate_polygon_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_ubyte2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+(i&1)];
      (out+j)[1] = (uint)in[i+1-(i&1)];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_trifan_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_quads_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+1];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+2];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_polygon_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_ubyte2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+(i&1)];
      (out+j)[1] = (uint)in[i+1-(i&1)];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_trifan_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_quads_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+1];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+2];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_polygon_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_ubyte2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ubyte* restrict in = (const ubyte* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1+(i&1)];
      (out+j)[2] = (ushort)in[i+2-(i&1)];
   }
}
static void translate_trifan_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_quads_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+2];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_polygon_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_ushort2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1+(i&1)];
      (out+j)[2] = (ushort)in[i+2-(i&1)];
   }
}
static void translate_trifan_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_quads_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+2];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_polygon_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_ushort2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_tristrip_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1+(i&1)];
      (out+j)[1] = (ushort)in[i+2-(i&1)];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_trifan_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+2];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_quadstrip_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+3];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_polygon_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_ushort2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_tristrip_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1+(i&1)];
      (out+j)[1] = (ushort)in[i+2-(i&1)];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_trifan_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+2];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_quadstrip_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+3];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_polygon_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_ushort2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_tristrip_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i+(i&1)];
      (out+j)[2] = (ushort)in[i+1-(i&1)];
   }
}
static void translate_trifan_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+1];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_quadstrip_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+0];
      (out+j+3)[2] = (ushort)in[i+1];
   }
}
static void translate_polygon_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_ushort2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_tristrip_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i+(i&1)];
      (out+j)[2] = (ushort)in[i+1-(i&1)];
   }
}
static void translate_trifan_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+1];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_quadstrip_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+0];
      (out+j+3)[2] = (ushort)in[i+1];
   }
}
static void translate_polygon_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_ushort2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+(i&1)];
      (out+j)[1] = (ushort)in[i+1-(i&1)];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_trifan_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_quads_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+1];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+2];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_polygon_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_ushort2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+(i&1)];
      (out+j)[1] = (ushort)in[i+1-(i&1)];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_trifan_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_quads_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+1];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+2];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_polygon_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_ushort2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1+(i&1)];
      (out+j)[2] = (uint)in[i+2-(i&1)];
   }
}
static void translate_trifan_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_quads_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+2];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_polygon_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_ushort2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1+(i&1)];
      (out+j)[2] = (uint)in[i+2-(i&1)];
   }
}
static void translate_trifan_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_quads_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+2];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_polygon_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_ushort2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_tristrip_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1+(i&1)];
      (out+j)[1] = (uint)in[i+2-(i&1)];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_trifan_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+2];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_quadstrip_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+3];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_polygon_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_ushort2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_tristrip_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1+(i&1)];
      (out+j)[1] = (uint)in[i+2-(i&1)];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_trifan_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+2];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_quadstrip_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+3];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_polygon_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_ushort2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_tristrip_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i+(i&1)];
      (out+j)[2] = (uint)in[i+1-(i&1)];
   }
}
static void translate_trifan_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+1];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_quadstrip_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+0];
      (out+j+3)[2] = (uint)in[i+1];
   }
}
static void translate_polygon_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_ushort2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_tristrip_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i+(i&1)];
      (out+j)[2] = (uint)in[i+1-(i&1)];
   }
}
static void translate_trifan_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+1];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_quadstrip_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+0];
      (out+j+3)[2] = (uint)in[i+1];
   }
}
static void translate_polygon_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_ushort2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+(i&1)];
      (out+j)[1] = (uint)in[i+1-(i&1)];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_trifan_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_quads_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+1];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+2];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_polygon_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_ushort2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+(i&1)];
      (out+j)[1] = (uint)in[i+1-(i&1)];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_trifan_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_quads_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+1];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+2];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_polygon_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_ushort2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const ushort* restrict in = (const ushort* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1+(i&1)];
      (out+j)[2] = (ushort)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_quads_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+2];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_polygon_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_uint2ushort_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1+(i&1)];
      (out+j)[2] = (ushort)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_quads_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+2];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_polygon_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_uint2ushort_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_tristrip_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1+(i&1)];
      (out+j)[1] = (ushort)in[i+2-(i&1)];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_trifan_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+2];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_quadstrip_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+3];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_polygon_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_uint2ushort_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_tristrip_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1+(i&1)];
      (out+j)[1] = (ushort)in[i+2-(i&1)];
      (out+j)[2] = (ushort)in[i];
   }
}
static void translate_trifan_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+2];
      (out+j+3)[1] = (ushort)in[i+3];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_quadstrip_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+1];
      (out+j+0)[1] = (ushort)in[i+3];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+0];
   }
}
static void translate_polygon_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_uint2ushort_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_tristrip_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i+(i&1)];
      (out+j)[2] = (ushort)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+1];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_quadstrip_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+0];
      (out+j+3)[2] = (ushort)in[i+1];
   }
}
static void translate_polygon_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_uint2ushort_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_linestrip_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
   }
}
static void translate_lineloop_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[end];
}
static void translate_tris_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_tristrip_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i+(i&1)];
      (out+j)[2] = (ushort)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[start];
      (out+j)[2] = (ushort)in[i+1];
   }
}
static void translate_quads_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+1];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+2];
   }
}
static void translate_quadstrip_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+3];
      (out+j+0)[1] = (ushort)in[i+2];
      (out+j+0)[2] = (ushort)in[i+0];
      (out+j+3)[0] = (ushort)in[i+3];
      (out+j+3)[1] = (ushort)in[i+0];
      (out+j+3)[2] = (ushort)in[i+1];
   }
}
static void translate_polygon_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_linesadj_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_linestripadj_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+3];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[i+1];
      (out+j)[3] = (ushort)in[i+0];
  }
}
static void translate_trisadj_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
  }
}
static void translate_tristripadj_uint2ushort_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+5];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+1];
      (out+j)[4] = (ushort)in[i+2];
      (out+j)[5] = (ushort)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+4];
      (out+j)[1] = (ushort)in[i+6];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i-2];
      (out+j)[4] = (ushort)in[i+0];
      (out+j)[5] = (ushort)in[i+3];
    }
  }
}
static void translate_points_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+(i&1)];
      (out+j)[1] = (ushort)in[i+1-(i&1)];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_trifan_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_quads_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+1];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (ushort)in[i+2];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_polygon_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_uint2ushort_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (ushort)in[i];
   }
}
static void translate_lines_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_linestrip_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
   }
}
static void translate_lineloop_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (ushort)in[end];
      (out+j)[1] = (ushort)in[start];
}
static void translate_tris_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_tristrip_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (ushort)in[i+(i&1)];
      (out+j)[1] = (ushort)in[i+1-(i&1)];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_trifan_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[start];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
   }
}
static void translate_quads_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+0];
      (out+j+0)[1] = (ushort)in[i+1];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+1];
      (out+j+3)[1] = (ushort)in[i+2];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_quadstrip_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (ushort)in[i+2];
      (out+j+0)[1] = (ushort)in[i+0];
      (out+j+0)[2] = (ushort)in[i+3];
      (out+j+3)[0] = (ushort)in[i+0];
      (out+j+3)[1] = (ushort)in[i+1];
      (out+j+3)[2] = (ushort)in[i+3];
   }
}
static void translate_polygon_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (ushort)in[i+1];
      (out+j)[1] = (ushort)in[i+2];
      (out+j)[2] = (ushort)in[start];
   }
}
static void translate_linesadj_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_linestripadj_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
  }
}
static void translate_trisadj_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
  }
}
static void translate_tristripadj_uint2ushort_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  ushort * restrict out = (ushort* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j)[2] = (ushort)in[i+2];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i-2];
      (out+j)[2] = (ushort)in[i+0];
      (out+j)[3] = (ushort)in[i+3];
      (out+j)[4] = (ushort)in[i+4];
      (out+j)[5] = (ushort)in[i+6];
    }
  }
}
static void translate_points_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1+(i&1)];
      (out+j)[2] = (uint)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_quads_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+2];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_polygon_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_uint2uint_first2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1+(i&1)];
      (out+j)[2] = (uint)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_quads_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+2];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_polygon_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_uint2uint_first2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_tristrip_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1+(i&1)];
      (out+j)[1] = (uint)in[i+2-(i&1)];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_trifan_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+2];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_quadstrip_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+3];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_polygon_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_uint2uint_first2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_tristrip_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1+(i&1)];
      (out+j)[1] = (uint)in[i+2-(i&1)];
      (out+j)[2] = (uint)in[i];
   }
}
static void translate_trifan_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+2];
      (out+j+3)[1] = (uint)in[i+3];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_quadstrip_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+1];
      (out+j+0)[1] = (uint)in[i+3];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+0];
   }
}
static void translate_polygon_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_uint2uint_first2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_tristrip_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i+(i&1)];
      (out+j)[2] = (uint)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+1];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_quadstrip_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+0];
      (out+j+3)[2] = (uint)in[i+1];
   }
}
static void translate_polygon_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_uint2uint_last2first_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_linestrip_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
   }
}
static void translate_lineloop_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[end];
}
static void translate_tris_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_tristrip_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i+(i&1)];
      (out+j)[2] = (uint)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[start];
      (out+j)[2] = (uint)in[i+1];
   }
}
static void translate_quads_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+1];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+2];
   }
}
static void translate_quadstrip_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+3];
      (out+j+0)[1] = (uint)in[i+2];
      (out+j+0)[2] = (uint)in[i+0];
      (out+j+3)[0] = (uint)in[i+3];
      (out+j+3)[1] = (uint)in[i+0];
      (out+j+3)[2] = (uint)in[i+1];
   }
}
static void translate_polygon_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_linesadj_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_linestripadj_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+3];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[i+1];
      (out+j)[3] = (uint)in[i+0];
  }
}
static void translate_trisadj_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
  }
}
static void translate_tristripadj_uint2uint_last2first_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+5];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+1];
      (out+j)[4] = (uint)in[i+2];
      (out+j)[5] = (uint)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+4];
      (out+j)[1] = (uint)in[i+6];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i-2];
      (out+j)[4] = (uint)in[i+0];
      (out+j)[5] = (uint)in[i+3];
    }
  }
}
static void translate_points_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+(i&1)];
      (out+j)[1] = (uint)in[i+1-(i&1)];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_trifan_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_quads_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+1];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
      (out+j+0)[0] = (uint)in[i+2];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_polygon_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_uint2uint_last2last_prdisable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
static void translate_points_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) { 
      (out+j)[0] = (uint)in[i];
   }
}
static void translate_lines_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_linestrip_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
   }
}
static void translate_lineloop_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) { 
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint)in[end];
      (out+j)[1] = (uint)in[start];
}
static void translate_tris_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_tristrip_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
      (out+j)[0] = (uint)in[i+(i&1)];
      (out+j)[1] = (uint)in[i+1-(i&1)];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_trifan_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[start];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
   }
}
static void translate_quads_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+0];
      (out+j+0)[1] = (uint)in[i+1];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+1];
      (out+j+3)[1] = (uint)in[i+2];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_quadstrip_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) { 
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint)in[i+2];
      (out+j+0)[1] = (uint)in[i+0];
      (out+j+0)[2] = (uint)in[i+3];
      (out+j+3)[0] = (uint)in[i+0];
      (out+j+3)[1] = (uint)in[i+1];
      (out+j+3)[2] = (uint)in[i+3];
   }
}
static void translate_polygon_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) { 
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint)in[i+1];
      (out+j)[1] = (uint)in[i+2];
      (out+j)[2] = (uint)in[start];
   }
}
static void translate_linesadj_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_linestripadj_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
  }
}
static void translate_trisadj_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
  }
}
static void translate_tristripadj_uint2uint_last2last_prenable(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint* restrict in = (const uint* restrict)_in;
  uint * restrict out = (uint* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) { 
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j)[2] = (uint)in[i+2];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i-2];
      (out+j)[2] = (uint)in[i+0];
      (out+j)[3] = (uint)in[i+3];
      (out+j)[4] = (uint)in[i+4];
      (out+j)[5] = (uint)in[i+6];
    }
  }
}
void u_index_init( void )
{
  static int firsttime = 1;
  if (!firsttime) return;
  firsttime = 0;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_POINTS] = generate_points_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINES] = generate_lines_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLES] = generate_tris_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_QUADS] = generate_quads_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_POLYGON] = generate_polygon_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_POINTS] = generate_points_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINES] = generate_lines_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLES] = generate_tris_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_QUADS] = generate_quads_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_POLYGON] = generate_polygon_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_ushort_first2first;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_POINTS] = generate_points_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINES] = generate_lines_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLES] = generate_tris_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_QUADS] = generate_quads_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_POLYGON] = generate_polygon_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_POINTS] = generate_points_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINES] = generate_lines_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLES] = generate_tris_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_QUADS] = generate_quads_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_POLYGON] = generate_polygon_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_ushort_first2last;
generate[OUT_USHORT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_ushort_first2last;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_POINTS] = generate_points_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINES] = generate_lines_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLES] = generate_tris_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_QUADS] = generate_quads_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_POLYGON] = generate_polygon_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_POINTS] = generate_points_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINES] = generate_lines_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLES] = generate_tris_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_QUADS] = generate_quads_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_POLYGON] = generate_polygon_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_ushort_last2first;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_POINTS] = generate_points_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINES] = generate_lines_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLES] = generate_tris_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_QUADS] = generate_quads_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_POLYGON] = generate_polygon_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_POINTS] = generate_points_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINES] = generate_lines_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLES] = generate_tris_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_QUADS] = generate_quads_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_POLYGON] = generate_polygon_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_ushort_last2last;
generate[OUT_USHORT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_ushort_last2last;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_POINTS] = generate_points_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINES] = generate_lines_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLES] = generate_tris_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_QUADS] = generate_quads_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_POLYGON] = generate_polygon_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_POINTS] = generate_points_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINES] = generate_lines_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLES] = generate_tris_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_QUADS] = generate_quads_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_POLYGON] = generate_polygon_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint_first2first;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_POINTS] = generate_points_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINES] = generate_lines_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLES] = generate_tris_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_QUADS] = generate_quads_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_POLYGON] = generate_polygon_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_POINTS] = generate_points_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINES] = generate_lines_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLES] = generate_tris_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_QUADS] = generate_quads_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_POLYGON] = generate_polygon_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint_first2last;
generate[OUT_UINT][PV_FIRST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint_first2last;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_POINTS] = generate_points_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINES] = generate_lines_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLES] = generate_tris_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_QUADS] = generate_quads_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_POLYGON] = generate_polygon_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_POINTS] = generate_points_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINES] = generate_lines_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLES] = generate_tris_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_QUADS] = generate_quads_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_POLYGON] = generate_polygon_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_FIRST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint_last2first;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_POINTS] = generate_points_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINES] = generate_lines_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLES] = generate_tris_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_QUADS] = generate_quads_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_POLYGON] = generate_polygon_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_POINTS] = generate_points_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINES] = generate_lines_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_STRIP] = generate_linestrip_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_LOOP] = generate_lineloop_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLES] = generate_tris_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_QUADS] = generate_quads_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_POLYGON] = generate_polygon_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINES_ADJACENCY] = generate_linesadj_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint_last2last;
generate[OUT_UINT][PV_LAST][PV_LAST][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint_last2last;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2ushort_first2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2ushort_first2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2ushort_first2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2ushort_first2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2ushort_last2first_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2ushort_last2first_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2ushort_last2last_prdisable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2ushort_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2uint_first2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2uint_first2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2uint_first2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2uint_first2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2uint_last2first_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2uint_last2first_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2uint_last2last_prdisable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ubyte2uint_last2last_prenable;
translate[IN_UBYTE][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ubyte2uint_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2ushort_first2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2ushort_first2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2ushort_first2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2ushort_first2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2ushort_last2first_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2ushort_last2first_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2ushort_last2last_prdisable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2ushort_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2uint_first2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2uint_first2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2uint_first2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2uint_first2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2uint_last2first_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2uint_last2first_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2uint_last2last_prdisable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_ushort2uint_last2last_prenable;
translate[IN_USHORT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_ushort2uint_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2ushort_first2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2ushort_first2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2ushort_first2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2ushort_first2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2ushort_last2first_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2ushort_last2first_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2ushort_last2last_prdisable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_USHORT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2ushort_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2uint_first2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2uint_first2first_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2uint_first2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_FIRST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2uint_first2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2uint_last2first_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_FIRST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2uint_last2first_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POINTS] = translate_points_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES] = translate_lines_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUADS] = translate_quads_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_DISABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2uint_last2last_prdisable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POINTS] = translate_points_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES] = translate_lines_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP] = translate_linestrip_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_LOOP] = translate_lineloop_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES] = translate_tris_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUADS] = translate_quads_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_POLYGON] = translate_polygon_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINES_ADJACENCY] = translate_linesadj_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint2uint_last2last_prenable;
translate[IN_UINT][OUT_UINT][PV_LAST][PV_LAST][PR_ENABLE][PIPE_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint2uint_last2last_prenable;
}
#include "indices/u_indices.c"
