/* PantheonShell.c generated by valac 0.56.18, the Vala compiler
 * generated from PantheonShell.vala, do not modify */

/*
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * Copyright 2023 Corentin Noël <tintou@noel.tf>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <meta/meta-context.h>
#include <wayland-server.h>
#include <glib.h>
#include <meta/meta-wayland-compositor.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <glib-object.h>
#include <wayland-server-protocol.h>
#include <meta/window.h>
#include <meta/common.h>
#include <meta/display.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef void (*PantheonDesktopGetPanel) (struct wl_client* client, struct wl_resource* resource, guint32 output, struct wl_resource* surface);
typedef void (*PantheonDesktopGetWidget) (struct wl_client* client, struct wl_resource* resource, guint32 output, struct wl_resource* surface);
typedef void (*PantheonDesktopGetExtendedBehavior) (struct wl_client* client, struct wl_resource* resource, guint32 output, struct wl_resource* surface);
typedef void (*PantheonDesktopDestroy) (struct wl_client* client, struct wl_resource* resource);
typedef void (*PantheonDesktopSetAnchor) (struct wl_client* client, struct wl_resource* resource, uint32_t anchor);
typedef void (*PantheonDesktopFocus) (struct wl_client* client, struct wl_resource* resource);
typedef void (*PantheonDesktopSetSize) (struct wl_client* client, struct wl_resource* resource, gint width, gint height);
typedef void (*PantheonDesktopSetKeepAbove) (struct wl_client* client, struct wl_resource* resource);
typedef void (*PantheonDesktopMakeCentered) (struct wl_client* client, struct wl_resource* resource);
#define _wl_global_destroy0(var) ((var == NULL) ? NULL : (var = (wl_global_destroy (var), NULL)))

#define GREETER_COMPOSITOR_TYPE_PANEL_SURFACE (greeter_compositor_panel_surface_get_type ())
#define GREETER_COMPOSITOR_PANEL_SURFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_PANEL_SURFACE, GreeterCompositorPanelSurface))
#define GREETER_COMPOSITOR_PANEL_SURFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_PANEL_SURFACE, GreeterCompositorPanelSurfaceClass))
#define GREETER_COMPOSITOR_IS_PANEL_SURFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_PANEL_SURFACE))
#define GREETER_COMPOSITOR_IS_PANEL_SURFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_PANEL_SURFACE))
#define GREETER_COMPOSITOR_PANEL_SURFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_PANEL_SURFACE, GreeterCompositorPanelSurfaceClass))

typedef struct _GreeterCompositorPanelSurface GreeterCompositorPanelSurface;
typedef struct _GreeterCompositorPanelSurfaceClass GreeterCompositorPanelSurfaceClass;
typedef struct _GreeterCompositorPanelSurfacePrivate GreeterCompositorPanelSurfacePrivate;
enum  {
	GREETER_COMPOSITOR_PANEL_SURFACE_0_PROPERTY,
	GREETER_COMPOSITOR_PANEL_SURFACE_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_panel_surface_properties[GREETER_COMPOSITOR_PANEL_SURFACE_NUM_PROPERTIES];

#define GREETER_COMPOSITOR_TYPE_WIDGET_SURFACE (greeter_compositor_widget_surface_get_type ())
#define GREETER_COMPOSITOR_WIDGET_SURFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WIDGET_SURFACE, GreeterCompositorWidgetSurface))
#define GREETER_COMPOSITOR_WIDGET_SURFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WIDGET_SURFACE, GreeterCompositorWidgetSurfaceClass))
#define GREETER_COMPOSITOR_IS_WIDGET_SURFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WIDGET_SURFACE))
#define GREETER_COMPOSITOR_IS_WIDGET_SURFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WIDGET_SURFACE))
#define GREETER_COMPOSITOR_WIDGET_SURFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WIDGET_SURFACE, GreeterCompositorWidgetSurfaceClass))

typedef struct _GreeterCompositorWidgetSurface GreeterCompositorWidgetSurface;
typedef struct _GreeterCompositorWidgetSurfaceClass GreeterCompositorWidgetSurfaceClass;
typedef struct _GreeterCompositorWidgetSurfacePrivate GreeterCompositorWidgetSurfacePrivate;
enum  {
	GREETER_COMPOSITOR_WIDGET_SURFACE_0_PROPERTY,
	GREETER_COMPOSITOR_WIDGET_SURFACE_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_widget_surface_properties[GREETER_COMPOSITOR_WIDGET_SURFACE_NUM_PROPERTIES];

#define GREETER_COMPOSITOR_TYPE_EXTENDED_BEHAVIOR_SURFACE (greeter_compositor_extended_behavior_surface_get_type ())
#define GREETER_COMPOSITOR_EXTENDED_BEHAVIOR_SURFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_EXTENDED_BEHAVIOR_SURFACE, GreeterCompositorExtendedBehaviorSurface))
#define GREETER_COMPOSITOR_EXTENDED_BEHAVIOR_SURFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_EXTENDED_BEHAVIOR_SURFACE, GreeterCompositorExtendedBehaviorSurfaceClass))
#define GREETER_COMPOSITOR_IS_EXTENDED_BEHAVIOR_SURFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_EXTENDED_BEHAVIOR_SURFACE))
#define GREETER_COMPOSITOR_IS_EXTENDED_BEHAVIOR_SURFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_EXTENDED_BEHAVIOR_SURFACE))
#define GREETER_COMPOSITOR_EXTENDED_BEHAVIOR_SURFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_EXTENDED_BEHAVIOR_SURFACE, GreeterCompositorExtendedBehaviorSurfaceClass))

typedef struct _GreeterCompositorExtendedBehaviorSurface GreeterCompositorExtendedBehaviorSurface;
typedef struct _GreeterCompositorExtendedBehaviorSurfaceClass GreeterCompositorExtendedBehaviorSurfaceClass;
typedef struct _GreeterCompositorExtendedBehaviorSurfacePrivate GreeterCompositorExtendedBehaviorSurfacePrivate;
enum  {
	GREETER_COMPOSITOR_EXTENDED_BEHAVIOR_SURFACE_0_PROPERTY,
	GREETER_COMPOSITOR_EXTENDED_BEHAVIOR_SURFACE_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_extended_behavior_surface_properties[GREETER_COMPOSITOR_EXTENDED_BEHAVIOR_SURFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER (greeter_compositor_shell_clients_manager_get_type ())
#define GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManager))
#define GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManagerClass))
#define GREETER_COMPOSITOR_IS_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER))
#define GREETER_COMPOSITOR_IS_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER))
#define GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManagerClass))

typedef struct _GreeterCompositorShellClientsManager GreeterCompositorShellClientsManager;
typedef struct _GreeterCompositorShellClientsManagerClass GreeterCompositorShellClientsManagerClass;

struct _GreeterCompositorPanelSurface {
	GObject parent_instance;
	GreeterCompositorPanelSurfacePrivate * priv;
	GObject* wayland_surface;
};

struct _GreeterCompositorPanelSurfaceClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorWidgetSurface {
	GObject parent_instance;
	GreeterCompositorWidgetSurfacePrivate * priv;
	GObject* wayland_surface;
};

struct _GreeterCompositorWidgetSurfaceClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorExtendedBehaviorSurface {
	GObject parent_instance;
	GreeterCompositorExtendedBehaviorSurfacePrivate * priv;
	GObject* wayland_surface;
};

struct _GreeterCompositorExtendedBehaviorSurfaceClass {
	GObjectClass parent_class;
};

VALA_EXTERN struct io_elementary_pantheon_shell_v1_interface greeter_compositor_wayland_pantheon_shell_interface;
struct io_elementary_pantheon_shell_v1_interface greeter_compositor_wayland_pantheon_shell_interface = {0};
VALA_EXTERN struct io_elementary_pantheon_panel_v1_interface greeter_compositor_wayland_pantheon_panel_interface;
struct io_elementary_pantheon_panel_v1_interface greeter_compositor_wayland_pantheon_panel_interface = {0};
VALA_EXTERN struct io_elementary_pantheon_widget_v1_interface greeter_compositor_wayland_pantheon_widget_interface;
struct io_elementary_pantheon_widget_v1_interface greeter_compositor_wayland_pantheon_widget_interface = {0};
VALA_EXTERN struct io_elementary_pantheon_extended_behavior_v1_interface greeter_compositor_wayland_pantheon_extended_behavior_interface;
struct io_elementary_pantheon_extended_behavior_v1_interface greeter_compositor_wayland_pantheon_extended_behavior_interface = {0};
VALA_EXTERN struct wl_global* greeter_compositor_shell_global;
struct wl_global* greeter_compositor_shell_global = NULL;
VALA_EXTERN GQuark greeter_compositor_panel_surface_quark;
VALA_EXTERN GQuark greeter_compositor_widget_surface_quark;
VALA_EXTERN GQuark greeter_compositor_extended_behavior_surface_quark;
static gpointer greeter_compositor_panel_surface_parent_class = NULL;
GQuark greeter_compositor_panel_surface_quark = (GQuark) 0;
static gpointer greeter_compositor_widget_surface_parent_class = NULL;
GQuark greeter_compositor_widget_surface_quark = (GQuark) 0;
static gpointer greeter_compositor_extended_behavior_surface_parent_class = NULL;
GQuark greeter_compositor_extended_behavior_surface_quark = (GQuark) 0;

VALA_EXTERN struct wl_display* greeter_compositor_get_display_from_context (MetaContext* context);
VALA_EXTERN void greeter_compositor_init_pantheon_shell (MetaContext* context);
VALA_EXTERN void greeter_compositor_get_panel (struct wl_client* client,
                                   struct wl_resource* resource,
                                   guint32 output,
                                   struct wl_resource* surface_resource);
static void _greeter_compositor_get_panel_pantheon_desktop_get_panel (struct wl_client* client,
                                                               struct wl_resource* resource,
                                                               guint32 output,
                                                               struct wl_resource* surface);
VALA_EXTERN void greeter_compositor_get_widget (struct wl_client* client,
                                    struct wl_resource* resource,
                                    guint32 output,
                                    struct wl_resource* surface_resource);
static void _greeter_compositor_get_widget_pantheon_desktop_get_widget (struct wl_client* client,
                                                                 struct wl_resource* resource,
                                                                 guint32 output,
                                                                 struct wl_resource* surface);
VALA_EXTERN void greeter_compositor_get_extended_behavior (struct wl_client* client,
                                               struct wl_resource* resource,
                                               guint32 output,
                                               struct wl_resource* surface_resource);
static void _greeter_compositor_get_extended_behavior_pantheon_desktop_get_extended_behavior (struct wl_client* client,
                                                                                       struct wl_resource* resource,
                                                                                       guint32 output,
                                                                                       struct wl_resource* surface);
VALA_EXTERN void greeter_compositor_destroy_panel_surface (struct wl_client* client,
                                               struct wl_resource* resource);
static void _greeter_compositor_destroy_panel_surface_pantheon_desktop_destroy (struct wl_client* client,
                                                                         struct wl_resource* resource);
VALA_EXTERN void greeter_compositor_set_anchor (struct wl_client* client,
                                    struct wl_resource* resource,
                                    uint32_t anchor);
static void _greeter_compositor_set_anchor_pantheon_desktop_set_anchor (struct wl_client* client,
                                                                 struct wl_resource* resource,
                                                                 uint32_t anchor);
VALA_EXTERN void greeter_compositor_focus_panel (struct wl_client* client,
                                     struct wl_resource* resource);
static void _greeter_compositor_focus_panel_pantheon_desktop_focus (struct wl_client* client,
                                                             struct wl_resource* resource);
VALA_EXTERN void greeter_compositor_set_size (struct wl_client* client,
                                  struct wl_resource* resource,
                                  gint width,
                                  gint height);
static void _greeter_compositor_set_size_pantheon_desktop_set_size (struct wl_client* client,
                                                             struct wl_resource* resource,
                                                             gint width,
                                                             gint height);
VALA_EXTERN void greeter_compositor_destroy_widget_surface (struct wl_client* client,
                                                struct wl_resource* resource);
static void _greeter_compositor_destroy_widget_surface_pantheon_desktop_destroy (struct wl_client* client,
                                                                          struct wl_resource* resource);
VALA_EXTERN void greeter_compositor_destroy_extended_behavior_surface (struct wl_client* client,
                                                           struct wl_resource* resource);
static void _greeter_compositor_destroy_extended_behavior_surface_pantheon_desktop_destroy (struct wl_client* client,
                                                                                     struct wl_resource* resource);
VALA_EXTERN void greeter_compositor_set_keep_above (struct wl_client* client,
                                        struct wl_resource* resource);
static void _greeter_compositor_set_keep_above_pantheon_desktop_set_keep_above (struct wl_client* client,
                                                                         struct wl_resource* resource);
VALA_EXTERN void greeter_compositor_make_centered (struct wl_client* client,
                                       struct wl_resource* resource);
static void _greeter_compositor_make_centered_pantheon_desktop_make_centered (struct wl_client* client,
                                                                       struct wl_resource* resource);
VALA_EXTERN void greeter_compositor_focus_extended_behavior (struct wl_client* client,
                                                 struct wl_resource* resource);
static void _greeter_compositor_focus_extended_behavior_pantheon_desktop_focus (struct wl_client* client,
                                                                         struct wl_resource* resource);
static void __lambda103_ (struct wl_client* client,
                   guint32 version,
                   guint32 id);
static void __lambda104_ (struct wl_resource* res);
static void ___lambda104__wl_resource_destroy_func_t (struct wl_resource* resource);
static void ___lambda103__wl_global_bind_func_t (struct wl_client* client,
                                          gpointer self,
                                          guint32 version,
                                          guint32 id);
VALA_EXTERN GType greeter_compositor_panel_surface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorPanelSurface, g_object_unref)
VALA_EXTERN GreeterCompositorPanelSurface* greeter_compositor_panel_surface_new (GObject* wayland_surface);
VALA_EXTERN GreeterCompositorPanelSurface* greeter_compositor_panel_surface_construct (GType object_type,
                                                                           GObject* wayland_surface);
VALA_EXTERN void greeter_compositor_panel_surface_on_wayland_surface_disposed (GreeterCompositorPanelSurface* self);
static void greeter_compositor_panel_surface_finalize (GObject * obj);
static GType greeter_compositor_panel_surface_get_type_once (void);
VALA_EXTERN GType greeter_compositor_widget_surface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWidgetSurface, g_object_unref)
VALA_EXTERN GreeterCompositorWidgetSurface* greeter_compositor_widget_surface_new (GObject* wayland_surface);
VALA_EXTERN GreeterCompositorWidgetSurface* greeter_compositor_widget_surface_construct (GType object_type,
                                                                             GObject* wayland_surface);
VALA_EXTERN void greeter_compositor_widget_surface_on_wayland_surface_disposed (GreeterCompositorWidgetSurface* self);
static void greeter_compositor_widget_surface_finalize (GObject * obj);
static GType greeter_compositor_widget_surface_get_type_once (void);
VALA_EXTERN GType greeter_compositor_extended_behavior_surface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorExtendedBehaviorSurface, g_object_unref)
VALA_EXTERN GreeterCompositorExtendedBehaviorSurface* greeter_compositor_extended_behavior_surface_new (GObject* wayland_surface);
VALA_EXTERN GreeterCompositorExtendedBehaviorSurface* greeter_compositor_extended_behavior_surface_construct (GType object_type,
                                                                                                  GObject* wayland_surface);
VALA_EXTERN void greeter_compositor_extended_behavior_surface_on_wayland_surface_disposed (GreeterCompositorExtendedBehaviorSurface* self);
static void greeter_compositor_extended_behavior_surface_finalize (GObject * obj);
static GType greeter_compositor_extended_behavior_surface_get_type_once (void);
VALA_EXTERN void greeter_compositor_unref_obj_on_destroy (struct wl_resource* resource);
static void _greeter_compositor_unref_obj_on_destroy_wl_resource_destroy_func_t (struct wl_resource* resource);
VALA_EXTERN GType greeter_compositor_shell_clients_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorShellClientsManager, g_object_unref)
VALA_EXTERN GreeterCompositorShellClientsManager* greeter_compositor_shell_clients_manager_get_instance (void);
VALA_EXTERN void greeter_compositor_shell_clients_manager_set_anchor (GreeterCompositorShellClientsManager* self,
                                                          MetaWindow* window,
                                                          MetaSide side);
VALA_EXTERN void greeter_compositor_focus (GObject* wayland_surface);
VALA_EXTERN void greeter_compositor_shell_clients_manager_set_size (GreeterCompositorShellClientsManager* self,
                                                        MetaWindow* window,
                                                        gint width,
                                                        gint height);
VALA_EXTERN void greeter_compositor_shell_clients_manager_make_centered (GreeterCompositorShellClientsManager* self,
                                                             MetaWindow* window);

inline struct wl_display*
greeter_compositor_get_display_from_context (MetaContext* context)
{
	MetaWaylandCompositor* compositor = NULL;
	MetaWaylandCompositor* _tmp0_;
	MetaWaylandCompositor* _tmp1_;
	MetaWaylandCompositor* _tmp2_;
	void* _tmp3_;
	struct wl_display* result;
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = meta_context_get_wayland_compositor (context);
	compositor = _tmp0_;
	_tmp1_ = compositor;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = compositor;
	_tmp3_ = meta_wayland_compositor_get_wayland_display (_tmp2_);
	result = (struct wl_display*) _tmp3_;
	return result;
}

static void
_greeter_compositor_get_panel_pantheon_desktop_get_panel (struct wl_client* client,
                                                          struct wl_resource* resource,
                                                          guint32 output,
                                                          struct wl_resource* surface)
{
	greeter_compositor_get_panel (client, resource, output, surface);
}

static void
_greeter_compositor_get_widget_pantheon_desktop_get_widget (struct wl_client* client,
                                                            struct wl_resource* resource,
                                                            guint32 output,
                                                            struct wl_resource* surface)
{
	greeter_compositor_get_widget (client, resource, output, surface);
}

static void
_greeter_compositor_get_extended_behavior_pantheon_desktop_get_extended_behavior (struct wl_client* client,
                                                                                  struct wl_resource* resource,
                                                                                  guint32 output,
                                                                                  struct wl_resource* surface)
{
	greeter_compositor_get_extended_behavior (client, resource, output, surface);
}

static void
_greeter_compositor_destroy_panel_surface_pantheon_desktop_destroy (struct wl_client* client,
                                                                    struct wl_resource* resource)
{
	greeter_compositor_destroy_panel_surface (client, resource);
}

static void
_greeter_compositor_set_anchor_pantheon_desktop_set_anchor (struct wl_client* client,
                                                            struct wl_resource* resource,
                                                            uint32_t anchor)
{
	greeter_compositor_set_anchor (client, resource, anchor);
}

static void
_greeter_compositor_focus_panel_pantheon_desktop_focus (struct wl_client* client,
                                                        struct wl_resource* resource)
{
	greeter_compositor_focus_panel (client, resource);
}

static void
_greeter_compositor_set_size_pantheon_desktop_set_size (struct wl_client* client,
                                                        struct wl_resource* resource,
                                                        gint width,
                                                        gint height)
{
	greeter_compositor_set_size (client, resource, width, height);
}

static void
_greeter_compositor_destroy_widget_surface_pantheon_desktop_destroy (struct wl_client* client,
                                                                     struct wl_resource* resource)
{
	greeter_compositor_destroy_widget_surface (client, resource);
}

static void
_greeter_compositor_destroy_extended_behavior_surface_pantheon_desktop_destroy (struct wl_client* client,
                                                                                struct wl_resource* resource)
{
	greeter_compositor_destroy_extended_behavior_surface (client, resource);
}

static void
_greeter_compositor_set_keep_above_pantheon_desktop_set_keep_above (struct wl_client* client,
                                                                    struct wl_resource* resource)
{
	greeter_compositor_set_keep_above (client, resource);
}

static void
_greeter_compositor_make_centered_pantheon_desktop_make_centered (struct wl_client* client,
                                                                  struct wl_resource* resource)
{
	greeter_compositor_make_centered (client, resource);
}

static void
_greeter_compositor_focus_extended_behavior_pantheon_desktop_focus (struct wl_client* client,
                                                                    struct wl_resource* resource)
{
	greeter_compositor_focus_extended_behavior (client, resource);
}

static void
__lambda104_ (struct wl_resource* res)
{
	g_return_if_fail (res != NULL);
}

static void
___lambda104__wl_resource_destroy_func_t (struct wl_resource* resource)
{
	__lambda104_ (resource);
}

static void
__lambda103_ (struct wl_client* client,
              guint32 version,
              guint32 id)
{
	struct wl_resource* resource = NULL;
	struct wl_resource* _tmp0_;
	g_return_if_fail (client != NULL);
	_tmp0_ = wl_resource_create (client, &io_elementary_pantheon_shell_v1_interface, (gint) version, id);
	resource = _tmp0_;
	wl_resource_set_implementation (resource, &greeter_compositor_wayland_pantheon_shell_interface, NULL, ___lambda104__wl_resource_destroy_func_t);
}

static void
___lambda103__wl_global_bind_func_t (struct wl_client* client,
                                     gpointer self,
                                     guint32 version,
                                     guint32 id)
{
	__lambda103_ (client, version, id);
}

void
greeter_compositor_init_pantheon_shell (MetaContext* context)
{
	struct wl_display* wl_disp = NULL;
	struct wl_display* _tmp0_;
	struct wl_display* _tmp1_;
	struct io_elementary_pantheon_shell_v1_interface _tmp2_ = {0};
	struct io_elementary_pantheon_panel_v1_interface _tmp3_ = {0};
	struct io_elementary_pantheon_widget_v1_interface _tmp4_ = {0};
	struct io_elementary_pantheon_extended_behavior_v1_interface _tmp5_ = {0};
	struct wl_display* _tmp6_;
	struct wl_global* _tmp7_;
	g_return_if_fail (context != NULL);
	_tmp0_ = greeter_compositor_get_display_from_context (context);
	wl_disp = _tmp0_;
	_tmp1_ = wl_disp;
	if (_tmp1_ == NULL) {
		g_debug ("PantheonShell.vala:45: Not running under Wayland, no Pantheon Shell pr" \
"otocol");
		return;
	}
	_tmp2_.get_panel = _greeter_compositor_get_panel_pantheon_desktop_get_panel;
	_tmp2_.get_widget = _greeter_compositor_get_widget_pantheon_desktop_get_widget;
	_tmp2_.get_extended_behavior = _greeter_compositor_get_extended_behavior_pantheon_desktop_get_extended_behavior;
	greeter_compositor_wayland_pantheon_shell_interface = _tmp2_;
	_tmp3_.destroy = _greeter_compositor_destroy_panel_surface_pantheon_desktop_destroy;
	_tmp3_.set_anchor = _greeter_compositor_set_anchor_pantheon_desktop_set_anchor;
	_tmp3_.focus = _greeter_compositor_focus_panel_pantheon_desktop_focus;
	_tmp3_.set_size = _greeter_compositor_set_size_pantheon_desktop_set_size;
	greeter_compositor_wayland_pantheon_panel_interface = _tmp3_;
	_tmp4_.destroy = _greeter_compositor_destroy_widget_surface_pantheon_desktop_destroy;
	greeter_compositor_wayland_pantheon_widget_interface = _tmp4_;
	_tmp5_.destroy = _greeter_compositor_destroy_extended_behavior_surface_pantheon_desktop_destroy;
	_tmp5_.set_keep_above = _greeter_compositor_set_keep_above_pantheon_desktop_set_keep_above;
	_tmp5_.make_centered = _greeter_compositor_make_centered_pantheon_desktop_make_centered;
	_tmp5_.focus = _greeter_compositor_focus_extended_behavior_pantheon_desktop_focus;
	greeter_compositor_wayland_pantheon_extended_behavior_interface = _tmp5_;
	greeter_compositor_panel_surface_quark = g_quark_from_string ("-gala-wayland-panel-surface-data");
	greeter_compositor_widget_surface_quark = g_quark_from_string ("-gala-wayland-widget-surface-data");
	greeter_compositor_extended_behavior_surface_quark = g_quark_from_string ("-gala-wayland-extended-behavior-surface-data");
	_tmp6_ = wl_disp;
	_tmp7_ = wl_global_create (_tmp6_, &io_elementary_pantheon_shell_v1_interface, 1, NULL, ___lambda103__wl_global_bind_func_t);
	_wl_global_destroy0 (greeter_compositor_shell_global);
	greeter_compositor_shell_global = _tmp7_;
}

GreeterCompositorPanelSurface*
greeter_compositor_panel_surface_construct (GType object_type,
                                            GObject* wayland_surface)
{
	GreeterCompositorPanelSurface * self = NULL;
	g_return_val_if_fail (wayland_surface != NULL, NULL);
	self = (GreeterCompositorPanelSurface*) g_object_new (object_type, NULL);
	self->wayland_surface = wayland_surface;
	return self;
}

GreeterCompositorPanelSurface*
greeter_compositor_panel_surface_new (GObject* wayland_surface)
{
	return greeter_compositor_panel_surface_construct (GREETER_COMPOSITOR_TYPE_PANEL_SURFACE, wayland_surface);
}

void
greeter_compositor_panel_surface_on_wayland_surface_disposed (GreeterCompositorPanelSurface* self)
{
	g_return_if_fail (self != NULL);
	self->wayland_surface = NULL;
}

static void
greeter_compositor_panel_surface_class_init (GreeterCompositorPanelSurfaceClass * klass,
                                             gpointer klass_data)
{
	greeter_compositor_panel_surface_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_panel_surface_finalize;
}

static void
greeter_compositor_panel_surface_instance_init (GreeterCompositorPanelSurface * self,
                                                gpointer klass)
{
}

static void
greeter_compositor_panel_surface_finalize (GObject * obj)
{
	GreeterCompositorPanelSurface * self;
	GObject* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_PANEL_SURFACE, GreeterCompositorPanelSurface);
	_tmp0_ = self->wayland_surface;
	if (_tmp0_ != NULL) {
		GObject* _tmp1_;
		_tmp1_ = self->wayland_surface;
		g_object_steal_qdata (_tmp1_, greeter_compositor_panel_surface_quark);
	}
	G_OBJECT_CLASS (greeter_compositor_panel_surface_parent_class)->finalize (obj);
}

static GType
greeter_compositor_panel_surface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorPanelSurfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_panel_surface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorPanelSurface), 0, (GInstanceInitFunc) greeter_compositor_panel_surface_instance_init, NULL };
	GType greeter_compositor_panel_surface_type_id;
	greeter_compositor_panel_surface_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorPanelSurface", &g_define_type_info, 0);
	return greeter_compositor_panel_surface_type_id;
}

GType
greeter_compositor_panel_surface_get_type (void)
{
	static volatile gsize greeter_compositor_panel_surface_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_panel_surface_type_id__once)) {
		GType greeter_compositor_panel_surface_type_id;
		greeter_compositor_panel_surface_type_id = greeter_compositor_panel_surface_get_type_once ();
		g_once_init_leave (&greeter_compositor_panel_surface_type_id__once, greeter_compositor_panel_surface_type_id);
	}
	return greeter_compositor_panel_surface_type_id__once;
}

GreeterCompositorWidgetSurface*
greeter_compositor_widget_surface_construct (GType object_type,
                                             GObject* wayland_surface)
{
	GreeterCompositorWidgetSurface * self = NULL;
	g_return_val_if_fail (wayland_surface != NULL, NULL);
	self = (GreeterCompositorWidgetSurface*) g_object_new (object_type, NULL);
	self->wayland_surface = wayland_surface;
	return self;
}

GreeterCompositorWidgetSurface*
greeter_compositor_widget_surface_new (GObject* wayland_surface)
{
	return greeter_compositor_widget_surface_construct (GREETER_COMPOSITOR_TYPE_WIDGET_SURFACE, wayland_surface);
}

void
greeter_compositor_widget_surface_on_wayland_surface_disposed (GreeterCompositorWidgetSurface* self)
{
	g_return_if_fail (self != NULL);
	self->wayland_surface = NULL;
}

static void
greeter_compositor_widget_surface_class_init (GreeterCompositorWidgetSurfaceClass * klass,
                                              gpointer klass_data)
{
	greeter_compositor_widget_surface_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_widget_surface_finalize;
}

static void
greeter_compositor_widget_surface_instance_init (GreeterCompositorWidgetSurface * self,
                                                 gpointer klass)
{
}

static void
greeter_compositor_widget_surface_finalize (GObject * obj)
{
	GreeterCompositorWidgetSurface * self;
	GObject* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_WIDGET_SURFACE, GreeterCompositorWidgetSurface);
	_tmp0_ = self->wayland_surface;
	if (_tmp0_ != NULL) {
		GObject* _tmp1_;
		_tmp1_ = self->wayland_surface;
		g_object_steal_qdata (_tmp1_, greeter_compositor_widget_surface_quark);
	}
	G_OBJECT_CLASS (greeter_compositor_widget_surface_parent_class)->finalize (obj);
}

static GType
greeter_compositor_widget_surface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorWidgetSurfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_widget_surface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorWidgetSurface), 0, (GInstanceInitFunc) greeter_compositor_widget_surface_instance_init, NULL };
	GType greeter_compositor_widget_surface_type_id;
	greeter_compositor_widget_surface_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorWidgetSurface", &g_define_type_info, 0);
	return greeter_compositor_widget_surface_type_id;
}

GType
greeter_compositor_widget_surface_get_type (void)
{
	static volatile gsize greeter_compositor_widget_surface_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_widget_surface_type_id__once)) {
		GType greeter_compositor_widget_surface_type_id;
		greeter_compositor_widget_surface_type_id = greeter_compositor_widget_surface_get_type_once ();
		g_once_init_leave (&greeter_compositor_widget_surface_type_id__once, greeter_compositor_widget_surface_type_id);
	}
	return greeter_compositor_widget_surface_type_id__once;
}

GreeterCompositorExtendedBehaviorSurface*
greeter_compositor_extended_behavior_surface_construct (GType object_type,
                                                        GObject* wayland_surface)
{
	GreeterCompositorExtendedBehaviorSurface * self = NULL;
	g_return_val_if_fail (wayland_surface != NULL, NULL);
	self = (GreeterCompositorExtendedBehaviorSurface*) g_object_new (object_type, NULL);
	self->wayland_surface = wayland_surface;
	return self;
}

GreeterCompositorExtendedBehaviorSurface*
greeter_compositor_extended_behavior_surface_new (GObject* wayland_surface)
{
	return greeter_compositor_extended_behavior_surface_construct (GREETER_COMPOSITOR_TYPE_EXTENDED_BEHAVIOR_SURFACE, wayland_surface);
}

void
greeter_compositor_extended_behavior_surface_on_wayland_surface_disposed (GreeterCompositorExtendedBehaviorSurface* self)
{
	g_return_if_fail (self != NULL);
	self->wayland_surface = NULL;
}

static void
greeter_compositor_extended_behavior_surface_class_init (GreeterCompositorExtendedBehaviorSurfaceClass * klass,
                                                         gpointer klass_data)
{
	greeter_compositor_extended_behavior_surface_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_extended_behavior_surface_finalize;
}

static void
greeter_compositor_extended_behavior_surface_instance_init (GreeterCompositorExtendedBehaviorSurface * self,
                                                            gpointer klass)
{
}

static void
greeter_compositor_extended_behavior_surface_finalize (GObject * obj)
{
	GreeterCompositorExtendedBehaviorSurface * self;
	GObject* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_EXTENDED_BEHAVIOR_SURFACE, GreeterCompositorExtendedBehaviorSurface);
	_tmp0_ = self->wayland_surface;
	if (_tmp0_ != NULL) {
		GObject* _tmp1_;
		_tmp1_ = self->wayland_surface;
		g_object_steal_qdata (_tmp1_, greeter_compositor_extended_behavior_surface_quark);
	}
	G_OBJECT_CLASS (greeter_compositor_extended_behavior_surface_parent_class)->finalize (obj);
}

static GType
greeter_compositor_extended_behavior_surface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorExtendedBehaviorSurfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_extended_behavior_surface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorExtendedBehaviorSurface), 0, (GInstanceInitFunc) greeter_compositor_extended_behavior_surface_instance_init, NULL };
	GType greeter_compositor_extended_behavior_surface_type_id;
	greeter_compositor_extended_behavior_surface_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorExtendedBehaviorSurface", &g_define_type_info, 0);
	return greeter_compositor_extended_behavior_surface_type_id;
}

GType
greeter_compositor_extended_behavior_surface_get_type (void)
{
	static volatile gsize greeter_compositor_extended_behavior_surface_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_extended_behavior_surface_type_id__once)) {
		GType greeter_compositor_extended_behavior_surface_type_id;
		greeter_compositor_extended_behavior_surface_type_id = greeter_compositor_extended_behavior_surface_get_type_once ();
		g_once_init_leave (&greeter_compositor_extended_behavior_surface_type_id__once, greeter_compositor_extended_behavior_surface_type_id);
	}
	return greeter_compositor_extended_behavior_surface_type_id__once;
}

void
greeter_compositor_unref_obj_on_destroy (struct wl_resource* resource)
{
	gconstpointer _tmp0_;
	g_return_if_fail (resource != NULL);
	_tmp0_ = wl_resource_get_user_data (resource);
	g_object_unref ((GObject*) _tmp0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_greeter_compositor_unref_obj_on_destroy_wl_resource_destroy_func_t (struct wl_resource* resource)
{
	greeter_compositor_unref_obj_on_destroy (resource);
}

void
greeter_compositor_get_panel (struct wl_client* client,
                              struct wl_resource* resource,
                              guint32 output,
                              struct wl_resource* surface_resource)
{
	GObject* wayland_surface = NULL;
	gconstpointer _tmp0_;
	GreeterCompositorPanelSurface* panel_surface = NULL;
	GObject* _tmp1_;
	gconstpointer _tmp2_;
	GreeterCompositorPanelSurface* _tmp3_;
	GreeterCompositorPanelSurface* _tmp4_;
	GObject* _tmp5_;
	GreeterCompositorPanelSurface* _tmp6_;
	struct wl_resource* panel_resource = NULL;
	struct wl_resource* _tmp7_;
	struct wl_resource* _tmp8_;
	GreeterCompositorPanelSurface* _tmp9_;
	GObject* _tmp10_;
	GObject* _tmp11_;
	GreeterCompositorPanelSurface* _tmp12_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	g_return_if_fail (surface_resource != NULL);
	_tmp0_ = wl_resource_get_user_data (surface_resource);
	wayland_surface = (GObject*) _tmp0_;
	_tmp1_ = wayland_surface;
	_tmp2_ = g_object_get_qdata (_tmp1_, greeter_compositor_panel_surface_quark);
	_tmp3_ = _g_object_ref0 ((GreeterCompositorPanelSurface*) _tmp2_);
	panel_surface = _tmp3_;
	_tmp4_ = panel_surface;
	if (_tmp4_ != NULL) {
		wl_resource_post_error (surface_resource, (guint32) WL_DISPLAY_ERROR_INVALID_OBJECT, "io_elementary_pantheon_shell_v1_interface::get_panel already requested");
		_g_object_unref0 (panel_surface);
		return;
	}
	_tmp5_ = wayland_surface;
	_tmp6_ = greeter_compositor_panel_surface_new (_tmp5_);
	_g_object_unref0 (panel_surface);
	panel_surface = _tmp6_;
	_tmp7_ = wl_resource_create (client, &io_elementary_pantheon_panel_v1_interface, wl_resource_get_version (resource), output);
	panel_resource = _tmp7_;
	_tmp8_ = panel_resource;
	_tmp9_ = panel_surface;
	_tmp10_ = g_object_ref ((GObject*) _tmp9_);
	wl_resource_set_implementation (_tmp8_, &greeter_compositor_wayland_pantheon_panel_interface, _tmp10_, _greeter_compositor_unref_obj_on_destroy_wl_resource_destroy_func_t);
	_tmp11_ = wayland_surface;
	_tmp12_ = panel_surface;
	g_object_set_qdata_full (_tmp11_, greeter_compositor_panel_surface_quark, _tmp12_, (GDestroyNotify) greeter_compositor_panel_surface_on_wayland_surface_disposed);
	_g_object_unref0 (panel_surface);
}

void
greeter_compositor_get_widget (struct wl_client* client,
                               struct wl_resource* resource,
                               guint32 output,
                               struct wl_resource* surface_resource)
{
	GObject* wayland_surface = NULL;
	gconstpointer _tmp0_;
	GreeterCompositorWidgetSurface* widget_surface = NULL;
	GObject* _tmp1_;
	gconstpointer _tmp2_;
	GreeterCompositorWidgetSurface* _tmp3_;
	GreeterCompositorWidgetSurface* _tmp4_;
	GObject* _tmp5_;
	GreeterCompositorWidgetSurface* _tmp6_;
	struct wl_resource* widget_resource = NULL;
	struct wl_resource* _tmp7_;
	struct wl_resource* _tmp8_;
	GreeterCompositorWidgetSurface* _tmp9_;
	GObject* _tmp10_;
	GObject* _tmp11_;
	GreeterCompositorWidgetSurface* _tmp12_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	g_return_if_fail (surface_resource != NULL);
	_tmp0_ = wl_resource_get_user_data (surface_resource);
	wayland_surface = (GObject*) _tmp0_;
	_tmp1_ = wayland_surface;
	_tmp2_ = g_object_get_qdata (_tmp1_, greeter_compositor_widget_surface_quark);
	_tmp3_ = _g_object_ref0 ((GreeterCompositorWidgetSurface*) _tmp2_);
	widget_surface = _tmp3_;
	_tmp4_ = widget_surface;
	if (_tmp4_ != NULL) {
		wl_resource_post_error (surface_resource, (guint32) WL_DISPLAY_ERROR_INVALID_OBJECT, "io_elementary_pantheon_shell_v1_interface::get_widget already requeste" \
"d");
		_g_object_unref0 (widget_surface);
		return;
	}
	_tmp5_ = wayland_surface;
	_tmp6_ = greeter_compositor_widget_surface_new (_tmp5_);
	_g_object_unref0 (widget_surface);
	widget_surface = _tmp6_;
	_tmp7_ = wl_resource_create (client, &io_elementary_pantheon_widget_v1_interface, wl_resource_get_version (resource), output);
	widget_resource = _tmp7_;
	_tmp8_ = widget_resource;
	_tmp9_ = widget_surface;
	_tmp10_ = g_object_ref ((GObject*) _tmp9_);
	wl_resource_set_implementation (_tmp8_, &greeter_compositor_wayland_pantheon_widget_interface, _tmp10_, _greeter_compositor_unref_obj_on_destroy_wl_resource_destroy_func_t);
	_tmp11_ = wayland_surface;
	_tmp12_ = widget_surface;
	g_object_set_qdata_full (_tmp11_, greeter_compositor_widget_surface_quark, _tmp12_, (GDestroyNotify) greeter_compositor_widget_surface_on_wayland_surface_disposed);
	_g_object_unref0 (widget_surface);
}

void
greeter_compositor_get_extended_behavior (struct wl_client* client,
                                          struct wl_resource* resource,
                                          guint32 output,
                                          struct wl_resource* surface_resource)
{
	GObject* wayland_surface = NULL;
	gconstpointer _tmp0_;
	GreeterCompositorExtendedBehaviorSurface* eb_surface = NULL;
	GObject* _tmp1_;
	gconstpointer _tmp2_;
	GreeterCompositorExtendedBehaviorSurface* _tmp3_;
	GreeterCompositorExtendedBehaviorSurface* _tmp4_;
	GObject* _tmp5_;
	GreeterCompositorExtendedBehaviorSurface* _tmp6_;
	struct wl_resource* eb_resource = NULL;
	struct wl_resource* _tmp7_;
	struct wl_resource* _tmp8_;
	GreeterCompositorExtendedBehaviorSurface* _tmp9_;
	GObject* _tmp10_;
	GObject* _tmp11_;
	GreeterCompositorExtendedBehaviorSurface* _tmp12_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	g_return_if_fail (surface_resource != NULL);
	_tmp0_ = wl_resource_get_user_data (surface_resource);
	wayland_surface = (GObject*) _tmp0_;
	_tmp1_ = wayland_surface;
	_tmp2_ = g_object_get_qdata (_tmp1_, greeter_compositor_extended_behavior_surface_quark);
	_tmp3_ = _g_object_ref0 ((GreeterCompositorExtendedBehaviorSurface*) _tmp2_);
	eb_surface = _tmp3_;
	_tmp4_ = eb_surface;
	if (_tmp4_ != NULL) {
		wl_resource_post_error (surface_resource, (guint32) WL_DISPLAY_ERROR_INVALID_OBJECT, "io_elementary_pantheon_shell_v1_interface::get_extended_behavior alrea" \
"dy requested");
		_g_object_unref0 (eb_surface);
		return;
	}
	_tmp5_ = wayland_surface;
	_tmp6_ = greeter_compositor_extended_behavior_surface_new (_tmp5_);
	_g_object_unref0 (eb_surface);
	eb_surface = _tmp6_;
	_tmp7_ = wl_resource_create (client, &io_elementary_pantheon_extended_behavior_v1_interface, wl_resource_get_version (resource), output);
	eb_resource = _tmp7_;
	_tmp8_ = eb_resource;
	_tmp9_ = eb_surface;
	_tmp10_ = g_object_ref ((GObject*) _tmp9_);
	wl_resource_set_implementation (_tmp8_, &greeter_compositor_wayland_pantheon_extended_behavior_interface, _tmp10_, _greeter_compositor_unref_obj_on_destroy_wl_resource_destroy_func_t);
	_tmp11_ = wayland_surface;
	_tmp12_ = eb_surface;
	g_object_set_qdata_full (_tmp11_, greeter_compositor_extended_behavior_surface_quark, _tmp12_, (GDestroyNotify) greeter_compositor_extended_behavior_surface_on_wayland_surface_disposed);
	_g_object_unref0 (eb_surface);
}

void
greeter_compositor_set_anchor (struct wl_client* client,
                               struct wl_resource* resource,
                               uint32_t anchor)
{
	GreeterCompositorPanelSurface* panel_surface = NULL;
	gconstpointer _tmp0_;
	GreeterCompositorPanelSurface* _tmp1_;
	GObject* _tmp2_;
	MetaWindow* window = NULL;
	GreeterCompositorPanelSurface* _tmp3_;
	GObject* _tmp4_;
	MetaWindow* _tmp5_ = NULL;
	MetaWindow* _tmp6_;
	MetaSide side = 0;
	GreeterCompositorShellClientsManager* _tmp7_;
	GreeterCompositorShellClientsManager* _tmp8_;
	MetaWindow* _tmp9_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = wl_resource_get_user_data (resource);
	panel_surface = (GreeterCompositorPanelSurface*) _tmp0_;
	_tmp1_ = panel_surface;
	_tmp2_ = _tmp1_->wayland_surface;
	if (_tmp2_ == NULL) {
		g_warning ("PantheonShell.vala:234: Window tried to set anchor but wayland surface" \
" is null.");
		return;
	}
	_tmp3_ = panel_surface;
	_tmp4_ = _tmp3_->wayland_surface;
	g_object_get (_tmp4_, "window", &_tmp5_, NULL, NULL);
	_g_object_unref0 (window);
	window = _tmp5_;
	_tmp6_ = window;
	if (_tmp6_ == NULL) {
		g_warning ("PantheonShell.vala:241: Window tried to set anchor but wayland surface" \
" had no associated window.");
		_g_object_unref0 (window);
		return;
	}
	side = META_SIDE_TOP;
	switch (anchor) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP:
		{
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		{
			side = META_SIDE_BOTTOM;
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT:
		{
			side = META_SIDE_LEFT;
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT:
		{
			side = META_SIDE_RIGHT;
			break;
		}
		default:
		break;
	}
	_tmp7_ = greeter_compositor_shell_clients_manager_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = window;
	greeter_compositor_shell_clients_manager_set_anchor (_tmp8_, _tmp9_, side);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (window);
}

void
greeter_compositor_focus_panel (struct wl_client* client,
                                struct wl_resource* resource)
{
	GreeterCompositorPanelSurface* panel_surface = NULL;
	gconstpointer _tmp0_;
	GreeterCompositorPanelSurface* _tmp1_;
	GObject* _tmp2_;
	GreeterCompositorPanelSurface* _tmp3_;
	GObject* _tmp4_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = wl_resource_get_user_data (resource);
	panel_surface = (GreeterCompositorPanelSurface*) _tmp0_;
	_tmp1_ = panel_surface;
	_tmp2_ = _tmp1_->wayland_surface;
	if (_tmp2_ == NULL) {
		g_warning ("PantheonShell.vala:269: Window tried to focus but wayland surface is n" \
"ull.");
		return;
	}
	_tmp3_ = panel_surface;
	_tmp4_ = _tmp3_->wayland_surface;
	greeter_compositor_focus (_tmp4_);
}

void
greeter_compositor_focus_extended_behavior (struct wl_client* client,
                                            struct wl_resource* resource)
{
	GreeterCompositorExtendedBehaviorSurface* extended_behavior_surface = NULL;
	gconstpointer _tmp0_;
	GreeterCompositorExtendedBehaviorSurface* _tmp1_;
	GObject* _tmp2_;
	GreeterCompositorExtendedBehaviorSurface* _tmp3_;
	GObject* _tmp4_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = wl_resource_get_user_data (resource);
	extended_behavior_surface = (GreeterCompositorExtendedBehaviorSurface*) _tmp0_;
	_tmp1_ = extended_behavior_surface;
	_tmp2_ = _tmp1_->wayland_surface;
	if (_tmp2_ == NULL) {
		g_warning ("PantheonShell.vala:279: Window tried to focus but wayland surface is n" \
"ull.");
		return;
	}
	_tmp3_ = extended_behavior_surface;
	_tmp4_ = _tmp3_->wayland_surface;
	greeter_compositor_focus (_tmp4_);
}

void
greeter_compositor_focus (GObject* wayland_surface)
{
	MetaWindow* window = NULL;
	MetaWindow* _tmp0_ = NULL;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaDisplay* _tmp4_;
	g_return_if_fail (wayland_surface != NULL);
	g_object_get (wayland_surface, "window", &_tmp0_, NULL, NULL);
	_g_object_unref0 (window);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ == NULL) {
		g_warning ("PantheonShell.vala:290: Window tried to focus but wayland surface had " \
"no associated window.");
		_g_object_unref0 (window);
		return;
	}
	_tmp2_ = window;
	_tmp3_ = window;
	_tmp4_ = meta_window_get_display (_tmp3_);
	meta_window_focus (_tmp2_, meta_display_get_current_time (_tmp4_));
	_g_object_unref0 (window);
}

void
greeter_compositor_set_size (struct wl_client* client,
                             struct wl_resource* resource,
                             gint width,
                             gint height)
{
	GreeterCompositorPanelSurface* panel_surface = NULL;
	gconstpointer _tmp0_;
	GreeterCompositorPanelSurface* _tmp1_;
	GObject* _tmp2_;
	MetaWindow* window = NULL;
	GreeterCompositorPanelSurface* _tmp3_;
	GObject* _tmp4_;
	MetaWindow* _tmp5_ = NULL;
	MetaWindow* _tmp6_;
	GreeterCompositorShellClientsManager* _tmp7_;
	GreeterCompositorShellClientsManager* _tmp8_;
	MetaWindow* _tmp9_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = wl_resource_get_user_data (resource);
	panel_surface = (GreeterCompositorPanelSurface*) _tmp0_;
	_tmp1_ = panel_surface;
	_tmp2_ = _tmp1_->wayland_surface;
	if (_tmp2_ == NULL) {
		g_warning ("PantheonShell.vala:300: Window tried to set size but wayland surface i" \
"s null.");
		return;
	}
	_tmp3_ = panel_surface;
	_tmp4_ = _tmp3_->wayland_surface;
	g_object_get (_tmp4_, "window", &_tmp5_, NULL, NULL);
	_g_object_unref0 (window);
	window = _tmp5_;
	_tmp6_ = window;
	if (_tmp6_ == NULL) {
		g_warning ("PantheonShell.vala:307: Window tried to set size but wayland surface h" \
"ad no associated window.");
		_g_object_unref0 (window);
		return;
	}
	_tmp7_ = greeter_compositor_shell_clients_manager_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = window;
	greeter_compositor_shell_clients_manager_set_size (_tmp8_, _tmp9_, width, height);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (window);
}

void
greeter_compositor_set_keep_above (struct wl_client* client,
                                   struct wl_resource* resource)
{
	GreeterCompositorExtendedBehaviorSurface* eb_surface = NULL;
	gconstpointer _tmp0_;
	GreeterCompositorExtendedBehaviorSurface* _tmp1_;
	GObject* _tmp2_;
	MetaWindow* window = NULL;
	GreeterCompositorExtendedBehaviorSurface* _tmp3_;
	GObject* _tmp4_;
	MetaWindow* _tmp5_ = NULL;
	MetaWindow* _tmp6_;
	MetaWindow* _tmp7_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = wl_resource_get_user_data (resource);
	eb_surface = (GreeterCompositorExtendedBehaviorSurface*) _tmp0_;
	_tmp1_ = eb_surface;
	_tmp2_ = _tmp1_->wayland_surface;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = eb_surface;
	_tmp4_ = _tmp3_->wayland_surface;
	g_object_get (_tmp4_, "window", &_tmp5_, NULL, NULL);
	_g_object_unref0 (window);
	window = _tmp5_;
	_tmp6_ = window;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (window);
		return;
	}
	_tmp7_ = window;
	meta_window_make_above (_tmp7_);
	_g_object_unref0 (window);
}

void
greeter_compositor_make_centered (struct wl_client* client,
                                  struct wl_resource* resource)
{
	GreeterCompositorExtendedBehaviorSurface* eb_surface = NULL;
	gconstpointer _tmp0_;
	GreeterCompositorExtendedBehaviorSurface* _tmp1_;
	GObject* _tmp2_;
	MetaWindow* window = NULL;
	GreeterCompositorExtendedBehaviorSurface* _tmp3_;
	GObject* _tmp4_;
	MetaWindow* _tmp5_ = NULL;
	MetaWindow* _tmp6_;
	GreeterCompositorShellClientsManager* _tmp7_;
	GreeterCompositorShellClientsManager* _tmp8_;
	MetaWindow* _tmp9_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = wl_resource_get_user_data (resource);
	eb_surface = (GreeterCompositorExtendedBehaviorSurface*) _tmp0_;
	_tmp1_ = eb_surface;
	_tmp2_ = _tmp1_->wayland_surface;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = eb_surface;
	_tmp4_ = _tmp3_->wayland_surface;
	g_object_get (_tmp4_, "window", &_tmp5_, NULL, NULL);
	_g_object_unref0 (window);
	window = _tmp5_;
	_tmp6_ = window;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (window);
		return;
	}
	_tmp7_ = greeter_compositor_shell_clients_manager_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = window;
	greeter_compositor_shell_clients_manager_make_centered (_tmp8_, _tmp9_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (window);
}

void
greeter_compositor_destroy_panel_surface (struct wl_client* client,
                                          struct wl_resource* resource)
{
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	wl_resource_destroy (resource);
}

void
greeter_compositor_destroy_widget_surface (struct wl_client* client,
                                           struct wl_resource* resource)
{
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	wl_resource_destroy (resource);
}

void
greeter_compositor_destroy_extended_behavior_surface (struct wl_client* client,
                                                      struct wl_resource* resource)
{
	g_return_if_fail (client != NULL);
	g_return_if_fail (resource != NULL);
	wl_resource_destroy (resource);
}

