
#include <com/sun/star/xml/sax/FastParser.hpp>
#include <com/sun/star/lang/XInitialization.hpp>
#include "ooxml/OOXMLFactory.hxx"
#include "ooxml/OOXMLFastHelper.hxx"
#include "ooxml/OOXMLStreamImpl.hxx"

#include "OOXMLFactory_dml-stylesheet.hxx"
#include "OOXMLFactory_dml-styleDefaults.hxx"
#include "OOXMLFactory_dml-shape3DLighting.hxx"
#include "OOXMLFactory_dml-shape3DScene.hxx"
#include "OOXMLFactory_dml-shape3DStyles.hxx"
#include "OOXMLFactory_dml-shape3DCamera.hxx"
#include "OOXMLFactory_dml-baseStylesheet.hxx"
#include "OOXMLFactory_dml-textCharacter.hxx"
#include "OOXMLFactory_dml-shapeEffects.hxx"
#include "OOXMLFactory_dml-shapeLineProperties.hxx"
#include "OOXMLFactory_dml-shapeProperties.hxx"
#include "OOXMLFactory_dml-baseTypes.hxx"
#include "OOXMLFactory_dml-documentProperties.hxx"
#include "OOXMLFactory_dml-graphicalObject.hxx"
#include "OOXMLFactory_wp14.hxx"
#include "OOXMLFactory_w14.hxx"
#include "OOXMLFactory_w15.hxx"
#include "OOXMLFactory_a14.hxx"
#include "OOXMLFactory_dml-shapeGeometry.hxx"
#include "OOXMLFactory_dml-wordprocessingDrawing.hxx"
#include "OOXMLFactory_sml-customXmlMappings.hxx"
#include "OOXMLFactory_shared-math.hxx"
#include "OOXMLFactory_shared-relationshipReference.hxx"
#include "OOXMLFactory_dml-chartDrawing.hxx"
#include "OOXMLFactory_vml-main.hxx"
#include "OOXMLFactory_vml-officeDrawing.hxx"
#include "OOXMLFactory_vml-wordprocessingDrawing.hxx"
#include "OOXMLFactory_wml.hxx"
namespace writerfilter {
namespace ooxml {

using namespace com::sun::star;

/// @cond GENERATED

uno::Reference<xml::sax::XFastContextHandler> OOXMLFactory::createFastChildContextFromFactory
(OOXMLFastContextHandler* pHandler, const OOXMLFactory_ns::Pointer_t& pFactory, Token_t Element)
{
    uno::Reference <xml::sax::XFastContextHandler> aResult;
    const Id nDefine = pHandler->getDefine();

    if (pFactory.get() != NULL)
    {
        ResourceType nResource;
        Id nElementId;
        if (pFactory->getElementId(nDefine, Element, nResource, nElementId))
        {
            const Id nId = pFactory->getResourceId(nDefine, Element);

            switch (nResource)
            {
            case ResourceType::Theme:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerTheme>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::Properties:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerProperties>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::Stream:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerStream>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::Value:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerValue>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::CommentEx:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerCommentEx>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::Shape:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerShape>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::XNote:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerXNote>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::TextTableCell:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerTextTableCell>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::TextTableRow:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerTextTableRow>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::TextTable:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerTextTable>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::PropertyTable:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerPropertyTable>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::Table:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerTable>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::Math:
                aResult.set(OOXMLFastHelper<OOXMLFastContextHandlerMath>::createAndSetParentAndDefine(pHandler, Element, nId, nElementId));
                break;
            case ResourceType::Any:
                aResult.set(createFastChildContextFromStart(pHandler, Element));
                break;
            default:
                break;
            }

        }
    }

    return aResult;
}

OOXMLFactory_ns::Pointer_t OOXMLFactory::getFactoryForNamespace(Id nId)
{
    OOXMLFactory_ns::Pointer_t pResult;

    switch (oox::getNamespace(nId))
    {
    case NN_dml_stylesheet:
        pResult = OOXMLFactory_dml_stylesheet::getInstance();
        break;
    case NN_dml_styleDefaults:
        pResult = OOXMLFactory_dml_styleDefaults::getInstance();
        break;
    case NN_dml_shape3DLighting:
        pResult = OOXMLFactory_dml_shape3DLighting::getInstance();
        break;
    case NN_dml_shape3DScene:
        pResult = OOXMLFactory_dml_shape3DScene::getInstance();
        break;
    case NN_dml_shape3DStyles:
        pResult = OOXMLFactory_dml_shape3DStyles::getInstance();
        break;
    case NN_dml_shape3DCamera:
        pResult = OOXMLFactory_dml_shape3DCamera::getInstance();
        break;
    case NN_dml_baseStylesheet:
        pResult = OOXMLFactory_dml_baseStylesheet::getInstance();
        break;
    case NN_dml_textCharacter:
        pResult = OOXMLFactory_dml_textCharacter::getInstance();
        break;
    case NN_dml_shapeEffects:
        pResult = OOXMLFactory_dml_shapeEffects::getInstance();
        break;
    case NN_dml_shapeLineProperties:
        pResult = OOXMLFactory_dml_shapeLineProperties::getInstance();
        break;
    case NN_dml_shapeProperties:
        pResult = OOXMLFactory_dml_shapeProperties::getInstance();
        break;
    case NN_dml_baseTypes:
        pResult = OOXMLFactory_dml_baseTypes::getInstance();
        break;
    case NN_dml_documentProperties:
        pResult = OOXMLFactory_dml_documentProperties::getInstance();
        break;
    case NN_dml_graphicalObject:
        pResult = OOXMLFactory_dml_graphicalObject::getInstance();
        break;
    case NN_wp14:
        pResult = OOXMLFactory_wp14::getInstance();
        break;
    case NN_w14:
        pResult = OOXMLFactory_w14::getInstance();
        break;
    case NN_w15:
        pResult = OOXMLFactory_w15::getInstance();
        break;
    case NN_a14:
        pResult = OOXMLFactory_a14::getInstance();
        break;
    case NN_dml_shapeGeometry:
        pResult = OOXMLFactory_dml_shapeGeometry::getInstance();
        break;
    case NN_dml_wordprocessingDrawing:
        pResult = OOXMLFactory_dml_wordprocessingDrawing::getInstance();
        break;
    case NN_sml_customXmlMappings:
        pResult = OOXMLFactory_sml_customXmlMappings::getInstance();
        break;
    case NN_shared_math:
        pResult = OOXMLFactory_shared_math::getInstance();
        break;
    case NN_shared_relationshipReference:
        pResult = OOXMLFactory_shared_relationshipReference::getInstance();
        break;
    case NN_dml_chartDrawing:
        pResult = OOXMLFactory_dml_chartDrawing::getInstance();
        break;
    case NN_vml_main:
        pResult = OOXMLFactory_vml_main::getInstance();
        break;
    case NN_vml_officeDrawing:
        pResult = OOXMLFactory_vml_officeDrawing::getInstance();
        break;
    case NN_vml_wordprocessingDrawing:
        pResult = OOXMLFactory_vml_wordprocessingDrawing::getInstance();
        break;
    case NN_wml:
        pResult = OOXMLFactory_wml::getInstance();
        break;
    default:
        break;
    }

    return pResult;
}

uno::Reference<xml::sax::XFastContextHandler> OOXMLFactory::createFastChildContextFromStart
(OOXMLFastContextHandler* pHandler, Token_t Element)
{
    uno::Reference<xml::sax::XFastContextHandler> aResult;
    OOXMLFactory_ns::Pointer_t pFactory;


    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_stylesheet);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_styleDefaults);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_shape3DLighting);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_shape3DScene);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_shape3DStyles);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_shape3DCamera);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_baseStylesheet);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_textCharacter);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_shapeEffects);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_shapeLineProperties);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_shapeProperties);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_baseTypes);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_documentProperties);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_graphicalObject);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_wp14);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_w14);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_w15);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_a14);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_shapeGeometry);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_wordprocessingDrawing);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_sml_customXmlMappings);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_shared_math);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_shared_relationshipReference);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_dml_chartDrawing);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_vml_main);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_vml_officeDrawing);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_vml_wordprocessingDrawing);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }
    if (!aResult.is())
    {
        pFactory = getFactoryForNamespace(NN_wml);
        aResult.set(createFastChildContextFromFactory(pHandler, pFactory, Element));
    }

    return aResult;
}


std::string fastTokenToId(sal_uInt32 nToken)
{
    std::string sResult;
#ifdef DBG_UTIL

    switch (oox::getNamespace(nToken))
    {
    case oox::NMSP_a14:
        sResult += "a14:";
        break;
    case oox::NMSP_adec:
        sResult += "adec:";
        break;
    case oox::NMSP_asvg:
        sResult += "asvg:";
        break;
    case oox::NMSP_ax:
        sResult += "ax:";
        break;
    case oox::NMSP_c15:
        sResult += "c15:";
        break;
    case oox::NMSP_dc:
        sResult += "dc:";
        break;
    case oox::NMSP_dcTerms:
        sResult += "dcTerms:";
        break;
    case oox::NMSP_dcmiType:
        sResult += "dcmiType:";
        break;
    case oox::NMSP_dml:
        sResult += "dml:";
        break;
    case oox::NMSP_dmlChart:
        sResult += "dmlChart:";
        break;
    case oox::NMSP_dmlChartDr:
        sResult += "dmlChartDr:";
        break;
    case oox::NMSP_dmlDiagram:
        sResult += "dmlDiagram:";
        break;
    case oox::NMSP_dmlLockedCanvas:
        sResult += "dmlLockedCanvas:";
        break;
    case oox::NMSP_dmlPicture:
        sResult += "dmlPicture:";
        break;
    case oox::NMSP_dmlSpreadDr:
        sResult += "dmlSpreadDr:";
        break;
    case oox::NMSP_dmlWordDr:
        sResult += "dmlWordDr:";
        break;
    case oox::NMSP_doc:
        sResult += "doc:";
        break;
    case oox::NMSP_dsp:
        sResult += "dsp:";
        break;
    case oox::NMSP_loext:
        sResult += "loext:";
        break;
    case oox::NMSP_mce:
        sResult += "mce:";
        break;
    case oox::NMSP_mceTest:
        sResult += "mceTest:";
        break;
    case oox::NMSP_officeCustomPr:
        sResult += "officeCustomPr:";
        break;
    case oox::NMSP_officeDocPropsVT:
        sResult += "officeDocPropsVT:";
        break;
    case oox::NMSP_officeExtPr:
        sResult += "officeExtPr:";
        break;
    case oox::NMSP_officeMath:
        sResult += "officeMath:";
        break;
    case oox::NMSP_officeRel:
        sResult += "officeRel:";
        break;
    case oox::NMSP_officeRelTheme:
        sResult += "officeRelTheme:";
        break;
    case oox::NMSP_p14:
        sResult += "p14:";
        break;
    case oox::NMSP_p15:
        sResult += "p15:";
        break;
    case oox::NMSP_packageContentTypes:
        sResult += "packageContentTypes:";
        break;
    case oox::NMSP_packageMetaCorePr:
        sResult += "packageMetaCorePr:";
        break;
    case oox::NMSP_packageRel:
        sResult += "packageRel:";
        break;
    case oox::NMSP_ppt:
        sResult += "ppt:";
        break;
    case oox::NMSP_schema:
        sResult += "schema:";
        break;
    case oox::NMSP_vml:
        sResult += "vml:";
        break;
    case oox::NMSP_vmlExcel:
        sResult += "vmlExcel:";
        break;
    case oox::NMSP_vmlOffice:
        sResult += "vmlOffice:";
        break;
    case oox::NMSP_vmlPowerpoint:
        sResult += "vmlPowerpoint:";
        break;
    case oox::NMSP_vmlWord:
        sResult += "vmlWord:";
        break;
    case oox::NMSP_w14:
        sResult += "w14:";
        break;
    case oox::NMSP_w15:
        sResult += "w15:";
        break;
    case oox::NMSP_wp14:
        sResult += "wp14:";
        break;
    case oox::NMSP_wpc:
        sResult += "wpc:";
        break;
    case oox::NMSP_wpg:
        sResult += "wpg:";
        break;
    case oox::NMSP_wps:
        sResult += "wps:";
        break;
    case oox::NMSP_x12ac:
        sResult += "x12ac:";
        break;
    case oox::NMSP_xls:
        sResult += "xls:";
        break;
    case oox::NMSP_xls14Lst:
        sResult += "xls14Lst:";
        break;
    case oox::NMSP_xm:
        sResult += "xm:";
        break;
    case oox::NMSP_xml:
        sResult += "xml:";
        break;
    case oox::NMSP_xr16:
        sResult += "xr16:";
        break;
    case oox::NMSP_xr2:
        sResult += "xr2:";
        break;
    case oox::NMSP_xsi:
        sResult += "xsi:";
        break;
    }

    switch (nToken & 0xffff)
    {
    case oox::XML_extLst:
        sResult += "extLst";
        break;
    case oox::XML_bg1:
        sResult += "bg1";
        break;
    case oox::XML_tx1:
        sResult += "tx1";
        break;
    case oox::XML_bg2:
        sResult += "bg2";
        break;
    case oox::XML_tx2:
        sResult += "tx2";
        break;
    case oox::XML_accent1:
        sResult += "accent1";
        break;
    case oox::XML_accent2:
        sResult += "accent2";
        break;
    case oox::XML_accent3:
        sResult += "accent3";
        break;
    case oox::XML_accent4:
        sResult += "accent4";
        break;
    case oox::XML_accent5:
        sResult += "accent5";
        break;
    case oox::XML_accent6:
        sResult += "accent6";
        break;
    case oox::XML_hlink:
        sResult += "hlink";
        break;
    case oox::XML_folHlink:
        sResult += "folHlink";
        break;
    case oox::XML_masterClrMapping:
        sResult += "masterClrMapping";
        break;
    case oox::XML_overrideClrMapping:
        sResult += "overrideClrMapping";
        break;
    case oox::XML_clrScheme:
        sResult += "clrScheme";
        break;
    case oox::XML_clrMap:
        sResult += "clrMap";
        break;
    case oox::XML_extraClrScheme:
        sResult += "extraClrScheme";
        break;
    case oox::XML_themeElements:
        sResult += "themeElements";
        break;
    case oox::XML_objectDefaults:
        sResult += "objectDefaults";
        break;
    case oox::XML_extraClrSchemeLst:
        sResult += "extraClrSchemeLst";
        break;
    case oox::XML_custClrLst:
        sResult += "custClrLst";
        break;
    case oox::XML_name:
        sResult += "name";
        break;
    case oox::XML_fontScheme:
        sResult += "fontScheme";
        break;
    case oox::XML_fmtScheme:
        sResult += "fmtScheme";
        break;
    case oox::XML_id:
        sResult += "id";
        break;
    case oox::XML_theme:
        sResult += "theme";
        break;
    case oox::XML_themeOverride:
        sResult += "themeOverride";
        break;
    case oox::XML_themeManager:
        sResult += "themeManager";
        break;
    case oox::XML_hlinkClick:
        sResult += "hlinkClick";
        break;
    case oox::XML_spPr:
        sResult += "spPr";
        break;
    case oox::XML_spDef:
        sResult += "spDef";
        break;
    case oox::XML_lnDef:
        sResult += "lnDef";
        break;
    case oox::XML_txDef:
        sResult += "txDef";
        break;
    case oox::XML_rot:
        sResult += "rot";
        break;
    case oox::XML_rig:
        sResult += "rig";
        break;
    case oox::XML_dir:
        sResult += "dir";
        break;
    case oox::XML_camera:
        sResult += "camera";
        break;
    case oox::XML_lightRig:
        sResult += "lightRig";
        break;
    case oox::XML_w:
        sResult += "w";
        break;
    case oox::XML_h:
        sResult += "h";
        break;
    case oox::XML_prst:
        sResult += "prst";
        break;
    case oox::XML_bevelT:
        sResult += "bevelT";
        break;
    case oox::XML_bevelB:
        sResult += "bevelB";
        break;
    case oox::XML_extrusionClr:
        sResult += "extrusionClr";
        break;
    case oox::XML_contourClr:
        sResult += "contourClr";
        break;
    case oox::XML_z:
        sResult += "z";
        break;
    case oox::XML_extrusionH:
        sResult += "extrusionH";
        break;
    case oox::XML_contourW:
        sResult += "contourW";
        break;
    case oox::XML_prstMaterial:
        sResult += "prstMaterial";
        break;
    case oox::XML_sp3d:
        sResult += "sp3d";
        break;
    case oox::XML_flatTx:
        sResult += "flatTx";
        break;
    case oox::XML_fov:
        sResult += "fov";
        break;
    case oox::XML_zoom:
        sResult += "zoom";
        break;
    case oox::XML_dk1:
        sResult += "dk1";
        break;
    case oox::XML_lt1:
        sResult += "lt1";
        break;
    case oox::XML_dk2:
        sResult += "dk2";
        break;
    case oox::XML_lt2:
        sResult += "lt2";
        break;
    case oox::XML_script:
        sResult += "script";
        break;
    case oox::XML_typeface:
        sResult += "typeface";
        break;
    case oox::XML_custClr:
        sResult += "custClr";
        break;
    case oox::XML_latin:
        sResult += "latin";
        break;
    case oox::XML_ea:
        sResult += "ea";
        break;
    case oox::XML_cs:
        sResult += "cs";
        break;
    case oox::XML_font:
        sResult += "font";
        break;
    case oox::XML_scene3d:
        sResult += "scene3d";
        break;
    case oox::XML_majorFont:
        sResult += "majorFont";
        break;
    case oox::XML_minorFont:
        sResult += "minorFont";
        break;
    case oox::XML_ln:
        sResult += "ln";
        break;
    case oox::XML_effectStyle:
        sResult += "effectStyle";
        break;
    case oox::XML_fillStyleLst:
        sResult += "fillStyleLst";
        break;
    case oox::XML_lnStyleLst:
        sResult += "lnStyleLst";
        break;
    case oox::XML_effectStyleLst:
        sResult += "effectStyleLst";
        break;
    case oox::XML_bgFillStyleLst:
        sResult += "bgFillStyleLst";
        break;
    case oox::XML_panose:
        sResult += "panose";
        break;
    case oox::XML_pitchFamily:
        sResult += "pitchFamily";
        break;
    case oox::XML_charset:
        sResult += "charset";
        break;
    case oox::XML_uLnTx:
        sResult += "uLnTx";
        break;
    case oox::XML_uLn:
        sResult += "uLn";
        break;
    case oox::XML_uFillTx:
        sResult += "uFillTx";
        break;
    case oox::XML_uFill:
        sResult += "uFill";
        break;
    case oox::XML_highlight:
        sResult += "highlight";
        break;
    case oox::XML_sym:
        sResult += "sym";
        break;
    case oox::XML_hlinkMouseOver:
        sResult += "hlinkMouseOver";
        break;
    case oox::XML_kumimoji:
        sResult += "kumimoji";
        break;
    case oox::XML_lang:
        sResult += "lang";
        break;
    case oox::XML_altLang:
        sResult += "altLang";
        break;
    case oox::XML_sz:
        sResult += "sz";
        break;
    case oox::XML_b:
        sResult += "b";
        break;
    case oox::XML_i:
        sResult += "i";
        break;
    case oox::XML_u:
        sResult += "u";
        break;
    case oox::XML_strike:
        sResult += "strike";
        break;
    case oox::XML_kern:
        sResult += "kern";
        break;
    case oox::XML_cap:
        sResult += "cap";
        break;
    case oox::XML_spc:
        sResult += "spc";
        break;
    case oox::XML_normalizeH:
        sResult += "normalizeH";
        break;
    case oox::XML_baseline:
        sResult += "baseline";
        break;
    case oox::XML_noProof:
        sResult += "noProof";
        break;
    case oox::XML_dirty:
        sResult += "dirty";
        break;
    case oox::XML_err:
        sResult += "err";
        break;
    case oox::XML_smtClean:
        sResult += "smtClean";
        break;
    case oox::XML_smtId:
        sResult += "smtId";
        break;
    case oox::XML_bmk:
        sResult += "bmk";
        break;
    case oox::XML_thresh:
        sResult += "thresh";
        break;
    case oox::XML_amt:
        sResult += "amt";
        break;
    case oox::XML_rad:
        sResult += "rad";
        break;
    case oox::XML_a:
        sResult += "a";
        break;
    case oox::XML_grow:
        sResult += "grow";
        break;
    case oox::XML_clrFrom:
        sResult += "clrFrom";
        break;
    case oox::XML_clrTo:
        sResult += "clrTo";
        break;
    case oox::XML_useA:
        sResult += "useA";
        break;
    case oox::XML_hue:
        sResult += "hue";
        break;
    case oox::XML_sat:
        sResult += "sat";
        break;
    case oox::XML_lum:
        sResult += "lum";
        break;
    case oox::XML_blurRad:
        sResult += "blurRad";
        break;
    case oox::XML_dist:
        sResult += "dist";
        break;
    case oox::XML_bright:
        sResult += "bright";
        break;
    case oox::XML_contrast:
        sResult += "contrast";
        break;
    case oox::XML_sx:
        sResult += "sx";
        break;
    case oox::XML_sy:
        sResult += "sy";
        break;
    case oox::XML_kx:
        sResult += "kx";
        break;
    case oox::XML_ky:
        sResult += "ky";
        break;
    case oox::XML_algn:
        sResult += "algn";
        break;
    case oox::XML_rotWithShape:
        sResult += "rotWithShape";
        break;
    case oox::XML_stA:
        sResult += "stA";
        break;
    case oox::XML_stPos:
        sResult += "stPos";
        break;
    case oox::XML_endA:
        sResult += "endA";
        break;
    case oox::XML_endPos:
        sResult += "endPos";
        break;
    case oox::XML_fadeDir:
        sResult += "fadeDir";
        break;
    case oox::XML_tx:
        sResult += "tx";
        break;
    case oox::XML_ty:
        sResult += "ty";
        break;
    case oox::XML_ang:
        sResult += "ang";
        break;
    case oox::XML_scaled:
        sResult += "scaled";
        break;
    case oox::XML_fillToRect:
        sResult += "fillToRect";
        break;
    case oox::XML_path:
        sResult += "path";
        break;
    case oox::XML_lin:
        sResult += "lin";
        break;
    case oox::XML_pos:
        sResult += "pos";
        break;
    case oox::XML_gs:
        sResult += "gs";
        break;
    case oox::XML_gsLst:
        sResult += "gsLst";
        break;
    case oox::XML_tileRect:
        sResult += "tileRect";
        break;
    case oox::XML_flip:
        sResult += "flip";
        break;
    case oox::XML_fillRect:
        sResult += "fillRect";
        break;
    case oox::XML_tile:
        sResult += "tile";
        break;
    case oox::XML_stretch:
        sResult += "stretch";
        break;
    case oox::XML_alphaBiLevel:
        sResult += "alphaBiLevel";
        break;
    case oox::XML_alphaCeiling:
        sResult += "alphaCeiling";
        break;
    case oox::XML_alphaFloor:
        sResult += "alphaFloor";
        break;
    case oox::XML_alphaInv:
        sResult += "alphaInv";
        break;
    case oox::XML_alphaMod:
        sResult += "alphaMod";
        break;
    case oox::XML_alphaModFix:
        sResult += "alphaModFix";
        break;
    case oox::XML_alphaRepl:
        sResult += "alphaRepl";
        break;
    case oox::XML_biLevel:
        sResult += "biLevel";
        break;
    case oox::XML_blur:
        sResult += "blur";
        break;
    case oox::XML_clrChange:
        sResult += "clrChange";
        break;
    case oox::XML_clrRepl:
        sResult += "clrRepl";
        break;
    case oox::XML_duotone:
        sResult += "duotone";
        break;
    case oox::XML_fillOverlay:
        sResult += "fillOverlay";
        break;
    case oox::XML_grayscl:
        sResult += "grayscl";
        break;
    case oox::XML_hsl:
        sResult += "hsl";
        break;
    case oox::XML_tint:
        sResult += "tint";
        break;
    case oox::XML_cstate:
        sResult += "cstate";
        break;
    case oox::XML_blip:
        sResult += "blip";
        break;
    case oox::XML_srcRect:
        sResult += "srcRect";
        break;
    case oox::XML_dpi:
        sResult += "dpi";
        break;
    case oox::XML_fgClr:
        sResult += "fgClr";
        break;
    case oox::XML_bgClr:
        sResult += "bgClr";
        break;
    case oox::XML_noFill:
        sResult += "noFill";
        break;
    case oox::XML_solidFill:
        sResult += "solidFill";
        break;
    case oox::XML_gradFill:
        sResult += "gradFill";
        break;
    case oox::XML_blipFill:
        sResult += "blipFill";
        break;
    case oox::XML_pattFill:
        sResult += "pattFill";
        break;
    case oox::XML_grpFill:
        sResult += "grpFill";
        break;
    case oox::XML_blend:
        sResult += "blend";
        break;
    case oox::XML_ref:
        sResult += "ref";
        break;
    case oox::XML_cont:
        sResult += "cont";
        break;
    case oox::XML_effect:
        sResult += "effect";
        break;
    case oox::XML_alphaOutset:
        sResult += "alphaOutset";
        break;
    case oox::XML_fill:
        sResult += "fill";
        break;
    case oox::XML_glow:
        sResult += "glow";
        break;
    case oox::XML_innerShdw:
        sResult += "innerShdw";
        break;
    case oox::XML_outerShdw:
        sResult += "outerShdw";
        break;
    case oox::XML_prstShdw:
        sResult += "prstShdw";
        break;
    case oox::XML_reflection:
        sResult += "reflection";
        break;
    case oox::XML_relOff:
        sResult += "relOff";
        break;
    case oox::XML_softEdge:
        sResult += "softEdge";
        break;
    case oox::XML_xfrm:
        sResult += "xfrm";
        break;
    case oox::XML_type:
        sResult += "type";
        break;
    case oox::XML_effectLst:
        sResult += "effectLst";
        break;
    case oox::XML_effectDag:
        sResult += "effectDag";
        break;
    case oox::XML_len:
        sResult += "len";
        break;
    case oox::XML_lim:
        sResult += "lim";
        break;
    case oox::XML_round:
        sResult += "round";
        break;
    case oox::XML_bevel:
        sResult += "bevel";
        break;
    case oox::XML_miter:
        sResult += "miter";
        break;
    case oox::XML_val:
        sResult += "val";
        break;
    case oox::XML_d:
        sResult += "d";
        break;
    case oox::XML_sp:
        sResult += "sp";
        break;
    case oox::XML_ds:
        sResult += "ds";
        break;
    case oox::XML_prstDash:
        sResult += "prstDash";
        break;
    case oox::XML_custDash:
        sResult += "custDash";
        break;
    case oox::XML_headEnd:
        sResult += "headEnd";
        break;
    case oox::XML_tailEnd:
        sResult += "tailEnd";
        break;
    case oox::XML_cmpd:
        sResult += "cmpd";
        break;
    case oox::XML_bwMode:
        sResult += "bwMode";
        break;
    case oox::XML_decorative:
        sResult += "decorative";
        break;
    case oox::XML_uri:
        sResult += "uri";
        break;
    case oox::XML_n:
        sResult += "n";
        break;
    case oox::XML_x:
        sResult += "x";
        break;
    case oox::XML_y:
        sResult += "y";
        break;
    case oox::XML_cx:
        sResult += "cx";
        break;
    case oox::XML_cy:
        sResult += "cy";
        break;
    case oox::XML_shade:
        sResult += "shade";
        break;
    case oox::XML_comp:
        sResult += "comp";
        break;
    case oox::XML_inv:
        sResult += "inv";
        break;
    case oox::XML_gray:
        sResult += "gray";
        break;
    case oox::XML_alpha:
        sResult += "alpha";
        break;
    case oox::XML_alphaOff:
        sResult += "alphaOff";
        break;
    case oox::XML_hueOff:
        sResult += "hueOff";
        break;
    case oox::XML_hueMod:
        sResult += "hueMod";
        break;
    case oox::XML_satOff:
        sResult += "satOff";
        break;
    case oox::XML_satMod:
        sResult += "satMod";
        break;
    case oox::XML_lumOff:
        sResult += "lumOff";
        break;
    case oox::XML_lumMod:
        sResult += "lumMod";
        break;
    case oox::XML_red:
        sResult += "red";
        break;
    case oox::XML_redOff:
        sResult += "redOff";
        break;
    case oox::XML_redMod:
        sResult += "redMod";
        break;
    case oox::XML_green:
        sResult += "green";
        break;
    case oox::XML_greenOff:
        sResult += "greenOff";
        break;
    case oox::XML_greenMod:
        sResult += "greenMod";
        break;
    case oox::XML_blue:
        sResult += "blue";
        break;
    case oox::XML_blueOff:
        sResult += "blueOff";
        break;
    case oox::XML_blueMod:
        sResult += "blueMod";
        break;
    case oox::XML_gamma:
        sResult += "gamma";
        break;
    case oox::XML_invGamma:
        sResult += "invGamma";
        break;
    case oox::XML_r:
        sResult += "r";
        break;
    case oox::XML_g:
        sResult += "g";
        break;
    case oox::XML_lastClr:
        sResult += "lastClr";
        break;
    case oox::XML_ext:
        sResult += "ext";
        break;
    case oox::XML_off:
        sResult += "off";
        break;
    case oox::XML_flipH:
        sResult += "flipH";
        break;
    case oox::XML_flipV:
        sResult += "flipV";
        break;
    case oox::XML_chOff:
        sResult += "chOff";
        break;
    case oox::XML_chExt:
        sResult += "chExt";
        break;
    case oox::XML_dx:
        sResult += "dx";
        break;
    case oox::XML_dy:
        sResult += "dy";
        break;
    case oox::XML_dz:
        sResult += "dz";
        break;
    case oox::XML_lat:
        sResult += "lat";
        break;
    case oox::XML_lon:
        sResult += "lon";
        break;
    case oox::XML_rev:
        sResult += "rev";
        break;
    case oox::XML_l:
        sResult += "l";
        break;
    case oox::XML_t:
        sResult += "t";
        break;
    case oox::XML_scrgbClr:
        sResult += "scrgbClr";
        break;
    case oox::XML_srgbClr:
        sResult += "srgbClr";
        break;
    case oox::XML_hslClr:
        sResult += "hslClr";
        break;
    case oox::XML_sysClr:
        sResult += "sysClr";
        break;
    case oox::XML_schemeClr:
        sResult += "schemeClr";
        break;
    case oox::XML_prstClr:
        sResult += "prstClr";
        break;
    case oox::XML_embed:
        sResult += "embed";
        break;
    case oox::XML_link:
        sResult += "link";
        break;
    case oox::XML_builtIn:
        sResult += "builtIn";
        break;
    case oox::XML_snd:
        sResult += "snd";
        break;
    case oox::XML_invalidUrl:
        sResult += "invalidUrl";
        break;
    case oox::XML_action:
        sResult += "action";
        break;
    case oox::XML_tgtFrame:
        sResult += "tgtFrame";
        break;
    case oox::XML_tooltip:
        sResult += "tooltip";
        break;
    case oox::XML_history:
        sResult += "history";
        break;
    case oox::XML_highlightClick:
        sResult += "highlightClick";
        break;
    case oox::XML_endSnd:
        sResult += "endSnd";
        break;
    case oox::XML_noGrp:
        sResult += "noGrp";
        break;
    case oox::XML_noSelect:
        sResult += "noSelect";
        break;
    case oox::XML_noRot:
        sResult += "noRot";
        break;
    case oox::XML_noChangeAspect:
        sResult += "noChangeAspect";
        break;
    case oox::XML_noMove:
        sResult += "noMove";
        break;
    case oox::XML_noResize:
        sResult += "noResize";
        break;
    case oox::XML_noEditPoints:
        sResult += "noEditPoints";
        break;
    case oox::XML_noAdjustHandles:
        sResult += "noAdjustHandles";
        break;
    case oox::XML_noChangeArrowheads:
        sResult += "noChangeArrowheads";
        break;
    case oox::XML_noChangeShapeType:
        sResult += "noChangeShapeType";
        break;
    case oox::XML_noTextEdit:
        sResult += "noTextEdit";
        break;
    case oox::XML_noCrop:
        sResult += "noCrop";
        break;
    case oox::XML_noUngrp:
        sResult += "noUngrp";
        break;
    case oox::XML_noDrilldown:
        sResult += "noDrilldown";
        break;
    case oox::XML_hlinkHover:
        sResult += "hlinkHover";
        break;
    case oox::XML_descr:
        sResult += "descr";
        break;
    case oox::XML_hidden:
        sResult += "hidden";
        break;
    case oox::XML_title:
        sResult += "title";
        break;
    case oox::XML_spLocks:
        sResult += "spLocks";
        break;
    case oox::XML_txBox:
        sResult += "txBox";
        break;
    case oox::XML_cxnSpLocks:
        sResult += "cxnSpLocks";
        break;
    case oox::XML_stCxn:
        sResult += "stCxn";
        break;
    case oox::XML_endCxn:
        sResult += "endCxn";
        break;
    case oox::XML_picLocks:
        sResult += "picLocks";
        break;
    case oox::XML_preferRelativeResize:
        sResult += "preferRelativeResize";
        break;
    case oox::XML_grpSpLocks:
        sResult += "grpSpLocks";
        break;
    case oox::XML_graphicFrameLocks:
        sResult += "graphicFrameLocks";
        break;
    case oox::XML_graphicData:
        sResult += "graphicData";
        break;
    case oox::XML_graphic:
        sResult += "graphic";
        break;
    case oox::XML_pctWidth:
        sResult += "pctWidth";
        break;
    case oox::XML_relativeFrom:
        sResult += "relativeFrom";
        break;
    case oox::XML_pctHeight:
        sResult += "pctHeight";
        break;
    case oox::XML_sizeRelH:
        sResult += "sizeRelH";
        break;
    case oox::XML_sizeRelV:
        sResult += "sizeRelV";
        break;
    case oox::XML_styleSet:
        sResult += "styleSet";
        break;
    case oox::XML_shadow:
        sResult += "shadow";
        break;
    case oox::XML_textOutline:
        sResult += "textOutline";
        break;
    case oox::XML_textFill:
        sResult += "textFill";
        break;
    case oox::XML_props3d:
        sResult += "props3d";
        break;
    case oox::XML_ligatures:
        sResult += "ligatures";
        break;
    case oox::XML_numForm:
        sResult += "numForm";
        break;
    case oox::XML_numSpacing:
        sResult += "numSpacing";
        break;
    case oox::XML_stylisticSets:
        sResult += "stylisticSets";
        break;
    case oox::XML_cntxtAlts:
        sResult += "cntxtAlts";
        break;
    case oox::XML_checked:
        sResult += "checked";
        break;
    case oox::XML_checkedState:
        sResult += "checkedState";
        break;
    case oox::XML_uncheckedState:
        sResult += "uncheckedState";
        break;
    case oox::XML_commentsEx:
        sResult += "commentsEx";
        break;
    case oox::XML_commentEx:
        sResult += "commentEx";
        break;
    case oox::XML_paraId:
        sResult += "paraId";
        break;
    case oox::XML_paraIdParent:
        sResult += "paraIdParent";
        break;
    case oox::XML_done:
        sResult += "done";
        break;
    case oox::XML_visible:
        sResult += "visible";
        break;
    case oox::XML_trans:
        sResult += "trans";
        break;
    case oox::XML_crackSpacing:
        sResult += "crackSpacing";
        break;
    case oox::XML_pressure:
        sResult += "pressure";
        break;
    case oox::XML_numberOfShades:
        sResult += "numberOfShades";
        break;
    case oox::XML_grainSize:
        sResult += "grainSize";
        break;
    case oox::XML_scaling:
        sResult += "scaling";
        break;
    case oox::XML_intensity:
        sResult += "intensity";
        break;
    case oox::XML_smoothness:
        sResult += "smoothness";
        break;
    case oox::XML_gridSize:
        sResult += "gridSize";
        break;
    case oox::XML_pencilSize:
        sResult += "pencilSize";
        break;
    case oox::XML_size:
        sResult += "size";
        break;
    case oox::XML_brushSize:
        sResult += "brushSize";
        break;
    case oox::XML_detail:
        sResult += "detail";
        break;
    case oox::XML_colorTemp:
        sResult += "colorTemp";
        break;
    case oox::XML_amount:
        sResult += "amount";
        break;
    case oox::XML_artisticBlur:
        sResult += "artisticBlur";
        break;
    case oox::XML_artisticCement:
        sResult += "artisticCement";
        break;
    case oox::XML_artisticChalkSketch:
        sResult += "artisticChalkSketch";
        break;
    case oox::XML_artisticCrisscrossEtching:
        sResult += "artisticCrisscrossEtching";
        break;
    case oox::XML_artisticCutout:
        sResult += "artisticCutout";
        break;
    case oox::XML_artisticFilmGrain:
        sResult += "artisticFilmGrain";
        break;
    case oox::XML_artisticGlass:
        sResult += "artisticGlass";
        break;
    case oox::XML_artisticGlowDiffused:
        sResult += "artisticGlowDiffused";
        break;
    case oox::XML_artisticGlowEdges:
        sResult += "artisticGlowEdges";
        break;
    case oox::XML_artisticLightScreen:
        sResult += "artisticLightScreen";
        break;
    case oox::XML_artisticLineDrawing:
        sResult += "artisticLineDrawing";
        break;
    case oox::XML_artisticMarker:
        sResult += "artisticMarker";
        break;
    case oox::XML_artisticMosiaicBubbles:
        sResult += "artisticMosiaicBubbles";
        break;
    case oox::XML_artisticPaintStrokes:
        sResult += "artisticPaintStrokes";
        break;
    case oox::XML_artisticPaintBrush:
        sResult += "artisticPaintBrush";
        break;
    case oox::XML_artisticPastelsSmooth:
        sResult += "artisticPastelsSmooth";
        break;
    case oox::XML_artisticPencilGrayscale:
        sResult += "artisticPencilGrayscale";
        break;
    case oox::XML_artisticPencilSketch:
        sResult += "artisticPencilSketch";
        break;
    case oox::XML_artisticPhotocopy:
        sResult += "artisticPhotocopy";
        break;
    case oox::XML_artisticPlasticWrap:
        sResult += "artisticPlasticWrap";
        break;
    case oox::XML_artisticTexturizer:
        sResult += "artisticTexturizer";
        break;
    case oox::XML_artisticWatercolorSponge:
        sResult += "artisticWatercolorSponge";
        break;
    case oox::XML_brightnessContrast:
        sResult += "brightnessContrast";
        break;
    case oox::XML_colorTemperature:
        sResult += "colorTemperature";
        break;
    case oox::XML_saturation:
        sResult += "saturation";
        break;
    case oox::XML_sharpenSoften:
        sResult += "sharpenSoften";
        break;
    case oox::XML_imgEffect:
        sResult += "imgEffect";
        break;
    case oox::XML_imgLayer:
        sResult += "imgLayer";
        break;
    case oox::XML_fmla:
        sResult += "fmla";
        break;
    case oox::XML_gd:
        sResult += "gd";
        break;
    case oox::XML_gdRefX:
        sResult += "gdRefX";
        break;
    case oox::XML_minX:
        sResult += "minX";
        break;
    case oox::XML_maxX:
        sResult += "maxX";
        break;
    case oox::XML_gdRefY:
        sResult += "gdRefY";
        break;
    case oox::XML_minY:
        sResult += "minY";
        break;
    case oox::XML_maxY:
        sResult += "maxY";
        break;
    case oox::XML_gdRefR:
        sResult += "gdRefR";
        break;
    case oox::XML_minR:
        sResult += "minR";
        break;
    case oox::XML_maxR:
        sResult += "maxR";
        break;
    case oox::XML_gdRefAng:
        sResult += "gdRefAng";
        break;
    case oox::XML_minAng:
        sResult += "minAng";
        break;
    case oox::XML_maxAng:
        sResult += "maxAng";
        break;
    case oox::XML_ahXY:
        sResult += "ahXY";
        break;
    case oox::XML_ahPolar:
        sResult += "ahPolar";
        break;
    case oox::XML_cxn:
        sResult += "cxn";
        break;
    case oox::XML_idx:
        sResult += "idx";
        break;
    case oox::XML_pt:
        sResult += "pt";
        break;
    case oox::XML_wR:
        sResult += "wR";
        break;
    case oox::XML_hR:
        sResult += "hR";
        break;
    case oox::XML_stAng:
        sResult += "stAng";
        break;
    case oox::XML_swAng:
        sResult += "swAng";
        break;
    case oox::XML_close:
        sResult += "close";
        break;
    case oox::XML_moveTo:
        sResult += "moveTo";
        break;
    case oox::XML_lnTo:
        sResult += "lnTo";
        break;
    case oox::XML_arcTo:
        sResult += "arcTo";
        break;
    case oox::XML_quadBezTo:
        sResult += "quadBezTo";
        break;
    case oox::XML_cubicBezTo:
        sResult += "cubicBezTo";
        break;
    case oox::XML_stroke:
        sResult += "stroke";
        break;
    case oox::XML_extrusionOk:
        sResult += "extrusionOk";
        break;
    case oox::XML_avLst:
        sResult += "avLst";
        break;
    case oox::XML_gdLst:
        sResult += "gdLst";
        break;
    case oox::XML_ahLst:
        sResult += "ahLst";
        break;
    case oox::XML_cxnLst:
        sResult += "cxnLst";
        break;
    case oox::XML_rect:
        sResult += "rect";
        break;
    case oox::XML_pathLst:
        sResult += "pathLst";
        break;
    case oox::XML_custGeom:
        sResult += "custGeom";
        break;
    case oox::XML_prstGeom:
        sResult += "prstGeom";
        break;
    case oox::XML_prstTxWarp:
        sResult += "prstTxWarp";
        break;
    case oox::XML_extent:
        sResult += "extent";
        break;
    case oox::XML_effectExtent:
        sResult += "effectExtent";
        break;
    case oox::XML_docPr:
        sResult += "docPr";
        break;
    case oox::XML_cNvGraphicFramePr:
        sResult += "cNvGraphicFramePr";
        break;
    case oox::XML_distT:
        sResult += "distT";
        break;
    case oox::XML_distB:
        sResult += "distB";
        break;
    case oox::XML_distL:
        sResult += "distL";
        break;
    case oox::XML_distR:
        sResult += "distR";
        break;
    case oox::XML_anchorId:
        sResult += "anchorId";
        break;
    case oox::XML_start:
        sResult += "start";
        break;
    case oox::XML_lineTo:
        sResult += "lineTo";
        break;
    case oox::XML_edited:
        sResult += "edited";
        break;
    case oox::XML_wrapText:
        sResult += "wrapText";
        break;
    case oox::XML_wrapPolygon:
        sResult += "wrapPolygon";
        break;
    case oox::XML_wrapNone:
        sResult += "wrapNone";
        break;
    case oox::XML_wrapSquare:
        sResult += "wrapSquare";
        break;
    case oox::XML_wrapTight:
        sResult += "wrapTight";
        break;
    case oox::XML_wrapThrough:
        sResult += "wrapThrough";
        break;
    case oox::XML_wrapTopAndBottom:
        sResult += "wrapTopAndBottom";
        break;
    case oox::XML_align:
        sResult += "align";
        break;
    case oox::XML_posOffset:
        sResult += "posOffset";
        break;
    case oox::XML_simplePos:
        sResult += "simplePos";
        break;
    case oox::XML_positionH:
        sResult += "positionH";
        break;
    case oox::XML_positionV:
        sResult += "positionV";
        break;
    case oox::XML_relativeHeight:
        sResult += "relativeHeight";
        break;
    case oox::XML_behindDoc:
        sResult += "behindDoc";
        break;
    case oox::XML_locked:
        sResult += "locked";
        break;
    case oox::XML_layoutInCell:
        sResult += "layoutInCell";
        break;
    case oox::XML_allowOverlap:
        sResult += "allowOverlap";
        break;
    case oox::XML_inline:
        sResult += "inline";
        break;
    case oox::XML_anchor:
        sResult += "anchor";
        break;
    case oox::XML_manifestLocation:
        sResult += "manifestLocation";
        break;
    case oox::XML_schemaLocation:
        sResult += "schemaLocation";
        break;
    case oox::XML_schema:
        sResult += "schema";
        break;
    case oox::XML_schemaLibrary:
        sResult += "schemaLibrary";
        break;
    case oox::XML_alnAt:
        sResult += "alnAt";
        break;
    case oox::XML_scr:
        sResult += "scr";
        break;
    case oox::XML_sty:
        sResult += "sty";
        break;
    case oox::XML_lit:
        sResult += "lit";
        break;
    case oox::XML_nor:
        sResult += "nor";
        break;
    case oox::XML_brk:
        sResult += "brk";
        break;
    case oox::XML_aln:
        sResult += "aln";
        break;
    case oox::XML_space:
        sResult += "space";
        break;
    case oox::XML_rPr:
        sResult += "rPr";
        break;
    case oox::XML_chr:
        sResult += "chr";
        break;
    case oox::XML_ctrlPr:
        sResult += "ctrlPr";
        break;
    case oox::XML_accPr:
        sResult += "accPr";
        break;
    case oox::XML_e:
        sResult += "e";
        break;
    case oox::XML_barPr:
        sResult += "barPr";
        break;
    case oox::XML_opEmu:
        sResult += "opEmu";
        break;
    case oox::XML_noBreak:
        sResult += "noBreak";
        break;
    case oox::XML_diff:
        sResult += "diff";
        break;
    case oox::XML_boxPr:
        sResult += "boxPr";
        break;
    case oox::XML_hideTop:
        sResult += "hideTop";
        break;
    case oox::XML_hideBot:
        sResult += "hideBot";
        break;
    case oox::XML_hideLeft:
        sResult += "hideLeft";
        break;
    case oox::XML_hideRight:
        sResult += "hideRight";
        break;
    case oox::XML_strikeH:
        sResult += "strikeH";
        break;
    case oox::XML_strikeV:
        sResult += "strikeV";
        break;
    case oox::XML_strikeBLTR:
        sResult += "strikeBLTR";
        break;
    case oox::XML_strikeTLBR:
        sResult += "strikeTLBR";
        break;
    case oox::XML_borderBoxPr:
        sResult += "borderBoxPr";
        break;
    case oox::XML_begChr:
        sResult += "begChr";
        break;
    case oox::XML_sepChr:
        sResult += "sepChr";
        break;
    case oox::XML_endChr:
        sResult += "endChr";
        break;
    case oox::XML_shp:
        sResult += "shp";
        break;
    case oox::XML_dPr:
        sResult += "dPr";
        break;
    case oox::XML_baseJc:
        sResult += "baseJc";
        break;
    case oox::XML_maxDist:
        sResult += "maxDist";
        break;
    case oox::XML_objDist:
        sResult += "objDist";
        break;
    case oox::XML_rSpRule:
        sResult += "rSpRule";
        break;
    case oox::XML_rSp:
        sResult += "rSp";
        break;
    case oox::XML_eqArrPr:
        sResult += "eqArrPr";
        break;
    case oox::XML_fPr:
        sResult += "fPr";
        break;
    case oox::XML_num:
        sResult += "num";
        break;
    case oox::XML_den:
        sResult += "den";
        break;
    case oox::XML_funcPr:
        sResult += "funcPr";
        break;
    case oox::XML_fName:
        sResult += "fName";
        break;
    case oox::XML_vertJc:
        sResult += "vertJc";
        break;
    case oox::XML_groupChrPr:
        sResult += "groupChrPr";
        break;
    case oox::XML_limLowPr:
        sResult += "limLowPr";
        break;
    case oox::XML_limUppPr:
        sResult += "limUppPr";
        break;
    case oox::XML_count:
        sResult += "count";
        break;
    case oox::XML_mcJc:
        sResult += "mcJc";
        break;
    case oox::XML_mcPr:
        sResult += "mcPr";
        break;
    case oox::XML_mc:
        sResult += "mc";
        break;
    case oox::XML_plcHide:
        sResult += "plcHide";
        break;
    case oox::XML_cGpRule:
        sResult += "cGpRule";
        break;
    case oox::XML_cSp:
        sResult += "cSp";
        break;
    case oox::XML_cGp:
        sResult += "cGp";
        break;
    case oox::XML_mcs:
        sResult += "mcs";
        break;
    case oox::XML_mPr:
        sResult += "mPr";
        break;
    case oox::XML_mr:
        sResult += "mr";
        break;
    case oox::XML_limLoc:
        sResult += "limLoc";
        break;
    case oox::XML_subHide:
        sResult += "subHide";
        break;
    case oox::XML_supHide:
        sResult += "supHide";
        break;
    case oox::XML_naryPr:
        sResult += "naryPr";
        break;
    case oox::XML_sub:
        sResult += "sub";
        break;
    case oox::XML_sup:
        sResult += "sup";
        break;
    case oox::XML_show:
        sResult += "show";
        break;
    case oox::XML_zeroWid:
        sResult += "zeroWid";
        break;
    case oox::XML_zeroAsc:
        sResult += "zeroAsc";
        break;
    case oox::XML_zeroDesc:
        sResult += "zeroDesc";
        break;
    case oox::XML_transp:
        sResult += "transp";
        break;
    case oox::XML_phantPr:
        sResult += "phantPr";
        break;
    case oox::XML_degHide:
        sResult += "degHide";
        break;
    case oox::XML_radPr:
        sResult += "radPr";
        break;
    case oox::XML_deg:
        sResult += "deg";
        break;
    case oox::XML_sPrePr:
        sResult += "sPrePr";
        break;
    case oox::XML_sSubPr:
        sResult += "sSubPr";
        break;
    case oox::XML_alnScr:
        sResult += "alnScr";
        break;
    case oox::XML_sSubSupPr:
        sResult += "sSubSupPr";
        break;
    case oox::XML_sSupPr:
        sResult += "sSupPr";
        break;
    case oox::XML_acc:
        sResult += "acc";
        break;
    case oox::XML_bar:
        sResult += "bar";
        break;
    case oox::XML_box:
        sResult += "box";
        break;
    case oox::XML_borderBox:
        sResult += "borderBox";
        break;
    case oox::XML_eqArr:
        sResult += "eqArr";
        break;
    case oox::XML_f:
        sResult += "f";
        break;
    case oox::XML_func:
        sResult += "func";
        break;
    case oox::XML_groupChr:
        sResult += "groupChr";
        break;
    case oox::XML_limLow:
        sResult += "limLow";
        break;
    case oox::XML_limUpp:
        sResult += "limUpp";
        break;
    case oox::XML_m:
        sResult += "m";
        break;
    case oox::XML_nary:
        sResult += "nary";
        break;
    case oox::XML_phant:
        sResult += "phant";
        break;
    case oox::XML_sPre:
        sResult += "sPre";
        break;
    case oox::XML_sSub:
        sResult += "sSub";
        break;
    case oox::XML_sSubSup:
        sResult += "sSubSup";
        break;
    case oox::XML_sSup:
        sResult += "sSup";
        break;
    case oox::XML_argSz:
        sResult += "argSz";
        break;
    case oox::XML_argPr:
        sResult += "argPr";
        break;
    case oox::XML_jc:
        sResult += "jc";
        break;
    case oox::XML_mathFont:
        sResult += "mathFont";
        break;
    case oox::XML_brkBin:
        sResult += "brkBin";
        break;
    case oox::XML_brkBinSub:
        sResult += "brkBinSub";
        break;
    case oox::XML_smallFrac:
        sResult += "smallFrac";
        break;
    case oox::XML_dispDef:
        sResult += "dispDef";
        break;
    case oox::XML_lMargin:
        sResult += "lMargin";
        break;
    case oox::XML_rMargin:
        sResult += "rMargin";
        break;
    case oox::XML_defJc:
        sResult += "defJc";
        break;
    case oox::XML_preSp:
        sResult += "preSp";
        break;
    case oox::XML_postSp:
        sResult += "postSp";
        break;
    case oox::XML_interSp:
        sResult += "interSp";
        break;
    case oox::XML_intraSp:
        sResult += "intraSp";
        break;
    case oox::XML_wrapIndent:
        sResult += "wrapIndent";
        break;
    case oox::XML_wrapRight:
        sResult += "wrapRight";
        break;
    case oox::XML_intLim:
        sResult += "intLim";
        break;
    case oox::XML_naryLim:
        sResult += "naryLim";
        break;
    case oox::XML_mathPr:
        sResult += "mathPr";
        break;
    case oox::XML_oMathParaPr:
        sResult += "oMathParaPr";
        break;
    case oox::XML_oMath:
        sResult += "oMath";
        break;
    case oox::XML_oMathPara:
        sResult += "oMathPara";
        break;
    case oox::XML_dm:
        sResult += "dm";
        break;
    case oox::XML_lo:
        sResult += "lo";
        break;
    case oox::XML_qs:
        sResult += "qs";
        break;
    case oox::XML_pict:
        sResult += "pict";
        break;
    case oox::XML_href:
        sResult += "href";
        break;
    case oox::XML_cNvPr:
        sResult += "cNvPr";
        break;
    case oox::XML_cNvPicPr:
        sResult += "cNvPicPr";
        break;
    case oox::XML_nvPicPr:
        sResult += "nvPicPr";
        break;
    case oox::XML_pic:
        sResult += "pic";
        break;
    case oox::XML_relIds:
        sResult += "relIds";
        break;
    case oox::XML_nvGrpSpPr:
        sResult += "nvGrpSpPr";
        break;
    case oox::XML_grpSpPr:
        sResult += "grpSpPr";
        break;
    case oox::XML_lockedCanvas:
        sResult += "lockedCanvas";
        break;
    case oox::XML_chart:
        sResult += "chart";
        break;
    case oox::XML_cNvSpPr:
        sResult += "cNvSpPr";
        break;
    case oox::XML_wsp:
        sResult += "wsp";
        break;
    case oox::XML_cNvGrpSpPr:
        sResult += "cNvGrpSpPr";
        break;
    case oox::XML_wgp:
        sResult += "wgp";
        break;
    case oox::XML_bg:
        sResult += "bg";
        break;
    case oox::XML_whole:
        sResult += "whole";
        break;
    case oox::XML_wpc:
        sResult += "wpc";
        break;
    case oox::XML_style:
        sResult += "style";
        break;
    case oox::XML_adj:
        sResult += "adj";
        break;
    case oox::XML_filled:
        sResult += "filled";
        break;
    case oox::XML_fillcolor:
        sResult += "fillcolor";
        break;
    case oox::XML_chromakey:
        sResult += "chromakey";
        break;
    case oox::XML_target:
        sResult += "target";
        break;
    case oox::XML_class:
        sResult += "class";
        break;
    case oox::XML_alt:
        sResult += "alt";
        break;
    case oox::XML_coordsize:
        sResult += "coordsize";
        break;
    case oox::XML_coordorigin:
        sResult += "coordorigin";
        break;
    case oox::XML_wrapcoords:
        sResult += "wrapcoords";
        break;
    case oox::XML_print:
        sResult += "print";
        break;
    case oox::XML_opacity:
        sResult += "opacity";
        break;
    case oox::XML_stroked:
        sResult += "stroked";
        break;
    case oox::XML_strokecolor:
        sResult += "strokecolor";
        break;
    case oox::XML_strokeweight:
        sResult += "strokeweight";
        break;
    case oox::XML_insetpen:
        sResult += "insetpen";
        break;
    case oox::XML_spid:
        sResult += "spid";
        break;
    case oox::XML_oned:
        sResult += "oned";
        break;
    case oox::XML_regroupid:
        sResult += "regroupid";
        break;
    case oox::XML_doubleclicknotify:
        sResult += "doubleclicknotify";
        break;
    case oox::XML_button:
        sResult += "button";
        break;
    case oox::XML_userhidden:
        sResult += "userhidden";
        break;
    case oox::XML_bullet:
        sResult += "bullet";
        break;
    case oox::XML_hr:
        sResult += "hr";
        break;
    case oox::XML_hrstd:
        sResult += "hrstd";
        break;
    case oox::XML_hrnoshade:
        sResult += "hrnoshade";
        break;
    case oox::XML_hrpct:
        sResult += "hrpct";
        break;
    case oox::XML_hralign:
        sResult += "hralign";
        break;
    case oox::XML_allowincell:
        sResult += "allowincell";
        break;
    case oox::XML_allowoverlap:
        sResult += "allowoverlap";
        break;
    case oox::XML_userdrawn:
        sResult += "userdrawn";
        break;
    case oox::XML_bordertopcolor:
        sResult += "bordertopcolor";
        break;
    case oox::XML_borderleftcolor:
        sResult += "borderleftcolor";
        break;
    case oox::XML_borderbottomcolor:
        sResult += "borderbottomcolor";
        break;
    case oox::XML_borderrightcolor:
        sResult += "borderrightcolor";
        break;
    case oox::XML_dgmlayout:
        sResult += "dgmlayout";
        break;
    case oox::XML_dgmnodekind:
        sResult += "dgmnodekind";
        break;
    case oox::XML_dgmlayoutmru:
        sResult += "dgmlayoutmru";
        break;
    case oox::XML_insetmode:
        sResult += "insetmode";
        break;
    case oox::XML_spt:
        sResult += "spt";
        break;
    case oox::XML_connectortype:
        sResult += "connectortype";
        break;
    case oox::XML_bwmode:
        sResult += "bwmode";
        break;
    case oox::XML_bwpure:
        sResult += "bwpure";
        break;
    case oox::XML_bwnormal:
        sResult += "bwnormal";
        break;
    case oox::XML_forcedash:
        sResult += "forcedash";
        break;
    case oox::XML_oleicon:
        sResult += "oleicon";
        break;
    case oox::XML_ole:
        sResult += "ole";
        break;
    case oox::XML_preferrelative:
        sResult += "preferrelative";
        break;
    case oox::XML_cliptowrap:
        sResult += "cliptowrap";
        break;
    case oox::XML_clip:
        sResult += "clip";
        break;
    case oox::XML_src:
        sResult += "src";
        break;
    case oox::XML_cropleft:
        sResult += "cropleft";
        break;
    case oox::XML_croptop:
        sResult += "croptop";
        break;
    case oox::XML_cropright:
        sResult += "cropright";
        break;
    case oox::XML_cropbottom:
        sResult += "cropbottom";
        break;
    case oox::XML_gain:
        sResult += "gain";
        break;
    case oox::XML_blacklevel:
        sResult += "blacklevel";
        break;
    case oox::XML_grayscale:
        sResult += "grayscale";
        break;
    case oox::XML_bilevel:
        sResult += "bilevel";
        break;
    case oox::XML_on:
        sResult += "on";
        break;
    case oox::XML_weight:
        sResult += "weight";
        break;
    case oox::XML_color:
        sResult += "color";
        break;
    case oox::XML_linestyle:
        sResult += "linestyle";
        break;
    case oox::XML_miterlimit:
        sResult += "miterlimit";
        break;
    case oox::XML_joinstyle:
        sResult += "joinstyle";
        break;
    case oox::XML_endcap:
        sResult += "endcap";
        break;
    case oox::XML_dashstyle:
        sResult += "dashstyle";
        break;
    case oox::XML_filltype:
        sResult += "filltype";
        break;
    case oox::XML_imageaspect:
        sResult += "imageaspect";
        break;
    case oox::XML_imagesize:
        sResult += "imagesize";
        break;
    case oox::XML_imagealignshape:
        sResult += "imagealignshape";
        break;
    case oox::XML_color2:
        sResult += "color2";
        break;
    case oox::XML_startarrow:
        sResult += "startarrow";
        break;
    case oox::XML_startarrowwidth:
        sResult += "startarrowwidth";
        break;
    case oox::XML_startarrowlength:
        sResult += "startarrowlength";
        break;
    case oox::XML_endarrow:
        sResult += "endarrow";
        break;
    case oox::XML_endarrowwidth:
        sResult += "endarrowwidth";
        break;
    case oox::XML_endarrowlength:
        sResult += "endarrowlength";
        break;
    case oox::XML_althref:
        sResult += "althref";
        break;
    case oox::XML_relid:
        sResult += "relid";
        break;
    case oox::XML_skew:
        sResult += "skew";
        break;
    case oox::XML_extrusion:
        sResult += "extrusion";
        break;
    case oox::XML_callout:
        sResult += "callout";
        break;
    case oox::XML_lock:
        sResult += "lock";
        break;
    case oox::XML_clippath:
        sResult += "clippath";
        break;
    case oox::XML_signatureline:
        sResult += "signatureline";
        break;
    case oox::XML_wrap:
        sResult += "wrap";
        break;
    case oox::XML_anchorlock:
        sResult += "anchorlock";
        break;
    case oox::XML_bordertop:
        sResult += "bordertop";
        break;
    case oox::XML_borderbottom:
        sResult += "borderbottom";
        break;
    case oox::XML_borderleft:
        sResult += "borderleft";
        break;
    case oox::XML_borderright:
        sResult += "borderright";
        break;
    case oox::XML_ClientData:
        sResult += "ClientData";
        break;
    case oox::XML_textdata:
        sResult += "textdata";
        break;
    case oox::XML_shape:
        sResult += "shape";
        break;
    case oox::XML_shapetype:
        sResult += "shapetype";
        break;
    case oox::XML_group:
        sResult += "group";
        break;
    case oox::XML_background:
        sResult += "background";
        break;
    case oox::XML_ink:
        sResult += "ink";
        break;
    case oox::XML_iscomment:
        sResult += "iscomment";
        break;
    case oox::XML_gfxdata:
        sResult += "gfxdata";
        break;
    case oox::XML_equationxml:
        sResult += "equationxml";
        break;
    case oox::XML_complex:
        sResult += "complex";
        break;
    case oox::XML_master:
        sResult += "master";
        break;
    case oox::XML_diagram:
        sResult += "diagram";
        break;
    case oox::XML_editas:
        sResult += "editas";
        break;
    case oox::XML_tableproperties:
        sResult += "tableproperties";
        break;
    case oox::XML_tablelimits:
        sResult += "tablelimits";
        break;
    case oox::XML_targetscreensize:
        sResult += "targetscreensize";
        break;
    case oox::XML_formulas:
        sResult += "formulas";
        break;
    case oox::XML_handles:
        sResult += "handles";
        break;
    case oox::XML_imagedata:
        sResult += "imagedata";
        break;
    case oox::XML_textbox:
        sResult += "textbox";
        break;
    case oox::XML_textpath:
        sResult += "textpath";
        break;
    case oox::XML_origin:
        sResult += "origin";
        break;
    case oox::XML_position:
        sResult += "position";
        break;
    case oox::XML_aspect:
        sResult += "aspect";
        break;
    case oox::XML_colors:
        sResult += "colors";
        break;
    case oox::XML_angle:
        sResult += "angle";
        break;
    case oox::XML_alignshape:
        sResult += "alignshape";
        break;
    case oox::XML_focus:
        sResult += "focus";
        break;
    case oox::XML_focussize:
        sResult += "focussize";
        break;
    case oox::XML_focusposition:
        sResult += "focusposition";
        break;
    case oox::XML_method:
        sResult += "method";
        break;
    case oox::XML_detectmouseclick:
        sResult += "detectmouseclick";
        break;
    case oox::XML_opacity2:
        sResult += "opacity2";
        break;
    case oox::XML_recolor:
        sResult += "recolor";
        break;
    case oox::XML_rotate:
        sResult += "rotate";
        break;
    case oox::XML_eqn:
        sResult += "eqn";
        break;
    case oox::XML_polar:
        sResult += "polar";
        break;
    case oox::XML_map:
        sResult += "map";
        break;
    case oox::XML_invx:
        sResult += "invx";
        break;
    case oox::XML_invy:
        sResult += "invy";
        break;
    case oox::XML_switch:
        sResult += "switch";
        break;
    case oox::XML_xrange:
        sResult += "xrange";
        break;
    case oox::XML_yrange:
        sResult += "yrange";
        break;
    case oox::XML_radiusrange:
        sResult += "radiusrange";
        break;
    case oox::XML_embosscolor:
        sResult += "embosscolor";
        break;
    case oox::XML_recolortarget:
        sResult += "recolortarget";
        break;
    case oox::XML_oleid:
        sResult += "oleid";
        break;
    case oox::XML_movie:
        sResult += "movie";
        break;
    case oox::XML_v:
        sResult += "v";
        break;
    case oox::XML_limo:
        sResult += "limo";
        break;
    case oox::XML_textboxrect:
        sResult += "textboxrect";
        break;
    case oox::XML_fillok:
        sResult += "fillok";
        break;
    case oox::XML_strokeok:
        sResult += "strokeok";
        break;
    case oox::XML_shadowok:
        sResult += "shadowok";
        break;
    case oox::XML_arrowok:
        sResult += "arrowok";
        break;
    case oox::XML_gradientshapeok:
        sResult += "gradientshapeok";
        break;
    case oox::XML_textpathok:
        sResult += "textpathok";
        break;
    case oox::XML_insetpenok:
        sResult += "insetpenok";
        break;
    case oox::XML_connecttype:
        sResult += "connecttype";
        break;
    case oox::XML_connectlocs:
        sResult += "connectlocs";
        break;
    case oox::XML_connectangles:
        sResult += "connectangles";
        break;
    case oox::XML_extrusionok:
        sResult += "extrusionok";
        break;
    case oox::XML_obscured:
        sResult += "obscured";
        break;
    case oox::XML_offset:
        sResult += "offset";
        break;
    case oox::XML_offset2:
        sResult += "offset2";
        break;
    case oox::XML_matrix:
        sResult += "matrix";
        break;
    case oox::XML_left:
        sResult += "left";
        break;
    case oox::XML_top:
        sResult += "top";
        break;
    case oox::XML_right:
        sResult += "right";
        break;
    case oox::XML_bottom:
        sResult += "bottom";
        break;
    case oox::XML_column:
        sResult += "column";
        break;
    case oox::XML_txbxContent:
        sResult += "txbxContent";
        break;
    case oox::XML_inset:
        sResult += "inset";
        break;
    case oox::XML_singleclick:
        sResult += "singleclick";
        break;
    case oox::XML_fitshape:
        sResult += "fitshape";
        break;
    case oox::XML_fitpath:
        sResult += "fitpath";
        break;
    case oox::XML_trim:
        sResult += "trim";
        break;
    case oox::XML_xscale:
        sResult += "xscale";
        break;
    case oox::XML_string:
        sResult += "string";
        break;
    case oox::XML_arc:
        sResult += "arc";
        break;
    case oox::XML_curve:
        sResult += "curve";
        break;
    case oox::XML_image:
        sResult += "image";
        break;
    case oox::XML_line:
        sResult += "line";
        break;
    case oox::XML_oval:
        sResult += "oval";
        break;
    case oox::XML_polyline:
        sResult += "polyline";
        break;
    case oox::XML_roundrect:
        sResult += "roundrect";
        break;
    case oox::XML_startAngle:
        sResult += "startAngle";
        break;
    case oox::XML_endAngle:
        sResult += "endAngle";
        break;
    case oox::XML_from:
        sResult += "from";
        break;
    case oox::XML_control1:
        sResult += "control1";
        break;
    case oox::XML_control2:
        sResult += "control2";
        break;
    case oox::XML_to:
        sResult += "to";
        break;
    case oox::XML_points:
        sResult += "points";
        break;
    case oox::XML_arcsize:
        sResult += "arcsize";
        break;
    case oox::XML_shapedefaults:
        sResult += "shapedefaults";
        break;
    case oox::XML_shapelayout:
        sResult += "shapelayout";
        break;
    case oox::XML_colormru:
        sResult += "colormru";
        break;
    case oox::XML_colormenu:
        sResult += "colormenu";
        break;
    case oox::XML_spidmax:
        sResult += "spidmax";
        break;
    case oox::XML_annotation:
        sResult += "annotation";
        break;
    case oox::XML_issignatureline:
        sResult += "issignatureline";
        break;
    case oox::XML_provid:
        sResult += "provid";
        break;
    case oox::XML_signinginstructionsset:
        sResult += "signinginstructionsset";
        break;
    case oox::XML_allowcomments:
        sResult += "allowcomments";
        break;
    case oox::XML_showsigndate:
        sResult += "showsigndate";
        break;
    case oox::XML_suggestedsigner:
        sResult += "suggestedsigner";
        break;
    case oox::XML_suggestedsigner2:
        sResult += "suggestedsigner2";
        break;
    case oox::XML_suggestedsigneremail:
        sResult += "suggestedsigneremail";
        break;
    case oox::XML_signinginstructions:
        sResult += "signinginstructions";
        break;
    case oox::XML_addlxml:
        sResult += "addlxml";
        break;
    case oox::XML_sigprovurl:
        sResult += "sigprovurl";
        break;
    case oox::XML_idmap:
        sResult += "idmap";
        break;
    case oox::XML_regrouptable:
        sResult += "regrouptable";
        break;
    case oox::XML_rules:
        sResult += "rules";
        break;
    case oox::XML_data:
        sResult += "data";
        break;
    case oox::XML_entry:
        sResult += "entry";
        break;
    case oox::XML_new:
        sResult += "new";
        break;
    case oox::XML_old:
        sResult += "old";
        break;
    case oox::XML_proxy:
        sResult += "proxy";
        break;
    case oox::XML_how:
        sResult += "how";
        break;
    case oox::XML_idref:
        sResult += "idref";
        break;
    case oox::XML_end:
        sResult += "end";
        break;
    case oox::XML_connectloc:
        sResult += "connectloc";
        break;
    case oox::XML_relationtable:
        sResult += "relationtable";
        break;
    case oox::XML_dgmstyle:
        sResult += "dgmstyle";
        break;
    case oox::XML_autoformat:
        sResult += "autoformat";
        break;
    case oox::XML_reverse:
        sResult += "reverse";
        break;
    case oox::XML_autolayout:
        sResult += "autolayout";
        break;
    case oox::XML_dgmscalex:
        sResult += "dgmscalex";
        break;
    case oox::XML_dgmscaley:
        sResult += "dgmscaley";
        break;
    case oox::XML_dgmfontsize:
        sResult += "dgmfontsize";
        break;
    case oox::XML_constrainbounds:
        sResult += "constrainbounds";
        break;
    case oox::XML_dgmbasetextscale:
        sResult += "dgmbasetextscale";
        break;
    case oox::XML_rel:
        sResult += "rel";
        break;
    case oox::XML_idsrc:
        sResult += "idsrc";
        break;
    case oox::XML_iddest:
        sResult += "iddest";
        break;
    case oox::XML_idcntr:
        sResult += "idcntr";
        break;
    case oox::XML_shadowcolor:
        sResult += "shadowcolor";
        break;
    case oox::XML_extrusioncolor:
        sResult += "extrusioncolor";
        break;
    case oox::XML_OLEObject:
        sResult += "OLEObject";
        break;
    case oox::XML_render:
        sResult += "render";
        break;
    case oox::XML_viewpointorigin:
        sResult += "viewpointorigin";
        break;
    case oox::XML_viewpoint:
        sResult += "viewpoint";
        break;
    case oox::XML_plane:
        sResult += "plane";
        break;
    case oox::XML_skewangle:
        sResult += "skewangle";
        break;
    case oox::XML_skewamt:
        sResult += "skewamt";
        break;
    case oox::XML_foredepth:
        sResult += "foredepth";
        break;
    case oox::XML_backdepth:
        sResult += "backdepth";
        break;
    case oox::XML_orientation:
        sResult += "orientation";
        break;
    case oox::XML_orientationangle:
        sResult += "orientationangle";
        break;
    case oox::XML_lockrotationcenter:
        sResult += "lockrotationcenter";
        break;
    case oox::XML_autorotationcenter:
        sResult += "autorotationcenter";
        break;
    case oox::XML_rotationcenter:
        sResult += "rotationcenter";
        break;
    case oox::XML_rotationangle:
        sResult += "rotationangle";
        break;
    case oox::XML_colormode:
        sResult += "colormode";
        break;
    case oox::XML_shininess:
        sResult += "shininess";
        break;
    case oox::XML_specularity:
        sResult += "specularity";
        break;
    case oox::XML_diffusity:
        sResult += "diffusity";
        break;
    case oox::XML_metal:
        sResult += "metal";
        break;
    case oox::XML_edge:
        sResult += "edge";
        break;
    case oox::XML_facet:
        sResult += "facet";
        break;
    case oox::XML_lightface:
        sResult += "lightface";
        break;
    case oox::XML_brightness:
        sResult += "brightness";
        break;
    case oox::XML_lightposition:
        sResult += "lightposition";
        break;
    case oox::XML_lightlevel:
        sResult += "lightlevel";
        break;
    case oox::XML_lightharsh:
        sResult += "lightharsh";
        break;
    case oox::XML_lightposition2:
        sResult += "lightposition2";
        break;
    case oox::XML_lightlevel2:
        sResult += "lightlevel2";
        break;
    case oox::XML_lightharsh2:
        sResult += "lightharsh2";
        break;
    case oox::XML_gap:
        sResult += "gap";
        break;
    case oox::XML_dropauto:
        sResult += "dropauto";
        break;
    case oox::XML_drop:
        sResult += "drop";
        break;
    case oox::XML_distance:
        sResult += "distance";
        break;
    case oox::XML_lengthspecified:
        sResult += "lengthspecified";
        break;
    case oox::XML_length:
        sResult += "length";
        break;
    case oox::XML_accentbar:
        sResult += "accentbar";
        break;
    case oox::XML_textborder:
        sResult += "textborder";
        break;
    case oox::XML_minusx:
        sResult += "minusx";
        break;
    case oox::XML_minusy:
        sResult += "minusy";
        break;
    case oox::XML_selection:
        sResult += "selection";
        break;
    case oox::XML_grouping:
        sResult += "grouping";
        break;
    case oox::XML_ungrouping:
        sResult += "ungrouping";
        break;
    case oox::XML_rotation:
        sResult += "rotation";
        break;
    case oox::XML_cropping:
        sResult += "cropping";
        break;
    case oox::XML_verticies:
        sResult += "verticies";
        break;
    case oox::XML_adjusthandles:
        sResult += "adjusthandles";
        break;
    case oox::XML_text:
        sResult += "text";
        break;
    case oox::XML_aspectratio:
        sResult += "aspectratio";
        break;
    case oox::XML_LinkType:
        sResult += "LinkType";
        break;
    case oox::XML_LockedField:
        sResult += "LockedField";
        break;
    case oox::XML_FieldCodes:
        sResult += "FieldCodes";
        break;
    case oox::XML_Type:
        sResult += "Type";
        break;
    case oox::XML_ProgID:
        sResult += "ProgID";
        break;
    case oox::XML_ShapeID:
        sResult += "ShapeID";
        break;
    case oox::XML_DrawAspect:
        sResult += "DrawAspect";
        break;
    case oox::XML_ObjectID:
        sResult += "ObjectID";
        break;
    case oox::XML_UpdateMode:
        sResult += "UpdateMode";
        break;
    case oox::XML_width:
        sResult += "width";
        break;
    case oox::XML_side:
        sResult += "side";
        break;
    case oox::XML_anchorx:
        sResult += "anchorx";
        break;
    case oox::XML_anchory:
        sResult += "anchory";
        break;
    case oox::XML_themeColor:
        sResult += "themeColor";
        break;
    case oox::XML_themeTint:
        sResult += "themeTint";
        break;
    case oox::XML_themeShade:
        sResult += "themeShade";
        break;
    case oox::XML_frame:
        sResult += "frame";
        break;
    case oox::XML_themeFill:
        sResult += "themeFill";
        break;
    case oox::XML_themeFillTint:
        sResult += "themeFillTint";
        break;
    case oox::XML_themeFillShade:
        sResult += "themeFillShade";
        break;
    case oox::XML_eastAsia:
        sResult += "eastAsia";
        break;
    case oox::XML_bidi:
        sResult += "bidi";
        break;
    case oox::XML_combine:
        sResult += "combine";
        break;
    case oox::XML_combineBrackets:
        sResult += "combineBrackets";
        break;
    case oox::XML_vert:
        sResult += "vert";
        break;
    case oox::XML_vertCompress:
        sResult += "vertCompress";
        break;
    case oox::XML_dropCap:
        sResult += "dropCap";
        break;
    case oox::XML_lines:
        sResult += "lines";
        break;
    case oox::XML_vSpace:
        sResult += "vSpace";
        break;
    case oox::XML_hSpace:
        sResult += "hSpace";
        break;
    case oox::XML_hAnchor:
        sResult += "hAnchor";
        break;
    case oox::XML_vAnchor:
        sResult += "vAnchor";
        break;
    case oox::XML_xAlign:
        sResult += "xAlign";
        break;
    case oox::XML_yAlign:
        sResult += "yAlign";
        break;
    case oox::XML_hRule:
        sResult += "hRule";
        break;
    case oox::XML_anchorLock:
        sResult += "anchorLock";
        break;
    case oox::XML_leader:
        sResult += "leader";
        break;
    case oox::XML_before:
        sResult += "before";
        break;
    case oox::XML_beforeLines:
        sResult += "beforeLines";
        break;
    case oox::XML_beforeAutospacing:
        sResult += "beforeAutospacing";
        break;
    case oox::XML_after:
        sResult += "after";
        break;
    case oox::XML_afterLines:
        sResult += "afterLines";
        break;
    case oox::XML_afterAutospacing:
        sResult += "afterAutospacing";
        break;
    case oox::XML_lineRule:
        sResult += "lineRule";
        break;
    case oox::XML_endChars:
        sResult += "endChars";
        break;
    case oox::XML_startChars:
        sResult += "startChars";
        break;
    case oox::XML_leftChars:
        sResult += "leftChars";
        break;
    case oox::XML_rightChars:
        sResult += "rightChars";
        break;
    case oox::XML_hanging:
        sResult += "hanging";
        break;
    case oox::XML_hangingChars:
        sResult += "hangingChars";
        break;
    case oox::XML_firstLine:
        sResult += "firstLine";
        break;
    case oox::XML_firstLineChars:
        sResult += "firstLineChars";
        break;
    case oox::XML_percent:
        sResult += "percent";
        break;
    case oox::XML_vendorID:
        sResult += "vendorID";
        break;
    case oox::XML_dllVersion:
        sResult += "dllVersion";
        break;
    case oox::XML_nlCheck:
        sResult += "nlCheck";
        break;
    case oox::XML_checkStyle:
        sResult += "checkStyle";
        break;
    case oox::XML_appName:
        sResult += "appName";
        break;
    case oox::XML_spelling:
        sResult += "spelling";
        break;
    case oox::XML_grammar:
        sResult += "grammar";
        break;
    case oox::XML_cryptProviderType:
        sResult += "cryptProviderType";
        break;
    case oox::XML_cryptAlgorithmClass:
        sResult += "cryptAlgorithmClass";
        break;
    case oox::XML_cryptAlgorithmType:
        sResult += "cryptAlgorithmType";
        break;
    case oox::XML_cryptAlgorithmSid:
        sResult += "cryptAlgorithmSid";
        break;
    case oox::XML_cryptSpinCount:
        sResult += "cryptSpinCount";
        break;
    case oox::XML_cryptProvider:
        sResult += "cryptProvider";
        break;
    case oox::XML_algIdExt:
        sResult += "algIdExt";
        break;
    case oox::XML_algIdExtSource:
        sResult += "algIdExtSource";
        break;
    case oox::XML_cryptProviderTypeExt:
        sResult += "cryptProviderTypeExt";
        break;
    case oox::XML_cryptProviderTypeExtSource:
        sResult += "cryptProviderTypeExtSource";
        break;
    case oox::XML_hash:
        sResult += "hash";
        break;
    case oox::XML_salt:
        sResult += "salt";
        break;
    case oox::XML_edit:
        sResult += "edit";
        break;
    case oox::XML_formatting:
        sResult += "formatting";
        break;
    case oox::XML_enforcement:
        sResult += "enforcement";
        break;
    case oox::XML_markup:
        sResult += "markup";
        break;
    case oox::XML_comments:
        sResult += "comments";
        break;
    case oox::XML_insDel:
        sResult += "insDel";
        break;
    case oox::XML_inkAnnotations:
        sResult += "inkAnnotations";
        break;
    case oox::XML_author:
        sResult += "author";
        break;
    case oox::XML_date:
        sResult += "date";
        break;
    case oox::XML_vMerge:
        sResult += "vMerge";
        break;
    case oox::XML_vMergeOrig:
        sResult += "vMergeOrig";
        break;
    case oox::XML_displacedByCustomXml:
        sResult += "displacedByCustomXml";
        break;
    case oox::XML_colFirst:
        sResult += "colFirst";
        break;
    case oox::XML_colLast:
        sResult += "colLast";
        break;
    case oox::XML_initials:
        sResult += "initials";
        break;
    case oox::XML_ed:
        sResult += "ed";
        break;
    case oox::XML_edGrp:
        sResult += "edGrp";
        break;
    case oox::XML_original:
        sResult += "original";
        break;
    case oox::XML_tblPrEx:
        sResult += "tblPrEx";
        break;
    case oox::XML_tcPr:
        sResult += "tcPr";
        break;
    case oox::XML_trPr:
        sResult += "trPr";
        break;
    case oox::XML_tblGrid:
        sResult += "tblGrid";
        break;
    case oox::XML_tblPr:
        sResult += "tblPr";
        break;
    case oox::XML_sectPr:
        sResult += "sectPr";
        break;
    case oox::XML_pPr:
        sResult += "pPr";
        break;
    case oox::XML_cellIns:
        sResult += "cellIns";
        break;
    case oox::XML_cellDel:
        sResult += "cellDel";
        break;
    case oox::XML_cellMerge:
        sResult += "cellMerge";
        break;
    case oox::XML_bookmarkStart:
        sResult += "bookmarkStart";
        break;
    case oox::XML_bookmarkEnd:
        sResult += "bookmarkEnd";
        break;
    case oox::XML_permStart:
        sResult += "permStart";
        break;
    case oox::XML_permEnd:
        sResult += "permEnd";
        break;
    case oox::XML_moveFromRangeStart:
        sResult += "moveFromRangeStart";
        break;
    case oox::XML_moveFromRangeEnd:
        sResult += "moveFromRangeEnd";
        break;
    case oox::XML_moveToRangeStart:
        sResult += "moveToRangeStart";
        break;
    case oox::XML_moveToRangeEnd:
        sResult += "moveToRangeEnd";
        break;
    case oox::XML_commentRangeStart:
        sResult += "commentRangeStart";
        break;
    case oox::XML_commentRangeEnd:
        sResult += "commentRangeEnd";
        break;
    case oox::XML_customXmlInsRangeStart:
        sResult += "customXmlInsRangeStart";
        break;
    case oox::XML_customXmlInsRangeEnd:
        sResult += "customXmlInsRangeEnd";
        break;
    case oox::XML_customXmlDelRangeStart:
        sResult += "customXmlDelRangeStart";
        break;
    case oox::XML_customXmlDelRangeEnd:
        sResult += "customXmlDelRangeEnd";
        break;
    case oox::XML_customXmlMoveFromRangeStart:
        sResult += "customXmlMoveFromRangeStart";
        break;
    case oox::XML_customXmlMoveFromRangeEnd:
        sResult += "customXmlMoveFromRangeEnd";
        break;
    case oox::XML_customXmlMoveToRangeStart:
        sResult += "customXmlMoveToRangeStart";
        break;
    case oox::XML_customXmlMoveToRangeEnd:
        sResult += "customXmlMoveToRangeEnd";
        break;
    case oox::XML_ilvl:
        sResult += "ilvl";
        break;
    case oox::XML_numId:
        sResult += "numId";
        break;
    case oox::XML_numberingChange:
        sResult += "numberingChange";
        break;
    case oox::XML_ins:
        sResult += "ins";
        break;
    case oox::XML_between:
        sResult += "between";
        break;
    case oox::XML_tab:
        sResult += "tab";
        break;
    case oox::XML_pStyle:
        sResult += "pStyle";
        break;
    case oox::XML_keepNext:
        sResult += "keepNext";
        break;
    case oox::XML_keepLines:
        sResult += "keepLines";
        break;
    case oox::XML_pageBreakBefore:
        sResult += "pageBreakBefore";
        break;
    case oox::XML_framePr:
        sResult += "framePr";
        break;
    case oox::XML_widowControl:
        sResult += "widowControl";
        break;
    case oox::XML_numPr:
        sResult += "numPr";
        break;
    case oox::XML_suppressLineNumbers:
        sResult += "suppressLineNumbers";
        break;
    case oox::XML_pBdr:
        sResult += "pBdr";
        break;
    case oox::XML_shd:
        sResult += "shd";
        break;
    case oox::XML_tabs:
        sResult += "tabs";
        break;
    case oox::XML_suppressAutoHyphens:
        sResult += "suppressAutoHyphens";
        break;
    case oox::XML_kinsoku:
        sResult += "kinsoku";
        break;
    case oox::XML_wordWrap:
        sResult += "wordWrap";
        break;
    case oox::XML_overflowPunct:
        sResult += "overflowPunct";
        break;
    case oox::XML_topLinePunct:
        sResult += "topLinePunct";
        break;
    case oox::XML_autoSpaceDE:
        sResult += "autoSpaceDE";
        break;
    case oox::XML_autoSpaceDN:
        sResult += "autoSpaceDN";
        break;
    case oox::XML_adjustRightInd:
        sResult += "adjustRightInd";
        break;
    case oox::XML_snapToGrid:
        sResult += "snapToGrid";
        break;
    case oox::XML_spacing:
        sResult += "spacing";
        break;
    case oox::XML_ind:
        sResult += "ind";
        break;
    case oox::XML_contextualSpacing:
        sResult += "contextualSpacing";
        break;
    case oox::XML_mirrorIndents:
        sResult += "mirrorIndents";
        break;
    case oox::XML_suppressOverlap:
        sResult += "suppressOverlap";
        break;
    case oox::XML_textDirection:
        sResult += "textDirection";
        break;
    case oox::XML_textAlignment:
        sResult += "textAlignment";
        break;
    case oox::XML_textboxTightWrap:
        sResult += "textboxTightWrap";
        break;
    case oox::XML_outlineLvl:
        sResult += "outlineLvl";
        break;
    case oox::XML_divId:
        sResult += "divId";
        break;
    case oox::XML_cnfStyle:
        sResult += "cnfStyle";
        break;
    case oox::XML_pPrChange:
        sResult += "pPrChange";
        break;
    case oox::XML_dxaOrig:
        sResult += "dxaOrig";
        break;
    case oox::XML_dyaOrig:
        sResult += "dyaOrig";
        break;
    case oox::XML_fldData:
        sResult += "fldData";
        break;
    case oox::XML_instr:
        sResult += "instr";
        break;
    case oox::XML_fldLock:
        sResult += "fldLock";
        break;
    case oox::XML_ffData:
        sResult += "ffData";
        break;
    case oox::XML_fldCharType:
        sResult += "fldCharType";
        break;
    case oox::XML_docLocation:
        sResult += "docLocation";
        break;
    case oox::XML_enabled:
        sResult += "enabled";
        break;
    case oox::XML_calcOnExit:
        sResult += "calcOnExit";
        break;
    case oox::XML_entryMacro:
        sResult += "entryMacro";
        break;
    case oox::XML_exitMacro:
        sResult += "exitMacro";
        break;
    case oox::XML_helpText:
        sResult += "helpText";
        break;
    case oox::XML_statusText:
        sResult += "statusText";
        break;
    case oox::XML_checkBox:
        sResult += "checkBox";
        break;
    case oox::XML_ddList:
        sResult += "ddList";
        break;
    case oox::XML_textInput:
        sResult += "textInput";
        break;
    case oox::XML_sizeAuto:
        sResult += "sizeAuto";
        break;
    case oox::XML_default:
        sResult += "default";
        break;
    case oox::XML_result:
        sResult += "result";
        break;
    case oox::XML_listEntry:
        sResult += "listEntry";
        break;
    case oox::XML_maxLength:
        sResult += "maxLength";
        break;
    case oox::XML_format:
        sResult += "format";
        break;
    case oox::XML_first:
        sResult += "first";
        break;
    case oox::XML_other:
        sResult += "other";
        break;
    case oox::XML_orient:
        sResult += "orient";
        break;
    case oox::XML_code:
        sResult += "code";
        break;
    case oox::XML_header:
        sResult += "header";
        break;
    case oox::XML_footer:
        sResult += "footer";
        break;
    case oox::XML_gutter:
        sResult += "gutter";
        break;
    case oox::XML_zOrder:
        sResult += "zOrder";
        break;
    case oox::XML_display:
        sResult += "display";
        break;
    case oox::XML_offsetFrom:
        sResult += "offsetFrom";
        break;
    case oox::XML_countBy:
        sResult += "countBy";
        break;
    case oox::XML_restart:
        sResult += "restart";
        break;
    case oox::XML_fmt:
        sResult += "fmt";
        break;
    case oox::XML_chapStyle:
        sResult += "chapStyle";
        break;
    case oox::XML_chapSep:
        sResult += "chapSep";
        break;
    case oox::XML_col:
        sResult += "col";
        break;
    case oox::XML_equalWidth:
        sResult += "equalWidth";
        break;
    case oox::XML_sep:
        sResult += "sep";
        break;
    case oox::XML_linePitch:
        sResult += "linePitch";
        break;
    case oox::XML_charSpace:
        sResult += "charSpace";
        break;
    case oox::XML_headerReference:
        sResult += "headerReference";
        break;
    case oox::XML_footerReference:
        sResult += "footerReference";
        break;
    case oox::XML_footnotePr:
        sResult += "footnotePr";
        break;
    case oox::XML_endnotePr:
        sResult += "endnotePr";
        break;
    case oox::XML_pgSz:
        sResult += "pgSz";
        break;
    case oox::XML_pgMar:
        sResult += "pgMar";
        break;
    case oox::XML_paperSrc:
        sResult += "paperSrc";
        break;
    case oox::XML_pgBorders:
        sResult += "pgBorders";
        break;
    case oox::XML_lnNumType:
        sResult += "lnNumType";
        break;
    case oox::XML_pgNumType:
        sResult += "pgNumType";
        break;
    case oox::XML_cols:
        sResult += "cols";
        break;
    case oox::XML_formProt:
        sResult += "formProt";
        break;
    case oox::XML_vAlign:
        sResult += "vAlign";
        break;
    case oox::XML_noEndnote:
        sResult += "noEndnote";
        break;
    case oox::XML_titlePg:
        sResult += "titlePg";
        break;
    case oox::XML_rtlGutter:
        sResult += "rtlGutter";
        break;
    case oox::XML_docGrid:
        sResult += "docGrid";
        break;
    case oox::XML_printerSettings:
        sResult += "printerSettings";
        break;
    case oox::XML_rsidRPr:
        sResult += "rsidRPr";
        break;
    case oox::XML_rsidDel:
        sResult += "rsidDel";
        break;
    case oox::XML_rsidR:
        sResult += "rsidR";
        break;
    case oox::XML_rsidSect:
        sResult += "rsidSect";
        break;
    case oox::XML_sectPrChange:
        sResult += "sectPrChange";
        break;
    case oox::XML_clear:
        sResult += "clear";
        break;
    case oox::XML_alignment:
        sResult += "alignment";
        break;
    case oox::XML_relativeTo:
        sResult += "relativeTo";
        break;
    case oox::XML_char:
        sResult += "char";
        break;
    case oox::XML_br:
        sResult += "br";
        break;
    case oox::XML_delText:
        sResult += "delText";
        break;
    case oox::XML_instrText:
        sResult += "instrText";
        break;
    case oox::XML_delInstrText:
        sResult += "delInstrText";
        break;
    case oox::XML_noBreakHyphen:
        sResult += "noBreakHyphen";
        break;
    case oox::XML_softHyphen:
        sResult += "softHyphen";
        break;
    case oox::XML_dayShort:
        sResult += "dayShort";
        break;
    case oox::XML_monthShort:
        sResult += "monthShort";
        break;
    case oox::XML_yearShort:
        sResult += "yearShort";
        break;
    case oox::XML_dayLong:
        sResult += "dayLong";
        break;
    case oox::XML_monthLong:
        sResult += "monthLong";
        break;
    case oox::XML_yearLong:
        sResult += "yearLong";
        break;
    case oox::XML_annotationRef:
        sResult += "annotationRef";
        break;
    case oox::XML_footnoteRef:
        sResult += "footnoteRef";
        break;
    case oox::XML_endnoteRef:
        sResult += "endnoteRef";
        break;
    case oox::XML_separator:
        sResult += "separator";
        break;
    case oox::XML_continuationSeparator:
        sResult += "continuationSeparator";
        break;
    case oox::XML_pgNum:
        sResult += "pgNum";
        break;
    case oox::XML_cr:
        sResult += "cr";
        break;
    case oox::XML_object:
        sResult += "object";
        break;
    case oox::XML_fldChar:
        sResult += "fldChar";
        break;
    case oox::XML_ruby:
        sResult += "ruby";
        break;
    case oox::XML_footnoteReference:
        sResult += "footnoteReference";
        break;
    case oox::XML_endnoteReference:
        sResult += "endnoteReference";
        break;
    case oox::XML_commentReference:
        sResult += "commentReference";
        break;
    case oox::XML_drawing:
        sResult += "drawing";
        break;
    case oox::XML_ptab:
        sResult += "ptab";
        break;
    case oox::XML_lastRenderedPageBreak:
        sResult += "lastRenderedPageBreak";
        break;
    case oox::XML_hint:
        sResult += "hint";
        break;
    case oox::XML_ascii:
        sResult += "ascii";
        break;
    case oox::XML_hAnsi:
        sResult += "hAnsi";
        break;
    case oox::XML_asciiTheme:
        sResult += "asciiTheme";
        break;
    case oox::XML_hAnsiTheme:
        sResult += "hAnsiTheme";
        break;
    case oox::XML_eastAsiaTheme:
        sResult += "eastAsiaTheme";
        break;
    case oox::XML_cstheme:
        sResult += "cstheme";
        break;
    case oox::XML_rStyle:
        sResult += "rStyle";
        break;
    case oox::XML_rFonts:
        sResult += "rFonts";
        break;
    case oox::XML_bCs:
        sResult += "bCs";
        break;
    case oox::XML_iCs:
        sResult += "iCs";
        break;
    case oox::XML_caps:
        sResult += "caps";
        break;
    case oox::XML_smallCaps:
        sResult += "smallCaps";
        break;
    case oox::XML_dstrike:
        sResult += "dstrike";
        break;
    case oox::XML_outline:
        sResult += "outline";
        break;
    case oox::XML_emboss:
        sResult += "emboss";
        break;
    case oox::XML_imprint:
        sResult += "imprint";
        break;
    case oox::XML_vanish:
        sResult += "vanish";
        break;
    case oox::XML_webHidden:
        sResult += "webHidden";
        break;
    case oox::XML_szCs:
        sResult += "szCs";
        break;
    case oox::XML_bdr:
        sResult += "bdr";
        break;
    case oox::XML_fitText:
        sResult += "fitText";
        break;
    case oox::XML_vertAlign:
        sResult += "vertAlign";
        break;
    case oox::XML_rtl:
        sResult += "rtl";
        break;
    case oox::XML_em:
        sResult += "em";
        break;
    case oox::XML_eastAsianLayout:
        sResult += "eastAsianLayout";
        break;
    case oox::XML_specVanish:
        sResult += "specVanish";
        break;
    case oox::XML_rPrChange:
        sResult += "rPrChange";
        break;
    case oox::XML_del:
        sResult += "del";
        break;
    case oox::XML_moveFrom:
        sResult += "moveFrom";
        break;
    case oox::XML_altChunkPr:
        sResult += "altChunkPr";
        break;
    case oox::XML_matchSrc:
        sResult += "matchSrc";
        break;
    case oox::XML_rubyAlign:
        sResult += "rubyAlign";
        break;
    case oox::XML_hps:
        sResult += "hps";
        break;
    case oox::XML_hpsRaise:
        sResult += "hpsRaise";
        break;
    case oox::XML_hpsBaseText:
        sResult += "hpsBaseText";
        break;
    case oox::XML_lid:
        sResult += "lid";
        break;
    case oox::XML_rubyPr:
        sResult += "rubyPr";
        break;
    case oox::XML_rt:
        sResult += "rt";
        break;
    case oox::XML_rubyBase:
        sResult += "rubyBase";
        break;
    case oox::XML_displayText:
        sResult += "displayText";
        break;
    case oox::XML_value:
        sResult += "value";
        break;
    case oox::XML_dateFormat:
        sResult += "dateFormat";
        break;
    case oox::XML_storeMappedDataAs:
        sResult += "storeMappedDataAs";
        break;
    case oox::XML_calendar:
        sResult += "calendar";
        break;
    case oox::XML_fullDate:
        sResult += "fullDate";
        break;
    case oox::XML_docPartGallery:
        sResult += "docPartGallery";
        break;
    case oox::XML_docPartCategory:
        sResult += "docPartCategory";
        break;
    case oox::XML_docPartUnique:
        sResult += "docPartUnique";
        break;
    case oox::XML_listItem:
        sResult += "listItem";
        break;
    case oox::XML_lastValue:
        sResult += "lastValue";
        break;
    case oox::XML_docPart:
        sResult += "docPart";
        break;
    case oox::XML_multiLine:
        sResult += "multiLine";
        break;
    case oox::XML_prefixMappings:
        sResult += "prefixMappings";
        break;
    case oox::XML_xpath:
        sResult += "xpath";
        break;
    case oox::XML_storeItemID:
        sResult += "storeItemID";
        break;
    case oox::XML_alias:
        sResult += "alias";
        break;
    case oox::XML_placeholder:
        sResult += "placeholder";
        break;
    case oox::XML_showingPlcHdr:
        sResult += "showingPlcHdr";
        break;
    case oox::XML_dataBinding:
        sResult += "dataBinding";
        break;
    case oox::XML_temporary:
        sResult += "temporary";
        break;
    case oox::XML_tabIndex:
        sResult += "tabIndex";
        break;
    case oox::XML_tag:
        sResult += "tag";
        break;
    case oox::XML_equation:
        sResult += "equation";
        break;
    case oox::XML_comboBox:
        sResult += "comboBox";
        break;
    case oox::XML_checkbox:
        sResult += "checkbox";
        break;
    case oox::XML_docPartObj:
        sResult += "docPartObj";
        break;
    case oox::XML_docPartList:
        sResult += "docPartList";
        break;
    case oox::XML_dropDownList:
        sResult += "dropDownList";
        break;
    case oox::XML_picture:
        sResult += "picture";
        break;
    case oox::XML_richText:
        sResult += "richText";
        break;
    case oox::XML_citation:
        sResult += "citation";
        break;
    case oox::XML_bibliography:
        sResult += "bibliography";
        break;
    case oox::XML_appearance:
        sResult += "appearance";
        break;
    case oox::XML_customXml:
        sResult += "customXml";
        break;
    case oox::XML_smartTag:
        sResult += "smartTag";
        break;
    case oox::XML_sdt:
        sResult += "sdt";
        break;
    case oox::XML_p:
        sResult += "p";
        break;
    case oox::XML_tbl:
        sResult += "tbl";
        break;
    case oox::XML_tr:
        sResult += "tr";
        break;
    case oox::XML_tc:
        sResult += "tc";
        break;
    case oox::XML_sdtPr:
        sResult += "sdtPr";
        break;
    case oox::XML_sdtEndPr:
        sResult += "sdtEndPr";
        break;
    case oox::XML_sdtContent:
        sResult += "sdtContent";
        break;
    case oox::XML_customXmlPr:
        sResult += "customXmlPr";
        break;
    case oox::XML_element:
        sResult += "element";
        break;
    case oox::XML_smartTagPr:
        sResult += "smartTagPr";
        break;
    case oox::XML_attr:
        sResult += "attr";
        break;
    case oox::XML_fldSimple:
        sResult += "fldSimple";
        break;
    case oox::XML_hyperlink:
        sResult += "hyperlink";
        break;
    case oox::XML_subDoc:
        sResult += "subDoc";
        break;
    case oox::XML_rsidP:
        sResult += "rsidP";
        break;
    case oox::XML_rsidRDefault:
        sResult += "rsidRDefault";
        break;
    case oox::XML_gridCol:
        sResult += "gridCol";
        break;
    case oox::XML_tblGridChange:
        sResult += "tblGridChange";
        break;
    case oox::XML_insideH:
        sResult += "insideH";
        break;
    case oox::XML_insideV:
        sResult += "insideV";
        break;
    case oox::XML_tl2br:
        sResult += "tl2br";
        break;
    case oox::XML_tr2bl:
        sResult += "tr2bl";
        break;
    case oox::XML_tcW:
        sResult += "tcW";
        break;
    case oox::XML_gridSpan:
        sResult += "gridSpan";
        break;
    case oox::XML_hMerge:
        sResult += "hMerge";
        break;
    case oox::XML_tcBorders:
        sResult += "tcBorders";
        break;
    case oox::XML_noWrap:
        sResult += "noWrap";
        break;
    case oox::XML_tcMar:
        sResult += "tcMar";
        break;
    case oox::XML_tcFitText:
        sResult += "tcFitText";
        break;
    case oox::XML_hideMark:
        sResult += "hideMark";
        break;
    case oox::XML_tcPrChange:
        sResult += "tcPrChange";
        break;
    case oox::XML_firstRow:
        sResult += "firstRow";
        break;
    case oox::XML_lastRow:
        sResult += "lastRow";
        break;
    case oox::XML_firstColumn:
        sResult += "firstColumn";
        break;
    case oox::XML_lastColumn:
        sResult += "lastColumn";
        break;
    case oox::XML_oddVBand:
        sResult += "oddVBand";
        break;
    case oox::XML_evenVBand:
        sResult += "evenVBand";
        break;
    case oox::XML_oddHBand:
        sResult += "oddHBand";
        break;
    case oox::XML_evenHBand:
        sResult += "evenHBand";
        break;
    case oox::XML_firstRowFirstColumn:
        sResult += "firstRowFirstColumn";
        break;
    case oox::XML_firstRowLastColumn:
        sResult += "firstRowLastColumn";
        break;
    case oox::XML_lastRowFirstColumn:
        sResult += "lastRowFirstColumn";
        break;
    case oox::XML_lastRowLastColumn:
        sResult += "lastRowLastColumn";
        break;
    case oox::XML_gridBefore:
        sResult += "gridBefore";
        break;
    case oox::XML_gridAfter:
        sResult += "gridAfter";
        break;
    case oox::XML_wBefore:
        sResult += "wBefore";
        break;
    case oox::XML_wAfter:
        sResult += "wAfter";
        break;
    case oox::XML_cantSplit:
        sResult += "cantSplit";
        break;
    case oox::XML_trHeight:
        sResult += "trHeight";
        break;
    case oox::XML_tblHeader:
        sResult += "tblHeader";
        break;
    case oox::XML_tblCellSpacing:
        sResult += "tblCellSpacing";
        break;
    case oox::XML_trPrChange:
        sResult += "trPrChange";
        break;
    case oox::XML_rsidTr:
        sResult += "rsidTr";
        break;
    case oox::XML_leftFromText:
        sResult += "leftFromText";
        break;
    case oox::XML_rightFromText:
        sResult += "rightFromText";
        break;
    case oox::XML_topFromText:
        sResult += "topFromText";
        break;
    case oox::XML_bottomFromText:
        sResult += "bottomFromText";
        break;
    case oox::XML_vertAnchor:
        sResult += "vertAnchor";
        break;
    case oox::XML_horzAnchor:
        sResult += "horzAnchor";
        break;
    case oox::XML_tblpXSpec:
        sResult += "tblpXSpec";
        break;
    case oox::XML_tblpX:
        sResult += "tblpX";
        break;
    case oox::XML_tblpYSpec:
        sResult += "tblpYSpec";
        break;
    case oox::XML_tblpY:
        sResult += "tblpY";
        break;
    case oox::XML_tblStyle:
        sResult += "tblStyle";
        break;
    case oox::XML_tblpPr:
        sResult += "tblpPr";
        break;
    case oox::XML_tblOverlap:
        sResult += "tblOverlap";
        break;
    case oox::XML_bidiVisual:
        sResult += "bidiVisual";
        break;
    case oox::XML_tblStyleRowBandSize:
        sResult += "tblStyleRowBandSize";
        break;
    case oox::XML_tblStyleColBandSize:
        sResult += "tblStyleColBandSize";
        break;
    case oox::XML_tblW:
        sResult += "tblW";
        break;
    case oox::XML_tblInd:
        sResult += "tblInd";
        break;
    case oox::XML_tblBorders:
        sResult += "tblBorders";
        break;
    case oox::XML_tblLayout:
        sResult += "tblLayout";
        break;
    case oox::XML_tblCellMar:
        sResult += "tblCellMar";
        break;
    case oox::XML_tblLook:
        sResult += "tblLook";
        break;
    case oox::XML_tblCaption:
        sResult += "tblCaption";
        break;
    case oox::XML_tblDescription:
        sResult += "tblDescription";
        break;
    case oox::XML_tblPrChange:
        sResult += "tblPrChange";
        break;
    case oox::XML_tblPrExChange:
        sResult += "tblPrExChange";
        break;
    case oox::XML_noHBand:
        sResult += "noHBand";
        break;
    case oox::XML_noVBand:
        sResult += "noVBand";
        break;
    case oox::XML_customMarkFollows:
        sResult += "customMarkFollows";
        break;
    case oox::XML_numStart:
        sResult += "numStart";
        break;
    case oox::XML_numRestart:
        sResult += "numRestart";
        break;
    case oox::XML_numFmt:
        sResult += "numFmt";
        break;
    case oox::XML_footnote:
        sResult += "footnote";
        break;
    case oox::XML_endnote:
        sResult += "endnote";
        break;
    case oox::XML_active:
        sResult += "active";
        break;
    case oox::XML_uniqueTag:
        sResult += "uniqueTag";
        break;
    case oox::XML_recipientData:
        sResult += "recipientData";
        break;
    case oox::XML_recipients:
        sResult += "recipients";
        break;
    case oox::XML_mappedName:
        sResult += "mappedName";
        break;
    case oox::XML_dynamicAddress:
        sResult += "dynamicAddress";
        break;
    case oox::XML_udl:
        sResult += "udl";
        break;
    case oox::XML_table:
        sResult += "table";
        break;
    case oox::XML_colDelim:
        sResult += "colDelim";
        break;
    case oox::XML_fHdr:
        sResult += "fHdr";
        break;
    case oox::XML_fieldMapData:
        sResult += "fieldMapData";
        break;
    case oox::XML_mainDocumentType:
        sResult += "mainDocumentType";
        break;
    case oox::XML_linkToQuery:
        sResult += "linkToQuery";
        break;
    case oox::XML_dataType:
        sResult += "dataType";
        break;
    case oox::XML_connectString:
        sResult += "connectString";
        break;
    case oox::XML_query:
        sResult += "query";
        break;
    case oox::XML_dataSource:
        sResult += "dataSource";
        break;
    case oox::XML_headerSource:
        sResult += "headerSource";
        break;
    case oox::XML_doNotSuppressBlankLines:
        sResult += "doNotSuppressBlankLines";
        break;
    case oox::XML_destination:
        sResult += "destination";
        break;
    case oox::XML_addressFieldName:
        sResult += "addressFieldName";
        break;
    case oox::XML_mailSubject:
        sResult += "mailSubject";
        break;
    case oox::XML_mailAsAttachment:
        sResult += "mailAsAttachment";
        break;
    case oox::XML_viewMergedData:
        sResult += "viewMergedData";
        break;
    case oox::XML_activeRecord:
        sResult += "activeRecord";
        break;
    case oox::XML_checkErrors:
        sResult += "checkErrors";
        break;
    case oox::XML_odso:
        sResult += "odso";
        break;
    case oox::XML_useSingleBorderforContiguousCells:
        sResult += "useSingleBorderforContiguousCells";
        break;
    case oox::XML_wpJustification:
        sResult += "wpJustification";
        break;
    case oox::XML_noTabHangInd:
        sResult += "noTabHangInd";
        break;
    case oox::XML_noLeading:
        sResult += "noLeading";
        break;
    case oox::XML_spaceForUL:
        sResult += "spaceForUL";
        break;
    case oox::XML_noColumnBalance:
        sResult += "noColumnBalance";
        break;
    case oox::XML_balanceSingleByteDoubleByteWidth:
        sResult += "balanceSingleByteDoubleByteWidth";
        break;
    case oox::XML_noExtraLineSpacing:
        sResult += "noExtraLineSpacing";
        break;
    case oox::XML_doNotLeaveBackslashAlone:
        sResult += "doNotLeaveBackslashAlone";
        break;
    case oox::XML_ulTrailSpace:
        sResult += "ulTrailSpace";
        break;
    case oox::XML_doNotExpandShiftReturn:
        sResult += "doNotExpandShiftReturn";
        break;
    case oox::XML_spacingInWholePoints:
        sResult += "spacingInWholePoints";
        break;
    case oox::XML_lineWrapLikeWord6:
        sResult += "lineWrapLikeWord6";
        break;
    case oox::XML_printBodyTextBeforeHeader:
        sResult += "printBodyTextBeforeHeader";
        break;
    case oox::XML_printColBlack:
        sResult += "printColBlack";
        break;
    case oox::XML_wpSpaceWidth:
        sResult += "wpSpaceWidth";
        break;
    case oox::XML_showBreaksInFrames:
        sResult += "showBreaksInFrames";
        break;
    case oox::XML_subFontBySize:
        sResult += "subFontBySize";
        break;
    case oox::XML_suppressBottomSpacing:
        sResult += "suppressBottomSpacing";
        break;
    case oox::XML_suppressTopSpacing:
        sResult += "suppressTopSpacing";
        break;
    case oox::XML_suppressSpacingAtTopOfPage:
        sResult += "suppressSpacingAtTopOfPage";
        break;
    case oox::XML_suppressTopSpacingWP:
        sResult += "suppressTopSpacingWP";
        break;
    case oox::XML_suppressSpBfAfterPgBrk:
        sResult += "suppressSpBfAfterPgBrk";
        break;
    case oox::XML_swapBordersFacingPages:
        sResult += "swapBordersFacingPages";
        break;
    case oox::XML_convMailMergeEsc:
        sResult += "convMailMergeEsc";
        break;
    case oox::XML_truncateFontHeightsLikeWP6:
        sResult += "truncateFontHeightsLikeWP6";
        break;
    case oox::XML_mwSmallCaps:
        sResult += "mwSmallCaps";
        break;
    case oox::XML_usePrinterMetrics:
        sResult += "usePrinterMetrics";
        break;
    case oox::XML_doNotSuppressParagraphBorders:
        sResult += "doNotSuppressParagraphBorders";
        break;
    case oox::XML_wrapTrailSpaces:
        sResult += "wrapTrailSpaces";
        break;
    case oox::XML_footnoteLayoutLikeWW8:
        sResult += "footnoteLayoutLikeWW8";
        break;
    case oox::XML_shapeLayoutLikeWW8:
        sResult += "shapeLayoutLikeWW8";
        break;
    case oox::XML_alignTablesRowByRow:
        sResult += "alignTablesRowByRow";
        break;
    case oox::XML_forgetLastTabAlignment:
        sResult += "forgetLastTabAlignment";
        break;
    case oox::XML_adjustLineHeightInTable:
        sResult += "adjustLineHeightInTable";
        break;
    case oox::XML_autoSpaceLikeWord95:
        sResult += "autoSpaceLikeWord95";
        break;
    case oox::XML_noSpaceRaiseLower:
        sResult += "noSpaceRaiseLower";
        break;
    case oox::XML_doNotUseHTMLParagraphAutoSpacing:
        sResult += "doNotUseHTMLParagraphAutoSpacing";
        break;
    case oox::XML_layoutRawTableWidth:
        sResult += "layoutRawTableWidth";
        break;
    case oox::XML_layoutTableRowsApart:
        sResult += "layoutTableRowsApart";
        break;
    case oox::XML_useWord97LineBreakRules:
        sResult += "useWord97LineBreakRules";
        break;
    case oox::XML_doNotBreakWrappedTables:
        sResult += "doNotBreakWrappedTables";
        break;
    case oox::XML_doNotSnapToGridInCell:
        sResult += "doNotSnapToGridInCell";
        break;
    case oox::XML_selectFldWithFirstOrLastChar:
        sResult += "selectFldWithFirstOrLastChar";
        break;
    case oox::XML_applyBreakingRules:
        sResult += "applyBreakingRules";
        break;
    case oox::XML_doNotWrapTextWithPunct:
        sResult += "doNotWrapTextWithPunct";
        break;
    case oox::XML_doNotUseEastAsianBreakRules:
        sResult += "doNotUseEastAsianBreakRules";
        break;
    case oox::XML_useWord2002TableStyleRules:
        sResult += "useWord2002TableStyleRules";
        break;
    case oox::XML_growAutofit:
        sResult += "growAutofit";
        break;
    case oox::XML_useFELayout:
        sResult += "useFELayout";
        break;
    case oox::XML_useNormalStyleForList:
        sResult += "useNormalStyleForList";
        break;
    case oox::XML_doNotUseIndentAsNumberingTabStop:
        sResult += "doNotUseIndentAsNumberingTabStop";
        break;
    case oox::XML_useAltKinsokuLineBreakRules:
        sResult += "useAltKinsokuLineBreakRules";
        break;
    case oox::XML_allowSpaceOfSameStyleInTable:
        sResult += "allowSpaceOfSameStyleInTable";
        break;
    case oox::XML_doNotSuppressIndentation:
        sResult += "doNotSuppressIndentation";
        break;
    case oox::XML_doNotAutofitConstrainedTables:
        sResult += "doNotAutofitConstrainedTables";
        break;
    case oox::XML_autofitToFirstFixedWidthCell:
        sResult += "autofitToFirstFixedWidthCell";
        break;
    case oox::XML_underlineTabInNumList:
        sResult += "underlineTabInNumList";
        break;
    case oox::XML_displayHangulFixedWidth:
        sResult += "displayHangulFixedWidth";
        break;
    case oox::XML_splitPgBreakAndParaMark:
        sResult += "splitPgBreakAndParaMark";
        break;
    case oox::XML_doNotVertAlignCellWithSp:
        sResult += "doNotVertAlignCellWithSp";
        break;
    case oox::XML_doNotBreakConstrainedForcedTable:
        sResult += "doNotBreakConstrainedForcedTable";
        break;
    case oox::XML_doNotVertAlignInTxbx:
        sResult += "doNotVertAlignInTxbx";
        break;
    case oox::XML_useAnsiKerningPairs:
        sResult += "useAnsiKerningPairs";
        break;
    case oox::XML_cachedColBalance:
        sResult += "cachedColBalance";
        break;
    case oox::XML_compatSetting:
        sResult += "compatSetting";
        break;
    case oox::XML_docVar:
        sResult += "docVar";
        break;
    case oox::XML_rsidRoot:
        sResult += "rsidRoot";
        break;
    case oox::XML_rsid:
        sResult += "rsid";
        break;
    case oox::XML_solutionID:
        sResult += "solutionID";
        break;
    case oox::XML_rPrDefault:
        sResult += "rPrDefault";
        break;
    case oox::XML_pPrDefault:
        sResult += "pPrDefault";
        break;
    case oox::XML_t1:
        sResult += "t1";
        break;
    case oox::XML_t2:
        sResult += "t2";
        break;
    case oox::XML_followedHyperlink:
        sResult += "followedHyperlink";
        break;
    case oox::XML_actualPg:
        sResult += "actualPg";
        break;
    case oox::XML_fontSz:
        sResult += "fontSz";
        break;
    case oox::XML_recommended:
        sResult += "recommended";
        break;
    case oox::XML_writeProtection:
        sResult += "writeProtection";
        break;
    case oox::XML_view:
        sResult += "view";
        break;
    case oox::XML_linkStyles:
        sResult += "linkStyles";
        break;
    case oox::XML_removePersonalInformation:
        sResult += "removePersonalInformation";
        break;
    case oox::XML_removeDateAndTime:
        sResult += "removeDateAndTime";
        break;
    case oox::XML_doNotDisplayPageBoundaries:
        sResult += "doNotDisplayPageBoundaries";
        break;
    case oox::XML_displayBackgroundShape:
        sResult += "displayBackgroundShape";
        break;
    case oox::XML_printPostScriptOverText:
        sResult += "printPostScriptOverText";
        break;
    case oox::XML_printFractionalCharacterWidth:
        sResult += "printFractionalCharacterWidth";
        break;
    case oox::XML_printFormsData:
        sResult += "printFormsData";
        break;
    case oox::XML_embedTrueTypeFonts:
        sResult += "embedTrueTypeFonts";
        break;
    case oox::XML_embedSystemFonts:
        sResult += "embedSystemFonts";
        break;
    case oox::XML_saveSubsetFonts:
        sResult += "saveSubsetFonts";
        break;
    case oox::XML_saveFormsData:
        sResult += "saveFormsData";
        break;
    case oox::XML_mirrorMargins:
        sResult += "mirrorMargins";
        break;
    case oox::XML_alignBordersAndEdges:
        sResult += "alignBordersAndEdges";
        break;
    case oox::XML_bordersDoNotSurroundHeader:
        sResult += "bordersDoNotSurroundHeader";
        break;
    case oox::XML_bordersDoNotSurroundFooter:
        sResult += "bordersDoNotSurroundFooter";
        break;
    case oox::XML_gutterAtTop:
        sResult += "gutterAtTop";
        break;
    case oox::XML_hideSpellingErrors:
        sResult += "hideSpellingErrors";
        break;
    case oox::XML_hideGrammaticalErrors:
        sResult += "hideGrammaticalErrors";
        break;
    case oox::XML_activeWritingStyle:
        sResult += "activeWritingStyle";
        break;
    case oox::XML_proofState:
        sResult += "proofState";
        break;
    case oox::XML_formsDesign:
        sResult += "formsDesign";
        break;
    case oox::XML_attachedTemplate:
        sResult += "attachedTemplate";
        break;
    case oox::XML_stylePaneFormatFilter:
        sResult += "stylePaneFormatFilter";
        break;
    case oox::XML_stylePaneSortMethod:
        sResult += "stylePaneSortMethod";
        break;
    case oox::XML_documentType:
        sResult += "documentType";
        break;
    case oox::XML_mailMerge:
        sResult += "mailMerge";
        break;
    case oox::XML_revisionView:
        sResult += "revisionView";
        break;
    case oox::XML_trackRevisions:
        sResult += "trackRevisions";
        break;
    case oox::XML_doNotTrackMoves:
        sResult += "doNotTrackMoves";
        break;
    case oox::XML_doNotTrackFormatting:
        sResult += "doNotTrackFormatting";
        break;
    case oox::XML_documentProtection:
        sResult += "documentProtection";
        break;
    case oox::XML_autoFormatOverride:
        sResult += "autoFormatOverride";
        break;
    case oox::XML_styleLockTheme:
        sResult += "styleLockTheme";
        break;
    case oox::XML_styleLockQFSet:
        sResult += "styleLockQFSet";
        break;
    case oox::XML_defaultTabStop:
        sResult += "defaultTabStop";
        break;
    case oox::XML_autoHyphenation:
        sResult += "autoHyphenation";
        break;
    case oox::XML_consecutiveHyphenLimit:
        sResult += "consecutiveHyphenLimit";
        break;
    case oox::XML_hyphenationZone:
        sResult += "hyphenationZone";
        break;
    case oox::XML_doNotHyphenateCaps:
        sResult += "doNotHyphenateCaps";
        break;
    case oox::XML_showEnvelope:
        sResult += "showEnvelope";
        break;
    case oox::XML_summaryLength:
        sResult += "summaryLength";
        break;
    case oox::XML_clickAndTypeStyle:
        sResult += "clickAndTypeStyle";
        break;
    case oox::XML_defaultTableStyle:
        sResult += "defaultTableStyle";
        break;
    case oox::XML_evenAndOddHeaders:
        sResult += "evenAndOddHeaders";
        break;
    case oox::XML_bookFoldRevPrinting:
        sResult += "bookFoldRevPrinting";
        break;
    case oox::XML_bookFoldPrinting:
        sResult += "bookFoldPrinting";
        break;
    case oox::XML_bookFoldPrintingSheets:
        sResult += "bookFoldPrintingSheets";
        break;
    case oox::XML_drawingGridHorizontalSpacing:
        sResult += "drawingGridHorizontalSpacing";
        break;
    case oox::XML_drawingGridVerticalSpacing:
        sResult += "drawingGridVerticalSpacing";
        break;
    case oox::XML_displayHorizontalDrawingGridEvery:
        sResult += "displayHorizontalDrawingGridEvery";
        break;
    case oox::XML_displayVerticalDrawingGridEvery:
        sResult += "displayVerticalDrawingGridEvery";
        break;
    case oox::XML_doNotUseMarginsForDrawingGridOrigin:
        sResult += "doNotUseMarginsForDrawingGridOrigin";
        break;
    case oox::XML_drawingGridHorizontalOrigin:
        sResult += "drawingGridHorizontalOrigin";
        break;
    case oox::XML_drawingGridVerticalOrigin:
        sResult += "drawingGridVerticalOrigin";
        break;
    case oox::XML_doNotShadeFormData:
        sResult += "doNotShadeFormData";
        break;
    case oox::XML_noPunctuationKerning:
        sResult += "noPunctuationKerning";
        break;
    case oox::XML_characterSpacingControl:
        sResult += "characterSpacingControl";
        break;
    case oox::XML_printTwoOnOne:
        sResult += "printTwoOnOne";
        break;
    case oox::XML_strictFirstAndLastChars:
        sResult += "strictFirstAndLastChars";
        break;
    case oox::XML_noLineBreaksAfter:
        sResult += "noLineBreaksAfter";
        break;
    case oox::XML_noLineBreaksBefore:
        sResult += "noLineBreaksBefore";
        break;
    case oox::XML_savePreviewPicture:
        sResult += "savePreviewPicture";
        break;
    case oox::XML_doNotValidateAgainstSchema:
        sResult += "doNotValidateAgainstSchema";
        break;
    case oox::XML_saveInvalidXml:
        sResult += "saveInvalidXml";
        break;
    case oox::XML_ignoreMixedContent:
        sResult += "ignoreMixedContent";
        break;
    case oox::XML_alwaysShowPlaceholderText:
        sResult += "alwaysShowPlaceholderText";
        break;
    case oox::XML_doNotDemarcateInvalidXml:
        sResult += "doNotDemarcateInvalidXml";
        break;
    case oox::XML_saveXmlDataOnly:
        sResult += "saveXmlDataOnly";
        break;
    case oox::XML_useXSLTWhenSaving:
        sResult += "useXSLTWhenSaving";
        break;
    case oox::XML_saveThroughXslt:
        sResult += "saveThroughXslt";
        break;
    case oox::XML_showXMLTags:
        sResult += "showXMLTags";
        break;
    case oox::XML_alwaysMergeEmptyNamespace:
        sResult += "alwaysMergeEmptyNamespace";
        break;
    case oox::XML_updateFields:
        sResult += "updateFields";
        break;
    case oox::XML_hdrShapeDefaults:
        sResult += "hdrShapeDefaults";
        break;
    case oox::XML_compat:
        sResult += "compat";
        break;
    case oox::XML_docVars:
        sResult += "docVars";
        break;
    case oox::XML_rsids:
        sResult += "rsids";
        break;
    case oox::XML_uiCompat97To2003:
        sResult += "uiCompat97To2003";
        break;
    case oox::XML_attachedSchema:
        sResult += "attachedSchema";
        break;
    case oox::XML_themeFontLang:
        sResult += "themeFontLang";
        break;
    case oox::XML_clrSchemeMapping:
        sResult += "clrSchemeMapping";
        break;
    case oox::XML_doNotIncludeSubdocsInStats:
        sResult += "doNotIncludeSubdocsInStats";
        break;
    case oox::XML_doNotAutoCompressPictures:
        sResult += "doNotAutoCompressPictures";
        break;
    case oox::XML_forceUpgrade:
        sResult += "forceUpgrade";
        break;
    case oox::XML_captions:
        sResult += "captions";
        break;
    case oox::XML_readModeInkLockDown:
        sResult += "readModeInkLockDown";
        break;
    case oox::XML_smartTagType:
        sResult += "smartTagType";
        break;
    case oox::XML_shapeDefaults:
        sResult += "shapeDefaults";
        break;
    case oox::XML_doNotEmbedSmartTags:
        sResult += "doNotEmbedSmartTags";
        break;
    case oox::XML_decimalSymbol:
        sResult += "decimalSymbol";
        break;
    case oox::XML_listSeparator:
        sResult += "listSeparator";
        break;
    case oox::XML_frameset:
        sResult += "frameset";
        break;
    case oox::XML_divs:
        sResult += "divs";
        break;
    case oox::XML_encoding:
        sResult += "encoding";
        break;
    case oox::XML_optimizeForBrowser:
        sResult += "optimizeForBrowser";
        break;
    case oox::XML_relyOnVML:
        sResult += "relyOnVML";
        break;
    case oox::XML_allowPNG:
        sResult += "allowPNG";
        break;
    case oox::XML_doNotRelyOnCSS:
        sResult += "doNotRelyOnCSS";
        break;
    case oox::XML_doNotSaveAsSingleFile:
        sResult += "doNotSaveAsSingleFile";
        break;
    case oox::XML_doNotOrganizeInFolder:
        sResult += "doNotOrganizeInFolder";
        break;
    case oox::XML_doNotUseLongFileNames:
        sResult += "doNotUseLongFileNames";
        break;
    case oox::XML_pixelsPerInch:
        sResult += "pixelsPerInch";
        break;
    case oox::XML_targetScreenSz:
        sResult += "targetScreenSz";
        break;
    case oox::XML_saveSmartTagsAsXml:
        sResult += "saveSmartTagsAsXml";
        break;
    case oox::XML_sourceFileName:
        sResult += "sourceFileName";
        break;
    case oox::XML_marW:
        sResult += "marW";
        break;
    case oox::XML_marH:
        sResult += "marH";
        break;
    case oox::XML_scrollbar:
        sResult += "scrollbar";
        break;
    case oox::XML_noResizeAllowed:
        sResult += "noResizeAllowed";
        break;
    case oox::XML_linkedToFile:
        sResult += "linkedToFile";
        break;
    case oox::XML_noBorder:
        sResult += "noBorder";
        break;
    case oox::XML_flatBorders:
        sResult += "flatBorders";
        break;
    case oox::XML_framesetSplitbar:
        sResult += "framesetSplitbar";
        break;
    case oox::XML_frameLayout:
        sResult += "frameLayout";
        break;
    case oox::XML_numPicBulletId:
        sResult += "numPicBulletId";
        break;
    case oox::XML_null:
        sResult += "null";
        break;
    case oox::XML_legacy:
        sResult += "legacy";
        break;
    case oox::XML_legacySpace:
        sResult += "legacySpace";
        break;
    case oox::XML_legacyIndent:
        sResult += "legacyIndent";
        break;
    case oox::XML_lvlRestart:
        sResult += "lvlRestart";
        break;
    case oox::XML_isLgl:
        sResult += "isLgl";
        break;
    case oox::XML_suff:
        sResult += "suff";
        break;
    case oox::XML_lvlText:
        sResult += "lvlText";
        break;
    case oox::XML_lvlPicBulletId:
        sResult += "lvlPicBulletId";
        break;
    case oox::XML_lvlJc:
        sResult += "lvlJc";
        break;
    case oox::XML_tplc:
        sResult += "tplc";
        break;
    case oox::XML_tentative:
        sResult += "tentative";
        break;
    case oox::XML_nsid:
        sResult += "nsid";
        break;
    case oox::XML_multiLevelType:
        sResult += "multiLevelType";
        break;
    case oox::XML_tmpl:
        sResult += "tmpl";
        break;
    case oox::XML_styleLink:
        sResult += "styleLink";
        break;
    case oox::XML_numStyleLink:
        sResult += "numStyleLink";
        break;
    case oox::XML_lvl:
        sResult += "lvl";
        break;
    case oox::XML_abstractNumId:
        sResult += "abstractNumId";
        break;
    case oox::XML_startOverride:
        sResult += "startOverride";
        break;
    case oox::XML_lvlOverride:
        sResult += "lvlOverride";
        break;
    case oox::XML_numPicBullet:
        sResult += "numPicBullet";
        break;
    case oox::XML_abstractNum:
        sResult += "abstractNum";
        break;
    case oox::XML_numIdMacAtCleanup:
        sResult += "numIdMacAtCleanup";
        break;
    case oox::XML_aliases:
        sResult += "aliases";
        break;
    case oox::XML_basedOn:
        sResult += "basedOn";
        break;
    case oox::XML_next:
        sResult += "next";
        break;
    case oox::XML_autoRedefine:
        sResult += "autoRedefine";
        break;
    case oox::XML_uiPriority:
        sResult += "uiPriority";
        break;
    case oox::XML_semiHidden:
        sResult += "semiHidden";
        break;
    case oox::XML_unhideWhenUsed:
        sResult += "unhideWhenUsed";
        break;
    case oox::XML_qFormat:
        sResult += "qFormat";
        break;
    case oox::XML_personal:
        sResult += "personal";
        break;
    case oox::XML_personalCompose:
        sResult += "personalCompose";
        break;
    case oox::XML_personalReply:
        sResult += "personalReply";
        break;
    case oox::XML_tblStylePr:
        sResult += "tblStylePr";
        break;
    case oox::XML_styleId:
        sResult += "styleId";
        break;
    case oox::XML_customStyle:
        sResult += "customStyle";
        break;
    case oox::XML_lsdException:
        sResult += "lsdException";
        break;
    case oox::XML_defLockedState:
        sResult += "defLockedState";
        break;
    case oox::XML_defUIPriority:
        sResult += "defUIPriority";
        break;
    case oox::XML_defSemiHidden:
        sResult += "defSemiHidden";
        break;
    case oox::XML_defUnhideWhenUsed:
        sResult += "defUnhideWhenUsed";
        break;
    case oox::XML_defQFormat:
        sResult += "defQFormat";
        break;
    case oox::XML_docDefaults:
        sResult += "docDefaults";
        break;
    case oox::XML_latentStyles:
        sResult += "latentStyles";
        break;
    case oox::XML_usb0:
        sResult += "usb0";
        break;
    case oox::XML_usb1:
        sResult += "usb1";
        break;
    case oox::XML_usb2:
        sResult += "usb2";
        break;
    case oox::XML_usb3:
        sResult += "usb3";
        break;
    case oox::XML_csb0:
        sResult += "csb0";
        break;
    case oox::XML_csb1:
        sResult += "csb1";
        break;
    case oox::XML_fontKey:
        sResult += "fontKey";
        break;
    case oox::XML_subsetted:
        sResult += "subsetted";
        break;
    case oox::XML_altName:
        sResult += "altName";
        break;
    case oox::XML_panose1:
        sResult += "panose1";
        break;
    case oox::XML_characterSet:
        sResult += "characterSet";
        break;
    case oox::XML_family:
        sResult += "family";
        break;
    case oox::XML_notTrueType:
        sResult += "notTrueType";
        break;
    case oox::XML_pitch:
        sResult += "pitch";
        break;
    case oox::XML_sig:
        sResult += "sig";
        break;
    case oox::XML_embedRegular:
        sResult += "embedRegular";
        break;
    case oox::XML_embedBold:
        sResult += "embedBold";
        break;
    case oox::XML_embedItalic:
        sResult += "embedItalic";
        break;
    case oox::XML_embedBoldItalic:
        sResult += "embedBoldItalic";
        break;
    case oox::XML_blockQuote:
        sResult += "blockQuote";
        break;
    case oox::XML_bodyDiv:
        sResult += "bodyDiv";
        break;
    case oox::XML_marLeft:
        sResult += "marLeft";
        break;
    case oox::XML_marRight:
        sResult += "marRight";
        break;
    case oox::XML_marTop:
        sResult += "marTop";
        break;
    case oox::XML_marBottom:
        sResult += "marBottom";
        break;
    case oox::XML_divBdr:
        sResult += "divBdr";
        break;
    case oox::XML_divsChild:
        sResult += "divsChild";
        break;
    case oox::XML_div:
        sResult += "div";
        break;
    case oox::XML_altChunk:
        sResult += "altChunk";
        break;
    case oox::XML_proofErr:
        sResult += "proofErr";
        break;
    case oox::XML_comment:
        sResult += "comment";
        break;
    case oox::XML_footnotes:
        sResult += "footnotes";
        break;
    case oox::XML_endnotes:
        sResult += "endnotes";
        break;
    case oox::XML_hdr:
        sResult += "hdr";
        break;
    case oox::XML_ftr:
        sResult += "ftr";
        break;
    case oox::XML_namespaceuri:
        sResult += "namespaceuri";
        break;
    case oox::XML_url:
        sResult += "url";
        break;
    case oox::XML_behavior:
        sResult += "behavior";
        break;
    case oox::XML_all:
        sResult += "all";
        break;
    case oox::XML_gallery:
        sResult += "gallery";
        break;
    case oox::XML_decorated:
        sResult += "decorated";
        break;
    case oox::XML_category:
        sResult += "category";
        break;
    case oox::XML_types:
        sResult += "types";
        break;
    case oox::XML_behaviors:
        sResult += "behaviors";
        break;
    case oox::XML_description:
        sResult += "description";
        break;
    case oox::XML_guid:
        sResult += "guid";
        break;
    case oox::XML_docPartPr:
        sResult += "docPartPr";
        break;
    case oox::XML_docPartBody:
        sResult += "docPartBody";
        break;
    case oox::XML_settings:
        sResult += "settings";
        break;
    case oox::XML_webSettings:
        sResult += "webSettings";
        break;
    case oox::XML_fonts:
        sResult += "fonts";
        break;
    case oox::XML_numbering:
        sResult += "numbering";
        break;
    case oox::XML_styles:
        sResult += "styles";
        break;
    case oox::XML_chapNum:
        sResult += "chapNum";
        break;
    case oox::XML_heading:
        sResult += "heading";
        break;
    case oox::XML_noLabel:
        sResult += "noLabel";
        break;
    case oox::XML_caption:
        sResult += "caption";
        break;
    case oox::XML_autoCaption:
        sResult += "autoCaption";
        break;
    case oox::XML_autoCaptions:
        sResult += "autoCaptions";
        break;
    case oox::XML_body:
        sResult += "body";
        break;
    case oox::XML_docParts:
        sResult += "docParts";
        break;
    case oox::XML_document:
        sResult += "document";
        break;
    case oox::XML_glossaryDocument:
        sResult += "glossaryDocument";
        break;
    }
#else
    (void)nToken;
#endif
    return sResult;
}

uno::Reference <xml::sax::XFastParser> OOXMLStreamImpl::getFastParser()
{
    if (!mxFastParser.is())
    {
        mxFastParser = css::xml::sax::FastParser::create(mxContext);
        // the threaded parser is about 20% slower loading writer documents
        css::uno::Reference< css::lang::XInitialization > xInit( mxFastParser, css::uno::UNO_QUERY_THROW );
        css::uno::Sequence< css::uno::Any > args{ css::uno::Any(OUString("DisableThreadedParser")) };
        xInit->initialize(args);

        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/drawingml/chart", oox::NMSP_dmlChart);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/drawingml/chartDrawing", oox::NMSP_dmlChartDr);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/drawingml/diagram", oox::NMSP_dmlDiagram);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/drawingml/lockedCanvas", oox::NMSP_dmlLockedCanvas);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/drawingml/main", oox::NMSP_dml);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/drawingml/picture", oox::NMSP_dmlPicture);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/drawingml/spreadsheetDrawing", oox::NMSP_dmlSpreadDr);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/drawingml/wordprocessingDrawing", oox::NMSP_dmlWordDr);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/officeDocument/custom-properties", oox::NMSP_officeCustomPr);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/officeDocument/docPropsVTypes", oox::NMSP_officeDocPropsVT);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/officeDocument/extended-properties", oox::NMSP_officeExtPr);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/officeDocument/math", oox::NMSP_officeMath);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/officeDocument/relationships", oox::NMSP_officeRel);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/officeDocument/relationships/theme", oox::NMSP_officeRelTheme);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/presentationml/main", oox::NMSP_ppt);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/schemaLibrary/main", oox::NMSP_schema);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/spreadsheetml/main", oox::NMSP_xls);
        mxFastParser->registerNamespace("http://purl.oclc.org/ooxml/wordprocessingml/main", oox::NMSP_doc);
        mxFastParser->registerNamespace("http://purl.org/dc/dcmitype/", oox::NMSP_dcmiType);
        mxFastParser->registerNamespace("http://purl.org/dc/elements/1.1/", oox::NMSP_dc);
        mxFastParser->registerNamespace("http://purl.org/dc/terms/", oox::NMSP_dcTerms);
        mxFastParser->registerNamespace("http://schemas.libreoffice.org/", oox::NMSP_loext);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/2006/activeX", oox::NMSP_ax);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/drawing/2008/diagram", oox::NMSP_dsp);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/drawing/2010/main", oox::NMSP_a14);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/drawing/2012/chart", oox::NMSP_c15);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/drawing/2016/SVG/main", oox::NMSP_asvg);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/drawing/2017/decorative", oox::NMSP_adec);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/excel/2006/main", oox::NMSP_xm);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/powerpoint/2010/main", oox::NMSP_p14);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/powerpoint/2012/main", oox::NMSP_p15);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/spreadsheetml/2009/9/main", oox::NMSP_xls14Lst);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/spreadsheetml/2011/1/ac", oox::NMSP_x12ac);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/spreadsheetml/2015/revision2", oox::NMSP_xr2);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/spreadsheetml/2017/revision16", oox::NMSP_xr16);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/word/2010/wordml", oox::NMSP_w14);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas", oox::NMSP_wpc);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing", oox::NMSP_wp14);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/word/2010/wordprocessingGroup", oox::NMSP_wpg);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/word/2010/wordprocessingShape", oox::NMSP_wps);
        mxFastParser->registerNamespace("http://schemas.microsoft.com/office/word/2012/wordml", oox::NMSP_w15);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/drawingml/2006/chart", oox::NMSP_dmlChart);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/drawingml/2006/chartDrawing", oox::NMSP_dmlChartDr);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/drawingml/2006/diagram", oox::NMSP_dmlDiagram);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/drawingml/2006/lockedCanvas", oox::NMSP_dmlLockedCanvas);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/drawingml/2006/main", oox::NMSP_dml);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/drawingml/2006/picture", oox::NMSP_dmlPicture);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing", oox::NMSP_dmlSpreadDr);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", oox::NMSP_dmlWordDr);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/markup-compatibility/2006", oox::NMSP_mce);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/officeDocument/2006/custom-properties", oox::NMSP_officeCustomPr);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes", oox::NMSP_officeDocPropsVT);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/officeDocument/2006/extended-properties", oox::NMSP_officeExtPr);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/officeDocument/2006/math", oox::NMSP_officeMath);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/officeDocument/2006/relationships", oox::NMSP_officeRel);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme", oox::NMSP_officeRelTheme);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/package/2006/content-types", oox::NMSP_packageContentTypes);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/package/2006/metadata/core-properties", oox::NMSP_packageMetaCorePr);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/package/2006/relationships", oox::NMSP_packageRel);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/presentationml/2006/main", oox::NMSP_ppt);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/schemaLibrary/2006/main", oox::NMSP_schema);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main", oox::NMSP_xls);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main/v2", oox::NMSP_mceTest);
        mxFastParser->registerNamespace("http://schemas.openxmlformats.org/wordprocessingml/2006/main", oox::NMSP_doc);
        mxFastParser->registerNamespace("http://www.w3.org/2001/XMLSchema-instance", oox::NMSP_xsi);
        mxFastParser->registerNamespace("http://www.w3.org/XML/1998/namespace", oox::NMSP_xml);
        mxFastParser->registerNamespace("urn:schemas-microsoft-com:office:excel", oox::NMSP_vmlExcel);
        mxFastParser->registerNamespace("urn:schemas-microsoft-com:office:office", oox::NMSP_vmlOffice);
        mxFastParser->registerNamespace("urn:schemas-microsoft-com:office:powerpoint", oox::NMSP_vmlPowerpoint);
        mxFastParser->registerNamespace("urn:schemas-microsoft-com:office:word", oox::NMSP_vmlWord);
        mxFastParser->registerNamespace("urn:schemas-microsoft-com:vml", oox::NMSP_vml);
    }

    return mxFastParser;
}

/// @endcond
}}
