
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kactionselector_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <kactionselector.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KActionSelector_Type = nullptr;
static PyTypeObject *Sbk_KActionSelector_TypeF(void)
{
    return _Sbk_KActionSelector_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KActionSelectorWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KActionSelectorWrapper::KActionSelectorWrapper(::QWidget * parent) : KActionSelector(parent)
{
}

void KActionSelectorWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KActionSelector", funcName, gil, pyOverride, signal);
}

void KActionSelectorWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KActionSelector", funcName, gil, pyOverride, event);
}

int KActionSelectorWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KActionSelector", funcName, gil, pyOverride);
}

void KActionSelectorWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KActionSelector", funcName, gil, pyOverride, signal);
}

void KActionSelectorWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KActionSelector", funcName, gil, pyOverride, event);
}

bool KActionSelectorWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KActionSelector", funcName, gil, pyOverride, event);
}

bool KActionSelectorWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::KActionSelector::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KActionSelector", funcName, gil, pyOverride, arg__1, arg__2);
}

void KActionSelectorWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KActionSelector", funcName, gil, pyOverride, event);
}

bool KActionSelectorWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KActionSelector", funcName, gil, pyOverride, next);
}

void KActionSelectorWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KActionSelector", funcName, gil, pyOverride, event);
}

bool KActionSelectorWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KActionSelector", funcName, gil, pyOverride);
}

int KActionSelectorWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KActionSelector", funcName, gil, pyOverride, arg__1);
}

void KActionSelectorWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KActionSelector", funcName, gil, pyOverride, painter);
}

void KActionSelectorWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KActionSelector", funcName, gil, pyOverride, event);
}

::QVariant KActionSelectorWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KActionSelector", funcName, gil, pyOverride, arg__1);
}

void KActionSelectorWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::KActionSelector::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KActionSelector", funcName, gil, pyOverride, arg__1);
}

void KActionSelectorWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KActionSelector", funcName, gil, pyOverride, event);
}

int KActionSelectorWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KActionSelector", funcName, gil, pyOverride, arg__1);
}

::QSize KActionSelectorWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KActionSelector", funcName, gil, pyOverride);
}

void KActionSelectorWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KActionSelector", funcName, gil, pyOverride, event);
}

bool KActionSelectorWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KActionSelector", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KActionSelectorWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KActionSelector", funcName, gil, pyOverride);
}

void KActionSelectorWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KActionSelector", funcName, gil, pyOverride, event);
}

::QPaintDevice * KActionSelectorWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KActionSelector", funcName, gil, pyOverride, offset);
}

void KActionSelectorWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KActionSelector", funcName, gil, pyOverride, visible);
}

::QPainter * KActionSelectorWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KActionSelector", funcName, gil, pyOverride);
}

void KActionSelectorWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KActionSelector", funcName, gil, pyOverride, event);
}

::QSize KActionSelectorWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KActionSelector", funcName, gil, pyOverride);
}

void KActionSelectorWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KActionSelector", funcName, gil, pyOverride, event);
}

void KActionSelectorWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionSelector_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KActionSelector", funcName, gil, pyOverride, event);
}

const QMetaObject *KActionSelectorWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KActionSelector::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KActionSelectorWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KActionSelector::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KActionSelectorWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KActionSelectorWrapper *>(this));
    }
    return KActionSelector::qt_metacast(_clname);
}

KActionSelectorWrapper::~KActionSelectorWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KActionSelector_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KActionSelector_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KActionSelector >()))
        return -1;

    KActionSelectorWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KActionSelector", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KActionSelector::KActionSelector(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KActionSelector(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KActionSelector(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KActionSelector(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KActionSelectorWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KActionSelectorWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KActionSelector >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KActionSelectorFunc_availableInsertionPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // availableInsertionPolicy()const
        KActionSelector::InsertionPolicy cppResult = const_cast<const ::KActionSelector *>(cppSelf)->availableInsertionPolicy();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_InsertionPolicy_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionSelectorFunc_availableLabel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // availableLabel()const
        QString cppResult = const_cast<const ::KActionSelector *>(cppSelf)->availableLabel();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionSelectorFunc_availableListWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // availableListWidget()const
        QListWidget * cppResult = const_cast<const ::KActionSelector *>(cppSelf)->availableListWidget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QListWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionSelectorFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KActionSelector::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionSelectorFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KActionSelector::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_keyboardEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // keyboardEnabled()const
        bool cppResult = const_cast<const ::KActionSelector *>(cppSelf)->keyboardEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionSelectorFunc_moveOnDoubleClick(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // moveOnDoubleClick()const
        bool cppResult = const_cast<const ::KActionSelector *>(cppSelf)->moveOnDoubleClick();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionSelectorFunc_selectedInsertionPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectedInsertionPolicy()const
        KActionSelector::InsertionPolicy cppResult = const_cast<const ::KActionSelector *>(cppSelf)->selectedInsertionPolicy();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_InsertionPolicy_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionSelectorFunc_selectedLabel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectedLabel()const
        QString cppResult = const_cast<const ::KActionSelector *>(cppSelf)->selectedLabel();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionSelectorFunc_selectedListWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectedListWidget()const
        QListWidget * cppResult = const_cast<const ::KActionSelector *>(cppSelf)->selectedListWidget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QListWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionSelectorFunc_setAvailableInsertionPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionSelector::setAvailableInsertionPolicy(KActionSelector::InsertionPolicy)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_InsertionPolicy_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setAvailableInsertionPolicy(KActionSelector::InsertionPolicy)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAvailableInsertionPolicy", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        ::KActionSelector::InsertionPolicy cppArg0{KActionSelector::BelowCurrent};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAvailableInsertionPolicy(KActionSelector::InsertionPolicy)
            cppSelf->setAvailableInsertionPolicy(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setAvailableLabel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionSelector::setAvailableLabel(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setAvailableLabel(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAvailableLabel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAvailableLabel(QString)
            cppSelf->setAvailableLabel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setButtonIcon(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setButtonIcon", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KActionSelector::setButtonIcon(QString,KActionSelector::MoveButton)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_MoveButton_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // setButtonIcon(QString,KActionSelector::MoveButton)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setButtonIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KActionSelector::MoveButton cppArg1{KActionSelector::ButtonAdd};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setButtonIcon(QString,KActionSelector::MoveButton)
            cppSelf->setButtonIcon(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setButtonIconSet(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setButtonIconSet", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KActionSelector::setButtonIconSet(QIcon,KActionSelector::MoveButton)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_MoveButton_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // setButtonIconSet(QIcon,KActionSelector::MoveButton)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setButtonIconSet", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::KActionSelector::MoveButton cppArg1{KActionSelector::ButtonAdd};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setButtonIconSet(QIcon,KActionSelector::MoveButton)
            cppSelf->setButtonIconSet(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setButtonTooltip(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setButtonTooltip", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KActionSelector::setButtonTooltip(QString,KActionSelector::MoveButton)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_MoveButton_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // setButtonTooltip(QString,KActionSelector::MoveButton)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setButtonTooltip", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KActionSelector::MoveButton cppArg1{KActionSelector::ButtonAdd};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setButtonTooltip(QString,KActionSelector::MoveButton)
            cppSelf->setButtonTooltip(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setButtonWhatsThis(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setButtonWhatsThis", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KActionSelector::setButtonWhatsThis(QString,KActionSelector::MoveButton)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_MoveButton_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // setButtonWhatsThis(QString,KActionSelector::MoveButton)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setButtonWhatsThis", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KActionSelector::MoveButton cppArg1{KActionSelector::ButtonAdd};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setButtonWhatsThis(QString,KActionSelector::MoveButton)
            cppSelf->setButtonWhatsThis(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setButtonsEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setButtonsEnabled()
        cppSelf->setButtonsEnabled();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setKeyboardEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionSelector::setKeyboardEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setKeyboardEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setKeyboardEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setKeyboardEnabled(bool)
            cppSelf->setKeyboardEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setMoveOnDoubleClick(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionSelector::setMoveOnDoubleClick(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMoveOnDoubleClick(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMoveOnDoubleClick", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMoveOnDoubleClick(bool)
            cppSelf->setMoveOnDoubleClick(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setSelectedInsertionPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionSelector::setSelectedInsertionPolicy(KActionSelector::InsertionPolicy)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_InsertionPolicy_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setSelectedInsertionPolicy(KActionSelector::InsertionPolicy)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSelectedInsertionPolicy", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        ::KActionSelector::InsertionPolicy cppArg0{KActionSelector::BelowCurrent};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSelectedInsertionPolicy(KActionSelector::InsertionPolicy)
            cppSelf->setSelectedInsertionPolicy(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setSelectedLabel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionSelector::setSelectedLabel(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setSelectedLabel(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSelectedLabel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSelectedLabel(QString)
            cppSelf->setSelectedLabel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_setShowUpDownButtons(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionSelector::setShowUpDownButtons(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowUpDownButtons(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowUpDownButtons", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowUpDownButtons(bool)
            cppSelf->setShowUpDownButtons(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionSelectorFunc_showUpDownButtons(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showUpDownButtons()const
        bool cppResult = const_cast<const ::KActionSelector *>(cppSelf)->showUpDownButtons();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KActionSelector_PropertyStrings[] = {
    "availableInsertionPolicy::",
    "availableLabel::",
    "keyboardEnabled::",
    "moveOnDoubleClick::",
    "selectedInsertionPolicy::",
    "selectedLabel::",
    "showUpDownButtons::",
    nullptr // Sentinel
};

static const char *Sbk_KActionSelector_EnumFlagInfo[] = {
    "InsertionPolicy:IntEnum",
    "MoveButton:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KActionSelector_methods[] = {
    {"availableInsertionPolicy", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_availableInsertionPolicy), METH_NOARGS, nullptr},
    {"availableLabel", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_availableLabel), METH_NOARGS, nullptr},
    {"availableListWidget", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_availableListWidget), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_eventFilter), METH_VARARGS, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_keyPressEvent), METH_O, nullptr},
    {"keyboardEnabled", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_keyboardEnabled), METH_NOARGS, nullptr},
    {"moveOnDoubleClick", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_moveOnDoubleClick), METH_NOARGS, nullptr},
    {"selectedInsertionPolicy", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_selectedInsertionPolicy), METH_NOARGS, nullptr},
    {"selectedLabel", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_selectedLabel), METH_NOARGS, nullptr},
    {"selectedListWidget", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_selectedListWidget), METH_NOARGS, nullptr},
    {"setAvailableInsertionPolicy", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setAvailableInsertionPolicy), METH_O, nullptr},
    {"setAvailableLabel", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setAvailableLabel), METH_O, nullptr},
    {"setButtonIcon", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setButtonIcon), METH_VARARGS, nullptr},
    {"setButtonIconSet", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setButtonIconSet), METH_VARARGS, nullptr},
    {"setButtonTooltip", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setButtonTooltip), METH_VARARGS, nullptr},
    {"setButtonWhatsThis", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setButtonWhatsThis), METH_VARARGS, nullptr},
    {"setButtonsEnabled", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setButtonsEnabled), METH_NOARGS, nullptr},
    {"setKeyboardEnabled", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setKeyboardEnabled), METH_O, nullptr},
    {"setMoveOnDoubleClick", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setMoveOnDoubleClick), METH_O, nullptr},
    {"setSelectedInsertionPolicy", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setSelectedInsertionPolicy), METH_O, nullptr},
    {"setSelectedLabel", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setSelectedLabel), METH_O, nullptr},
    {"setShowUpDownButtons", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_setShowUpDownButtons), METH_O, nullptr},
    {"showUpDownButtons", reinterpret_cast<PyCFunction>(Sbk_KActionSelectorFunc_showUpDownButtons), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KActionSelector_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KActionSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KActionSelectorWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KActionSelector_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KActionSelector_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KActionSelectorSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KActionSelector *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KActionSelector_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KActionSelector_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KActionSelector_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KActionSelector_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KActionSelector_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KActionSelector_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KActionSelector_spec = {
    "1:KWidgetsAddons.KActionSelector",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KActionSelector_slots
};

} //extern "C"

static void *Sbk_KActionSelector_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KActionSelector *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KActionSelector *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KActionSelector *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KActionSelector_MoveButton(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KActionSelector::MoveButton>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KActionSelector::MoveButton *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KActionSelector_MoveButton_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_MoveButton_IDX])))
        return Enum_PythonToCpp_KActionSelector_MoveButton;
    return {};
}

static PyObject *KActionSelector_MoveButton_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KActionSelector::MoveButton>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KActionSelector::MoveButton *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KActionSelector_InsertionPolicy(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KActionSelector::InsertionPolicy>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KActionSelector::InsertionPolicy *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KActionSelector_InsertionPolicy_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_InsertionPolicy_IDX])))
        return Enum_PythonToCpp_KActionSelector_InsertionPolicy;
    return {};
}

static PyObject *KActionSelector_InsertionPolicy_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KActionSelector::InsertionPolicy>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KActionSelector::InsertionPolicy *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KActionSelector_PythonToCpp_KActionSelector_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KActionSelector_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KActionSelector_PythonToCpp_KActionSelector_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KActionSelector_TypeF()))
        return KActionSelector_PythonToCpp_KActionSelector_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KActionSelector_PTR_CppToPython_KActionSelector(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KActionSelector *>(const_cast<void *>(cppIn)), Sbk_KActionSelector_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KActionSelector_SignatureStrings[] = {
    "KWidgetsAddons.KActionSelector(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,moveOnDoubleClick:bool=None,keyboardEnabled:bool=None,availableLabel:QString=None,selectedLabel:QString=None,availableInsertionPolicy:KWidgetsAddons.KActionSelector.InsertionPolicy=None,selectedInsertionPolicy:KWidgetsAddons.KActionSelector.InsertionPolicy=None,showUpDownButtons:bool=None)",
    "KWidgetsAddons.KActionSelector.availableInsertionPolicy(self)->KWidgetsAddons.KActionSelector.InsertionPolicy",
    "KWidgetsAddons.KActionSelector.availableLabel(self)->QString",
    "KWidgetsAddons.KActionSelector.availableListWidget(self)->PySide6.QtWidgets.QListWidget",
    "KWidgetsAddons.KActionSelector.eventFilter(self,arg__1:PySide6.QtCore.QObject,arg__2:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KActionSelector.keyPressEvent(self,arg__1:PySide6.QtGui.QKeyEvent)",
    "KWidgetsAddons.KActionSelector.keyboardEnabled(self)->bool",
    "KWidgetsAddons.KActionSelector.moveOnDoubleClick(self)->bool",
    "KWidgetsAddons.KActionSelector.selectedInsertionPolicy(self)->KWidgetsAddons.KActionSelector.InsertionPolicy",
    "KWidgetsAddons.KActionSelector.selectedLabel(self)->QString",
    "KWidgetsAddons.KActionSelector.selectedListWidget(self)->PySide6.QtWidgets.QListWidget",
    "KWidgetsAddons.KActionSelector.setAvailableInsertionPolicy(self,policy:KWidgetsAddons.KActionSelector.InsertionPolicy)",
    "KWidgetsAddons.KActionSelector.setAvailableLabel(self,text:QString)",
    "KWidgetsAddons.KActionSelector.setButtonIcon(self,icon:QString,button:KWidgetsAddons.KActionSelector.MoveButton)",
    "KWidgetsAddons.KActionSelector.setButtonIconSet(self,iconset:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],button:KWidgetsAddons.KActionSelector.MoveButton)",
    "KWidgetsAddons.KActionSelector.setButtonTooltip(self,tip:QString,button:KWidgetsAddons.KActionSelector.MoveButton)",
    "KWidgetsAddons.KActionSelector.setButtonWhatsThis(self,text:QString,button:KWidgetsAddons.KActionSelector.MoveButton)",
    "KWidgetsAddons.KActionSelector.setButtonsEnabled(self)",
    "KWidgetsAddons.KActionSelector.setKeyboardEnabled(self,enable:bool)",
    "KWidgetsAddons.KActionSelector.setMoveOnDoubleClick(self,enable:bool)",
    "KWidgetsAddons.KActionSelector.setSelectedInsertionPolicy(self,policy:KWidgetsAddons.KActionSelector.InsertionPolicy)",
    "KWidgetsAddons.KActionSelector.setSelectedLabel(self,text:QString)",
    "KWidgetsAddons.KActionSelector.setShowUpDownButtons(self,show:bool)",
    "KWidgetsAddons.KActionSelector.showUpDownButtons(self)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KActionSelector_SignatureByteSize = 478;
static constexpr uint8_t KActionSelector_SignatureBytes[478] = {
    0x78, 0xda, 0xbd, 0x55, 0x4d, 0x6f, 0x82, 0x40, 0x10, 0xbd, 0xf7, 0x57, 0xf4, 0x58, 0x1b, 0x4a,
    0xd2, 0x1e, 0x7a, 0x20, 0xb1, 0x89, 0x55, 0xdb, 0x18, 0x6a, 0x95, 0x50, 0xe3, 0xa1, 0x69, 0xcc,
    0x22, 0x53, 0xdd, 0xba, 0xee, 0x92, 0xdd, 0xf5, 0x83, 0x7f, 0xdf, 0x85, 0x05, 0x3f, 0x10, 0x05,
    0x1a, 0xed, 0x0d, 0x18, 0xde, 0x7b, 0x33, 0xb3, 0x6f, 0x66, 0xed, 0x21, 0xf6, 0x27, 0x20, 0x45,
    0xc3, 0xf7, 0x19, 0x15, 0xa6, 0xdd, 0x18, 0x4b, 0xcc, 0xa8, 0x0b, 0x04, 0xc6, 0x92, 0xf1, 0x1b,
    0x01, 0xe4, 0xdb, 0x08, 0x10, 0x07, 0x2a, 0xad, 0x7e, 0xe8, 0x62, 0x1f, 0x1e, 0x4d, 0x47, 0x26,
    0x18, 0xd3, 0xd1, 0x0f, 0x75, 0xba, 0x20, 0x24, 0x90, 0xdc, 0xb8, 0xb5, 0x6c, 0x08, 0x57, 0x8c,
    0xfb, 0x3d, 0x4a, 0xc2, 0xfa, 0x3b, 0xa3, 0x60, 0xcc, 0xd9, 0x12, 0x7a, 0xb4, 0xc5, 0x16, 0x1e,
    0x81, 0x26, 0xc1, 0xe3, 0x99, 0xe5, 0x31, 0x46, 0x74, 0x6c, 0x06, 0xa1, 0xc7, 0x10, 0xf7, 0xdb,
    0x14, 0xa9, 0xa8, 0xbf, 0x13, 0x41, 0x4b, 0x84, 0x49, 0xf4, 0xf1, 0x0d, 0x79, 0x40, 0x2c, 0xc7,
    0x95, 0x1c, 0xd3, 0x89, 0x8e, 0x89, 0x38, 0x37, 0xf0, 0x73, 0x42, 0x1b, 0x58, 0x87, 0x0a, 0xe0,
    0x51, 0x21, 0x7d, 0xa6, 0x34, 0x43, 0xcb, 0x3e, 0x59, 0xa5, 0x99, 0xf9, 0x7d, 0x5f, 0xe7, 0x2c,
    0x5c, 0x53, 0xb6, 0x1a, 0x04, 0x2d, 0xb6, 0xa2, 0xcf, 0x0b, 0x29, 0x15, 0x6c, 0x5b, 0x6b, 0xed,
    0xaa, 0x80, 0xf0, 0x58, 0x51, 0xf1, 0xd9, 0xd4, 0xee, 0x9e, 0xaa, 0xe5, 0x53, 0x5a, 0x2d, 0x6e,
    0x6f, 0xaa, 0x91, 0x74, 0xb9, 0x3c, 0x18, 0x8b, 0xc4, 0x24, 0x29, 0x43, 0x8e, 0x79, 0xb6, 0x3f,
    0x15, 0xf1, 0xc2, 0x52, 0xf9, 0xef, 0x05, 0x13, 0x09, 0x89, 0x23, 0x11, 0x9f, 0x8c, 0x46, 0xf7,
    0x3b, 0x8e, 0x6c, 0x32, 0x0e, 0xa6, 0xd3, 0xf3, 0x7e, 0x14, 0x40, 0x47, 0x1f, 0x0e, 0xa2, 0xed,
    0x88, 0x45, 0xa5, 0x12, 0xb5, 0xbe, 0x48, 0x51, 0x59, 0xb3, 0xcf, 0x41, 0x88, 0x18, 0x73, 0x44,
    0xf3, 0x75, 0x81, 0x4d, 0x47, 0x19, 0x5e, 0xf3, 0x96, 0x60, 0xdc, 0x35, 0x7b, 0xda, 0x97, 0x32,
    0xc9, 0x1c, 0xcc, 0x50, 0x15, 0xf0, 0x11, 0x1b, 0x5f, 0xc6, 0x3d, 0x7b, 0xb3, 0x59, 0xd1, 0x3c,
    0x1b, 0xec, 0x79, 0xbd, 0x23, 0x40, 0x36, 0x4e, 0x4d, 0x90, 0x11, 0xfc, 0x65, 0xac, 0x6b, 0x55,
    0x64, 0xb7, 0xdd, 0x30, 0x24, 0xac, 0x65, 0xba, 0xb3, 0xca, 0x70, 0xe8, 0x75, 0xd1, 0x19, 0x33,
    0xaa, 0xf1, 0x58, 0x3d, 0xa5, 0x78, 0xc3, 0x8b, 0x83, 0x45, 0x99, 0x77, 0x95, 0x7b, 0x34, 0x4d,
    0x35, 0x41, 0x37, 0x39, 0x80, 0x58, 0x53, 0x45, 0x2c, 0x19, 0x06, 0x4a, 0xd5, 0x1c, 0x50, 0x05,
    0xf9, 0xcc, 0x8c, 0x41, 0x04, 0x30, 0xae, 0x33, 0x1f, 0xfb, 0x78, 0x3d, 0x47, 0xc1, 0xd7, 0x05,
    0xf3, 0xfc, 0x50, 0x03, 0x20, 0x71, 0x90, 0xf4, 0x16, 0x07, 0xff, 0xd0, 0x9a, 0xe1, 0x14, 0x49,
    0xf1, 0x31, 0xc5, 0xe2, 0xf0, 0x40, 0x2f, 0xa8, 0x2a, 0xf6, 0xd6, 0x46, 0x09, 0x98, 0x9d, 0xb3,
    0x6e, 0x0c, 0x88, 0x5f, 0xe2, 0xbb, 0xa7, 0x0c, 0x47, 0x37, 0x77, 0xef, 0x54, 0x65, 0x71, 0x4f,
    0x2c, 0xa0, 0xcb, 0x0d, 0x9f, 0x7b, 0xb0, 0x89, 0x2a, 0xcf, 0x9e, 0x9b, 0xbd, 0xb4, 0x35, 0x4d,
    0x74, 0x97, 0x97, 0x2c, 0x3e, 0x97, 0x20, 0xdd, 0xdb, 0xbf, 0x00, 0xb2, 0x90, 0x0e
};
#endif

PyTypeObject *init_KActionSelector(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX].type;

    Shiboken::AutoDecRef Sbk_KActionSelector_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KActionSelector_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KActionSelector",
        "KActionSelector*",
        &Sbk_KActionSelector_spec,
        &Shiboken::callCppDestructor< KActionSelector >,
        Sbk_KActionSelector_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KActionSelector_Type; // references _Sbk_KActionSelector_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KActionSelector_SignatureStrings);
#else
    InitSignatureBytes(pyType, KActionSelector_SignatureBytes, KActionSelector_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KActionSelector_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KActionSelector_PythonToCpp_KActionSelector_PTR,
        is_KActionSelector_PythonToCpp_KActionSelector_PTR_Convertible,
        KActionSelector_PTR_CppToPython_KActionSelector);

    Shiboken::Conversions::registerConverterName(converter, "KActionSelector");
    Shiboken::Conversions::registerConverterName(converter, "KActionSelector*");
    Shiboken::Conversions::registerConverterName(converter, "KActionSelector&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KActionSelector).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KActionSelectorWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KActionSelector_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KActionSelector_TypeF(), &Sbk_KActionSelectorSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KActionSelector_TypeF(), &Sbk_KActionSelector_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KActionSelector_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'MoveButton'.
    const char *MoveButton_Initializer[] = {
        "ButtonAdd",
        "ButtonRemove",
        "ButtonUp",
        "ButtonDown",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t MoveButton_InitializerValues[] = {
        uint8_t(KActionSelector::MoveButton::ButtonAdd),    //  0x00  0
        uint8_t(KActionSelector::MoveButton::ButtonRemove), //  0x01  1
        uint8_t(KActionSelector::MoveButton::ButtonUp),     //  0x02  2
        uint8_t(KActionSelector::MoveButton::ButtonDown)    //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KActionSelector_TypeF(),
        "1:KWidgetsAddons.KActionSelector.MoveButton",
        MoveButton_Initializer, MoveButton_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_MoveButton_IDX].type = EType;
    // Register converter for enum 'KActionSelector::MoveButton'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KActionSelector_MoveButton_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KActionSelector_MoveButton,
            is_Enum_PythonToCpp_KActionSelector_MoveButton_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KActionSelector::MoveButton");
        Shiboken::Conversions::registerConverterAlias(converter, "MoveButton");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'MoveButton' enum.

    // Initialization of enum 'InsertionPolicy'.
    const char *InsertionPolicy_Initializer[] = {
        "BelowCurrent",
        "Sorted",
        "AtTop",
        "AtBottom",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t InsertionPolicy_InitializerValues[] = {
        uint8_t(KActionSelector::InsertionPolicy::BelowCurrent), //  0x00  0
        uint8_t(KActionSelector::InsertionPolicy::Sorted),       //  0x01  1
        uint8_t(KActionSelector::InsertionPolicy::AtTop),        //  0x02  2
        uint8_t(KActionSelector::InsertionPolicy::AtBottom)      //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KActionSelector_TypeF(),
        "1:KWidgetsAddons.KActionSelector.InsertionPolicy",
        InsertionPolicy_Initializer, InsertionPolicy_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_InsertionPolicy_IDX].type = EType;
    // Register converter for enum 'KActionSelector::InsertionPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KActionSelector_InsertionPolicy_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KActionSelector_InsertionPolicy,
            is_Enum_PythonToCpp_KActionSelector_InsertionPolicy_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KActionSelector::InsertionPolicy");
        Shiboken::Conversions::registerConverterAlias(converter, "InsertionPolicy");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'InsertionPolicy' enum.

    PySide::Signal::registerSignals(pyType, &::KActionSelector::staticMetaObject);
    qRegisterMetaType< ::KActionSelector::MoveButton >("KActionSelector::MoveButton");
    qRegisterMetaType< ::KActionSelector::InsertionPolicy >("KActionSelector::InsertionPolicy");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KActionSelector::staticMetaObject, sizeof(KActionSelectorWrapper));

    return pyType;
}
