/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	storagev1beta1 "k8s.io/api/storage/v1beta1"
)

// CSIDriverSpecApplyConfiguration represents a declarative configuration of the CSIDriverSpec type for use
// with apply.
//
// CSIDriverSpec is the specification of a CSIDriver.
type CSIDriverSpecApplyConfiguration struct {
	// attachRequired indicates this CSI volume driver requires an attach
	// operation (because it implements the CSI ControllerPublishVolume()
	// method), and that the Kubernetes attach detach controller should call
	// the attach volume interface which checks the volumeattachment status
	// and waits until the volume is attached before proceeding to mounting.
	// The CSI external-attacher coordinates with CSI volume driver and updates
	// the volumeattachment status when the attach operation is complete.
	// If the value is specified to false, the attach operation will be skipped.
	// Otherwise the attach operation will be called.
	//
	// This field is immutable.
	AttachRequired *bool `json:"attachRequired,omitempty"`
	// podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.)
	// during mount operations, if set to true.
	// If set to false, pod information will not be passed on mount.
	// Default is false.
	//
	// The CSI driver specifies podInfoOnMount as part of driver deployment.
	// If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls.
	// The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.
	//
	// The following VolumeContext will be passed if podInfoOnMount is set to true.
	// This list might grow, but the prefix will be used.
	// "csi.storage.k8s.io/pod.name": pod.Name
	// "csi.storage.k8s.io/pod.namespace": pod.Namespace
	// "csi.storage.k8s.io/pod.uid": string(pod.UID)
	// "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
	// defined by a CSIVolumeSource, otherwise "false"
	//
	// "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only
	// required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode.
	// Other drivers can leave pod info disabled and/or ignore this field.
	// As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when
	// deployed on such a cluster and the deployment determines which mode that is, for example
	// via a command line parameter of the driver.
	//
	// This field is immutable.
	PodInfoOnMount *bool `json:"podInfoOnMount,omitempty"`
	// volumeLifecycleModes defines what kind of volumes this CSI volume driver supports.
	// The default if the list is empty is "Persistent", which is the usage defined by the
	// CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.
	//
	// The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec
	// with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod.
	// A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.
	//
	// For more information about implementing this mode, see
	// https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html
	// A driver can support one or more of these modes and
	// more modes may be added in the future.
	//
	// This field is immutable.
	VolumeLifecycleModes []storagev1beta1.VolumeLifecycleMode `json:"volumeLifecycleModes,omitempty"`
	// storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage
	// capacity that the driver deployment will report by creating
	// CSIStorageCapacity objects with capacity information, if set to true.
	//
	// The check can be enabled immediately when deploying a driver.
	// In that case, provisioning new volumes with late binding
	// will pause until the driver deployment has published
	// some suitable CSIStorageCapacity object.
	//
	// Alternatively, the driver can be deployed with the field
	// unset or false and it can be flipped later when storage
	// capacity information has been published.
	//
	// This field was immutable in Kubernetes <= 1.22 and now is mutable.
	StorageCapacity *bool `json:"storageCapacity,omitempty"`
	// fsGroupPolicy defines if the underlying volume supports changing ownership and
	// permission of the volume before being mounted.
	// Refer to the specific FSGroupPolicy values for additional details.
	//
	// This field is immutable.
	//
	// Defaults to ReadWriteOnceWithFSType, which will examine each volume
	// to determine if Kubernetes should modify ownership and permissions of the volume.
	// With the default policy the defined fsGroup will only be applied
	// if a fstype is defined and the volume's access mode contains ReadWriteOnce.
	FSGroupPolicy *storagev1beta1.FSGroupPolicy `json:"fsGroupPolicy,omitempty"`
	// tokenRequests indicates the CSI driver needs pods' service account
	// tokens it is mounting volume for to do necessary authentication. Kubelet
	// will pass the tokens in VolumeContext in the CSI NodePublishVolume calls.
	// The CSI driver should parse and validate the following VolumeContext:
	// "csi.storage.k8s.io/serviceAccount.tokens": {
	// "<audience>": {
	// "token": <token>,
	// "expirationTimestamp": <expiration timestamp in RFC3339>,
	// },
	// ...
	// }
	//
	// Note: Audience in each TokenRequest should be different and at
	// most one token is empty string. To receive a new token after expiry,
	// RequiresRepublish can be used to trigger NodePublishVolume periodically.
	TokenRequests []TokenRequestApplyConfiguration `json:"tokenRequests,omitempty"`
	// requiresRepublish indicates the CSI driver wants `NodePublishVolume`
	// being periodically called to reflect any possible change in the mounted
	// volume. This field defaults to false.
	//
	// Note: After a successful initial NodePublishVolume call, subsequent calls
	// to NodePublishVolume should only update the contents of the volume. New
	// mount points will not be seen by a running container.
	RequiresRepublish *bool `json:"requiresRepublish,omitempty"`
	// seLinuxMount specifies if the CSI driver supports "-o context"
	// mount option.
	//
	// When "true", the CSI driver must ensure that all volumes provided by this CSI
	// driver can be mounted separately with different `-o context` options. This is
	// typical for storage backends that provide volumes as filesystems on block
	// devices or as independent shared volumes.
	// Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount
	// option when mounting a ReadWriteOncePod volume used in Pod that has
	// explicitly set SELinux context. In the future, it may be expanded to other
	// volume AccessModes. In any case, Kubernetes will ensure that the volume is
	// mounted only with a single SELinux context.
	//
	// When "false", Kubernetes won't pass any special SELinux mount options to the driver.
	// This is typical for volumes that represent subdirectories of a bigger shared filesystem.
	//
	// Default is "false".
	SELinuxMount *bool `json:"seLinuxMount,omitempty"`
	// nodeAllocatableUpdatePeriodSeconds specifies the interval between periodic updates of
	// the CSINode allocatable capacity for this driver. When set, both periodic updates and
	// updates triggered by capacity-related failures are enabled. If not set, no updates
	// occur (neither periodic nor upon detecting capacity-related failures), and the
	// allocatable.count remains static. The minimum allowed value for this field is 10 seconds.
	//
	// This is a beta feature and requires the MutableCSINodeAllocatableCount feature gate to be enabled.
	//
	// This field is mutable.
	NodeAllocatableUpdatePeriodSeconds *int64 `json:"nodeAllocatableUpdatePeriodSeconds,omitempty"`
	// serviceAccountTokenInSecrets is an opt-in for CSI drivers to indicate that
	// service account tokens should be passed via the Secrets field in NodePublishVolumeRequest
	// instead of the VolumeContext field. The CSI specification provides a dedicated Secrets
	// field for sensitive information like tokens, which is the appropriate mechanism for
	// handling credentials. This addresses security concerns where sensitive tokens were being
	// logged as part of volume context.
	//
	// When "true", kubelet will pass the tokens only in the Secrets field with the key
	// "csi.storage.k8s.io/serviceAccount.tokens". The CSI driver must be updated to read
	// tokens from the Secrets field instead of VolumeContext.
	//
	// When "false" or not set, kubelet will pass the tokens in VolumeContext with the key
	// "csi.storage.k8s.io/serviceAccount.tokens" (existing behavior). This maintains backward
	// compatibility with existing CSI drivers.
	//
	// This field can only be set when TokenRequests is configured. The API server will reject
	// CSIDriver specs that set this field without TokenRequests.
	//
	// Default behavior if unset is to pass tokens in the VolumeContext field.
	ServiceAccountTokenInSecrets *bool `json:"serviceAccountTokenInSecrets,omitempty"`
}

// CSIDriverSpecApplyConfiguration constructs a declarative configuration of the CSIDriverSpec type for use with
// apply.
func CSIDriverSpec() *CSIDriverSpecApplyConfiguration {
	return &CSIDriverSpecApplyConfiguration{}
}

// WithAttachRequired sets the AttachRequired field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AttachRequired field is set to the value of the last call.
func (b *CSIDriverSpecApplyConfiguration) WithAttachRequired(value bool) *CSIDriverSpecApplyConfiguration {
	b.AttachRequired = &value
	return b
}

// WithPodInfoOnMount sets the PodInfoOnMount field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodInfoOnMount field is set to the value of the last call.
func (b *CSIDriverSpecApplyConfiguration) WithPodInfoOnMount(value bool) *CSIDriverSpecApplyConfiguration {
	b.PodInfoOnMount = &value
	return b
}

// WithVolumeLifecycleModes adds the given value to the VolumeLifecycleModes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the VolumeLifecycleModes field.
func (b *CSIDriverSpecApplyConfiguration) WithVolumeLifecycleModes(values ...storagev1beta1.VolumeLifecycleMode) *CSIDriverSpecApplyConfiguration {
	for i := range values {
		b.VolumeLifecycleModes = append(b.VolumeLifecycleModes, values[i])
	}
	return b
}

// WithStorageCapacity sets the StorageCapacity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StorageCapacity field is set to the value of the last call.
func (b *CSIDriverSpecApplyConfiguration) WithStorageCapacity(value bool) *CSIDriverSpecApplyConfiguration {
	b.StorageCapacity = &value
	return b
}

// WithFSGroupPolicy sets the FSGroupPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FSGroupPolicy field is set to the value of the last call.
func (b *CSIDriverSpecApplyConfiguration) WithFSGroupPolicy(value storagev1beta1.FSGroupPolicy) *CSIDriverSpecApplyConfiguration {
	b.FSGroupPolicy = &value
	return b
}

// WithTokenRequests adds the given value to the TokenRequests field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the TokenRequests field.
func (b *CSIDriverSpecApplyConfiguration) WithTokenRequests(values ...*TokenRequestApplyConfiguration) *CSIDriverSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTokenRequests")
		}
		b.TokenRequests = append(b.TokenRequests, *values[i])
	}
	return b
}

// WithRequiresRepublish sets the RequiresRepublish field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RequiresRepublish field is set to the value of the last call.
func (b *CSIDriverSpecApplyConfiguration) WithRequiresRepublish(value bool) *CSIDriverSpecApplyConfiguration {
	b.RequiresRepublish = &value
	return b
}

// WithSELinuxMount sets the SELinuxMount field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SELinuxMount field is set to the value of the last call.
func (b *CSIDriverSpecApplyConfiguration) WithSELinuxMount(value bool) *CSIDriverSpecApplyConfiguration {
	b.SELinuxMount = &value
	return b
}

// WithNodeAllocatableUpdatePeriodSeconds sets the NodeAllocatableUpdatePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeAllocatableUpdatePeriodSeconds field is set to the value of the last call.
func (b *CSIDriverSpecApplyConfiguration) WithNodeAllocatableUpdatePeriodSeconds(value int64) *CSIDriverSpecApplyConfiguration {
	b.NodeAllocatableUpdatePeriodSeconds = &value
	return b
}

// WithServiceAccountTokenInSecrets sets the ServiceAccountTokenInSecrets field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceAccountTokenInSecrets field is set to the value of the last call.
func (b *CSIDriverSpecApplyConfiguration) WithServiceAccountTokenInSecrets(value bool) *CSIDriverSpecApplyConfiguration {
	b.ServiceAccountTokenInSecrets = &value
	return b
}
