
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "ktexttohtml_wrapper.h"

// Argument includes
#include <QString>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KTextToHTML_Type = nullptr;
static PyTypeObject *Sbk_KTextToHTML_TypeF(void)
{
    return _Sbk_KTextToHTML_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KTextToHTML_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KTextToHTML");
    return -1;
}

static PyObject *Sbk_KTextToHTMLFunc_convertToHtml(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "convertToHtml", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKTextToHTML_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:convertToHtml", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KTextToHTML::convertToHtml(QString,QFlags<KTextToHTML::Option>,int=,int=)->QString
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KTextToHTML_Option_IDX])))->flagsConverter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // convertToHtml(QString,QFlags<KTextToHTML::Option>,int,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // convertToHtml(QString,QFlags<KTextToHTML::Option>,int,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 0; // convertToHtml(QString,QFlags<KTextToHTML::Option>,int,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "convertToHtml", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKTextToHTML_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"maxUrlLen", 2}, {"maxAddressLen", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "convertToHtml", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKTextToHTML_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<KTextToHTML::Option> cppArg1 = QFlags<KTextToHTML::Option>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 4096;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = 255;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // convertToHtml(QString,QFlags<KTextToHTML::Option>,int,int)
            QString cppResult = ::KTextToHTML::convertToHtml(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KTextToHTML_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KTextToHTML_EnumFlagInfo[] = {
    "Option:IntFlag:Options",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KTextToHTML_methods[] = {
    {"convertToHtml", reinterpret_cast<PyCFunction>(Sbk_KTextToHTMLFunc_convertToHtml), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KTextToHTML_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KTextToHTML_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KTextToHTML_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KTextToHTML_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KTextToHTML_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KTextToHTML_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KTextToHTML_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KTextToHTML_spec = {
    "1:KCoreAddons.KTextToHTML",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KTextToHTML_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KTextToHTML_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KTextToHTML::Option>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KTextToHTML::Option *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KTextToHTML_Option_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KTextToHTML_Option_IDX])))
        return Enum_PythonToCpp_KTextToHTML_Option;
    return {};
}

static PyObject *KTextToHTML_Option_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KTextToHTML::Option>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KTextToHTML::Option *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KTextToHTML_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KTextToHTML::Option>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KTextToHTML::Option> *>(cppOut) = value;

}

static PyObject *KTextToHTML_Option_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KTextToHTML::Option> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KTextToHTML_Option_IDX]), flags.toInt());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKTextToHTML_SignatureStrings[] = {
    "KCoreAddons.KTextToHTML.convertToHtml(plainText:QString,options:KCoreAddons.KTextToHTML.Option,maxUrlLen:int=4096,maxAddressLen:int=255)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKTextToHTML_SignatureByteSize = 110;
static constexpr uint8_t KCoreAddonsKTextToHTML_SignatureBytes[110] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x0e,
    0x49, 0xad, 0x28, 0x09, 0xc9, 0xf7, 0x08, 0xf1, 0xf5, 0xd1, 0x4b, 0xce, 0xcf, 0x2b, 0x4b, 0x2d,
    0x02, 0xf1, 0x4a, 0x72, 0x73, 0x34, 0x0a, 0x72, 0x12, 0x33, 0xf3, 0x40, 0xb2, 0x56, 0x81, 0xc1,
    0x25, 0x45, 0x99, 0x79, 0xe9, 0x3a, 0xf9, 0x05, 0x25, 0x99, 0x40, 0x3d, 0x56, 0xde, 0x38, 0xf4,
    0xfb, 0x83, 0xe5, 0x75, 0x72, 0x13, 0x2b, 0x42, 0x8b, 0x72, 0x7c, 0x52, 0xf3, 0xac, 0x32, 0xf3,
    0x4a, 0x6c, 0x4d, 0x0c, 0x2c, 0xcd, 0x40, 0x42, 0x40, 0xf5, 0x45, 0xa9, 0xc5, 0xc5, 0x30, 0x61,
    0x23, 0x53, 0x53, 0x4d, 0x5d, 0x3b, 0xa8, 0xc9, 0x5c, 0x00, 0x77, 0xbb, 0x34, 0x7e
};
#endif

PyTypeObject *init_KCoreAddonsKTextToHTML(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKTextToHTML_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKTextToHTML_IDX].type;

    Shiboken::AutoDecRef Sbk_KTextToHTML_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KTextToHTML_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KTextToHTML",
        "KTextToHTML",
        &Sbk_KTextToHTML_spec,
        nullptr,
        Sbk_KTextToHTML_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KTextToHTML_Type; // references _Sbk_KTextToHTML_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKTextToHTML_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKTextToHTML_SignatureBytes, KCoreAddonsKTextToHTML_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KTextToHTML_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKTextToHTML_IDX].type = pyType;


    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KTextToHTML_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Option'.
    const char *Option_Initializer[] = {
        "PreserveSpaces",
        "ReplaceSmileys",
        "IgnoreUrls",
        "HighlightText",
        "ConvertPhoneNumbers",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Option_InitializerValues[] = {
        uint8_t(KTextToHTML::Option::PreserveSpaces),     //  0x02  2
        uint8_t(KTextToHTML::Option::ReplaceSmileys),     //  0x04  4
        uint8_t(KTextToHTML::Option::IgnoreUrls),         //  0x08  8
        uint8_t(KTextToHTML::Option::HighlightText),      //  0x10  16
        uint8_t(KTextToHTML::Option::ConvertPhoneNumbers) //  0x20  32
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KTextToHTML_TypeF(),
        "1:KCoreAddons.KTextToHTML.Option",
        Option_Initializer, Option_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KTextToHTML_Option_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKCoreAddonsTypeStructs[SBK_QFlags_KTextToHTML_Option_IDX].type =
        EType;
    // Register converter for enum 'KTextToHTML::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KTextToHTML_Option_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KTextToHTML_Option,
            is_Enum_PythonToCpp_KTextToHTML_Option_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KTextToHTML::Option");
        Shiboken::Conversions::registerConverterAlias(converter, "Option");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KTextToHTML_Option_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KTextToHTML_Option,
            is_Enum_PythonToCpp_KTextToHTML_Option_Convertible);
        // Register converter for flag 'QFlags<KTextToHTML::Option>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KTextToHTML::Option>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KTextToHTML::Options");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Option' enum/flags.

    qRegisterMetaType< ::KTextToHTML::Option >("KTextToHTML::Option");

    return pyType;
}
