#ifndef itkPyBufferSwigInterface_h
#define itkPyBufferSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkPyBuffer.h"
#include "itkPyVnl.h"

using itkPyBufferISC2 = itk::PyBuffer< itk::Image< signed char,2 > >;
using itkPyBufferISC3 = itk::PyBuffer< itk::Image< signed char,3 > >;
using itkPyBufferISC4 = itk::PyBuffer< itk::Image< signed char,4 > >;
using itkPyBufferISS2 = itk::PyBuffer< itk::Image< signed short,2 > >;
using itkPyBufferISS3 = itk::PyBuffer< itk::Image< signed short,3 > >;
using itkPyBufferISS4 = itk::PyBuffer< itk::Image< signed short,4 > >;
using itkPyBufferIUC2 = itk::PyBuffer< itk::Image< unsigned char,2 > >;
using itkPyBufferIRGBUC2 = itk::PyBuffer< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkPyBufferIRGBAUC2 = itk::PyBuffer< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkPyBufferIUC3 = itk::PyBuffer< itk::Image< unsigned char,3 > >;
using itkPyBufferIRGBUC3 = itk::PyBuffer< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkPyBufferIRGBAUC3 = itk::PyBuffer< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkPyBufferIUC4 = itk::PyBuffer< itk::Image< unsigned char,4 > >;
using itkPyBufferIRGBUC4 = itk::PyBuffer< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkPyBufferIRGBAUC4 = itk::PyBuffer< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkPyBufferIULL2 = itk::PyBuffer< itk::Image< unsigned long long,2 > >;
using itkPyBufferIULL3 = itk::PyBuffer< itk::Image< unsigned long long,3 > >;
using itkPyBufferIULL4 = itk::PyBuffer< itk::Image< unsigned long long,4 > >;
using itkPyBufferIUS2 = itk::PyBuffer< itk::Image< unsigned short,2 > >;
using itkPyBufferIRGBUS2 = itk::PyBuffer< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkPyBufferIRGBAUS2 = itk::PyBuffer< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkPyBufferIUS3 = itk::PyBuffer< itk::Image< unsigned short,3 > >;
using itkPyBufferIRGBUS3 = itk::PyBuffer< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkPyBufferIRGBAUS3 = itk::PyBuffer< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkPyBufferIUS4 = itk::PyBuffer< itk::Image< unsigned short,4 > >;
using itkPyBufferIRGBUS4 = itk::PyBuffer< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkPyBufferIRGBAUS4 = itk::PyBuffer< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkPyBufferIF2 = itk::PyBuffer< itk::Image< float,2 > >;
using itkPyBufferISSRTF22 = itk::PyBuffer< itk::Image< itk::SymmetricSecondRankTensor< float, 2 >, 2 > >;
using itkPyBufferIVF22 = itk::PyBuffer< itk::Image< itk::Vector< float,2 >,2 > >;
using itkPyBufferICVF22 = itk::PyBuffer< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkPyBufferIVF32 = itk::PyBuffer< itk::Image< itk::Vector< float,3 >,2 > >;
using itkPyBufferICVF32 = itk::PyBuffer< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkPyBufferIVF42 = itk::PyBuffer< itk::Image< itk::Vector< float,4 >,2 > >;
using itkPyBufferICVF42 = itk::PyBuffer< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkPyBufferIF3 = itk::PyBuffer< itk::Image< float,3 > >;
using itkPyBufferISSRTF33 = itk::PyBuffer< itk::Image< itk::SymmetricSecondRankTensor< float, 3 >, 3 > >;
using itkPyBufferIVF23 = itk::PyBuffer< itk::Image< itk::Vector< float,2 >,3 > >;
using itkPyBufferICVF23 = itk::PyBuffer< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkPyBufferIVF33 = itk::PyBuffer< itk::Image< itk::Vector< float,3 >,3 > >;
using itkPyBufferICVF33 = itk::PyBuffer< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkPyBufferIVF43 = itk::PyBuffer< itk::Image< itk::Vector< float,4 >,3 > >;
using itkPyBufferICVF43 = itk::PyBuffer< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkPyBufferIF4 = itk::PyBuffer< itk::Image< float,4 > >;
using itkPyBufferISSRTF44 = itk::PyBuffer< itk::Image< itk::SymmetricSecondRankTensor< float, 4 >, 4 > >;
using itkPyBufferIVF24 = itk::PyBuffer< itk::Image< itk::Vector< float,2 >,4 > >;
using itkPyBufferICVF24 = itk::PyBuffer< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkPyBufferIVF34 = itk::PyBuffer< itk::Image< itk::Vector< float,3 >,4 > >;
using itkPyBufferICVF34 = itk::PyBuffer< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkPyBufferIVF44 = itk::PyBuffer< itk::Image< itk::Vector< float,4 >,4 > >;
using itkPyBufferICVF44 = itk::PyBuffer< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkPyBufferID2 = itk::PyBuffer< itk::Image< double,2 > >;
using itkPyBufferISSRTD22 = itk::PyBuffer< itk::Image< itk::SymmetricSecondRankTensor< double, 2 >, 2 > >;
using itkPyBufferIVD22 = itk::PyBuffer< itk::Image< itk::Vector< double,2 >,2 > >;
using itkPyBufferICVD22 = itk::PyBuffer< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkPyBufferIVD32 = itk::PyBuffer< itk::Image< itk::Vector< double,3 >,2 > >;
using itkPyBufferICVD32 = itk::PyBuffer< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkPyBufferIVD42 = itk::PyBuffer< itk::Image< itk::Vector< double,4 >,2 > >;
using itkPyBufferICVD42 = itk::PyBuffer< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkPyBufferID3 = itk::PyBuffer< itk::Image< double,3 > >;
using itkPyBufferISSRTD33 = itk::PyBuffer< itk::Image< itk::SymmetricSecondRankTensor< double, 3 >, 3 > >;
using itkPyBufferIVD23 = itk::PyBuffer< itk::Image< itk::Vector< double,2 >,3 > >;
using itkPyBufferICVD23 = itk::PyBuffer< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkPyBufferIVD33 = itk::PyBuffer< itk::Image< itk::Vector< double,3 >,3 > >;
using itkPyBufferICVD33 = itk::PyBuffer< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkPyBufferIVD43 = itk::PyBuffer< itk::Image< itk::Vector< double,4 >,3 > >;
using itkPyBufferICVD43 = itk::PyBuffer< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkPyBufferID4 = itk::PyBuffer< itk::Image< double,4 > >;
using itkPyBufferISSRTD44 = itk::PyBuffer< itk::Image< itk::SymmetricSecondRankTensor< double, 4 >, 4 > >;
using itkPyBufferIVD24 = itk::PyBuffer< itk::Image< itk::Vector< double,2 >,4 > >;
using itkPyBufferICVD24 = itk::PyBuffer< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkPyBufferIVD34 = itk::PyBuffer< itk::Image< itk::Vector< double,3 >,4 > >;
using itkPyBufferICVD34 = itk::PyBuffer< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkPyBufferIVD44 = itk::PyBuffer< itk::Image< itk::Vector< double,4 >,4 > >;
using itkPyBufferICVD44 = itk::PyBuffer< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkPyBufferIUI2 = itk::PyBuffer< itk::Image< unsigned int,2 > >;
using itkPyBufferIUI3 = itk::PyBuffer< itk::Image< unsigned int,3 > >;
using itkPyBufferIUI4 = itk::PyBuffer< itk::Image< unsigned int,4 > >;
using itkPyBufferIUL2 = itk::PyBuffer< itk::Image< unsigned long,2 > >;
using itkPyBufferIUL3 = itk::PyBuffer< itk::Image< unsigned long,3 > >;
using itkPyBufferIUL4 = itk::PyBuffer< itk::Image< unsigned long,4 > >;
using itkPyBufferISI2 = itk::PyBuffer< itk::Image< signed int,2 > >;
using itkPyBufferISI3 = itk::PyBuffer< itk::Image< signed int,3 > >;
using itkPyBufferISI4 = itk::PyBuffer< itk::Image< signed int,4 > >;
using itkPyBufferVISC2 = itk::PyBuffer< itk::VectorImage< signed char,2 > >;
using itkPyBufferVISS2 = itk::PyBuffer< itk::VectorImage< signed short,2 > >;
using itkPyBufferVIUC2 = itk::PyBuffer< itk::VectorImage< unsigned char,2 > >;
using itkPyBufferVIULL2 = itk::PyBuffer< itk::VectorImage< unsigned long long,2 > >;
using itkPyBufferVIUS2 = itk::PyBuffer< itk::VectorImage< unsigned short,2 > >;
using itkPyBufferVIF2 = itk::PyBuffer< itk::VectorImage< float,2 > >;
using itkPyBufferVID2 = itk::PyBuffer< itk::VectorImage< double,2 > >;
using itkPyBufferVISC3 = itk::PyBuffer< itk::VectorImage< signed char,3 > >;
using itkPyBufferVISS3 = itk::PyBuffer< itk::VectorImage< signed short,3 > >;
using itkPyBufferVIUC3 = itk::PyBuffer< itk::VectorImage< unsigned char,3 > >;
using itkPyBufferVIULL3 = itk::PyBuffer< itk::VectorImage< unsigned long long,3 > >;
using itkPyBufferVIUS3 = itk::PyBuffer< itk::VectorImage< unsigned short,3 > >;
using itkPyBufferVIF3 = itk::PyBuffer< itk::VectorImage< float,3 > >;
using itkPyBufferVID3 = itk::PyBuffer< itk::VectorImage< double,3 > >;
using itkPyBufferVISC4 = itk::PyBuffer< itk::VectorImage< signed char,4 > >;
using itkPyBufferVISS4 = itk::PyBuffer< itk::VectorImage< signed short,4 > >;
using itkPyBufferVIUC4 = itk::PyBuffer< itk::VectorImage< unsigned char,4 > >;
using itkPyBufferVIULL4 = itk::PyBuffer< itk::VectorImage< unsigned long long,4 > >;
using itkPyBufferVIUS4 = itk::PyBuffer< itk::VectorImage< unsigned short,4 > >;
using itkPyBufferVIF4 = itk::PyBuffer< itk::VectorImage< float,4 > >;
using itkPyBufferVID4 = itk::PyBuffer< itk::VectorImage< double,4 > >;
using itkPyVnlSC = itk::PyVnl< signed char >;
using itkPyVnlSS = itk::PyVnl< signed short >;
using itkPyVnlUC = itk::PyVnl< unsigned char >;
using itkPyVnlULL = itk::PyVnl< unsigned long long >;
using itkPyVnlUS = itk::PyVnl< unsigned short >;
using itkPyVnlF = itk::PyVnl< float >;
using itkPyVnlD = itk::PyVnl< double >;
using itkPyVnlUI = itk::PyVnl< unsigned int >;
using itkPyVnlUL = itk::PyVnl< unsigned long >;
using itkPyVnlSI = itk::PyVnl< signed int >;
using itkPyVnlSL = itk::PyVnl< signed long >;
using itkPyVnlSLL = itk::PyVnl< signed long long >;


#include "itkImageSwigInterface.h"
#include "itkPyBufferSwigInterface.h"
#include "vnl_vectorSwigInterface.h"
#include "itkVectorImageSwigInterface.h"
#include "vnl_matrixSwigInterface.h"
#endif
