#ifndef itkNeighborhoodSwigInterface_h
#define itkNeighborhoodSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkNeighborhood.h"

using itkNeighborhoodSC2 = itk::Neighborhood< signed char,2 >;
using itkNeighborhoodSS2 = itk::Neighborhood< signed short,2 >;
using itkNeighborhoodUC2 = itk::Neighborhood< unsigned char,2 >;
using itkNeighborhoodULL2 = itk::Neighborhood< unsigned long long,2 >;
using itkNeighborhoodUS2 = itk::Neighborhood< unsigned short,2 >;
using itkNeighborhoodF2 = itk::Neighborhood< float,2 >;
using itkNeighborhoodD2 = itk::Neighborhood< double,2 >;
using itkNeighborhoodRGBUC2 = itk::Neighborhood< itk::RGBPixel< unsigned char >,2 >;
using itkNeighborhoodRGBUS2 = itk::Neighborhood< itk::RGBPixel< unsigned short >,2 >;
using itkNeighborhoodB2 = itk::Neighborhood< bool,2 >;
using itkNeighborhoodVD22 = itk::Neighborhood< itk::Vector< double,2 >,2 >;
using itkNeighborhoodVF22 = itk::Neighborhood< itk::Vector< float,2 >,2 >;
using itkNeighborhoodCVD22 = itk::Neighborhood< itk::CovariantVector< double,2 >,2 >;
using itkNeighborhoodCVF22 = itk::Neighborhood< itk::CovariantVector< float,2 >,2 >;
using itkNeighborhoodSC3 = itk::Neighborhood< signed char,3 >;
using itkNeighborhoodSS3 = itk::Neighborhood< signed short,3 >;
using itkNeighborhoodUC3 = itk::Neighborhood< unsigned char,3 >;
using itkNeighborhoodULL3 = itk::Neighborhood< unsigned long long,3 >;
using itkNeighborhoodUS3 = itk::Neighborhood< unsigned short,3 >;
using itkNeighborhoodF3 = itk::Neighborhood< float,3 >;
using itkNeighborhoodD3 = itk::Neighborhood< double,3 >;
using itkNeighborhoodRGBUC3 = itk::Neighborhood< itk::RGBPixel< unsigned char >,3 >;
using itkNeighborhoodRGBUS3 = itk::Neighborhood< itk::RGBPixel< unsigned short >,3 >;
using itkNeighborhoodB3 = itk::Neighborhood< bool,3 >;
using itkNeighborhoodVD33 = itk::Neighborhood< itk::Vector< double,3 >,3 >;
using itkNeighborhoodVF33 = itk::Neighborhood< itk::Vector< float,3 >,3 >;
using itkNeighborhoodCVD33 = itk::Neighborhood< itk::CovariantVector< double,3 >,3 >;
using itkNeighborhoodCVF33 = itk::Neighborhood< itk::CovariantVector< float,3 >,3 >;
using itkNeighborhoodSC4 = itk::Neighborhood< signed char,4 >;
using itkNeighborhoodSS4 = itk::Neighborhood< signed short,4 >;
using itkNeighborhoodUC4 = itk::Neighborhood< unsigned char,4 >;
using itkNeighborhoodULL4 = itk::Neighborhood< unsigned long long,4 >;
using itkNeighborhoodUS4 = itk::Neighborhood< unsigned short,4 >;
using itkNeighborhoodF4 = itk::Neighborhood< float,4 >;
using itkNeighborhoodD4 = itk::Neighborhood< double,4 >;
using itkNeighborhoodRGBUC4 = itk::Neighborhood< itk::RGBPixel< unsigned char >,4 >;
using itkNeighborhoodRGBUS4 = itk::Neighborhood< itk::RGBPixel< unsigned short >,4 >;
using itkNeighborhoodB4 = itk::Neighborhood< bool,4 >;
using itkNeighborhoodVD44 = itk::Neighborhood< itk::Vector< double,4 >,4 >;
using itkNeighborhoodVF44 = itk::Neighborhood< itk::Vector< float,4 >,4 >;
using itkNeighborhoodCVD44 = itk::Neighborhood< itk::CovariantVector< double,4 >,4 >;
using itkNeighborhoodCVF44 = itk::Neighborhood< itk::CovariantVector< float,4 >,4 >;


#include "ITKCommonBaseSwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkRGBPixelSwigInterface.h"
#include "itkSizeSwigInterface.h"
#include "itkNeighborhoodSwigInterface.h"
#include "itkCovariantVectorSwigInterface.h"
#include "itkOffsetSwigInterface.h"
#endif
