//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/internal_redirect/allow_listed_routes/v3/allow_listed_routes_config.proto

package allow_listed_routesv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on AllowListedRoutesConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AllowListedRoutesConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AllowListedRoutesConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AllowListedRoutesConfigMultiError, or nil if none found.
func (m *AllowListedRoutesConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *AllowListedRoutesConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetAllowedRouteNames() {
		_, _ = idx, item

		if utf8.RuneCountInString(item) < 1 {
			err := AllowListedRoutesConfigValidationError{
				field:  fmt.Sprintf("AllowedRouteNames[%v]", idx),
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return AllowListedRoutesConfigMultiError(errors)
	}

	return nil
}

// AllowListedRoutesConfigMultiError is an error wrapping multiple validation
// errors returned by AllowListedRoutesConfig.ValidateAll() if the designated
// constraints aren't met.
type AllowListedRoutesConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AllowListedRoutesConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AllowListedRoutesConfigMultiError) AllErrors() []error { return m }

// AllowListedRoutesConfigValidationError is the validation error returned by
// AllowListedRoutesConfig.Validate if the designated constraints aren't met.
type AllowListedRoutesConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AllowListedRoutesConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AllowListedRoutesConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AllowListedRoutesConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AllowListedRoutesConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AllowListedRoutesConfigValidationError) ErrorName() string {
	return "AllowListedRoutesConfigValidationError"
}

// Error satisfies the builtin error interface
func (e AllowListedRoutesConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAllowListedRoutesConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AllowListedRoutesConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AllowListedRoutesConfigValidationError{}
