# 13 "length.mll"
 
open Lexing

exception ConversionFailure
;;

let base_font_size = 12 (* Reasonable default: 1em = 12pt; units: pt *)
;;

let base_font_size_float = float base_font_size
;;

(*  [base_font_relative_ex_size_float] is just a heuristic; any value
 *  between 0.42 to 0.54 seems reasonable, i.e. is backed by fonts
 *  actually used in browsers.
 *
 *  W3C: "In the cases where it is impossible or impractical to
 *  determine the x-height, a value of 0.5em should be used." *)
let base_font_relative_ex_size_float = 0.5
;;

let points_per_pixel = 0.75 (* W3C definition: 12pt = 16px; units: pt/px *)
and pixels_per_char = 16 (* units: px/char *)
;;

let pixel_to_char x = (100 * x + 50) / (100 * pixels_per_char)
and pixel_to_char_float x = float_of_int x /. float_of_int pixels_per_char
and char_to_pixel x = pixels_per_char * x
;;

type t =
  | Char of int
  | Pixel of int
  | Percent of int
  | NotALength of string
  | Default

let pretty = function
  | Char x -> string_of_int x ^ " chars"
  | Pixel x -> string_of_int x ^ " pxls"
  | Percent x -> string_of_int x ^ "%"
  | Default -> "default"
  | NotALength s -> "*" ^ s ^ "*"

let is_zero = function
  | Char 0 | Pixel 0 | Percent 0 -> true
  | _ -> false

let as_number_of_chars = function
  | Char n -> n
  | Pixel x -> pixel_to_char x
  | Percent _ | NotALength _ | Default -> raise ConversionFailure
;;

let pixel_of_em x = Pixel (int_of_float (Float.round (float_of_int pixels_per_char *. x)))
and pixel_of_point x = Pixel (int_of_float (Float.round (x /. points_per_pixel)))
and as_percent x = Percent (int_of_float (Float.round x))

let convert unit x =
  (* mainly TeX Book, Chapter 10 *)
  match unit with
  | "bp" -> pixel_of_point (x *. 72.27 /. 72.0)
  | "cc" -> pixel_of_point (x *. 14856.0 /. 1157.0)
  | "cm" -> pixel_of_em ((x *. 28.47) /. base_font_size_float)
  | "dd" -> pixel_of_point (x *. 1238.0 /. 1157.0)
  | "em" -> pixel_of_em x
  | "ex" -> pixel_of_em (x *. base_font_relative_ex_size_float)
  | "in" -> pixel_of_em ((x *. 72.27) /. base_font_size_float)
  | "mm" -> pixel_of_em ((x *. 2.847) /. base_font_size_float)
  | "pc" -> pixel_of_em ((x *. 12.0)  /. base_font_size_float)
  | "pt" -> pixel_of_point x
  | "sp" -> pixel_of_point (x /. 65536.0)
  | "@percent" -> as_percent (100.0 *. x)
  | _ -> NotALength unit
;;


# 80 "length.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\255\255\000\000\000\000\017\000\029\000\039\000\000\000\
    \000\000\000\000\001\000\000\000\000\000\254\255\000\000\002\000\
    \007\000";
  Lexing.lex_backtrk =
   "\001\000\255\255\002\000\255\255\255\255\000\000\000\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\001\000\001\000\
    \000\000";
  Lexing.lex_default =
   "\255\255\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\000\000\015\000\015\000\
    \255\255";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\016\000\016\000\255\255\255\255\016\000\000\000\255\255\
    \016\000\016\000\000\000\000\000\016\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \016\000\000\000\255\255\000\000\000\000\000\000\000\000\016\000\
    \000\000\000\000\000\000\000\000\000\000\001\000\004\000\000\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \003\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\004\000\000\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\000\000\000\000\010\000\000\000\008\000\011\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\012\000\000\000\
    \007\000\000\000\009\000\000\000\013\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\014\000\014\000\015\000\015\000\014\000\255\255\015\000\
    \016\000\016\000\255\255\255\255\016\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \014\000\255\255\015\000\255\255\255\255\255\255\255\255\016\000\
    \255\255\255\255\255\255\255\255\255\255\000\000\002\000\255\255\
    \002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
    \002\000\002\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \002\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\005\000\255\255\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\255\255\255\255\009\000\255\255\007\000\010\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\011\000\255\255\
    \003\000\255\255\008\000\255\255\012\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \014\000\255\255\015\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    ";
  Lexing.lex_base_code =
   "";
  Lexing.lex_backtrk_code =
   "";
  Lexing.lex_default_code =
   "";
  Lexing.lex_trans_code =
   "";
  Lexing.lex_check_code =
   "";
  Lexing.lex_code =
   "";
}

let rec main_rule lexbuf =
   __ocaml_lex_main_rule_rec lexbuf 0
and __ocaml_lex_main_rule_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 92 "length.mll"
      (let x, unit = positif lexbuf in convert unit (0.0 -. x))
# 193 "length.ml"

  | 1 ->
# 93 "length.mll"
      (let x, unit = positif lexbuf in convert unit x)
# 198 "length.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_main_rule_rec lexbuf __ocaml_lex_state

and positif lexbuf =
   __ocaml_lex_positif_rec lexbuf 2
and __ocaml_lex_positif_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 97 "length.mll"
   (let lxm = lexeme lexbuf in float_of_string lxm, unit lexbuf)
# 210 "length.ml"

  | 1 ->
# 98 "length.mll"
             (1.0, "@percent")
# 215 "length.ml"

  | 2 ->
# 99 "length.mll"
     (raise ConversionFailure)
# 220 "length.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_positif_rec lexbuf __ocaml_lex_state

and unit lexbuf =
   __ocaml_lex_unit_rec lexbuf 14
and __ocaml_lex_unit_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 101 "length.mll"
                     (unit lexbuf)
# 232 "length.ml"

  | 1 ->
# 102 "length.mll"
                      (lexeme lexbuf)
# 237 "length.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_unit_rec lexbuf __ocaml_lex_state

;;

# 104 "length.mll"
 
open Lexing

let main lexbuf =
  try main_rule lexbuf with
  | ConversionFailure ->
      let sbuf = lexbuf.lex_buffer in
      NotALength (Bytes.sub_string sbuf 0 lexbuf.lex_buffer_len)

# 254 "length.ml"
