{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node using a GL shader when drawing its children nodes.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.GLShaderNode
    ( 

-- * Exported types
    GLShaderNode(..)                        ,
    IsGLShaderNode                          ,
    toGLShaderNode                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getArgs]("GI.Gsk.Objects.GLShaderNode#g:method:getArgs"), [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.GLShaderNode#g:method:getChild"), [getNChildren]("GI.Gsk.Objects.GLShaderNode#g:method:getNChildren"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getShader]("GI.Gsk.Objects.GLShaderNode#g:method:getShader").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveGLShaderNodeMethod               ,
#endif

-- ** getArgs #method:getArgs#

#if defined(ENABLE_OVERLOADING)
    GLShaderNodeGetArgsMethodInfo           ,
#endif
    gLShaderNodeGetArgs                     ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    GLShaderNodeGetChildMethodInfo          ,
#endif
    gLShaderNodeGetChild                    ,


-- ** getNChildren #method:getNChildren#

#if defined(ENABLE_OVERLOADING)
    GLShaderNodeGetNChildrenMethodInfo      ,
#endif
    gLShaderNodeGetNChildren                ,


-- ** getShader #method:getShader#

#if defined(ENABLE_OVERLOADING)
    GLShaderNodeGetShaderMethodInfo         ,
#endif
    gLShaderNodeGetShader                   ,


-- ** new #method:new#

    gLShaderNodeNew                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#else
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype GLShaderNode = GLShaderNode (SP.ManagedPtr GLShaderNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype GLShaderNode where
    toManagedPtr (GLShaderNode p) = p

foreign import ccall "gsk_gl_shader_node_get_type"
    c_gsk_gl_shader_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject GLShaderNode where
    glibType = c_gsk_gl_shader_node_get_type

-- | Type class for types which can be safely cast to t'GLShaderNode', for instance with `toGLShaderNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf GLShaderNode o) => IsGLShaderNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf GLShaderNode o) => IsGLShaderNode o

instance O.HasParentTypes GLShaderNode
type instance O.ParentTypes GLShaderNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'GLShaderNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toGLShaderNode :: (MIO.MonadIO m, IsGLShaderNode o) => o -> m GLShaderNode
toGLShaderNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo GLShaderNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveGLShaderNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGLShaderNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveGLShaderNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveGLShaderNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveGLShaderNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveGLShaderNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveGLShaderNodeMethod "getArgs" o = GLShaderNodeGetArgsMethodInfo
    ResolveGLShaderNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveGLShaderNodeMethod "getChild" o = GLShaderNodeGetChildMethodInfo
    ResolveGLShaderNodeMethod "getNChildren" o = GLShaderNodeGetNChildrenMethodInfo
    ResolveGLShaderNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveGLShaderNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveGLShaderNodeMethod "getShader" o = GLShaderNodeGetShaderMethodInfo
    ResolveGLShaderNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGLShaderNodeMethod t GLShaderNode, O.OverloadedMethod info GLShaderNode p) => OL.IsLabel t (GLShaderNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGLShaderNodeMethod t GLShaderNode, O.OverloadedMethod info GLShaderNode p, R.HasField t GLShaderNode p) => R.HasField t GLShaderNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGLShaderNodeMethod t GLShaderNode, O.OverloadedMethodInfo info GLShaderNode) => OL.IsLabel t (O.MethodProxy info GLShaderNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr GLShaderNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method GLShaderNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "shader"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "GLShader" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GskGLShader`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bounds"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the rectangle to render the shader into"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "args"
--           , argType = TInterface Name { namespace = "GLib" , name = "Bytes" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Arguments for the uniforms"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "children"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 4
--                 (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "array of child nodes,\n  these will be rendered to textures and used as input."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_children"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Length of @children (currently the GL backend supports\n  up to 4 children)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_children"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "Length of @children (currently the GL backend supports\n  up to 4 children)"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "Gsk" , name = "GLShaderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_gl_shader_node_new" gsk_gl_shader_node_new :: 
    Ptr Gsk.GLShader.GLShader ->            -- shader : TInterface (Name {namespace = "Gsk", name = "GLShader"})
    Ptr Graphene.Rect.Rect ->               -- bounds : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr GLib.Bytes.Bytes ->                 -- args : TInterface (Name {namespace = "GLib", name = "Bytes"})
    Ptr (Ptr Gsk.RenderNode.RenderNode) ->  -- children : TCArray False (-1) 4 (TInterface (Name {namespace = "Gsk", name = "RenderNode"}))
    Word32 ->                               -- n_children : TBasicType TUInt
    IO (Ptr GLShaderNode)

{-# DEPRECATED gLShaderNodeNew ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Creates a @GskRenderNode@ that will render the given /@shader@/ into the
-- area given by /@bounds@/.
-- 
-- The /@args@/ is a block of data to use for uniform input, as per types and
-- offsets defined by the /@shader@/. Normally this is generated by
-- t'GI.Gsk.Objects.GLShader.GLShader'.@/format_args/@() or t'GI.Gsk.Structs.ShaderArgsBuilder.ShaderArgsBuilder'.
-- 
-- See t'GI.Gsk.Objects.GLShader.GLShader' for details about how the shader should be written.
-- 
-- All the children will be rendered into textures (if they aren\'t already
-- @GskTextureNodes@, which will be used directly). These textures will be
-- sent as input to the shader.
-- 
-- If the renderer doesn\'t support GL shaders, or if there is any problem
-- when compiling the shader, then the node will draw pink. You should use
-- 'GI.Gsk.Objects.GLShader.gLShaderCompile' to ensure the /@shader@/ will work for the
-- renderer before using it.
gLShaderNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.GLShader.IsGLShader a) =>
    a
    -- ^ /@shader@/: the @GskGLShader@
    -> Graphene.Rect.Rect
    -- ^ /@bounds@/: the rectangle to render the shader into
    -> GLib.Bytes.Bytes
    -- ^ /@args@/: Arguments for the uniforms
    -> Maybe ([Gsk.RenderNode.RenderNode])
    -- ^ /@children@/: array of child nodes,
    --   these will be rendered to textures and used as input.
    -> m GLShaderNode
    -- ^ __Returns:__ A new @GskRenderNode@
gLShaderNodeNew shader bounds args children = liftIO $ do
    let nChildren = case children of
            Nothing -> 0
            Just jChildren -> fromIntegral $ P.length jChildren
    shader' <- unsafeManagedPtrCastPtr shader
    bounds' <- unsafeManagedPtrGetPtr bounds
    args' <- unsafeManagedPtrGetPtr args
    maybeChildren <- case children of
        Nothing -> return FP.nullPtr
        Just jChildren -> do
            jChildren' <- mapM unsafeManagedPtrCastPtr jChildren
            jChildren'' <- packPtrArray jChildren'
            return jChildren''
    result <- gsk_gl_shader_node_new shader' bounds' args' maybeChildren nChildren
    checkUnexpectedReturnNULL "gLShaderNodeNew" result
    result' <- (wrapPtr GLShaderNode) result
    touchManagedPtr shader
    touchManagedPtr bounds
    touchManagedPtr args
    whenJust children (mapM_ touchManagedPtr)
    freeMem maybeChildren
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GLShaderNode::get_args
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "GLShaderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a gl shader"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Bytes" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_gl_shader_node_get_args" gsk_gl_shader_node_get_args :: 
    Ptr GLShaderNode ->                     -- node : TInterface (Name {namespace = "Gsk", name = "GLShaderNode"})
    IO (Ptr GLib.Bytes.Bytes)

{-# DEPRECATED gLShaderNodeGetArgs ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Gets args for the node.
gLShaderNodeGetArgs ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLShaderNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a gl shader
    -> m GLib.Bytes.Bytes
    -- ^ __Returns:__ A @GBytes@ with the uniform arguments
gLShaderNodeGetArgs node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_gl_shader_node_get_args node'
    checkUnexpectedReturnNULL "gLShaderNodeGetArgs" result
    result' <- (newBoxed GLib.Bytes.Bytes) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data GLShaderNodeGetArgsMethodInfo
instance (signature ~ (m GLib.Bytes.Bytes), MonadIO m, IsGLShaderNode a) => O.OverloadedMethod GLShaderNodeGetArgsMethodInfo a signature where
    overloadedMethod = gLShaderNodeGetArgs

instance O.OverloadedMethodInfo GLShaderNodeGetArgsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.GLShaderNode.gLShaderNodeGetArgs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-GLShaderNode.html#v:gLShaderNodeGetArgs"
        })


#endif

-- method GLShaderNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "GLShaderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a gl shader"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "idx"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the child to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_gl_shader_node_get_child" gsk_gl_shader_node_get_child :: 
    Ptr GLShaderNode ->                     -- node : TInterface (Name {namespace = "Gsk", name = "GLShaderNode"})
    Word32 ->                               -- idx : TBasicType TUInt
    IO (Ptr Gsk.RenderNode.RenderNode)

{-# DEPRECATED gLShaderNodeGetChild ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Gets one of the children.
gLShaderNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLShaderNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a gl shader
    -> Word32
    -- ^ /@idx@/: the position of the child to get
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ the /@idx@/\'th child of /@node@/
gLShaderNodeGetChild node idx = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_gl_shader_node_get_child node' idx
    checkUnexpectedReturnNULL "gLShaderNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data GLShaderNodeGetChildMethodInfo
instance (signature ~ (Word32 -> m Gsk.RenderNode.RenderNode), MonadIO m, IsGLShaderNode a) => O.OverloadedMethod GLShaderNodeGetChildMethodInfo a signature where
    overloadedMethod = gLShaderNodeGetChild

instance O.OverloadedMethodInfo GLShaderNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.GLShaderNode.gLShaderNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-GLShaderNode.html#v:gLShaderNodeGetChild"
        })


#endif

-- method GLShaderNode::get_n_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "GLShaderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a gl shader"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_gl_shader_node_get_n_children" gsk_gl_shader_node_get_n_children :: 
    Ptr GLShaderNode ->                     -- node : TInterface (Name {namespace = "Gsk", name = "GLShaderNode"})
    IO Word32

{-# DEPRECATED gLShaderNodeGetNChildren ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Returns the number of children
gLShaderNodeGetNChildren ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLShaderNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a gl shader
    -> m Word32
    -- ^ __Returns:__ The number of children
gLShaderNodeGetNChildren node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_gl_shader_node_get_n_children node'
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data GLShaderNodeGetNChildrenMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsGLShaderNode a) => O.OverloadedMethod GLShaderNodeGetNChildrenMethodInfo a signature where
    overloadedMethod = gLShaderNodeGetNChildren

instance O.OverloadedMethodInfo GLShaderNodeGetNChildrenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.GLShaderNode.gLShaderNodeGetNChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-GLShaderNode.html#v:gLShaderNodeGetNChildren"
        })


#endif

-- method GLShaderNode::get_shader
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "GLShaderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a gl shader"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "GLShader" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_gl_shader_node_get_shader" gsk_gl_shader_node_get_shader :: 
    Ptr GLShaderNode ->                     -- node : TInterface (Name {namespace = "Gsk", name = "GLShaderNode"})
    IO (Ptr Gsk.GLShader.GLShader)

-- | Gets shader code for the node.
gLShaderNodeGetShader ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLShaderNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a gl shader
    -> m Gsk.GLShader.GLShader
    -- ^ __Returns:__ the @GskGLShader@ shader
gLShaderNodeGetShader node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_gl_shader_node_get_shader node'
    checkUnexpectedReturnNULL "gLShaderNodeGetShader" result
    result' <- (newObject Gsk.GLShader.GLShader) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data GLShaderNodeGetShaderMethodInfo
instance (signature ~ (m Gsk.GLShader.GLShader), MonadIO m, IsGLShaderNode a) => O.OverloadedMethod GLShaderNodeGetShaderMethodInfo a signature where
    overloadedMethod = gLShaderNodeGetShader

instance O.OverloadedMethodInfo GLShaderNodeGetShaderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.GLShaderNode.gLShaderNodeGetShader",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-GLShaderNode.html#v:gLShaderNodeGetShader"
        })


#endif


