{-# LANGUAGE PatternSynonyms, ScopedTypeVariables, ViewPatterns #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Constants
    ( 
    pattern VEC4_LEN                        ,
    pattern VEC3_LEN                        ,
    pattern VEC2_LEN                        ,
    pattern PI_2                            ,
    pattern PI                              ,

    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Evaluates to the number of components of a t'GI.Graphene.Structs.Vec4.Vec4'.
-- 
-- This symbol is useful when declaring a C array of floating
-- point values to be used with 'GI.Graphene.Structs.Vec4.vec4InitFromFloat' and
-- 'GI.Graphene.Structs.Vec4.vec4ToFloat', e.g.
-- 
-- 
-- 	
-- >
-- >  float v[GRAPHENE_VEC4_LEN];
-- >
-- >  // vec is defined elsewhere
-- >  graphene_vec4_to_float (&vec, v);
-- >
-- >  for (int i = 0; i < GRAPHENE_VEC4_LEN; i++)
-- >    fprintf (stdout, "component %d: %g\n", i, v[i]);
-- 
-- 
-- /Since: 1.0/
pattern VEC4_LEN = 4 :: Int32

-- | Evaluates to the number of components of a t'GI.Graphene.Structs.Vec3.Vec3'.
-- 
-- This symbol is useful when declaring a C array of floating
-- point values to be used with 'GI.Graphene.Structs.Vec3.vec3InitFromFloat' and
-- 'GI.Graphene.Structs.Vec3.vec3ToFloat', e.g.
-- 
-- 
-- 	
-- >
-- >  float v[GRAPHENE_VEC3_LEN];
-- >
-- >  // vec is defined elsewhere
-- >  graphene_vec3_to_float (&vec, v);
-- >
-- >  for (int i = 0; i < GRAPHENE_VEC2_LEN; i++)
-- >    fprintf (stdout, "component %d: %g\n", i, v[i]);
-- 
-- 
-- /Since: 1.0/
pattern VEC3_LEN = 3 :: Int32

-- | Evaluates to the number of components of a t'GI.Graphene.Structs.Vec2.Vec2'.
-- 
-- This symbol is useful when declaring a C array of floating
-- point values to be used with 'GI.Graphene.Structs.Vec2.vec2InitFromFloat' and
-- 'GI.Graphene.Structs.Vec2.vec2ToFloat', e.g.
-- 
-- 
-- 	
-- >
-- >  float v[GRAPHENE_VEC2_LEN];
-- >
-- >  // vec is defined elsewhere
-- >  graphene_vec2_to_float (&vec, v);
-- >
-- >  for (int i = 0; i < GRAPHENE_VEC2_LEN; i++)
-- >    fprintf (stdout, "component %d: %g\n", i, v[i]);
-- 
-- 
-- /Since: 1.0/
pattern VEC2_LEN = 2 :: Int32

-- | /No description available in the introspection data./
pattern PI_2 = 1.570796 :: Double

-- | /No description available in the introspection data./
pattern PI = 3.141593 :: Double


