// Generated by gmmproc 2.66.8 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/menuitem.h>
#include <gtkmm/private/menuitem_p.h>


/*
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtk/gtk.h>
#include <gtkmm/label.h>
#include <gtkmm/misc.h>
#include <gtkmm/menu.h>
#include <gtkmm/box.h>
#include <gtkmm/window.h>
#include <gtkmm/menubar.h>
#include <gtkmm/accelgroup.h>
#include <gtkmm/accelmap.h>

// gtk_menu_item_(de)select are just a wrapper for gtk_item_(de)select
// and defined in Gtk_Item, so they do not be redefined here

namespace Gtk
{


MenuItem::MenuItem(Widget& widget)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Bin(Glib::ConstructParams(menuitem_class_.init()))
{
  add(widget);
}

MenuItem::MenuItem(const Glib::ustring& label, bool mnemonic)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Bin(Glib::ConstructParams(menuitem_class_.init()))
{
  add_accel_label(label, mnemonic); /* Left-aligned label */
}

void MenuItem::add_accel_label(const Glib::ustring& label, bool mnemonic)
{
  set_label(label);
  set_use_underline(mnemonic);
}

void MenuItem::set_accel_key(const AccelKey& accel_key)
{
  accel_key_ = accel_key;
}

bool MenuItem::has_submenu() const
{
  return get_submenu() != nullptr;
}

void MenuItem::accelerate(Window& window)
{
  if(!accel_key_.is_null())
  {
#ifndef GTKMM_DISABLE_DEPRECATED

    auto accel_group = window.get_accel_group();
#else
    // Gtk::Window::get_accel_group() does not exist if gtkmm is built
    // without deprecated API.
    Glib::RefPtr<AccelGroup> accel_group;
    auto accel_groups = window.get_accel_groups();
    if (accel_groups.empty())
    {
      // Create an AccelGroup for window, if there is none.
      accel_group = AccelGroup::create();
      window.add_accel_group(accel_group);
    }
    else
      accel_group = accel_groups[0];
#endif // GTKMM_DISABLE_DEPRECATED


    if(accel_key_.get_path().empty())
    {
      add_accelerator("activate", accel_group,
                      accel_key_.get_key(), accel_key_.get_mod(), ACCEL_VISIBLE);
    }
    else
    {
      AccelMap::add_entry(accel_key_.get_path().raw(),
                          accel_key_.get_key(),
                          accel_key_.get_mod());

      Bin::set_accel_path(accel_key_.get_path(), accel_group);
    }
  }

  if(has_submenu())
    get_submenu()->accelerate(window);
}

void MenuItem::unset_accel_path()
{
  gtk_menu_item_set_accel_path(gobj(), nullptr);
}

void MenuItem::unset_submenu()
{
  gtk_menu_item_set_submenu(gobj(), nullptr);
}

} // namespace Gtk

namespace
{


static const Glib::SignalProxyInfo MenuItem_signal_activate_info =
{
  "activate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo MenuItem_signal_activate_item_info =
{
  "activate_item",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void MenuItem_signal_toggle_size_request_callback(GtkMenuItem* self, int* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,int* >;

  auto obj = dynamic_cast<MenuItem*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo MenuItem_signal_toggle_size_request_info =
{
  "toggle_size_request",
  (GCallback) &MenuItem_signal_toggle_size_request_callback,
  (GCallback) &MenuItem_signal_toggle_size_request_callback
};


static void MenuItem_signal_toggle_size_allocate_callback(GtkMenuItem* self, gint p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,int >;

  auto obj = dynamic_cast<MenuItem*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo MenuItem_signal_toggle_size_allocate_info =
{
  "toggle_size_allocate",
  (GCallback) &MenuItem_signal_toggle_size_allocate_callback,
  (GCallback) &MenuItem_signal_toggle_size_allocate_callback
};


static const Glib::SignalProxyInfo MenuItem_signal_select_info =
{
  "select",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo MenuItem_signal_deselect_info =
{
  "deselect",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

Gtk::MenuItem* wrap(GtkMenuItem* object, bool take_copy)
{
  return dynamic_cast<Gtk::MenuItem *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& MenuItem_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &MenuItem_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_menu_item_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Activatable::add_interface(get_type());

  }

  return *this;
}


void MenuItem_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->activate = &activate_callback;
  klass->activate_item = &activate_item_callback;
  klass->toggle_size_request = &toggle_size_request_callback;
  klass->toggle_size_allocate = &toggle_size_allocate_callback;
}


void MenuItem_Class::activate_callback(GtkMenuItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_activate();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->activate)
    (*base->activate)(self);
}
void MenuItem_Class::activate_item_callback(GtkMenuItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_activate_item();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->activate_item)
    (*base->activate_item)(self);
}
void MenuItem_Class::toggle_size_request_callback(GtkMenuItem* self, int* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_toggle_size_request(p0);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->toggle_size_request)
    (*base->toggle_size_request)(self, p0);
}
void MenuItem_Class::toggle_size_allocate_callback(GtkMenuItem* self, gint p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_toggle_size_allocate(p0
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->toggle_size_allocate)
    (*base->toggle_size_allocate)(self, p0);
}


Glib::ObjectBase* MenuItem_Class::wrap_new(GObject* o)
{
  return manage(new MenuItem((GtkMenuItem*)(o)));

}


/* The implementation: */

MenuItem::MenuItem(const Glib::ConstructParams& construct_params)
:
  Gtk::Bin(construct_params)
{
  }

MenuItem::MenuItem(GtkMenuItem* castitem)
:
  Gtk::Bin((GtkBin*)(castitem))
{
  }


MenuItem::MenuItem(MenuItem&& src) noexcept
: Gtk::Bin(std::move(src))
  , Activatable(std::move(src))
{}

MenuItem& MenuItem::operator=(MenuItem&& src) noexcept
{
  Gtk::Bin::operator=(std::move(src));
  Activatable::operator=(std::move(src));
  return *this;
}

MenuItem::~MenuItem() noexcept
{
  destroy_();
}

MenuItem::CppClassType MenuItem::menuitem_class_; // initialize static member

GType MenuItem::get_type()
{
  return menuitem_class_.init().get_type();
}


GType MenuItem::get_base_type()
{
  return gtk_menu_item_get_type();
}


MenuItem::MenuItem()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Bin(Glib::ConstructParams(menuitem_class_.init()))
{
  

}

void MenuItem::set_submenu(Menu& submenu)
{
  gtk_menu_item_set_submenu(gobj(), (submenu).Gtk::Widget::gobj());
}

Menu* MenuItem::get_submenu()
{
  return Glib::wrap((GtkMenu*)(gtk_menu_item_get_submenu(gobj())));
}

const Menu* MenuItem::get_submenu() const
{
  return const_cast<MenuItem*>(this)->get_submenu();
}

void MenuItem::select()
{
  gtk_menu_item_select(gobj());
}

void MenuItem::deselect()
{
  gtk_menu_item_deselect(gobj());
}

void MenuItem::activate()
{
  gtk_menu_item_activate(gobj());
}

void MenuItem::toggle_size_request(int& requisition)
{
  gtk_menu_item_toggle_size_request(gobj(), &(requisition));
}

void MenuItem::toggle_size_allocate(int allocation)
{
  gtk_menu_item_toggle_size_allocate(gobj(), allocation);
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void MenuItem::set_right_justified(bool right_justified)
{
  gtk_menu_item_set_right_justified(gobj(), static_cast<int>(right_justified));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
bool MenuItem::get_right_justified() const
{
  return gtk_menu_item_get_right_justified(const_cast<GtkMenuItem*>(gobj()));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void MenuItem::set_accel_path(const Glib::ustring& accel_path)
{
  gtk_menu_item_set_accel_path(gobj(), accel_path.c_str());
}

Glib::ustring MenuItem::get_accel_path() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_menu_item_get_accel_path(const_cast<GtkMenuItem*>(gobj())));
}

void MenuItem::set_label(const Glib::ustring& label)
{
  gtk_menu_item_set_label(gobj(), label.c_str());
}

Glib::ustring MenuItem::get_label() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_menu_item_get_label(const_cast<GtkMenuItem*>(gobj())));
}

void MenuItem::set_use_underline(bool setting)
{
  gtk_menu_item_set_use_underline(gobj(), static_cast<int>(setting));
}

bool MenuItem::get_use_underline() const
{
  return gtk_menu_item_get_use_underline(const_cast<GtkMenuItem*>(gobj()));
}

void MenuItem::set_reserve_indicator(bool reserve)
{
  gtk_menu_item_set_reserve_indicator(gobj(), static_cast<int>(reserve));
}

bool MenuItem::get_reserve_indicator() const
{
  return gtk_menu_item_get_reserve_indicator(const_cast<GtkMenuItem*>(gobj()));
}


Glib::SignalProxy< void > MenuItem::signal_activate()
{
  return Glib::SignalProxy< void >(this, &MenuItem_signal_activate_info);
}


Glib::SignalProxy< void > MenuItem::signal_activate_item()
{
  return Glib::SignalProxy< void >(this, &MenuItem_signal_activate_item_info);
}


Glib::SignalProxy< void,int* > MenuItem::signal_toggle_size_request()
{
  return Glib::SignalProxy< void,int* >(this, &MenuItem_signal_toggle_size_request_info);
}


Glib::SignalProxy< void,int > MenuItem::signal_toggle_size_allocate()
{
  return Glib::SignalProxy< void,int >(this, &MenuItem_signal_toggle_size_allocate_info);
}


Glib::SignalProxy< void > MenuItem::signal_select()
{
  return Glib::SignalProxy< void >(this, &MenuItem_signal_select_info);
}


Glib::SignalProxy< void > MenuItem::signal_deselect()
{
  return Glib::SignalProxy< void >(this, &MenuItem_signal_deselect_info);
}


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy< bool > MenuItem::property_right_justified() 
{
  return Glib::PropertyProxy< bool >(this, "right-justified");
}
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy_ReadOnly< bool > MenuItem::property_right_justified() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "right-justified");
}
#endif // GTKMM_DISABLE_DEPRECATED


Glib::PropertyProxy< Gtk::Menu* > MenuItem::property_submenu() 
{
  return Glib::PropertyProxy< Gtk::Menu* >(this, "submenu");
}

Glib::PropertyProxy_ReadOnly< Gtk::Menu* > MenuItem::property_submenu() const
{
  return Glib::PropertyProxy_ReadOnly< Gtk::Menu* >(this, "submenu");
}

Glib::PropertyProxy< Glib::ustring > MenuItem::property_accel_path() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "accel-path");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > MenuItem::property_accel_path() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "accel-path");
}

Glib::PropertyProxy< Glib::ustring > MenuItem::property_label() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "label");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > MenuItem::property_label() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "label");
}

Glib::PropertyProxy< bool > MenuItem::property_use_underline() 
{
  return Glib::PropertyProxy< bool >(this, "use-underline");
}

Glib::PropertyProxy_ReadOnly< bool > MenuItem::property_use_underline() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "use-underline");
}


void Gtk::MenuItem::on_activate()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->activate)
    (*base->activate)(gobj());
}
void Gtk::MenuItem::on_activate_item()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->activate_item)
    (*base->activate_item)(gobj());
}
void Gtk::MenuItem::on_toggle_size_request(int* requisition)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->toggle_size_request)
    (*base->toggle_size_request)(gobj(),requisition);
}
void Gtk::MenuItem::on_toggle_size_allocate(int allocation)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->toggle_size_allocate)
    (*base->toggle_size_allocate)(gobj(),allocation);
}


} // namespace Gtk


