/* styles.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from styles.vala, do not modify */

/* SPDX-License-Identifier: GPL-3.0-or-later*/

#include "graphs.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GRAPHS_STYLE_MANAGER_0_PROPERTY,
	GRAPHS_STYLE_MANAGER_APPLICATION_PROPERTY,
	GRAPHS_STYLE_MANAGER_USE_CUSTOM_STYLE_PROPERTY,
	GRAPHS_STYLE_MANAGER_CUSTOM_STYLE_PROPERTY,
	GRAPHS_STYLE_MANAGER_SELECTION_MODEL_PROPERTY,
	GRAPHS_STYLE_MANAGER_STYLE_DIR_PROPERTY,
	GRAPHS_STYLE_MANAGER_SELECTED_STYLENAME_PROPERTY,
	GRAPHS_STYLE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	GRAPHS_STYLE_0_PROPERTY,
	GRAPHS_STYLE_NAME_PROPERTY,
	GRAPHS_STYLE_PREVIEW_PROPERTY,
	GRAPHS_STYLE_FILE_PROPERTY,
	GRAPHS_STYLE_MUTABLE_PROPERTY,
	GRAPHS_STYLE_LIGHT_PROPERTY,
	GRAPHS_STYLE_NUM_PROPERTIES
};
static GParamSpec* graphs_style_properties[GRAPHS_STYLE_NUM_PROPERTIES];

#define GRAPHS_TYPE_STYLE_PREVIEW (graphs_style_preview_get_type ())
#define GRAPHS_STYLE_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAPHS_TYPE_STYLE_PREVIEW, GraphsStylePreview))
#define GRAPHS_STYLE_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAPHS_TYPE_STYLE_PREVIEW, GraphsStylePreviewClass))
#define GRAPHS_IS_STYLE_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAPHS_TYPE_STYLE_PREVIEW))
#define GRAPHS_IS_STYLE_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAPHS_TYPE_STYLE_PREVIEW))
#define GRAPHS_STYLE_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAPHS_TYPE_STYLE_PREVIEW, GraphsStylePreviewClass))

typedef struct _GraphsStylePreview GraphsStylePreview;
typedef struct _GraphsStylePreviewClass GraphsStylePreviewClass;
typedef struct _GraphsStylePreviewPrivate GraphsStylePreviewPrivate;
enum  {
	GRAPHS_STYLE_PREVIEW_0_PROPERTY,
	GRAPHS_STYLE_PREVIEW_EDIT_BUTTON_PROPERTY,
	GRAPHS_STYLE_PREVIEW_STYLE_PROPERTY,
	GRAPHS_STYLE_PREVIEW_STYLENAME_PROPERTY,
	GRAPHS_STYLE_PREVIEW_PREVIEW_PROPERTY,
	GRAPHS_STYLE_PREVIEW_NUM_PROPERTIES
};
static GParamSpec* graphs_style_preview_properties[GRAPHS_STYLE_PREVIEW_NUM_PROPERTIES];
enum  {
	GRAPHS_ADD_STYLE_DIALOG_0_PROPERTY,
	GRAPHS_ADD_STYLE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* graphs_add_style_dialog_properties[GRAPHS_ADD_STYLE_DIALOG_NUM_PROPERTIES];
enum  {
	GRAPHS_ADD_STYLE_DIALOG_ACCEPT_SIGNAL,
	GRAPHS_ADD_STYLE_DIALOG_NUM_SIGNALS
};
static guint graphs_add_style_dialog_signals[GRAPHS_ADD_STYLE_DIALOG_NUM_SIGNALS] = {0};

struct _GraphsStyleManagerPrivate {
	GraphsApplication* _application;
	gboolean _use_custom_style;
	gchar* _custom_style;
	GtkSingleSelection* _selection_model;
	GFile* _style_dir;
	gchar* _selected_stylename;
	GListStore* style_model;
};

struct _GraphsStylePrivate {
	gchar* _name;
	GdkTexture* _preview;
	GFile* _file;
	gboolean _mutable;
	gboolean _light;
};

struct _GraphsStylePreview {
	GtkBox parent_instance;
	GraphsStylePreviewPrivate * priv;
};

struct _GraphsStylePreviewClass {
	GtkBoxClass parent_class;
};

struct _GraphsStylePreviewPrivate {
	GtkLabel* _label;
	GtkPicture* _picture;
	GtkButton* _edit_button;
	GraphsStyle* _style;
	GtkCssProvider* provider;
};

struct _GraphsAddStyleDialogPrivate {
	AdwEntryRow* _new_style_name;
	AdwComboRow* _style_templates;
	GraphsStyleManager* style_manager;
	gchar** stylenames;
	gint stylenames_length1;
	gint _stylenames_size_;
};

static gint GraphsStyleManager_private_offset;
static gpointer graphs_style_manager_parent_class = NULL;
static gint GraphsStyle_private_offset;
static gpointer graphs_style_parent_class = NULL;
static gint GraphsStylePreview_private_offset;
static gpointer graphs_style_preview_parent_class = NULL;
static gint GraphsAddStyleDialog_private_offset;
static gpointer graphs_add_style_dialog_parent_class = NULL;

static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gint _graphs_style_cmp_gcompare_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self);
static void __lambda12_ (GraphsStyleManager* self);
static void ___lambda12__gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                         guint position,
                                                         guint n_items,
                                                         gpointer self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GObject * graphs_style_manager_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void graphs_style_manager_finalize (GObject * obj);
static GType graphs_style_manager_get_type_once (void);
static void _vala_graphs_style_manager_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_graphs_style_manager_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void graphs_style_finalize (GObject * obj);
static GType graphs_style_get_type_once (void);
static void _vala_graphs_style_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_graphs_style_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
VALA_EXTERN GType graphs_style_preview_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GraphsStylePreview* graphs_style_preview_new (void);
VALA_EXTERN GraphsStylePreview* graphs_style_preview_construct (GType object_type);
static GtkLabel* graphs_style_preview_get_label (GraphsStylePreview* self);
static GtkPicture* graphs_style_preview_get_picture (GraphsStylePreview* self);
VALA_EXTERN GtkButton* graphs_style_preview_get_edit_button (GraphsStylePreview* self);
VALA_EXTERN GraphsStyle* graphs_style_preview_get_style (GraphsStylePreview* self);
VALA_EXTERN void graphs_style_preview_set_style (GraphsStylePreview* self,
                                     GraphsStyle* value);
VALA_EXTERN void graphs_style_preview_set_stylename (GraphsStylePreview* self,
                                         const gchar* value);
VALA_EXTERN GdkTexture* graphs_style_preview_get_preview (GraphsStylePreview* self);
VALA_EXTERN void graphs_style_preview_set_preview (GraphsStylePreview* self,
                                       GdkTexture* value);
static GObject * graphs_style_preview_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void graphs_style_preview_finalize (GObject * obj);
static GType graphs_style_preview_get_type_once (void);
static void _vala_graphs_style_preview_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_graphs_style_preview_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static AdwComboRow* graphs_add_style_dialog_get_style_templates (GraphsAddStyleDialog* self);
static gchar* graphs_add_style_dialog_get_selected (GraphsAddStyleDialog* self);
static void graphs_add_style_dialog_on_template_changed (GraphsAddStyleDialog* self);
static AdwEntryRow* graphs_add_style_dialog_get_new_style_name (GraphsAddStyleDialog* self);
static void _graphs_add_style_dialog_on_template_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void graphs_add_style_dialog_on_accept (GraphsAddStyleDialog* self);
static void _graphs_add_style_dialog_on_accept_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void graphs_add_style_dialog_finalize (GObject * obj);
static GType graphs_add_style_dialog_get_type_once (void);
static void _vala_graphs_add_style_dialog_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gint
graphs_style_cmp (GraphsStyle* a,
                  GraphsStyle* b)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GCompareFunc _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gint _tmp13_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = graphs_style_get_file (a);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = -1;
		return result;
	} else {
		GFile* _tmp2_;
		GFile* _tmp3_;
		_tmp2_ = graphs_style_get_file (b);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == NULL) {
			result = 1;
			return result;
		}
	}
	_tmp4_ = ((GCompareFunc) g_strcmp0);
	_tmp5_ = graphs_style_get_name (a);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = graphs_style_get_name (b);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) -1);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp4_ (_tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp8_);
	result = _tmp13_;
	return result;
}

static inline gpointer
graphs_style_manager_get_instance_private (GraphsStyleManager* self)
{
	return G_STRUCT_MEMBER_P (self, GraphsStyleManager_private_offset);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gint
_graphs_style_cmp_gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self)
{
	gint result;
	result = graphs_style_cmp ((GraphsStyle*) a, (GraphsStyle*) b);
	return result;
}

gchar**
graphs_style_manager_load_system_styles (GraphsStyleManager* self,
                                         const gchar* system_style,
                                         gint* result_length1)
{
	gchar** stylenames = NULL;
	gchar** _tmp0_;
	gint stylenames_length1;
	gint _stylenames_size_;
	GListStore* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GdkTexture* _tmp46_;
	GdkTexture* _tmp47_;
	GraphsStyle* _tmp48_;
	GraphsStyle* _tmp49_;
	gchar** _tmp50_;
	gint _tmp50__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (system_style != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	stylenames = _tmp0_;
	stylenames_length1 = 0;
	_stylenames_size_ = stylenames_length1;
	{
		GFile* directory = NULL;
		GFile* _tmp1_;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp2_;
		GFileEnumerator* _tmp3_;
		GFileInfo* info = NULL;
		_tmp1_ = g_file_new_for_uri ("resource:///se/sjoerd/Graphs/styles");
		directory = _tmp1_;
		_tmp2_ = directory;
		_tmp3_ = g_file_enumerate_children (_tmp2_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (directory);
			goto __catch0_g_error;
		}
		info = NULL;
		while (TRUE) {
			GFileInfo* _tmp4_ = NULL;
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFile* file = NULL;
			GFileEnumerator* _tmp9_;
			GFileInfo* _tmp10_;
			GFile* _tmp11_;
			GFileInputStream* _tmp12_ = NULL;
			GFile* _tmp13_;
			GFileInputStream* _tmp14_;
			GDataInputStream* stream = NULL;
			GDataInputStream* _tmp15_;
			GDataInputStream* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gsize size = 0UL;
			gchar* _tmp19_ = NULL;
			GDataInputStream* _tmp20_;
			gsize _tmp21_ = 0UL;
			gchar* _tmp22_;
			gchar* name = NULL;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* preview_name = NULL;
			GFileInfo* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			GdkTexture* preview = NULL;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			GdkTexture* _tmp33_;
			GdkTexture* _tmp34_;
			GCompareDataFunc cmp = NULL;
			gpointer cmp_target;
			GDestroyNotify cmp_target_destroy_notify;
			GListStore* _tmp35_;
			const gchar* _tmp36_;
			GFile* _tmp37_;
			GdkTexture* _tmp38_;
			GraphsStyle* _tmp39_;
			GraphsStyle* _tmp40_;
			GCompareDataFunc _tmp41_;
			gpointer _tmp41__target;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (info);
			info = _tmp7_;
			_tmp8_ = info;
			if (!(_tmp8_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				break;
			}
			_tmp9_ = enumerator;
			_tmp10_ = info;
			_tmp11_ = g_file_enumerator_get_child (_tmp9_, _tmp10_);
			file = _tmp11_;
			_tmp13_ = file;
			_tmp14_ = g_file_read (_tmp13_, NULL, &_inner_error0_);
			_tmp12_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				goto __catch0_g_error;
			}
			_tmp15_ = g_data_input_stream_new ((GInputStream*) _tmp12_);
			stream = _tmp15_;
			_tmp16_ = stream;
			_tmp17_ = g_data_input_stream_read_line_utf8 (_tmp16_, NULL, NULL, &_inner_error0_);
			_tmp18_ = _tmp17_;
			_g_free0 (_tmp18_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp12_);
				_g_object_unref0 (file);
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				goto __catch0_g_error;
			}
			_tmp20_ = stream;
			_tmp22_ = g_data_input_stream_read_line_utf8 (_tmp20_, &_tmp21_, NULL, &_inner_error0_);
			size = _tmp21_;
			_tmp19_ = _tmp22_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp12_);
				_g_object_unref0 (file);
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				goto __catch0_g_error;
			}
			_tmp23_ = string_slice (_tmp19_, (glong) 2, (glong) size);
			name = _tmp23_;
			_tmp24_ = name;
			_tmp25_ = g_strdup (_tmp24_);
			_vala_array_add2 (&stylenames, &stylenames_length1, &_stylenames_size_, _tmp25_);
			_tmp26_ = info;
			_tmp27_ = g_file_info_get_name (_tmp26_);
			_tmp28_ = string_replace (_tmp27_, ".mplstyle", ".png");
			preview_name = _tmp28_;
			_tmp29_ = preview_name;
			_tmp30_ = string_to_string (_tmp29_);
			_tmp31_ = g_strconcat ("/se/sjoerd/Graphs/", _tmp30_, NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = gdk_texture_new_from_resource (_tmp32_);
			_tmp34_ = _tmp33_;
			_g_free0 (_tmp32_);
			preview = _tmp34_;
			cmp = _graphs_style_cmp_gcompare_data_func;
			cmp_target = NULL;
			cmp_target_destroy_notify = NULL;
			_tmp35_ = self->priv->style_model;
			_tmp36_ = name;
			_tmp37_ = file;
			_tmp38_ = preview;
			_tmp39_ = graphs_style_new (_tmp36_, _tmp37_, _tmp38_, FALSE);
			_tmp40_ = _tmp39_;
			_tmp41_ = cmp;
			_tmp41__target = cmp_target;
			g_list_store_insert_sorted (_tmp35_, (GObject*) _tmp40_, _tmp41_, _tmp41__target);
			_g_object_unref0 (_tmp40_);
			(cmp_target_destroy_notify == NULL) ? NULL : (cmp_target_destroy_notify (cmp_target), NULL);
			cmp = NULL;
			cmp_target = NULL;
			cmp_target_destroy_notify = NULL;
			_g_object_unref0 (preview);
			_g_free0 (preview_name);
			_g_free0 (name);
			_g_free0 (_tmp19_);
			_g_object_unref0 (stream);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (file);
			_g_object_unref0 (_tmp4_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (directory);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		stylenames = (_vala_array_free (stylenames, stylenames_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp42_ = self->priv->style_model;
	_tmp43_ = string_to_string (system_style);
	_tmp44_ = g_strconcat ("/se/sjoerd/Graphs/system-style-", _tmp43_, ".png", NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = gdk_texture_new_from_resource (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = graphs_style_new (_ ("System"), NULL, _tmp47_, FALSE);
	_tmp49_ = _tmp48_;
	g_list_store_insert (_tmp42_, (guint) 0, (GObject*) _tmp49_);
	_g_object_unref0 (_tmp49_);
	_g_object_unref0 (_tmp47_);
	_g_free0 (_tmp45_);
	_tmp50_ = stylenames;
	_tmp50__length1 = stylenames_length1;
	if (result_length1) {
		*result_length1 = _tmp50__length1;
	}
	result = _tmp50_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GraphsStyle*
graphs_style_manager_get_selected_style (GraphsStyleManager* self)
{
	GtkSingleSelection* _tmp0_;
	GObject* _tmp1_;
	GraphsStyle* _tmp2_;
	GraphsStyle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = gtk_single_selection_get_selected_item (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GRAPHS_TYPE_STYLE, GraphsStyle));
	result = _tmp2_;
	return result;
}

static void
__lambda12_ (GraphsStyleManager* self)
{
	GraphsStyle* style = NULL;
	GraphsStyle* _tmp0_;
	GraphsStyle* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	_tmp0_ = graphs_style_manager_get_selected_style (self);
	style = _tmp0_;
	_tmp1_ = style;
	_tmp2_ = graphs_style_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_use_custom_style;
		if (_tmp4_) {
			graphs_style_manager_set_use_custom_style (self, FALSE);
		}
	} else {
		GraphsStyle* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp12_;
		_tmp5_ = style;
		_tmp6_ = graphs_style_get_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->_custom_style;
		if (g_strcmp0 (_tmp7_, _tmp8_) != 0) {
			GraphsStyle* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = style;
			_tmp10_ = graphs_style_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			graphs_style_manager_set_custom_style (self, _tmp11_);
		}
		_tmp12_ = self->priv->_use_custom_style;
		if (!_tmp12_) {
			graphs_style_manager_set_use_custom_style (self, TRUE);
		}
	}
	_g_object_unref0 (style);
}

static void
___lambda12__gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                    guint position,
                                                    guint n_items,
                                                    gpointer self)
{
	__lambda12_ ((GraphsStyleManager*) self);
}

void
graphs_style_manager_setup_bindings (GraphsStyleManager* self,
                                     GraphsFigureSettings* figure_settings)
{
	GtkSingleSelection* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (figure_settings != NULL);
	g_object_bind_property_with_closures ((GObject*) figure_settings, "use_custom_style", (GObject*) self, "use_custom_style", 1 | 2, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) figure_settings, "custom_style", (GObject*) self, "custom_style", 1 | 2, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp0_ = self->priv->_selection_model;
	g_signal_connect_object ((GtkSelectionModel*) _tmp0_, "selection-changed", (GCallback) ___lambda12__gtk_selection_model_selection_changed, self, 0);
}

/**
         * List all stylenames
         *
         * The result is guaranteed to be sorted and excludes the system style.
         */
static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
graphs_style_manager_list_stylenames (GraphsStyleManager* self,
                                      gint* result_length1)
{
	gchar** stylenames = NULL;
	gchar** _tmp0_;
	gint stylenames_length1;
	gint _stylenames_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	stylenames = _tmp0_;
	stylenames_length1 = 0;
	_stylenames_size_ = stylenames_length1;
	{
		guint i = 0U;
		i = (guint) 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GListStore* _tmp3_;
				GraphsStyle* style = NULL;
				GListStore* _tmp4_;
				GObject* _tmp5_;
				GraphsStyle* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->style_model;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp3_))) {
					break;
				}
				_tmp4_ = self->priv->style_model;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, i);
				style = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GRAPHS_TYPE_STYLE, GraphsStyle);
				_tmp6_ = style;
				_tmp7_ = graphs_style_get_name (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strdup (_tmp8_);
				_vala_array_add3 (&stylenames, &stylenames_length1, &_stylenames_size_, _tmp9_);
				_g_object_unref0 (style);
			}
		}
	}
	_tmp10_ = stylenames;
	_tmp10__length1 = stylenames_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

GraphsStyleManager*
graphs_style_manager_construct (GType object_type)
{
	GraphsStyleManager * self = NULL;
	self = (GraphsStyleManager*) g_object_new (object_type, NULL);
	return self;
}

GraphsStyleManager*
graphs_style_manager_new (void)
{
	return graphs_style_manager_construct (GRAPHS_TYPE_STYLE_MANAGER);
}

GraphsApplication*
graphs_style_manager_get_application (GraphsStyleManager* self)
{
	GraphsApplication* result;
	GraphsApplication* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application;
	result = _tmp0_;
	return result;
}

void
graphs_style_manager_set_application (GraphsStyleManager* self,
                                      GraphsApplication* value)
{
	GraphsApplication* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_manager_get_application (self);
	if (old_value != value) {
		GraphsApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_APPLICATION_PROPERTY]);
	}
}

gboolean
graphs_style_manager_get_use_custom_style (GraphsStyleManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_custom_style;
	return result;
}

void
graphs_style_manager_set_use_custom_style (GraphsStyleManager* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_manager_get_use_custom_style (self);
	if (old_value != value) {
		self->priv->_use_custom_style = value;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_USE_CUSTOM_STYLE_PROPERTY]);
	}
}

const gchar*
graphs_style_manager_get_custom_style (GraphsStyleManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_custom_style;
	result = _tmp0_;
	return result;
}

void
graphs_style_manager_set_custom_style (GraphsStyleManager* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_manager_get_custom_style (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_custom_style);
		self->priv->_custom_style = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_CUSTOM_STYLE_PROPERTY]);
	}
}

GtkSingleSelection*
graphs_style_manager_get_selection_model (GraphsStyleManager* self)
{
	GtkSingleSelection* result;
	GtkSingleSelection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selection_model;
	result = _tmp0_;
	return result;
}

void
graphs_style_manager_set_selection_model (GraphsStyleManager* self,
                                          GtkSingleSelection* value)
{
	GtkSingleSelection* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_manager_get_selection_model (self);
	if (old_value != value) {
		GtkSingleSelection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selection_model);
		self->priv->_selection_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_SELECTION_MODEL_PROPERTY]);
	}
}

GFile*
graphs_style_manager_get_style_dir (GraphsStyleManager* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_style_dir;
	result = _tmp0_;
	return result;
}

void
graphs_style_manager_set_style_dir (GraphsStyleManager* self,
                                    GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_manager_get_style_dir (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_style_dir);
		self->priv->_style_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_STYLE_DIR_PROPERTY]);
	}
}

const gchar*
graphs_style_manager_get_selected_stylename (GraphsStyleManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_stylename;
	result = _tmp0_;
	return result;
}

void
graphs_style_manager_set_selected_stylename (GraphsStyleManager* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_manager_get_selected_stylename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_selected_stylename);
		self->priv->_selected_stylename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_SELECTED_STYLENAME_PROPERTY]);
	}
}

static GObject *
graphs_style_manager_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraphsStyleManager * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	GListModel* _tmp2_;
	GtkSingleSelection* _tmp3_;
	GtkSingleSelection* _tmp4_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (graphs_style_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_STYLE_MANAGER, GraphsStyleManager);
	_tmp0_ = g_list_store_new (GRAPHS_TYPE_STYLE);
	_g_object_unref0 (self->priv->style_model);
	self->priv->style_model = _tmp0_;
	_tmp1_ = self->priv->style_model;
	_tmp2_ = _g_object_ref0 ((GListModel*) _tmp1_);
	_tmp3_ = gtk_single_selection_new (_tmp2_);
	_tmp4_ = _tmp3_;
	graphs_style_manager_set_selection_model (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	{
		GFile* config_dir = NULL;
		GFile* _tmp5_;
		GFile* _tmp6_ = NULL;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		_tmp5_ = graphs_tools_get_config_directory (&_inner_error0_);
		config_dir = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = config_dir;
		_tmp8_ = g_file_get_child_for_display_name (_tmp7_, "styles", &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config_dir);
			goto __catch0_g_error;
		}
		graphs_style_manager_set_style_dir (self, _tmp6_);
		_tmp9_ = self->priv->_style_dir;
		if (!g_file_query_exists (_tmp9_, NULL)) {
			GFile* _tmp10_;
			_tmp10_ = self->priv->_style_dir;
			g_file_make_directory_with_parents (_tmp10_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				_g_object_unref0 (config_dir);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (config_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
graphs_style_manager_class_init (GraphsStyleManagerClass * klass,
                                 gpointer klass_data)
{
	graphs_style_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraphsStyleManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_graphs_style_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_graphs_style_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = graphs_style_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = graphs_style_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_MANAGER_APPLICATION_PROPERTY, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GRAPHS_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_MANAGER_USE_CUSTOM_STYLE_PROPERTY, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_USE_CUSTOM_STYLE_PROPERTY] = g_param_spec_boolean ("use-custom-style", "use-custom-style", "use-custom-style", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_MANAGER_CUSTOM_STYLE_PROPERTY, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_CUSTOM_STYLE_PROPERTY] = g_param_spec_string ("custom-style", "custom-style", "custom-style", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_MANAGER_SELECTION_MODEL_PROPERTY, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_SELECTION_MODEL_PROPERTY] = g_param_spec_object ("selection-model", "selection-model", "selection-model", gtk_single_selection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_MANAGER_STYLE_DIR_PROPERTY, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_STYLE_DIR_PROPERTY] = g_param_spec_object ("style-dir", "style-dir", "style-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_MANAGER_SELECTED_STYLENAME_PROPERTY, graphs_style_manager_properties[GRAPHS_STYLE_MANAGER_SELECTED_STYLENAME_PROPERTY] = g_param_spec_string ("selected-stylename", "selected-stylename", "selected-stylename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
graphs_style_manager_instance_init (GraphsStyleManager * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	self->priv = graphs_style_manager_get_instance_private (self);
	self->priv->_use_custom_style = FALSE;
	_tmp0_ = g_strdup ("Adwaita");
	self->priv->_custom_style = _tmp0_;
}

static void
graphs_style_manager_finalize (GObject * obj)
{
	GraphsStyleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_STYLE_MANAGER, GraphsStyleManager);
	_g_object_unref0 (self->priv->_application);
	_g_free0 (self->priv->_custom_style);
	_g_object_unref0 (self->priv->_selection_model);
	_g_object_unref0 (self->priv->_style_dir);
	_g_free0 (self->priv->_selected_stylename);
	_g_object_unref0 (self->priv->style_model);
	G_OBJECT_CLASS (graphs_style_manager_parent_class)->finalize (obj);
}

/**
     * Style manager
     */
static GType
graphs_style_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraphsStyleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphs_style_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphsStyleManager), 0, (GInstanceInitFunc) graphs_style_manager_instance_init, NULL };
	GType graphs_style_manager_type_id;
	graphs_style_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GraphsStyleManager", &g_define_type_info, 0);
	GraphsStyleManager_private_offset = g_type_add_instance_private (graphs_style_manager_type_id, sizeof (GraphsStyleManagerPrivate));
	return graphs_style_manager_type_id;
}

GType
graphs_style_manager_get_type (void)
{
	static volatile gsize graphs_style_manager_type_id__once = 0;
	if (g_once_init_enter (&graphs_style_manager_type_id__once)) {
		GType graphs_style_manager_type_id;
		graphs_style_manager_type_id = graphs_style_manager_get_type_once ();
		g_once_init_leave (&graphs_style_manager_type_id__once, graphs_style_manager_type_id);
	}
	return graphs_style_manager_type_id__once;
}

static void
_vala_graphs_style_manager_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GraphsStyleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_STYLE_MANAGER, GraphsStyleManager);
	switch (property_id) {
		case GRAPHS_STYLE_MANAGER_APPLICATION_PROPERTY:
		g_value_set_object (value, graphs_style_manager_get_application (self));
		break;
		case GRAPHS_STYLE_MANAGER_USE_CUSTOM_STYLE_PROPERTY:
		g_value_set_boolean (value, graphs_style_manager_get_use_custom_style (self));
		break;
		case GRAPHS_STYLE_MANAGER_CUSTOM_STYLE_PROPERTY:
		g_value_set_string (value, graphs_style_manager_get_custom_style (self));
		break;
		case GRAPHS_STYLE_MANAGER_SELECTION_MODEL_PROPERTY:
		g_value_set_object (value, graphs_style_manager_get_selection_model (self));
		break;
		case GRAPHS_STYLE_MANAGER_STYLE_DIR_PROPERTY:
		g_value_set_object (value, graphs_style_manager_get_style_dir (self));
		break;
		case GRAPHS_STYLE_MANAGER_SELECTED_STYLENAME_PROPERTY:
		g_value_set_string (value, graphs_style_manager_get_selected_stylename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_graphs_style_manager_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GraphsStyleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_STYLE_MANAGER, GraphsStyleManager);
	switch (property_id) {
		case GRAPHS_STYLE_MANAGER_APPLICATION_PROPERTY:
		graphs_style_manager_set_application (self, g_value_get_object (value));
		break;
		case GRAPHS_STYLE_MANAGER_USE_CUSTOM_STYLE_PROPERTY:
		graphs_style_manager_set_use_custom_style (self, g_value_get_boolean (value));
		break;
		case GRAPHS_STYLE_MANAGER_CUSTOM_STYLE_PROPERTY:
		graphs_style_manager_set_custom_style (self, g_value_get_string (value));
		break;
		case GRAPHS_STYLE_MANAGER_SELECTION_MODEL_PROPERTY:
		graphs_style_manager_set_selection_model (self, g_value_get_object (value));
		break;
		case GRAPHS_STYLE_MANAGER_STYLE_DIR_PROPERTY:
		graphs_style_manager_set_style_dir (self, g_value_get_object (value));
		break;
		case GRAPHS_STYLE_MANAGER_SELECTED_STYLENAME_PROPERTY:
		graphs_style_manager_set_selected_stylename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
graphs_style_get_instance_private (GraphsStyle* self)
{
	return G_STRUCT_MEMBER_P (self, GraphsStyle_private_offset);
}

GraphsStyle*
graphs_style_construct (GType object_type,
                        const gchar* name,
                        GFile* file,
                        GdkTexture* preview,
                        gboolean mutable)
{
	GraphsStyle * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (preview != NULL, NULL);
	self = (GraphsStyle*) g_object_new (object_type, "name", name, "file", file, "preview", preview, "mutable", mutable, NULL);
	return self;
}

GraphsStyle*
graphs_style_new (const gchar* name,
                  GFile* file,
                  GdkTexture* preview,
                  gboolean mutable)
{
	return graphs_style_construct (GRAPHS_TYPE_STYLE, name, file, preview, mutable);
}

const gchar*
graphs_style_get_name (GraphsStyle* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
graphs_style_set_name (GraphsStyle* self,
                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_properties[GRAPHS_STYLE_NAME_PROPERTY]);
	}
}

GdkTexture*
graphs_style_get_preview (GraphsStyle* self)
{
	GdkTexture* result;
	GdkTexture* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preview;
	result = _tmp0_;
	return result;
}

void
graphs_style_set_preview (GraphsStyle* self,
                          GdkTexture* value)
{
	GdkTexture* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_get_preview (self);
	if (old_value != value) {
		GdkTexture* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_preview);
		self->priv->_preview = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_properties[GRAPHS_STYLE_PREVIEW_PROPERTY]);
	}
}

GFile*
graphs_style_get_file (GraphsStyle* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

void
graphs_style_set_file (GraphsStyle* self,
                       GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_properties[GRAPHS_STYLE_FILE_PROPERTY]);
	}
}

gboolean
graphs_style_get_mutable (GraphsStyle* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mutable;
	return result;
}

void
graphs_style_set_mutable (GraphsStyle* self,
                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_get_mutable (self);
	if (old_value != value) {
		self->priv->_mutable = value;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_properties[GRAPHS_STYLE_MUTABLE_PROPERTY]);
	}
}

gboolean
graphs_style_get_light (GraphsStyle* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_light;
	return result;
}

void
graphs_style_set_light (GraphsStyle* self,
                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_style_get_light (self);
	if (old_value != value) {
		self->priv->_light = value;
		g_object_notify_by_pspec ((GObject *) self, graphs_style_properties[GRAPHS_STYLE_LIGHT_PROPERTY]);
	}
}

static void
graphs_style_class_init (GraphsStyleClass * klass,
                         gpointer klass_data)
{
	graphs_style_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraphsStyle_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_graphs_style_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_graphs_style_set_property;
	G_OBJECT_CLASS (klass)->finalize = graphs_style_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_NAME_PROPERTY, graphs_style_properties[GRAPHS_STYLE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_PREVIEW_PROPERTY, graphs_style_properties[GRAPHS_STYLE_PREVIEW_PROPERTY] = g_param_spec_object ("preview", "preview", "preview", gdk_texture_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_FILE_PROPERTY, graphs_style_properties[GRAPHS_STYLE_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_MUTABLE_PROPERTY, graphs_style_properties[GRAPHS_STYLE_MUTABLE_PROPERTY] = g_param_spec_boolean ("mutable", "mutable", "mutable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_LIGHT_PROPERTY, graphs_style_properties[GRAPHS_STYLE_LIGHT_PROPERTY] = g_param_spec_boolean ("light", "light", "light", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
graphs_style_instance_init (GraphsStyle * self,
                            gpointer klass)
{
	gchar* _tmp0_;
	self->priv = graphs_style_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_name = _tmp0_;
	self->priv->_light = TRUE;
}

static void
graphs_style_finalize (GObject * obj)
{
	GraphsStyle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_STYLE, GraphsStyle);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_preview);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (graphs_style_parent_class)->finalize (obj);
}

static GType
graphs_style_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraphsStyleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphs_style_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphsStyle), 0, (GInstanceInitFunc) graphs_style_instance_init, NULL };
	GType graphs_style_type_id;
	graphs_style_type_id = g_type_register_static (G_TYPE_OBJECT, "GraphsStyle", &g_define_type_info, 0);
	GraphsStyle_private_offset = g_type_add_instance_private (graphs_style_type_id, sizeof (GraphsStylePrivate));
	return graphs_style_type_id;
}

GType
graphs_style_get_type (void)
{
	static volatile gsize graphs_style_type_id__once = 0;
	if (g_once_init_enter (&graphs_style_type_id__once)) {
		GType graphs_style_type_id;
		graphs_style_type_id = graphs_style_get_type_once ();
		g_once_init_leave (&graphs_style_type_id__once, graphs_style_type_id);
	}
	return graphs_style_type_id__once;
}

static void
_vala_graphs_style_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GraphsStyle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_STYLE, GraphsStyle);
	switch (property_id) {
		case GRAPHS_STYLE_NAME_PROPERTY:
		g_value_set_string (value, graphs_style_get_name (self));
		break;
		case GRAPHS_STYLE_PREVIEW_PROPERTY:
		g_value_set_object (value, graphs_style_get_preview (self));
		break;
		case GRAPHS_STYLE_FILE_PROPERTY:
		g_value_set_object (value, graphs_style_get_file (self));
		break;
		case GRAPHS_STYLE_MUTABLE_PROPERTY:
		g_value_set_boolean (value, graphs_style_get_mutable (self));
		break;
		case GRAPHS_STYLE_LIGHT_PROPERTY:
		g_value_set_boolean (value, graphs_style_get_light (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_graphs_style_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	GraphsStyle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_STYLE, GraphsStyle);
	switch (property_id) {
		case GRAPHS_STYLE_NAME_PROPERTY:
		graphs_style_set_name (self, g_value_get_string (value));
		break;
		case GRAPHS_STYLE_PREVIEW_PROPERTY:
		graphs_style_set_preview (self, g_value_get_object (value));
		break;
		case GRAPHS_STYLE_FILE_PROPERTY:
		graphs_style_set_file (self, g_value_get_object (value));
		break;
		case GRAPHS_STYLE_MUTABLE_PROPERTY:
		graphs_style_set_mutable (self, g_value_get_boolean (value));
		break;
		case GRAPHS_STYLE_LIGHT_PROPERTY:
		graphs_style_set_light (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
graphs_style_preview_get_instance_private (GraphsStylePreview* self)
{
	return G_STRUCT_MEMBER_P (self, GraphsStylePreview_private_offset);
}

GraphsStylePreview*
graphs_style_preview_construct (GType object_type)
{
	GraphsStylePreview * self = NULL;
	self = (GraphsStylePreview*) g_object_new (object_type, NULL);
	return self;
}

GraphsStylePreview*
graphs_style_preview_new (void)
{
	return graphs_style_preview_construct (GRAPHS_TYPE_STYLE_PREVIEW);
}

static GtkLabel*
graphs_style_preview_get_label (GraphsStylePreview* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static GtkPicture*
graphs_style_preview_get_picture (GraphsStylePreview* self)
{
	GtkPicture* result;
	GtkPicture* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_picture;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_style_preview_get_edit_button (GraphsStylePreview* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_edit_button;
	result = _tmp0_;
	return result;
}

GraphsStyle*
graphs_style_preview_get_style (GraphsStylePreview* self)
{
	GraphsStyle* result;
	GraphsStyle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_style;
	result = _tmp0_;
	return result;
}

void
graphs_style_preview_set_style (GraphsStylePreview* self,
                                GraphsStyle* value)
{
	GraphsStyle* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_style);
	self->priv->_style = _tmp0_;
	g_object_bind_property_with_closures ((GObject*) value, "name", (GObject*) self, "stylename", 2, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) value, "preview", (GObject*) self, "preview", 2, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_notify_by_pspec ((GObject *) self, graphs_style_preview_properties[GRAPHS_STYLE_PREVIEW_STYLE_PROPERTY]);
}

void
graphs_style_preview_set_stylename (GraphsStylePreview* self,
                                    const gchar* value)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_label;
	_tmp1_ = graphs_tools_shorten_label (value, (guint) 20);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_notify_by_pspec ((GObject *) self, graphs_style_preview_properties[GRAPHS_STYLE_PREVIEW_STYLENAME_PROPERTY]);
}

GdkTexture*
graphs_style_preview_get_preview (GraphsStylePreview* self)
{
	GdkTexture* result;
	GtkPicture* _tmp0_;
	GdkPaintable* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_picture;
	_tmp1_ = gtk_picture_get_paintable (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gdk_texture_get_type (), GdkTexture);
	return result;
}

void
graphs_style_preview_set_preview (GraphsStylePreview* self,
                                  GdkTexture* value)
{
	GtkPicture* _tmp0_;
	GraphsStyle* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_picture;
	gtk_picture_set_paintable (_tmp0_, (GdkPaintable*) value);
	_tmp1_ = self->priv->_style;
	_tmp2_ = graphs_style_get_mutable (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gchar* color = NULL;
		GraphsStyle* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		GtkCssProvider* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp4_ = self->priv->_style;
		_tmp5_ = graphs_style_get_light (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("@light_1");
			_g_free0 (color);
			color = _tmp7_;
		} else {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("@dark_5");
			_g_free0 (color);
			color = _tmp8_;
		}
		_tmp9_ = self->priv->provider;
		_tmp10_ = color;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = g_strconcat ("button { color: ", _tmp11_, "; }", NULL);
		_tmp13_ = _tmp12_;
		gtk_css_provider_load_from_string (_tmp9_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (color);
	}
	g_object_notify_by_pspec ((GObject *) self, graphs_style_preview_properties[GRAPHS_STYLE_PREVIEW_PREVIEW_PROPERTY]);
}

static GObject *
graphs_style_preview_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraphsStylePreview * self;
	GtkCssProvider* _tmp0_;
	GtkButton* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkCssProvider* _tmp3_;
	parent_class = G_OBJECT_CLASS (graphs_style_preview_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_STYLE_PREVIEW, GraphsStylePreview);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->provider);
	self->priv->provider = _tmp0_;
	_tmp1_ = self->priv->_edit_button;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	_tmp3_ = self->priv->provider;
	gtk_style_context_add_provider (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	return obj;
}

static void
graphs_style_preview_class_init (GraphsStylePreviewClass * klass,
                                 gpointer klass_data)
{
	graphs_style_preview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraphsStylePreview_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_graphs_style_preview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_graphs_style_preview_set_property;
	G_OBJECT_CLASS (klass)->constructor = graphs_style_preview_constructor;
	G_OBJECT_CLASS (klass)->finalize = graphs_style_preview_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_PREVIEW_EDIT_BUTTON_PROPERTY, graphs_style_preview_properties[GRAPHS_STYLE_PREVIEW_EDIT_BUTTON_PROPERTY] = g_param_spec_object ("edit-button", "edit-button", "edit-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_PREVIEW_STYLE_PROPERTY, graphs_style_preview_properties[GRAPHS_STYLE_PREVIEW_STYLE_PROPERTY] = g_param_spec_object ("style", "style", "style", GRAPHS_TYPE_STYLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_PREVIEW_STYLENAME_PROPERTY, graphs_style_preview_properties[GRAPHS_STYLE_PREVIEW_STYLENAME_PROPERTY] = g_param_spec_string ("stylename", "stylename", "stylename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_STYLE_PREVIEW_PREVIEW_PROPERTY, graphs_style_preview_properties[GRAPHS_STYLE_PREVIEW_PREVIEW_PROPERTY] = g_param_spec_object ("preview", "preview", "preview", gdk_texture_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/se/sjoerd/Graphs/ui/style-preview.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label", FALSE, GraphsStylePreview_private_offset + G_STRUCT_OFFSET (GraphsStylePreviewPrivate, _label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "picture", FALSE, GraphsStylePreview_private_offset + G_STRUCT_OFFSET (GraphsStylePreviewPrivate, _picture));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_button", FALSE, GraphsStylePreview_private_offset + G_STRUCT_OFFSET (GraphsStylePreviewPrivate, _edit_button));
}

static void
graphs_style_preview_instance_init (GraphsStylePreview * self,
                                    gpointer klass)
{
	self->priv = graphs_style_preview_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
graphs_style_preview_finalize (GObject * obj)
{
	GraphsStylePreview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_STYLE_PREVIEW, GraphsStylePreview);
	_g_object_unref0 (self->priv->_style);
	_g_object_unref0 (self->priv->provider);
	G_OBJECT_CLASS (graphs_style_preview_parent_class)->finalize (obj);
}

/**
     * Style Preview widget
     */
static GType
graphs_style_preview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraphsStylePreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphs_style_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphsStylePreview), 0, (GInstanceInitFunc) graphs_style_preview_instance_init, NULL };
	GType graphs_style_preview_type_id;
	graphs_style_preview_type_id = g_type_register_static (gtk_box_get_type (), "GraphsStylePreview", &g_define_type_info, 0);
	GraphsStylePreview_private_offset = g_type_add_instance_private (graphs_style_preview_type_id, sizeof (GraphsStylePreviewPrivate));
	return graphs_style_preview_type_id;
}

GType
graphs_style_preview_get_type (void)
{
	static volatile gsize graphs_style_preview_type_id__once = 0;
	if (g_once_init_enter (&graphs_style_preview_type_id__once)) {
		GType graphs_style_preview_type_id;
		graphs_style_preview_type_id = graphs_style_preview_get_type_once ();
		g_once_init_leave (&graphs_style_preview_type_id__once, graphs_style_preview_type_id);
	}
	return graphs_style_preview_type_id__once;
}

static void
_vala_graphs_style_preview_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GraphsStylePreview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_STYLE_PREVIEW, GraphsStylePreview);
	switch (property_id) {
		case GRAPHS_STYLE_PREVIEW_EDIT_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_style_preview_get_edit_button (self));
		break;
		case GRAPHS_STYLE_PREVIEW_STYLE_PROPERTY:
		g_value_set_object (value, graphs_style_preview_get_style (self));
		break;
		case GRAPHS_STYLE_PREVIEW_PREVIEW_PROPERTY:
		g_value_set_object (value, graphs_style_preview_get_preview (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_graphs_style_preview_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GraphsStylePreview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_STYLE_PREVIEW, GraphsStylePreview);
	switch (property_id) {
		case GRAPHS_STYLE_PREVIEW_STYLE_PROPERTY:
		graphs_style_preview_set_style (self, g_value_get_object (value));
		break;
		case GRAPHS_STYLE_PREVIEW_STYLENAME_PROPERTY:
		graphs_style_preview_set_stylename (self, g_value_get_string (value));
		break;
		case GRAPHS_STYLE_PREVIEW_PREVIEW_PROPERTY:
		graphs_style_preview_set_preview (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
graphs_add_style_dialog_get_instance_private (GraphsAddStyleDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GraphsAddStyleDialog_private_offset);
}

GraphsAddStyleDialog*
graphs_add_style_dialog_construct (GType object_type,
                                   GraphsStyleManager* style_manager,
                                   GtkWidget* parent)
{
	GraphsAddStyleDialog * self = NULL;
	GraphsStyleManager* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	AdwComboRow* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GtkStringList* _tmp5_;
	GtkStringList* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (style_manager != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (GraphsAddStyleDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (style_manager);
	_g_object_unref0 (self->priv->style_manager);
	self->priv->style_manager = _tmp0_;
	_tmp2_ = graphs_style_manager_list_stylenames (style_manager, &_tmp1_);
	self->priv->stylenames = (_vala_array_free (self->priv->stylenames, self->priv->stylenames_length1, (GDestroyNotify) g_free), NULL);
	self->priv->stylenames = _tmp2_;
	self->priv->stylenames_length1 = _tmp1_;
	self->priv->_stylenames_size_ = self->priv->stylenames_length1;
	_tmp3_ = self->priv->_style_templates;
	_tmp4_ = self->priv->stylenames;
	_tmp4__length1 = self->priv->stylenames_length1;
	_tmp5_ = gtk_string_list_new (_tmp4_);
	_tmp6_ = _tmp5_;
	adw_combo_row_set_model (_tmp3_, (GListModel*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = graphs_style_manager_get_use_custom_style (style_manager);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		gchar* template = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = graphs_style_manager_get_custom_style (style_manager);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		template = _tmp11_;
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					gchar** _tmp14_;
					gint _tmp14__length1;
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					if (!_tmp12_) {
						guint _tmp13_;
						_tmp13_ = i;
						i = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp14_ = self->priv->stylenames;
					_tmp14__length1 = self->priv->stylenames_length1;
					if (!(i < ((guint) _tmp14__length1))) {
						break;
					}
					_tmp15_ = self->priv->stylenames;
					_tmp15__length1 = self->priv->stylenames_length1;
					_tmp16_ = _tmp15_[i];
					_tmp17_ = template;
					if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
						AdwComboRow* _tmp18_;
						_tmp18_ = self->priv->_style_templates;
						adw_combo_row_set_selected (_tmp18_, i);
						break;
					}
				}
			}
		}
		_g_free0 (template);
	}
	adw_dialog_present ((AdwDialog*) self, parent);
	return self;
}

GraphsAddStyleDialog*
graphs_add_style_dialog_new (GraphsStyleManager* style_manager,
                             GtkWidget* parent)
{
	return graphs_add_style_dialog_construct (GRAPHS_TYPE_ADD_STYLE_DIALOG, style_manager, parent);
}

static gchar*
graphs_add_style_dialog_get_selected (GraphsAddStyleDialog* self)
{
	GtkStringObject* item = NULL;
	AdwComboRow* _tmp0_;
	GObject* _tmp1_;
	GtkStringObject* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_style_templates;
	_tmp1_ = adw_combo_row_get_selected_item (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_string_object_get_type (), GtkStringObject));
	item = _tmp2_;
	_tmp3_ = gtk_string_object_get_string (item);
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	_g_object_unref0 (item);
	return result;
}

static void
graphs_add_style_dialog_on_template_changed (GraphsAddStyleDialog* self)
{
	AdwEntryRow* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_new_style_name;
	_tmp1_ = graphs_add_style_dialog_get_selected (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->stylenames;
	_tmp3__length1 = self->priv->stylenames_length1;
	_tmp4_ = graphs_tools_get_duplicate_string (_tmp2_, _tmp3_, (gint) _tmp3__length1);
	_tmp5_ = _tmp4_;
	gtk_editable_set_text ((GtkEditable*) _tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
}

static void
_graphs_add_style_dialog_on_template_changed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	graphs_add_style_dialog_on_template_changed ((GraphsAddStyleDialog*) self);
}

static void
graphs_add_style_dialog_on_accept (GraphsAddStyleDialog* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	AdwEntryRow* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = graphs_add_style_dialog_get_selected (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_new_style_name;
	_tmp3_ = gtk_editable_get_text ((GtkEditable*) _tmp2_);
	g_signal_emit (self, graphs_add_style_dialog_signals[GRAPHS_ADD_STYLE_DIALOG_ACCEPT_SIGNAL], 0, _tmp1_, _tmp3_);
	_g_free0 (_tmp1_);
	adw_dialog_close ((AdwDialog*) self);
}

static void
_graphs_add_style_dialog_on_accept_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
	graphs_add_style_dialog_on_accept ((GraphsAddStyleDialog*) self);
}

static AdwEntryRow*
graphs_add_style_dialog_get_new_style_name (GraphsAddStyleDialog* self)
{
	AdwEntryRow* result;
	AdwEntryRow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_new_style_name;
	result = _tmp0_;
	return result;
}

static AdwComboRow*
graphs_add_style_dialog_get_style_templates (GraphsAddStyleDialog* self)
{
	AdwComboRow* result;
	AdwComboRow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_style_templates;
	result = _tmp0_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
graphs_add_style_dialog_class_init (GraphsAddStyleDialogClass * klass,
                                    gpointer klass_data)
{
	graphs_add_style_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraphsAddStyleDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_graphs_add_style_dialog_get_property;
	G_OBJECT_CLASS (klass)->finalize = graphs_add_style_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/se/sjoerd/Graphs/ui/add-style.ui");
	graphs_add_style_dialog_signals[GRAPHS_ADD_STYLE_DIALOG_ACCEPT_SIGNAL] = g_signal_new ("accept", GRAPHS_TYPE_ADD_STYLE_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_style_name", FALSE, GraphsAddStyleDialog_private_offset + G_STRUCT_OFFSET (GraphsAddStyleDialogPrivate, _new_style_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "style_templates", FALSE, GraphsAddStyleDialog_private_offset + G_STRUCT_OFFSET (GraphsAddStyleDialogPrivate, _style_templates));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_template_changed", G_CALLBACK(_graphs_add_style_dialog_on_template_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_accept", G_CALLBACK(_graphs_add_style_dialog_on_accept_gtk_button_clicked));
}

static void
graphs_add_style_dialog_instance_init (GraphsAddStyleDialog * self,
                                       gpointer klass)
{
	self->priv = graphs_add_style_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
graphs_add_style_dialog_finalize (GObject * obj)
{
	GraphsAddStyleDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_ADD_STYLE_DIALOG, GraphsAddStyleDialog);
	_g_object_unref0 (self->priv->style_manager);
	self->priv->stylenames = (_vala_array_free (self->priv->stylenames, self->priv->stylenames_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (graphs_add_style_dialog_parent_class)->finalize (obj);
}

/**
     * Add style dialog
     */
static GType
graphs_add_style_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraphsAddStyleDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphs_add_style_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphsAddStyleDialog), 0, (GInstanceInitFunc) graphs_add_style_dialog_instance_init, NULL };
	GType graphs_add_style_dialog_type_id;
	graphs_add_style_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "GraphsAddStyleDialog", &g_define_type_info, 0);
	GraphsAddStyleDialog_private_offset = g_type_add_instance_private (graphs_add_style_dialog_type_id, sizeof (GraphsAddStyleDialogPrivate));
	return graphs_add_style_dialog_type_id;
}

GType
graphs_add_style_dialog_get_type (void)
{
	static volatile gsize graphs_add_style_dialog_type_id__once = 0;
	if (g_once_init_enter (&graphs_add_style_dialog_type_id__once)) {
		GType graphs_add_style_dialog_type_id;
		graphs_add_style_dialog_type_id = graphs_add_style_dialog_get_type_once ();
		g_once_init_leave (&graphs_add_style_dialog_type_id__once, graphs_add_style_dialog_type_id);
	}
	return graphs_add_style_dialog_type_id__once;
}

static void
_vala_graphs_add_style_dialog_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GraphsAddStyleDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_ADD_STYLE_DIALOG, GraphsAddStyleDialog);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

