/* Utils.c generated by valac 0.56.17, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright 2012–2021 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite-7.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add15 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add16 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add17 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add19 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add20 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add21 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add22 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add23 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add24 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
 G_GNUC_INTERNAL gdouble granite_contrast_ratio (GdkRGBA* bg_color,
                                GdkRGBA* fg_color);
 G_GNUC_INTERNAL gdouble granite_get_luminance (GdkRGBA* color);
 G_GNUC_INTERNAL gdouble granite_sanitize_color (gdouble color);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
 * Converts a {@link Gtk.accelerator_parse} style accel string to a human-readable string.
 *
 * @param accel an accelerator label like “<Control>a” or “<Super>Right”
 *
 * @return a human-readable string like "Ctrl + A" or "⌘ + →"
 */
static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add15 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add16 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add17 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add19 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add20 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add21 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
granite_accel_to_string (const gchar* accel)
{
	guint accel_key = 0U;
	GdkModifierType accel_mods = 0U;
	guint _tmp1_ = 0U;
	GdkModifierType _tmp2_ = 0U;
	gchar** arr = NULL;
	gchar** _tmp3_;
	gint arr_length1;
	gint _arr_size_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* result;
	if (accel == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	granite_init ();
	gtk_accelerator_parse (accel, &_tmp1_, &_tmp2_);
	accel_key = _tmp1_;
	accel_mods = _tmp2_;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	arr = _tmp3_;
	arr_length1 = 0;
	_arr_size_ = arr_length1;
	if ((accel_mods & GDK_SUPER_MASK) == GDK_SUPER_MASK) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("⌘");
		_vala_array_add2 (&arr, &arr_length1, &_arr_size_, _tmp4_);
	}
	if ((accel_mods & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Shift"));
		_vala_array_add3 (&arr, &arr_length1, &_arr_size_, _tmp5_);
	}
	if ((accel_mods & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (_ ("Ctrl"));
		_vala_array_add4 (&arr, &arr_length1, &_arr_size_, _tmp6_);
	}
	if ((accel_mods & GDK_ALT_MASK) == GDK_ALT_MASK) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (_ ("Alt"));
		_vala_array_add5 (&arr, &arr_length1, &_arr_size_, _tmp7_);
	}
	switch (accel_key) {
		case GDK_KEY_Up:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("↑");
			_vala_array_add6 (&arr, &arr_length1, &_arr_size_, _tmp8_);
			break;
		}
		case GDK_KEY_Down:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("↓");
			_vala_array_add7 (&arr, &arr_length1, &_arr_size_, _tmp9_);
			break;
		}
		case GDK_KEY_Left:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("←");
			_vala_array_add8 (&arr, &arr_length1, &_arr_size_, _tmp10_);
			break;
		}
		case GDK_KEY_Right:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("→");
			_vala_array_add9 (&arr, &arr_length1, &_arr_size_, _tmp11_);
			break;
		}
		case GDK_KEY_Alt_L:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup (_ ("Left Alt"));
			_vala_array_add10 (&arr, &arr_length1, &_arr_size_, _tmp12_);
			break;
		}
		case GDK_KEY_Alt_R:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup (_ ("Right Alt"));
			_vala_array_add11 (&arr, &arr_length1, &_arr_size_, _tmp13_);
			break;
		}
		case GDK_KEY_backslash:
		{
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("\\");
			_vala_array_add12 (&arr, &arr_length1, &_arr_size_, _tmp14_);
			break;
		}
		case GDK_KEY_Control_R:
		{
			gchar* _tmp15_;
			_tmp15_ = g_strdup (_ ("Right Ctrl"));
			_vala_array_add13 (&arr, &arr_length1, &_arr_size_, _tmp15_);
			break;
		}
		case GDK_KEY_Control_L:
		{
			gchar* _tmp16_;
			_tmp16_ = g_strdup (_ ("Left Ctrl"));
			_vala_array_add14 (&arr, &arr_length1, &_arr_size_, _tmp16_);
			break;
		}
		case GDK_KEY_minus:
		case GDK_KEY_KP_Subtract:
		{
			gchar* _tmp17_;
			_tmp17_ = g_strdup (_ ("Minus"));
			_vala_array_add15 (&arr, &arr_length1, &_arr_size_, _tmp17_);
			break;
		}
		case GDK_KEY_KP_Add:
		case GDK_KEY_plus:
		{
			gchar* _tmp18_;
			_tmp18_ = g_strdup (_ ("Plus"));
			_vala_array_add16 (&arr, &arr_length1, &_arr_size_, _tmp18_);
			break;
		}
		case GDK_KEY_KP_Equal:
		case GDK_KEY_equal:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup (_ ("Equals"));
			_vala_array_add17 (&arr, &arr_length1, &_arr_size_, _tmp19_);
			break;
		}
		case GDK_KEY_Return:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup (_ ("Enter"));
			_vala_array_add18 (&arr, &arr_length1, &_arr_size_, _tmp20_);
			break;
		}
		case GDK_KEY_Shift_L:
		{
			gchar* _tmp21_;
			_tmp21_ = g_strdup (_ ("Left Shift"));
			_vala_array_add19 (&arr, &arr_length1, &_arr_size_, _tmp21_);
			break;
		}
		case GDK_KEY_Shift_R:
		{
			gchar* _tmp22_;
			_tmp22_ = g_strdup (_ ("Right Shift"));
			_vala_array_add20 (&arr, &arr_length1, &_arr_size_, _tmp22_);
			break;
		}
		default:
		{
			gchar* accel_label = NULL;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			_tmp23_ = gtk_accelerator_get_label (accel_key, 0);
			accel_label = _tmp23_;
			_tmp24_ = accel_label;
			if (g_strcmp0 (_tmp24_, "") != 0) {
				const gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp25_ = accel_label;
				_tmp26_ = g_strdup (_tmp25_);
				_vala_array_add21 (&arr, &arr_length1, &_arr_size_, _tmp26_);
			}
			_g_free0 (accel_label);
			break;
		}
	}
	if (accel_mods != 0) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar* _tmp28_;
		_tmp27_ = arr;
		_tmp27__length1 = arr_length1;
		_tmp28_ = _vala_g_strjoinv (" + ", _tmp27_, (gint) _tmp27__length1);
		result = _tmp28_;
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp29_ = arr;
	_tmp29__length1 = arr_length1;
	_tmp30_ = _tmp29_[0];
	_tmp31_ = g_strdup (_tmp30_);
	result = _tmp31_;
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
 * Takes a description and an array of accels and returns {@link Pango} markup for use in a {@link Gtk.Tooltip}. This method uses {@link Granite.accel_to_string}.
 *
 * Example:
 *
 * Description
 * Shortcut 1, Shortcut 2
 *
 * @param a string array of accelerator labels like {"<Control>a", "<Super>Right"}
 *
 * @param description a standard tooltip text string
 *
 * @return {@link Pango} markup with the description label on one line and a list of human-readable accels on a new line
 */
static void
_vala_array_add22 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add23 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add24 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar*
granite_markup_accel_tooltip (gchar** accels,
                              gint accels_length1,
                              const gchar* description)
{
	gchar** parts = NULL;
	gchar** _tmp0_;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar* result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	parts = _tmp0_;
	parts_length1 = 0;
	_parts_size_ = parts_length1;
	if (description != NULL) {
		_tmp1_ = g_strcmp0 (description, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (description);
		_vala_array_add22 (&parts, &parts_length1, &_parts_size_, _tmp2_);
	}
	if (accels != NULL) {
		_tmp3_ = accels_length1 > 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar** unique_accels = NULL;
		gchar** _tmp4_;
		gint unique_accels_length1;
		gint _unique_accels_size_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp4_ = g_new0 (gchar*, 0 + 1);
		unique_accels = _tmp4_;
		unique_accels_length1 = 0;
		_unique_accels_size_ = unique_accels_length1;
		granite_init ();
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					const gchar* _tmp7_;
					gchar* accel_string = NULL;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar** _tmp11_;
					gint _tmp11__length1;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < accels_length1)) {
						break;
					}
					_tmp7_ = accels[i];
					if (g_strcmp0 (_tmp7_, "") == 0) {
						continue;
					}
					_tmp8_ = accels[i];
					_tmp9_ = granite_accel_to_string (_tmp8_);
					accel_string = _tmp9_;
					_tmp10_ = accel_string;
					_tmp11_ = unique_accels;
					_tmp11__length1 = unique_accels_length1;
					if (!_vala_string_array_contains (_tmp11_, _tmp11__length1, _tmp10_)) {
						const gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp12_ = accel_string;
						_tmp13_ = g_strdup (_tmp12_);
						_vala_array_add23 (&unique_accels, &unique_accels_length1, &_unique_accels_size_, _tmp13_);
					}
					_g_free0 (accel_string);
				}
			}
		}
		_tmp14_ = unique_accels;
		_tmp14__length1 = unique_accels_length1;
		if (_tmp14__length1 > 0) {
			gchar* accel_label = NULL;
			gchar** _tmp15_;
			gint _tmp15__length1;
			gchar* _tmp16_;
			gchar* accel_markup = NULL;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = unique_accels;
			_tmp15__length1 = unique_accels_length1;
			_tmp16_ = _vala_g_strjoinv (_ (", "), _tmp15_, (gint) _tmp15__length1);
			accel_label = _tmp16_;
			_tmp17_ = accel_label;
			_tmp18_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _tmp17_);
			accel_markup = _tmp18_;
			_tmp19_ = accel_markup;
			_tmp20_ = g_strdup (_tmp19_);
			_vala_array_add24 (&parts, &parts_length1, &_parts_size_, _tmp20_);
			_g_free0 (accel_markup);
			_g_free0 (accel_label);
		}
		unique_accels = (_vala_array_free (unique_accels, unique_accels_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp21_ = parts;
	_tmp21__length1 = parts_length1;
	_tmp22_ = _vala_g_strjoinv ("\n", _tmp21_, (gint) _tmp21__length1);
	result = _tmp22_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

 G_GNUC_INTERNAL gdouble
granite_contrast_ratio (GdkRGBA* bg_color,
                        GdkRGBA* fg_color)
{
	gdouble bg_luminance = 0.0;
	GdkRGBA _tmp0_;
	gdouble fg_luminance = 0.0;
	GdkRGBA _tmp1_;
	gdouble result;
	g_return_val_if_fail (bg_color != NULL, 0.0);
	g_return_val_if_fail (fg_color != NULL, 0.0);
	_tmp0_ = *bg_color;
	bg_luminance = granite_get_luminance (&_tmp0_);
	_tmp1_ = *fg_color;
	fg_luminance = granite_get_luminance (&_tmp1_);
	if (bg_luminance > fg_luminance) {
		result = (bg_luminance + 0.05) / (fg_luminance + 0.05);
		return result;
	}
	result = (fg_luminance + 0.05) / (bg_luminance + 0.05);
	return result;
}

 G_GNUC_INTERNAL gdouble
granite_get_luminance (GdkRGBA* color)
{
	gdouble red = 0.0;
	GdkRGBA _tmp0_;
	gdouble green = 0.0;
	GdkRGBA _tmp1_;
	gdouble blue = 0.0;
	GdkRGBA _tmp2_;
	gdouble result;
	g_return_val_if_fail (color != NULL, 0.0);
	_tmp0_ = *color;
	red = granite_sanitize_color ((gdouble) _tmp0_.red) * 0.2126;
	_tmp1_ = *color;
	green = granite_sanitize_color ((gdouble) _tmp1_.green) * 0.7152;
	_tmp2_ = *color;
	blue = granite_sanitize_color ((gdouble) _tmp2_.blue) * 0.0722;
	result = (red + green) + blue;
	return result;
}

 G_GNUC_INTERNAL gdouble
granite_sanitize_color (gdouble color)
{
	gdouble result;
	if (color <= 0.03928) {
		result = color / 12.92;
		return result;
	}
	result = pow ((color + 0.055) / 1.055, 2.4);
	return result;
}

/**
 * Takes a {@link Gdk.RGBA} background color and returns a suitably-contrasting foreground color, i.e. for determining text color on a colored background. There is a slight bias toward returning white, as white generally looks better on a wider range of colored backgrounds than black.
 *
 * @param bg_color any {@link Gdk.RGBA} background color
 *
 * @return a contrasting {@link Gdk.RGBA} foreground color, i.e. white ({ 1.0, 1.0, 1.0, 1.0}) or black ({ 0.0, 0.0, 0.0, 1.0}).
 */
void
granite_contrasting_foreground_color (GdkRGBA* bg_color,
                                      GdkRGBA* result)
{
	GdkRGBA gdk_white = {0};
	GdkRGBA _tmp0_ = {0};
	GdkRGBA gdk_black = {0};
	GdkRGBA _tmp1_ = {0};
	gdouble contrast_with_white = 0.0;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	gdouble contrast_with_black = 0.0;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA fg_color = {0};
	GdkRGBA _tmp6_;
	g_return_if_fail (bg_color != NULL);
	_tmp0_.red = 1.0f;
	_tmp0_.green = 1.0f;
	_tmp0_.blue = 1.0f;
	_tmp0_.alpha = 1.0f;
	gdk_white = _tmp0_;
	_tmp1_.red = 0.0f;
	_tmp1_.green = 0.0f;
	_tmp1_.blue = 0.0f;
	_tmp1_.alpha = 1.0f;
	gdk_black = _tmp1_;
	_tmp2_ = *bg_color;
	_tmp3_ = gdk_white;
	contrast_with_white = granite_contrast_ratio (&_tmp2_, &_tmp3_);
	_tmp4_ = *bg_color;
	_tmp5_ = gdk_black;
	contrast_with_black = granite_contrast_ratio (&_tmp4_, &_tmp5_);
	_tmp6_ = gdk_white;
	fg_color = _tmp6_;
	if (contrast_with_black > (contrast_with_white + 3)) {
		GdkRGBA _tmp7_;
		_tmp7_ = gdk_black;
		fg_color = _tmp7_;
	}
	*result = fg_color;
	return;
}

/**
     * Applies colorPrimary property to the window. The colorPrimary property currently changes
     * the color of the {@link Gtk.HeaderBar} and it's children so that the application window
     * can have a so-called "brand color".
     *
     * Note that this currently only works with the default stylesheet that elementary OS uses.
     *
     * @param window the widget to apply the color, for most cases the widget will be actually the {@link Gtk.Window} itself
     * @param color the color to apply
     * @param priority priorty of change, by default {@link Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION}
     *
     * @return the added {@link Gtk.CssProvider}, or null in case the parsing of
     *         stylesheet failed.
     */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

GtkCssProvider*
granite_widgets_utils_set_color_primary (GtkWidget* window,
                                         GdkRGBA* color,
                                         gint priority)
{
	gchar* css = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	guint8* _tmp7_;
	gint _tmp7__length1;
	GdkDisplay* _tmp8_;
	GtkCssProvider* result;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	_vala_assert (window != NULL, "window != null");
	_tmp0_ = gdk_rgba_to_string (color);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("@define-color color_primary %s;", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	css = _tmp3_;
	_tmp4_ = gtk_css_provider_new ();
	css_provider = _tmp4_;
	_tmp5_ = string_get_data (css, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	gtk_css_provider_load_from_data (css_provider, (const char*) _tmp7_, (gssize) _tmp7__length1);
	_tmp8_ = gdk_display_get_default ();
	gtk_style_context_add_provider_for_display (_tmp8_, (GtkStyleProvider*) css_provider, (guint) priority);
	result = css_provider;
	_g_free0 (css);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

