/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, vocoder, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_vocoder_cvsd_decode_bs = R"doc(This block performs CVSD audio decoding. Its design and implementation is modeled after the CVSD encoder/decoder specifications defined in the Bluetooth standard.

CVSD is a method for encoding speech that seeks to reduce the bandwidth required for digital voice transmission. CVSD takes advantage of strong correlation between samples, quantizing the difference in amplitude between two consecutive samples. This difference requires fewer quantization levels as compared to other methods that quantize the actual amplitude level, reducing the bandwidth. CVSD employs a two level quantizer (one bit) and an adaptive algorithm that allows for continuous step size adjustment.


The coder can represent low amplitude signals with accuracy without sacrificing performance on large amplitude signals, a trade off that occurs in some non-adaptive modulations.


The CVSD decoder effectively provides 1-to-8 decompression. More specifically, for each incoming input bit, the decoder outputs one audio sample. If the input is a \"1\" bit, the internal reference is increased appropriately and then outputted as the next estimated audio sample. If the input is a \"0\" bit, the internal reference is decreased appropriately and then likewise outputted as the next estimated audio sample. Grouping 8 input bits together, the encoder essentially produces 8 output audio samples for everyone one input byte.


This decoder requires that output audio samples are 2-byte short signed integers. The result bandwidth conversion, therefore, is 1 byte of encoded audio data to 16 output bytes of raw audio data.


The CVSD decoder module must be post-fixed by a down-converter to under-sample the audio data after decoding. The Bluetooth standard specifically calls for a 8-to-1 decimating down-converter. This is required so that so that output sampling rate equals the original input sampling rate present before the encoder. In all cases, the output down-converter rate must be the inverse of the input up-converter rate before the CVSD encoder.


References:

Constructor Specific Documentation:

Constructor parameters to initialize the CVSD decoder. The default values are modeled after the Bluetooth standard and should not be changed, except by an advanced user.

Args:
    min_step : Minimum step size used to update the internal reference. Default: \"10\"
    max_step : Maximum step size used to update the internal reference. Default: \"1280\"
    step_decay : Decay factor applied to step size when there is not a run of J output 1s or 0s. Default: \"0.9990234375\" (i.e. 1-1/1024)
    accum_decay : Decay factor applied to the internal reference during every iteration of the codec. Default: \"0.96875\" (i.e. 1-1/32)
    K : Size of shift register; the number of output bits remembered by codec (must be <= to 32). Default: \"32\"
    J : Number of bits in the shift register that are equal; i.e. the size of a run of 1s, 0s. Default: \"4\"
    pos_accum_max : Maximum integer value allowed for the internal reference. Default: \"32767\" (2^15 - 1 or MAXSHORT)
    neg_accum_max : Minimum integer value allowed for the internal reference. Default: \"-32767\" (-2^15 + 1 or MINSHORT+1))doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_cvsd_decode_bs_0 = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_cvsd_decode_bs_1 = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_make = R"doc(This block performs CVSD audio decoding. Its design and implementation is modeled after the CVSD encoder/decoder specifications defined in the Bluetooth standard.

CVSD is a method for encoding speech that seeks to reduce the bandwidth required for digital voice transmission. CVSD takes advantage of strong correlation between samples, quantizing the difference in amplitude between two consecutive samples. This difference requires fewer quantization levels as compared to other methods that quantize the actual amplitude level, reducing the bandwidth. CVSD employs a two level quantizer (one bit) and an adaptive algorithm that allows for continuous step size adjustment.


The coder can represent low amplitude signals with accuracy without sacrificing performance on large amplitude signals, a trade off that occurs in some non-adaptive modulations.


The CVSD decoder effectively provides 1-to-8 decompression. More specifically, for each incoming input bit, the decoder outputs one audio sample. If the input is a \"1\" bit, the internal reference is increased appropriately and then outputted as the next estimated audio sample. If the input is a \"0\" bit, the internal reference is decreased appropriately and then likewise outputted as the next estimated audio sample. Grouping 8 input bits together, the encoder essentially produces 8 output audio samples for everyone one input byte.


This decoder requires that output audio samples are 2-byte short signed integers. The result bandwidth conversion, therefore, is 1 byte of encoded audio data to 16 output bytes of raw audio data.


The CVSD decoder module must be post-fixed by a down-converter to under-sample the audio data after decoding. The Bluetooth standard specifically calls for a 8-to-1 decimating down-converter. This is required so that so that output sampling rate equals the original input sampling rate present before the encoder. In all cases, the output down-converter rate must be the inverse of the input up-converter rate before the CVSD encoder.


References:

Constructor Specific Documentation:

Constructor parameters to initialize the CVSD decoder. The default values are modeled after the Bluetooth standard and should not be changed, except by an advanced user.

Args:
    min_step : Minimum step size used to update the internal reference. Default: \"10\"
    max_step : Maximum step size used to update the internal reference. Default: \"1280\"
    step_decay : Decay factor applied to step size when there is not a run of J output 1s or 0s. Default: \"0.9990234375\" (i.e. 1-1/1024)
    accum_decay : Decay factor applied to the internal reference during every iteration of the codec. Default: \"0.96875\" (i.e. 1-1/32)
    K : Size of shift register; the number of output bits remembered by codec (must be <= to 32). Default: \"32\"
    J : Number of bits in the shift register that are equal; i.e. the size of a run of 1s, 0s. Default: \"4\"
    pos_accum_max : Maximum integer value allowed for the internal reference. Default: \"32767\" (2^15 - 1 or MAXSHORT)
    neg_accum_max : Minimum integer value allowed for the internal reference. Default: \"-32767\" (-2^15 + 1 or MINSHORT+1))doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_min_step = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_max_step = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_step_decay = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_accum_decay = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_K = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_J = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_pos_accum_max = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_decode_bs_neg_accum_max = R"doc()doc";
