/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt_bit_inner_deinterleaver = R"doc(Bit Inner deinterleaver.

ETSI EN 300 744 Clause 4.3.4.1 
Data Input format: 
000000B0B1 - QPSK. 
0000B0B1B2B3 - 16QAM. 
00B0B1B2B3B4B5 - 64QAM. 
Data Output format: 
000000X0X1 - QPSK. 
0000X0X1X2X3 - 16QAM. 
00X0X1X2X3X4X5 - 64QAM. 
bit deinterleaver block size is 126.

Constructor Specific Documentation:

Create a Bit Inner deinterleaver.

Args:
    nsize : length of input stream.
    constellation : constellation used.
    hierarchy : hierarchy used.
    transmission : transmission mode used.)doc";


static const char*
    __doc_gr_dtv_dvbt_bit_inner_deinterleaver_dvbt_bit_inner_deinterleaver = R"doc()doc";


static const char* __doc_gr_dtv_dvbt_bit_inner_deinterleaver_make = R"doc(Bit Inner deinterleaver.

ETSI EN 300 744 Clause 4.3.4.1 
Data Input format: 
000000B0B1 - QPSK. 
0000B0B1B2B3 - 16QAM. 
00B0B1B2B3B4B5 - 64QAM. 
Data Output format: 
000000X0X1 - QPSK. 
0000X0X1X2X3 - 16QAM. 
00X0X1X2X3X4X5 - 64QAM. 
bit deinterleaver block size is 126.

Constructor Specific Documentation:

Create a Bit Inner deinterleaver.

Args:
    nsize : length of input stream.
    constellation : constellation used.
    hierarchy : hierarchy used.
    transmission : transmission mode used.)doc";
