/* paths.c generated by valac 0.56.18, the Vala compiler
 * generated from paths.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_PATHS (gnome_pie_paths_get_type ())
#define GNOME_PIE_PATHS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_PATHS, GnomePiePaths))
#define GNOME_PIE_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_PATHS, GnomePiePathsClass))
#define GNOME_PIE_IS_PATHS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_PATHS))
#define GNOME_PIE_IS_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_PATHS))
#define GNOME_PIE_PATHS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_PATHS, GnomePiePathsClass))

typedef struct _GnomePiePaths GnomePiePaths;
typedef struct _GnomePiePathsClass GnomePiePathsClass;
typedef struct _GnomePiePathsPrivate GnomePiePathsPrivate;
enum  {
	GNOME_PIE_PATHS_0_PROPERTY,
	GNOME_PIE_PATHS_NUM_PROPERTIES
};
static GParamSpec* gnome_pie_paths_properties[GNOME_PIE_PATHS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GnomePiePaths {
	GObject parent_instance;
	GnomePiePathsPrivate * priv;
};

struct _GnomePiePathsClass {
	GObjectClass parent_class;
};

static gpointer gnome_pie_paths_parent_class = NULL;
static gchar* gnome_pie_paths__config_directory;
static gchar* gnome_pie_paths__config_directory = NULL;
static gchar* gnome_pie_paths__log;
static gchar* gnome_pie_paths__log = NULL;
static gchar* gnome_pie_paths__settings;
static gchar* gnome_pie_paths__settings = NULL;
static gchar* gnome_pie_paths__pie_config;
static gchar* gnome_pie_paths__pie_config = NULL;
static gchar* gnome_pie_paths__local_themes;
static gchar* gnome_pie_paths__local_themes = NULL;
static gchar* gnome_pie_paths__global_themes;
static gchar* gnome_pie_paths__global_themes = NULL;
static gchar* gnome_pie_paths__locales;
static gchar* gnome_pie_paths__locales = NULL;
static gchar* gnome_pie_paths__ui_files;
static gchar* gnome_pie_paths__ui_files = NULL;
static gchar* gnome_pie_paths__autostart;
static gchar* gnome_pie_paths__autostart = NULL;
static gchar* gnome_pie_paths__launchers;
static gchar* gnome_pie_paths__launchers = NULL;
static gchar* gnome_pie_paths__executable;
static gchar* gnome_pie_paths__executable = NULL;

VALA_EXTERN GType gnome_pie_paths_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePiePaths, g_object_unref)
VALA_EXTERN void gnome_pie_paths_delete_directory (const gchar* directory);
VALA_EXTERN void gnome_pie_paths_init (void);
static void gnome_pie_paths_set_executable (const gchar* value);
VALA_EXTERN const gchar* gnome_pie_paths_get_executable (void);
static void gnome_pie_paths_set_global_themes (const gchar* value);
static void gnome_pie_paths_set_ui_files (const gchar* value);
static void gnome_pie_paths_set_locales (const gchar* value);
static void gnome_pie_paths_set_config_directory (const gchar* value);
static void gnome_pie_paths_set_local_themes (const gchar* value);
static void gnome_pie_paths_set_launchers (const gchar* value);
static void gnome_pie_paths_set_pie_config (const gchar* value);
static void gnome_pie_paths_set_settings (const gchar* value);
static void gnome_pie_paths_set_log (const gchar* value);
VALA_EXTERN const gchar* gnome_pie_paths_get_log (void);
static void gnome_pie_paths_set_autostart (const gchar* value);
VALA_EXTERN const gchar* gnome_pie_paths_get_pie_config (void);
VALA_EXTERN const gchar* gnome_pie_paths_get_settings (void);
VALA_EXTERN const gchar* gnome_pie_paths_get_local_themes (void);
VALA_EXTERN const gchar* gnome_pie_paths_get_launchers (void);
VALA_EXTERN const gchar* gnome_pie_paths_get_global_themes (void);
VALA_EXTERN const gchar* gnome_pie_paths_get_ui_files (void);
VALA_EXTERN GnomePiePaths* gnome_pie_paths_new (void);
VALA_EXTERN GnomePiePaths* gnome_pie_paths_construct (GType object_type);
VALA_EXTERN const gchar* gnome_pie_paths_get_config_directory (void);
VALA_EXTERN const gchar* gnome_pie_paths_get_locales (void);
VALA_EXTERN const gchar* gnome_pie_paths_get_autostart (void);
static void gnome_pie_paths_finalize (GObject * obj);
static GType gnome_pie_paths_get_type_once (void);
static void _vala_gnome_pie_paths_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gnome_pie_paths_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
gnome_pie_paths_delete_directory (const gchar* directory)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (directory != NULL);
	{
		GDir* d = NULL;
		GDir* _tmp0_;
		gchar* name = NULL;
		_tmp0_ = g_dir_open (directory, (guint) 0, &_inner_error0_);
		d = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GDir* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* path = NULL;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp1_ = d;
			_tmp2_ = g_dir_read_name (_tmp1_);
			_tmp3_ = g_strdup (_tmp2_);
			_g_free0 (name);
			name = _tmp3_;
			_tmp4_ = name;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = name;
			_tmp6_ = g_build_filename (directory, _tmp5_, NULL);
			path = _tmp6_;
			_tmp7_ = path;
			if (g_file_test (_tmp7_, G_FILE_TEST_IS_DIR)) {
				const gchar* _tmp8_;
				_tmp8_ = path;
				gnome_pie_paths_delete_directory (_tmp8_);
			} else {
				const gchar* _tmp9_;
				_tmp9_ = path;
				g_remove (_tmp9_);
			}
			_g_free0 (path);
		}
		g_rmdir (directory);
		_g_free0 (name);
		_g_dir_close0 (d);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("paths.vala:127: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
gnome_pie_paths_init (void)
{
	GFile* icon_dir = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GtkIconTheme* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GFile* default_dir = NULL;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GFile* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GFile* locale_dir = NULL;
	GFile* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	GFile* config_dir = NULL;
	const gchar* _tmp68_;
	GFile* _tmp69_;
	GFile* _tmp70_;
	GFile* _tmp71_;
	GFile* _tmp72_;
	GFile* _tmp73_;
	GFile* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	GFile* themes_dir = NULL;
	GFile* _tmp79_;
	GFile* _tmp80_;
	GFile* _tmp81_;
	GFile* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	GFile* launchers_dir = NULL;
	GFile* _tmp87_;
	GFile* _tmp88_;
	GFile* _tmp89_;
	GFile* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	GFile* config_file = NULL;
	GFile* _tmp95_;
	GFile* _tmp96_;
	GFile* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	GFile* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	GFile* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	const gchar* _tmp110_;
	const gchar* _tmp111_;
	GFile* _tmp112_;
	GFile* _tmp113_;
	gboolean _tmp114_;
	const gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	const gchar* _tmp121_;
	const gchar* _tmp122_;
	GFile* _tmp123_;
	GFile* _tmp124_;
	gboolean _tmp125_;
	const gchar* _tmp126_;
	const gchar* _tmp127_;
	GFile* _tmp128_;
	GFile* _tmp129_;
	gboolean _tmp130_;
	const gchar* _tmp131_;
	const gchar* _tmp132_;
	GFile* _tmp133_;
	GFile* _tmp134_;
	gboolean _tmp135_;
	const gchar* _tmp136_;
	const gchar* _tmp137_;
	GFile* _tmp138_;
	GFile* _tmp139_;
	gboolean _tmp140_;
	const gchar* _tmp141_;
	const gchar* _tmp142_;
	GFile* _tmp143_;
	GFile* _tmp144_;
	gboolean _tmp145_;
	const gchar* _tmp146_;
	const gchar* _tmp147_;
	GFile* _tmp148_;
	GFile* _tmp149_;
	gboolean _tmp150_;
	const gchar* _tmp151_;
	const gchar* _tmp152_;
	GFile* _tmp153_;
	GFile* _tmp154_;
	gboolean _tmp155_;
	GError* _inner_error0_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = g_file_read_link ("/proc/self/exe", &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = g_file_new_for_path (_tmp0_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		gnome_pie_paths_set_executable (_tmp5_);
		_g_free0 (_tmp5_);
		_g_object_unref0 (_tmp3_);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("paths.vala:141: Failed to get path of executable!");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = gnome_pie_paths_get_executable ();
	_tmp7_ = _tmp6_;
	_tmp8_ = g_path_get_dirname (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_new_for_path (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_get_child (_tmp11_, "resources");
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_g_free0 (_tmp9_);
	icon_dir = _tmp13_;
	_tmp14_ = icon_dir;
	if (g_file_query_exists (_tmp14_, NULL)) {
		gchar* path = NULL;
		GFile* _tmp15_;
		gchar* _tmp16_;
		GtkIconTheme* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = icon_dir;
		_tmp16_ = g_file_get_path (_tmp15_);
		path = _tmp16_;
		_tmp17_ = gtk_icon_theme_get_default ();
		_tmp18_ = path;
		gtk_icon_theme_append_search_path (_tmp17_, _tmp18_);
		_g_free0 (path);
	}
	_tmp19_ = gtk_icon_theme_get_default ();
	_tmp20_ = g_get_home_dir ();
	_tmp21_ = g_strconcat (_tmp20_, ".icons", NULL);
	_tmp22_ = _tmp21_;
	gtk_icon_theme_append_search_path (_tmp19_, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = g_file_new_for_path ("/usr/share/gnome-pie/");
	default_dir = _tmp23_;
	_tmp24_ = default_dir;
	if (!g_file_query_exists (_tmp24_, NULL)) {
		GFile* _tmp25_;
		GFile* _tmp26_;
		_tmp25_ = g_file_new_for_path ("/usr/local/share/gnome-pie/");
		_g_object_unref0 (default_dir);
		default_dir = _tmp25_;
		_tmp26_ = default_dir;
		if (!g_file_query_exists (_tmp26_, NULL)) {
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			GFile* _tmp31_;
			GFile* _tmp32_;
			GFile* _tmp33_;
			_tmp27_ = gnome_pie_paths_get_executable ();
			_tmp28_ = _tmp27_;
			_tmp29_ = g_path_get_dirname (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_file_new_for_path (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_file_get_child (_tmp32_, "resources");
			_g_object_unref0 (default_dir);
			default_dir = _tmp33_;
			_g_object_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
		}
	}
	_tmp34_ = default_dir;
	_tmp35_ = g_file_get_path (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat (_tmp36_, "/themes", NULL);
	_tmp38_ = _tmp37_;
	gnome_pie_paths_set_global_themes (_tmp38_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_tmp39_ = default_dir;
	_tmp40_ = g_file_get_path (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_tmp41_, "/ui", NULL);
	_tmp43_ = _tmp42_;
	gnome_pie_paths_set_ui_files (_tmp43_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	_tmp44_ = g_file_new_for_path ("/usr/share/locale/de/LC_MESSAGES/gnomepie.mo");
	locale_dir = _tmp44_;
	_tmp45_ = locale_dir;
	if (g_file_query_exists (_tmp45_, NULL)) {
		GFile* _tmp46_;
		_tmp46_ = g_file_new_for_path ("/usr/share/locale");
		_g_object_unref0 (locale_dir);
		locale_dir = _tmp46_;
	} else {
		GFile* _tmp47_;
		GFile* _tmp48_;
		_tmp47_ = g_file_new_for_path ("/usr/local/share/locale/de/LC_MESSAGES/gnomepie.mo");
		_g_object_unref0 (locale_dir);
		locale_dir = _tmp47_;
		_tmp48_ = locale_dir;
		if (g_file_query_exists (_tmp48_, NULL)) {
			GFile* _tmp49_;
			_tmp49_ = g_file_new_for_path ("/usr/local/share/locale");
			_g_object_unref0 (locale_dir);
			locale_dir = _tmp49_;
		} else {
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			GFile* _tmp54_;
			GFile* _tmp55_;
			GFile* _tmp56_;
			GFile* _tmp57_;
			_tmp50_ = gnome_pie_paths_get_executable ();
			_tmp51_ = _tmp50_;
			_tmp52_ = g_path_get_dirname (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_file_new_for_path (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_file_get_child (_tmp55_, "resources/locale/de/LC_MESSAGES/gnomepie.mo");
			_g_object_unref0 (locale_dir);
			locale_dir = _tmp56_;
			_g_object_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_tmp57_ = locale_dir;
			if (g_file_query_exists (_tmp57_, NULL)) {
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				GFile* _tmp62_;
				GFile* _tmp63_;
				GFile* _tmp64_;
				_tmp58_ = gnome_pie_paths_get_executable ();
				_tmp59_ = _tmp58_;
				_tmp60_ = g_path_get_dirname (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_file_new_for_path (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = g_file_get_child (_tmp63_, "resources/locale");
				_g_object_unref0 (locale_dir);
				locale_dir = _tmp64_;
				_g_object_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	}
	_tmp65_ = locale_dir;
	_tmp66_ = g_file_get_path (_tmp65_);
	_tmp67_ = _tmp66_;
	gnome_pie_paths_set_locales (_tmp67_);
	_g_free0 (_tmp67_);
	_tmp68_ = g_get_user_config_dir ();
	_tmp69_ = g_file_new_for_path (_tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = g_file_get_child (_tmp70_, "gnome-pie");
	_tmp72_ = _tmp71_;
	_g_object_unref0 (_tmp70_);
	config_dir = _tmp72_;
	_tmp73_ = config_dir;
	if (!g_file_query_exists (_tmp73_, NULL)) {
		{
			GFile* _tmp74_;
			_tmp74_ = config_dir;
			g_file_make_directory (_tmp74_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp75_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp75_ = e->message;
			g_error ("paths.vala:198: %s", _tmp75_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config_dir);
			_g_object_unref0 (locale_dir);
			_g_object_unref0 (default_dir);
			_g_object_unref0 (icon_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp76_ = config_dir;
	_tmp77_ = g_file_get_path (_tmp76_);
	_tmp78_ = _tmp77_;
	gnome_pie_paths_set_config_directory (_tmp78_);
	_g_free0 (_tmp78_);
	_tmp79_ = config_dir;
	_tmp80_ = g_file_get_child (_tmp79_, "themes");
	themes_dir = _tmp80_;
	_tmp81_ = themes_dir;
	if (!g_file_query_exists (_tmp81_, NULL)) {
		{
			GFile* _tmp82_;
			_tmp82_ = themes_dir;
			g_file_make_directory (_tmp82_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp83_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp83_ = e->message;
			g_error ("paths.vala:210: %s", _tmp83_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (themes_dir);
			_g_object_unref0 (config_dir);
			_g_object_unref0 (locale_dir);
			_g_object_unref0 (default_dir);
			_g_object_unref0 (icon_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp84_ = themes_dir;
	_tmp85_ = g_file_get_path (_tmp84_);
	_tmp86_ = _tmp85_;
	gnome_pie_paths_set_local_themes (_tmp86_);
	_g_free0 (_tmp86_);
	_tmp87_ = config_dir;
	_tmp88_ = g_file_get_child (_tmp87_, "launchers");
	launchers_dir = _tmp88_;
	_tmp89_ = launchers_dir;
	if (!g_file_query_exists (_tmp89_, NULL)) {
		{
			GFile* _tmp90_;
			_tmp90_ = launchers_dir;
			g_file_make_directory (_tmp90_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp91_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp91_ = e->message;
			g_error ("paths.vala:222: %s", _tmp91_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (launchers_dir);
			_g_object_unref0 (themes_dir);
			_g_object_unref0 (config_dir);
			_g_object_unref0 (locale_dir);
			_g_object_unref0 (default_dir);
			_g_object_unref0 (icon_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp92_ = launchers_dir;
	_tmp93_ = g_file_get_path (_tmp92_);
	_tmp94_ = _tmp93_;
	gnome_pie_paths_set_launchers (_tmp94_);
	_g_free0 (_tmp94_);
	_tmp95_ = config_dir;
	_tmp96_ = g_file_get_child (_tmp95_, "pies.conf");
	config_file = _tmp96_;
	_tmp97_ = config_file;
	_tmp98_ = g_file_get_path (_tmp97_);
	_tmp99_ = _tmp98_;
	gnome_pie_paths_set_pie_config (_tmp99_);
	_g_free0 (_tmp99_);
	_tmp100_ = config_dir;
	_tmp101_ = g_file_get_path (_tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = g_strconcat (_tmp102_, "/gnome-pie.conf", NULL);
	_tmp104_ = _tmp103_;
	gnome_pie_paths_set_settings (_tmp104_);
	_g_free0 (_tmp104_);
	_g_free0 (_tmp102_);
	_tmp105_ = config_dir;
	_tmp106_ = g_file_get_path (_tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = g_strconcat (_tmp107_, "/gnome-pie.log", NULL);
	_tmp109_ = _tmp108_;
	gnome_pie_paths_set_log (_tmp109_);
	_g_free0 (_tmp109_);
	_g_free0 (_tmp107_);
	_tmp110_ = gnome_pie_paths_get_log ();
	_tmp111_ = _tmp110_;
	_tmp112_ = g_file_new_for_path (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = !g_file_query_exists (_tmp113_, NULL);
	_g_object_unref0 (_tmp113_);
	if (_tmp114_) {
		{
			const gchar* _tmp115_;
			const gchar* _tmp116_;
			_tmp115_ = gnome_pie_paths_get_log ();
			_tmp116_ = _tmp115_;
			g_file_set_contents (_tmp116_, "", (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch4_g_file_error;
				}
				_g_object_unref0 (config_file);
				_g_object_unref0 (launchers_dir);
				_g_object_unref0 (themes_dir);
				_g_object_unref0 (config_dir);
				_g_object_unref0 (locale_dir);
				_g_object_unref0 (default_dir);
				_g_object_unref0 (icon_dir);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally4;
		__catch4_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp117_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp117_ = e->message;
			g_error ("paths.vala:239: %s", _tmp117_);
			_g_error_free0 (e);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config_file);
			_g_object_unref0 (launchers_dir);
			_g_object_unref0 (themes_dir);
			_g_object_unref0 (config_dir);
			_g_object_unref0 (locale_dir);
			_g_object_unref0 (default_dir);
			_g_object_unref0 (icon_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp118_ = g_get_user_config_dir ();
	_tmp119_ = g_build_filename (_tmp118_, "autostart", "gnome-pie.desktop", NULL, NULL);
	_tmp120_ = _tmp119_;
	gnome_pie_paths_set_autostart (_tmp120_);
	_g_free0 (_tmp120_);
	_tmp121_ = gnome_pie_paths_get_pie_config ();
	_tmp122_ = _tmp121_;
	_tmp123_ = g_file_new_for_path (_tmp122_);
	_tmp124_ = _tmp123_;
	_tmp125_ = !g_file_query_exists (_tmp124_, NULL);
	_g_object_unref0 (_tmp124_);
	if (_tmp125_) {
		g_warning ("paths.vala:249: Failed to find pie configuration file \"pies.conf\"! (" \
"This should only happen when Gnome-Pie is started for the first time.." \
".)");
	}
	_tmp126_ = gnome_pie_paths_get_settings ();
	_tmp127_ = _tmp126_;
	_tmp128_ = g_file_new_for_path (_tmp127_);
	_tmp129_ = _tmp128_;
	_tmp130_ = !g_file_query_exists (_tmp129_, NULL);
	_g_object_unref0 (_tmp129_);
	if (_tmp130_) {
		g_warning ("paths.vala:252: Failed to find settings file \"gnome-pie.conf\"! (This" \
" should only happen when Gnome-Pie is started for the first time...)");
	}
	_tmp131_ = gnome_pie_paths_get_log ();
	_tmp132_ = _tmp131_;
	_tmp133_ = g_file_new_for_path (_tmp132_);
	_tmp134_ = _tmp133_;
	_tmp135_ = !g_file_query_exists (_tmp134_, NULL);
	_g_object_unref0 (_tmp134_);
	if (_tmp135_) {
		g_warning ("paths.vala:255: Failed to find log file \"gnome-pie.log\"!");
	}
	_tmp136_ = gnome_pie_paths_get_local_themes ();
	_tmp137_ = _tmp136_;
	_tmp138_ = g_file_new_for_path (_tmp137_);
	_tmp139_ = _tmp138_;
	_tmp140_ = !g_file_query_exists (_tmp139_, NULL);
	_g_object_unref0 (_tmp139_);
	if (_tmp140_) {
		g_warning ("paths.vala:258: Failed to find local themes directory!");
	}
	_tmp141_ = gnome_pie_paths_get_launchers ();
	_tmp142_ = _tmp141_;
	_tmp143_ = g_file_new_for_path (_tmp142_);
	_tmp144_ = _tmp143_;
	_tmp145_ = !g_file_query_exists (_tmp144_, NULL);
	_g_object_unref0 (_tmp144_);
	if (_tmp145_) {
		g_warning ("paths.vala:261: Failed to find launchers directory!");
	}
	_tmp146_ = gnome_pie_paths_get_global_themes ();
	_tmp147_ = _tmp146_;
	_tmp148_ = g_file_new_for_path (_tmp147_);
	_tmp149_ = _tmp148_;
	_tmp150_ = !g_file_query_exists (_tmp149_, NULL);
	_g_object_unref0 (_tmp149_);
	if (_tmp150_) {
		g_warning ("paths.vala:264: Failed to find global themes directory!");
	}
	_tmp151_ = gnome_pie_paths_get_ui_files ();
	_tmp152_ = _tmp151_;
	_tmp153_ = g_file_new_for_path (_tmp152_);
	_tmp154_ = _tmp153_;
	_tmp155_ = !g_file_query_exists (_tmp154_, NULL);
	_g_object_unref0 (_tmp154_);
	if (_tmp155_) {
		g_warning ("paths.vala:267: Failed to find UI files directory!");
	}
	_g_object_unref0 (config_file);
	_g_object_unref0 (launchers_dir);
	_g_object_unref0 (themes_dir);
	_g_object_unref0 (config_dir);
	_g_object_unref0 (locale_dir);
	_g_object_unref0 (default_dir);
	_g_object_unref0 (icon_dir);
}

GnomePiePaths*
gnome_pie_paths_construct (GType object_type)
{
	GnomePiePaths * self = NULL;
	self = (GnomePiePaths*) g_object_new (object_type, NULL);
	return self;
}

GnomePiePaths*
gnome_pie_paths_new (void)
{
	return gnome_pie_paths_construct (GNOME_PIE_TYPE_PATHS);
}

const gchar*
gnome_pie_paths_get_config_directory (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__config_directory;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_config_directory (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__config_directory);
	gnome_pie_paths__config_directory = _tmp0_;
}

const gchar*
gnome_pie_paths_get_log (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__log;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_log (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__log);
	gnome_pie_paths__log = _tmp0_;
}

const gchar*
gnome_pie_paths_get_settings (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__settings;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_settings (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__settings);
	gnome_pie_paths__settings = _tmp0_;
}

const gchar*
gnome_pie_paths_get_pie_config (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__pie_config;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_pie_config (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__pie_config);
	gnome_pie_paths__pie_config = _tmp0_;
}

const gchar*
gnome_pie_paths_get_local_themes (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__local_themes;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_local_themes (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__local_themes);
	gnome_pie_paths__local_themes = _tmp0_;
}

const gchar*
gnome_pie_paths_get_global_themes (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__global_themes;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_global_themes (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__global_themes);
	gnome_pie_paths__global_themes = _tmp0_;
}

const gchar*
gnome_pie_paths_get_locales (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__locales;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_locales (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__locales);
	gnome_pie_paths__locales = _tmp0_;
}

const gchar*
gnome_pie_paths_get_ui_files (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__ui_files;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_ui_files (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__ui_files);
	gnome_pie_paths__ui_files = _tmp0_;
}

const gchar*
gnome_pie_paths_get_autostart (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__autostart;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_autostart (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__autostart);
	gnome_pie_paths__autostart = _tmp0_;
}

const gchar*
gnome_pie_paths_get_launchers (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__launchers;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_launchers (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__launchers);
	gnome_pie_paths__launchers = _tmp0_;
}

const gchar*
gnome_pie_paths_get_executable (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = gnome_pie_paths__executable;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_paths_set_executable (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (gnome_pie_paths__executable);
	gnome_pie_paths__executable = _tmp0_;
}

static void
gnome_pie_paths_class_init (GnomePiePathsClass * klass,
                            gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gnome_pie_paths_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gnome_pie_paths_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gnome_pie_paths_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_pie_paths_finalize;
	_tmp0_ = g_strdup ("");
	gnome_pie_paths__config_directory = _tmp0_;
	_tmp1_ = g_strdup ("");
	gnome_pie_paths__log = _tmp1_;
	_tmp2_ = g_strdup ("");
	gnome_pie_paths__settings = _tmp2_;
	_tmp3_ = g_strdup ("");
	gnome_pie_paths__pie_config = _tmp3_;
	_tmp4_ = g_strdup ("");
	gnome_pie_paths__local_themes = _tmp4_;
	_tmp5_ = g_strdup ("");
	gnome_pie_paths__global_themes = _tmp5_;
	_tmp6_ = g_strdup ("");
	gnome_pie_paths__locales = _tmp6_;
	_tmp7_ = g_strdup ("");
	gnome_pie_paths__ui_files = _tmp7_;
	_tmp8_ = g_strdup ("");
	gnome_pie_paths__autostart = _tmp8_;
	_tmp9_ = g_strdup ("");
	gnome_pie_paths__launchers = _tmp9_;
	_tmp10_ = g_strdup ("");
	gnome_pie_paths__executable = _tmp10_;
}

static void
gnome_pie_paths_instance_init (GnomePiePaths * self,
                               gpointer klass)
{
}

static void
gnome_pie_paths_finalize (GObject * obj)
{
	GnomePiePaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_PATHS, GnomePiePaths);
	G_OBJECT_CLASS (gnome_pie_paths_parent_class)->finalize (obj);
}

static GType
gnome_pie_paths_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePiePathsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_paths_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePiePaths), 0, (GInstanceInitFunc) gnome_pie_paths_instance_init, NULL };
	GType gnome_pie_paths_type_id;
	gnome_pie_paths_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomePiePaths", &g_define_type_info, 0);
	return gnome_pie_paths_type_id;
}

GType
gnome_pie_paths_get_type (void)
{
	static volatile gsize gnome_pie_paths_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_paths_type_id__once)) {
		GType gnome_pie_paths_type_id;
		gnome_pie_paths_type_id = gnome_pie_paths_get_type_once ();
		g_once_init_leave (&gnome_pie_paths_type_id__once, gnome_pie_paths_type_id);
	}
	return gnome_pie_paths_type_id__once;
}

static void
_vala_gnome_pie_paths_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GnomePiePaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_PATHS, GnomePiePaths);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gnome_pie_paths_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GnomePiePaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_PATHS, GnomePiePaths);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

