/* theme.c generated by valac 0.56.18, the Vala compiler
 * generated from theme.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gio/gio.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_THEME (gnome_pie_theme_get_type ())
#define GNOME_PIE_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_THEME, GnomePieTheme))
#define GNOME_PIE_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_THEME, GnomePieThemeClass))
#define GNOME_PIE_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_THEME))
#define GNOME_PIE_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_THEME))
#define GNOME_PIE_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_THEME, GnomePieThemeClass))

typedef struct _GnomePieTheme GnomePieTheme;
typedef struct _GnomePieThemeClass GnomePieThemeClass;
typedef struct _GnomePieThemePrivate GnomePieThemePrivate;

#define GNOME_PIE_TYPE_COLOR (gnome_pie_color_get_type ())
#define GNOME_PIE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_COLOR, GnomePieColor))
#define GNOME_PIE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_COLOR, GnomePieColorClass))
#define GNOME_PIE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_COLOR))
#define GNOME_PIE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_COLOR))
#define GNOME_PIE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_COLOR, GnomePieColorClass))

typedef struct _GnomePieColor GnomePieColor;
typedef struct _GnomePieColorClass GnomePieColorClass;

#define GNOME_PIE_TYPE_IMAGE (gnome_pie_image_get_type ())
#define GNOME_PIE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_IMAGE, GnomePieImage))
#define GNOME_PIE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_IMAGE, GnomePieImageClass))
#define GNOME_PIE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_IMAGE))
#define GNOME_PIE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_IMAGE))
#define GNOME_PIE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_IMAGE, GnomePieImageClass))

typedef struct _GnomePieImage GnomePieImage;
typedef struct _GnomePieImageClass GnomePieImageClass;

#define GNOME_PIE_TYPE_ICON (gnome_pie_icon_get_type ())
#define GNOME_PIE_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_ICON, GnomePieIcon))
#define GNOME_PIE_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_ICON, GnomePieIconClass))
#define GNOME_PIE_IS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_ICON))
#define GNOME_PIE_IS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_ICON))
#define GNOME_PIE_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_ICON, GnomePieIconClass))

typedef struct _GnomePieIcon GnomePieIcon;
typedef struct _GnomePieIconClass GnomePieIconClass;

#define GNOME_PIE_TYPE_CENTER_LAYER (gnome_pie_center_layer_get_type ())
#define GNOME_PIE_CENTER_LAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_CENTER_LAYER, GnomePieCenterLayer))
#define GNOME_PIE_CENTER_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_CENTER_LAYER, GnomePieCenterLayerClass))
#define GNOME_PIE_IS_CENTER_LAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_CENTER_LAYER))
#define GNOME_PIE_IS_CENTER_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_CENTER_LAYER))
#define GNOME_PIE_CENTER_LAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_CENTER_LAYER, GnomePieCenterLayerClass))

typedef struct _GnomePieCenterLayer GnomePieCenterLayer;
typedef struct _GnomePieCenterLayerClass GnomePieCenterLayerClass;

#define GNOME_PIE_TYPE_SLICE_LAYER (gnome_pie_slice_layer_get_type ())
#define GNOME_PIE_SLICE_LAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_SLICE_LAYER, GnomePieSliceLayer))
#define GNOME_PIE_SLICE_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_SLICE_LAYER, GnomePieSliceLayerClass))
#define GNOME_PIE_IS_SLICE_LAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_SLICE_LAYER))
#define GNOME_PIE_IS_SLICE_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_SLICE_LAYER))
#define GNOME_PIE_SLICE_LAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_SLICE_LAYER, GnomePieSliceLayerClass))

typedef struct _GnomePieSliceLayer GnomePieSliceLayer;
typedef struct _GnomePieSliceLayerClass GnomePieSliceLayerClass;
enum  {
	GNOME_PIE_THEME_0_PROPERTY,
	GNOME_PIE_THEME_DIRECTORY_PROPERTY,
	GNOME_PIE_THEME_NAME_PROPERTY,
	GNOME_PIE_THEME_DESCRIPTION_PROPERTY,
	GNOME_PIE_THEME_AUTHOR_PROPERTY,
	GNOME_PIE_THEME_EMAIL_PROPERTY,
	GNOME_PIE_THEME_RADIUS_PROPERTY,
	GNOME_PIE_THEME_MAX_ZOOM_PROPERTY,
	GNOME_PIE_THEME_ZOOM_RANGE_PROPERTY,
	GNOME_PIE_THEME_TRANSITION_TIME_PROPERTY,
	GNOME_PIE_THEME_WOBBLE_PROPERTY,
	GNOME_PIE_THEME_FADE_IN_TIME_PROPERTY,
	GNOME_PIE_THEME_FADE_OUT_TIME_PROPERTY,
	GNOME_PIE_THEME_FADE_IN_ZOOM_PROPERTY,
	GNOME_PIE_THEME_FADE_OUT_ZOOM_PROPERTY,
	GNOME_PIE_THEME_FADE_IN_ROTATION_PROPERTY,
	GNOME_PIE_THEME_FADE_OUT_ROTATION_PROPERTY,
	GNOME_PIE_THEME_SPRINGINESS_PROPERTY,
	GNOME_PIE_THEME_CENTER_RADIUS_PROPERTY,
	GNOME_PIE_THEME_ACTIVE_RADIUS_PROPERTY,
	GNOME_PIE_THEME_SLICE_RADIUS_PROPERTY,
	GNOME_PIE_THEME_VISIBLE_SLICE_RADIUS_PROPERTY,
	GNOME_PIE_THEME_SLICE_GAP_PROPERTY,
	GNOME_PIE_THEME_HAS_SLICE_CAPTIONS_PROPERTY,
	GNOME_PIE_THEME_CAPTION_PROPERTY,
	GNOME_PIE_THEME_CAPTION_FONT_PROPERTY,
	GNOME_PIE_THEME_CAPTION_WIDTH_PROPERTY,
	GNOME_PIE_THEME_CAPTION_HEIGHT_PROPERTY,
	GNOME_PIE_THEME_CAPTION_POSITION_PROPERTY,
	GNOME_PIE_THEME_CAPTION_COLOR_PROPERTY,
	GNOME_PIE_THEME_PREVIEW_ICON_PROPERTY,
	GNOME_PIE_THEME_CENTER_LAYERS_PROPERTY,
	GNOME_PIE_THEME_ACTIVE_SLICE_LAYERS_PROPERTY,
	GNOME_PIE_THEME_INACTIVE_SLICE_LAYERS_PROPERTY,
	GNOME_PIE_THEME_NUM_PROPERTIES
};
static GParamSpec* gnome_pie_theme_properties[GNOME_PIE_THEME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))

#define GNOME_PIE_TYPE_ARCHIVE_WRITER (gnome_pie_archive_writer_get_type ())
#define GNOME_PIE_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_ARCHIVE_WRITER, GnomePieArchiveWriter))
#define GNOME_PIE_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_ARCHIVE_WRITER, GnomePieArchiveWriterClass))
#define GNOME_PIE_IS_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_ARCHIVE_WRITER))
#define GNOME_PIE_IS_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_ARCHIVE_WRITER))
#define GNOME_PIE_ARCHIVE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_ARCHIVE_WRITER, GnomePieArchiveWriterClass))

typedef struct _GnomePieArchiveWriter GnomePieArchiveWriter;
typedef struct _GnomePieArchiveWriterClass GnomePieArchiveWriterClass;

#define GNOME_PIE_TYPE_CONFIG (gnome_pie_config_get_type ())
#define GNOME_PIE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_CONFIG, GnomePieConfig))
#define GNOME_PIE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_CONFIG, GnomePieConfigClass))
#define GNOME_PIE_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_CONFIG))
#define GNOME_PIE_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_CONFIG))
#define GNOME_PIE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_CONFIG, GnomePieConfigClass))

typedef struct _GnomePieConfig GnomePieConfig;
typedef struct _GnomePieConfigClass GnomePieConfigClass;
typedef enum  {
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_AUTO,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MOUSE,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_ACTIVE,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_12,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_24,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MINUTE,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_SECOND
} GnomePieCenterLayerRotationMode;

#define GNOME_PIE_CENTER_LAYER_TYPE_ROTATION_MODE (gnome_pie_center_layer_rotation_mode_get_type ())
typedef enum  {
	GNOME_PIE_SLICE_LAYER_TYPE_FILE,
	GNOME_PIE_SLICE_LAYER_TYPE_ICON,
	GNOME_PIE_SLICE_LAYER_TYPE_CAPTION
} GnomePieSliceLayerType;

#define GNOME_PIE_SLICE_LAYER_TYPE_TYPE (gnome_pie_slice_layer_type_get_type ())
typedef enum  {
	GNOME_PIE_SLICE_LAYER_VISIBILITY_ANY,
	GNOME_PIE_SLICE_LAYER_VISIBILITY_WITH_CAPTION,
	GNOME_PIE_SLICE_LAYER_VISIBILITY_WITHOUT_CAPTION
} GnomePieSliceLayerVisibility;

#define GNOME_PIE_SLICE_LAYER_TYPE_VISIBILITY (gnome_pie_slice_layer_visibility_get_type ())

struct _GnomePieTheme {
	GObject parent_instance;
	GnomePieThemePrivate * priv;
};

struct _GnomePieThemeClass {
	GObjectClass parent_class;
};

struct _GnomePieThemePrivate {
	gchar* _directory;
	gchar* _name;
	gchar* _description;
	gchar* _author;
	gchar* _email;
	gdouble _radius;
	gdouble _max_zoom;
	gdouble _zoom_range;
	gdouble _transition_time;
	gdouble _wobble;
	gdouble _fade_in_time;
	gdouble _fade_out_time;
	gdouble _fade_in_zoom;
	gdouble _fade_out_zoom;
	gdouble _fade_in_rotation;
	gdouble _fade_out_rotation;
	gdouble _springiness;
	gdouble _center_radius;
	gdouble _active_radius;
	gdouble _slice_radius;
	gdouble _visible_slice_radius;
	gdouble _slice_gap;
	gboolean _has_slice_captions;
	gboolean _caption;
	gchar* _caption_font;
	gint _caption_width;
	gint _caption_height;
	gdouble _caption_position;
	GnomePieColor* _caption_color;
	GnomePieIcon* _preview_icon;
	GeeArrayList* _center_layers;
	GeeArrayList* _active_slice_layers;
	GeeArrayList* _inactive_slice_layers;
};

static gint GnomePieTheme_private_offset;
static gpointer gnome_pie_theme_parent_class = NULL;

VALA_EXTERN GType gnome_pie_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieTheme, g_object_unref)
VALA_EXTERN GType gnome_pie_color_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieColor, g_object_unref)
VALA_EXTERN GType gnome_pie_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieImage, g_object_unref)
VALA_EXTERN GType gnome_pie_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieIcon, g_object_unref)
VALA_EXTERN GType gnome_pie_center_layer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieCenterLayer, g_object_unref)
VALA_EXTERN GType gnome_pie_slice_layer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieSliceLayer, g_object_unref)
VALA_EXTERN GnomePieColor* gnome_pie_color_new (void);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct (GType object_type);
VALA_EXTERN GnomePieIcon* gnome_pie_icon_new (const gchar* icon_name,
                                  gint size);
VALA_EXTERN GnomePieIcon* gnome_pie_icon_construct (GType object_type,
                                        const gchar* icon_name,
                                        gint size);
VALA_EXTERN GnomePieTheme* gnome_pie_theme_new (const gchar* dir);
VALA_EXTERN GnomePieTheme* gnome_pie_theme_construct (GType object_type,
                                          const gchar* dir);
static void gnome_pie_theme_set_center_layers (GnomePieTheme* self,
                                        GeeArrayList* value);
static void gnome_pie_theme_set_active_slice_layers (GnomePieTheme* self,
                                              GeeArrayList* value);
static void gnome_pie_theme_set_inactive_slice_layers (GnomePieTheme* self,
                                                GeeArrayList* value);
static void gnome_pie_theme_set_directory (GnomePieTheme* self,
                                    const gchar* value);
VALA_EXTERN gboolean gnome_pie_theme_load (GnomePieTheme* self);
VALA_EXTERN GeeArrayList* gnome_pie_theme_get_center_layers (GnomePieTheme* self);
VALA_EXTERN GeeArrayList* gnome_pie_theme_get_active_slice_layers (GnomePieTheme* self);
VALA_EXTERN GeeArrayList* gnome_pie_theme_get_inactive_slice_layers (GnomePieTheme* self);
VALA_EXTERN const gchar* gnome_pie_theme_get_directory (GnomePieTheme* self);
static void gnome_pie_theme_set_preview_icon (GnomePieTheme* self,
                                       GnomePieIcon* value);
static void gnome_pie_theme_parse_root (GnomePieTheme* self,
                                 xmlNode* root);
VALA_EXTERN gdouble gnome_pie_theme_get_radius (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_max_zoom (GnomePieTheme* self);
static void gnome_pie_theme_set_radius (GnomePieTheme* self,
                                 gdouble value);
VALA_EXTERN void gnome_pie_theme_export (GnomePieTheme* self,
                             const gchar* file);
VALA_EXTERN GType gnome_pie_archive_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieArchiveWriter, g_object_unref)
VALA_EXTERN GnomePieArchiveWriter* gnome_pie_archive_writer_new (void);
VALA_EXTERN GnomePieArchiveWriter* gnome_pie_archive_writer_construct (GType object_type);
VALA_EXTERN gboolean gnome_pie_archive_writer_open (GnomePieArchiveWriter* self,
                                        const gchar* path);
VALA_EXTERN gboolean gnome_pie_archive_writer_add (GnomePieArchiveWriter* self,
                                       const gchar* directory);
VALA_EXTERN void gnome_pie_archive_writer_close (GnomePieArchiveWriter* self);
VALA_EXTERN const gchar* gnome_pie_theme_get_name (GnomePieTheme* self);
VALA_EXTERN void gnome_pie_theme_load_images (GnomePieTheme* self);
VALA_EXTERN void gnome_pie_center_layer_load_image (GnomePieCenterLayer* self);
VALA_EXTERN void gnome_pie_slice_layer_load_image (GnomePieSliceLayer* self);
VALA_EXTERN gboolean gnome_pie_theme_is_local (GnomePieTheme* self);
VALA_EXTERN const gchar* gnome_pie_paths_get_local_themes (void);
static void gnome_pie_theme_set_name (GnomePieTheme* self,
                               const gchar* value);
static void gnome_pie_theme_set_description (GnomePieTheme* self,
                                      const gchar* value);
static void gnome_pie_theme_set_email (GnomePieTheme* self,
                                const gchar* value);
static void gnome_pie_theme_set_author (GnomePieTheme* self,
                                 const gchar* value);
static void gnome_pie_theme_parse_pie (GnomePieTheme* self,
                                xmlNode* pie);
VALA_EXTERN GType gnome_pie_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieConfig, g_object_unref)
VALA_EXTERN GnomePieConfig* gnome_pie_config_get_global (void);
VALA_EXTERN gdouble gnome_pie_config_get_global_scale (GnomePieConfig* self);
static void gnome_pie_theme_set_max_zoom (GnomePieTheme* self,
                                   gdouble value);
static void gnome_pie_theme_set_zoom_range (GnomePieTheme* self,
                                     gdouble value);
static void gnome_pie_theme_set_transition_time (GnomePieTheme* self,
                                          gdouble value);
static void gnome_pie_theme_set_wobble (GnomePieTheme* self,
                                 gdouble value);
static void gnome_pie_theme_set_fade_in_time (GnomePieTheme* self,
                                       gdouble value);
static void gnome_pie_theme_set_fade_out_time (GnomePieTheme* self,
                                        gdouble value);
static void gnome_pie_theme_set_fade_in_zoom (GnomePieTheme* self,
                                       gdouble value);
static void gnome_pie_theme_set_fade_out_zoom (GnomePieTheme* self,
                                        gdouble value);
static void gnome_pie_theme_set_fade_in_rotation (GnomePieTheme* self,
                                           gdouble value);
static void gnome_pie_theme_set_fade_out_rotation (GnomePieTheme* self,
                                            gdouble value);
static void gnome_pie_theme_set_springiness (GnomePieTheme* self,
                                      gdouble value);
static void gnome_pie_theme_parse_center (GnomePieTheme* self,
                                   xmlNode* center);
static void gnome_pie_theme_parse_slices (GnomePieTheme* self,
                                   xmlNode* slices);
static void gnome_pie_theme_set_caption (GnomePieTheme* self,
                                  gboolean value);
static void gnome_pie_theme_parse_caption (GnomePieTheme* self,
                                    xmlNode* caption);
static void gnome_pie_theme_set_center_radius (GnomePieTheme* self,
                                        gdouble value);
static void gnome_pie_theme_set_active_radius (GnomePieTheme* self,
                                        gdouble value);
static void gnome_pie_theme_parse_center_layer (GnomePieTheme* self,
                                         xmlNode* layer);
static void gnome_pie_theme_set_slice_radius (GnomePieTheme* self,
                                       gdouble value);
static void gnome_pie_theme_set_visible_slice_radius (GnomePieTheme* self,
                                               gdouble value);
static void gnome_pie_theme_set_slice_gap (GnomePieTheme* self,
                                    gdouble value);
static void gnome_pie_theme_parse_slice_layers (GnomePieTheme* self,
                                         xmlNode* slice);
VALA_EXTERN GType gnome_pie_center_layer_rotation_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gdouble gnome_pie_theme_get_center_radius (GnomePieTheme* self);
VALA_EXTERN GnomePieCenterLayer* gnome_pie_center_layer_new (const gchar* image_file,
                                                 gint center_radius,
                                                 gdouble active_scale,
                                                 gdouble active_rotation_speed,
                                                 gdouble active_alpha,
                                                 gboolean active_colorize,
                                                 GnomePieCenterLayerRotationMode active_rotation_mode,
                                                 gdouble inactive_scale,
                                                 gdouble inactive_rotation_speed,
                                                 gdouble inactive_alpha,
                                                 gboolean inactive_colorize,
                                                 GnomePieCenterLayerRotationMode inactive_rotation_mode);
VALA_EXTERN GnomePieCenterLayer* gnome_pie_center_layer_construct (GType object_type,
                                                       const gchar* image_file,
                                                       gint center_radius,
                                                       gdouble active_scale,
                                                       gdouble active_rotation_speed,
                                                       gdouble active_alpha,
                                                       gboolean active_colorize,
                                                       GnomePieCenterLayerRotationMode active_rotation_mode,
                                                       gdouble inactive_scale,
                                                       gdouble inactive_rotation_speed,
                                                       gdouble inactive_alpha,
                                                       gboolean inactive_colorize,
                                                       GnomePieCenterLayerRotationMode inactive_rotation_mode);
VALA_EXTERN GType gnome_pie_slice_layer_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gnome_pie_slice_layer_visibility_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GnomePieColor* gnome_pie_color_new_from_rgb (gfloat red,
                                             gfloat green,
                                             gfloat blue);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct_from_rgb (GType object_type,
                                                   gfloat red,
                                                   gfloat green,
                                                   gfloat blue);
VALA_EXTERN GnomePieColor* gnome_pie_color_new_from_string (const gchar* hex_string);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct_from_string (GType object_type,
                                                      const gchar* hex_string);
static void gnome_pie_theme_set_has_slice_captions (GnomePieTheme* self,
                                             gboolean value);
VALA_EXTERN gdouble gnome_pie_theme_get_slice_radius (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_visible_slice_radius (GnomePieTheme* self);
VALA_EXTERN GnomePieSliceLayer* gnome_pie_slice_layer_new_icon (const gchar* icon_file,
                                                    gint icon_size,
                                                    gint x,
                                                    gint y,
                                                    gboolean colorize,
                                                    GnomePieSliceLayerVisibility visibility);
VALA_EXTERN GnomePieSliceLayer* gnome_pie_slice_layer_construct_icon (GType object_type,
                                                          const gchar* icon_file,
                                                          gint icon_size,
                                                          gint x,
                                                          gint y,
                                                          gboolean colorize,
                                                          GnomePieSliceLayerVisibility visibility);
VALA_EXTERN GnomePieSliceLayer* gnome_pie_slice_layer_new_caption (const gchar* font,
                                                       gint width,
                                                       gint height,
                                                       gint x,
                                                       gint y,
                                                       GnomePieColor* color,
                                                       gboolean colorize,
                                                       GnomePieSliceLayerVisibility visibility);
VALA_EXTERN GnomePieSliceLayer* gnome_pie_slice_layer_construct_caption (GType object_type,
                                                             const gchar* font,
                                                             gint width,
                                                             gint height,
                                                             gint x,
                                                             gint y,
                                                             GnomePieColor* color,
                                                             gboolean colorize,
                                                             GnomePieSliceLayerVisibility visibility);
VALA_EXTERN GnomePieSliceLayer* gnome_pie_slice_layer_new_file (const gchar* icon_file,
                                                    gint icon_size,
                                                    gint x,
                                                    gint y,
                                                    gboolean colorize,
                                                    GnomePieSliceLayerVisibility visibility);
VALA_EXTERN GnomePieSliceLayer* gnome_pie_slice_layer_construct_file (GType object_type,
                                                          const gchar* icon_file,
                                                          gint icon_size,
                                                          gint x,
                                                          gint y,
                                                          gboolean colorize,
                                                          GnomePieSliceLayerVisibility visibility);
static void gnome_pie_theme_set_caption_font (GnomePieTheme* self,
                                       const gchar* value);
static void gnome_pie_theme_set_caption_width (GnomePieTheme* self,
                                        gint value);
VALA_EXTERN gint gnome_pie_theme_get_caption_width (GnomePieTheme* self);
static void gnome_pie_theme_set_caption_height (GnomePieTheme* self,
                                         gint value);
VALA_EXTERN gint gnome_pie_theme_get_caption_height (GnomePieTheme* self);
static void gnome_pie_theme_set_caption_position (GnomePieTheme* self,
                                           gdouble value);
static void gnome_pie_theme_set_caption_color (GnomePieTheme* self,
                                        GnomePieColor* value);
VALA_EXTERN const gchar* gnome_pie_theme_get_description (GnomePieTheme* self);
VALA_EXTERN const gchar* gnome_pie_theme_get_author (GnomePieTheme* self);
VALA_EXTERN const gchar* gnome_pie_theme_get_email (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_zoom_range (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_transition_time (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_wobble (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_fade_in_time (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_fade_out_time (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_fade_in_zoom (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_fade_out_zoom (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_fade_in_rotation (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_fade_out_rotation (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_springiness (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_active_radius (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_slice_gap (GnomePieTheme* self);
VALA_EXTERN gboolean gnome_pie_theme_get_has_slice_captions (GnomePieTheme* self);
VALA_EXTERN gboolean gnome_pie_theme_get_caption (GnomePieTheme* self);
VALA_EXTERN const gchar* gnome_pie_theme_get_caption_font (GnomePieTheme* self);
VALA_EXTERN gdouble gnome_pie_theme_get_caption_position (GnomePieTheme* self);
VALA_EXTERN GnomePieColor* gnome_pie_theme_get_caption_color (GnomePieTheme* self);
VALA_EXTERN GnomePieIcon* gnome_pie_theme_get_preview_icon (GnomePieTheme* self);
static void gnome_pie_theme_finalize (GObject * obj);
static GType gnome_pie_theme_get_type_once (void);
static void _vala_gnome_pie_theme_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gnome_pie_theme_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
gnome_pie_theme_get_instance_private (GnomePieTheme* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePieTheme_private_offset);
}

GnomePieTheme*
gnome_pie_theme_construct (GType object_type,
                           const gchar* dir)
{
	GnomePieTheme * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_val_if_fail (dir != NULL, NULL);
	self = (GnomePieTheme*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (GNOME_PIE_TYPE_CENTER_LAYER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	gnome_pie_theme_set_center_layers (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gee_array_list_new (GNOME_PIE_TYPE_SLICE_LAYER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	gnome_pie_theme_set_active_slice_layers (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = gee_array_list_new (GNOME_PIE_TYPE_SLICE_LAYER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	gnome_pie_theme_set_inactive_slice_layers (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	gnome_pie_theme_set_directory (self, dir);
	return self;
}

GnomePieTheme*
gnome_pie_theme_new (const gchar* dir)
{
	return gnome_pie_theme_construct (GNOME_PIE_TYPE_THEME, dir);
}

gboolean
gnome_pie_theme_load (GnomePieTheme* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_;
	gchar* config_file = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GnomePieIcon* _tmp43_;
	GnomePieIcon* _tmp44_;
	xmlDoc* themeXML = NULL;
	const gchar* _tmp45_;
	xmlDoc* _tmp46_;
	xmlDoc* _tmp47_;
	xmlNode* root = NULL;
	xmlDoc* _tmp53_;
	xmlNode* _tmp54_;
	xmlNode* _tmp55_;
	xmlNode* _tmp57_;
	xmlDoc* _tmp58_;
	gdouble _tmp59_;
	gdouble _tmp60_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_center_layers;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->_active_slice_layers;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = self->priv->_inactive_slice_layers;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	_tmp3_ = self->priv->_directory;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = !g_file_query_exists (_tmp5_, NULL);
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = self->priv->_directory;
	_tmp8_ = g_strconcat (_tmp7_, "/theme.xml", NULL);
	config_file = _tmp8_;
	_tmp9_ = config_file;
	_tmp10_ = g_file_new_for_path (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = !g_file_query_exists (_tmp11_, NULL);
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		{
			gchar* child = NULL;
			gboolean success = FALSE;
			GDir* d = NULL;
			const gchar* _tmp13_;
			GDir* _tmp14_;
			success = FALSE;
			_tmp13_ = self->priv->_directory;
			_tmp14_ = g_dir_open (_tmp13_, (guint) 0, &_inner_error0_);
			d = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (child);
				goto __catch0_g_error;
			}
			while (TRUE) {
				gboolean _tmp15_ = FALSE;
				GDir* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				GFile* _tmp28_;
				GFile* _tmp29_;
				gboolean _tmp30_;
				_tmp16_ = d;
				_tmp17_ = g_dir_read_name (_tmp16_);
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (child);
				child = _tmp18_;
				_tmp19_ = child;
				if (_tmp19_ != NULL) {
					_tmp15_ = !success;
				} else {
					_tmp15_ = FALSE;
				}
				if (!_tmp15_) {
					break;
				}
				_tmp20_ = self->priv->_directory;
				_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
				_tmp22_ = _tmp21_;
				_tmp23_ = child;
				_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp25_, "/theme.xml", NULL);
				_g_free0 (config_file);
				config_file = _tmp26_;
				_g_free0 (_tmp25_);
				_g_free0 (_tmp22_);
				_tmp27_ = config_file;
				_tmp28_ = g_file_new_for_path (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_file_query_exists (_tmp29_, NULL);
				_g_object_unref0 (_tmp29_);
				if (_tmp30_) {
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp31_ = self->priv->_directory;
					_tmp32_ = g_strconcat (_tmp31_, "/", NULL);
					_tmp33_ = _tmp32_;
					_tmp34_ = child;
					_tmp35_ = g_strconcat (_tmp33_, _tmp34_, NULL);
					_tmp36_ = _tmp35_;
					gnome_pie_theme_set_directory (self, _tmp36_);
					_g_free0 (_tmp36_);
					_g_free0 (_tmp33_);
					success = TRUE;
				}
			}
			if (!success) {
				result = FALSE;
				_g_dir_close0 (d);
				_g_free0 (child);
				_g_free0 (config_file);
				return result;
			}
			_g_dir_close0 (d);
			_g_free0 (child);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp37_;
			const gchar* _tmp38_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp37_ = e;
			_tmp38_ = _tmp37_->message;
			g_warning ("theme.vala:122: %s", _tmp38_);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (config_file);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp39_ = FALSE;
			_g_free0 (config_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp39_;
		}
	}
	_tmp40_ = self->priv->_directory;
	_tmp41_ = g_strconcat (_tmp40_, "/preview.png", NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = gnome_pie_icon_new (_tmp42_, 36);
	_tmp44_ = _tmp43_;
	gnome_pie_theme_set_preview_icon (self, _tmp44_);
	_g_object_unref0 (_tmp44_);
	_g_free0 (_tmp42_);
	xmlInitParser ();
	_tmp45_ = config_file;
	_tmp46_ = xmlParseFile (_tmp45_);
	themeXML = _tmp46_;
	_tmp47_ = themeXML;
	if (_tmp47_ == NULL) {
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp48_ = config_file;
		_tmp49_ = g_strconcat ("Failed to add theme: \"", _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat (_tmp50_, "\" not found!", NULL);
		_tmp52_ = _tmp51_;
		g_warning ("theme.vala:133: %s", _tmp52_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
		result = FALSE;
		_g_free0 (config_file);
		return result;
	}
	_tmp53_ = themeXML;
	_tmp54_ = xmlDocGetRootElement (_tmp53_);
	root = _tmp54_;
	_tmp55_ = root;
	if (_tmp55_ == NULL) {
		xmlDoc* _tmp56_;
		_tmp56_ = themeXML;
		_xmlFreeDoc0 (_tmp56_);
		g_warning ("theme.vala:140: Failed to add theme: \"theme.xml\" is empty!");
		result = FALSE;
		_g_free0 (config_file);
		return result;
	}
	_tmp57_ = root;
	gnome_pie_theme_parse_root (self, _tmp57_);
	_tmp58_ = themeXML;
	_xmlFreeDoc0 (_tmp58_);
	xmlCleanupParser ();
	_tmp59_ = self->priv->_radius;
	_tmp60_ = self->priv->_max_zoom;
	gnome_pie_theme_set_radius (self, _tmp59_ * _tmp60_);
	result = TRUE;
	_g_free0 (config_file);
	return result;
}

void
gnome_pie_theme_export (GnomePieTheme* self,
                        const gchar* file)
{
	GnomePieArchiveWriter* archive = NULL;
	GnomePieArchiveWriter* _tmp0_;
	gboolean success = FALSE;
	GnomePieArchiveWriter* _tmp1_;
	GnomePieArchiveWriter* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = gnome_pie_archive_writer_new ();
	archive = _tmp0_;
	success = TRUE;
	_tmp1_ = archive;
	if (!gnome_pie_archive_writer_open (_tmp1_, file)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = g_strconcat ("Cannot open file ", file, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, " for writing!", NULL);
		_tmp5_ = _tmp4_;
		g_warning ("theme.vala:165: %s", _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		success = FALSE;
	} else {
		GnomePieArchiveWriter* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = archive;
		_tmp7_ = self->priv->_directory;
		if (!gnome_pie_archive_writer_add (_tmp6_, _tmp7_)) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp8_ = self->priv->_directory;
			_tmp9_ = g_strconcat ("Cannot append directory ", _tmp8_, NULL);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat (_tmp10_, " to archive!", NULL);
			_tmp12_ = _tmp11_;
			g_warning ("theme.vala:168: %s", _tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
			success = FALSE;
		}
	}
	_tmp13_ = archive;
	gnome_pie_archive_writer_close (_tmp13_);
	if (success) {
		gchar* message = NULL;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		GtkMessageDialog* dialog = NULL;
		const gchar* _tmp16_;
		GtkMessageDialog* _tmp17_;
		GtkMessageDialog* _tmp18_;
		GtkMessageDialog* _tmp19_;
		_tmp14_ = self->priv->_name;
		_tmp15_ = g_strdup_printf (_ ("Successfully exported the theme \"%s\"!"), _tmp14_);
		message = _tmp15_;
		_tmp16_ = message;
		_tmp17_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, "%s", _tmp16_);
		g_object_ref_sink (_tmp17_);
		dialog = _tmp17_;
		_tmp18_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp18_);
		_tmp19_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp19_);
		_g_object_unref0 (dialog);
		_g_free0 (message);
	} else {
		gchar* message = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		GtkMessageDialog* dialog = NULL;
		const gchar* _tmp22_;
		GtkMessageDialog* _tmp23_;
		GtkMessageDialog* _tmp24_;
		GtkMessageDialog* _tmp25_;
		_tmp20_ = self->priv->_name;
		_tmp21_ = g_strdup_printf (_ ("An error occured while exporting the theme \"%s\"! Please check the co" \
"nsole output."), _tmp20_);
		message = _tmp21_;
		_tmp22_ = message;
		_tmp23_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp22_);
		g_object_ref_sink (_tmp23_);
		dialog = _tmp23_;
		_tmp24_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp24_);
		_tmp25_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp25_);
		_g_object_unref0 (dialog);
		_g_free0 (message);
	}
	_g_object_unref0 (archive);
}

void
gnome_pie_theme_load_images (GnomePieTheme* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _layer_list = NULL;
		GeeArrayList* _tmp0_;
		gint _layer_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _layer_index = 0;
		_tmp0_ = self->priv->_center_layers;
		_layer_list = _tmp0_;
		_tmp1_ = _layer_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_layer_size = _tmp3_;
		_layer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GnomePieCenterLayer* layer = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GnomePieCenterLayer* _tmp8_;
			_layer_index = _layer_index + 1;
			_tmp4_ = _layer_index;
			_tmp5_ = _layer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _layer_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _layer_index);
			layer = (GnomePieCenterLayer*) _tmp7_;
			_tmp8_ = layer;
			gnome_pie_center_layer_load_image (_tmp8_);
			_g_object_unref0 (layer);
		}
	}
	{
		GeeArrayList* _layer_list = NULL;
		GeeArrayList* _tmp9_;
		gint _layer_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _layer_index = 0;
		_tmp9_ = self->priv->_active_slice_layers;
		_layer_list = _tmp9_;
		_tmp10_ = _layer_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_layer_size = _tmp12_;
		_layer_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			GnomePieSliceLayer* layer = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			GnomePieSliceLayer* _tmp17_;
			_layer_index = _layer_index + 1;
			_tmp13_ = _layer_index;
			_tmp14_ = _layer_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _layer_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _layer_index);
			layer = (GnomePieSliceLayer*) _tmp16_;
			_tmp17_ = layer;
			gnome_pie_slice_layer_load_image (_tmp17_);
			_g_object_unref0 (layer);
		}
	}
	{
		GeeArrayList* _layer_list = NULL;
		GeeArrayList* _tmp18_;
		gint _layer_size = 0;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _layer_index = 0;
		_tmp18_ = self->priv->_inactive_slice_layers;
		_layer_list = _tmp18_;
		_tmp19_ = _layer_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_layer_size = _tmp21_;
		_layer_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			GnomePieSliceLayer* layer = NULL;
			GeeArrayList* _tmp24_;
			gpointer _tmp25_;
			GnomePieSliceLayer* _tmp26_;
			_layer_index = _layer_index + 1;
			_tmp22_ = _layer_index;
			_tmp23_ = _layer_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _layer_list;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _layer_index);
			layer = (GnomePieSliceLayer*) _tmp25_;
			_tmp26_ = layer;
			gnome_pie_slice_layer_load_image (_tmp26_);
			_g_object_unref0 (layer);
		}
	}
}

gboolean
gnome_pie_theme_is_local (GnomePieTheme* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_directory;
	_tmp1_ = gnome_pie_paths_get_local_themes ();
	_tmp2_ = _tmp1_;
	result = g_str_has_prefix (_tmp0_, _tmp2_);
	return result;
}

static void
gnome_pie_theme_parse_root (GnomePieTheme* self,
                            xmlNode* root)
{
	g_return_if_fail (self != NULL);
	{
		xmlAttr* attribute = NULL;
		xmlAttr* _tmp0_;
		_tmp0_ = root->properties;
		attribute = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp4_;
				gchar* attr_name = NULL;
				xmlAttr* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* attr_content = NULL;
				xmlAttr* _tmp8_;
				xmlNode* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GQuark _tmp15_ = 0U;
				static GQuark _tmp14_label0 = 0;
				static GQuark _tmp14_label1 = 0;
				static GQuark _tmp14_label2 = 0;
				static GQuark _tmp14_label3 = 0;
				if (!_tmp1_) {
					xmlAttr* _tmp2_;
					xmlAttr* _tmp3_;
					_tmp2_ = attribute;
					_tmp3_ = _tmp2_->next;
					attribute = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = attribute;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = attribute;
				_tmp6_ = _tmp5_->name;
				_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
				attr_name = _tmp7_;
				_tmp8_ = attribute;
				_tmp9_ = _tmp8_->children;
				_tmp10_ = _tmp9_->content;
				_tmp11_ = g_strdup (_tmp10_);
				attr_content = _tmp11_;
				_tmp12_ = attr_name;
				_tmp13_ = _tmp12_;
				_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
				if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("name")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp16_;
							_tmp16_ = attr_content;
							gnome_pie_theme_set_name (self, _tmp16_);
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("description")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp17_;
							_tmp17_ = attr_content;
							gnome_pie_theme_set_description (self, _tmp17_);
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label2) ? _tmp14_label2 : (_tmp14_label2 = g_quark_from_static_string ("email")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp18_;
							_tmp18_ = attr_content;
							gnome_pie_theme_set_email (self, _tmp18_);
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label3) ? _tmp14_label3 : (_tmp14_label3 = g_quark_from_static_string ("author")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp19_;
							_tmp19_ = attr_content;
							gnome_pie_theme_set_author (self, _tmp19_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							_tmp20_ = attr_name;
							_tmp21_ = g_strconcat ("Invalid attribute \"", _tmp20_, NULL);
							_tmp22_ = _tmp21_;
							_tmp23_ = g_strconcat (_tmp22_, "\" in <theme> element!", NULL);
							_tmp24_ = _tmp23_;
							g_warning ("theme.vala:237: %s", _tmp24_);
							_g_free0 (_tmp24_);
							_g_free0 (_tmp22_);
							break;
						}
					}
				}
				_g_free0 (attr_content);
				_g_free0 (attr_name);
			}
		}
	}
	{
		xmlNode* node = NULL;
		xmlNode* _tmp25_;
		_tmp25_ = root->children;
		node = _tmp25_;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp29_;
				xmlNode* _tmp30_;
				if (!_tmp26_) {
					xmlNode* _tmp27_;
					xmlNode* _tmp28_;
					_tmp27_ = node;
					_tmp28_ = _tmp27_->next;
					node = _tmp28_;
				}
				_tmp26_ = FALSE;
				_tmp29_ = node;
				if (!(_tmp29_ != NULL)) {
					break;
				}
				_tmp30_ = node;
				if (_tmp30_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp31_;
					_tmp31_ = node;
					gnome_pie_theme_parse_pie (self, _tmp31_);
				}
			}
		}
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
gnome_pie_theme_parse_pie (GnomePieTheme* self,
                           xmlNode* pie)
{
	g_return_if_fail (self != NULL);
	{
		xmlAttr* attribute = NULL;
		xmlAttr* _tmp0_;
		_tmp0_ = pie->properties;
		attribute = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp4_;
				gchar* attr_name = NULL;
				xmlAttr* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* attr_content = NULL;
				xmlAttr* _tmp8_;
				xmlNode* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GQuark _tmp15_ = 0U;
				static GQuark _tmp14_label0 = 0;
				static GQuark _tmp14_label1 = 0;
				static GQuark _tmp14_label2 = 0;
				static GQuark _tmp14_label3 = 0;
				static GQuark _tmp14_label4 = 0;
				static GQuark _tmp14_label5 = 0;
				static GQuark _tmp14_label6 = 0;
				static GQuark _tmp14_label7 = 0;
				static GQuark _tmp14_label8 = 0;
				static GQuark _tmp14_label9 = 0;
				static GQuark _tmp14_label10 = 0;
				static GQuark _tmp14_label11 = 0;
				if (!_tmp1_) {
					xmlAttr* _tmp2_;
					xmlAttr* _tmp3_;
					_tmp2_ = attribute;
					_tmp3_ = _tmp2_->next;
					attribute = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = attribute;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = attribute;
				_tmp6_ = _tmp5_->name;
				_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
				attr_name = _tmp7_;
				_tmp8_ = attribute;
				_tmp9_ = _tmp8_->children;
				_tmp10_ = _tmp9_->content;
				_tmp11_ = g_strdup (_tmp10_);
				attr_content = _tmp11_;
				_tmp12_ = attr_name;
				_tmp13_ = _tmp12_;
				_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
				if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("radius")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp16_;
							GnomePieConfig* _tmp17_;
							GnomePieConfig* _tmp18_;
							gdouble _tmp19_;
							gdouble _tmp20_;
							_tmp16_ = attr_content;
							_tmp17_ = gnome_pie_config_get_global ();
							_tmp18_ = _tmp17_;
							_tmp19_ = gnome_pie_config_get_global_scale (_tmp18_);
							_tmp20_ = _tmp19_;
							gnome_pie_theme_set_radius (self, double_parse (_tmp16_) * _tmp20_);
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("maxzoom")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp21_;
							_tmp21_ = attr_content;
							gnome_pie_theme_set_max_zoom (self, double_parse (_tmp21_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label2) ? _tmp14_label2 : (_tmp14_label2 = g_quark_from_static_string ("zoomrange")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp22_;
							_tmp22_ = attr_content;
							gnome_pie_theme_set_zoom_range (self, double_parse (_tmp22_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label3) ? _tmp14_label3 : (_tmp14_label3 = g_quark_from_static_string ("transitiontime")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp23_;
							_tmp23_ = attr_content;
							gnome_pie_theme_set_transition_time (self, double_parse (_tmp23_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label4) ? _tmp14_label4 : (_tmp14_label4 = g_quark_from_static_string ("wobble")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp24_;
							_tmp24_ = attr_content;
							gnome_pie_theme_set_wobble (self, double_parse (_tmp24_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label5) ? _tmp14_label5 : (_tmp14_label5 = g_quark_from_static_string ("fadeintime")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp25_;
							_tmp25_ = attr_content;
							gnome_pie_theme_set_fade_in_time (self, double_parse (_tmp25_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label6) ? _tmp14_label6 : (_tmp14_label6 = g_quark_from_static_string ("fadeouttime")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp26_;
							_tmp26_ = attr_content;
							gnome_pie_theme_set_fade_out_time (self, double_parse (_tmp26_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label7) ? _tmp14_label7 : (_tmp14_label7 = g_quark_from_static_string ("fadeinzoom")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp27_;
							_tmp27_ = attr_content;
							gnome_pie_theme_set_fade_in_zoom (self, double_parse (_tmp27_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label8) ? _tmp14_label8 : (_tmp14_label8 = g_quark_from_static_string ("fadeoutzoom")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp28_;
							_tmp28_ = attr_content;
							gnome_pie_theme_set_fade_out_zoom (self, double_parse (_tmp28_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label9) ? _tmp14_label9 : (_tmp14_label9 = g_quark_from_static_string ("fadeinrotation")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp29_;
							_tmp29_ = attr_content;
							gnome_pie_theme_set_fade_in_rotation (self, double_parse (_tmp29_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label10) ? _tmp14_label10 : (_tmp14_label10 = g_quark_from_static_string ("fadeoutrotation")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp30_;
							_tmp30_ = attr_content;
							gnome_pie_theme_set_fade_out_rotation (self, double_parse (_tmp30_));
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label11) ? _tmp14_label11 : (_tmp14_label11 = g_quark_from_static_string ("springiness")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp31_;
							_tmp31_ = attr_content;
							gnome_pie_theme_set_springiness (self, double_parse (_tmp31_));
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							_tmp32_ = attr_name;
							_tmp33_ = g_strconcat ("Invalid attribute \"", _tmp32_, NULL);
							_tmp34_ = _tmp33_;
							_tmp35_ = g_strconcat (_tmp34_, "\" in <pie> element!", NULL);
							_tmp36_ = _tmp35_;
							g_warning ("theme.vala:295: %s", _tmp36_);
							_g_free0 (_tmp36_);
							_g_free0 (_tmp34_);
							break;
						}
					}
				}
				_g_free0 (attr_content);
				_g_free0 (attr_name);
			}
		}
	}
	{
		xmlNode* node = NULL;
		xmlNode* _tmp37_;
		_tmp37_ = pie->children;
		node = _tmp37_;
		{
			gboolean _tmp38_ = FALSE;
			_tmp38_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp41_;
				xmlNode* _tmp42_;
				if (!_tmp38_) {
					xmlNode* _tmp39_;
					xmlNode* _tmp40_;
					_tmp39_ = node;
					_tmp40_ = _tmp39_->next;
					node = _tmp40_;
				}
				_tmp38_ = FALSE;
				_tmp41_ = node;
				if (!(_tmp41_ != NULL)) {
					break;
				}
				_tmp42_ = node;
				if (_tmp42_->type == XML_ELEMENT_NODE) {
					gchar* element_name = NULL;
					xmlNode* _tmp43_;
					const gchar* _tmp44_;
					gchar* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					GQuark _tmp49_ = 0U;
					static GQuark _tmp48_label0 = 0;
					static GQuark _tmp48_label1 = 0;
					static GQuark _tmp48_label2 = 0;
					_tmp43_ = node;
					_tmp44_ = _tmp43_->name;
					_tmp45_ = g_utf8_strdown (_tmp44_, (gssize) -1);
					element_name = _tmp45_;
					_tmp46_ = element_name;
					_tmp47_ = _tmp46_;
					_tmp49_ = (NULL == _tmp47_) ? 0 : g_quark_from_string (_tmp47_);
					if (_tmp49_ == ((0 != _tmp48_label0) ? _tmp48_label0 : (_tmp48_label0 = g_quark_from_static_string ("center")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp50_;
								_tmp50_ = node;
								gnome_pie_theme_parse_center (self, _tmp50_);
								break;
							}
						}
					} else if (_tmp49_ == ((0 != _tmp48_label1) ? _tmp48_label1 : (_tmp48_label1 = g_quark_from_static_string ("slices")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp51_;
								_tmp51_ = node;
								gnome_pie_theme_parse_slices (self, _tmp51_);
								break;
							}
						}
					} else if (_tmp49_ == ((0 != _tmp48_label2) ? _tmp48_label2 : (_tmp48_label2 = g_quark_from_static_string ("caption")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp52_;
								gnome_pie_theme_set_caption (self, TRUE);
								_tmp52_ = node;
								gnome_pie_theme_parse_caption (self, _tmp52_);
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								const gchar* _tmp53_;
								gchar* _tmp54_;
								gchar* _tmp55_;
								gchar* _tmp56_;
								gchar* _tmp57_;
								_tmp53_ = element_name;
								_tmp54_ = g_strconcat ("Invalid child element \"", _tmp53_, NULL);
								_tmp55_ = _tmp54_;
								_tmp56_ = g_strconcat (_tmp55_, "\" in <pie> element!", NULL);
								_tmp57_ = _tmp56_;
								g_warning ("theme.vala:314: %s", _tmp57_);
								_g_free0 (_tmp57_);
								_g_free0 (_tmp55_);
								break;
							}
						}
					}
					_g_free0 (element_name);
				}
			}
		}
	}
}

static void
gnome_pie_theme_parse_center (GnomePieTheme* self,
                              xmlNode* center)
{
	g_return_if_fail (self != NULL);
	{
		xmlAttr* attribute = NULL;
		xmlAttr* _tmp0_;
		_tmp0_ = center->properties;
		attribute = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp4_;
				gchar* attr_name = NULL;
				xmlAttr* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* attr_content = NULL;
				xmlAttr* _tmp8_;
				xmlNode* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GQuark _tmp15_ = 0U;
				static GQuark _tmp14_label0 = 0;
				static GQuark _tmp14_label1 = 0;
				if (!_tmp1_) {
					xmlAttr* _tmp2_;
					xmlAttr* _tmp3_;
					_tmp2_ = attribute;
					_tmp3_ = _tmp2_->next;
					attribute = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = attribute;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = attribute;
				_tmp6_ = _tmp5_->name;
				_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
				attr_name = _tmp7_;
				_tmp8_ = attribute;
				_tmp9_ = _tmp8_->children;
				_tmp10_ = _tmp9_->content;
				_tmp11_ = g_strdup (_tmp10_);
				attr_content = _tmp11_;
				_tmp12_ = attr_name;
				_tmp13_ = _tmp12_;
				_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
				if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("radius")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp16_;
							GnomePieConfig* _tmp17_;
							GnomePieConfig* _tmp18_;
							gdouble _tmp19_;
							gdouble _tmp20_;
							_tmp16_ = attr_content;
							_tmp17_ = gnome_pie_config_get_global ();
							_tmp18_ = _tmp17_;
							_tmp19_ = gnome_pie_config_get_global_scale (_tmp18_);
							_tmp20_ = _tmp19_;
							gnome_pie_theme_set_center_radius (self, double_parse (_tmp16_) * _tmp20_);
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("activeradius")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp21_;
							GnomePieConfig* _tmp22_;
							GnomePieConfig* _tmp23_;
							gdouble _tmp24_;
							gdouble _tmp25_;
							_tmp21_ = attr_content;
							_tmp22_ = gnome_pie_config_get_global ();
							_tmp23_ = _tmp22_;
							_tmp24_ = gnome_pie_config_get_global_scale (_tmp23_);
							_tmp25_ = _tmp24_;
							gnome_pie_theme_set_active_radius (self, double_parse (_tmp21_) * _tmp25_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp26_;
							gchar* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_;
							gchar* _tmp30_;
							_tmp26_ = attr_name;
							_tmp27_ = g_strconcat ("Invalid attribute \"", _tmp26_, NULL);
							_tmp28_ = _tmp27_;
							_tmp29_ = g_strconcat (_tmp28_, "\" in <center> element!", NULL);
							_tmp30_ = _tmp29_;
							g_warning ("theme.vala:338: %s", _tmp30_);
							_g_free0 (_tmp30_);
							_g_free0 (_tmp28_);
							break;
						}
					}
				}
				_g_free0 (attr_content);
				_g_free0 (attr_name);
			}
		}
	}
	{
		xmlNode* node = NULL;
		xmlNode* _tmp31_;
		_tmp31_ = center->children;
		node = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp35_;
				xmlNode* _tmp36_;
				if (!_tmp32_) {
					xmlNode* _tmp33_;
					xmlNode* _tmp34_;
					_tmp33_ = node;
					_tmp34_ = _tmp33_->next;
					node = _tmp34_;
				}
				_tmp32_ = FALSE;
				_tmp35_ = node;
				if (!(_tmp35_ != NULL)) {
					break;
				}
				_tmp36_ = node;
				if (_tmp36_->type == XML_ELEMENT_NODE) {
					gchar* element_name = NULL;
					xmlNode* _tmp37_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp37_ = node;
					_tmp38_ = _tmp37_->name;
					_tmp39_ = g_utf8_strdown (_tmp38_, (gssize) -1);
					element_name = _tmp39_;
					_tmp40_ = element_name;
					if (g_strcmp0 (_tmp40_, "center_layer") == 0) {
						xmlNode* _tmp41_;
						_tmp41_ = node;
						gnome_pie_theme_parse_center_layer (self, _tmp41_);
					} else {
						const gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						_tmp42_ = element_name;
						_tmp43_ = g_strconcat ("Invalid child element \"", _tmp42_, NULL);
						_tmp44_ = _tmp43_;
						_tmp45_ = g_strconcat (_tmp44_, "\" in <center> element!", NULL);
						_tmp46_ = _tmp45_;
						g_warning ("theme.vala:349: %s", _tmp46_);
						_g_free0 (_tmp46_);
						_g_free0 (_tmp44_);
					}
					_g_free0 (element_name);
				}
			}
		}
	}
}

static void
gnome_pie_theme_parse_slices (GnomePieTheme* self,
                              xmlNode* slices)
{
	g_return_if_fail (self != NULL);
	{
		xmlAttr* attribute = NULL;
		xmlAttr* _tmp0_;
		_tmp0_ = slices->properties;
		attribute = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp4_;
				gchar* attr_name = NULL;
				xmlAttr* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* attr_content = NULL;
				xmlAttr* _tmp8_;
				xmlNode* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GQuark _tmp15_ = 0U;
				static GQuark _tmp14_label0 = 0;
				static GQuark _tmp14_label1 = 0;
				if (!_tmp1_) {
					xmlAttr* _tmp2_;
					xmlAttr* _tmp3_;
					_tmp2_ = attribute;
					_tmp3_ = _tmp2_->next;
					attribute = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = attribute;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = attribute;
				_tmp6_ = _tmp5_->name;
				_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
				attr_name = _tmp7_;
				_tmp8_ = attribute;
				_tmp9_ = _tmp8_->children;
				_tmp10_ = _tmp9_->content;
				_tmp11_ = g_strdup (_tmp10_);
				attr_content = _tmp11_;
				_tmp12_ = attr_name;
				_tmp13_ = _tmp12_;
				_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
				if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("radius")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp16_;
							GnomePieConfig* _tmp17_;
							GnomePieConfig* _tmp18_;
							gdouble _tmp19_;
							gdouble _tmp20_;
							const gchar* _tmp21_;
							GnomePieConfig* _tmp22_;
							GnomePieConfig* _tmp23_;
							gdouble _tmp24_;
							gdouble _tmp25_;
							_tmp16_ = attr_content;
							_tmp17_ = gnome_pie_config_get_global ();
							_tmp18_ = _tmp17_;
							_tmp19_ = gnome_pie_config_get_global_scale (_tmp18_);
							_tmp20_ = _tmp19_;
							gnome_pie_theme_set_slice_radius (self, double_parse (_tmp16_) * _tmp20_);
							_tmp21_ = attr_content;
							_tmp22_ = gnome_pie_config_get_global ();
							_tmp23_ = _tmp22_;
							_tmp24_ = gnome_pie_config_get_global_scale (_tmp23_);
							_tmp25_ = _tmp24_;
							gnome_pie_theme_set_visible_slice_radius (self, double_parse (_tmp21_) * _tmp25_);
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("mingap")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp26_;
							GnomePieConfig* _tmp27_;
							GnomePieConfig* _tmp28_;
							gdouble _tmp29_;
							gdouble _tmp30_;
							_tmp26_ = attr_content;
							_tmp27_ = gnome_pie_config_get_global ();
							_tmp28_ = _tmp27_;
							_tmp29_ = gnome_pie_config_get_global_scale (_tmp28_);
							_tmp30_ = _tmp29_;
							gnome_pie_theme_set_slice_gap (self, double_parse (_tmp26_) * _tmp30_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							_tmp31_ = attr_name;
							_tmp32_ = g_strconcat ("Invalid attribute \"", _tmp31_, NULL);
							_tmp33_ = _tmp32_;
							_tmp34_ = g_strconcat (_tmp33_, "\" in <slices> element!", NULL);
							_tmp35_ = _tmp34_;
							g_warning ("theme.vala:373: %s", _tmp35_);
							_g_free0 (_tmp35_);
							_g_free0 (_tmp33_);
							break;
						}
					}
				}
				_g_free0 (attr_content);
				_g_free0 (attr_name);
			}
		}
	}
	{
		xmlNode* node = NULL;
		xmlNode* _tmp36_;
		_tmp36_ = slices->children;
		node = _tmp36_;
		{
			gboolean _tmp37_ = FALSE;
			_tmp37_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp40_;
				xmlNode* _tmp41_;
				if (!_tmp37_) {
					xmlNode* _tmp38_;
					xmlNode* _tmp39_;
					_tmp38_ = node;
					_tmp39_ = _tmp38_->next;
					node = _tmp39_;
				}
				_tmp37_ = FALSE;
				_tmp40_ = node;
				if (!(_tmp40_ != NULL)) {
					break;
				}
				_tmp41_ = node;
				if (_tmp41_->type == XML_ELEMENT_NODE) {
					gchar* element_name = NULL;
					xmlNode* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gboolean _tmp45_ = FALSE;
					const gchar* _tmp46_;
					_tmp42_ = node;
					_tmp43_ = _tmp42_->name;
					_tmp44_ = g_utf8_strdown (_tmp43_, (gssize) -1);
					element_name = _tmp44_;
					_tmp46_ = element_name;
					if (g_strcmp0 (_tmp46_, "activeslice") == 0) {
						_tmp45_ = TRUE;
					} else {
						const gchar* _tmp47_;
						_tmp47_ = element_name;
						_tmp45_ = g_strcmp0 (_tmp47_, "inactiveslice") == 0;
					}
					if (_tmp45_) {
						xmlNode* _tmp48_;
						_tmp48_ = node;
						gnome_pie_theme_parse_slice_layers (self, _tmp48_);
					} else {
						const gchar* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						_tmp49_ = element_name;
						_tmp50_ = g_strconcat ("Invalid child element \"", _tmp49_, NULL);
						_tmp51_ = _tmp50_;
						_tmp52_ = g_strconcat (_tmp51_, "\" in <slices> element!", NULL);
						_tmp53_ = _tmp52_;
						g_warning ("theme.vala:384: %s", _tmp53_);
						_g_free0 (_tmp53_);
						_g_free0 (_tmp51_);
					}
					_g_free0 (element_name);
				}
			}
		}
	}
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
gnome_pie_theme_parse_center_layer (GnomePieTheme* self,
                                    xmlNode* layer)
{
	gchar* file = NULL;
	gchar* _tmp0_;
	gdouble active_rotation_speed = 0.0;
	gdouble inactive_rotation_speed = 0.0;
	gdouble active_scale = 0.0;
	gdouble inactive_scale = 0.0;
	gdouble active_alpha = 0.0;
	gdouble inactive_alpha = 0.0;
	gboolean active_colorize = FALSE;
	gboolean inactive_colorize = FALSE;
	GnomePieCenterLayerRotationMode active_rotation_mode = 0;
	GnomePieCenterLayerRotationMode inactive_rotation_mode = 0;
	gdouble max_scale = 0.0;
	GeeArrayList* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gdouble _tmp69_;
	GnomePieCenterLayer* _tmp70_;
	GnomePieCenterLayer* _tmp71_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	file = _tmp0_;
	active_rotation_speed = 0.0;
	inactive_rotation_speed = 0.0;
	active_scale = 1.0;
	inactive_scale = 1.0;
	active_alpha = 1.0;
	inactive_alpha = 1.0;
	active_colorize = FALSE;
	inactive_colorize = FALSE;
	active_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_AUTO;
	inactive_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_AUTO;
	{
		xmlAttr* attribute = NULL;
		xmlAttr* _tmp1_;
		_tmp1_ = layer->properties;
		attribute = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp5_;
				gchar* attr_name = NULL;
				xmlAttr* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* attr_content = NULL;
				xmlAttr* _tmp9_;
				xmlNode* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				GQuark _tmp16_ = 0U;
				static GQuark _tmp15_label0 = 0;
				static GQuark _tmp15_label1 = 0;
				static GQuark _tmp15_label2 = 0;
				static GQuark _tmp15_label3 = 0;
				static GQuark _tmp15_label4 = 0;
				static GQuark _tmp15_label5 = 0;
				static GQuark _tmp15_label6 = 0;
				static GQuark _tmp15_label7 = 0;
				static GQuark _tmp15_label8 = 0;
				static GQuark _tmp15_label9 = 0;
				static GQuark _tmp15_label10 = 0;
				if (!_tmp2_) {
					xmlAttr* _tmp3_;
					xmlAttr* _tmp4_;
					_tmp3_ = attribute;
					_tmp4_ = _tmp3_->next;
					attribute = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = attribute;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = attribute;
				_tmp7_ = _tmp6_->name;
				_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) -1);
				attr_name = _tmp8_;
				_tmp9_ = attribute;
				_tmp10_ = _tmp9_->children;
				_tmp11_ = _tmp10_->content;
				_tmp12_ = g_strdup (_tmp11_);
				attr_content = _tmp12_;
				_tmp13_ = attr_name;
				_tmp14_ = _tmp13_;
				_tmp16_ = (NULL == _tmp14_) ? 0 : g_quark_from_string (_tmp14_);
				if (_tmp16_ == ((0 != _tmp15_label0) ? _tmp15_label0 : (_tmp15_label0 = g_quark_from_static_string ("file")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp17_;
							gchar* _tmp18_;
							_tmp17_ = attr_content;
							_tmp18_ = g_strdup (_tmp17_);
							_g_free0 (file);
							file = _tmp18_;
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label1) ? _tmp15_label1 : (_tmp15_label1 = g_quark_from_static_string ("active_scale")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp19_;
							_tmp19_ = attr_content;
							active_scale = double_parse (_tmp19_);
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label2) ? _tmp15_label2 : (_tmp15_label2 = g_quark_from_static_string ("active_alpha")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp20_;
							_tmp20_ = attr_content;
							active_alpha = double_parse (_tmp20_);
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label3) ? _tmp15_label3 : (_tmp15_label3 = g_quark_from_static_string ("active_rotationmode")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							GQuark _tmp25_ = 0U;
							static GQuark _tmp24_label0 = 0;
							static GQuark _tmp24_label1 = 0;
							static GQuark _tmp24_label2 = 0;
							static GQuark _tmp24_label3 = 0;
							static GQuark _tmp24_label4 = 0;
							static GQuark _tmp24_label5 = 0;
							static GQuark _tmp24_label6 = 0;
							static GQuark _tmp24_label7 = 0;
							_tmp21_ = attr_content;
							_tmp22_ = g_utf8_strdown (_tmp21_, (gssize) -1);
							_tmp23_ = _tmp22_;
							_tmp25_ = (NULL == _tmp23_) ? 0 : g_quark_from_string (_tmp23_);
							g_free (_tmp23_);
							if (_tmp25_ == ((0 != _tmp24_label0) ? _tmp24_label0 : (_tmp24_label0 = g_quark_from_static_string ("auto")))) {
								switch (0) {
									default:
									{
										active_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_AUTO;
										break;
									}
								}
							} else if (_tmp25_ == ((0 != _tmp24_label1) ? _tmp24_label1 : (_tmp24_label1 = g_quark_from_static_string ("turn_to_active")))) {
								switch (0) {
									default:
									{
										active_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_ACTIVE;
										break;
									}
								}
							} else if (_tmp25_ == ((0 != _tmp24_label2) ? _tmp24_label2 : (_tmp24_label2 = g_quark_from_static_string ("turn_to_mouse")))) {
								switch (0) {
									default:
									{
										active_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MOUSE;
										break;
									}
								}
							} else if ((_tmp25_ == ((0 != _tmp24_label3) ? _tmp24_label3 : (_tmp24_label3 = g_quark_from_static_string ("turn_to_hour")))) || (_tmp25_ == ((0 != _tmp24_label4) ? _tmp24_label4 : (_tmp24_label4 = g_quark_from_static_string ("turn_to_hour_12"))))) {
								switch (0) {
									default:
									{
										active_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_12;
										break;
									}
								}
							} else if (_tmp25_ == ((0 != _tmp24_label5) ? _tmp24_label5 : (_tmp24_label5 = g_quark_from_static_string ("turn_to_hour_24")))) {
								switch (0) {
									default:
									{
										active_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_24;
										break;
									}
								}
							} else if (_tmp25_ == ((0 != _tmp24_label6) ? _tmp24_label6 : (_tmp24_label6 = g_quark_from_static_string ("turn_to_minute")))) {
								switch (0) {
									default:
									{
										active_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MINUTE;
										break;
									}
								}
							} else if (_tmp25_ == ((0 != _tmp24_label7) ? _tmp24_label7 : (_tmp24_label7 = g_quark_from_static_string ("turn_to_second")))) {
								switch (0) {
									default:
									{
										active_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_SECOND;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										const gchar* _tmp26_;
										gchar* _tmp27_;
										gchar* _tmp28_;
										gchar* _tmp29_;
										gchar* _tmp30_;
										const gchar* _tmp31_;
										gchar* _tmp32_;
										gchar* _tmp33_;
										gchar* _tmp34_;
										gchar* _tmp35_;
										_tmp26_ = attr_content;
										_tmp27_ = g_strconcat ("Invalid value \"", _tmp26_, NULL);
										_tmp28_ = _tmp27_;
										_tmp29_ = g_strconcat (_tmp28_, "\" for attribute \"", NULL);
										_tmp30_ = _tmp29_;
										_tmp31_ = attr_name;
										_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
										_tmp33_ = _tmp32_;
										_tmp34_ = g_strconcat (_tmp33_, "\" in <center_layer> element!", NULL);
										_tmp35_ = _tmp34_;
										g_warning ("theme.vala:447: %s", _tmp35_);
										_g_free0 (_tmp35_);
										_g_free0 (_tmp33_);
										_g_free0 (_tmp30_);
										_g_free0 (_tmp28_);
										break;
									}
								}
							}
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label4) ? _tmp15_label4 : (_tmp15_label4 = g_quark_from_static_string ("active_rotationspeed")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp36_;
							_tmp36_ = attr_content;
							active_rotation_speed = double_parse (_tmp36_);
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label5) ? _tmp15_label5 : (_tmp15_label5 = g_quark_from_static_string ("active_colorize")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp37_;
							_tmp37_ = attr_content;
							active_colorize = bool_parse (_tmp37_);
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label6) ? _tmp15_label6 : (_tmp15_label6 = g_quark_from_static_string ("inactive_scale")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp38_;
							_tmp38_ = attr_content;
							inactive_scale = double_parse (_tmp38_);
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label7) ? _tmp15_label7 : (_tmp15_label7 = g_quark_from_static_string ("inactive_alpha")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp39_;
							_tmp39_ = attr_content;
							inactive_alpha = double_parse (_tmp39_);
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label8) ? _tmp15_label8 : (_tmp15_label8 = g_quark_from_static_string ("inactive_rotationmode")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp40_;
							gchar* _tmp41_;
							gchar* _tmp42_;
							GQuark _tmp44_ = 0U;
							static GQuark _tmp43_label0 = 0;
							static GQuark _tmp43_label1 = 0;
							static GQuark _tmp43_label2 = 0;
							static GQuark _tmp43_label3 = 0;
							static GQuark _tmp43_label4 = 0;
							static GQuark _tmp43_label5 = 0;
							static GQuark _tmp43_label6 = 0;
							static GQuark _tmp43_label7 = 0;
							_tmp40_ = attr_content;
							_tmp41_ = g_utf8_strdown (_tmp40_, (gssize) -1);
							_tmp42_ = _tmp41_;
							_tmp44_ = (NULL == _tmp42_) ? 0 : g_quark_from_string (_tmp42_);
							g_free (_tmp42_);
							if (_tmp44_ == ((0 != _tmp43_label0) ? _tmp43_label0 : (_tmp43_label0 = g_quark_from_static_string ("auto")))) {
								switch (0) {
									default:
									{
										inactive_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_AUTO;
										break;
									}
								}
							} else if (_tmp44_ == ((0 != _tmp43_label1) ? _tmp43_label1 : (_tmp43_label1 = g_quark_from_static_string ("turn_to_active")))) {
								switch (0) {
									default:
									{
										inactive_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_ACTIVE;
										break;
									}
								}
							} else if (_tmp44_ == ((0 != _tmp43_label2) ? _tmp43_label2 : (_tmp43_label2 = g_quark_from_static_string ("turn_to_mouse")))) {
								switch (0) {
									default:
									{
										inactive_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MOUSE;
										break;
									}
								}
							} else if ((_tmp44_ == ((0 != _tmp43_label3) ? _tmp43_label3 : (_tmp43_label3 = g_quark_from_static_string ("turn_to_hour")))) || (_tmp44_ == ((0 != _tmp43_label4) ? _tmp43_label4 : (_tmp43_label4 = g_quark_from_static_string ("turn_to_hour_12"))))) {
								switch (0) {
									default:
									{
										inactive_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_12;
										break;
									}
								}
							} else if (_tmp44_ == ((0 != _tmp43_label5) ? _tmp43_label5 : (_tmp43_label5 = g_quark_from_static_string ("turn_to_hour_24")))) {
								switch (0) {
									default:
									{
										inactive_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_24;
										break;
									}
								}
							} else if (_tmp44_ == ((0 != _tmp43_label6) ? _tmp43_label6 : (_tmp43_label6 = g_quark_from_static_string ("turn_to_minute")))) {
								switch (0) {
									default:
									{
										inactive_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MINUTE;
										break;
									}
								}
							} else if (_tmp44_ == ((0 != _tmp43_label7) ? _tmp43_label7 : (_tmp43_label7 = g_quark_from_static_string ("turn_to_second")))) {
								switch (0) {
									default:
									{
										inactive_rotation_mode = GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_SECOND;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										const gchar* _tmp45_;
										gchar* _tmp46_;
										gchar* _tmp47_;
										gchar* _tmp48_;
										gchar* _tmp49_;
										const gchar* _tmp50_;
										gchar* _tmp51_;
										gchar* _tmp52_;
										gchar* _tmp53_;
										gchar* _tmp54_;
										_tmp45_ = attr_content;
										_tmp46_ = g_strconcat ("Invalid value \"", _tmp45_, NULL);
										_tmp47_ = _tmp46_;
										_tmp48_ = g_strconcat (_tmp47_, "\" for attribute \"", NULL);
										_tmp49_ = _tmp48_;
										_tmp50_ = attr_name;
										_tmp51_ = g_strconcat (_tmp49_, _tmp50_, NULL);
										_tmp52_ = _tmp51_;
										_tmp53_ = g_strconcat (_tmp52_, "\" in <center_layer> element!", NULL);
										_tmp54_ = _tmp53_;
										g_warning ("theme.vala:488: %s", _tmp54_);
										_g_free0 (_tmp54_);
										_g_free0 (_tmp52_);
										_g_free0 (_tmp49_);
										_g_free0 (_tmp47_);
										break;
									}
								}
							}
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label9) ? _tmp15_label9 : (_tmp15_label9 = g_quark_from_static_string ("inactive_rotationspeed")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp55_;
							_tmp55_ = attr_content;
							inactive_rotation_speed = double_parse (_tmp55_);
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label10) ? _tmp15_label10 : (_tmp15_label10 = g_quark_from_static_string ("inactive_colorize")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp56_;
							_tmp56_ = attr_content;
							inactive_colorize = bool_parse (_tmp56_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp59_;
							gchar* _tmp60_;
							gchar* _tmp61_;
							_tmp57_ = attr_name;
							_tmp58_ = g_strconcat ("Invalid attribute \"", _tmp57_, NULL);
							_tmp59_ = _tmp58_;
							_tmp60_ = g_strconcat (_tmp59_, "\" in <center_layer> element!", NULL);
							_tmp61_ = _tmp60_;
							g_warning ("theme.vala:499: %s", _tmp61_);
							_g_free0 (_tmp61_);
							_g_free0 (_tmp59_);
							break;
						}
					}
				}
				_g_free0 (attr_content);
				_g_free0 (attr_name);
			}
		}
	}
	max_scale = fmax (active_scale, inactive_scale);
	_tmp62_ = self->priv->_center_layers;
	_tmp63_ = self->priv->_directory;
	_tmp64_ = g_strconcat (_tmp63_, "/", NULL);
	_tmp65_ = _tmp64_;
	_tmp66_ = file;
	_tmp67_ = g_strconcat (_tmp65_, _tmp66_, NULL);
	_tmp68_ = _tmp67_;
	_tmp69_ = self->priv->_center_radius;
	_tmp70_ = gnome_pie_center_layer_new (_tmp68_, (gint) (_tmp69_ * max_scale), active_scale / max_scale, active_rotation_speed, active_alpha, active_colorize, active_rotation_mode, inactive_scale / max_scale, inactive_rotation_speed, inactive_alpha, inactive_colorize, inactive_rotation_mode);
	_tmp71_ = _tmp70_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp71_);
	_g_object_unref0 (_tmp71_);
	_g_free0 (_tmp68_);
	_g_free0 (_tmp65_);
	_g_free0 (file);
}

static void
gnome_pie_theme_parse_slice_layers (GnomePieTheme* self,
                                    xmlNode* slice)
{
	g_return_if_fail (self != NULL);
	{
		xmlNode* layer = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = slice->children;
		layer = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				xmlNode* _tmp5_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = layer;
					_tmp3_ = _tmp2_->next;
					layer = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = layer;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = layer;
				if (_tmp5_->type == XML_ELEMENT_NODE) {
					gchar* element_name = NULL;
					xmlNode* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					const gchar* _tmp9_;
					_tmp6_ = layer;
					_tmp7_ = _tmp6_->name;
					_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) -1);
					element_name = _tmp8_;
					_tmp9_ = element_name;
					if (g_strcmp0 (_tmp9_, "slice_layer") == 0) {
						gchar* file = NULL;
						gchar* _tmp10_;
						gdouble scale = 0.0;
						GnomePieSliceLayerType type = 0;
						GnomePieSliceLayerVisibility visibility = 0;
						gboolean colorize = FALSE;
						gchar* slice_caption_font = NULL;
						gchar* _tmp11_;
						gint slice_caption_width = 0;
						gint slice_caption_height = 0;
						gint pos_x = 0;
						gint pos_y = 0;
						GnomePieColor* slice_caption_color = NULL;
						GnomePieColor* _tmp12_;
						const gchar* _tmp91_;
						gint size = 0;
						gdouble _tmp97_;
						gdouble _tmp98_;
						gdouble _tmp99_;
						gdouble _tmp100_;
						const gchar* _tmp101_;
						gchar* _tmp102_;
						gchar* _tmp103_;
						gboolean _tmp104_;
						_tmp10_ = g_strdup ("");
						file = _tmp10_;
						scale = 1.0;
						type = GNOME_PIE_SLICE_LAYER_TYPE_FILE;
						visibility = GNOME_PIE_SLICE_LAYER_VISIBILITY_ANY;
						colorize = FALSE;
						_tmp11_ = g_strdup ("sans 8");
						slice_caption_font = _tmp11_;
						slice_caption_width = 50;
						slice_caption_height = 20;
						pos_x = 0;
						pos_y = 0;
						_tmp12_ = gnome_pie_color_new_from_rgb (1.0f, 1.0f, 1.0f);
						slice_caption_color = _tmp12_;
						{
							xmlAttr* attribute = NULL;
							xmlNode* _tmp13_;
							xmlAttr* _tmp14_;
							_tmp13_ = layer;
							_tmp14_ = _tmp13_->properties;
							attribute = _tmp14_;
							{
								gboolean _tmp15_ = FALSE;
								_tmp15_ = TRUE;
								while (TRUE) {
									xmlAttr* _tmp18_;
									gchar* attr_name = NULL;
									xmlAttr* _tmp19_;
									const gchar* _tmp20_;
									gchar* _tmp21_;
									gchar* attr_content = NULL;
									xmlAttr* _tmp22_;
									xmlNode* _tmp23_;
									const gchar* _tmp24_;
									gchar* _tmp25_;
									const gchar* _tmp26_;
									const gchar* _tmp27_;
									GQuark _tmp29_ = 0U;
									static GQuark _tmp28_label0 = 0;
									static GQuark _tmp28_label1 = 0;
									static GQuark _tmp28_label2 = 0;
									static GQuark _tmp28_label3 = 0;
									static GQuark _tmp28_label4 = 0;
									static GQuark _tmp28_label5 = 0;
									static GQuark _tmp28_label6 = 0;
									static GQuark _tmp28_label7 = 0;
									static GQuark _tmp28_label8 = 0;
									static GQuark _tmp28_label9 = 0;
									static GQuark _tmp28_label10 = 0;
									if (!_tmp15_) {
										xmlAttr* _tmp16_;
										xmlAttr* _tmp17_;
										_tmp16_ = attribute;
										_tmp17_ = _tmp16_->next;
										attribute = _tmp17_;
									}
									_tmp15_ = FALSE;
									_tmp18_ = attribute;
									if (!(_tmp18_ != NULL)) {
										break;
									}
									_tmp19_ = attribute;
									_tmp20_ = _tmp19_->name;
									_tmp21_ = g_utf8_strdown (_tmp20_, (gssize) -1);
									attr_name = _tmp21_;
									_tmp22_ = attribute;
									_tmp23_ = _tmp22_->children;
									_tmp24_ = _tmp23_->content;
									_tmp25_ = g_strdup (_tmp24_);
									attr_content = _tmp25_;
									_tmp26_ = attr_name;
									_tmp27_ = _tmp26_;
									_tmp29_ = (NULL == _tmp27_) ? 0 : g_quark_from_string (_tmp27_);
									if (_tmp29_ == ((0 != _tmp28_label0) ? _tmp28_label0 : (_tmp28_label0 = g_quark_from_static_string ("file")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp30_;
												gchar* _tmp31_;
												_tmp30_ = attr_content;
												_tmp31_ = g_strdup (_tmp30_);
												_g_free0 (file);
												file = _tmp31_;
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label1) ? _tmp28_label1 : (_tmp28_label1 = g_quark_from_static_string ("scale")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp32_;
												_tmp32_ = attr_content;
												scale = double_parse (_tmp32_);
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label2) ? _tmp28_label2 : (_tmp28_label2 = g_quark_from_static_string ("type")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp33_;
												_tmp33_ = attr_content;
												if (g_strcmp0 (_tmp33_, "icon") == 0) {
													type = GNOME_PIE_SLICE_LAYER_TYPE_ICON;
												} else {
													const gchar* _tmp34_;
													_tmp34_ = attr_content;
													if (g_strcmp0 (_tmp34_, "caption") == 0) {
														type = GNOME_PIE_SLICE_LAYER_TYPE_CAPTION;
													} else {
														const gchar* _tmp35_;
														_tmp35_ = attr_content;
														if (g_strcmp0 (_tmp35_, "file") != 0) {
															const gchar* _tmp36_;
															gchar* _tmp37_;
															gchar* _tmp38_;
															gchar* _tmp39_;
															gchar* _tmp40_;
															const gchar* _tmp41_;
															gchar* _tmp42_;
															gchar* _tmp43_;
															gchar* _tmp44_;
															gchar* _tmp45_;
															_tmp36_ = attr_content;
															_tmp37_ = g_strconcat ("Invalid attribute content ", _tmp36_, NULL);
															_tmp38_ = _tmp37_;
															_tmp39_ = g_strconcat (_tmp38_, " for attribute ", NULL);
															_tmp40_ = _tmp39_;
															_tmp41_ = attr_name;
															_tmp42_ = g_strconcat (_tmp40_, _tmp41_, NULL);
															_tmp43_ = _tmp42_;
															_tmp44_ = g_strconcat (_tmp43_, " in <slice_layer> element!", NULL);
															_tmp45_ = _tmp44_;
															g_warning ("theme.vala:548: %s", _tmp45_);
															_g_free0 (_tmp45_);
															_g_free0 (_tmp43_);
															_g_free0 (_tmp40_);
															_g_free0 (_tmp38_);
														}
													}
												}
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label3) ? _tmp28_label3 : (_tmp28_label3 = g_quark_from_static_string ("colorize")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp46_;
												_tmp46_ = attr_content;
												colorize = bool_parse (_tmp46_);
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label4) ? _tmp28_label4 : (_tmp28_label4 = g_quark_from_static_string ("font")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp47_;
												gchar* _tmp48_;
												_tmp47_ = attr_content;
												_tmp48_ = g_strdup (_tmp47_);
												_g_free0 (slice_caption_font);
												slice_caption_font = _tmp48_;
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label5) ? _tmp28_label5 : (_tmp28_label5 = g_quark_from_static_string ("width")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp49_;
												GnomePieConfig* _tmp50_;
												GnomePieConfig* _tmp51_;
												gdouble _tmp52_;
												gdouble _tmp53_;
												_tmp49_ = attr_content;
												_tmp50_ = gnome_pie_config_get_global ();
												_tmp51_ = _tmp50_;
												_tmp52_ = gnome_pie_config_get_global_scale (_tmp51_);
												_tmp53_ = _tmp52_;
												slice_caption_width = (gint) (atoi (_tmp49_) * _tmp53_);
												if ((slice_caption_width % 2) == 1) {
													gint _tmp54_;
													slice_caption_width = slice_caption_width - 1;
													_tmp54_ = slice_caption_width;
												}
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label6) ? _tmp28_label6 : (_tmp28_label6 = g_quark_from_static_string ("height")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp55_;
												GnomePieConfig* _tmp56_;
												GnomePieConfig* _tmp57_;
												gdouble _tmp58_;
												gdouble _tmp59_;
												_tmp55_ = attr_content;
												_tmp56_ = gnome_pie_config_get_global ();
												_tmp57_ = _tmp56_;
												_tmp58_ = gnome_pie_config_get_global_scale (_tmp57_);
												_tmp59_ = _tmp58_;
												slice_caption_height = (gint) (atoi (_tmp55_) * _tmp59_);
												if ((slice_caption_height % 2) == 1) {
													gint _tmp60_;
													slice_caption_height = slice_caption_height - 1;
													_tmp60_ = slice_caption_height;
												}
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label7) ? _tmp28_label7 : (_tmp28_label7 = g_quark_from_static_string ("x")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp61_;
												GnomePieConfig* _tmp62_;
												GnomePieConfig* _tmp63_;
												gdouble _tmp64_;
												gdouble _tmp65_;
												_tmp61_ = attr_content;
												_tmp62_ = gnome_pie_config_get_global ();
												_tmp63_ = _tmp62_;
												_tmp64_ = gnome_pie_config_get_global_scale (_tmp63_);
												_tmp65_ = _tmp64_;
												pos_x = (gint) (double_parse (_tmp61_) * _tmp65_);
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label8) ? _tmp28_label8 : (_tmp28_label8 = g_quark_from_static_string ("y")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp66_;
												GnomePieConfig* _tmp67_;
												GnomePieConfig* _tmp68_;
												gdouble _tmp69_;
												gdouble _tmp70_;
												_tmp66_ = attr_content;
												_tmp67_ = gnome_pie_config_get_global ();
												_tmp68_ = _tmp67_;
												_tmp69_ = gnome_pie_config_get_global_scale (_tmp68_);
												_tmp70_ = _tmp69_;
												pos_y = (gint) (double_parse (_tmp66_) * _tmp70_);
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label9) ? _tmp28_label9 : (_tmp28_label9 = g_quark_from_static_string ("color")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp71_;
												GnomePieColor* _tmp72_;
												_tmp71_ = attr_content;
												_tmp72_ = gnome_pie_color_new_from_string (_tmp71_);
												_g_object_unref0 (slice_caption_color);
												slice_caption_color = _tmp72_;
												break;
											}
										}
									} else if (_tmp29_ == ((0 != _tmp28_label10) ? _tmp28_label10 : (_tmp28_label10 = g_quark_from_static_string ("visibility")))) {
										switch (0) {
											default:
											{
												const gchar* _tmp73_;
												_tmp73_ = attr_content;
												if (g_strcmp0 (_tmp73_, "without_caption") == 0) {
													visibility = GNOME_PIE_SLICE_LAYER_VISIBILITY_WITHOUT_CAPTION;
												} else {
													const gchar* _tmp74_;
													_tmp74_ = attr_content;
													if (g_strcmp0 (_tmp74_, "with_caption") == 0) {
														gnome_pie_theme_set_has_slice_captions (self, TRUE);
														visibility = GNOME_PIE_SLICE_LAYER_VISIBILITY_WITH_CAPTION;
													} else {
														const gchar* _tmp75_;
														_tmp75_ = attr_content;
														if (g_strcmp0 (_tmp75_, "any") != 0) {
															const gchar* _tmp76_;
															gchar* _tmp77_;
															gchar* _tmp78_;
															gchar* _tmp79_;
															gchar* _tmp80_;
															const gchar* _tmp81_;
															gchar* _tmp82_;
															gchar* _tmp83_;
															gchar* _tmp84_;
															gchar* _tmp85_;
															_tmp76_ = attr_content;
															_tmp77_ = g_strconcat ("Invalid attribute content ", _tmp76_, NULL);
															_tmp78_ = _tmp77_;
															_tmp79_ = g_strconcat (_tmp78_, " for attribute ", NULL);
															_tmp80_ = _tmp79_;
															_tmp81_ = attr_name;
															_tmp82_ = g_strconcat (_tmp80_, _tmp81_, NULL);
															_tmp83_ = _tmp82_;
															_tmp84_ = g_strconcat (_tmp83_, " in <slice_layer> element!", NULL);
															_tmp85_ = _tmp84_;
															g_warning ("theme.vala:582: %s", _tmp85_);
															_g_free0 (_tmp85_);
															_g_free0 (_tmp83_);
															_g_free0 (_tmp80_);
															_g_free0 (_tmp78_);
														}
													}
												}
												break;
											}
										}
									} else {
										switch (0) {
											default:
											{
												const gchar* _tmp86_;
												gchar* _tmp87_;
												gchar* _tmp88_;
												gchar* _tmp89_;
												gchar* _tmp90_;
												_tmp86_ = attr_name;
												_tmp87_ = g_strconcat ("Invalid attribute \"", _tmp86_, NULL);
												_tmp88_ = _tmp87_;
												_tmp89_ = g_strconcat (_tmp88_, "\" in <slice_layer> element!", NULL);
												_tmp90_ = _tmp89_;
												g_warning ("theme.vala:585: %s", _tmp90_);
												_g_free0 (_tmp90_);
												_g_free0 (_tmp88_);
												break;
											}
										}
									}
									_g_free0 (attr_content);
									_g_free0 (attr_name);
								}
							}
						}
						_tmp91_ = file;
						if (g_strcmp0 (_tmp91_, "") != 0) {
							const gchar* _tmp92_;
							gchar* _tmp93_;
							gchar* _tmp94_;
							const gchar* _tmp95_;
							gchar* _tmp96_;
							_tmp92_ = self->priv->_directory;
							_tmp93_ = g_strconcat (_tmp92_, "/", NULL);
							_tmp94_ = _tmp93_;
							_tmp95_ = file;
							_tmp96_ = g_strconcat (_tmp94_, _tmp95_, NULL);
							_g_free0 (file);
							file = _tmp96_;
							_g_free0 (_tmp94_);
						}
						_tmp97_ = self->priv->_slice_radius;
						_tmp98_ = self->priv->_max_zoom;
						size = 2 * ((gint) ((_tmp97_ * scale) * _tmp98_));
						_tmp99_ = self->priv->_slice_radius;
						_tmp100_ = self->priv->_visible_slice_radius;
						gnome_pie_theme_set_visible_slice_radius (self, fmax (_tmp99_ * scale, _tmp100_));
						_tmp101_ = slice->name;
						_tmp102_ = g_utf8_strdown (_tmp101_, (gssize) -1);
						_tmp103_ = _tmp102_;
						_tmp104_ = g_strcmp0 (_tmp103_, "activeslice") == 0;
						_g_free0 (_tmp103_);
						if (_tmp104_) {
							if (type == GNOME_PIE_SLICE_LAYER_TYPE_ICON) {
								GeeArrayList* _tmp105_;
								const gchar* _tmp106_;
								GnomePieSliceLayer* _tmp107_;
								GnomePieSliceLayer* _tmp108_;
								_tmp105_ = self->priv->_active_slice_layers;
								_tmp106_ = file;
								_tmp107_ = gnome_pie_slice_layer_new_icon (_tmp106_, size, pos_x, pos_y, colorize, visibility);
								_tmp108_ = _tmp107_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp105_, _tmp108_);
								_g_object_unref0 (_tmp108_);
							} else {
								if (type == GNOME_PIE_SLICE_LAYER_TYPE_CAPTION) {
									GeeArrayList* _tmp109_;
									const gchar* _tmp110_;
									GnomePieColor* _tmp111_;
									GnomePieSliceLayer* _tmp112_;
									GnomePieSliceLayer* _tmp113_;
									_tmp109_ = self->priv->_active_slice_layers;
									_tmp110_ = slice_caption_font;
									_tmp111_ = slice_caption_color;
									_tmp112_ = gnome_pie_slice_layer_new_caption (_tmp110_, slice_caption_width, slice_caption_height, pos_x, pos_y, _tmp111_, colorize, visibility);
									_tmp113_ = _tmp112_;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, _tmp113_);
									_g_object_unref0 (_tmp113_);
								} else {
									GeeArrayList* _tmp114_;
									const gchar* _tmp115_;
									GnomePieSliceLayer* _tmp116_;
									GnomePieSliceLayer* _tmp117_;
									_tmp114_ = self->priv->_active_slice_layers;
									_tmp115_ = file;
									_tmp116_ = gnome_pie_slice_layer_new_file (_tmp115_, size, pos_x, pos_y, colorize, visibility);
									_tmp117_ = _tmp116_;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp114_, _tmp117_);
									_g_object_unref0 (_tmp117_);
								}
							}
						} else {
							if (type == GNOME_PIE_SLICE_LAYER_TYPE_ICON) {
								GeeArrayList* _tmp118_;
								const gchar* _tmp119_;
								GnomePieSliceLayer* _tmp120_;
								GnomePieSliceLayer* _tmp121_;
								_tmp118_ = self->priv->_inactive_slice_layers;
								_tmp119_ = file;
								_tmp120_ = gnome_pie_slice_layer_new_icon (_tmp119_, size, pos_x, pos_y, colorize, visibility);
								_tmp121_ = _tmp120_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp118_, _tmp121_);
								_g_object_unref0 (_tmp121_);
							} else {
								if (type == GNOME_PIE_SLICE_LAYER_TYPE_CAPTION) {
									GeeArrayList* _tmp122_;
									const gchar* _tmp123_;
									GnomePieColor* _tmp124_;
									GnomePieSliceLayer* _tmp125_;
									GnomePieSliceLayer* _tmp126_;
									_tmp122_ = self->priv->_inactive_slice_layers;
									_tmp123_ = slice_caption_font;
									_tmp124_ = slice_caption_color;
									_tmp125_ = gnome_pie_slice_layer_new_caption (_tmp123_, slice_caption_width, slice_caption_height, pos_x, pos_y, _tmp124_, colorize, visibility);
									_tmp126_ = _tmp125_;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp122_, _tmp126_);
									_g_object_unref0 (_tmp126_);
								} else {
									GeeArrayList* _tmp127_;
									const gchar* _tmp128_;
									GnomePieSliceLayer* _tmp129_;
									GnomePieSliceLayer* _tmp130_;
									_tmp127_ = self->priv->_inactive_slice_layers;
									_tmp128_ = file;
									_tmp129_ = gnome_pie_slice_layer_new_file (_tmp128_, size, pos_x, pos_y, colorize, visibility);
									_tmp130_ = _tmp129_;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp127_, _tmp130_);
									_g_object_unref0 (_tmp130_);
								}
							}
						}
						_g_object_unref0 (slice_caption_color);
						_g_free0 (slice_caption_font);
						_g_free0 (file);
					} else {
						const gchar* _tmp131_;
						gchar* _tmp132_;
						gchar* _tmp133_;
						gchar* _tmp134_;
						gchar* _tmp135_;
						const gchar* _tmp136_;
						gchar* _tmp137_;
						gchar* _tmp138_;
						gchar* _tmp139_;
						gchar* _tmp140_;
						_tmp131_ = element_name;
						_tmp132_ = g_strconcat ("Invalid child element \"", _tmp131_, NULL);
						_tmp133_ = _tmp132_;
						_tmp134_ = g_strconcat (_tmp133_, "\" in <", NULL);
						_tmp135_ = _tmp134_;
						_tmp136_ = slice->name;
						_tmp137_ = g_strconcat (_tmp135_, _tmp136_, NULL);
						_tmp138_ = _tmp137_;
						_tmp139_ = g_strconcat (_tmp138_, "> element!", NULL);
						_tmp140_ = _tmp139_;
						g_warning ("theme.vala:611: %s", _tmp140_);
						_g_free0 (_tmp140_);
						_g_free0 (_tmp138_);
						_g_free0 (_tmp135_);
						_g_free0 (_tmp133_);
					}
					_g_free0 (element_name);
				}
			}
		}
	}
}

static void
gnome_pie_theme_parse_caption (GnomePieTheme* self,
                               xmlNode* caption)
{
	g_return_if_fail (self != NULL);
	{
		xmlAttr* attribute = NULL;
		xmlAttr* _tmp0_;
		_tmp0_ = caption->properties;
		attribute = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp4_;
				gchar* attr_name = NULL;
				xmlAttr* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* attr_content = NULL;
				xmlAttr* _tmp8_;
				xmlNode* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GQuark _tmp15_ = 0U;
				static GQuark _tmp14_label0 = 0;
				static GQuark _tmp14_label1 = 0;
				static GQuark _tmp14_label2 = 0;
				static GQuark _tmp14_label3 = 0;
				static GQuark _tmp14_label4 = 0;
				if (!_tmp1_) {
					xmlAttr* _tmp2_;
					xmlAttr* _tmp3_;
					_tmp2_ = attribute;
					_tmp3_ = _tmp2_->next;
					attribute = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = attribute;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = attribute;
				_tmp6_ = _tmp5_->name;
				_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
				attr_name = _tmp7_;
				_tmp8_ = attribute;
				_tmp9_ = _tmp8_->children;
				_tmp10_ = _tmp9_->content;
				_tmp11_ = g_strdup (_tmp10_);
				attr_content = _tmp11_;
				_tmp12_ = attr_name;
				_tmp13_ = _tmp12_;
				_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
				if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("font")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp16_;
							_tmp16_ = attr_content;
							gnome_pie_theme_set_caption_font (self, _tmp16_);
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("width")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp17_;
							GnomePieConfig* _tmp18_;
							GnomePieConfig* _tmp19_;
							gdouble _tmp20_;
							gdouble _tmp21_;
							gint _tmp22_;
							_tmp17_ = attr_content;
							_tmp18_ = gnome_pie_config_get_global ();
							_tmp19_ = _tmp18_;
							_tmp20_ = gnome_pie_config_get_global_scale (_tmp19_);
							_tmp21_ = _tmp20_;
							gnome_pie_theme_set_caption_width (self, (gint) (atoi (_tmp17_) * _tmp21_));
							_tmp22_ = self->priv->_caption_width;
							if ((_tmp22_ % 2) == 1) {
								gint _tmp23_;
								gint _tmp24_;
								_tmp23_ = self->priv->_caption_width;
								_tmp23_ = _tmp23_ - 1;
								_tmp24_ = _tmp23_;
								gnome_pie_theme_set_caption_width (self, _tmp24_);
							}
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label2) ? _tmp14_label2 : (_tmp14_label2 = g_quark_from_static_string ("height")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp25_;
							GnomePieConfig* _tmp26_;
							GnomePieConfig* _tmp27_;
							gdouble _tmp28_;
							gdouble _tmp29_;
							gint _tmp30_;
							_tmp25_ = attr_content;
							_tmp26_ = gnome_pie_config_get_global ();
							_tmp27_ = _tmp26_;
							_tmp28_ = gnome_pie_config_get_global_scale (_tmp27_);
							_tmp29_ = _tmp28_;
							gnome_pie_theme_set_caption_height (self, (gint) (atoi (_tmp25_) * _tmp29_));
							_tmp30_ = self->priv->_caption_height;
							if ((_tmp30_ % 2) == 1) {
								gint _tmp31_;
								gint _tmp32_;
								_tmp31_ = self->priv->_caption_height;
								_tmp31_ = _tmp31_ - 1;
								_tmp32_ = _tmp31_;
								gnome_pie_theme_set_caption_height (self, _tmp32_);
							}
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label3) ? _tmp14_label3 : (_tmp14_label3 = g_quark_from_static_string ("position")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp33_;
							GnomePieConfig* _tmp34_;
							GnomePieConfig* _tmp35_;
							gdouble _tmp36_;
							gdouble _tmp37_;
							_tmp33_ = attr_content;
							_tmp34_ = gnome_pie_config_get_global ();
							_tmp35_ = _tmp34_;
							_tmp36_ = gnome_pie_config_get_global_scale (_tmp35_);
							_tmp37_ = _tmp36_;
							gnome_pie_theme_set_caption_position (self, double_parse (_tmp33_) * _tmp37_);
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label4) ? _tmp14_label4 : (_tmp14_label4 = g_quark_from_static_string ("color")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp38_;
							GnomePieColor* _tmp39_;
							GnomePieColor* _tmp40_;
							_tmp38_ = attr_content;
							_tmp39_ = gnome_pie_color_new_from_string (_tmp38_);
							_tmp40_ = _tmp39_;
							gnome_pie_theme_set_caption_color (self, _tmp40_);
							_g_object_unref0 (_tmp40_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp44_;
							gchar* _tmp45_;
							_tmp41_ = attr_name;
							_tmp42_ = g_strconcat ("Invalid attribute \"", _tmp41_, NULL);
							_tmp43_ = _tmp42_;
							_tmp44_ = g_strconcat (_tmp43_, "\" in <caption> element!", NULL);
							_tmp45_ = _tmp44_;
							g_warning ("theme.vala:647: %s", _tmp45_);
							_g_free0 (_tmp45_);
							_g_free0 (_tmp43_);
							break;
						}
					}
				}
				_g_free0 (attr_content);
				_g_free0 (attr_name);
			}
		}
	}
}

const gchar*
gnome_pie_theme_get_directory (GnomePieTheme* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_directory (GnomePieTheme* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_directory (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_directory);
		self->priv->_directory = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_DIRECTORY_PROPERTY]);
	}
}

const gchar*
gnome_pie_theme_get_name (GnomePieTheme* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_name (GnomePieTheme* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_NAME_PROPERTY]);
	}
}

const gchar*
gnome_pie_theme_get_description (GnomePieTheme* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_description (GnomePieTheme* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
gnome_pie_theme_get_author (GnomePieTheme* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_author;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_author (GnomePieTheme* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_author (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_author);
		self->priv->_author = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_AUTHOR_PROPERTY]);
	}
}

const gchar*
gnome_pie_theme_get_email (GnomePieTheme* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_email;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_email (GnomePieTheme* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_email (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_email);
		self->priv->_email = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_EMAIL_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_radius (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_radius;
	return result;
}

static void
gnome_pie_theme_set_radius (GnomePieTheme* self,
                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_radius (self);
	if (old_value != value) {
		self->priv->_radius = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_RADIUS_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_max_zoom (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_max_zoom;
	return result;
}

static void
gnome_pie_theme_set_max_zoom (GnomePieTheme* self,
                              gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_max_zoom (self);
	if (old_value != value) {
		self->priv->_max_zoom = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_MAX_ZOOM_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_zoom_range (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_zoom_range;
	return result;
}

static void
gnome_pie_theme_set_zoom_range (GnomePieTheme* self,
                                gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_zoom_range (self);
	if (old_value != value) {
		self->priv->_zoom_range = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_ZOOM_RANGE_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_transition_time (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_transition_time;
	return result;
}

static void
gnome_pie_theme_set_transition_time (GnomePieTheme* self,
                                     gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_transition_time (self);
	if (old_value != value) {
		self->priv->_transition_time = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_TRANSITION_TIME_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_wobble (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_wobble;
	return result;
}

static void
gnome_pie_theme_set_wobble (GnomePieTheme* self,
                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_wobble (self);
	if (old_value != value) {
		self->priv->_wobble = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_WOBBLE_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_fade_in_time (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_in_time;
	return result;
}

static void
gnome_pie_theme_set_fade_in_time (GnomePieTheme* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_fade_in_time (self);
	if (old_value != value) {
		self->priv->_fade_in_time = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_IN_TIME_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_fade_out_time (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_out_time;
	return result;
}

static void
gnome_pie_theme_set_fade_out_time (GnomePieTheme* self,
                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_fade_out_time (self);
	if (old_value != value) {
		self->priv->_fade_out_time = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_OUT_TIME_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_fade_in_zoom (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_in_zoom;
	return result;
}

static void
gnome_pie_theme_set_fade_in_zoom (GnomePieTheme* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_fade_in_zoom (self);
	if (old_value != value) {
		self->priv->_fade_in_zoom = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_IN_ZOOM_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_fade_out_zoom (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_out_zoom;
	return result;
}

static void
gnome_pie_theme_set_fade_out_zoom (GnomePieTheme* self,
                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_fade_out_zoom (self);
	if (old_value != value) {
		self->priv->_fade_out_zoom = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_OUT_ZOOM_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_fade_in_rotation (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_in_rotation;
	return result;
}

static void
gnome_pie_theme_set_fade_in_rotation (GnomePieTheme* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_fade_in_rotation (self);
	if (old_value != value) {
		self->priv->_fade_in_rotation = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_IN_ROTATION_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_fade_out_rotation (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_out_rotation;
	return result;
}

static void
gnome_pie_theme_set_fade_out_rotation (GnomePieTheme* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_fade_out_rotation (self);
	if (old_value != value) {
		self->priv->_fade_out_rotation = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_OUT_ROTATION_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_springiness (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_springiness;
	return result;
}

static void
gnome_pie_theme_set_springiness (GnomePieTheme* self,
                                 gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_springiness (self);
	if (old_value != value) {
		self->priv->_springiness = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_SPRINGINESS_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_center_radius (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_center_radius;
	return result;
}

static void
gnome_pie_theme_set_center_radius (GnomePieTheme* self,
                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_center_radius (self);
	if (old_value != value) {
		self->priv->_center_radius = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_CENTER_RADIUS_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_active_radius (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_active_radius;
	return result;
}

static void
gnome_pie_theme_set_active_radius (GnomePieTheme* self,
                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_active_radius (self);
	if (old_value != value) {
		self->priv->_active_radius = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_ACTIVE_RADIUS_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_slice_radius (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_slice_radius;
	return result;
}

static void
gnome_pie_theme_set_slice_radius (GnomePieTheme* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_slice_radius (self);
	if (old_value != value) {
		self->priv->_slice_radius = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_SLICE_RADIUS_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_visible_slice_radius (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_visible_slice_radius;
	return result;
}

static void
gnome_pie_theme_set_visible_slice_radius (GnomePieTheme* self,
                                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_visible_slice_radius (self);
	if (old_value != value) {
		self->priv->_visible_slice_radius = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_VISIBLE_SLICE_RADIUS_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_slice_gap (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_slice_gap;
	return result;
}

static void
gnome_pie_theme_set_slice_gap (GnomePieTheme* self,
                               gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_slice_gap (self);
	if (old_value != value) {
		self->priv->_slice_gap = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_SLICE_GAP_PROPERTY]);
	}
}

gboolean
gnome_pie_theme_get_has_slice_captions (GnomePieTheme* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_slice_captions;
	return result;
}

static void
gnome_pie_theme_set_has_slice_captions (GnomePieTheme* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_has_slice_captions (self);
	if (old_value != value) {
		self->priv->_has_slice_captions = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_HAS_SLICE_CAPTIONS_PROPERTY]);
	}
}

gboolean
gnome_pie_theme_get_caption (GnomePieTheme* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_caption;
	return result;
}

static void
gnome_pie_theme_set_caption (GnomePieTheme* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_caption (self);
	if (old_value != value) {
		self->priv->_caption = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_PROPERTY]);
	}
}

const gchar*
gnome_pie_theme_get_caption_font (GnomePieTheme* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_caption_font;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_caption_font (GnomePieTheme* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_caption_font (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_caption_font);
		self->priv->_caption_font = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_FONT_PROPERTY]);
	}
}

gint
gnome_pie_theme_get_caption_width (GnomePieTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_caption_width;
	return result;
}

static void
gnome_pie_theme_set_caption_width (GnomePieTheme* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_caption_width (self);
	if (old_value != value) {
		self->priv->_caption_width = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_WIDTH_PROPERTY]);
	}
}

gint
gnome_pie_theme_get_caption_height (GnomePieTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_caption_height;
	return result;
}

static void
gnome_pie_theme_set_caption_height (GnomePieTheme* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_caption_height (self);
	if (old_value != value) {
		self->priv->_caption_height = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_HEIGHT_PROPERTY]);
	}
}

gdouble
gnome_pie_theme_get_caption_position (GnomePieTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_caption_position;
	return result;
}

static void
gnome_pie_theme_set_caption_position (GnomePieTheme* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_caption_position (self);
	if (old_value != value) {
		self->priv->_caption_position = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_POSITION_PROPERTY]);
	}
}

GnomePieColor*
gnome_pie_theme_get_caption_color (GnomePieTheme* self)
{
	GnomePieColor* result;
	GnomePieColor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_caption_color;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gnome_pie_theme_set_caption_color (GnomePieTheme* self,
                                   GnomePieColor* value)
{
	GnomePieColor* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_caption_color (self);
	if (old_value != value) {
		GnomePieColor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_caption_color);
		self->priv->_caption_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_COLOR_PROPERTY]);
	}
}

GnomePieIcon*
gnome_pie_theme_get_preview_icon (GnomePieTheme* self)
{
	GnomePieIcon* result;
	GnomePieIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preview_icon;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_preview_icon (GnomePieTheme* self,
                                  GnomePieIcon* value)
{
	GnomePieIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_preview_icon (self);
	if (old_value != value) {
		GnomePieIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_preview_icon);
		self->priv->_preview_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_PREVIEW_ICON_PROPERTY]);
	}
}

GeeArrayList*
gnome_pie_theme_get_center_layers (GnomePieTheme* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_center_layers;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_center_layers (GnomePieTheme* self,
                                   GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_center_layers (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_center_layers);
		self->priv->_center_layers = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_CENTER_LAYERS_PROPERTY]);
	}
}

GeeArrayList*
gnome_pie_theme_get_active_slice_layers (GnomePieTheme* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_slice_layers;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_active_slice_layers (GnomePieTheme* self,
                                         GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_active_slice_layers (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_active_slice_layers);
		self->priv->_active_slice_layers = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_ACTIVE_SLICE_LAYERS_PROPERTY]);
	}
}

GeeArrayList*
gnome_pie_theme_get_inactive_slice_layers (GnomePieTheme* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inactive_slice_layers;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_theme_set_inactive_slice_layers (GnomePieTheme* self,
                                           GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_theme_get_inactive_slice_layers (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_inactive_slice_layers);
		self->priv->_inactive_slice_layers = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_theme_properties[GNOME_PIE_THEME_INACTIVE_SLICE_LAYERS_PROPERTY]);
	}
}

static void
gnome_pie_theme_class_init (GnomePieThemeClass * klass,
                            gpointer klass_data)
{
	gnome_pie_theme_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePieTheme_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gnome_pie_theme_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gnome_pie_theme_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_pie_theme_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_DIRECTORY_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_DIRECTORY_PROPERTY] = g_param_spec_string ("directory", "directory", "directory", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_NAME_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_DESCRIPTION_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_AUTHOR_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_AUTHOR_PROPERTY] = g_param_spec_string ("author", "author", "author", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_EMAIL_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_EMAIL_PROPERTY] = g_param_spec_string ("email", "email", "email", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_RADIUS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_RADIUS_PROPERTY] = g_param_spec_double ("radius", "radius", "radius", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 150, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_MAX_ZOOM_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_MAX_ZOOM_PROPERTY] = g_param_spec_double ("max-zoom", "max-zoom", "max-zoom", -G_MAXDOUBLE, G_MAXDOUBLE, 1.2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_ZOOM_RANGE_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_ZOOM_RANGE_PROPERTY] = g_param_spec_double ("zoom-range", "zoom-range", "zoom-range", -G_MAXDOUBLE, G_MAXDOUBLE, 0.2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_TRANSITION_TIME_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_TRANSITION_TIME_PROPERTY] = g_param_spec_double ("transition-time", "transition-time", "transition-time", -G_MAXDOUBLE, G_MAXDOUBLE, 0.5, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_WOBBLE_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_WOBBLE_PROPERTY] = g_param_spec_double ("wobble", "wobble", "wobble", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_FADE_IN_TIME_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_IN_TIME_PROPERTY] = g_param_spec_double ("fade-in-time", "fade-in-time", "fade-in-time", -G_MAXDOUBLE, G_MAXDOUBLE, 0.2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_FADE_OUT_TIME_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_OUT_TIME_PROPERTY] = g_param_spec_double ("fade-out-time", "fade-out-time", "fade-out-time", -G_MAXDOUBLE, G_MAXDOUBLE, 0.1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_FADE_IN_ZOOM_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_IN_ZOOM_PROPERTY] = g_param_spec_double ("fade-in-zoom", "fade-in-zoom", "fade-in-zoom", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_FADE_OUT_ZOOM_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_OUT_ZOOM_PROPERTY] = g_param_spec_double ("fade-out-zoom", "fade-out-zoom", "fade-out-zoom", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_FADE_IN_ROTATION_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_IN_ROTATION_PROPERTY] = g_param_spec_double ("fade-in-rotation", "fade-in-rotation", "fade-in-rotation", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_FADE_OUT_ROTATION_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_FADE_OUT_ROTATION_PROPERTY] = g_param_spec_double ("fade-out-rotation", "fade-out-rotation", "fade-out-rotation", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_SPRINGINESS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_SPRINGINESS_PROPERTY] = g_param_spec_double ("springiness", "springiness", "springiness", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_CENTER_RADIUS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_CENTER_RADIUS_PROPERTY] = g_param_spec_double ("center-radius", "center-radius", "center-radius", -G_MAXDOUBLE, G_MAXDOUBLE, 90.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_ACTIVE_RADIUS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_ACTIVE_RADIUS_PROPERTY] = g_param_spec_double ("active-radius", "active-radius", "active-radius", -G_MAXDOUBLE, G_MAXDOUBLE, 45.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_SLICE_RADIUS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_SLICE_RADIUS_PROPERTY] = g_param_spec_double ("slice-radius", "slice-radius", "slice-radius", -G_MAXDOUBLE, G_MAXDOUBLE, 32.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_VISIBLE_SLICE_RADIUS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_VISIBLE_SLICE_RADIUS_PROPERTY] = g_param_spec_double ("visible-slice-radius", "visible-slice-radius", "visible-slice-radius", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_SLICE_GAP_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_SLICE_GAP_PROPERTY] = g_param_spec_double ("slice-gap", "slice-gap", "slice-gap", -G_MAXDOUBLE, G_MAXDOUBLE, 14.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_HAS_SLICE_CAPTIONS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_HAS_SLICE_CAPTIONS_PROPERTY] = g_param_spec_boolean ("has-slice-captions", "has-slice-captions", "has-slice-captions", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_CAPTION_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_PROPERTY] = g_param_spec_boolean ("caption", "caption", "caption", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_CAPTION_FONT_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_FONT_PROPERTY] = g_param_spec_string ("caption-font", "caption-font", "caption-font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_CAPTION_WIDTH_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_WIDTH_PROPERTY] = g_param_spec_int ("caption-width", "caption-width", "caption-width", G_MININT, G_MAXINT, 100, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_CAPTION_HEIGHT_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_HEIGHT_PROPERTY] = g_param_spec_int ("caption-height", "caption-height", "caption-height", G_MININT, G_MAXINT, 100, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_CAPTION_POSITION_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_POSITION_PROPERTY] = g_param_spec_double ("caption-position", "caption-position", "caption-position", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_CAPTION_COLOR_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_CAPTION_COLOR_PROPERTY] = g_param_spec_object ("caption-color", "caption-color", "caption-color", GNOME_PIE_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_PREVIEW_ICON_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_PREVIEW_ICON_PROPERTY] = g_param_spec_object ("preview-icon", "preview-icon", "preview-icon", GNOME_PIE_TYPE_ICON, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_CENTER_LAYERS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_CENTER_LAYERS_PROPERTY] = g_param_spec_object ("center-layers", "center-layers", "center-layers", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_ACTIVE_SLICE_LAYERS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_ACTIVE_SLICE_LAYERS_PROPERTY] = g_param_spec_object ("active-slice-layers", "active-slice-layers", "active-slice-layers", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_THEME_INACTIVE_SLICE_LAYERS_PROPERTY, gnome_pie_theme_properties[GNOME_PIE_THEME_INACTIVE_SLICE_LAYERS_PROPERTY] = g_param_spec_object ("inactive-slice-layers", "inactive-slice-layers", "inactive-slice-layers", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gnome_pie_theme_instance_init (GnomePieTheme * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GnomePieColor* _tmp6_;
	GnomePieIcon* _tmp7_;
	self->priv = gnome_pie_theme_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_directory = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_name = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_description = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_author = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_email = _tmp4_;
	self->priv->_radius = (gdouble) 150;
	self->priv->_max_zoom = 1.2;
	self->priv->_zoom_range = 0.2;
	self->priv->_transition_time = 0.5;
	self->priv->_wobble = 0.0;
	self->priv->_fade_in_time = 0.2;
	self->priv->_fade_out_time = 0.1;
	self->priv->_fade_in_zoom = 1.0;
	self->priv->_fade_out_zoom = 1.0;
	self->priv->_fade_in_rotation = 0.0;
	self->priv->_fade_out_rotation = 0.0;
	self->priv->_springiness = 0.0;
	self->priv->_center_radius = 90.0;
	self->priv->_active_radius = 45.0;
	self->priv->_slice_radius = 32.0;
	self->priv->_visible_slice_radius = 0.0;
	self->priv->_slice_gap = 14.0;
	self->priv->_has_slice_captions = FALSE;
	self->priv->_caption = FALSE;
	_tmp5_ = g_strdup ("sans 12");
	self->priv->_caption_font = _tmp5_;
	self->priv->_caption_width = 100;
	self->priv->_caption_height = 100;
	self->priv->_caption_position = 0.0;
	_tmp6_ = gnome_pie_color_new ();
	self->priv->_caption_color = _tmp6_;
	_tmp7_ = gnome_pie_icon_new ("gnome-pie", 36);
	self->priv->_preview_icon = _tmp7_;
}

static void
gnome_pie_theme_finalize (GObject * obj)
{
	GnomePieTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_THEME, GnomePieTheme);
	_g_free0 (self->priv->_directory);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_author);
	_g_free0 (self->priv->_email);
	_g_free0 (self->priv->_caption_font);
	_g_object_unref0 (self->priv->_caption_color);
	_g_object_unref0 (self->priv->_preview_icon);
	_g_object_unref0 (self->priv->_center_layers);
	_g_object_unref0 (self->priv->_active_slice_layers);
	_g_object_unref0 (self->priv->_inactive_slice_layers);
	G_OBJECT_CLASS (gnome_pie_theme_parent_class)->finalize (obj);
}

static GType
gnome_pie_theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePieThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePieTheme), 0, (GInstanceInitFunc) gnome_pie_theme_instance_init, NULL };
	GType gnome_pie_theme_type_id;
	gnome_pie_theme_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomePieTheme", &g_define_type_info, 0);
	GnomePieTheme_private_offset = g_type_add_instance_private (gnome_pie_theme_type_id, sizeof (GnomePieThemePrivate));
	return gnome_pie_theme_type_id;
}

GType
gnome_pie_theme_get_type (void)
{
	static volatile gsize gnome_pie_theme_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_theme_type_id__once)) {
		GType gnome_pie_theme_type_id;
		gnome_pie_theme_type_id = gnome_pie_theme_get_type_once ();
		g_once_init_leave (&gnome_pie_theme_type_id__once, gnome_pie_theme_type_id);
	}
	return gnome_pie_theme_type_id__once;
}

static void
_vala_gnome_pie_theme_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GnomePieTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_THEME, GnomePieTheme);
	switch (property_id) {
		case GNOME_PIE_THEME_DIRECTORY_PROPERTY:
		g_value_set_string (value, gnome_pie_theme_get_directory (self));
		break;
		case GNOME_PIE_THEME_NAME_PROPERTY:
		g_value_set_string (value, gnome_pie_theme_get_name (self));
		break;
		case GNOME_PIE_THEME_DESCRIPTION_PROPERTY:
		g_value_set_string (value, gnome_pie_theme_get_description (self));
		break;
		case GNOME_PIE_THEME_AUTHOR_PROPERTY:
		g_value_set_string (value, gnome_pie_theme_get_author (self));
		break;
		case GNOME_PIE_THEME_EMAIL_PROPERTY:
		g_value_set_string (value, gnome_pie_theme_get_email (self));
		break;
		case GNOME_PIE_THEME_RADIUS_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_radius (self));
		break;
		case GNOME_PIE_THEME_MAX_ZOOM_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_max_zoom (self));
		break;
		case GNOME_PIE_THEME_ZOOM_RANGE_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_zoom_range (self));
		break;
		case GNOME_PIE_THEME_TRANSITION_TIME_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_transition_time (self));
		break;
		case GNOME_PIE_THEME_WOBBLE_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_wobble (self));
		break;
		case GNOME_PIE_THEME_FADE_IN_TIME_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_fade_in_time (self));
		break;
		case GNOME_PIE_THEME_FADE_OUT_TIME_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_fade_out_time (self));
		break;
		case GNOME_PIE_THEME_FADE_IN_ZOOM_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_fade_in_zoom (self));
		break;
		case GNOME_PIE_THEME_FADE_OUT_ZOOM_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_fade_out_zoom (self));
		break;
		case GNOME_PIE_THEME_FADE_IN_ROTATION_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_fade_in_rotation (self));
		break;
		case GNOME_PIE_THEME_FADE_OUT_ROTATION_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_fade_out_rotation (self));
		break;
		case GNOME_PIE_THEME_SPRINGINESS_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_springiness (self));
		break;
		case GNOME_PIE_THEME_CENTER_RADIUS_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_center_radius (self));
		break;
		case GNOME_PIE_THEME_ACTIVE_RADIUS_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_active_radius (self));
		break;
		case GNOME_PIE_THEME_SLICE_RADIUS_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_slice_radius (self));
		break;
		case GNOME_PIE_THEME_VISIBLE_SLICE_RADIUS_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_visible_slice_radius (self));
		break;
		case GNOME_PIE_THEME_SLICE_GAP_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_slice_gap (self));
		break;
		case GNOME_PIE_THEME_HAS_SLICE_CAPTIONS_PROPERTY:
		g_value_set_boolean (value, gnome_pie_theme_get_has_slice_captions (self));
		break;
		case GNOME_PIE_THEME_CAPTION_PROPERTY:
		g_value_set_boolean (value, gnome_pie_theme_get_caption (self));
		break;
		case GNOME_PIE_THEME_CAPTION_FONT_PROPERTY:
		g_value_set_string (value, gnome_pie_theme_get_caption_font (self));
		break;
		case GNOME_PIE_THEME_CAPTION_WIDTH_PROPERTY:
		g_value_set_int (value, gnome_pie_theme_get_caption_width (self));
		break;
		case GNOME_PIE_THEME_CAPTION_HEIGHT_PROPERTY:
		g_value_set_int (value, gnome_pie_theme_get_caption_height (self));
		break;
		case GNOME_PIE_THEME_CAPTION_POSITION_PROPERTY:
		g_value_set_double (value, gnome_pie_theme_get_caption_position (self));
		break;
		case GNOME_PIE_THEME_CAPTION_COLOR_PROPERTY:
		g_value_set_object (value, gnome_pie_theme_get_caption_color (self));
		break;
		case GNOME_PIE_THEME_PREVIEW_ICON_PROPERTY:
		g_value_set_object (value, gnome_pie_theme_get_preview_icon (self));
		break;
		case GNOME_PIE_THEME_CENTER_LAYERS_PROPERTY:
		g_value_set_object (value, gnome_pie_theme_get_center_layers (self));
		break;
		case GNOME_PIE_THEME_ACTIVE_SLICE_LAYERS_PROPERTY:
		g_value_set_object (value, gnome_pie_theme_get_active_slice_layers (self));
		break;
		case GNOME_PIE_THEME_INACTIVE_SLICE_LAYERS_PROPERTY:
		g_value_set_object (value, gnome_pie_theme_get_inactive_slice_layers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gnome_pie_theme_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GnomePieTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_THEME, GnomePieTheme);
	switch (property_id) {
		case GNOME_PIE_THEME_DIRECTORY_PROPERTY:
		gnome_pie_theme_set_directory (self, g_value_get_string (value));
		break;
		case GNOME_PIE_THEME_NAME_PROPERTY:
		gnome_pie_theme_set_name (self, g_value_get_string (value));
		break;
		case GNOME_PIE_THEME_DESCRIPTION_PROPERTY:
		gnome_pie_theme_set_description (self, g_value_get_string (value));
		break;
		case GNOME_PIE_THEME_AUTHOR_PROPERTY:
		gnome_pie_theme_set_author (self, g_value_get_string (value));
		break;
		case GNOME_PIE_THEME_EMAIL_PROPERTY:
		gnome_pie_theme_set_email (self, g_value_get_string (value));
		break;
		case GNOME_PIE_THEME_RADIUS_PROPERTY:
		gnome_pie_theme_set_radius (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_MAX_ZOOM_PROPERTY:
		gnome_pie_theme_set_max_zoom (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_ZOOM_RANGE_PROPERTY:
		gnome_pie_theme_set_zoom_range (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_TRANSITION_TIME_PROPERTY:
		gnome_pie_theme_set_transition_time (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_WOBBLE_PROPERTY:
		gnome_pie_theme_set_wobble (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_FADE_IN_TIME_PROPERTY:
		gnome_pie_theme_set_fade_in_time (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_FADE_OUT_TIME_PROPERTY:
		gnome_pie_theme_set_fade_out_time (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_FADE_IN_ZOOM_PROPERTY:
		gnome_pie_theme_set_fade_in_zoom (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_FADE_OUT_ZOOM_PROPERTY:
		gnome_pie_theme_set_fade_out_zoom (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_FADE_IN_ROTATION_PROPERTY:
		gnome_pie_theme_set_fade_in_rotation (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_FADE_OUT_ROTATION_PROPERTY:
		gnome_pie_theme_set_fade_out_rotation (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_SPRINGINESS_PROPERTY:
		gnome_pie_theme_set_springiness (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_CENTER_RADIUS_PROPERTY:
		gnome_pie_theme_set_center_radius (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_ACTIVE_RADIUS_PROPERTY:
		gnome_pie_theme_set_active_radius (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_SLICE_RADIUS_PROPERTY:
		gnome_pie_theme_set_slice_radius (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_VISIBLE_SLICE_RADIUS_PROPERTY:
		gnome_pie_theme_set_visible_slice_radius (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_SLICE_GAP_PROPERTY:
		gnome_pie_theme_set_slice_gap (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_HAS_SLICE_CAPTIONS_PROPERTY:
		gnome_pie_theme_set_has_slice_captions (self, g_value_get_boolean (value));
		break;
		case GNOME_PIE_THEME_CAPTION_PROPERTY:
		gnome_pie_theme_set_caption (self, g_value_get_boolean (value));
		break;
		case GNOME_PIE_THEME_CAPTION_FONT_PROPERTY:
		gnome_pie_theme_set_caption_font (self, g_value_get_string (value));
		break;
		case GNOME_PIE_THEME_CAPTION_WIDTH_PROPERTY:
		gnome_pie_theme_set_caption_width (self, g_value_get_int (value));
		break;
		case GNOME_PIE_THEME_CAPTION_HEIGHT_PROPERTY:
		gnome_pie_theme_set_caption_height (self, g_value_get_int (value));
		break;
		case GNOME_PIE_THEME_CAPTION_POSITION_PROPERTY:
		gnome_pie_theme_set_caption_position (self, g_value_get_double (value));
		break;
		case GNOME_PIE_THEME_CAPTION_COLOR_PROPERTY:
		gnome_pie_theme_set_caption_color (self, g_value_get_object (value));
		break;
		case GNOME_PIE_THEME_PREVIEW_ICON_PROPERTY:
		gnome_pie_theme_set_preview_icon (self, g_value_get_object (value));
		break;
		case GNOME_PIE_THEME_CENTER_LAYERS_PROPERTY:
		gnome_pie_theme_set_center_layers (self, g_value_get_object (value));
		break;
		case GNOME_PIE_THEME_ACTIVE_SLICE_LAYERS_PROPERTY:
		gnome_pie_theme_set_active_slice_layers (self, g_value_get_object (value));
		break;
		case GNOME_PIE_THEME_INACTIVE_SLICE_LAYERS_PROPERTY:
		gnome_pie_theme_set_inactive_slice_layers (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

