/* contacts-bin-chunk.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-bin-chunk.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contactscore.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_BIN_CHUNK_0_PROPERTY,
	CONTACTS_BIN_CHUNK_IS_EMPTY_PROPERTY,
	CONTACTS_BIN_CHUNK_DIRTY_PROPERTY,
	CONTACTS_BIN_CHUNK_N_ITEMS_PROPERTY,
	CONTACTS_BIN_CHUNK_ITEM_TYPE_PROPERTY,
	CONTACTS_BIN_CHUNK_NUM_PROPERTIES
};
static GParamSpec* contacts_bin_chunk_properties[CONTACTS_BIN_CHUNK_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
enum  {
	CONTACTS_BIN_CHUNK_CHILD_0_PROPERTY,
	CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY,
	CONTACTS_BIN_CHUNK_CHILD_IS_EMPTY_PROPERTY,
	CONTACTS_BIN_CHUNK_CHILD_ICON_NAME_PROPERTY,
	CONTACTS_BIN_CHUNK_CHILD_NUM_PROPERTIES
};
static GParamSpec* contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsBinChunkPrivate {
	ContactsBinChunkChild** original_elements;
	gint original_elements_length1;
	gint _original_elements_size_;
	gboolean original_elements_set;
	GPtrArray* elements;
};

struct _ContactsBinChunkChildPrivate {
	GeeHashMultiMap* _parameters;
};

static gint ContactsBinChunk_private_offset;
static gpointer contacts_bin_chunk_parent_class = NULL;
static GListModelInterface * contacts_bin_chunk_g_list_model_parent_iface = NULL;
static gint ContactsBinChunkChild_private_offset;
static gpointer contacts_bin_chunk_child_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static gboolean contacts_bin_chunk_has_empty_child (ContactsBinChunk* self);
static void __lambda4_ (ContactsBinChunk* self,
                 GObject* obj,
                 GParamSpec* pspec);
static void ___lambda4__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static ContactsBinChunkChild* contacts_bin_chunk_real_create_empty_child (ContactsBinChunk* self);
static guint contacts_bin_chunk_nr_nonempty_children (ContactsBinChunk* self);
static GValue* contacts_bin_chunk_real_to_value (ContactsChunk* base);
static ContactsBinChunkChild* __lambda5_ (ContactsBinChunk* self,
                                   ContactsBinChunkChild* child);
static gpointer ___lambda5__gcopy_func (gconstpointer src,
                                 gpointer self);
static GVariant* contacts_bin_chunk_real_to_gvariant (ContactsChunk* base);
static void contacts_bin_chunk_real_apply_gvariant (ContactsChunk* base,
                                             GVariant* variant,
                                             gboolean mark_dirty);
static GObject* contacts_bin_chunk_real_get_item (GListModel* base,
                                           guint i);
static guint contacts_bin_chunk_real_get_n_items (GListModel* base);
static GType contacts_bin_chunk_real_get_item_type (GListModel* base);
static void contacts_bin_chunk_finalize (GObject * obj);
static GType contacts_bin_chunk_get_type_once (void);
static void _vala_contacts_bin_chunk_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static FolksAbstractFieldDetails* contacts_bin_chunk_child_real_create_afd (ContactsBinChunkChild* self);
static ContactsBinChunkChild* contacts_bin_chunk_child_real_copy (ContactsBinChunkChild* self);
static GVariant* contacts_bin_chunk_child_real_to_gvariant_internal (ContactsBinChunkChild* self);
static void contacts_bin_chunk_child_real_apply_gvariant (ContactsBinChunkChild* self,
                                                   GVariant* variant);
static gint contacts_bin_chunk_child_real_compare_internal (ContactsBinChunkChild* self,
                                                     ContactsBinChunkChild* other);
static void contacts_bin_chunk_child_finalize (GObject * obj);
static GType contacts_bin_chunk_child_get_type_once (void);
static void _vala_contacts_bin_chunk_child_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_contacts_bin_chunk_child_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
contacts_bin_chunk_get_instance_private (ContactsBinChunk* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsBinChunk_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

/**
   * Should be called by subclasses when they add a child.
   *
   * It will make sure to add the child in the appropriate position and that
   * the emptines check is appropriately applied.
   */
static void
__lambda4_ (ContactsBinChunk* self,
            GObject* obj,
            GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_debug ("contacts-bin-chunk.vala:73: Child 'is-empty' changed, doing emptiness " \
"check");
	contacts_bin_chunk_emptiness_check (self);
}

static void
___lambda4__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda4_ ((ContactsBinChunk*) self, _sender, pspec);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_bin_chunk_add_child (ContactsBinChunk* self,
                              ContactsBinChunkChild* child)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint i = 0;
	GPtrArray* _tmp9_;
	ContactsBinChunkChild* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp1_ = contacts_bin_chunk_child_get_is_empty (child);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = contacts_bin_chunk_has_empty_child (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	g_signal_connect_object ((GObject*) child, "notify::is-empty", (GCallback) ___lambda4__g_object_notify, self, 0);
	i = 0;
	while (TRUE) {
		GPtrArray* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		GPtrArray* _tmp6_;
		gconstpointer _tmp7_;
		gint _tmp8_;
		_tmp3_ = self->priv->elements;
		_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!(i < _tmp5_)) {
			break;
		}
		_tmp6_ = self->priv->elements;
		_tmp7_ = g_ptr_array_index (_tmp6_, (guint) i);
		if (contacts_bin_chunk_child_compare (child, (ContactsBinChunkChild*) _tmp7_) < 0) {
			break;
		}
		_tmp8_ = i;
		i = _tmp8_ + 1;
	}
	_tmp9_ = self->priv->elements;
	_tmp10_ = _g_object_ref0 (child);
	g_ptr_array_insert (_tmp9_, i, _tmp10_);
	g_list_model_items_changed ((GListModel*) self, (guint) i, (guint) 0, (guint) 1);
}

/**
   * Subclasses should implement this to create an empty child (which will be
   * used for the emptiness check).
   */
static ContactsBinChunkChild*
contacts_bin_chunk_real_create_empty_child (ContactsBinChunk* self)
{
	g_critical ("Type `%s' does not implement abstract method `contacts_bin_chunk_create_empty_child'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

ContactsBinChunkChild*
contacts_bin_chunk_create_empty_child (ContactsBinChunk* self)
{
	ContactsBinChunkClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_BIN_CHUNK_GET_CLASS (self);
	if (_klass_->create_empty_child) {
		return _klass_->create_empty_child (self);
	}
	return NULL;
}

void
contacts_bin_chunk_emptiness_check (ContactsBinChunk* self)
{
	ContactsBinChunkChild* child = NULL;
	ContactsBinChunkChild* _tmp0_;
	ContactsBinChunkChild* _tmp1_;
	g_return_if_fail (self != NULL);
	if (contacts_bin_chunk_has_empty_child (self)) {
		return;
	}
	_tmp0_ = contacts_bin_chunk_create_empty_child (self);
	child = _tmp0_;
	_tmp1_ = child;
	contacts_bin_chunk_add_child (self, _tmp1_);
	_g_object_unref0 (child);
}

static gboolean
contacts_bin_chunk_has_empty_child (ContactsBinChunk* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->elements;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < ((guint) _tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->elements;
				_tmp6_ = g_ptr_array_index (_tmp5_, i);
				_tmp7_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static guint
contacts_bin_chunk_nr_nonempty_children (ContactsBinChunk* self)
{
	guint _result_ = 0U;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_result_ = (guint) 0;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->elements;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < ((guint) _tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->elements;
				_tmp6_ = g_ptr_array_index (_tmp5_, i);
				_tmp7_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					guint _tmp9_;
					_tmp9_ = _result_;
					_result_ = _tmp9_ + 1;
				}
			}
		}
	}
	result = _result_;
	return result;
}

static GValue*
contacts_bin_chunk_real_to_value (ContactsChunk* base)
{
	ContactsBinChunk * self;
	GeeHashSet* afds = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp12_ = NULL;
	GeeHashSet* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GValue* _tmp17_ = NULL;
	GValue* result;
	self = (ContactsBinChunk*) base;
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	afds = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				FolksAbstractFieldDetails* afd = NULL;
				GPtrArray* _tmp6_;
				gconstpointer _tmp7_;
				FolksAbstractFieldDetails* _tmp8_;
				FolksAbstractFieldDetails* _tmp9_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->elements;
				_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < ((guint) _tmp5_))) {
					break;
				}
				_tmp6_ = self->priv->elements;
				_tmp7_ = g_ptr_array_index (_tmp6_, i);
				_tmp8_ = contacts_bin_chunk_child_create_afd ((ContactsBinChunkChild*) _tmp7_);
				afd = _tmp8_;
				_tmp9_ = afd;
				if (_tmp9_ != NULL) {
					GeeHashSet* _tmp10_;
					FolksAbstractFieldDetails* _tmp11_;
					_tmp10_ = afds;
					_tmp11_ = afd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				}
				_g_object_unref0 (afd);
			}
		}
	}
	_tmp13_ = afds;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != 0) {
		GeeHashSet* _tmp16_;
		_tmp16_ = afds;
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = NULL;
	}
	_tmp17_ = g_new0 (GValue, 1);
	g_value_init (_tmp17_, GEE_TYPE_HASH_SET);
	g_value_set_object (_tmp17_, _tmp12_);
	result = _tmp17_;
	_g_object_unref0 (afds);
	return result;
}

/** A helper function to collect the AbstractFieldDetails of the children */
GeeSet*
contacts_bin_chunk_get_abstract_field_details (ContactsBinChunk* self)
{
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	GeeHashSet* afds = NULL;
	GeeHashSet* _tmp2_;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "this.persona != null", NULL);
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	afds = _tmp2_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				FolksAbstractFieldDetails* afd = NULL;
				GPtrArray* _tmp8_;
				gconstpointer _tmp9_;
				FolksAbstractFieldDetails* _tmp10_;
				FolksAbstractFieldDetails* _tmp11_;
				if (!_tmp3_) {
					guint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->elements;
				_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < ((guint) _tmp7_))) {
					break;
				}
				_tmp8_ = self->priv->elements;
				_tmp9_ = g_ptr_array_index (_tmp8_, i);
				_tmp10_ = contacts_bin_chunk_child_create_afd ((ContactsBinChunkChild*) _tmp9_);
				afd = _tmp10_;
				_tmp11_ = afd;
				if (_tmp11_ != NULL) {
					GeeHashSet* _tmp12_;
					FolksAbstractFieldDetails* _tmp13_;
					_tmp12_ = afds;
					_tmp13_ = afd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				}
				_g_object_unref0 (afd);
			}
		}
	}
	result = (GeeSet*) afds;
	return result;
}

/**
   * A helper finish the initialization of a BinChunk. It makes sure to set the
   * "original_elements" field (which is used to calculate the "dirty"
   * property) as well as doing an initial emptiness check
   */
static ContactsBinChunkChild*
__lambda5_ (ContactsBinChunk* self,
            ContactsBinChunkChild* child)
{
	ContactsBinChunkChild* _tmp0_;
	ContactsBinChunkChild* result;
	g_return_val_if_fail (child != NULL, NULL);
	_tmp0_ = contacts_bin_chunk_child_copy (child);
	result = _tmp0_;
	return result;
}

static gpointer
___lambda5__gcopy_func (gconstpointer src,
                        gpointer self)
{
	gpointer result;
	result = __lambda5_ ((ContactsBinChunk*) self, (ContactsBinChunkChild*) src);
	return result;
}

void
contacts_bin_chunk_finish_initialization (ContactsBinChunk* self)
{
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	gsize _tmp3_ = 0;
	gpointer* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->elements;
	_tmp1_ = g_ptr_array_copy (_tmp0_, ___lambda5__gcopy_func, self);
	_tmp2_ = _tmp1_;
	_tmp4_ = g_ptr_array_steal (_tmp2_, &_tmp3_);
	self->priv->original_elements = (_vala_array_free (self->priv->original_elements, self->priv->original_elements_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->original_elements = _tmp4_;
	self->priv->original_elements_length1 = _tmp3_;
	self->priv->_original_elements_size_ = self->priv->original_elements_length1;
	_g_ptr_array_unref0 (_tmp2_);
	self->priv->original_elements_set = TRUE;
	contacts_bin_chunk_emptiness_check (self);
}

static GVariant*
contacts_bin_chunk_real_to_gvariant (ContactsChunk* base)
{
	ContactsBinChunk * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp15_;
	GVariant* _tmp16_;
	GVariant* result;
	self = (ContactsBinChunk*) base;
	_tmp0_ = contacts_chunk_get_is_empty ((ContactsChunk*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = G_VARIANT_TYPE_ARRAY;
	_tmp3_ = g_variant_builder_new (_tmp2_);
	builder = _tmp3_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				GVariant* child_variant = NULL;
				GPtrArray* _tmp9_;
				gconstpointer _tmp10_;
				GVariant* _tmp11_;
				GVariant* _tmp12_;
				if (!_tmp4_) {
					guint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->elements;
				_tmp7_ = vala_g_ptr_array_get_length (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(i < ((guint) _tmp8_))) {
					break;
				}
				_tmp9_ = self->priv->elements;
				_tmp10_ = g_ptr_array_index (_tmp9_, i);
				_tmp11_ = contacts_bin_chunk_child_to_gvariant ((ContactsBinChunkChild*) _tmp10_);
				child_variant = _tmp11_;
				_tmp12_ = child_variant;
				if (_tmp12_ != NULL) {
					GVariantBuilder* _tmp13_;
					GVariant* _tmp14_;
					_tmp13_ = builder;
					_tmp14_ = child_variant;
					g_variant_builder_add_value (_tmp13_, _tmp14_);
				}
				_g_variant_unref0 (child_variant);
			}
		}
	}
	_tmp15_ = builder;
	_tmp16_ = g_variant_builder_end (_tmp15_);
	g_variant_ref_sink (_tmp16_);
	result = _tmp16_;
	_g_variant_builder_unref0 (builder);
	return result;
}

static void
contacts_bin_chunk_real_apply_gvariant (ContactsChunk* base,
                                        GVariant* variant,
                                        gboolean mark_dirty)
{
	ContactsBinChunk * self;
	const GVariantType* _tmp0_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp1_;
	GVariant* child_variant = NULL;
	GVariantIter* _tmp2_;
	GVariant* _tmp3_;
	self = (ContactsBinChunk*) base;
	g_return_if_fail (variant != NULL);
	_tmp0_ = g_variant_get_type (variant);
	_vala_return_if_fail (g_variant_type_is_array (_tmp0_), "variant.get_type ().is_array ()");
	_tmp1_ = g_variant_iter_new (variant);
	iter = _tmp1_;
	_tmp2_ = iter;
	_tmp3_ = g_variant_iter_next_value (_tmp2_);
	child_variant = _tmp3_;
	while (TRUE) {
		GVariant* _tmp4_;
		ContactsBinChunkChild* child = NULL;
		ContactsBinChunkChild* _tmp5_;
		ContactsBinChunkChild* _tmp6_;
		GVariant* _tmp7_;
		ContactsBinChunkChild* _tmp8_;
		GVariantIter* _tmp9_;
		GVariant* _tmp10_;
		_tmp4_ = child_variant;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = contacts_bin_chunk_create_empty_child (self);
		child = _tmp5_;
		_tmp6_ = child;
		_tmp7_ = child_variant;
		contacts_bin_chunk_child_apply_gvariant (_tmp6_, _tmp7_);
		_tmp8_ = child;
		contacts_bin_chunk_add_child (self, _tmp8_);
		_tmp9_ = iter;
		_tmp10_ = g_variant_iter_next_value (_tmp9_);
		_g_variant_unref0 (child_variant);
		child_variant = _tmp10_;
		_g_object_unref0 (child);
	}
	if (!mark_dirty) {
		contacts_bin_chunk_finish_initialization (self);
	}
	_g_variant_unref0 (child_variant);
	_g_variant_iter_free0 (iter);
}

static GObject*
contacts_bin_chunk_real_get_item (GListModel* base,
                                  guint i)
{
	ContactsBinChunk * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	GObject* _tmp5_;
	GObject* result;
	self = (ContactsBinChunk*) base;
	_tmp0_ = self->priv->elements;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (i > ((guint) _tmp2_)) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->elements;
	_tmp4_ = g_ptr_array_index (_tmp3_, i);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ContactsBinChunkChild*) _tmp4_, G_TYPE_OBJECT, GObject));
	result = _tmp5_;
	return result;
}

static guint
contacts_bin_chunk_real_get_n_items (GListModel* base)
{
	ContactsBinChunk * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	self = (ContactsBinChunk*) base;
	_tmp0_ = self->priv->elements;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static GType
contacts_bin_chunk_real_get_item_type (GListModel* base)
{
	ContactsBinChunk * self;
	GType result;
	self = (ContactsBinChunk*) base;
	result = CONTACTS_TYPE_BIN_CHUNK_CHILD;
	return result;
}

ContactsBinChunk*
contacts_bin_chunk_construct (GType object_type)
{
	ContactsBinChunk * self = NULL;
	self = (ContactsBinChunk*) contacts_chunk_construct (object_type);
	return self;
}

static gboolean
contacts_bin_chunk_real_get_is_empty (ContactsChunk* base)
{
	gboolean result;
	ContactsBinChunk* self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	self = (ContactsBinChunk*) base;
	_tmp0_ = self->priv->elements;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->priv->elements;
	{
		GPtrArray* chunk_element_collection = NULL;
		guint chunk_element_index = 0U;
		chunk_element_collection = _tmp3_;
		for (chunk_element_index = 0; chunk_element_index < chunk_element_collection->len; chunk_element_index = chunk_element_index + 1) {
			ContactsBinChunkChild* _tmp4_;
			ContactsBinChunkChild* chunk_element = NULL;
			_tmp4_ = _g_object_ref0 ((ContactsBinChunkChild*) g_ptr_array_index (chunk_element_collection, chunk_element_index));
			chunk_element = _tmp4_;
			{
				ContactsBinChunkChild* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = chunk_element;
				_tmp6_ = contacts_bin_chunk_child_get_is_empty (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					result = FALSE;
					_g_object_unref0 (chunk_element);
					return result;
				}
				_g_object_unref0 (chunk_element);
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
contacts_bin_chunk_real_get_dirty (ContactsChunk* base)
{
	gboolean result;
	ContactsBinChunk* self;
	guint non_empty_count = 0U;
	ContactsBinChunkChild** _tmp0_;
	gint _tmp0__length1;
	self = (ContactsBinChunk*) base;
	g_warn_if_fail (self->priv->original_elements_set);
	non_empty_count = contacts_bin_chunk_nr_nonempty_children (self);
	_tmp0_ = self->priv->original_elements;
	_tmp0__length1 = self->priv->original_elements_length1;
	if (((guint) _tmp0__length1) != non_empty_count) {
		result = TRUE;
		return result;
	}
	{
		guint i = 0U;
		guint j = 0U;
		i = (guint) 0;
		j = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gconstpointer _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				GPtrArray* _tmp12_;
				gconstpointer _tmp13_;
				ContactsBinChunkChild** _tmp14_;
				gint _tmp14__length1;
				ContactsBinChunkChild* _tmp15_;
				if (!_tmp1_) {
					guint _tmp2_;
					guint _tmp3_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
					_tmp3_ = j;
					j = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = self->priv->elements;
				_tmp5_ = vala_g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < ((guint) _tmp6_))) {
					break;
				}
				_tmp7_ = self->priv->elements;
				_tmp8_ = g_ptr_array_index (_tmp7_, i);
				_tmp9_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					guint _tmp11_;
					_tmp11_ = j;
					j = _tmp11_ - 1;
					continue;
				}
				_tmp12_ = self->priv->elements;
				_tmp13_ = g_ptr_array_index (_tmp12_, i);
				_tmp14_ = self->priv->original_elements;
				_tmp14__length1 = self->priv->original_elements_length1;
				_tmp15_ = _tmp14_[j];
				if (contacts_bin_chunk_child_compare ((ContactsBinChunkChild*) _tmp13_, _tmp15_) != 0) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

guint
contacts_bin_chunk_get_n_items (ContactsBinChunk* self)
{
	guint result;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->elements;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

GType
contacts_bin_chunk_get_item_type (ContactsBinChunk* self)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = CONTACTS_TYPE_BIN_CHUNK_CHILD;
	return result;
}

static void
contacts_bin_chunk_class_init (ContactsBinChunkClass * klass,
                               gpointer klass_data)
{
	contacts_bin_chunk_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsBinChunk_private_offset);
	((ContactsBinChunkClass *) klass)->create_empty_child = (ContactsBinChunkChild* (*) (ContactsBinChunk*)) contacts_bin_chunk_real_create_empty_child;
	((ContactsChunkClass *) klass)->to_value = (GValue* (*) (ContactsChunk*)) contacts_bin_chunk_real_to_value;
	((ContactsChunkClass *) klass)->to_gvariant = (GVariant* (*) (ContactsChunk*)) contacts_bin_chunk_real_to_gvariant;
	((ContactsChunkClass *) klass)->apply_gvariant = (void (*) (ContactsChunk*, GVariant*, gboolean)) contacts_bin_chunk_real_apply_gvariant;
	CONTACTS_CHUNK_CLASS (klass)->get_is_empty = (gboolean (*) (ContactsChunk*)) contacts_bin_chunk_real_get_is_empty;
	CONTACTS_CHUNK_CLASS (klass)->get_dirty = (gboolean (*) (ContactsChunk*)) contacts_bin_chunk_real_get_dirty;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_bin_chunk_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_bin_chunk_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_IS_EMPTY_PROPERTY, contacts_bin_chunk_properties[CONTACTS_BIN_CHUNK_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_DIRTY_PROPERTY, contacts_bin_chunk_properties[CONTACTS_BIN_CHUNK_DIRTY_PROPERTY] = g_param_spec_boolean ("dirty", "dirty", "dirty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_N_ITEMS_PROPERTY, contacts_bin_chunk_properties[CONTACTS_BIN_CHUNK_N_ITEMS_PROPERTY] = g_param_spec_uint ("n-items", "n-items", "n-items", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_ITEM_TYPE_PROPERTY, contacts_bin_chunk_properties[CONTACTS_BIN_CHUNK_ITEM_TYPE_PROPERTY] = g_param_spec_gtype ("item-type", "item-type", "item-type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_bin_chunk_g_list_model_interface_init (GListModelInterface * iface,
                                                gpointer iface_data)
{
	contacts_bin_chunk_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item = (GObject* (*) (GListModel*, guint)) contacts_bin_chunk_real_get_item;
	iface->get_n_items = (guint (*) (GListModel*)) contacts_bin_chunk_real_get_n_items;
	iface->get_item_type = (GType (*) (GListModel*)) contacts_bin_chunk_real_get_item_type;
}

static void
contacts_bin_chunk_instance_init (ContactsBinChunk * self,
                                  gpointer klass)
{
	GPtrArray* _tmp0_;
	self->priv = contacts_bin_chunk_get_instance_private (self);
	self->priv->original_elements_set = FALSE;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->elements = _tmp0_;
}

static void
contacts_bin_chunk_finalize (GObject * obj)
{
	ContactsBinChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIN_CHUNK, ContactsBinChunk);
	self->priv->original_elements = (_vala_array_free (self->priv->original_elements, self->priv->original_elements_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_ptr_array_unref0 (self->priv->elements);
	G_OBJECT_CLASS (contacts_bin_chunk_parent_class)->finalize (obj);
}

/**
 * A {@link Chunk} that aggregates multiple values associated to a property
 * (for example, a chunk for phone numbers, or email addresses). These values
 * are represented as {@link BinChunkChild}ren, which BinChunk exposes through
 * the {@link GLib.ListModel} interface.
 *
 * One important property of BinkChunk is that it makes sure at least one empty
 * child exists. This allows us to expose an immutable interface, while being
 * able to synchronize with our UI (which expects this kind of behavior)
 */
 G_GNUC_NO_INLINE static GType
contacts_bin_chunk_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsBinChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_bin_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsBinChunk), 0, (GInstanceInitFunc) contacts_bin_chunk_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) contacts_bin_chunk_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType contacts_bin_chunk_type_id;
	contacts_bin_chunk_type_id = g_type_register_static (CONTACTS_TYPE_CHUNK, "ContactsBinChunk", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (contacts_bin_chunk_type_id, g_list_model_get_type (), &g_list_model_info);
	ContactsBinChunk_private_offset = g_type_add_instance_private (contacts_bin_chunk_type_id, sizeof (ContactsBinChunkPrivate));
	return contacts_bin_chunk_type_id;
}

GType
contacts_bin_chunk_get_type (void)
{
	static volatile gsize contacts_bin_chunk_type_id__once = 0;
	if (g_once_init_enter (&contacts_bin_chunk_type_id__once)) {
		GType contacts_bin_chunk_type_id;
		contacts_bin_chunk_type_id = contacts_bin_chunk_get_type_once ();
		g_once_init_leave (&contacts_bin_chunk_type_id__once, contacts_bin_chunk_type_id);
	}
	return contacts_bin_chunk_type_id__once;
}

static void
_vala_contacts_bin_chunk_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	ContactsBinChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIN_CHUNK, ContactsBinChunk);
	switch (property_id) {
		case CONTACTS_BIN_CHUNK_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, contacts_chunk_get_is_empty ((ContactsChunk*) self));
		break;
		case CONTACTS_BIN_CHUNK_DIRTY_PROPERTY:
		g_value_set_boolean (value, contacts_chunk_get_dirty ((ContactsChunk*) self));
		break;
		case CONTACTS_BIN_CHUNK_N_ITEMS_PROPERTY:
		g_value_set_uint (value, contacts_bin_chunk_get_n_items (self));
		break;
		case CONTACTS_BIN_CHUNK_ITEM_TYPE_PROPERTY:
		g_value_set_gtype (value, contacts_bin_chunk_get_item_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_bin_chunk_child_get_instance_private (ContactsBinChunkChild* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsBinChunkChild_private_offset);
}

/**
   * Creates an AbstractFieldDetails from the contents of this child
   *
   * If the contents are invalid (or empty), it returns null.
   */
static FolksAbstractFieldDetails*
contacts_bin_chunk_child_real_create_afd (ContactsBinChunkChild* self)
{
	g_critical ("Type `%s' does not implement abstract method `contacts_bin_chunk_child_create_afd'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

FolksAbstractFieldDetails*
contacts_bin_chunk_child_create_afd (ContactsBinChunkChild* self)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->create_afd) {
		return _klass_->create_afd (self);
	}
	return NULL;
}

/**
   * Creates a deep copy of this child
   */
static ContactsBinChunkChild*
contacts_bin_chunk_child_real_copy (ContactsBinChunkChild* self)
{
	g_critical ("Type `%s' does not implement abstract method `contacts_bin_chunk_child_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

ContactsBinChunkChild*
contacts_bin_chunk_child_copy (ContactsBinChunkChild* self)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->copy) {
		return _klass_->copy (self);
	}
	return NULL;
}

void
contacts_bin_chunk_child_copy_parameters (ContactsBinChunkChild* self,
                                          ContactsBinChunkChild* copy)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMapIterator* iter = NULL;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeMapIterator* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (copy != NULL);
	_tmp0_ = contacts_bin_chunk_child_get_parameters (copy);
	_tmp1_ = _tmp0_;
	gee_multi_map_clear (_tmp1_);
	_tmp2_ = contacts_bin_chunk_child_get_parameters (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_multi_map_map_iterator (_tmp3_);
	iter = _tmp4_;
	while (TRUE) {
		GeeMapIterator* _tmp5_;
		GeeMultiMap* _tmp6_;
		GeeMultiMap* _tmp7_;
		GeeMapIterator* _tmp8_;
		gpointer _tmp9_;
		gchar* _tmp10_;
		GeeMapIterator* _tmp11_;
		gpointer _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = iter;
		if (!gee_map_iterator_next (_tmp5_)) {
			break;
		}
		_tmp6_ = contacts_bin_chunk_child_get_parameters (copy);
		_tmp7_ = _tmp6_;
		_tmp8_ = iter;
		_tmp9_ = gee_map_iterator_get_key (_tmp8_);
		_tmp10_ = (gchar*) _tmp9_;
		_tmp11_ = iter;
		_tmp12_ = gee_map_iterator_get_value (_tmp11_);
		_tmp13_ = (gchar*) _tmp12_;
		gee_multi_map_set (_tmp7_, _tmp10_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
	}
	_g_object_unref0 (iter);
}

/** See Contacts.Chunk.to_gvariant() */
GVariant*
contacts_bin_chunk_child_to_gvariant (ContactsBinChunkChild* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GVariant* _tmp2_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_bin_chunk_child_get_is_empty (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = contacts_bin_chunk_child_to_gvariant_internal (self);
	result = _tmp2_;
	return result;
}

static GVariant*
contacts_bin_chunk_child_real_to_gvariant_internal (ContactsBinChunkChild* self)
{
	g_critical ("Type `%s' does not implement abstract method `contacts_bin_chunk_child_to_gvariant_internal'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GVariant*
contacts_bin_chunk_child_to_gvariant_internal (ContactsBinChunkChild* self)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->to_gvariant_internal) {
		return _klass_->to_gvariant_internal (self);
	}
	return NULL;
}

GVariant*
contacts_bin_chunk_child_parameters_to_gvariant (ContactsBinChunkChild* self)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp5_;
	GVariantBuilder* _tmp6_;
	GeeMapIterator* iter = NULL;
	GeeMultiMap* _tmp7_;
	GeeMultiMap* _tmp8_;
	GeeMapIterator* _tmp9_;
	GVariantBuilder* _tmp18_;
	GVariant* _tmp19_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_bin_chunk_child_get_parameters (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_multi_map_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		GVariant* _tmp4_;
		_tmp4_ = g_variant_new ("a(ss)", NULL, NULL);
		g_variant_ref_sink (_tmp4_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = G_VARIANT_TYPE_ARRAY;
	_tmp6_ = g_variant_builder_new (_tmp5_);
	builder = _tmp6_;
	_tmp7_ = contacts_bin_chunk_child_get_parameters (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_multi_map_map_iterator (_tmp8_);
	iter = _tmp9_;
	while (TRUE) {
		GeeMapIterator* _tmp10_;
		gchar* param_name = NULL;
		GeeMapIterator* _tmp11_;
		gpointer _tmp12_;
		gchar* param_value = NULL;
		GeeMapIterator* _tmp13_;
		gpointer _tmp14_;
		GVariantBuilder* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp10_ = iter;
		if (!gee_map_iterator_next (_tmp10_)) {
			break;
		}
		_tmp11_ = iter;
		_tmp12_ = gee_map_iterator_get_key (_tmp11_);
		param_name = (gchar*) _tmp12_;
		_tmp13_ = iter;
		_tmp14_ = gee_map_iterator_get_value (_tmp13_);
		param_value = (gchar*) _tmp14_;
		_tmp15_ = builder;
		_tmp16_ = param_name;
		_tmp17_ = param_value;
		g_variant_builder_add (_tmp15_, "(ss)", _tmp16_, _tmp17_, NULL);
		_g_free0 (param_value);
		_g_free0 (param_name);
	}
	_tmp18_ = builder;
	_tmp19_ = g_variant_builder_end (_tmp18_);
	g_variant_ref_sink (_tmp19_);
	result = _tmp19_;
	_g_object_unref0 (iter);
	_g_variant_builder_unref0 (builder);
	return result;
}

static void
contacts_bin_chunk_child_real_apply_gvariant (ContactsBinChunkChild* self,
                                              GVariant* variant)
{
	g_critical ("Type `%s' does not implement abstract method `contacts_bin_chunk_child_apply_gvariant'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
contacts_bin_chunk_child_apply_gvariant (ContactsBinChunkChild* self,
                                         GVariant* variant)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->apply_gvariant) {
		_klass_->apply_gvariant (self, variant);
	}
}

void
contacts_bin_chunk_child_apply_gvariant_parameters (ContactsBinChunkChild* self,
                                                    GVariant* parameters)
{
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp3_;
	GVariantIter* _tmp4_;
	gchar* param_name = NULL;
	gchar* param_value = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = g_variant_get_type (parameters);
	_tmp1_ = g_variant_type_new ("a(ss)");
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (g_variant_type_equal (_tmp0_, _tmp2_), "parameters.get_type ().equal (new VariantType (\"a(ss)\"))");
	_tmp3_ = g_variant_iter_new (parameters);
	_tmp4_ = _tmp3_;
	_g_variant_type_free0 (_tmp2_);
	iter = _tmp4_;
	while (TRUE) {
		GVariantIter* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gboolean _tmp8_;
		const gchar* _tmp9_;
		_tmp5_ = iter;
		_tmp8_ = g_variant_iter_next (_tmp5_, "(ss)", &_tmp6_, &_tmp7_, NULL);
		_g_free0 (param_name);
		param_name = _tmp6_;
		_g_free0 (param_value);
		param_value = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = param_name;
		if (g_strcmp0 (_tmp9_, FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE) == 0) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = param_name;
			_tmp11_ = param_value;
			_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
			_tmp13_ = _tmp12_;
			contacts_bin_chunk_child_add_parameter (self, _tmp10_, _tmp13_);
			_g_free0 (_tmp13_);
		} else {
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp14_ = param_name;
			_tmp15_ = param_value;
			contacts_bin_chunk_child_add_parameter (self, _tmp14_, _tmp15_);
		}
	}
	_g_free0 (param_value);
	_g_free0 (param_name);
	_g_variant_iter_free0 (iter);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
contacts_bin_chunk_child_change_string_prop (ContactsBinChunkChild* self,
                                             const gchar* prop_name,
                                             gchar** old_value,
                                             const gchar* new_value)
{
	gboolean notify_empty = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop_name != NULL);
	g_return_if_fail (*old_value != NULL);
	g_return_if_fail (new_value != NULL);
	if (g_strcmp0 (new_value, *old_value) == 0) {
		return;
	}
	_tmp0_ = string_strip (new_value);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (*old_value);
	_tmp3_ = _tmp2_;
	_tmp4_ = (g_strcmp0 (_tmp1_, "") == 0) != (g_strcmp0 (_tmp3_, "") == 0);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	notify_empty = _tmp4_;
	_tmp5_ = g_strdup (new_value);
	_g_free0 (*old_value);
	*old_value = _tmp5_;
	g_object_notify ((GObject*) self, prop_name);
	if (notify_empty) {
		g_object_notify ((GObject*) self, "is-empty");
	}
}

/**
   * Compares 2 children in such a way that unequal children are sorted in an
   * intuitive manner
   */
gint
contacts_bin_chunk_child_compare (ContactsBinChunkChild* self,
                                  ContactsBinChunkChild* other)
{
	gboolean has_pref = FALSE;
	gboolean empty = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	has_pref = contacts_bin_chunk_child_has_pref_marker (self);
	if (has_pref != contacts_bin_chunk_child_has_pref_marker (other)) {
		gint _tmp0_ = 0;
		if (has_pref) {
			_tmp0_ = -1;
		} else {
			_tmp0_ = 1;
		}
		result = _tmp0_;
		return result;
	}
	_tmp1_ = contacts_bin_chunk_child_get_is_empty (self);
	_tmp2_ = _tmp1_;
	empty = _tmp2_;
	_tmp3_ = contacts_bin_chunk_child_get_is_empty (other);
	_tmp4_ = _tmp3_;
	if (empty != _tmp4_) {
		gint _tmp5_ = 0;
		if (empty) {
			_tmp5_ = 1;
		} else {
			_tmp5_ = -1;
		}
		result = _tmp5_;
		return result;
	}
	result = contacts_bin_chunk_child_compare_internal (self, other);
	return result;
}

/**
   * Returns whether this child is marked as the "preferred" child, similar to
   * the vCard PREF attribute
   */
gboolean
contacts_bin_chunk_child_has_pref_marker (ContactsBinChunkChild* self)
{
	GeeCollection* evolution_pref = NULL;
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = contacts_bin_chunk_child_get_parameters (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_multi_map_get (_tmp1_, "x-evolution-ui-slot");
	evolution_pref = _tmp2_;
	_tmp4_ = evolution_pref;
	if (_tmp4_ != NULL) {
		GeeCollection* _tmp5_;
		_tmp5_ = evolution_pref;
		_tmp3_ = gee_collection_contains (_tmp5_, "1");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_g_object_unref0 (evolution_pref);
		return result;
	}
	{
		GeeIterator* _param_it = NULL;
		GeeMultiMap* _tmp6_;
		GeeMultiMap* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp6_ = contacts_bin_chunk_child_get_parameters (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_multi_map_get (_tmp7_, "type");
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_param_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* param = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			_tmp12_ = _param_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _param_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			param = (gchar*) _tmp14_;
			_tmp15_ = param;
			if (g_ascii_strcasecmp (_tmp15_, "PREF") == 0) {
				result = TRUE;
				_g_free0 (param);
				_g_object_unref0 (_param_it);
				_g_object_unref0 (evolution_pref);
				return result;
			}
			_g_free0 (param);
		}
		_g_object_unref0 (_param_it);
	}
	result = FALSE;
	_g_object_unref0 (evolution_pref);
	return result;
}

/**
   * Should be implemented by subclasses to compare with logic specific to that
   * property. Note that we ideally try to go for a stable sort
   */
static gint
contacts_bin_chunk_child_real_compare_internal (ContactsBinChunkChild* self,
                                                ContactsBinChunkChild* other)
{
	gint _tmp0_ = 0;
	g_critical ("Type `%s' does not implement abstract method `contacts_bin_chunk_child_compare_internal'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gint
contacts_bin_chunk_child_compare_internal (ContactsBinChunkChild* self,
                                           ContactsBinChunkChild* other)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->compare_internal) {
		return _klass_->compare_internal (self, other);
	}
	return -1;
}

gint
contacts_bin_chunk_child_dummy_compare_parameters (ContactsBinChunkChild* self,
                                                   ContactsBinChunkChild* other)
{
	gchar** this_types = NULL;
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gint _tmp4_ = 0;
	gpointer* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint this_types_length1;
	gint _this_types_size_;
	gchar** other_types = NULL;
	GeeMultiMap* _tmp7_;
	GeeMultiMap* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	gint _tmp11_ = 0;
	gpointer* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint other_types_length1;
	gint _other_types_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GeeMultiMap* _tmp26_;
	GeeMultiMap* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GeeMultiMap* _tmp30_;
	GeeMultiMap* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GeeSet* keys = NULL;
	GeeMultiMap* _tmp42_;
	GeeMultiMap* _tmp43_;
	GeeSet* _tmp44_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = contacts_bin_chunk_child_get_parameters (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_multi_map_get (_tmp1_, "type");
	_tmp3_ = _tmp2_;
	_tmp5_ = gee_collection_to_array (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_g_object_unref0 (_tmp3_);
	this_types = _tmp6_;
	this_types_length1 = _tmp6__length1;
	_this_types_size_ = this_types_length1;
	_tmp7_ = contacts_bin_chunk_child_get_parameters (other);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_multi_map_get (_tmp8_, "type");
	_tmp10_ = _tmp9_;
	_tmp12_ = gee_collection_to_array (_tmp10_, &_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp11_;
	_g_object_unref0 (_tmp10_);
	other_types = _tmp13_;
	other_types_length1 = _tmp13__length1;
	_other_types_size_ = other_types_length1;
	_tmp14_ = this_types;
	_tmp14__length1 = this_types_length1;
	_tmp15_ = other_types;
	_tmp15__length1 = other_types_length1;
	if (_tmp14__length1 != _tmp15__length1) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar** _tmp17_;
		gint _tmp17__length1;
		_tmp16_ = other_types;
		_tmp16__length1 = other_types_length1;
		_tmp17_ = this_types;
		_tmp17__length1 = this_types_length1;
		result = _tmp16__length1 - _tmp17__length1;
		other_types = (_vala_array_free (other_types, other_types_length1, (GDestroyNotify) g_free), NULL);
		this_types = (_vala_array_free (this_types, this_types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gchar** _tmp20_;
				gint _tmp20__length1;
				gint type_cmp = 0;
				GCompareFunc _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				gchar** _tmp24_;
				gint _tmp24__length1;
				const gchar* _tmp25_;
				if (!_tmp18_) {
					guint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = this_types;
				_tmp20__length1 = this_types_length1;
				if (!(i < ((guint) _tmp20__length1))) {
					break;
				}
				_tmp21_ = ((GCompareFunc) g_strcmp0);
				_tmp22_ = this_types;
				_tmp22__length1 = this_types_length1;
				_tmp23_ = _tmp22_[i];
				_tmp24_ = other_types;
				_tmp24__length1 = other_types_length1;
				_tmp25_ = _tmp24_[i];
				type_cmp = _tmp21_ (_tmp23_, _tmp25_);
				if (type_cmp != 0) {
					result = type_cmp;
					other_types = (_vala_array_free (other_types, other_types_length1, (GDestroyNotify) g_free), NULL);
					this_types = (_vala_array_free (this_types, this_types_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp26_ = contacts_bin_chunk_child_get_parameters (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = gee_multi_map_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = contacts_bin_chunk_child_get_parameters (other);
	_tmp31_ = _tmp30_;
	_tmp32_ = gee_multi_map_get_size (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp29_ != _tmp33_) {
		GeeMultiMap* _tmp34_;
		GeeMultiMap* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		GeeMultiMap* _tmp38_;
		GeeMultiMap* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		_tmp34_ = contacts_bin_chunk_child_get_parameters (other);
		_tmp35_ = _tmp34_;
		_tmp36_ = gee_multi_map_get_size (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = contacts_bin_chunk_child_get_parameters (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = gee_multi_map_get_size (_tmp39_);
		_tmp41_ = _tmp40_;
		result = _tmp37_ - _tmp41_;
		other_types = (_vala_array_free (other_types, other_types_length1, (GDestroyNotify) g_free), NULL);
		this_types = (_vala_array_free (this_types, this_types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp42_ = contacts_bin_chunk_child_get_parameters (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = gee_multi_map_get_keys (_tmp43_);
	keys = _tmp44_;
	{
		GeeIterator* _key_it = NULL;
		GeeSet* _tmp45_;
		GeeIterator* _tmp46_;
		_tmp45_ = keys;
		_tmp46_ = gee_iterable_iterator ((GeeIterable*) _tmp45_);
		_key_it = _tmp46_;
		while (TRUE) {
			GeeIterator* _tmp47_;
			gchar* key = NULL;
			GeeIterator* _tmp48_;
			gpointer _tmp49_;
			GeeCollection* this_params = NULL;
			GeeMultiMap* _tmp50_;
			GeeMultiMap* _tmp51_;
			const gchar* _tmp52_;
			GeeCollection* _tmp53_;
			GeeCollection* other_params = NULL;
			GeeMultiMap* _tmp54_;
			GeeMultiMap* _tmp55_;
			const gchar* _tmp56_;
			GeeCollection* _tmp57_;
			GeeCollection* _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			GeeCollection* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			_tmp47_ = _key_it;
			if (!gee_iterator_next (_tmp47_)) {
				break;
			}
			_tmp48_ = _key_it;
			_tmp49_ = gee_iterator_get (_tmp48_);
			key = (gchar*) _tmp49_;
			_tmp50_ = contacts_bin_chunk_child_get_parameters (self);
			_tmp51_ = _tmp50_;
			_tmp52_ = key;
			_tmp53_ = gee_multi_map_get (_tmp51_, _tmp52_);
			this_params = _tmp53_;
			_tmp54_ = contacts_bin_chunk_child_get_parameters (other);
			_tmp55_ = _tmp54_;
			_tmp56_ = key;
			_tmp57_ = gee_multi_map_get (_tmp55_, _tmp56_);
			other_params = _tmp57_;
			_tmp58_ = this_params;
			_tmp59_ = gee_collection_get_size (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = other_params;
			_tmp62_ = gee_collection_get_size (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp60_ != _tmp63_) {
				GeeCollection* _tmp64_;
				gint _tmp65_;
				gint _tmp66_;
				GeeCollection* _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				_tmp64_ = other_params;
				_tmp65_ = gee_collection_get_size (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = this_params;
				_tmp68_ = gee_collection_get_size (_tmp67_);
				_tmp69_ = _tmp68_;
				result = _tmp66_ - _tmp69_;
				_g_object_unref0 (other_params);
				_g_object_unref0 (this_params);
				_g_free0 (key);
				_g_object_unref0 (_key_it);
				_g_object_unref0 (keys);
				other_types = (_vala_array_free (other_types, other_types_length1, (GDestroyNotify) g_free), NULL);
				this_types = (_vala_array_free (this_types, this_types_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
			_g_object_unref0 (other_params);
			_g_object_unref0 (this_params);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	result = 0;
	_g_object_unref0 (keys);
	other_types = (_vala_array_free (other_types, other_types_length1, (GDestroyNotify) g_free), NULL);
	this_types = (_vala_array_free (this_types, this_types_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
contacts_bin_chunk_child_add_parameter (ContactsBinChunkChild* self,
                                        const gchar* param_name,
                                        const gchar* param_value)
{
	GeeHashMultiMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param_name != NULL);
	g_return_if_fail (param_value != NULL);
	_tmp0_ = self->priv->_parameters;
	gee_multi_map_set ((GeeMultiMap*) _tmp0_, param_name, param_value);
}

ContactsBinChunkChild*
contacts_bin_chunk_child_construct (GType object_type)
{
	ContactsBinChunkChild * self = NULL;
	self = (ContactsBinChunkChild*) g_object_new (object_type, NULL);
	return self;
}

GeeMultiMap*
contacts_bin_chunk_child_get_parameters (ContactsBinChunkChild* self)
{
	GeeMultiMap* result;
	GeeHashMultiMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parameters;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}

void
contacts_bin_chunk_child_set_parameters (ContactsBinChunkChild* self,
                                         GeeMultiMap* value)
{
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	GeeMapIterator* iter = NULL;
	GeeMapIterator* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_parameters;
	if (value == G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap)) {
		return;
	}
	_tmp1_ = self->priv->_parameters;
	gee_multi_map_clear ((GeeMultiMap*) _tmp1_);
	_tmp2_ = gee_multi_map_map_iterator (value);
	iter = _tmp2_;
	while (TRUE) {
		GeeMapIterator* _tmp3_;
		GeeHashMultiMap* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		gchar* _tmp7_;
		GeeMapIterator* _tmp8_;
		gpointer _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = iter;
		if (!gee_map_iterator_next (_tmp3_)) {
			break;
		}
		_tmp4_ = self->priv->_parameters;
		_tmp5_ = iter;
		_tmp6_ = gee_map_iterator_get_key (_tmp5_);
		_tmp7_ = (gchar*) _tmp6_;
		_tmp8_ = iter;
		_tmp9_ = gee_map_iterator_get_value (_tmp8_);
		_tmp10_ = (gchar*) _tmp9_;
		gee_multi_map_set ((GeeMultiMap*) _tmp4_, _tmp7_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
	}
	_g_object_unref0 (iter);
	g_object_notify_by_pspec ((GObject *) self, contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY]);
}

gboolean
contacts_bin_chunk_child_get_is_empty (ContactsBinChunkChild* self)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->get_is_empty) {
		return _klass_->get_is_empty (self);
	}
	return FALSE;
}

const gchar*
contacts_bin_chunk_child_get_icon_name (ContactsBinChunkChild* self)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->get_icon_name) {
		return _klass_->get_icon_name (self);
	}
	return NULL;
}

static void
contacts_bin_chunk_child_class_init (ContactsBinChunkChildClass * klass,
                                     gpointer klass_data)
{
	contacts_bin_chunk_child_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsBinChunkChild_private_offset);
	((ContactsBinChunkChildClass *) klass)->create_afd = (FolksAbstractFieldDetails* (*) (ContactsBinChunkChild*)) contacts_bin_chunk_child_real_create_afd;
	((ContactsBinChunkChildClass *) klass)->copy = (ContactsBinChunkChild* (*) (ContactsBinChunkChild*)) contacts_bin_chunk_child_real_copy;
	((ContactsBinChunkChildClass *) klass)->to_gvariant_internal = (GVariant* (*) (ContactsBinChunkChild*)) contacts_bin_chunk_child_real_to_gvariant_internal;
	((ContactsBinChunkChildClass *) klass)->apply_gvariant = (void (*) (ContactsBinChunkChild*, GVariant*)) contacts_bin_chunk_child_real_apply_gvariant;
	((ContactsBinChunkChildClass *) klass)->compare_internal = (gint (*) (ContactsBinChunkChild*, ContactsBinChunkChild*)) contacts_bin_chunk_child_real_compare_internal;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_bin_chunk_child_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_bin_chunk_child_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_bin_chunk_child_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY, contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY] = g_param_spec_object ("parameters", "parameters", "parameters", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether this BinChunkChild is empty. You can use the notify signal to
	   * listen for changes.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_CHILD_IS_EMPTY_PROPERTY, contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * The icon name that best represents this BinChunkChild
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_CHILD_ICON_NAME_PROPERTY, contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_bin_chunk_child_instance_init (ContactsBinChunkChild * self,
                                        gpointer klass)
{
	GeeHashMultiMap* _tmp0_;
	self->priv = contacts_bin_chunk_child_get_instance_private (self);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_parameters = _tmp0_;
}

static void
contacts_bin_chunk_child_finalize (GObject * obj)
{
	ContactsBinChunkChild * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIN_CHUNK_CHILD, ContactsBinChunkChild);
	_g_object_unref0 (self->priv->_parameters);
	G_OBJECT_CLASS (contacts_bin_chunk_child_parent_class)->finalize (obj);
}

/**
 * A child of a {@link BinChunk}
 */
 G_GNUC_NO_INLINE static GType
contacts_bin_chunk_child_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsBinChunkChildClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_bin_chunk_child_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsBinChunkChild), 0, (GInstanceInitFunc) contacts_bin_chunk_child_instance_init, NULL };
	GType contacts_bin_chunk_child_type_id;
	contacts_bin_chunk_child_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsBinChunkChild", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ContactsBinChunkChild_private_offset = g_type_add_instance_private (contacts_bin_chunk_child_type_id, sizeof (ContactsBinChunkChildPrivate));
	return contacts_bin_chunk_child_type_id;
}

GType
contacts_bin_chunk_child_get_type (void)
{
	static volatile gsize contacts_bin_chunk_child_type_id__once = 0;
	if (g_once_init_enter (&contacts_bin_chunk_child_type_id__once)) {
		GType contacts_bin_chunk_child_type_id;
		contacts_bin_chunk_child_type_id = contacts_bin_chunk_child_get_type_once ();
		g_once_init_leave (&contacts_bin_chunk_child_type_id__once, contacts_bin_chunk_child_type_id);
	}
	return contacts_bin_chunk_child_type_id__once;
}

static void
_vala_contacts_bin_chunk_child_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ContactsBinChunkChild * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIN_CHUNK_CHILD, ContactsBinChunkChild);
	switch (property_id) {
		case CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY:
		g_value_set_object (value, contacts_bin_chunk_child_get_parameters (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_bin_chunk_child_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ContactsBinChunkChild * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIN_CHUNK_CHILD, ContactsBinChunkChild);
	switch (property_id) {
		case CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY:
		contacts_bin_chunk_child_set_parameters (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

