/* StatefulTimer.c generated by valac 0.56.17, the Vala compiler
 * generated from StatefulTimer.vala, do not modify */

/* StatefulTimer.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_0_PROPERTY,
	BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_PROPERTY,
	BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_util_stateful_timer_properties[BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_NUM_PROPERTIES];
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _BreakTimerDaemonUtilStatefulTimerPrivate {
	BreakTimerDaemonUtilStatefulTimerState _state;
	GTimer* timer;
	gdouble timer_error;
	gdouble lap_start;
};

static gint BreakTimerDaemonUtilStatefulTimer_private_offset;
static gpointer break_timer_daemon_util_stateful_timer_parent_class = NULL;

static void break_timer_daemon_util_stateful_timer_set_state (BreakTimerDaemonUtilStatefulTimer* self,
                                                       BreakTimerDaemonUtilStatefulTimerState value);
static void break_timer_daemon_util_stateful_timer_finalize (GObject * obj);
static GType break_timer_daemon_util_stateful_timer_get_type_once (void);
static void _vala_break_timer_daemon_util_stateful_timer_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_break_timer_daemon_util_stateful_timer_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
break_timer_daemon_util_stateful_timer_get_instance_private (BreakTimerDaemonUtilStatefulTimer* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonUtilStatefulTimer_private_offset);
}

static GType
break_timer_daemon_util_stateful_timer_state_get_type_once (void)
{
	static const GEnumValue values[] = {{BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_STOPPED, "BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_STOPPED", "stopped"}, {BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_COUNTING, "BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_COUNTING", "counting"}, {0, NULL, NULL}};
	GType break_timer_daemon_util_stateful_timer_state_type_id;
	break_timer_daemon_util_stateful_timer_state_type_id = g_enum_register_static ("BreakTimerDaemonUtilStatefulTimerState", values);
	return break_timer_daemon_util_stateful_timer_state_type_id;
}

GType
break_timer_daemon_util_stateful_timer_state_get_type (void)
{
	static volatile gsize break_timer_daemon_util_stateful_timer_state_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_util_stateful_timer_state_type_id__once)) {
		GType break_timer_daemon_util_stateful_timer_state_type_id;
		break_timer_daemon_util_stateful_timer_state_type_id = break_timer_daemon_util_stateful_timer_state_get_type_once ();
		g_once_init_leave (&break_timer_daemon_util_stateful_timer_state_type_id__once, break_timer_daemon_util_stateful_timer_state_type_id);
	}
	return break_timer_daemon_util_stateful_timer_state_type_id__once;
}

BreakTimerDaemonUtilStatefulTimer*
break_timer_daemon_util_stateful_timer_construct (GType object_type)
{
	BreakTimerDaemonUtilStatefulTimer * self = NULL;
	GTimer* _tmp0_;
	self = (BreakTimerDaemonUtilStatefulTimer*) g_object_new (object_type, NULL);
	_tmp0_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp0_;
	break_timer_daemon_util_stateful_timer_set_state (self, BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_COUNTING);
	return self;
}

BreakTimerDaemonUtilStatefulTimer*
break_timer_daemon_util_stateful_timer_new (void)
{
	return break_timer_daemon_util_stateful_timer_construct (BREAK_TIMER_DAEMON_UTIL_TYPE_STATEFUL_TIMER);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

gchar*
break_timer_daemon_util_stateful_timer_serialize (BreakTimerDaemonUtilStatefulTimer* self)
{
	BreakTimerDaemonUtilStatefulTimerState _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state;
	_tmp1_ = g_strdup_printf ("%i", (gint) _tmp0_);
	_tmp2_ = double_to_string (break_timer_daemon_util_stateful_timer_elapsed (self));
	_tmp3_ = double_to_string (self->priv->lap_start);
	_tmp4_ = g_new0 (gchar*, 3 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp2_;
	_tmp4_[2] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 3;
	_tmp6_ = _vala_g_strjoinv (",", _tmp5_, (gint) 3);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp7_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

void
break_timer_daemon_util_stateful_timer_deserialize (BreakTimerDaemonUtilStatefulTimer* self,
                                                    const gchar* data)
{
	gchar** data_parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint data_parts_length1;
	gint _data_parts_size_;
	BreakTimerDaemonUtilStatefulTimerState old_state = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gdouble old_elapsed = 0.0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gdouble old_lap_start = 0.0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (data, ",", 0);
	data_parts = _tmp1_;
	data_parts_length1 = _vala_array_length (_tmp0_);
	_data_parts_size_ = data_parts_length1;
	_tmp2_ = data_parts;
	_tmp2__length1 = data_parts_length1;
	_tmp3_ = _tmp2_[0];
	old_state = (BreakTimerDaemonUtilStatefulTimerState) atoi (_tmp3_);
	_tmp4_ = data_parts;
	_tmp4__length1 = data_parts_length1;
	_tmp5_ = _tmp4_[1];
	old_elapsed = double_parse (_tmp5_);
	_tmp6_ = data_parts;
	_tmp6__length1 = data_parts_length1;
	_tmp7_ = _tmp6_[2];
	old_lap_start = double_parse (_tmp7_);
	if (old_state == BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_STOPPED) {
		break_timer_daemon_util_stateful_timer_stop (self);
	} else {
		if (old_state == BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_COUNTING) {
			break_timer_daemon_util_stateful_timer_start (self);
		}
	}
	self->priv->timer_error = break_timer_daemon_util_stateful_timer_elapsed (self) - old_elapsed;
	self->priv->lap_start = old_lap_start;
	data_parts = (_vala_array_free (data_parts, data_parts_length1, (GDestroyNotify) g_free), NULL);
}

inline gboolean
break_timer_daemon_util_stateful_timer_is_stopped (BreakTimerDaemonUtilStatefulTimer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = !break_timer_daemon_util_stateful_timer_is_counting (self);
	return result;
}

gboolean
break_timer_daemon_util_stateful_timer_is_counting (BreakTimerDaemonUtilStatefulTimer* self)
{
	BreakTimerDaemonUtilStatefulTimerState _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	result = _tmp0_ == BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_COUNTING;
	return result;
}

void
break_timer_daemon_util_stateful_timer_start (BreakTimerDaemonUtilStatefulTimer* self)
{
	GTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	g_timer_start (_tmp0_);
	break_timer_daemon_util_stateful_timer_set_state (self, BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_COUNTING);
	self->priv->timer_error = (gdouble) 0;
	self->priv->lap_start = (gdouble) 0;
}

void
break_timer_daemon_util_stateful_timer_stop (BreakTimerDaemonUtilStatefulTimer* self)
{
	GTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	g_timer_stop (_tmp0_);
	break_timer_daemon_util_stateful_timer_set_state (self, BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_STOPPED);
}

void
break_timer_daemon_util_stateful_timer_continue (BreakTimerDaemonUtilStatefulTimer* self)
{
	GTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	g_timer_continue (_tmp0_);
	break_timer_daemon_util_stateful_timer_set_state (self, BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_COUNTING);
}

gdouble
break_timer_daemon_util_stateful_timer_elapsed (BreakTimerDaemonUtilStatefulTimer* self)
{
	GTimer* _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->timer;
	result = g_timer_elapsed (_tmp0_, NULL) - self->priv->timer_error;
	return result;
}

void
break_timer_daemon_util_stateful_timer_reset (BreakTimerDaemonUtilStatefulTimer* self)
{
	g_return_if_fail (self != NULL);
	break_timer_daemon_util_stateful_timer_start (self);
}

/**
     * Starts counting a new lap, and continues the timer if it is not
     * already counting.
     */
void
break_timer_daemon_util_stateful_timer_start_lap (BreakTimerDaemonUtilStatefulTimer* self)
{
	g_return_if_fail (self != NULL);
	if (break_timer_daemon_util_stateful_timer_is_stopped (self)) {
		break_timer_daemon_util_stateful_timer_continue (self);
	}
	self->priv->lap_start = break_timer_daemon_util_stateful_timer_elapsed (self);
}

/**
     * Returns the time since the last lap was created, or the elapsed time if
     * no laps have been created.
     * @see start_lap
     */
gdouble
break_timer_daemon_util_stateful_timer_lap_time (BreakTimerDaemonUtilStatefulTimer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = break_timer_daemon_util_stateful_timer_elapsed (self) - self->priv->lap_start;
	return result;
}

/**
     * Stops the timer, but does not advance the end time if if is already
     * stopped.
     */
void
break_timer_daemon_util_stateful_timer_freeze (BreakTimerDaemonUtilStatefulTimer* self)
{
	BreakTimerDaemonUtilStatefulTimerState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ > BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_STOPPED) {
		break_timer_daemon_util_stateful_timer_stop (self);
	}
}

BreakTimerDaemonUtilStatefulTimerState
break_timer_daemon_util_stateful_timer_get_state (BreakTimerDaemonUtilStatefulTimer* self)
{
	BreakTimerDaemonUtilStatefulTimerState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
break_timer_daemon_util_stateful_timer_set_state (BreakTimerDaemonUtilStatefulTimer* self,
                                                  BreakTimerDaemonUtilStatefulTimerState value)
{
	BreakTimerDaemonUtilStatefulTimerState old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_daemon_util_stateful_timer_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_daemon_util_stateful_timer_properties[BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_PROPERTY]);
	}
}

static void
break_timer_daemon_util_stateful_timer_class_init (BreakTimerDaemonUtilStatefulTimerClass * klass,
                                                   gpointer klass_data)
{
	break_timer_daemon_util_stateful_timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonUtilStatefulTimer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_daemon_util_stateful_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_break_timer_daemon_util_stateful_timer_set_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_util_stateful_timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_PROPERTY, break_timer_daemon_util_stateful_timer_properties[BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
break_timer_daemon_util_stateful_timer_instance_init (BreakTimerDaemonUtilStatefulTimer * self,
                                                      gpointer klass)
{
	self->priv = break_timer_daemon_util_stateful_timer_get_instance_private (self);
}

static void
break_timer_daemon_util_stateful_timer_finalize (GObject * obj)
{
	BreakTimerDaemonUtilStatefulTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_UTIL_TYPE_STATEFUL_TIMER, BreakTimerDaemonUtilStatefulTimer);
	_g_timer_destroy0 (self->priv->timer);
	G_OBJECT_CLASS (break_timer_daemon_util_stateful_timer_parent_class)->finalize (obj);
}

/**
 * A simple GTimer lookalike that keeps track of its own state.
 * This is implemented using the GTimer API, internally, so it behaves
 * exactly as described in the GTimer documentation, with two additions:
 *  - a state property to keep track of whether the timer is stopped.
 *  - a "lap" feature (start_lap, lap_time) to measure smaller time intervals
 */
static GType
break_timer_daemon_util_stateful_timer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonUtilStatefulTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_util_stateful_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonUtilStatefulTimer), 0, (GInstanceInitFunc) break_timer_daemon_util_stateful_timer_instance_init, NULL };
	GType break_timer_daemon_util_stateful_timer_type_id;
	break_timer_daemon_util_stateful_timer_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerDaemonUtilStatefulTimer", &g_define_type_info, 0);
	BreakTimerDaemonUtilStatefulTimer_private_offset = g_type_add_instance_private (break_timer_daemon_util_stateful_timer_type_id, sizeof (BreakTimerDaemonUtilStatefulTimerPrivate));
	return break_timer_daemon_util_stateful_timer_type_id;
}

GType
break_timer_daemon_util_stateful_timer_get_type (void)
{
	static volatile gsize break_timer_daemon_util_stateful_timer_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_util_stateful_timer_type_id__once)) {
		GType break_timer_daemon_util_stateful_timer_type_id;
		break_timer_daemon_util_stateful_timer_type_id = break_timer_daemon_util_stateful_timer_get_type_once ();
		g_once_init_leave (&break_timer_daemon_util_stateful_timer_type_id__once, break_timer_daemon_util_stateful_timer_type_id);
	}
	return break_timer_daemon_util_stateful_timer_type_id__once;
}

static void
_vala_break_timer_daemon_util_stateful_timer_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	BreakTimerDaemonUtilStatefulTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_UTIL_TYPE_STATEFUL_TIMER, BreakTimerDaemonUtilStatefulTimer);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_PROPERTY:
		g_value_set_enum (value, break_timer_daemon_util_stateful_timer_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_break_timer_daemon_util_stateful_timer_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	BreakTimerDaemonUtilStatefulTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_UTIL_TYPE_STATEFUL_TIMER, BreakTimerDaemonUtilStatefulTimer);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_UTIL_STATEFUL_TIMER_STATE_PROPERTY:
		break_timer_daemon_util_stateful_timer_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

